function isBasicJavascriptLoaded() {
	
	return true;
	
}

//******************//
//****Data model****//
//******************//
function getDefaultTableConfig() {
	var tableConfig = new Object();
	tableConfig.visible = true;
	
	tableConfig.multiQuery = false;
	
	tableConfig.deletedUsage = false;
	tableConfig.paginationUsage = false;
	tableConfig.paginationEntries = '';
	
	tableConfig.expandGroupedTotals = false;
	
	tableConfig.titles = new Object();
	tableConfig.titles.visible = true;
	
	tableConfig.headers = new Object();
	tableConfig.headers.visible = true;
	
	tableConfig.subtotals = new Object();
	tableConfig.subtotals.visible = true;
	
	tableConfig.totals = new Object();
	tableConfig.totals.visible = true;
	
	tableConfig.pagination = new Object();
	tableConfig.pagination.visible = 'all';
	
	return tableConfig;
}

function getDefaultFiltersConfig() {
	var jsonFilter = new Object();
	jsonFilter.initialExecution = false;
	return jsonFilter;
}

function getDefaultChart() {
	var jsonChart = new Object();
	jsonChart.data = getDefaultChartData();
	jsonChart.config = getDefaultChartConfig();
	return jsonChart;
}

function getDefaultChartData() {
	var jsonChart = new Object();
	jsonChart.xIndex = "";
	jsonChart.xAxis = "";
	jsonChart.halfChart = "no";
	jsonChart.field = "";
	jsonChart.label = "";
	jsonChart.chartReference = "";
	jsonChart.function = "";
	jsonChart.display = "yes";
	jsonChart.type = "";
	jsonChart.index = "";
	jsonChart.related = "";
	jsonChart.yAxisSide = "left";
	return jsonChart;
}

function getDefaultChartConfig() {
	var jsonChart = new Object();
	return jsonChart;
}
//******************//
//****Data model****//
//******************//

function saveReport() {
	
	var detailCount = 0,
		filledFields = true;
	
	$.each($('.layout_group'), function()
	{
		if( in_array(this.value, ['Detail', 'Minute Detail', 'Quarter Hour Detail', 'Hour Detail', 'Day Detail', 'DoW Detail', 'WoY Detail', 'Month Detail', 'Natural Quarter Detail', 'Fiscal Quarter Detail', 'Natural Year Detail', 'Fiscal Year Detail']) )
		{
			detailCount++;
		}
	});
	
	$(".asolReportsChartsGroup").each(function(i) 
	{
		$(this).find(".asolReportsChartRow").each(function(j) 
		{
			if( ($(this).find('.chart_display').val() === 'yes') )
			{
				if( $(this).hasClass('asolReportsMainChart') && ($(this).find('.chart_xaxis').val() === null || $(this).find('.chart_yaxis').val() === "" ))
					filledFields = false;
				else if( $(this).find('.chart_yaxis').val() === "" )
					filledFields = false;
			}
		});
	});
	
	if (typeof window.isBasicJavascriptLoaded == 'function' && detailCount <= 1 && filledFields) {
		
		var isMetaReport = ($("#create_form").find("[name=is_meta]").val() === '1');
		
		$("#create_form").find("[name=return_action]").val("index"); 
		$("#create_form").find("[name=action]").val("save"); 
		
		$("#create_form").find("[name=selected_fields]").val(formatFields(true));
			
		if ((typeof window.hasPremiumJsFeatures == 'function') && (isMetaReport)) {
		
			$("#create_form").find("[name=metaHtml]").val(escape(CKEDITOR.instances.meta_html.getData()));
			
		} else {
			
			$("#create_form").find("[name=selected_filters]").val(formatFilters(true, false));
			$("#create_form").find("[name=selected_charts]").val(formatCharts());
			$("#create_form").find("[name=row_index_display]").val($("#rowIndexDisplay").val());
			$("#create_form").find("[name=results_limit]").val(formatResultsLimit());
			
		}
		
		$("#create_form").find("[name=selected_tasks]").val(formatTasks());
		$("#create_form").find("[name=email_list]").val(format_email_list());
		
		return checkCreationForm(isMetaReport);
		
	} else {
		
		if( detailCount > 1 )
			alert(SUGAR.language.get('asol_Reports', 'LBL_REPORT_TWO_OR_MORE_DETAIL'));
		else if( !filledFields )
			alert(SUGAR.language.get('asol_Reports', 'LBL_REPORT_GRAPH_FIELDS_ALERT'));
		
		return false;
		
	}
	
}

function cancelReport() {
	
	if (typeof window.isBasicJavascriptLoaded == 'function') { 
		
		$("#create_form").find("[name=action]").val("index");
		$("#create_form").find("[name=module]").val("asol_Reports");
		$("#create_form").find("[name=assigned_user_id]").val("");
		$("#create_form").find("[name=assigned_user_name]").val("");
				
		return true;
				
	} else {
		
		return false;
		
	}
	
}

function RememberFields(idTable, fieldsJson, auditedReport) {

	var fieldIndex = 0;

	var disabledAuditInputsRow = "";
	var hiddenAuditButtonsRow = "";
    
    var table = document.getElementById(idTable);
    

    if (fieldsJson !== "") {

    	var lastFieldIndex = 0;
    
    	row_Values = window.JSON.parse(fieldsJson);

    	populateTableConfig(row_Values.tables[0]['config']);

    	var fieldValuesJson = row_Values.tables[0].data;

		for (var key = 0; key < fieldValuesJson.length; key++) {
    	
			var fieldData = fieldValuesJson[key];
			
			if ((key == 0) && (auditedReport == '1')) {
				disabledAuditInputsRow = "disabled";
				hiddenAuditButtonsRow = "style='display:none'";
			} else {
				disabledAuditInputsRow = "";
				hiddenAuditButtonsRow = "";        			
			}

			var splittedIndex = fieldData.index.split("_");
			var counterField = (splittedIndex.length == 2) ? splittedIndex[1] : count_function_fields(fieldData.key, fieldData.value) + 1;

			var row = document.createElement("tr");
			row.setAttribute("class", "oddListRowS1 asolReportsFieldRow");
			row.setAttribute("onmouseout", "highlightAssociatedRows(this, 'field', false);");
			row.setAttribute("onmouseover", "highlightAssociatedRows(this, 'field', true);");			
			
			var keyTitle = getKeyUsageValue(fieldData.key);

			
			//*****************//
	        //***MultiRemove***//
	        //*****************//
			var cell_MultiRemove = document.createElement("td");
			
			cell_MultiRemove.className = "center";

			cell_MultiRemove.innerHTML = getCellMultiRemoveHtml();
			
			row.appendChild(cell_MultiRemove);
			
			
			//***********//
	        //***Alias***//
	        //***********//
			var cell_Alias = document.createElement("td");
			
			cell_Alias.innerHTML = getCellFieldHtml(fieldIndex, fieldData.field, fieldData.isRelated, keyTitle) + "&nbsp;";
			cell_Alias.innerHTML += getCellAliasHtml(fieldIndex, fieldData.alias, disabledAuditInputsRow) + "&nbsp;";

			if (typeof window.hasPremiumJsFeatures == 'function') {
				cell_Alias.innerHTML += getMultiLanguageField((typeof(fieldData.language)=="undefined" ? '' : window.JSON.stringify(fieldData.language)), fieldIndex);
			}
			
			cell_Alias.innerHTML += getCellSortDirHtml(fieldIndex, fieldData.sortDirection) + "&nbsp;";
			cell_Alias.innerHTML += getCellSortSequenceHtml(fieldIndex, fieldData.sortOrder);
			
			row.appendChild(cell_Alias);
			
			
			//***************//
	        //***Reference***//
	        //***************//
			var cell_Reference = document.createElement("td");
			
			cell_Reference.innerHTML += getCellFieldReferenceHtml(fieldIndex, (typeof(fieldData.fieldReference)=="undefined" ? '' : fieldData.fieldReference), disabledAuditInputsRow);
			
			row.appendChild(cell_Reference);
			
			
			//*************//
			//***Display***//
			//*************//
			var cell_Display = document.createElement("td");
			
			cell_Display.innerHTML = getCellDisplayHtml(fieldIndex, fieldData.visible.toLowerCase(), disabledAuditInputsRow);
			
			row.appendChild(cell_Display);
			
			
			//**************//
			//***Function***//
			//**************//
			var cell_Function = document.createElement("td");
			
			if (fieldData.type != null) {
				fieldData.type = fixUpFilterType(fieldData.type);
			}
			
			switch (fieldData.type) {

				case "int":
				case "tinyint":
				case "smallint":
				case "mediumint":
				case "bigint":
				case "float":
				case "decimal":
				case "double":
				case "real":
				case "currency":
				case "enum":
				case "radioenum":
					
					cell_Function.innerHTML = getCellFunctionHtml_forEnums(fieldIndex, fieldData.function, disabledAuditInputsRow);
					break;
					
				case "multienum":
					
					cell_Function.innerHTML = getCellFunctionHtml_forMultiEnums(fieldIndex, fieldData.function, disabledAuditInputsRow);
					break;
					
					
				case "date":		
				case "datetime":
				case "datetimecombo":
				case "timestamp":
					
					cell_Function.innerHTML = getCellFunctionHtml_forDates(fieldIndex, fieldData.function, disabledAuditInputsRow);
					break;

				case "bool":
				case "tinyint(1)":
					
					cell_Function.innerHTML = getCellFunctionHtml_forBool(fieldIndex, fieldData.function, disabledAuditInputsRow);
					break;

				default:
					
					cell_Function.innerHTML = getCellFunctionHtml_forDefault(fieldIndex, fieldData.function, auditedReport, disabledAuditInputsRow);
					break;

			}

			cell_Function.innerHTML += getCellFunctionsConfigureSQL((typeof(fieldData.templates)=="undefined" ? new Array() : fieldData.templates), fieldData.field, fieldIndex, fieldData.sql, (typeof(fieldData.subQuery)=="undefined" ? new Object() : fieldData.subQuery));

			
			//***AlineaSol Premium***//
			if (typeof window.hasPremiumJsFeatures == 'function') {
				cell_Function.innerHTML += getCellFunctionsConfigurePHP((typeof(fieldData.templates)=="undefined" ? new Array() : fieldData.templates), fieldData.field, fieldIndex, fieldData.php);
			}
			//***AlineaSol Premium***//
			
			row.appendChild(cell_Function);
			
			
			//*****************//
			//***Format Type***//
			//*****************//
			var cell_Format_Type = document.createElement("td");
			
			cell_Format_Type.className = "formatTypeCell";
			cell_Format_Type.innerHTML = getCellFormatTypeHtml(fieldIndex, (typeof(fieldData.format)=="undefined" ? '' : fieldData.format), (typeof(fieldData.templates)=="undefined" ? new Array() : fieldData.templates), fieldData.field, fieldData.type, disabledAuditInputsRow);
			
			row.appendChild(cell_Format_Type);
			
			
			//******************//
			//***Layout Group***//
			//******************//
			var cell_Layout_Group = document.createElement("td");
			
			switch (fieldData.type) {
			
				case "date":
				case "datetime":
				case "datetimecombo":
				case "timestamp":

					cell_Layout_Group.innerHTML = getCellLayoutGroupHtml_forDates(fieldIndex, fieldData.type, fieldData.grouping, disabledAuditInputsRow);
					break;

				default:
				
					cell_Layout_Group.innerHTML = getCellLayoutGroupHtml_forDefault(fieldIndex, fieldData.grouping, disabledAuditInputsRow);
					break;

			}
			
			cell_Layout_Group.innerHTML += getCellGroupBySequenceHtml(fieldIndex, fieldData.groupingOrder);

			row.appendChild(cell_Layout_Group);
			

			//*************//
			//***Buttons***//
			//*************//
			var cell_Buttons = document.createElement("td");
			cell_Buttons.align = "right";

			cell_Buttons.innerHTML = getCellFieldButtonsHtml(fieldIndex, fieldData.type, fieldData.isRelated, fieldData.key, fieldData.index, fieldData.enumOperator, fieldData.enumReference, fieldData.field, counterField, auditedReport, hiddenAuditButtonsRow);

			//***AlineaSol Premium***//
			if (typeof window.hasPremiumJsFeatures == 'function') {
				cell_Buttons.innerHTML += getTemplateInputHtml(fieldIndex, (typeof(fieldData.templates)=="undefined" ? new Object() : fieldData.templates));
			}
			//***AlineaSol Premium***//
			
			var numberOfRows = $(".asolReportsFieldRow").size()+1;
			cell_Buttons.innerHTML += getCellFieldArrowsHtml(fieldIndex, idTable, numberOfRows, auditedReport, hiddenAuditButtonsRow);

			row.appendChild(cell_Buttons);
			
			
			
			if (in_array(fieldData.visible.toLowerCase(), ['no', 'html'])) {
				row.className += ' hiddenRow';
			}

			table.getElementsByTagName('tbody')[0].appendChild(row);
			
			lastFieldIndex = fieldIndex;
			fieldIndex++;

        }
        
        $('#fieldsGlobalIndex').val(lastFieldIndex + 1);

    }

}


function RememberFilters(idTable, filtersJson, auditedReport) {

	if ((filtersJson === null) || (filtersJson.length == 0)) {
		return;
	}
	
	var filterIndex = 0;
	
	var disabledAuditInputsRow = "";
	var hiddenAuditButtonsRow = "";
	
    var param1 = new Array();
    var param2 = new Array();
    var param3 = new Array();
	
	var filtersArray = window.JSON.parse(filtersJson);
	
	populateFiltersConfig(filtersArray);
	
    var table = document.getElementById(idTable);
    var lastFilterIndex = 0;
	
	filtersArray.data.forEach(function(currentFilter, filterIndex) {
		
		if ((filterIndex == 0) && (auditedReport == '1')) {
			disabledAuditInputsRow = "disabled";
			hiddenAuditButtonsRow = "style='display:none'";
		} else {
			disabledAuditInputsRow = "";
			hiddenAuditButtonsRow = "";        			
		}
		
    	var displayOperatorSelect = 'display: inline;';
    	var displayFirstParameter = 'display: inline;';
    	
    	var row = document.createElement("tr");
        row.setAttribute("class", "oddListRowS1 asolReportsFilterRow");
        row.setAttribute("onmouseout", "highlightAssociatedRows(this, 'filter', false);");
		row.setAttribute("onmouseover", "highlightAssociatedRows(this, 'filter', true);");		

        var cell_Button = document.createElement("td");
        cell_Button.align = "right";
        
        //***Override Properties***//
        currentFilter.isWhereFilter = ((typeof(currentFilter.isWhereFilter) == "undefined") || (currentFilter.templates == null) ? true : currentFilter.isWhereFilter);
        currentFilter.templates = ((typeof(currentFilter.templates) == "undefined") || (currentFilter.templates == null) ? new Array() : currentFilter.templates);
        currentFilter.enumValues = ((typeof(currentFilter.enumValues) == "undefined") || (currentFilter.enumValues == null) ? new Array() : currentFilter.enumValues);
        //***Override Properties***//
        
        
        //*****************//
        //***MultiRemove***//
        //*****************//
        var cell_MultiRemove = document.createElement("td");
        cell_MultiRemove.className = "center";
        
        cell_MultiRemove.innerHTML = getCellMultiRemoveHtml();
        
        row.appendChild(cell_MultiRemove);
		
        
        //***********************//
        //***Logical Operators***//
        //***********************//
        var cell_Logical_Operators = document.createElement("td");
        
        cell_Logical_Operators.innerHTML = getCellLogicalParametersHtml(filterIndex, currentFilter.logicalOperators, disabledAuditInputsRow);
        
        row.appendChild(cell_Logical_Operators);
        
        
        //***********//
        //***Alias***//
        //***********//
        var cell_Alias = document.createElement("td");
        
        cell_Alias.innerHTML = getCellFilterFieldHtml(filterIndex, currentFilter.field, currentFilter.isRelated, currentFilter.relationKey) + "&nbsp;";
		cell_Alias.innerHTML += getCellFilterAliasHtml(filterIndex, (typeof(currentFilter.alias)=="undefined") ? '' : currentFilter.alias, disabledAuditInputsRow);
		
		if (typeof window.hasPremiumJsFeatures == 'function') {
			cell_Alias.innerHTML += getMultiLanguageField((typeof(currentFilter.language)=="undefined" ? '' : window.JSON.stringify(currentFilter.language)), filterIndex);
		}
		
		row.appendChild(cell_Alias);
        
		
		//***************//
        //***Reference***//
        //***************//
		var cell_Ref = document.createElement("td");
        
		cell_Ref.innerHTML = getCellFilterReferenceHtml(filterIndex, (typeof(currentFilter.filterReference)=="undefined") ? '' : currentFilter.filterReference, disabledAuditInputsRow);
		
		row.appendChild(cell_Ref);
        
		
		//**************//
        //***Behavior***//
        //**************//
		var cell_Behavior = document.createElement("td");
		
		cell_Behavior.className = "behaviorCell";
		cell_Behavior.innerHTML = getCellBehaviourHtml(filterIndex, currentFilter.behavior, disabledAuditInputsRow);
        
		row.appendChild(cell_Behavior);
        
		
		//**********************//
        //***UserInputOptions***//
        //**********************//
		var cell_UserInputOptions = document.createElement("td");
        
		cell_UserInputOptions.innerHTML = getCellUserInputOptionsHtml(filterIndex, currentFilter.templates, currentFilter.userOptions, currentFilter.field, currentFilter.type, disabledAuditInputsRow);
        
		row.appendChild(cell_UserInputOptions);
        
        
        
		//**************************//
	    //***Operator & Filtering***//
	    //**************************//
		var cell_Operator = document.createElement("td");
        var cell_First_Parameter = document.createElement("td");
        var cell_Second_Parameter = document.createElement("td");
        
		currentFilter.type = fixUpFilterType(currentFilter.type);
		
		//***AlineaSol Premium***//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			if (currentFilter.operator == 'inherit') {
				displayOperatorSelect = 'display: inline;';
				displayFirstParameter = 'display: none;';
			} else if (!in_array(currentFilter.type, ["date", "datetime", "datetimecombo", "timestamp", "bool", "tinyint(1)", "relate"])) {
				if ((currentFilter.userOptions.length > 0) || (currentFilter.templates.hasOwnProperty('enum'))) {
					displayOperatorSelect = 'display: none;';
					displayFirstParameter = 'display: none;';
				} else {
					displayOperatorSelect = 'display: inline;';
					displayFirstParameter = 'display: inline;';
				}
			}
		}
		//***AlineaSol Premium***//
		
		switch (currentFilter.type) {
	
			case "enum":
			case "radioenum":
				
				cell_Operator.innerHTML = getCellOperatorHtml_forEnum(filterIndex, currentFilter.operator, displayOperatorSelect);						
				if (in_array(currentFilter.operator,  ["one of", "not one of"]))
					cell_First_Parameter.innerHTML = getCellFirstParameterHtml_forEnum(filterIndex, currentFilter.parameters.first, currentFilter.enumValues, currentFilter.enumLabels, 'multiple size=3', 'display:none;', displayFirstParameter);
				else if (in_array(currentFilter.operator, ["equals", "not equals"]))
					cell_First_Parameter.innerHTML = getCellFirstParameterHtml_forEnum(filterIndex, currentFilter.parameters.first, currentFilter.enumValues, currentFilter.enumLabels, '', 'display:none;', displayFirstParameter);
				else
					cell_First_Parameter.innerHTML = getCellFirstParameterHtml_forEnum(filterIndex, currentFilter.parameters.first, currentFilter.enumValues, currentFilter.enumLabels, '', displayFirstParameter, 'display:none;');
				
				cell_Second_Parameter.innerHTML = getCellSecondParameterHtml(filterIndex, null);
	
				break;
				
			case "multienum":
				
				cell_Operator.innerHTML = getCellOperatorHtml_forMultiEnum(filterIndex, currentFilter.operator, displayOperatorSelect);						
				cell_First_Parameter.innerHTML = getCellFirstParameterHtml_forEnum(filterIndex, currentFilter.parameters.first, currentFilter.enumValues, currentFilter.enumLabels, 'multiple size=3', 'display:none;', displayFirstParameter);
				cell_Second_Parameter.innerHTML = getCellSecondParameterHtml(filterIndex, null);
	
				break;
				
			case "int":
			case "tinyint":
			case "smallint":
			case "mediumint":
			case "bigint":
			case "decimal":
			case "double":
			case "real":
			case "currency":
	
				cell_Operator.innerHTML = getCellOperatorHtml_forInt(filterIndex, currentFilter.operator, displayOperatorSelect);
				cell_First_Parameter.innerHTML = getCellFirstParameterHtml(filterIndex, currentFilter.parameters.first, displayFirstParameter);
				cell_Second_Parameter.innerHTML = getCellSecondParameterHtml(filterIndex, null);
				break;
	
			case "date":
			case "datetime":
			case "datetimecombo":
			case "timestamp":
				
				cell_Operator.innerHTML = getCellOperatorHtml_forDate(filterIndex, currentFilter.operator, displayOperatorSelect);
	
				var fixed_str = "";
	
				switch (currentFilter.parameters.first[0]) {
	
					case "day":
					case "week":
					case "month":
					case "Nquarter":
					case "Fquarter":
					case "Nyear":
					case "Fyear":
					
						if (in_array(currentFilter.operator, ["last", "not last"]))
			               	fixed_str = getFixedEnumString_forDates(currentFilter.parameters.first);
						else
							fixed_str = getDefaultEnumString_forDates(currentFilter.parameters.first);
					
						break;
	
					case "monday":
					case "tuesday":
					case "wednesday":
					case "thursday":
					case "friday":
					case "saturday":
					case "sunday":
					case "january":
					case "february":
					case "march":
					case "april":
					case "may":
					case "june":
					case "july":
					case "august":
					case "september":
					case "october":
					case "november":
					case "december":
						
						fixed_str = getFixedEnumString_forDates(currentFilter.parameters.first);
		               	break;
	
					case "calendar":
					case "weekofyear":
					case "naturalyear":
					case "fiscalyear":
						
						fixed_str = (in_array(currentFilter.operator, ["equals", "not equals"])) ? getSingleEnumString_forDates(currentFilter.parameters.first) : getReducedSingleEnumString_forDates(currentFilter.parameters.first);
		               	break;
					
					case "dayofweek":
					case "monthofyear":
					case "naturalquarterofyear":
					case "fiscalquarterofyear":
					
						fixed_str = getSingleEnumString_forDates(currentFilter.parameters.first);
		               	break;
		               	
					default:
						
						fixed_str = getDefaultEnumString_forDates(currentFilter.parameters.first);
						break;
	
				}
				
				switch (currentFilter.operator) {
				
					case "equals":
					case "not equals":
					case "before date":
					case "after date":
					case "between":
					case "not between":
					case "last": 
					case "this": 
					case "these": 
					case "next": 
					case "not last": 
					case "not this": 
					case "not next": 
					
						cell_First_Parameter.innerHTML = getCellFirstParameterHtml_forDate_withFixedString(filterIndex, null, fixed_str, 'display:none;', 'display:none;', displayFirstParameter);
						param1.push(filterIndex);
						break;
				
					default: 
					
						cell_First_Parameter.innerHTML = getCellFirstParameterHtml_forDate_withFixedString(filterIndex, currentFilter.parameters.first, fixed_str, displayFirstParameter, displayFirstParameter, 'display:none;');
						param1.push(filterIndex);
						break;
				
				}
				
				switch (currentFilter.operator) {
				
					case "equals":
					case "not equals":
					case "before date":
					case "after date":
						
						switch (currentFilter.parameters.first[0]) {
						
							case "calendar":
							
								cell_Second_Parameter.innerHTML = getCellSecondParameterHtml_forDate(filterIndex, currentFilter.parameters.second, "", "", "display:inline;", "display:inline;", "display:none;", 'display:none;', "readonly") + getCellThirdParameterHtml_forDate(filterIndex, currentFilter.parameters.third, "", "", "display:none;", "display:none;", "display:none;", 'display:none;', "readonly");
								break;
							
							case "dayofweek":
								
								var fixed_param = getDayOfWeekEnumString_forDates(currentFilter.parameters.second);
								cell_Second_Parameter.innerHTML = getCellSecondParameterHtml_forDate(filterIndex, currentFilter.parameters.second, fixed_param, 'multiple size=3', "display:none;", "display:none;", 'display:inline;', "readonly") + getCellThirdParameterHtml_forDate(filterIndex, currentFilter.parameters.third, "", "", "display:none;", "display:none;", "display:none;", 'display:none;', "");
								break;
								
							case "weekofyear":
								
								var fixed_param = getWeekOfYearEnumString_forDates(currentFilter.parameters.second);
								cell_Second_Parameter.innerHTML = getCellSecondParameterHtml_forDate(filterIndex,currentFilter.parameters.second, fixed_param, '', "display:none;", "display:none;", 'display:inline;', "readonly") + getCellThirdParameterHtml_forDate(filterIndex, currentFilter.parameters.third, "", "", "display:none;", "display:none;", "display:none;", 'display:none;', "");
								break;
								
							case "monthofyear":
	
								var fixed_param = getMonthOfYearEnumString_forDates(currentFilter.parameters.second);
								cell_Second_Parameter.innerHTML = getCellSecondParameterHtml_forDate(filterIndex, currentFilter.parameters.second, fixed_param, 'multiple size=3', "display:none;", "display:none;", 'display:inline;', "readonly") + getCellThirdParameterHtml_forDate(filterIndex, currentFilter.parameters.third, "", "", "display:none;", "display:none;", "display:none;", 'display:none;', "");
								break;
								
							case "naturalquarterofyear":
							case "fiscalquarterofyear":
								
								var fixed_param = getQuarterOfYearEnumString_forDates(currentFilter.parameters.second);
								cell_Second_Parameter.innerHTML = getCellSecondParameterHtml_forDate(filterIndex, currentFilter.parameters.second, fixed_param, 'multiple size=3', "display:none;", "display:none;", 'display:inline;', "readonly") + getCellThirdParameterHtml_forDate(filterIndex, currentFilter.parameters.third, "", "", "display:none;", "display:none;", "display:none;", 'display:none;', "");
								break;	
								
							default:
								
								cell_Second_Parameter.innerHTML = getCellSecondParameterHtml_forDate(filterIndex, currentFilter.parameters.second, "", "", "display:inline;", "display:none;", 'display:none;', "") + getCellThirdParameterHtml_forDate(filterIndex, currentFilter.parameters.third, "", "", "display:none;", "display:none;", "display:none;", 'display:none;', "");
								break;
								
						}
						
						param2.push(filterIndex);
						param3.push(filterIndex);
						break;
						
					case "between":
					case "not between":
					
						switch (currentFilter.parameters.first[0]) {
						
							case "calendar":
						
								cell_Second_Parameter.innerHTML = getCellSecondParameterHtml_forDate(filterIndex, currentFilter.parameters.second, "", "", "display:inline;", "display:inline;", 'display:none;', "readonly") + getCellThirdParameterHtml_forDate(filterIndex, currentFilter.parameters.third, "", "", "display:block;", "display:inline;", "display:inline;", 'display:none;', "readonly");
								break;
						
							case "weekofyear":
							
								var fixed_param1 = getWeekOfYearEnumString_forDates(currentFilter.parameters.second);
								var fixed_param2 = getWeekOfYearEnumString_forDates(currentFilter.parameters.third);
								cell_Second_Parameter.innerHTML = getCellSecondParameterHtml_forDate(filterIndex, currentFilter.parameters.second, fixed_param1, '', "display:none;", "display:none;", 'display:inline;', "readonly") + getCellThirdParameterHtml_forDate(filterIndex, currentFilter.parameters.third, fixed_param2, "", "display:block;", "display:none;", "display:none;", 'display:inline;', "");
								break;
							
							default:
								
								cell_Second_Parameter.innerHTML = getCellSecondParameterHtml_forDate(filterIndex, currentFilter.parameters.second, "", "", "display:inline;", "display:none;", 'display:none;', "") + getCellThirdParameterHtml_forDate(filterIndex, currentFilter.parameters.third, "", "", "display:block;", "display:inline;", "display:none;", 'display:none;', "");
								break;
								
						}
						
						param2.push(filterIndex);
						param3.push(filterIndex);
						break;
						
					case "last":
					case "next":
					case "not last":
					case "not next":
					case "these":
	
						var firstParameterValue = currentFilter.parameters.first[0];
						
						if (in_array(firstParameterValue, ["day", "week", "month", "Nquarter", "Fquarter", "Nyear", "Fyear"])) {
							secondParameterStyle = "display: inline";
						} else { 
							secondParameterStyle = "display: none";
						}
						
						cell_Second_Parameter.innerHTML = getCellSecondParameterHtml_forDate(filterIndex, currentFilter.parameters.second, "", "", secondParameterStyle, "display:none;", 'display:none;', "") + getCellThirdParameterHtml_forDate(filterIndex, currentFilter.parameters.third, "", "", "display:none;", "display:none;", "display:none;", 'display:none;', "");
						param2.push(filterIndex);
						param3.push(filterIndex);
						break;
						
					default:
						
						cell_Second_Parameter.innerHTML = getCellSecondParameterHtml_forDate(filterIndex, currentFilter.parameters.second, "", "", "display:none;", "display:none;", 'display:none;', "readonly") + getCellThirdParameterHtml_forDate(filterIndex, currentFilter.parameters.third, "", "", "display:none;", "display:none;", "display:none;", 'display:none;', "");
						param2.push(filterIndex);
						param3.push(filterIndex);
						break;
				
				}
	
	
				if (currentFilter.parameters.second == "last n days") {
						
					cell_Second_Parameter.innerHTML = getCellSecondParameterHtml_forDate(filterIndex, currentFilter.parameters.second, "", "", "display:inline;", "display:none;", 'display:none;', "") + getCellThirdParameterHtml_forDate(filterIndex, currentFilter.parameters.third, "", "", "display:none;", "display:none;", "display:none;", 'display:none;', "");
					param2.push(filterIndex);
	
				}
	
				break;
	
			case "bool":
			case "tinyint(1)":
				
				cell_Operator.innerHTML = getCellOperatorHtml_forBool(filterIndex, currentFilter.operator, displayOperatorSelect);
				cell_First_Parameter.innerHTML = getCellFirstParameterHtml_forBool(filterIndex, currentFilter.parameters.first, disabledAuditInputsRow, displayFirstParameter);
				cell_Second_Parameter.innerHTML = getCellSecondParameterHtml(filterIndex, null);
				
				break;
	
			default:
	
				displayFirstParameter = (currentFilter.operator == 'my items') ? 'display: none;' : displayFirstParameter;
				cell_Operator.innerHTML = getCellOperatorHtml_forDefault(filterIndex, currentFilter.operator, currentFilter.field, displayOperatorSelect);								
				cell_First_Parameter.innerHTML = getCellFirstParameterHtml(filterIndex, currentFilter.parameters.first, displayFirstParameter);
				cell_Second_Parameter.innerHTML = getCellSecondParameterHtml(filterIndex, null);
				
				break;

		}
		
		//***Override Template***//
        currentFilter.templates = (typeof(currentFilter.templates) == "undefined" ? new Array() : currentFilter.templates);
        //***Override Template***//
        
		//***AlineaSol Premium***//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			var displayInheritSelector = (currentFilter.operator == 'inherit') ? 'display: inline;' : 'display: none;';
			
			if (!in_array(currentFilter.type, ["date", "datetime", "datetimecombo", "timestamp", "bool", "tinyint(1)", "relate"])) {
				var hiddenSelect = ((currentFilter.userOptions.length > 0) || (currentFilter.templates.hasOwnProperty('enum'))) ? 'display: inline;' : 'display: none;';
				var multipleSelect = (in_array(currentFilter.operator, ["one of", "not one of"])) ? 'multiple' : '';
				cell_Operator.innerHTML += getCellOperatorHtml_forDropdownGenerator(filterIndex, currentFilter.operator, hiddenSelect);
				
				var jsonEnumTemplates = window.JSON.parse(unescape($('#asolReportsAvailableEnumTemplates').val()));
				
				if (currentFilter.templates.hasOwnProperty('enum')) {
					var dropdownFilteringValues = jsonEnumTemplates[currentFilter.templates.enum].content;
				} else {
					var dropdownFilteringValues = currentFilter.userOptions;
				}
			
				cell_First_Parameter.innerHTML += getCellFirstParameterHtml_forDropdownGenerator(filterIndex, currentFilter.parameters.first, getOptionFromDropdownGenerator(dropdownFilteringValues, false), getOptionFromDropdownGenerator(dropdownFilteringValues, true), '${dollar}', multipleSelect, hiddenSelect);
	
			}
			cell_First_Parameter.innerHTML += getCellFirstParameterHtml_forInherit(currentFilter.parameters.first, currentFilter.operator, filterIndex, currentFilter.type, displayInheritSelector);
		}
		//***AlineaSol Premium***//
		
		row.appendChild(cell_Operator);
        row.appendChild(cell_First_Parameter);
        row.appendChild(cell_Second_Parameter);
        
		
        //*************//
		//***Buttons***//
		//*************//
		cell_Button.innerHTML = getCellFilterButtonsHtml(filterIndex, currentFilter.type, currentFilter.relationKey, currentFilter.index, currentFilter.enumOperator, currentFilter.enumReference, hiddenAuditButtonsRow);
		
		var numberOfRows = $(".asolReportsFilterRow").size()+1;
		cell_Button.innerHTML += getCellFilterArrowsHtml(filterIndex, idTable, numberOfRows, auditedReport, hiddenAuditButtonsRow);

		//***AlineaSol Premium***//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			cell_Button.innerHTML += getTemplateInputHtml(filterIndex, currentFilter.templates);
		}
		//***AlineaSol Premium***//
		
		row.appendChild(cell_Button);
		
		
        table.getElementsByClassName((currentFilter.isWhereFilter ? "asolReportsFilterWhere" : "asolReportsFilterHaving"))[0].appendChild(row);
        
        lastFilterIndex = filterIndex;
		
	});
	
	$('#filtersGlobalIndex').val(lastFilterIndex + 1);

    //Ejecutamos los scripts de inicializacion
    for ( var i = 0; i < param1.length; i++) {
        Calendar.setup ({ inputField : "first_parameter_input_"+param1[i] , daFormat : window["cal_date_format"], button : "trigger_"+param1[i] , singleClick : true, dateStr : '', step : 1, weekNumbers:false });
    }

    for ( var i = 0; i < param2.length; i++) {
        Calendar.setup ({ inputField : "second_parameter_input_"+param2[i] , daFormat : window["cal_date_format"], button : "trigger2_"+param2[i] , singleClick : true, dateStr : '', step : 1, weekNumbers:false });
    }
    
    for ( var i = 0; i < param3.length; i++) {
        Calendar.setup ({ inputField : "third_parameter_input_"+param3[i] , daFormat : window["cal_date_format"], button : "trigger3_"+param3[i] , singleClick : true, dateStr : '', step : 1, weekNumbers:false });
    }
	    
}

function RememberResultsLimit(resultsLimit) {
	
	var limits = resultsLimit.split('${dp}');
	
	$("#results_limit_op").val(limits[0]);
	
	if (typeof(limits[1]) !== 'undefined') {
		$("#results_limit_param").val(limits[1]);
		$("#results_limit_param").css('visibility', 'visible');
	}
	
	if (typeof(limits[2]) !== 'undefined') {
		$("#results_limit_amount").val(limits[2]);
		$("#results_limit_amount").css('visibility', 'visible');
	}
	
}

function RememberTasks(idTable, task_Values) {

	var taskIndex = 0;
	
    var table = document.getElementById(idTable);
    var rows = task_Values.split("|");

    if (task_Values !== "") {

		for ( var i = 0; i < rows.length; i++) {

			var values = rows[i].split(":");
			
			var row = document.createElement("tr");
			row.setAttribute("class", "oddListRowS1 asolReportsTaskRow");

			var cell_MultiRemove = document.createElement("td");
			cell_MultiRemove.className = "center";
			var cell_Task = document.createElement("td");
			var cell_Range = document.createElement("td");
			var cell_Day_Parameter = document.createElement("td");
			var cell_Time_Parameter = document.createElement("td");
			var cell_End_Date = document.createElement("td");
			var cell_State = document.createElement("td");
			var cell_Button = document.createElement("td");
			cell_Button.align = "right";

			
			cell_MultiRemove.innerHTML = getCellMultiRemoveHtml();
			cell_Task.innerHTML = getCellTaskHtml(taskIndex, values[0]);
			cell_Range.innerHTML = getCellRangeHtml(taskIndex, values[1]);

			if (values[1] == "monthly") {
				cell_Day_Parameter.innerHTML = getCellDayHtml(taskIndex, values[2], '', 'display: inline;', 'display: none;');	
			} else if (values[1] == "weekly"){
				cell_Day_Parameter.innerHTML = getCellDayHtml(taskIndex, '', values[2], 'display: none;', 'display: inline;');
			} else {
				cell_Day_Parameter.innerHTML = getCellDayHtml(taskIndex, '', '', 'display: none;', 'display: none;');

			}

			cell_Time_Parameter.innerHTML = getCellTimeHtml(taskIndex, values[3]);
			cell_End_Date.innerHTML = getCellRangeEndDateHtml(taskIndex, values[4]);
			cell_State.innerHTML = getCellStateHtml(taskIndex, values[5]);
			cell_Button.innerHTML = getCellTaskButtonsHtml();

			
			row.appendChild(cell_MultiRemove);
			row.appendChild(cell_Task);
			row.appendChild(cell_Range);
			row.appendChild(cell_Day_Parameter);
			row.appendChild(cell_Time_Parameter);
			row.appendChild(cell_End_Date);
			row.appendChild(cell_State);
			row.appendChild(cell_Button);

			table.getElementsByTagName('tbody')[0].appendChild(row);
			

			taskIndex++;
			
		}
		
		$('#tasksGlobalIndex').val(taskIndex);

    }

    for (var i=0; i<taskIndex; i++){
    	
        Calendar.setup ({ inputField : "range_end_date_"+i , daFormat : window["cal_date_format"], button : "range_end_date_trigger_"+i , singleClick : true, dateStr : '', step : 1, weekNumbers:false });
        
    }

}

function RememberCharts(idTable, chartsJson, reportChartsEngine) {

	var chartIndex = 0;
	
    var chartsTable = document.getElementById(idTable);
    
	if (chartsJson !== "") {
	
		var chartsArray = window.JSON.parse(chartsJson).charts;

		for (var key = 0; key < chartsArray.length; key++) {

			var chartData = chartsArray[key].data;
			
			var chartConfig = (chartsArray[key].hasOwnProperty('config')) ? chartsArray[key].config : new Array();
			
			var chartsGroup = document.createElement("tbody");
			chartsGroup.setAttribute("class", "asolReportsChartsGroup");
			
		    if (chartData.display.toLowerCase() == 'no') {
		    	chartsGroup.className += ' hiddenRow';
			}
	        
			var currentChart = getChartRow(chartData, chartConfig, reportChartsEngine, chartIndex, true);
			chartsGroup.appendChild(currentChart);

			chartIndex++;
			
			//***********************//
			//***AlineaSol Premium***//
			//***********************//
			if (typeof window.hasPremiumJsFeatures == "function") {
				
			    var subcharts = chartData.subcharts;
			    
			    if (subcharts != undefined) {
			    
				    subcharts.forEach(function(currentSubchart) {
				    	var subchartHtml = getSubchartRow(currentSubchart, reportChartsEngine, chartIndex);
				    	chartsGroup.appendChild(subchartHtml);
				    	chartIndex++;
				    });
			    
			    }
			    
			}
			//***********************//
			//***AlineaSol Premium***//
			//***********************//
		    
		    var chartsGroupJquery = $(chartsGroup);
		    var numRows = chartsGroupJquery.find('.asolReportsChartRow').size();
		    chartsGroupJquery.find('.asolReportsMainChart .massiveCheck').closest('td').attr('rowSpan', numRows);
		    chartsGroupJquery.find('.asolReportsMainChart .chart_name').closest('td').attr('rowSpan', numRows);
		    chartsGroupJquery.find('.asolReportsMainChart .chart_ref').closest('td').attr('rowSpan', numRows);
		    
		    chartsTable.appendChild(chartsGroup);

	    }
	    
	    $('#chartsGlobalIndex').val(chartIndex);
	    
	}
    
}

function getChartRow(chartData, chartConfig, reportChartsEngine, chartIndex, isMainChart) {

	var chartRow = document.createElement("tr");
	if (isMainChart)
		chartRow.setAttribute("class", "oddListRowS1 asolReportsChartRow asolReportsMainChart");
	else if (typeof window.hasPremiumJsFeatures == "function")
		chartRow.setAttribute("class", "oddListRowS1 asolReportsChartRow asolReportsSubChart");

    if (isMainChart) {
    	var cell_MultiRemove = document.createElement("td");
    	cell_MultiRemove.className = "center";
    	var cell_Name = document.createElement("td");
    	var cell_Reference = document.createElement("td");
    }
    
    var cell_Display = document.createElement("td");
    var cell_Type = document.createElement("td");
    var cell_XAxis = document.createElement("td");
    var cell_YAxis = document.createElement("td");
    
    if (typeof window.hasPremiumJsFeatures == 'function') {
    	var cell_ZAxis = document.createElement("td");
    }
    
    var cell_Button = document.createElement("td");
    cell_Button.align = "right";
    
    var chartNum = chartData.index.split("_");
    var chartConfigJson = (window.JSON.stringify(chartConfig) === '[]') ? '{}' : window.JSON.stringify(chartConfig);
    
    if (isMainChart) {
    	cell_MultiRemove.innerHTML = getCellMultiRemoveHtml();
    	cell_Name.innerHTML = getCellChartNameHtml(chartIndex, chartData.label);
    	cell_Reference.innerHTML = getCellChartReferenceHtml(chartIndex, chartData.chartReference);
    }
    
    cell_Display.innerHTML = getCellChartDisplayHtml(chartIndex, chartData.display.toLowerCase(), "", isMainChart);
    
  	cell_Type.innerHTML = getCellChartTypeHtml(chartIndex, reportChartsEngine, chartData.type, chartData.halfChart, chartData.xAxis, chartData.xIndex, chartData.index, chartData.zIndex, chartNum[1]);

  	cell_XAxis.innerHTML = getCellChartXAxisHtml(chartIndex, chartData.xAxis, chartData.xIndex, isMainChart);
	cell_YAxis.innerHTML = getCellChartYAxisHtml(chartIndex, chartData.field, chartData.index, chartData.yAxisSide, isMainChart) + getInputChartFunctionHtml(chartIndex, chartData.function, chartData.index, chartData.related, chartNum);
	
	if (typeof window.hasPremiumJsFeatures == 'function') {
		cell_ZAxis.innerHTML = getCellChartZAxisHtml(chartIndex, chartData.zAxis, chartData.zIndex);
	}
	
    cell_Button.innerHTML = getCellChartButtonsHtml(chartIndex, chartConfigJson, reportChartsEngine, chartData.type, isMainChart);
    
   	if (isMainChart) {
   		chartRow.appendChild(cell_MultiRemove);
   		chartRow.appendChild(cell_Name);
   		chartRow.appendChild(cell_Reference);
	}
   	
   	chartRow.appendChild(cell_Display);
   	chartRow.appendChild(cell_Type);
   	chartRow.appendChild(cell_XAxis);
   	chartRow.appendChild(cell_YAxis);
   	
   	if (typeof window.hasPremiumJsFeatures == 'function') {
   		chartRow.appendChild(cell_ZAxis);
   	}
   	
   	chartRow.appendChild(cell_Button);

    return chartRow;
	
}

function getUserOptionsReadableFormat(userOptions) {
	
	if (userOptions === null) {
		userOptions = new Array();
	}
	
	var ret = "";
	userOptions.forEach(function(entry) {
		var key = entry.key;
		var value = entry.value;
		
		ret += key;
		if ((value != undefined) && (value.length > 0) && (value != key)) {
			ret += "=" + value;
		}
		ret += ",";
		
	});
	
	return ret.slice(0, -1);
}

function getUserOptionsObject(userOptions) {

	var returnedUserOptions = new Array();
	
	if (userOptions.length > 0) {
		userOptions.split(",").forEach(function(entry) {
			var userOption = new Object();
			var currentOptionArray = entry.split("=");
			userOption.key = currentOptionArray[0];
			userOption.value = ((currentOptionArray.length > 1) ? currentOptionArray[1] : null);

			returnedUserOptions.push(userOption);
			
		});
	}
	
	return returnedUserOptions;
	
}

function fixUpFilterType(filterType) {

	if (filterType.indexOf("int") === 0)
		return "int";
	else if (filterType.indexOf("decimal") === 0)
		return "decimal";
	else if (filterType.indexOf("float") === 0)
		return "float";
	
	return filterType;
	
}



function getCellFieldHtml(fieldIndex, selectedValue, isRelated, relationKey) {

	var DatabaseField = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DATABASE_FIELD');
	
	var imageTitle = DatabaseField+': '+selectedValue;
	if (isRelated) {
		imageTitle += ' ('+relationKey+')';
	} 
	
	return '<img src="modules/asol_Reports/include_basic/images/asol_reports_database.png" title="'+imageTitle+'" style="vertical-align: text-bottom" />'
			+ '<input type="hidden" id="field_'+fieldIndex+'" class="field" value="'+selectedValue+'" />';

}

function getCellAliasHtml(fieldIndex, selectedValue, disabledAuditInputsRow) {

	return "<input id='alias_"+fieldIndex+"' type='text' class='alias' size='15' maxlength='' value='" + selectedValue.replace(/'/g, "&#39;") + "' title='' onblur='updateCharts();' "+disabledAuditInputsRow+">";

}

function getCellFieldReferenceHtml(fieldIndex, selectedValue, disabledAuditInputsRow) {

	return "<input id='field_ref_"+fieldIndex+"' class='field_ref' "+disabledAuditInputsRow+" type='text' value='" + selectedValue + "'>";
	
}

function getCellSortSequenceHtml(fieldIndex, selectedValue) {

	var selectedSpan = (selectedValue == '') ? '' : selectedValue+getOrdinalChar(selectedValue); 
	return "<span id='sort_seq_span_"+fieldIndex+"' class='sort_seq_span'>"+selectedSpan+"</span><input id='sort_seq_"+fieldIndex+"' type='hidden' class='sort_seq'value='" + selectedValue + "'>";

}

function getCellGroupBySequenceHtml(fieldIndex, selectedValue) {

	var selectedSpan = (selectedValue == '') ? '' : selectedValue+getOrdinalChar(selectedValue); 
	return "<span id='group_seq_span_"+fieldIndex+"' class='group_seq_span'>"+selectedSpan+"</span><input id='group_seq_"+fieldIndex+"' type='hidden' class='group_seq' value='" + selectedValue + "'>";

}

function getCellDisplayHtml(fieldIndex, selectedValue, disabledAuditInputsRow) {

	var label_visible = SUGAR.language.get('asol_Reports', 'LBL_REPORT_VISIBLE');
	var label_hidden = SUGAR.language.get('asol_Reports', 'LBL_REPORT_HIDDEN');
	var label_html = SUGAR.language.get('asol_Reports', 'LBL_REPORT_HTML_HIDDEN');

	selectedValue = (!in_array(selectedValue, ['no', 'html']) ? 'yes' : selectedValue);
	
	var cell_Display_HTML = "<input type='hidden' class='field_display display' value='"+selectedValue+"' "+disabledAuditInputsRow+">";
	
	if (selectedValue == 'yes') {
		cell_Display_HTML += "<img class='field_visible clickable' src='modules/asol_Reports/include_basic/images/asol_reports_visible.png' title='"+label_visible+"' />"
								+ "<img style='display: none;' class='field_hidden clickable' src='modules/asol_Reports/include_basic/images/asol_reports_hidden.png' title='"+label_hidden+"' />"
								+ "<img style='display: none;' class='field_html clickable' src='modules/asol_Reports/include_basic/images/asol_reports_html.png' title='"+label_html+"' />";
	} else if (selectedValue == 'no') {
		cell_Display_HTML += "<img style='display: none;' class='field_visible clickable' src='modules/asol_Reports/include_basic/images/asol_reports_visible.png' title='"+label_visible+"' />"
								+ "<img class='field_hidden clickable' src='modules/asol_Reports/include_basic/images/asol_reports_hidden.png' title='"+label_hidden+"' />"
								+ "<img style='display: none;' class='field_html clickable' src='modules/asol_Reports/include_basic/images/asol_reports_html.png' title='"+label_html+"' />";
	} else {
		cell_Display_HTML += "<img style='display: none;' class='field_visible clickable' src='modules/asol_Reports/include_basic/images/asol_reports_visible.png' title='"+label_visible+"' />"
								+ "<img style='display: none;' class='field_hidden clickable' src='modules/asol_Reports/include_basic/images/asol_reports_hidden.png' title='"+label_hidden+"' />"
								+ "<img class='field_html clickable' src='modules/asol_Reports/include_basic/images/asol_reports_html.png' title='"+label_html+"' />";
	}
							
	return cell_Display_HTML;
	
}		


function manageFieldSortingValues(fieldIndex, nextClickValue) {
	
	var sortingInput = $('#sort_dir_'+fieldIndex);
	
	if (!in_array($(sortingInput).val(), ['ASC', 'DESC'])) {
		
		$(sortingInput).closest('.asolReportsFieldRow').find('.sort_seq').val('');
		$(sortingInput).closest('.asolReportsFieldRow').find('.sort_seq_span').html('');
		
	}
	
	$(sortingInput).val(nextClickValue);
	
	var imgClickValue = (nextClickValue == '0' ? 'none' : nextClickValue.toLowerCase());
	$(sortingInput).closest('.asolReportsFieldRow').find('img.field_sorting').not('.'+imgClickValue+'_sorting').css('display', 'none');
	$(sortingInput).closest('.asolReportsFieldRow').find('img.field_sorting.'+imgClickValue+'_sorting').css('display', 'inline');
	
	
}

function getCellSortDirHtml(fieldIndex, selectedValue) {

	var lbl_sort = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SORT');
	var lbl_asc = SUGAR.language.get('asol_Reports', 'LBL_REPORT_ASC_SORT');
	var lbl_desc = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DESC_SORT');
	
	var cell_Sort_Dir_HTML = "<input type='hidden' id='sort_dir_"+fieldIndex+"' class='sort_dir' value='"+selectedValue+"'>";
	cell_Sort_Dir_HTML += "<img src='modules/asol_Reports/include_basic/images/asol_reports_no_sorting.png' class='field_sorting none_sorting clickable' title='"+lbl_sort+"' onClick='manageFieldSortingValues("+fieldIndex+", \"ASC\");' style='vertical-align: text-bottom; display: "+((selectedValue == '0') ? 'inline' : 'none')+";'>";
	cell_Sort_Dir_HTML += "<img src='modules/asol_Reports/include_basic/images/asol_reports_asc_sorting.png' class='field_sorting asc_sorting clickable' title='"+lbl_asc+"' onClick='manageFieldSortingValues("+fieldIndex+", \"DESC\");' style='vertical-align: text-bottom; display: "+((selectedValue == 'ASC') ? 'inline' : 'none')+";'>";
	cell_Sort_Dir_HTML += "<img src='modules/asol_Reports/include_basic/images/asol_reports_desc_sorting.png' class='field_sorting desc_sorting clickable' title='"+lbl_desc+"' onClick='manageFieldSortingValues("+fieldIndex+", \"0\");' style='vertical-align: text-bottom; display: "+((selectedValue == 'DESC') ? 'inline' : 'none')+";'>";
	
	return cell_Sort_Dir_HTML;
	
}

function getCellFunctionHtml_forEnums(fieldIndex, selectedValue, disabledAuditInputsRow) {

	var cell_Function_HTML = "<select id='function_"+fieldIndex+"' class='function' "+disabledAuditInputsRow+" onChange='updateFilters(this); updateCharts();'>";
	var functionValues = ["0", "COUNT", "MIN", "MAX", "SUM", "AVG"];
	var functionLabels = ["", "COUNT", "MIN", "MAX", "SUM", "AVG"];
	
	for (x = 0; x < functionValues.length; x++) {
		cell_Function_HTML += (functionValues[x] == selectedValue) ? "<option value='"+functionValues[x]+"' selected>"+functionLabels[x]+"</option>" : "<option value='"+functionValues[x]+"'>"+functionLabels[x]+"</option>";
	}
	cell_Function_HTML += "</select>";
	return cell_Function_HTML;

}

function getCellFunctionHtml_forMultiEnums(fieldIndex, selectedValue, disabledAuditInputsRow) {
	
	var cell_Function_HTML = "<select id='function_"+fieldIndex+"' class='function' "+disabledAuditInputsRow+" onChange='updateFilters(this); updateCharts();'>";
	var functionValues = ["0", "COUNT"];
	var functionLabels = ["", "COUNT"];
	
	for (x = 0; x < functionValues.length; x++) {
		cell_Function_HTML += (functionValues[x] == selectedValue) ? "<option value='"+functionValues[x]+"' selected>"+functionLabels[x]+"</option>" : "<option value='"+functionValues[x]+"'>"+functionLabels[x]+"</option>";
	}
	cell_Function_HTML += "</select>";
	return cell_Function_HTML;

}

function getCellFunctionHtml_forDates(fieldIndex, selectedValue, disabledAuditInputsRow) {

	var cell_Function_HTML = "<select id='function_"+fieldIndex+"' class='function' "+disabledAuditInputsRow+" onChange='updateFilters(this); updateCharts();'>";
	var functionValues = ["0", "MIN", "MAX"];
	var functionLabels = ["", "MIN", "MAX"];
	for (x = 0; x < functionValues.length; x++) {
		cell_Function_HTML += (functionValues[x] == selectedValue) ? "<option value='"+functionValues[x]+"' selected>"+functionLabels[x]+"</option>" : "<option value='"+functionValues[x]+"'>"+functionLabels[x]+"</option>";
	}
	cell_Function_HTML += "</select>";
	return cell_Function_HTML;

}

function getCellFunctionHtml_forBool(fieldIndex, selectedValue, disabledAuditInputsRow) {
	
	var cell_Function_HTML = "<select id='function_"+fieldIndex+"' class='function' "+disabledAuditInputsRow+" onChange='updateFilters(this); updateCharts();'>";
	var functionValues = ["0", "COUNT", "SUM"];
	var functionLabels = ["", "COUNT", "SUM"];
	for (x = 0; x < functionValues.length; x++) {
		cell_Function_HTML += (functionValues[x] == selectedValue) ? "<option value='"+functionValues[x]+"' selected>"+functionLabels[x]+"</option>" : "<option value='"+functionValues[x]+"'>"+functionLabels[x]+"</option>";
	}
	cell_Function_HTML += "</select>";
	return cell_Function_HTML;

}

function getCellFunctionHtml_forDefault(fieldIndex, selectedValue, auditedReport, disabledAuditInputsRow) {

	var cell_Function_HTML = "<select id='function_"+fieldIndex+"' class='function' "+disabledAuditInputsRow+" onChange='updateFilters(this); updateCharts();'>";
	var functionValues = (auditedReport == '1') ? ["0", "COUNT", "MIN", "MAX", "SUM", "AVG"] : ["0", "COUNT"];
	var functionLabels = (auditedReport == '1') ? ["", "COUNT", "MIN", "MAX", "SUM", "AVG"] : ["", "COUNT"];
	for (x = 0; x < functionValues.length; x++) {
		cell_Function_HTML += (functionValues[x] == selectedValue) ? "<option value='"+functionValues[x]+"' selected>"+functionLabels[x]+"</option>" : "<option value='"+functionValues[x]+"'>"+functionLabels[x]+"</option>";
	}
	cell_Function_HTML += "</select>";
	return cell_Function_HTML;

}

function reDrawSqlFunctionImg(imageIndex) {

	var filled = ($("#configureSqlValue_"+imageIndex).val() != '');
	
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	if (typeof window.hasPremiumJsFeatures == 'function') {
		filled = isSqlPremiumFilled(imageIndex, filled);
	}
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
		
	if (filled)
		$("#configureSqlBtn_"+imageIndex).attr('src', 'modules/asol_Reports/include_basic/images/asol_reports_sql_function_filled.png');
	else
		$("#configureSqlBtn_"+imageIndex).attr('src', 'modules/asol_Reports/include_basic/images/asol_reports_sql_function.png');	

}

function getCellFunctionsConfigureSQL(templateValues, currentField, fieldIndex, sqlFormula, subQuery) {

	var disabledInputs = false;
	var sqlStoredFormula = sqlFormula = (typeof(sqlFormula) == 'undefined' ? '' : sqlFormula);

	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	if (typeof window.hasPremiumJsFeatures == 'function') { 
		var jsonSqlTemplates = window.JSON.parse(unescape($('#asolReportsAvailableSqlTemplates').val()));
		if (templateValues.hasOwnProperty('sql')) {
			sqlFormula = jsonSqlTemplates[templateValues.sql].content;
			sqlStoredFormula = 'hasTemplate';
			disabledInputs = true;
		}
	}
	//***********************//
	//***AlineaSol Premium***//
	//***********************//

	var checkInsecurity = ($('#mySQLcheckInsecurity').val() === "1") ? true : false;
	var disableMySQLField = (checkInsecurity && (!validate_mysql_function_insecurity(sqlFormula, false))) ? "disabled" : "";
	
	var lbl_report_save = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SAVE');
	var lbl_report_clear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CLEAR');
	var lbl_report_cancel = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CANCEL');
	var lbl_report_sql_code = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SQL_CODE');

	

	var sqlFilled = (sqlFormula != '');
	
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	if (typeof window.hasPremiumJsFeatures == 'function') {
		sqlFilled = (sqlFilled || ((typeof(subQuery.module) == 'undefined' ? '' : subQuery.module) != ''));
	}
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	
	
	var sqlFunctionImg = (sqlFilled ? "asol_reports_sql_function_filled.png" : "asol_reports_sql_function.png"); 
	

	var cell_Function_Configure_SQL_HTML = "<script>var dialogSqlFunction_"+fieldIndex+";</script>" +
											"<img id='configureSqlBtn_"+fieldIndex+"' src='modules/asol_Reports/include_basic/images/"+sqlFunctionImg+"' style='vertical-align: text-bottom' class='clickable' onClick='manageSqlEditor("+fieldIndex+", true);'>";

	cell_Function_Configure_SQL_HTML += "<input "+disableMySQLField+" type='hidden' id='configureSqlStoredValue_"+fieldIndex+"' class='configureSqlStoredValue' value='"+sqlStoredFormula+"'>";												
	
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	if (typeof window.hasPremiumJsFeatures == 'function') { 
		cell_Function_Configure_SQL_HTML += getSubReportHiddenInputs(subQuery, fieldIndex);										
	}
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	
	cell_Function_Configure_SQL_HTML += "<div id='configureSqlDiv_"+fieldIndex+"' class='configureSqlDiv' style='display:none'>";
	
	
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	if (typeof window.hasPremiumJsFeatures == 'function') { 
		cell_Function_Configure_SQL_HTML += getTemplateSelector(templateValues.sql, 'Sql', currentField, fieldIndex, 'Field', true);										
	}
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	
	
	cell_Function_Configure_SQL_HTML += "<table id='sqlGeneratorFieldTable_"+fieldIndex+"' class='edit view'><thead><tr><th><h4><div style='display: inline-block'>"+lbl_report_sql_code+"</div></h4></th></tr></thead><tbody><tr><td>" +
												"<textarea "+disableMySQLField+" id='configureSqlValue_"+fieldIndex+"' class='configureSqlValue' rows='4' cols='40' style='width:100%' "+(disabledInputs ? 'disabled' : '')+">"+sqlFormula+"</textarea>" +
											"</td></tr></tbody></table>";
	
	if (!disableMySQLField) {
		cell_Function_Configure_SQL_HTML += "<input id='sqlGeneratorFieldSaveBtn_"+fieldIndex+"' class='sqlGeneratorFieldSaveBtn' type='button' value='"+lbl_report_save+"' onClick='saveSqlValues(this.id, dialogSqlFunction_"+fieldIndex+", "+fieldIndex+")'>";
		cell_Function_Configure_SQL_HTML += "<input id='sqlGeneratorFieldClearBtn_"+fieldIndex+"' class='sqlGeneratorFieldClearBtn' type='button' value='"+lbl_report_clear+"' onClick='window[\"codeMirror_configureSqlValue_"+fieldIndex+"\"].setValue(\"\"); $(\"#configureSqlValue_"+fieldIndex+"\").val(\"\");' "+(disabledInputs ? "style='display:none'" : "")+">";
	}
		
	cell_Function_Configure_SQL_HTML += 		"<input id='sqlGeneratorFieldCancelBtn_"+fieldIndex+"' class='sqlGeneratorFieldCancelBtn' type='button' value='"+lbl_report_cancel+"' onClick='cancelSqlValues(this.id, dialogSqlFunction_"+fieldIndex+", "+fieldIndex+")'>" +
													"<br><br>" +
												"</div>";
	
	
	return cell_Function_Configure_SQL_HTML;
	
}

function manageSqlEditor(fieldIndex, subQueryMode) {
	
	if (typeof window.hasPremiumJsFeatures == 'function') {

		managePremiumSqlEditor(fieldIndex, subQueryMode);

	} else {

		getMySQLFunctionsHTML(fieldIndex); 
		window["dialogSqlFunction_"+fieldIndex] = $("#configureSqlDiv_"+fieldIndex).dialog({ 
			modal: true, 
			overlay: { opacity: 0.8, background: "black" }, 
			position: ["center", "center"], 
			width: 850, 
			resizable:true, 
			title: SUGAR.language.get('asol_Reports', 'LBL_REPORT_SQL_FUNCTION_FOR') + $("#alias_"+fieldIndex).val()
		});
		
		setCodeMirrorEditor("configureSqlValue_"+fieldIndex, "text/x-mysql");
	
	}
	
}

function saveSqlValues(saveButtonId, dialogSqlFunction, index) {
	
	if (validate_mysql_function_insecurity($("#configureSqlValue_"+index).val(), true)) {
		
		var sqlCode = window["codeMirror_configureSqlValue_"+index].getValue();
		
		if ((sqlCode.match(/\(/g) || []).length === (sqlCode.match(/\)/g) || []).length) {

			var asolReportsFieldRow = $("#configureSqlBtn_"+index).closest(".asolReportsFieldRow");
			
			//***********************//
			//***AlineaSol Premium***//
			//***********************//
			if (typeof window.hasPremiumJsFeatures == 'function') {
				
				var saveButton = $("#"+saveButtonId);
				var configureSqlDiv = saveButton.closest(".configureSqlDiv");
				var templateValue = configureSqlDiv.find('.asolReportsTemplate').val();
			
				if (templateValue == '') {
					$("#configureSqlValue_"+index).val(sqlCode);
					asolReportsFieldRow.find(".configureSqlStoredValue").val($("#configureSqlValue_"+index).val());
					asolReportsFieldRow.find(".templates").val(formatTemplates('configureSqlBtn_'+index, index, 'Field', 'sql', null));
				} else {
					asolReportsFieldRow.find(".configureSqlStoredValue").val('hasTemplate');
					asolReportsFieldRow.find(".templates").val(formatTemplates('configureSqlBtn_'+index, index, 'Field', 'sql', templateValue));
				}
			//***********************//
			//***AlineaSol Premium***//
			//***********************//	
			} else {
				$("#configureSqlValue_"+index).val(sqlCode);
				asolReportsFieldRow.find(".configureSqlStoredValue").val($("#configureSqlValue_"+index).val());
			}
			
			
			reDrawSqlFunctionImg(index);
			dialogSqlFunction.dialog("close");
		
		} else {
			
			alert(SUGAR.language.get('asol_Reports', 'LBL_REPORT_MATCHING_PARENTHESIS_ALERT'));
			
		}

	}
	
}

function cancelSqlValues(cancelButtonId, dialogSqlFunction, index) {
	
	var cancelButton = $("#"+cancelButtonId);
	var configureSqlDiv = cancelButton.closest(".configureSqlDiv");
	var asolReportsFieldRow = $("#configureSqlBtn_"+index).closest(".asolReportsFieldRow");
	
	if (unescape(asolReportsFieldRow.find(".configureSqlStoredValue").val()) != 'hasTemplate') {
		configureSqlDiv.find(".configureSqlValue").val(asolReportsFieldRow.find(".configureSqlStoredValue").val());
		window["codeMirror_configureSqlValue_"+index].setValue(asolReportsFieldRow.find(".configureSqlStoredValue").val());
	}
	
	dialogSqlFunction.dialog("close");
	
}

function getMySQLFunctionsHTML(fieldIndex) {
    
	var lang = document.documentElement.lang;

	if ($("#mySQLFunctions"+fieldIndex).length === 0) {
		$("#configureSqlDiv_"+fieldIndex).append("<div id='mySQLFunctions"+fieldIndex+"' class='mySQLFunctions'></div>");
	}
	
	$.ajax({
		url: 'modules/asol_Reports/mySQLFunctions/mySQLFunctions.'+lang+'.html',
		success: function(data) {
			$('#mySQLFunctions'+fieldIndex).html(data);
		},
		error: function(data2) {
			$.ajax({
				url: 'modules/asol_Reports/mySQLFunctions/mySQLFunctions.'+window["reportsDefaultLang"]+'.html',
				success: function(data2) {
					$('#mySQLFunctions'+fieldIndex).html(data2);
				}
			});
		}
	});

}

function getCellFormatTypeHtml(fieldIndex, selectedValue, selectedTemplates, currentField, fieldType, disabledAuditInputsRow) {
	
	var selectedType = ((typeof selectedValue.type === 'undefined') ? '' : selectedValue.type);
	
	var lbl_string = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FORMAT_STRING');
	var lbl_date = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FORMAT_DATE');
	var lbl_integer = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FORMAT_INT');
	var lbl_decimal = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FORMAT_DECIMAL');
	var lbl_currency = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FORMAT_CURRENCY');
	var lbl_percent = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FORMAT_PERCENT');
	var lbl_boolean = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FORMAT_BOOLEAN');
	
	var cell_Format_Type_HTML = "<select id='format_type_"+fieldIndex+"' class='format_type' "+disabledAuditInputsRow+" onClick='if (typeof window.hasPremiumJsFeatures == \"function\") { manageReportFieldFormat(this.value, "+fieldIndex+"); }'>";
	var cell_Format_Type_Ext_HTML = "";
	
	var formatValues = ["", "varchar", "date", "int", "decimal", "currency", "percent", "bool"];
	var formatLabels = ["", lbl_string, lbl_date, lbl_integer, lbl_decimal, lbl_currency, lbl_percent, lbl_boolean];

	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	if (typeof window.hasPremiumJsFeatures == 'function') {
		var lbl_enum = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FORMAT_ENUM');
		var lbl_button = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FORMAT_BUTTON');
		formatValues.push('enum');
		formatLabels.push(lbl_enum);
		formatValues.push('button');
		formatLabels.push(lbl_button);

		var selectedExtra = ((typeof selectedValue.extra === 'undefined') ? new Array() : selectedValue.extra);

		cell_Format_Type_Ext_HTML += getReportFieldExtraFormatButtonHtml(selectedType, selectedTemplates, selectedExtra, currentField, fieldIndex);
	}
	//***********************//
	//***AlineaSol Premium***//
	//***********************//

	
	for (x = 0; x < formatValues.length; x++) {
		cell_Format_Type_HTML += "<option value='"+formatValues[x]+"' "+(formatValues[x] == selectedType ? 'selected' : '')+">"+formatLabels[x]+"</option>";
	}
	
	cell_Format_Type_HTML += "</select>";

	return cell_Format_Type_HTML + cell_Format_Type_Ext_HTML;
	
}

function uniqueId(selectedId)
{
	var select = $('#'+selectedId),
		detailInstance = null,
		uniqueDetail = true;
	
	if (in_array(select.val(), ['Detail', 'Minute Detail', 'Quarter Hour Detail', 'Hour Detail', 'Day Detail', 'DoW Detail', 'WoY Detail', 'Month Detail', 'Natural Quarter Detail', 'Fiscal Quarter Detail', 'Natural Year Detail', 'Fiscal Year Detail'])) 
	{
		detailInstance = selectedId;
		
		$.each($('.layout_group'), function()
		{
			if ( this.id !== selectedId && in_array(this.value, ['Detail', 'Minute Detail', 'Quarter Hour Detail', 'Hour Detail', 'Day Detail', 'DoW Detail', 'WoY Detail', 'Month Detail', 'Natural Quarter Detail', 'Fiscal Quarter Detail', 'Natural Year Detail', 'Fiscal Year Detail']) )
			{
				detailInstance = this.id;
				uniqueDetail = false;
			}
		});
	}
	
	if ( !uniqueDetail )
	{
		if( confirm(SUGAR.language.get('asol_Reports', 'LBL_REPORT_UNIQUE_DETAIL')) )
		{
			$('#'+detailInstance).val('0');
		}
		else
		{
			select.val('0');
		}
	}
}

function manageGroupSortingValues(selectedId) {
	
	var orderSelect = $('#'+selectedId);
	
	if (!in_array(orderSelect.val(), ['Grouped', 'Minute Grouped', 'Quarter Hour Grouped', 'Hour Grouped', 'Day Grouped', 'DoW Grouped', 'WoY Grouped', 'Month Grouped', 'Natural Quarter Grouped', 'Fiscal Quarter Grouped', 'Natural Year Grouped', 'Fiscal Year Grouped'])) {
		
		orderSelect.closest('.asolReportsFieldRow').find('.group_seq').val('');
		orderSelect.closest('.asolReportsFieldRow').find('.group_seq_span').html('');
		
	}
	
}

function getCellLayoutGroupHtml_forDates(fieldIndex, fieldType, selectedValue, disabledAuditInputsRow) {
				
	var hasTime = (fieldType == 'date' ? false : true);
	
	var lbl_grouped = SUGAR.language.get('asol_Reports', 'LBL_REPORT_GROUPED');
	var lbl_minute_grouped = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MINUTE_GROUPED');
	var lbl_qhour_grouped = SUGAR.language.get('asol_Reports', 'LBL_REPORT_QHOUR_GROUPED');
	var lbl_hour_grouped = SUGAR.language.get('asol_Reports', 'LBL_REPORT_HOUR_GROUPED');
	var lbl_day_grouped = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DAY_GROUPED');
	var lbl_dow_grouped = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DOW_GROUPED');
	var lbl_woy_grouped = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WOY_GROUPED');
	var lbl_month_grouped = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MONTH_GROUPED');
	var lbl_nquarter_grouped = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NQUARTER_GROUPED');
	var lbl_fquarter_grouped = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FQUARTER_GROUPED');
	var lbl_nyear_grouped = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NYEAR_GROUPED');
	var lbl_fyear_grouped = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FYEAR_GROUPED');
	
	var lbl_detail = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DETAIL');
	var lbl_minute_detail = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MINUTE_DETAIL');
	var lbl_qhour_detail = SUGAR.language.get('asol_Reports', 'LBL_REPORT_QHOUR_DETAIL');
	var lbl_hour_detail = SUGAR.language.get('asol_Reports', 'LBL_REPORT_HOUR_DETAIL');
	var lbl_day_detail = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DAY_DETAIL');
	var lbl_dow_detail = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DOW_DETAIL');
	var lbl_woy_detail = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WOY_DETAIL');
	var lbl_month_detail = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MONTH_DETAIL');
	var lbl_nquarter_detail = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NQUARTER_DETAIL');
	var lbl_fquarter_detail = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FQUARTER_DETAIL');
	var lbl_nyear_detail = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NYEAR_DETAIL');
	var lbl_fyear_detail = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FYEAR_DETAIL');
	
	
	var layoutDetailValues = ["Detail", "Minute Detail", "Quarter Hour Detail", "Hour Detail", "Day Detail", "DoW Detail", "WoY Detail", "Month Detail", "Natural Quarter Detail", "Fiscal Quarter Detail", "Natural Year Detail", "Fiscal Year Detail"];
	var layoutDetailLabels = [lbl_detail, lbl_minute_detail, lbl_qhour_detail, lbl_hour_detail, lbl_day_detail, lbl_dow_detail, lbl_woy_detail, lbl_month_detail, lbl_nquarter_detail, lbl_fquarter_detail, lbl_nyear_detail, lbl_fyear_detail];
	
	var layoutGroupValues = ["Grouped", "Minute Grouped", "Quarter Hour Grouped", "Hour Grouped", "Day Grouped", "DoW Grouped", "WoY Grouped", "Month Grouped", "Natural Quarter Grouped", "Fiscal Quarter Grouped", "Natural Year Grouped", "Fiscal Year Grouped"];
	var layoutGroupLabels = [lbl_grouped, lbl_minute_grouped, lbl_qhour_grouped, lbl_hour_grouped, lbl_day_grouped, lbl_dow_grouped, lbl_woy_grouped, lbl_month_grouped, lbl_nquarter_grouped, lbl_fquarter_grouped, lbl_nyear_grouped, lbl_fyear_grouped];
	
	if (!hasTime) {
		
		layoutDetailValues.splice(layoutDetailValues.indexOf('Minute Detail'), 1);
		layoutDetailValues.splice(layoutDetailValues.indexOf('Quarter Hour Detail'), 1);
		layoutDetailValues.splice(layoutDetailValues.indexOf('Hour Detail'), 1);
		layoutGroupValues.splice(layoutGroupValues.indexOf('Minute Grouped'), 1);
		layoutGroupValues.splice(layoutGroupValues.indexOf('Quarter Hour Grouped'), 1);
		layoutGroupValues.splice(layoutGroupValues.indexOf('Hour Grouped'), 1);
		
		layoutDetailLabels.splice(layoutDetailLabels.indexOf(lbl_minute_detail), 1);
		layoutDetailLabels.splice(layoutDetailLabels.indexOf(lbl_qhour_detail), 1);
		layoutDetailLabels.splice(layoutDetailLabels.indexOf(lbl_hour_detail), 1);
		layoutGroupLabels.splice(layoutGroupLabels.indexOf(lbl_minute_grouped), 1);
		layoutGroupLabels.splice(layoutGroupLabels.indexOf(lbl_qhour_grouped), 1);
		layoutGroupLabels.splice(layoutGroupLabels.indexOf(lbl_hour_grouped), 1);
	
	}
	
	var cell_Layout_Group_HTML = "<select id='layout_group_"+fieldIndex+"' onChange='uniqueId(this.id); manageGroupSortingValues(this.id); updateCharts();' class='layout_group' "+disabledAuditInputsRow+">";
	
	cell_Layout_Group_HTML += ("0" == selectedValue) ? "<option value='0' selected></option>" : "<option value='0'></option>";
	
	
	cell_Layout_Group_HTML += "<optgroup label='"+lbl_grouped+"'>";
	for (x = 0; x < layoutGroupValues.length; x++) {
		cell_Layout_Group_HTML += (layoutGroupValues[x] == selectedValue) ? "<option value='"+layoutGroupValues[x]+"' selected>"+layoutGroupLabels[x]+"</option>" : "<option value='"+layoutGroupValues[x]+"'>"+layoutGroupLabels[x]+"</option>";
	}
	cell_Layout_Group_HTML += "</optgroup>";
	
	if (!window["subQueryMode"]) {
	
		cell_Layout_Group_HTML += "<optgroup label='"+lbl_detail+"'>";
		for (x = 0; x < layoutDetailValues.length; x++) {
			cell_Layout_Group_HTML += (layoutDetailValues[x] == selectedValue) ? "<option value='"+layoutDetailValues[x]+"' selected>"+layoutDetailLabels[x]+"</option>" : "<option value='"+layoutDetailValues[x]+"'>"+layoutDetailLabels[x]+"</option>";
		}
		cell_Layout_Group_HTML += "</optgroup>";
	
	}
	
	cell_Layout_Group_HTML += "</select>";
	
	return cell_Layout_Group_HTML;
	
}

function getCellLayoutGroupHtml_forDefault(fieldIndex, selectedValue, disabledAuditInputsRow) {
				
	var lbl_grouped = SUGAR.language.get('asol_Reports', 'LBL_REPORT_GROUPED');
	var lbl_detail = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DETAIL');
				
	var cell_Layout_Group_HTML = "<select id='layout_group_"+fieldIndex+"' onChange='uniqueId(this.id); manageGroupSortingValues(this.id); updateCharts();' class='layout_group' "+disabledAuditInputsRow+">";
	var layoutGroupValues = ["0", "Grouped"];
	var layoutGroupLabels = ["", lbl_grouped];
	
	if (!window["subQueryMode"]) {
		layoutGroupValues.push("Detail");
		layoutGroupLabels.push(lbl_detail);
	}
	
	for (x = 0; x < layoutGroupValues.length; x++) {
		cell_Layout_Group_HTML += (layoutGroupValues[x] == selectedValue) ? "<option value='"+layoutGroupValues[x]+"' selected>"+layoutGroupLabels[x]+"</option>" : "<option value='"+layoutGroupValues[x]+"'>"+layoutGroupLabels[x]+"</option>";
	}
	cell_Layout_Group_HTML += "</select>";
	return cell_Layout_Group_HTML;
	
}

function getCellFieldButtonsHtml(fieldIndex, fieldType, isRelated, key, i, enumOperator, enumReference, fieldName, counterField, auditedReport, hiddenAuditButtonsRow) {
	
	var AddButton = SUGAR.language.get('asol_Reports', 'LBL_REPORT_ADD_FILTER');
	var DeleteButton = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DELETE_ROW');
	var DeleteRowAlert = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DELETE_ROW_ALERT');
	
	var cell_Button_HTML = "<img class='asol_icon clickable addReportsFilterIcon' "+hiddenAuditButtonsRow+" border='0' src='modules/asol_Reports/include_basic/images/asol_reports_addline.png' title=\""+AddButton+"\" onClick='showFilteringDialog(this, \"filters_Table\", $(this).closest(\".asolReportsFieldRow\"), \"" + auditedReport + "\")'>"
		+ "<img class='asol_icon clickable' "+hiddenAuditButtonsRow+" src='modules/asol_Reports/include_basic/images/asol_reports_delete.png' title=\""+DeleteButton+"\" onClick='if(confirm(\""+DeleteRowAlert +" \" + $(this).closest(\".asolReportsFieldRow\").find(\".alias\").val())) { new Function($(this).closest(\"td\").find(\".deleteFieldCode\").val())(); }'>"
		+ "<input type='hidden' class='deleteFieldCode' value='delete_field_filters(\"\", \""+fieldName+"\"); $(\"#field_"+fieldIndex+"\").closest(\".asolReportsFieldRow\").remove(); updateCharts(); if (typeof window.hasPremiumJsFeatures == \"function\") { applyChartsRestrictions(); }'>"
		+ "<input type='hidden' id='value_type_"+fieldIndex+"' class='value_type' value='" + fieldType + "'>"
		+ "<input type='hidden' id='key_"+fieldIndex+"' class='key' value='" + key + "'>"
		+ "<input type='hidden' id='is_related_"+fieldIndex+"' class='is_related' value='" + isRelated + "'>"
		+ "<input type='hidden' id='index_"+fieldIndex+"' class='index' value='" + i + "'>"
		+ "<input type='hidden' id='enum_operator_"+fieldIndex+"' class='enum_operator' value='" + ((typeof enumOperator === 'undefined') ? '' : enumOperator) + "'>" 
		+ "<input type='hidden' id='enum_reference_"+fieldIndex+"' class='enum_reference' value='" + ((typeof enumReference === 'undefined') ? '' : enumReference) + "'>";

	return cell_Button_HTML;
	
}

function getCellFieldArrowsHtml(fieldIndex, idTable, index, auditedReport, hiddenAuditButtonsRow) {

	var cell_Arrows_HTML = "<input type='hidden' id='fieldNumber_"+index+"' value='"+index+"'>"
		+ "<input type='hidden' id='fieldIndex_"+index+"' class='fieldIndex' value='"+fieldIndex+"'>";

	return cell_Arrows_HTML;
	
}

function getCellChartButtonsHtml(chartIndex, selectedValue, chartEngine, chartType, isMainChart) {
	
	var DeleteButton = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DELETE_CHART');
	var DeleteChartAlert = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DELETE_CHART_ALERT');
	
	var cell_Button_HTML = ""; 
		
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	if (typeof window.hasPremiumJsFeatures == 'function') {
		cell_Button_HTML += getReportChartPremiumButtonsHtml(isMainChart, chartEngine, chartType, chartIndex);
		cell_Button_HTML += "<span id='chartConfiguratorDiv_"+chartIndex+"'></span>";
		cell_Button_HTML += "<input type='hidden' class='chart_configuration' id='chart_configuration_"+chartIndex+"' value='"+selectedValue+"'>";
		cell_Button_HTML += getReportChartConfiguratorHtml(selectedValue, chartIndex);
	}
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	
	cell_Button_HTML += "<img class='asol_icon clickable' src='modules/asol_Reports/include_basic/images/asol_reports_delete.png' title=\""+DeleteButton+"\" onClick='if(confirm(\""+DeleteChartAlert +" \" + $(this).closest(\".asolReportsChartsGroup\").find(\".chart_name\").val())) { new Function($(this).closest(\"td\").find(\".deleteChartCode\").val())(); }' />";
	
	if (isMainChart) {
		deleteCode = "$(\"#deleteChartCode_"+chartIndex+"\").closest(\".asolReportsChartsGroup\").remove(); if (typeof window.hasPremiumJsFeatures == \"function\") { applyChartsRestrictions(); }";
	} else {
		deleteCode = "$(\"#deleteChartCode_"+chartIndex+"\").closest(\".asolReportsChartRow\").remove(); if (typeof window.hasPremiumJsFeatures == \"function\") { applyChartsRestrictions(); }";
	}
	cell_Button_HTML += "<input type='hidden' id='deleteChartCode_"+chartIndex+"' class='deleteChartCode' value='"+deleteCode+"'>";

	return cell_Button_HTML;
	
}

function InsertFields(idTable, singleField, relatedFields, auditedReport) {
	
	var fieldIndex = $('#fieldsGlobalIndex').val();

    var table = document.getElementById(idTable);
    
    if ((relatedFields == null) && (typeof window.hasPremiumJsFeatures == 'function')) {
    	var fieldSelector = getFieldTreeSelector();
    } else {
    	var fieldSelector = (relatedFields ? '#related_fields :selected' : '#fields :selected');
    }

    $(fieldSelector).each(function(i) {
					
		if ((singleField == null) || (singleField == $(this).attr('fieldIndex'))) {
		
			var fieldValue = $(this).attr('fieldValue');
			var fieldLabel = $(this).attr('fieldLabel');
			var fieldVisible = '';
			var fieldType = $(this).attr('fieldType');
			var fieldKey = $(this).attr('fieldKey');
			var fieldRelated = (fieldKey == '' ? false : true);
			var fieldEnumOperator = $(this).attr('fieldEnumOp');
			var fieldEnumReference = $(this).attr('fieldEnumRef');

			var counterField = count_function_fields(fieldKey, fieldValue) + 1;
			
			var row = document.createElement("tr");
			row.setAttribute("class", "oddListRowS1 asolReportsFieldRow");
			row.setAttribute("onmouseout", "highlightAssociatedRows(this, 'field', false);");
			row.setAttribute("onmouseover", "highlightAssociatedRows(this, 'field', true);");		
						
			var usedKeys = new Array();
	        fieldKey.split(";").forEach(function(currentKey, keyIndex) {
				var keyArray = currentKey.split(" ");
				usedKeys.push((keyArray.length == 3) ? keyArray[0] : currentKey); 
			});
	        
	        var keyTitle = usedKeys.join('::');
	        
	        
	        //*****************//
	        //***MultiRemove***//
	        //*****************//
	        var cell_MultiRemove = document.createElement("td");
			cell_MultiRemove.className = "center";
			
			cell_MultiRemove.innerHTML = getCellMultiRemoveHtml();
			
			row.appendChild(cell_MultiRemove);
			
			
			//***********//
			//***Alias***//
			//***********//
			var cell_Alias = document.createElement("td");
			
			cell_Alias.innerHTML = getCellFieldHtml(fieldIndex, fieldValue, fieldRelated, keyTitle) + "&nbsp;";
			cell_Alias.innerHTML += getCellAliasHtml(fieldIndex, fieldLabel.replace(".", "_").replace(/_/g, " "), "") + "&nbsp;";
			
			if (typeof window.hasPremiumJsFeatures == 'function') {
				cell_Alias.innerHTML += getMultiLanguageField('', fieldIndex);
			}
			
			cell_Alias.innerHTML += getCellSortDirHtml(fieldIndex, "0") + "&nbsp;";
			cell_Alias.innerHTML += getCellSortSequenceHtml(fieldIndex, "");
			
			row.appendChild(cell_Alias);
			
			
			//***************//
			//***Reference***//
			//***************//
			var cell_Reference = document.createElement("td");
			
			cell_Reference.innerHTML += getCellFieldReferenceHtml(fieldIndex, fieldValue, "");
			
			row.appendChild(cell_Reference);
			
			
			//*************//
			//***Display***//
			//*************//
			var cell_Display = document.createElement("td");
			
			//***AlineaSol Premium***//
			if ((typeof window.hasPremiumJsFeatures == 'function') && window["subQueryMode"]) {
				fieldVisible = getSubQueryVisibilityValue();
			}
			//***AlineaSol Premium***//
			
			cell_Display.innerHTML = getCellDisplayHtml(fieldIndex, fieldVisible, "");
			
			row.appendChild(cell_Display);
			
			
			//**************//
			//***Function***//
			//**************//
			var cell_Function = document.createElement("td");
			
			fieldType = fixUpFilterType(fieldType);

			switch (fieldType) {
	
				case "int":
				case "tinyint":
				case "smallint":
				case "mediumint":
				case "bigint":
				case "float":
				case "decimal":
				case "double":
				case "real":
				case "currency":
				case "enum":
				case "radioenum":
				
					cell_Function.innerHTML = getCellFunctionHtml_forEnums(fieldIndex, "", "");
					break;
				
				case "multienum":
		
					cell_Function.innerHTML = getCellFunctionHtml_forMultiEnums(fieldIndex, "", "");
					break;
					
				case "date":
				case "datetime":
				case "datetimecombo":
				case "timestamp":
				
					cell_Function.innerHTML = getCellFunctionHtml_forDates(fieldIndex, "", "");
					break;
	
				case "bool":
				case "tinyint(1)":
				
					cell_Function.innerHTML = getCellFunctionHtml_forBool(fieldIndex, "", "");
					break;
	
				default:
								
					cell_Function.innerHTML = getCellFunctionHtml_forDefault(fieldIndex, "", auditedReport, "");
					break;
	
			}
			
			cell_Function.innerHTML += getCellFunctionsConfigureSQL(new Array(), fieldValue, fieldIndex, "", new Object());
			
			//***AlineaSol Premium***//
			if (typeof window.hasPremiumJsFeatures == 'function') {
				cell_Function.innerHTML += getCellFunctionsConfigurePHP(new Array(), fieldValue, fieldIndex, "");
			}
			//***AlineaSol Premium***//
			
			row.appendChild(cell_Function);
			
			
			//*****************//
			//***Format Type***//
			//*****************//
			var cell_Format_Type = document.createElement("td");
			
			cell_Format_Type.className = "formatTypeCell";
			cell_Format_Type.innerHTML = getCellFormatTypeHtml(fieldIndex, new Object(), new Array(), fieldValue, fieldType, "");
			
			row.appendChild(cell_Format_Type);
			
			
			//******************//
			//***Layout Group***//
			//******************//
			var cell_Layout_Group = document.createElement("td");
			
			switch (fieldType) {
	
				case "date":
				case "datetime":
				case "datetimecombo":
				case "timestamp":
				
					cell_Layout_Group.innerHTML = getCellLayoutGroupHtml_forDates(fieldIndex, fieldType, "", "");
					break;
	
				default:
				
					cell_Layout_Group.innerHTML = getCellLayoutGroupHtml_forDefault(fieldIndex, "", "");
					break;
	
			}
			
			cell_Layout_Group.innerHTML += getCellGroupBySequenceHtml(fieldIndex, "");
			
			row.appendChild(cell_Layout_Group);
			
			
			//*************//
			//***Buttons***//
			//*************//
			var cell_Buttons = document.createElement("td");
			cell_Buttons.align = "right";
			
			cell_Buttons.innerHTML = getCellFieldButtonsHtml(fieldIndex, fieldType, fieldRelated, fieldKey, fieldIndex+"_"+counterField, fieldEnumOperator, fieldEnumReference, fieldValue, counterField, auditedReport, "");
			
			//***AlineaSol Premium***//
			if (typeof window.hasPremiumJsFeatures == 'function') {
				cell_Buttons.innerHTML += getTemplateInputHtml(fieldIndex, new Object());
			}
			//***AlineaSol Premium***//
			
			var numberOfRows = $(".asolReportsFieldRow").size()+1;
			cell_Buttons.innerHTML += getCellFieldArrowsHtml(fieldIndex, idTable, numberOfRows, auditedReport, "");
			
			row.appendChild(cell_Buttons);
	
			
			
			if (in_array(fieldVisible.toLowerCase(), ['no', 'html'])) {
				row.className += ' hiddenRow';
			}
			
			table.getElementsByTagName('tbody')[0].appendChild(row);
			
			fieldIndex++;
				
		}
		
    });
	
	$('#fieldsGlobalIndex').val(parseInt(fieldIndex));
	updateCharts();

}

function getCellFilterFieldHtml(filterIndex, selectedValue, isRelated, relationKey) {

	var DatabaseField = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DATABASE_FIELD');
	
	var imageTitle = DatabaseField+': '+selectedValue;
	
	if (isRelated) {
		
        var usedKeys = new Array();
        relationKey.split(";").forEach(function(currentKey, keyIndex) {
			var keyArray = currentKey.split(" ");
			usedKeys.push((keyArray.length == 3) ? keyArray[0] : currentKey); 
		});
		
		imageTitle += ' ('+usedKeys.join('::')+')';
		
	} 
	
	return '<img src="modules/asol_Reports/include_basic/images/asol_reports_database.png" title="'+imageTitle+'" style="vertical-align: text-bottom" />'
			+ '<input type="hidden" id="filter_field_'+filterIndex+'" class="filter_field" value="'+selectedValue+'" />';
	
}

function getCellFilterAliasHtml(filterIndex, selectedValue, disabledAuditInputsRow) {

	return "<input type='text' id='filter_alias_"+filterIndex+"' class='filter_alias' size='15' maxlength='' value='" + selectedValue + "' title='' "+disabledAuditInputsRow+">";

}

function getCellFilterReferenceHtml(filterIndex, selectedValue, disabledAuditInputsRow) {

	return "<input id='filter_ref_"+filterIndex+"' class='filter_ref' "+disabledAuditInputsRow+" type='text' value='" + selectedValue + "'>";
	
}

function getCellUserInputOptionsHtml(filterIndex, templateValues, dropdownValues, currentField, fieldType, disabledAuditInputsRow) {
	
	var selectedValue = getUserOptionsReadableFormat(dropdownValues);
	
	var returnedHtml = "<input id='input_opts_"+filterIndex+"' class='input_opts' type='text' value='" + selectedValue + "' "+disabledAuditInputsRow+">";
	
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	if (typeof window.hasPremiumJsFeatures == 'function') {
		if (!in_array(fieldType, ["date", "datetime", "datetimecombo", "timestamp", "bool", "tinyint(1)", "relate"])) {
			returnedHtml += getReportDropdownGeneratorHtml(templateValues, dropdownValues, currentField, filterIndex);
		}
	}
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	
	return returnedHtml;
	
}

function getCellBehaviourHtml(filterIndex, selectedValue, disabledAuditInputsRow) {

	var lbl_auto = SUGAR.language.get('asol_Reports', 'LBL_REPORT_AUTO');
	var lbl_visible = SUGAR.language.get('asol_Reports', 'LBL_REPORT_VISIBLE');
	var lbl_user_input = SUGAR.language.get('asol_Reports', 'LBL_REPORT_USER_INPUT');
	
	var cell_Behavior_HTML = "<select id='behavior_"+filterIndex+"' class='behavior' "+disabledAuditInputsRow+">";
	var behaviorValues = ["auto", "visible", "user_input"];
	var behaviorLabels = [lbl_auto, lbl_visible, lbl_user_input];
	for (x = 0; x < behaviorValues.length; x++) {
		cell_Behavior_HTML += (behaviorValues[x] == selectedValue) ? "<option value='"+behaviorValues[x]+"' selected>"+behaviorLabels[x]+"</option>" : "<option value='"+behaviorValues[x]+"'>"+behaviorLabels[x]+"</option>";
	}
	cell_Behavior_HTML += "</select>";
	return cell_Behavior_HTML;

}

function manageCellOperatorHtml_forEnum(operatorSelectId, isMultiEnum) {
	
	var operatorSelect = $("#"+operatorSelectId);
	var asolReportsFilterRow = operatorSelect.closest(".asolReportsFilterRow");

	
	if (in_array(operatorSelect.val(), ['one of', 'not one of']) || isMultiEnum) { //one of, not one of
		
		asolReportsFilterRow.find('.first_parameter_input').css('display', 'none');
		asolReportsFilterRow.find('.first_parameter_select').css('display', 'inline');
		asolReportsFilterRow.find('.first_parameter_select').attr('multiple', true);
		asolReportsFilterRow.find('.first_parameter_select').attr('size', 3);
		
	} else if (in_array(operatorSelect.val(), ['like', 'not like', 'starts with', 'ends with'])) { //like, not like, starts with, ends with
		
		asolReportsFilterRow.find('.first_parameter_input').val('');
		asolReportsFilterRow.find('.first_parameter_input').css('display', 'inline');
		asolReportsFilterRow.find('.first_parameter_select').css('display', 'none');
		asolReportsFilterRow.find('.first_parameter_select').attr('multiple', false);
		asolReportsFilterRow.find('.first_parameter_select').attr('size', 1);
		
	} else if (in_array(operatorSelect.val(), ['equals', 'not equals'])) { //equals, not equals
		
		asolReportsFilterRow.find('.first_parameter_input').css('display', 'none');
		asolReportsFilterRow.find('.first_parameter_select').css('display', 'inline');
		asolReportsFilterRow.find('.first_parameter_select').attr('multiple', false);
		asolReportsFilterRow.find('.first_parameter_select').attr('size', 1);
		
	} else if (in_array(operatorSelect.val(), ['inherit'])) { //inherit

		asolReportsFilterRow.find('.first_parameter_input').css('display', 'none');
		asolReportsFilterRow.find('.first_parameter_select').css('display', 'none');
		asolReportsFilterRow.find('.first_parameter_select_inherit').css('display', 'inline');
		
	}
	
}

function getCellOperatorHtml_forEnum(filterIndex, selectedValue, selectStyle) {

	var lbl_equals = SUGAR.language.get('asol_Reports', 'LBL_REPORT_EQUALS');
	var lbl_not_equals = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_EQUALS');
	var lbl_like = SUGAR.language.get('asol_Reports', 'LBL_REPORT_LIKE');
	var lbl_not_like = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_LIKE');
	var lbl_starts = SUGAR.language.get('asol_Reports', 'LBL_REPORT_STARTS_WITH');
	var lbl_ends = SUGAR.language.get('asol_Reports', 'LBL_REPORT_ENDS_WITH');
	var lbl_one_of = SUGAR.language.get('asol_Reports', 'LBL_REPORT_ONE_OF');
	var lbl_not_one_of = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_ONE_OF');
	var lbl_inherit = SUGAR.language.get('asol_Reports', 'LBL_REPORT_INHERIT');
	
	var cell_Operator_HTML = "<select id='filter_operator_"+filterIndex+"' class='filter_operator' style='"+selectStyle+"' onChange='manageCellOperatorHtml_forEnum(this.id, false)'>";
	var operatorValues = ["equals", "not equals", "like", "not like", "starts with", "ends with", "one of", "not one of"];
	var operatorLabels = [lbl_equals, lbl_not_equals, lbl_like, lbl_not_like, lbl_starts, lbl_ends, lbl_one_of, lbl_not_one_of];
	
	if ((typeof window.hasPremiumJsFeatures == 'function') && (window["subQueryMode"])) {
		operatorValues.push("inherit");
		operatorLabels.push(lbl_inherit);
	}
	
	for (x = 0; x < operatorValues.length; x++) {
		cell_Operator_HTML += (operatorValues[x] == selectedValue) ? "<option value='"+operatorValues[x]+"' selected>"+operatorLabels[x]+"</option>" : "<option value='"+operatorValues[x]+"'>"+operatorLabels[x]+"</option>";
	}
	cell_Operator_HTML += "</select>";
	return cell_Operator_HTML;

}

function getCellOperatorHtml_forMultiEnum(filterIndex, selectedValue, selectStyle) {

	var lbl_equals = SUGAR.language.get('asol_Reports', 'LBL_REPORT_EQUALS');
	var lbl_not_equals = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_EQUALS');
	var lbl_one_of = SUGAR.language.get('asol_Reports', 'LBL_REPORT_ONE_OF');
	var lbl_not_one_of = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_ONE_OF');
	var lbl_inherit = SUGAR.language.get('asol_Reports', 'LBL_REPORT_INHERIT');
	
	var cell_Operator_HTML = "<select id='filter_operator_"+filterIndex+"' class='filter_operator' style='"+selectStyle+"' onChange='manageCellOperatorHtml_forEnum(this.id, true)'>";
	var operatorValues = ["equals", "not equals", "one of", "not one of"];
	var operatorLabels = [lbl_equals, lbl_not_equals, lbl_one_of, lbl_not_one_of];
	
	if ((typeof window.hasPremiumJsFeatures == 'function') && (window["subQueryMode"])) {
		operatorValues.push("inherit");
		operatorLabels.push(lbl_inherit);
	}
	
	for (x = 0; x < operatorValues.length; x++) {
		cell_Operator_HTML += (operatorValues[x] == selectedValue) ? "<option value='"+operatorValues[x]+"' selected>"+operatorLabels[x]+"</option>" : "<option value='"+operatorValues[x]+"'>"+operatorLabels[x]+"</option>";
	}
	cell_Operator_HTML += "</select>";
	return cell_Operator_HTML;

}

function getCellFirstParameterHtml_forEnum(filterIndex, selectedValuesArray, enumValues, enumLabels, multipleSelect, inputStyle, selectStyle) {

	var newFilter = (selectedValuesArray === null);
	
	if ((newFilter) || (selectedValuesArray.length == 0))  {
		selectedValuesArray = new Array();
		selectedValue = "";
	} else {
		selectedValue = selectedValuesArray[0];
	}
	
	var optionsSelect = "";

	var selectionMatch = false;
	enumValues.forEach(function(entry, index) {
		selectionMatch = (in_array(entry, selectedValuesArray) || selectionMatch);
		var sel = in_array(entry, selectedValuesArray) ? " selected" : "";
		optionsSelect += "<option" + sel + " value='"+entry+"'>" + enumLabels[entry] + "</option>";
	});
	
	var cell_FirstParameter_HTML = "<select id='first_parameter_select_"+filterIndex+"' onchange='$(this).next(\"input\").val(\"\").hide();' oncontextmenu='if (typeof window.hasPremiumJsFeatures == \"function\") { return getFieldReferenceContextMenu(this); }' class='first_parameter_select' style='" + selectStyle + "' " + multipleSelect + ">" + optionsSelect + "</select>";
	
	inputStyle = ((selectionMatch || (newFilter)) ? inputStyle : 'display: inline;');
	cell_FirstParameter_HTML += "<input id='first_parameter_input_"+filterIndex+"' class='first_parameter_input "+((selectionMatch || (newFilter)) ? '' : 'inputReferenced')+"' type='text' oncontextmenu='if (typeof window.hasPremiumJsFeatures == \"function\") { return getFieldReferenceContextMenu(this); }' style='" + inputStyle + "' value='"+selectedValue+"'>";
	
	return cell_FirstParameter_HTML;
	
}

function getCellOperatorHtml_forInt(filterIndex, selectedValue, selectStyle) {

	var lbl_equals = SUGAR.language.get('asol_Reports', 'LBL_REPORT_EQUALS');
	var lbl_not_equals = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_EQUALS');
	var lbl_like = SUGAR.language.get('asol_Reports', 'LBL_REPORT_LIKE');
	var lbl_not_like = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_LIKE');
	var lbl_starts = SUGAR.language.get('asol_Reports', 'LBL_REPORT_STARTS_WITH');
	var lbl_ends = SUGAR.language.get('asol_Reports', 'LBL_REPORT_ENDS_WITH');
	var lbl_less_than = SUGAR.language.get('asol_Reports', 'LBL_REPORT_LESS_THAN');
	var lbl_more_than = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MORE_THAN');
	var lbl_inherit = SUGAR.language.get('asol_Reports', 'LBL_REPORT_INHERIT');
	
	var cell_Operator_HTML = "<select id='filter_operator_"+filterIndex+"' class='filter_operator' style='"+selectStyle+"' onChange='manageCellOperatorHtml_forInt(this.id)'>";
	var operatorValues = ["equals", "not equals", "like", "not like", "starts with", "ends with", "less than", "more than"];
	var operatorLabels = [lbl_equals, lbl_not_equals, lbl_like, lbl_not_like, lbl_starts, lbl_ends, lbl_less_than, lbl_more_than];
	
	if ((typeof window.hasPremiumJsFeatures == 'function') && (window["subQueryMode"])) {
		operatorValues.push("inherit");
		operatorLabels.push(lbl_inherit);
	}
	
	for (x = 0; x < operatorValues.length; x++) {
		cell_Operator_HTML += (operatorValues[x] == selectedValue) ? "<option value='"+operatorValues[x]+"' selected>"+operatorLabels[x]+"</option>" : "<option value='"+operatorValues[x]+"'>"+operatorLabels[x]+"</option>";
	}
	cell_Operator_HTML += "</select>";
	return cell_Operator_HTML;

}

function manageCellOperatorHtml_forInt(operatorSelectId) {
	
	var operatorSelect = $("#"+operatorSelectId);
	var asolReportsFilterRow = operatorSelect.closest(".asolReportsFilterRow");

	if (in_array(operatorSelect.val(), ['inherit'])) { //inherit

		asolReportsFilterRow.find('.first_parameter_input').css('display', 'none');
		asolReportsFilterRow.find('.first_parameter_select_inherit').css('display', 'inline');
		
	} else {
		
		asolReportsFilterRow.find('.first_parameter_input').val('');
		asolReportsFilterRow.find('.first_parameter_input').css('display', 'inline');
		asolReportsFilterRow.find('.first_parameter_select_inherit').css('display', 'none');
		
	}
	
}

function getCellFirstParameterHtml(filterIndex, selectedValuesArray, inputStyle) {
	
	if ((selectedValuesArray === null) || (selectedValuesArray.length == 0)) {
		var selectedValue = "";
	} else {
		var selectedValue = selectedValuesArray[0];
	}
	
	return "<input id='first_parameter_input_"+filterIndex+"' type='text' class='first_parameter_input' oncontextmenu='if (typeof window.hasPremiumJsFeatures == \"function\") { return getFieldReferenceContextMenu(this); }' style='"+inputStyle+"' value='" + selectedValue + "'>";

}

function getCellSecondParameterHtml(filterIndex, selectedValuesArray) {
	
	if ((selectedValuesArray === null) || (selectedValuesArray.length == 0)) {
		var selectedValue = "";
	} else {
		var selectedValue = selectedValuesArray[0];
	}

	return "<input id='second_parameter_input_"+filterIndex+"' type='text' class='second_parameter_input' oncontextmenu='if (typeof window.hasPremiumJsFeatures == \"function\") { return getFieldReferenceContextMenu(this); }' value='" + selectedValue + "' style='display:none;'>";
	
}
	
function setDateParamsVisibility(operatorSelectId) {
	
	var operatorSelect = $("#"+operatorSelectId);
	var asolReportsFilterRow = operatorSelect.closest(".asolReportsFilterRow");
	
	
	asolReportsFilterRow.find('.first_parameter_input').css('display', 'none'); //Input1
	asolReportsFilterRow.find('.first_parameter_trigger').css('display', 'none'); //Calendar1
	asolReportsFilterRow.find('.first_parameter_select').css('display', 'inline'); //Select1
	
	if (in_array(operatorSelect.val(), ['last', 'not last', 'these', 'next', 'not next'])) { //last, not last, these, next, not next

		asolReportsFilterRow.find('.second_parameter_input').css('display', 'inline'); //Input2
		asolReportsFilterRow.find('.second_parameter_trigger').css('display', 'none'); //Calendar2
		asolReportsFilterRow.find('.second_parameter_select').css('display', 'none'); //Select2
		asolReportsFilterRow.find('.parameter_span').css('display', 'none'); //Span
		asolReportsFilterRow.find('.third_parameter_input').css('display', 'none'); //Input3
		asolReportsFilterRow.find('.third_parameter_trigger').css('display', 'none'); //Calendar3
		asolReportsFilterRow.find('.third_parameter_select').css('display', 'none'); //Select3
		
		asolReportsFilterRow.find('.second_parameter_input').val(''); //Input2
		
	} else if (in_array(operatorSelect.val(), ['equals', 'not equals', 'before date', 'after date', 'between', 'not between'])) { //equals, not equals, before date, after date, between, not between
		
		asolReportsFilterRow.find('.second_parameter_input').css('display', 'inline'); //Input2
		asolReportsFilterRow.find('.second_parameter_trigger').css('display', 'inline'); //Calendar2
		asolReportsFilterRow.find('.second_parameter_select').css('display', 'none'); //Select2
		asolReportsFilterRow.find('.third_parameter_select').css('display', 'none'); //Select3

		asolReportsFilterRow.find('.second_parameter_input').val(''); //Input2
		asolReportsFilterRow.find('.third_parameter_input').val(''); //Input3
			
		if (in_array(operatorSelect.val(), ['equals', 'not equals', 'before date', 'after date'])) {

			asolReportsFilterRow.find('.parameter_span').css('display', 'none'); //Span
			asolReportsFilterRow.find('.third_parameter_input').css('display', 'none'); //Input3
			asolReportsFilterRow.find('.third_parameter_trigger').css('display', 'none'); //Calendar3
			
		} else {
			
			asolReportsFilterRow.find('.parameter_span').css('display', 'block'); //Span
			asolReportsFilterRow.find('.third_parameter_input').css('display', 'inline'); //Input3
			asolReportsFilterRow.find('.third_parameter_trigger').css('display', 'inline'); //Calendar3
			
		};

	} if (in_array(operatorSelect.val(), ['this', 'not this'])) { //this, not this
		
		asolReportsFilterRow.find('.first_parameter_input').css('display', 'none'); //Input1
		asolReportsFilterRow.find('.first_parameter_trigger').css('display', 'none'); //Calendar1
		asolReportsFilterRow.find('.second_parameter_input').css('display', 'none'); //Input2
		asolReportsFilterRow.find('.second_parameter_trigger').css('display', 'none'); //Calendar2
		asolReportsFilterRow.find('.second_parameter_select').css('display', 'none'); //Select2
		asolReportsFilterRow.find('.parameter_span').css('display', 'none'); //Span
		asolReportsFilterRow.find('.third_parameter_input').css('display', 'none'); //Input3
		asolReportsFilterRow.find('.third_parameter_trigger').css('display', 'none'); //Calendar3
		asolReportsFilterRow.find('.third_parameter_select').css('display', 'none'); //Select3
		
	};
	
	if (in_array(operatorSelect.val(), ['equals', 'not equals', 'before date', 'after date', 'between', 'not netween'])) { //equals, not equals, before date, after date, between, not netween
		
		asolReportsFilterRow.find('.second_parameter_input').attr('readonly', true); //Input2
		asolReportsFilterRow.find('.third_parameter_input').attr('readonly', true); //Input3
	
	} else {
	
		asolReportsFilterRow.find('.second_parameter_input').removeAttr('readonly'); //Input2
		asolReportsFilterRow.find('.third_parameter_input').removeAttr('readonly'); //Input3
	
	}
	
}

function manageOperatorHtml_forDate(operatorSelectId) {
	
	var operatorSelect = $("#"+operatorSelectId);
	var asolReportsFilterRow = operatorSelect.closest(".asolReportsFilterRow");
	
	setDateParamsVisibility(operatorSelectId);

	asolReportsFilterRow.find('.first_parameter_select_inherit').css('display', 'none');
	
	switch (operatorSelect.val()) {
	
		case 'equals':
		case 'not equals':
			removeSelectElements(asolReportsFilterRow.find('.first_parameter_select').attr('id'));
			insertSingleDateValues(asolReportsFilterRow.find('.first_parameter_select').attr('id'));
			break;
			
		case 'before date':
		case 'after date':
		case 'between':
		case 'not between':
			removeSelectElements(asolReportsFilterRow.find('.first_parameter_select').attr('id'));
			insertReducedSingleDateValues(asolReportsFilterRow.find('.first_parameter_select').attr('id'));
			break;

		case 'last':
		case 'not last':
			removeSelectElements(asolReportsFilterRow.find('.first_parameter_select').attr('id'));
			insertExtendedDateValues(asolReportsFilterRow.find('.first_parameter_select').attr('id'));
			insertMonthDaysValues(asolReportsFilterRow.find('.first_parameter_select').attr('id'));
			break;

		case 'this':
		case 'not this':
		case 'these':
		case 'next':
		case 'not next':
			removeSelectElements(asolReportsFilterRow.find('.first_parameter_select').attr('id'));
			insertExtendedDateValues(asolReportsFilterRow.find('.first_parameter_select').attr('id'));
			break;
		
		case "inherit":
			asolReportsFilterRow.find('.first_parameter_input').css('display', 'none');
			asolReportsFilterRow.find('.first_parameter_select').css('display', 'none');
			asolReportsFilterRow.find('.first_parameter_select_inherit').css('display', 'inline');
			asolReportsFilterRow.find('.calendarValue').css('display', 'none');
			asolReportsFilterRow.find('.calendarIcon').css('display', 'none');
			break;
			
		default:
			break;
			
	}
	
}

function getCellOperatorHtml_forDate(filterIndex, selectedValue, selectStyle) {

	var lbl_equals = SUGAR.language.get('asol_Reports', 'LBL_REPORT_EQUALS');
	var lbl_not_equals = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_EQUALS');
	var lbl_before_date = SUGAR.language.get('asol_Reports', 'LBL_REPORT_BEFORE_DATE');
	var lbl_after_date = SUGAR.language.get('asol_Reports', 'LBL_REPORT_AFTER_DATE');
	var lbl_between = SUGAR.language.get('asol_Reports', 'LBL_REPORT_BETWEEN');
	var lbl_not_between = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_BETWEEN');
	var lbl_last = SUGAR.language.get('asol_Reports', 'LBL_REPORT_LAST');
	var lbl_not_last = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_LAST');
	var lbl_this = SUGAR.language.get('asol_Reports', 'LBL_REPORT_THIS');
	var lbl_not_this = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_THIS');
	var lbl_these = SUGAR.language.get('asol_Reports', 'LBL_REPORT_THESE');
	var lbl_next = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NEXT');
	var lbl_not_next = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_NEXT');
	var lbl_inherit = SUGAR.language.get('asol_Reports', 'LBL_REPORT_INHERIT');
	
	var cell_Operator_HTML = "<select id='filter_operator_"+filterIndex+"' class='filter_operator' style='"+selectStyle+"' onChange='manageOperatorHtml_forDate(this.id)'>";			
	var operatorValues = ["equals", "not equals", "before date", "after date", "between", "not between", "last", "not last", "this", "not this", "these", "next", "not next"];
	var operatorLabels = [lbl_equals, lbl_not_equals, lbl_before_date, lbl_after_date, lbl_between, lbl_not_between, lbl_last, lbl_not_last, lbl_this, lbl_not_this, lbl_these, lbl_next, lbl_not_next];
	
	if ((typeof window.hasPremiumJsFeatures == 'function') && (window["subQueryMode"])) {
		operatorValues.push("inherit");
		operatorLabels.push(lbl_inherit);
	}
	
	for (x = 0; x < operatorValues.length; x++) {
		cell_Operator_HTML += (operatorValues[x] == selectedValue) ? "<option value='"+operatorValues[x]+"' selected>"+operatorLabels[x]+"</option>" : "<option value='"+operatorValues[x]+"'>"+operatorLabels[x]+"</option>";
	}
	cell_Operator_HTML += "</select>";
	return cell_Operator_HTML;

}
	
function manageFirstParameterHtml_forDate(firstParamSelectId) {
	
	var firstParamSelect = $("#"+firstParamSelectId);
	var asolReportsFilterRow = firstParamSelect.closest(".asolReportsFilterRow");
	
	
	if (in_array(asolReportsFilterRow.val(), ["day", "week", "month", "Nquarter", "Fquarter", "Nyear", "Fyear"])) {
		
		asolReportsFilterRow.find('.second_parameter_input').css('display', 'inline'); //Input2 
	
	} else if (!in_array(asolReportsFilterRow.find('.filter_operator').val(), ['this', 'not this'])) { 
		
		asolReportsFilterRow.find('.second_parameter_input').css('display', 'none'); //Input2 
	
	}
	
}

function getFixedEnumString_forDates(selectedValuesArray) {
	
	if (selectedValuesArray === null) {
		selectedValuesArray = new Array();
	}

	var lbl_day = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DAY');
	var lbl_week = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WEEK');
	var lbl_month = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MONTH');
	var lbl_fquarter = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FQUARTER');
	var lbl_nquarter = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NQUARTER');
	var lbl_fyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FYEAR');
	var lbl_nyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NYEAR');
	var lbl_monday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MONDAY');
	var lbl_tuesday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_TUESDAY');
	var lbl_wednesday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WEDNESDAY');
	var lbl_thursday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_THURSDAY');
	var lbl_friday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FRIDAY');
	var lbl_saturday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SATURDAY');
	var lbl_sunday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SUNDAY');
	var lbl_january = SUGAR.language.get('asol_Reports', 'LBL_REPORT_JANUARY');
	var lbl_february = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FEBRUARY');
	var lbl_march = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MARCH');
	var lbl_april = SUGAR.language.get('asol_Reports', 'LBL_REPORT_APRIL');
	var lbl_may = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MAY');
	var lbl_june = SUGAR.language.get('asol_Reports', 'LBL_REPORT_JUNE');
	var lbl_july = SUGAR.language.get('asol_Reports', 'LBL_REPORT_JULY');
	var lbl_august = SUGAR.language.get('asol_Reports', 'LBL_REPORT_AUGUST');
	var lbl_september = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SEPTEMBER');
	var lbl_october = SUGAR.language.get('asol_Reports', 'LBL_REPORT_OCTOBER');
	var lbl_november = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOVEMBER');
	var lbl_december = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DECEMBER');
	
	var fixed_str_HTML = "";
	var fixedValues = ["day", "week", "month", "Nquarter", "Fquarter", "Nyear", "Fyear", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"];
	var fixedLabels = [lbl_day, lbl_week, lbl_month, lbl_nquarter, lbl_fquarter, lbl_nyear, lbl_fyear, lbl_monday, lbl_tuesday, lbl_wednesday, lbl_thursday, lbl_friday, lbl_saturday, lbl_sunday, lbl_january, lbl_february, lbl_march, lbl_april, lbl_may, lbl_june, lbl_july, lbl_august, lbl_september, lbl_october, lbl_november, lbl_december];
	
	fixedValues.forEach(function(currentValue, position) {
		fixed_str_HTML += in_array(currentValue, selectedValuesArray) ? "<option value='"+currentValue+"' selected>"+fixedLabels[position]+"</option>" : "<option value='"+currentValue+"'>"+fixedLabels[position]+"</option>";
	});
	
	return fixed_str_HTML;
	
}

function getSingleEnumString_forDates(selectedValuesArray) {
	
	if (selectedValuesArray === null) {
		selectedValuesArray = new Array();
	}
	
	var lbl_calendar = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CALENDAR');
	var lbl_dayofweek = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DAYOFWEEK');
	var lbl_weekofyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WEEKOFYEAR');
	var lbl_monthofyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MONTHOFYEAR');
	var lbl_naturalquarterofyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NATURALQUARTEROFYEAR');
	var lbl_fiscalquarterofyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FISCALQUARTEROFYEAR');
	var lbl_naturalyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NATURALYEAR');
	var lbl_fiscalyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FISCALYEAR');

	var default_HTML = "";
	var defaultValues = ["calendar", "dayofweek", "weekofyear", "monthofyear", "naturalquarterofyear", "fiscalquarterofyear", "naturalyear", "fiscalyear"]; 
	var defaultLabels = [lbl_calendar, lbl_dayofweek, lbl_weekofyear, lbl_monthofyear, lbl_naturalquarterofyear, lbl_fiscalquarterofyear, lbl_naturalyear, lbl_fiscalyear ];
	
	defaultValues.forEach(function(currentValue, position) {
		default_HTML += in_array(currentValue, selectedValuesArray) ? "<option value='"+currentValue+"' selected>"+defaultLabels[position]+"</option>" : "<option value='"+currentValue+"'>"+defaultLabels[position]+"</option>";
	});
	
	return default_HTML;
	
}

function getReducedSingleEnumString_forDates(selectedValuesArray) {
	
	if (selectedValuesArray === null) {
		selectedValuesArray = new Array();
	}
	
	var lbl_calendar = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CALENDAR');
	var lbl_weekofyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WEEKOFYEAR');
	var lbl_naturalyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NATURALYEAR');
	var lbl_fiscalyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FISCALYEAR');

	var default_HTML = "";
	var defaultValues = ["calendar", "weekofyear", "naturalyear", "fiscalyear"]; 
	var defaultLabels = [lbl_calendar, lbl_weekofyear, lbl_naturalyear, lbl_fiscalyear ];
	
	defaultValues.forEach(function(currentValue, position) {
		default_HTML += in_array(currentValue, selectedValuesArray) ? "<option value='"+currentValue+"' selected>"+defaultLabels[position]+"</option>" : "<option value='"+currentValue+"'>"+defaultLabels[position]+"</option>";
	});
	
	return default_HTML;
	
}

function getDefaultEnumString_forDates(selectedValuesArray) {
	
	if (selectedValuesArray === null) {
		selectedValuesArray = new Array();
	}

	var lbl_day = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DAY');
	var lbl_week = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WEEK');
	var lbl_month = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MONTH');
	var lbl_fquarter = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FQUARTER');
	var lbl_nquarter = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NQUARTER');
	var lbl_fyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FYEAR');
	var lbl_nyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NYEAR');

	var default_HTML = "";
	var defaultValues = ["day", "week", "month", "Nquarter", "Fquarter", "Nyear", "Fyear"];
	var defaultLabels = [lbl_day, lbl_week, lbl_month, lbl_nquarter, lbl_fquarter, lbl_nyear, lbl_fyear];
	
	defaultValues.forEach(function(currentValue, position) {
		default_HTML += in_array(currentValue, selectedValuesArray) ? "<option value='"+currentValue+"' selected>"+defaultLabels[position]+"</option>" : "<option value='"+currentValue+"'>"+defaultLabels[position]+"</option>";
	});
	
	return default_HTML;

}

function getDayOfWeekEnumString_forDates(selectedValuesArray) {
	
	if (selectedValuesArray === null) {
		selectedValuesArray = new Array();
	}
	
	var lbl_monday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MONDAY');
	var lbl_tuesday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_TUESDAY');
	var lbl_wednesday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WEDNESDAY');
	var lbl_thursday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_THURSDAY');
	var lbl_friday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FRIDAY');
	var lbl_saturday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SATURDAY');
	var lbl_sunday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SUNDAY');
	
	var fixed_str_HTML = "";
	var fixedValues = ["0", "1", "2", "3", "4", "5", "6"];
	var fixedLabels = [lbl_monday, lbl_tuesday, lbl_wednesday, lbl_thursday, lbl_friday, lbl_saturday, lbl_sunday];
	
	fixedValues.forEach(function(currentValue, position) {
		fixed_str_HTML += "<option value='"+currentValue+"'" + (in_array(currentValue, selectedValuesArray) ? "selected " : " ") + ">"+fixedLabels[position]+"</option>";
	});
	
	return fixed_str_HTML;
	
}

function getWeekOfYearEnumString_forDates(selectedValuesArray) {
	
	if (selectedValuesArray === null) {
		selectedValuesArray = new Array();
	}
	
	var weeksInYear = 53;
	
	var fixed_str_HTML = "";
	for (x = 1; x <= weeksInYear; x++) {
		fixed_str_HTML += in_array(x, selectedValuesArray) ? "<option value='"+x+"' selected>"+x+"</option>" : "<option value='"+x+"'>"+x+"</option>";
	}
	return fixed_str_HTML;
	
}

function getMonthOfYearEnumString_forDates(selectedValuesArray) {
	
	if (selectedValuesArray === null) {
		selectedValuesArray = new Array();
	}
	
	var lbl_january = SUGAR.language.get('asol_Reports', 'LBL_REPORT_JANUARY');
	var lbl_february = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FEBRUARY');
	var lbl_march = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MARCH');
	var lbl_april = SUGAR.language.get('asol_Reports', 'LBL_REPORT_APRIL');
	var lbl_may = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MAY');
	var lbl_june = SUGAR.language.get('asol_Reports', 'LBL_REPORT_JUNE');
	var lbl_july = SUGAR.language.get('asol_Reports', 'LBL_REPORT_JULY');
	var lbl_august = SUGAR.language.get('asol_Reports', 'LBL_REPORT_AUGUST');
	var lbl_september = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SEPTEMBER');
	var lbl_october = SUGAR.language.get('asol_Reports', 'LBL_REPORT_OCTOBER');
	var lbl_november = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOVEMBER');
	var lbl_december = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DECEMBER');
	
	var fixed_str_HTML = "";
	var fixedValues = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"];
	var fixedLabels = [lbl_january, lbl_february, lbl_march, lbl_april, lbl_may, lbl_june, lbl_july, lbl_august, lbl_september, lbl_october, lbl_november, lbl_december];
	
	fixedValues.forEach(function(currentValue, position) {
		var sel = "";
		fixed_str_HTML += "<option value='"+currentValue+"'" + (in_array(currentValue, selectedValuesArray) ? "selected " : " " ) + ">"+fixedLabels[position]+"</option>";
	});
	
	return fixed_str_HTML;
	
}

function getQuarterOfYearEnumString_forDates(selectedValuesArray) {
	
	if (selectedValuesArray === null) {
		selectedValuesArray = new Array();
	}
	
	var quartersInYear = 4;
	var fixed_str_HTML = "";
	
	for (x = 1; x <= quartersInYear; x++) {
		var sel = "";
		for (y = 0; y < selectedValuesArray.length; y++) {
			var optVal = selectedValuesArray[y] ;
			if (x == optVal)
				sel = " selected";
		}
		fixed_str_HTML += "<option value='"+x+"'" + sel + ">"+x+"º</option>";
	}
	return fixed_str_HTML;
	
}

function manageFirstParameterHtml_forDate_withFixedString(firstParamSelectId) {
	
	var firstParamSelect = $("#"+firstParamSelectId);
	var asolReportsFilterRow = firstParamSelect.closest(".asolReportsFilterRow");
	var operatorSelectValue = asolReportsFilterRow.find('.filter_operator').val();

	switch (operatorSelectValue) {
	
		case "equals":
		case "not equals":

			asolReportsFilterRow.find('.second_parameter_input').val('');
			
			if (in_array(firstParamSelect.val(), ["calendar"])) {
				
				asolReportsFilterRow.find('.second_parameter_input').attr('readonly', true); //Input2
				asolReportsFilterRow.find('.second_parameter_input').css('display', 'inline'); //Input2
				asolReportsFilterRow.find('.second_parameter_trigger').css('display', 'inline'); //Trigger2
				asolReportsFilterRow.find('.second_parameter_select').css('display', 'none'); //Select2
				
			} else if (in_array(firstParamSelect.val(), ["dayofweek", "weekofyear", "weekofyear", "monthofyear", "naturalquarterofyear", "fiscalquarterofyear"])) {
				
				var fixed_str = "";
				
				switch (firstParamSelect.val()){
				
					case "dayofweek":
						asolReportsFilterRow.find('.second_parameter_select').attr('multiple', true); //Select2
						asolReportsFilterRow.find('.second_parameter_select').attr('size', 3); //Select2
						fixed_str = getDayOfWeekEnumString_forDates(null);
						break;
						
					case "weekofyear":
						asolReportsFilterRow.find('.second_parameter_select').attr('multiple', false); //Select2
						asolReportsFilterRow.find('.second_parameter_select').attr('size', 1); //Select2
						fixed_str = getWeekOfYearEnumString_forDates(null);
						break;
						
					case "monthofyear":
						asolReportsFilterRow.find('.second_parameter_select').attr('multiple', true); //Select2
						asolReportsFilterRow.find('.second_parameter_select').attr('size', 3); //Select2
						fixed_str = getMonthOfYearEnumString_forDates(null);
						break;
						
					case "naturalquarterofyear":
					case "fiscalquarterofyear":
						asolReportsFilterRow.find('.second_parameter_select').attr('multiple', true); //Select2
						asolReportsFilterRow.find('.second_parameter_select').attr('size', 3); //Select2
						fixed_str = getQuarterOfYearEnumString_forDates(null);
						break;
						
					default:
						break;
				
				}
				
				asolReportsFilterRow.find('.second_parameter_input').removeAttr('readonly'); //Input2
				asolReportsFilterRow.find('.second_parameter_input').css('display', 'none'); //Input2
				asolReportsFilterRow.find('.second_parameter_trigger').css('display', 'none'); //Trigger2
				asolReportsFilterRow.find('.second_parameter_select').html(fixed_str); //Select2
				asolReportsFilterRow.find('.second_parameter_select').css('display', 'inline'); //Select2
				
			} else {
				
				asolReportsFilterRow.find('.second_parameter_input').removeAttr('readonly'); //Input2
				asolReportsFilterRow.find('.second_parameter_input').css('display', 'inline'); //Input2
				asolReportsFilterRow.find('.second_parameter_trigger').css('display', 'none'); //Trigger2
				asolReportsFilterRow.find('.second_parameter_select').css('display', 'none'); //Select2
				
			}
			
			break;
		
		case "before date":
		case "after date":
		case "between":
		case "not between":
			
			if (in_array(firstParamSelect.val(), ["calendar"])) {
				
				asolReportsFilterRow.find('.second_parameter_input').val(''); //Input2
				asolReportsFilterRow.find('.second_parameter_input').attr('readonly', true); //Input2
				asolReportsFilterRow.find('.second_parameter_input').css('display', 'inline'); //Input2
				asolReportsFilterRow.find('.second_parameter_trigger').css('display', 'inline'); //Trigger2
				asolReportsFilterRow.find('.second_parameter_select').css('display', 'none'); //Select2
				
				if (in_array(operatorSelectValue, ["between", "not between"])) {
					
					asolReportsFilterRow.find('.third_parameter_input').val(''); //Input3
					asolReportsFilterRow.find('.third_parameter_input').attr('readonly', true); //Input3
					asolReportsFilterRow.find('.third_parameter_input').css('display', 'inline'); //Input3
					asolReportsFilterRow.find('.third_parameter_trigger').css('display', 'inline'); //Trigger3
					asolReportsFilterRow.find('.third_parameter_select').css('display', 'none'); //Select3
				
				} else {
					
					asolReportsFilterRow.find('.third_parameter_input').removeAttr('readonly'); //Input3
					asolReportsFilterRow.find('.third_parameter_input').css('display', 'none'); //Input3
					asolReportsFilterRow.find('.third_parameter_trigger').css('display', 'none'); //Trigger3
					asolReportsFilterRow.find('.third_parameter_select').css('display', 'none'); //Select3
					
				}

			} else if (in_array(firstParamSelect.val(), ["weekofyear"])) {
				
				var fixed_str = "";
				
				switch (firstParamSelect.val()){

					case "weekofyear":
						asolReportsFilterRow.find('.second_parameter_select').attr('multiple', false); //Select2
						asolReportsFilterRow.find('.second_parameter_select').attr('size', 1); //Select2
						fixed_str = getWeekOfYearEnumString_forDates(null);
						break;
					
					default:
						break;
				
				}
				
				
				asolReportsFilterRow.find('.second_parameter_input').removeAttr('readonly'); //Input2
				asolReportsFilterRow.find('.second_parameter_input').css('display','none'); //Input2
				asolReportsFilterRow.find('.second_parameter_trigger').css('display', 'none'); //Trigger2
				asolReportsFilterRow.find('.second_parameter_select').html(fixed_str); //Select2
				asolReportsFilterRow.find('.second_parameter_select').css('display', 'inline'); //Select2
				
				asolReportsFilterRow.find('.third_parameter_input').removeAttr('readonly'); //Input3
				asolReportsFilterRow.find('.third_parameter_input').css('display','none'); //Input3
				asolReportsFilterRow.find('.third_parameter_trigger').css('display', 'none'); //Trigger3
				asolReportsFilterRow.find('.third_parameter_select').html(fixed_str); //Select3
					
				if (in_array(operatorSelectValue, ["between", "not between"])) {
					
					asolReportsFilterRow.find('.third_parameter_select').css('display', 'inline'); //Select3
					
				} else {
					
					asolReportsFilterRow.find('.third_parameter_select').css('display', 'none'); //Select3
				
				}
				
			} else {
				
				asolReportsFilterRow.find('.second_parameter_input').val(''); //Input2
				asolReportsFilterRow.find('.second_parameter_input').removeAttr('readonly'); //Input2
				asolReportsFilterRow.find('.second_parameter_input').css('display','inline'); //Input2
				asolReportsFilterRow.find('.second_parameter_trigger').css('display', 'none'); //Trigger2
				asolReportsFilterRow.find('.second_parameter_select').css('display', 'none'); //Select2
				
				asolReportsFilterRow.find('.third_parameter_input').removeAttr('readonly'); //Input3
				asolReportsFilterRow.find('.third_parameter_trigger').css('display', 'none'); //Trigger3
					asolReportsFilterRow.find('.third_parameter_select').css('display', 'none'); //Select3
					
				if (in_array(operatorSelectValue, ["between", "not between"])) {

					asolReportsFilterRow.find('.third_parameter_input').css('display','inline'); //Input3
					
				} else {
					
					asolReportsFilterRow.find('.third_parameter_input').css('display','none'); //Input3

				}
				
			}
			
			break;
			
		case "last":
		case "not last":
		case "this":
		case "not this":
		case "these":
		case "next":
		case "not next":

			var monthDayValues = ["monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "march", "may", "june", "july", "august", "september", "october", "november", "december"]; 
			
			if (in_array(firstParamSelect.val(), monthDayValues)) {
				
				asolReportsFilterRow.find('.second_parameter_input').css('display', 'none'); //Input2
				
			} else if (!in_array(operatorSelectValue, ["this", "not this"])) {
				
				asolReportsFilterRow.find('.second_parameter_input').css('display', 'inline'); //Input2
				
			}
			
			break;
	
		default:
			
	}
	
}

function getCellFirstParameterHtml_forDate_withFixedString(filterIndex, selectedValuesArray, fixed_str, inputStyle, imgStyle, selectStyle) {
	
	if ((selectedValuesArray === null) || (selectedValuesArray.length == 0)) {
		var selectedValue = "";
	} else {
		var selectedValue = selectedValuesArray[0];
	}

	var cell_First_Parameter_Html = "<input type='text' id='first_parameter_input_"+filterIndex+"' value='" + selectedValue + "' oncontextmenu='if (typeof window.hasPremiumJsFeatures == \"function\") { return getFieldReferenceContextMenu(this); }' class='first_parameter_input calendarValue' style='" + inputStyle + "' disabled='true' />"
			+ "<img border='0' src='themes/default/images/jscalendar.gif' class='first_parameter_trigger calendarIcon' alt='Enter Date' id='trigger_" + filterIndex + "' ' style='" + imgStyle + "' />"
			+ "<span></span>"
			+ "<select id='first_parameter_select_"+filterIndex+"' class='first_parameter_select' style='" + selectStyle + "' onChange='manageFirstParameterHtml_forDate_withFixedString(this.id)'>" + fixed_str + "</select>";

	return cell_First_Parameter_Html;
			
}

function getCellSecondParameterHtml_forDate(filterIndex, selectedValuesArray, fixed_str, multipleSelect, inputStyle, imgStyle, selectStyle, inputReadonly) {

	if ((selectedValuesArray === null) || (selectedValuesArray.length == 0)) {
		var selectedValue = "";
	} else {
		var selectedValue = selectedValuesArray[0];
	}
	
	var cell_Second_Parameter_Html = "<input type='text' id='second_parameter_input_"+filterIndex+"' value='" + selectedValue + "' class='second_parameter_input calendarValue' oncontextmenu='if (typeof window.hasPremiumJsFeatures == \"function\") { return getFieldReferenceContextMenu(this); }' style='" + inputStyle + "' " + inputReadonly + " />" 
		+ "<img border='0' src='themes/default/images/jscalendar.gif'  class='second_parameter_trigger calendarIcon' alt='Enter Date' id='trigger2_" + filterIndex + "' style='" + imgStyle + "' />"
		+ "<select id='second_parameter_select_"+filterIndex+"' " + multipleSelect + " class='second_parameter_select' style='" + selectStyle + "'>" + fixed_str + "</select>";

	return cell_Second_Parameter_Html;
		
}

function getCellThirdParameterHtml_forDate(filterIndex, selectedValuesArray, fixed_str, multipleSelect, spanStyle, inputStyle, imgStyle, selectStyle, inputReadonly) {
	
	if ((selectedValuesArray === null) || (selectedValuesArray.length == 0)) {
		var selectedValue = "";
	} else {
		var selectedValue = selectedValuesArray[0];
	}

	var lbl_and = SUGAR.language.get('asol_Reports', 'LBL_REPORT_AND');
	
	var cell_Third_Parameter_Html = "<span class='parameter_span' style='" + spanStyle + "'>"+lbl_and+"</span><input type='text' id='third_parameter_input_"+filterIndex+"' oncontextmenu='if (typeof window.hasPremiumJsFeatures == \"function\") { return getFieldReferenceContextMenu(this); }' value='" + selectedValue + "' class='third_parameter_input calendarValue' style='" + inputStyle + "' " + inputReadonly + " />" 
		+ "<img border='0' src='themes/default/images/jscalendar.gif' class='third_parameter_trigger calendarIcon' alt='Enter Date' id='trigger3_" + filterIndex + "' style='" + imgStyle + "' />"
		+ "<select id='third_parameter_select_"+filterIndex+"' " + multipleSelect + " class='third_parameter_select' style='" + selectStyle + "'>" + fixed_str + "</select>";

	return cell_Third_Parameter_Html;
		
}

function getCellOperatorHtml_forBool(filterIndex, selectedValue, selectStyle) {

	var lbl_equals = SUGAR.language.get('asol_Reports', 'LBL_REPORT_EQUALS');
	var lbl_not_equals = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_EQUALS');
	var lbl_inherit = SUGAR.language.get('asol_Reports', 'LBL_REPORT_INHERIT');
	
	var cell_Operator_HTML = "<select id='filter_operator_"+filterIndex+"' class='filter_operator' style='"+selectStyle+"'>";
	var operatorValues = ["equals", "not equals"];
	var operatorLabels = [lbl_equals, lbl_not_equals];
	
	if ((typeof window.hasPremiumJsFeatures == 'function') && (window["subQueryMode"])) {
		operatorValues.push("inherit");
		operatorLabels.push(lbl_inherit);
	}
	
	for (x = 0; x < operatorValues.length; x++) {
		cell_Operator_HTML += (operatorValues[x] == selectedValue) ? "<option value='"+operatorValues[x]+"' selected>"+operatorLabels[x]+"</option>" : "<option value='"+operatorValues[x]+"'>"+operatorLabels[x]+"</option>";
	}
	cell_Operator_HTML += "</select>";
	return cell_Operator_HTML;
	
}

function getCellFirstParameterHtml_forBool(filterIndex, selectedValue, disabledAuditInputsRow, selectStyle) {
	
	var lbl_true = SUGAR.language.get('asol_Reports', 'LBL_REPORT_TRUE');
	var lbl_false = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FALSE');

	var cell_First_Parameter_HTML = "<select id='first_parameter_select_"+filterIndex+"' class='first_parameter_select' "+disabledAuditInputsRow+">";
	var firstParameterValues = ["true", "false"];
	var firstParameterLabels = [lbl_true, lbl_false];
	for (x = 0; x < firstParameterValues.length; x++) {
		cell_First_Parameter_HTML += (firstParameterValues[x] == selectedValue) ? "<option value='"+firstParameterValues[x]+"' selected>"+firstParameterLabels[x]+"</option>" : "<option value='"+firstParameterValues[x]+"'>"+firstParameterLabels[x]+"</option>";
	}
	cell_First_Parameter_HTML += "</select>";
	return cell_First_Parameter_HTML;
	
}

function manageCellDefaultOperatorHtml(defaultOperatorSelectId) {
	
	var operatorSelect = $("#"+defaultOperatorSelectId);
	var asolReportsFilterRow = operatorSelect.closest(".asolReportsFilterRow");
	
	if (operatorSelect.val() == 'my items') {
		
		asolReportsFilterRow.find('.first_parameter_input').css('display', 'none');
		asolReportsFilterRow.find('.first_parameter_select_inherit').css('display', 'none');
		
	} else if (operatorSelect.val() == 'inherit') {
		
		asolReportsFilterRow.find('.first_parameter_input').css('display', 'none');
		asolReportsFilterRow.find('.first_parameter_select_inherit').css('display', 'inline');
		
	} else {
		
		asolReportsFilterRow.find('.first_parameter_input').css('display', 'inline');
		asolReportsFilterRow.find('.first_parameter_select_inherit').css('display', 'none');
		
	} 
	
}

function getCellOperatorHtml_forDefault(filterIndex, selectedValue, currentFilterField, selectStyle) {

	var lbl_equals = SUGAR.language.get('asol_Reports', 'LBL_REPORT_EQUALS');
	var lbl_not_equals = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_EQUALS');
	var lbl_like = SUGAR.language.get('asol_Reports', 'LBL_REPORT_LIKE');
	var lbl_not_like = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOT_LIKE');
	var lbl_starts = SUGAR.language.get('asol_Reports', 'LBL_REPORT_STARTS_WITH');
	var lbl_ends = SUGAR.language.get('asol_Reports', 'LBL_REPORT_ENDS_WITH');
	var lbl_my_items = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MY_ITEMS');
	var lbl_inherit = SUGAR.language.get('asol_Reports', 'LBL_REPORT_INHERIT');
	
	var cell_Operator_HTML = "<select id='filter_operator_"+filterIndex+"' class='filter_operator' style='"+selectStyle+"' onChange='manageCellDefaultOperatorHtml(this.id);'>";
	var operatorValues = ["equals", "not equals", "like", "not like", "starts with", "ends with"];
	var operatorLabels = [lbl_equals, lbl_not_equals, lbl_like, lbl_not_like, lbl_starts, lbl_ends];

	if (in_array(currentFilterField.split(".").pop(), ['created_by', 'modified_user_id', 'assigned_user_id', 'reports_to_id'])) {
		operatorValues.push('my items');
		operatorLabels.push(lbl_my_items);
	}
	
	if ((typeof window.hasPremiumJsFeatures == 'function') && (window["subQueryMode"])) {
		operatorValues.push("inherit");
		operatorLabels.push(lbl_inherit);
	}
	
	for (x = 0; x < operatorValues.length; x++) {
		cell_Operator_HTML += (operatorValues[x] == selectedValue) ? "<option value='"+operatorValues[x]+"' selected>"+operatorLabels[x]+"</option>" : "<option value='"+operatorValues[x]+"'>"+operatorLabels[x]+"</option>";
	}
	cell_Operator_HTML += "</select>";
	return cell_Operator_HTML;

}

function getCellLogicalParametersHtml(filterIndex, logicalParametersArray, disabledAuditInputsRow) {

	if ((typeof logicalParametersArray == 'undefined') || (logicalParametersArray === null)) {
		logicalParametersArray = new Object();
		logicalParametersArray.operator = "";
		logicalParametersArray.parenthesis = "0";
	}
	
	var lbl_and = SUGAR.language.get('asol_Reports', 'LBL_REPORT_AND');
	var lbl_or = SUGAR.language.get('asol_Reports', 'LBL_REPORT_OR');
	
	var cell_LogicalParameters_HTML = "";
	
	cell_LogicalParameters_HTML += "<select id='filter_parenthesis_"+filterIndex+"' class='filter_parenthesis' "+disabledAuditInputsRow+">";
	var parenthesisValues = ["0", "1", "2", "3", "-1", "-2", "-3"];
	var parenthesisLabels = ["", "(", "((", "(((", "..)", "..))", "..)))"];
	for (x = 0; x < parenthesisValues.length; x++) {
		cell_LogicalParameters_HTML += (parenthesisValues[x] == logicalParametersArray.parenthesis) ? "<option value='"+parenthesisValues[x]+"' selected>"+parenthesisLabels[x]+"</option>" : "<option value='"+parenthesisValues[x]+"'>"+parenthesisLabels[x]+"</option>";
	}
	cell_LogicalParameters_HTML += "</select>&nbsp;";
	
	//cell_LogicalParameters_HTML += "<b>"+String.fromCharCode(parseInt(filterIndex) + 65 )+"</b>&nbsp;";
	
	cell_LogicalParameters_HTML += "<select id='filter_logical_operator_"+filterIndex+"' class='filter_logical_operator' "+disabledAuditInputsRow+">";
	var logicValues = ["", "AND", "OR"];
	var logicLabels = ["", lbl_and, lbl_or];
	for (x = 0; x < logicValues.length; x++) {
		cell_LogicalParameters_HTML += (logicValues[x] == logicalParametersArray.operator) ? "<option value='"+logicValues[x]+"' selected>"+logicLabels[x]+"</option>" : "<option value='"+logicValues[x]+"'>"+logicLabels[x]+"</option>";
	}
	cell_LogicalParameters_HTML += "</select>";
	
	return cell_LogicalParameters_HTML;
	
}

function getCellFilterButtonsHtml(filterIndex, fieldType, isRelated, i, enumOperator, enumReference, hiddenAuditButtonsRow) {

	var DeleteButton = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DELETE_FILTER');
	var DeleteFilterAlert = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DELETE_FILTER_ALERT');
	
	var cell_Button_HTML = "<img class='asol_icon clickable' "+hiddenAuditButtonsRow+" src='modules/asol_Reports/include_basic/images/asol_reports_delete.png' title=\""+DeleteButton+"\" onClick='if(confirm(\""+DeleteFilterAlert +" \" + $(this).closest(\".asolReportsFilterRow\").find(\".filter_alias\").val())) { $(this).closest(\".asolReportsFilterRow\").remove(); }' value='Delete Filter'>"
		+ "<input type='hidden' id='filter_value_type_"+filterIndex+"' class='filter_value_type' value='" + fieldType + "'>"
		+ "<input type='hidden' id='filter_is_related_"+filterIndex+"' class='filter_is_related' value='" + isRelated + "'>"
		+ "<input type='hidden' id='filter_index_"+filterIndex+"' class='filter_index' value='" + i + "'>"
		+ "<input type='hidden' id='filter_enum_operator_"+filterIndex+"' class='filter_enum_operator' value='" + ((typeof enumOperator === 'undefined') ? '' : enumOperator) + "'>"
		+ "<input type='hidden' id='filter_enum_reference_"+filterIndex+"' class='filter_enum_reference' value='" + ((typeof enumReference === 'undefined') ? '' : enumReference) + "'>";
		
	return cell_Button_HTML;
	
}

function getCellFilterArrowsHtml(filterIndex, idTable, index, auditedReport, hiddenAuditButtonsRow) {

	var cell_Arrows_HTML = "<input type='hidden' id='filterNumber_"+index+"' value='"+index+"'>"
		+ "<input type='hidden' id='filterIndex_"+index+"' value='"+filterIndex+"'>";

	return cell_Arrows_HTML;
	
}

function showFilteringDialog(button, idTable, fieldReference, auditedReport) {
	
	var isFunctionFilter = ($(fieldReference).find(".function").val() !== '0');
	var numberOfGroups = $(".asolReportsFieldRow").find(".layout_group").map(function(){ return (in_array(this.value, ['Grouped', 'Hour Grouped', 'Day Grouped', 'DoW Grouped', 'WoY Grouped', 'Month Grouped', 'Natural Quarter Grouped', 'Fiscal Quarter Grouped', 'Natural Year Grouped', 'Fiscal Year Grouped']) ? 1 : 0); }).get().reduce(function(prev, cur) { return prev + cur; });

	if (isFunctionFilter && numberOfGroups > 0) {
		
		$('#asolReportFilteringDiv').show().position({
			my: "right top",
			at: "left top",
			of: button
		});
		
		$('#asolReportFilteringDiv #whereButton').unbind("click").click(function() {
			$('#asolReportFilteringDiv').hide();
			InsertFilters(idTable, fieldReference, auditedReport, "asolReportsFilterWhere");
	    });
		
	    $('#asolReportFilteringDiv #havingButton').unbind("click").click(function() {
	    	$('#asolReportFilteringDiv').hide();
	    	InsertFilters(idTable, fieldReference, auditedReport, "asolReportsFilterHaving");
	    });
	    
	    $('html').unbind("click").click(function(event) {
	    	if (!$(event.target).hasClass('addReportsFilterIcon') && !$(event.target).hasClass('filteringDiv')) {
	    		$("#asolReportFilteringDiv").hide();
	    	}
	    });
	    
	} else {
		
		$("#asolReportFilteringDiv").hide();
		InsertFilters(idTable, fieldReference, auditedReport, "asolReportsFilterWhere");
		
	}
	
}

function updateFilters(functionReference) {

	if (functionReference.value === "0") {

		var field = $(functionReference).closest(".asolReportsFieldRow").find(".field").val();
		var index = $(functionReference).closest(".asolReportsFieldRow").find(".index").val();

		$(".asolReportsFilterHaving .asolReportsFilterRow").each(function() {
			if ((field === $(this).find(".filter_field").val()) && (index === $(this).find(".filter_index").val())) {
				if (confirm(SUGAR.language.get('asol_Reports', 'LBL_REPORT_HAVING_FILTER_DELETE_ALERT')) == true) {
					$("#filters_Table tbody.asolReportsFilterWhere").append($(this));
				} else {
					$(this).remove();
				}
			}
		});
		
	}
	
}

function InsertFilters(idTable, fieldReference, auditedReport, addFilterPanel) {
	
	//*********************//
    //***FieldReferences***//
    //*********************//
	var idField = $(fieldReference).find(".field").val();
	var aliasField = $(fieldReference).find(".alias").val();
	var fieldType = $(fieldReference).find(".value_type").val();
	var fieldFunction = $(fieldReference).find(".function").val();
	var isRelated = ($(fieldReference).find(".is_related").val() === 'true');	
	var relationKey = $(fieldReference).find(".key").val();
	var index = $(fieldReference).find(".index").val();
	var enumOperator = $(fieldReference).find(".enum_operator").val();
	var enumReference = $(fieldReference).find(".enum_reference").val();
	

	
	var filterIndex = $('#filtersGlobalIndex').val();
	
    var table = document.getElementById(idTable);
	
    var row = document.createElement("tr");
    row.setAttribute("class", "oddListRowS1 asolReportsFilterRow");
    row.setAttribute("onmouseout", "highlightAssociatedRows(this, 'filter', false);");
	row.setAttribute("onmouseover", "highlightAssociatedRows(this, 'filter', true);");		

    //*****************//
    //***MultiRemove***//
    //*****************//
    var cell_MultiRemove = document.createElement("td");
    cell_MultiRemove.className = "center";
    
    cell_MultiRemove.innerHTML = getCellMultiRemoveHtml();
    
    row.appendChild(cell_MultiRemove);
	
    
    //***********************//
    //***Logical Operators***//
    //***********************//
    var cell_Logical_Operators = document.createElement("td");
    
    cell_Logical_Operators.innerHTML = getCellLogicalParametersHtml(filterIndex, null, "");
    
    row.appendChild(cell_Logical_Operators);
    
    
    //***********//
    //***Alias***//
    //***********//
    var cell_Alias = document.createElement("td");
    
    cell_Alias.innerHTML = getCellFilterFieldHtml(filterIndex, idField, isRelated, relationKey) + "&nbsp;";
    cell_Alias.innerHTML += getCellFilterAliasHtml(filterIndex, aliasField, "");
    
    if (typeof window.hasPremiumJsFeatures == 'function') {
		cell_Alias.innerHTML += getMultiLanguageField('', filterIndex);
	}
    
    row.appendChild(cell_Alias);
    
    
    //***************//
    //***Reference***//
    //***************//
    var cell_Ref = document.createElement("td");
    
    cell_Ref.innerHTML = getCellFilterReferenceHtml(filterIndex, idField);
	
    row.appendChild(cell_Ref);
    
        
    //**************//
    //***Behavior***//
    //**************//
    var cell_Behavior = document.createElement("td");
    
    cell_Behavior.className = "behaviorCell";
    cell_Behavior.innerHTML = getCellBehaviourHtml(filterIndex, "", "");
    
    row.appendChild(cell_Behavior);
    
    
    //**********************//
    //***UserInputOptions***//
    //**********************//
    var cell_UserInputOptions = document.createElement("td");
    
    cell_UserInputOptions.innerHTML = getCellUserInputOptionsHtml(filterIndex, new Array(), new Array(), idField, fieldType, "");
	
    row.appendChild(cell_UserInputOptions);
    
    
    //**************************//
    //***Operator & Filtering***//
    //**************************//
    var cell_Operator = document.createElement("td");
    var cell_First_Parameter = document.createElement("td");
    var cell_Second_Parameter = document.createElement("td");
    
	fieldType = fixUpFilterType(fieldType);
	
    switch (fieldType) {

		case "enum":
		case "radioenum":		
			
			var options_db = new Array();
			var options = new Object();
			
			if (!in_array(enumReference, ['', undefined])) {

				var dropdown = SUGAR.language.get('app_list_strings', enumReference);
				
				for (var key in dropdown) {
					options_db.push(key);
					options[key] = dropdown[key];
				}
				
			}
			
			cell_Operator.innerHTML = getCellOperatorHtml_forEnum(filterIndex, "");
            cell_First_Parameter.innerHTML = getCellFirstParameterHtml_forEnum(filterIndex, null, options_db, options, '', 'display:none;', 'display:inline;'); 
			cell_Second_Parameter.innerHTML = getCellSecondParameterHtml(filterIndex, null);
			break;

		case "multienum":		
			
			var options_db = new Array();
			var options = new Object();
			
			if (!in_array(enumReference, ['', undefined])) {

				var dropdown = SUGAR.language.get('app_list_strings', enumReference);
				
				for (var key in dropdown) {
					options_db.push(key);
					options[key] = dropdown[key];
				}
				
			}
			
			cell_Operator.innerHTML = getCellOperatorHtml_forMultiEnum(filterIndex, "");
            cell_First_Parameter.innerHTML = getCellFirstParameterHtml_forEnum(filterIndex, null, options_db, options, 'multiple size=3', 'display:none;', 'display:inline;'); 
			cell_Second_Parameter.innerHTML = getCellSecondParameterHtml(filterIndex, null);
			break;
			
		case "int":
		case "tinyint":
		case "smallint":
		case "mediumint":
		case "bigint":
		case "decimal":
		case "double":
		case "real":
		case "currency":
	
			cell_Operator.innerHTML = getCellOperatorHtml_forInt(filterIndex, "");
            cell_First_Parameter.innerHTML = getCellFirstParameterHtml(filterIndex, null);
            cell_Second_Parameter.innerHTML = getCellSecondParameterHtml(filterIndex, null);
            break;

		case "date":
		case "datetime":
		case "datetimecombo":
		case "timestamp":
							
			cell_Operator.innerHTML = getCellOperatorHtml_forDate(filterIndex, "", "display:inline;");
			var fixed_str = getSingleEnumString_forDates(null);
            cell_First_Parameter.innerHTML = getCellFirstParameterHtml_forDate_withFixedString(filterIndex, null, fixed_str, 'display:none;', 'display:none;', 'display:inline;');
            cell_Second_Parameter.innerHTML = getCellSecondParameterHtml_forDate(filterIndex, null, "", "", "display:inline;", "display:inline;", 'display:none;', "readonly") + getCellThirdParameterHtml_forDate(filterIndex, null, "", "", "display:none;", "display:none;", "display:none;", 'display:none;', "readonly");
            break;

		case "bool":
		case "tinyint(1)":
	
			cell_Operator.innerHTML = getCellOperatorHtml_forBool(filterIndex, "");
			cell_First_Parameter.innerHTML = getCellFirstParameterHtml_forBool(filterIndex, "", "");
            cell_Second_Parameter.innerHTML = getCellSecondParameterHtml(filterIndex, null);
            break;

		default:	
							
			cell_Operator.innerHTML = getCellOperatorHtml_forDefault(filterIndex, "", idField, "");		
            cell_First_Parameter.innerHTML = getCellFirstParameterHtml(filterIndex, null);
            cell_Second_Parameter.innerHTML = getCellSecondParameterHtml(filterIndex, null);
            break;

    }
    
    
	//***AlineaSol Premium***//
	if (typeof window.hasPremiumJsFeatures == 'function') {
		if (!in_array(fieldType, ["date", "datetime", "datetimecombo", "timestamp", "bool", "tinyint(1)", "relate"])) {
			cell_Operator.innerHTML += getCellOperatorHtml_forDropdownGenerator(filterIndex, '', 'display: none;');
			cell_First_Parameter.innerHTML += getCellFirstParameterHtml_forDropdownGenerator(filterIndex, null, new Array(), new Array(), '${dollar}', '', 'display:none;');			
		}
		cell_First_Parameter.innerHTML += getCellFirstParameterHtml_forInherit('', '', filterIndex, fieldType, 'display: none;');
	}
	//***AlineaSol Premium***//
    
	row.appendChild(cell_Operator);
    row.appendChild(cell_First_Parameter);
    row.appendChild(cell_Second_Parameter);
    
    
	//*************//
	//***Buttons***//
	//*************//
	var cell_Button = document.createElement("td");
    cell_Button.align = "right";

    cell_Button.innerHTML = getCellFilterButtonsHtml(filterIndex, fieldType, relationKey, index, enumOperator, enumReference, "");


	//***AlineaSol Premium***//
    if (typeof window.hasPremiumJsFeatures == 'function') {
		cell_Button.innerHTML += getTemplateInputHtml(filterIndex, new Object());
	}
	//***AlineaSol Premium***//
    
    var numberOfRows = $("#filters_Table tr.asolReportsFilterRow").size()+1;
	cell_Button.innerHTML += getCellFilterArrowsHtml(filterIndex, idTable, numberOfRows, auditedReport, "");
	
	row.appendChild(cell_Button);

	
	table.getElementsByClassName(addFilterPanel)[0].appendChild(row);	
	
	
    Calendar.setup ({ inputField : "first_parameter_input_"+filterIndex , daFormat : window["cal_date_format"], button : "trigger_"+filterIndex , singleClick : true, dateStr : '', step : 1, weekNumbers:false });
    Calendar.setup ({ inputField : "second_parameter_input_"+filterIndex , daFormat : window["cal_date_format"], button : "trigger2_"+filterIndex , singleClick : true, dateStr : '', step : 1, weekNumbers:false });
    Calendar.setup ({ inputField : "third_parameter_input_"+filterIndex , daFormat : window["cal_date_format"], button : "trigger3_"+filterIndex , singleClick : true, dateStr : '', step : 1, weekNumbers:false });
    
    $('#filtersGlobalIndex').val(parseInt(filterIndex)+1);

}

function removeSelectElements(selectObjectId, initIndex, endIndex) {
	
	var options = $('#'+selectObjectId+" option");
	
	initIndex = (typeof initIndex === "undefined") ? 0 : initIndex;
	endIndex = (typeof endIndex === "undefined") ? options.size() : endIndex;
	
	for(var i=initIndex; i<endIndex; i++) {
		options[i].remove();
	}
	
}

function insertMonthDaysValues(selectObjectId) {

	var selectObject = document.getElementById(selectObjectId);
	
	var lbl_monday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MONDAY');
	var lbl_tuesday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_TUESDAY');
	var lbl_wednesday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WEDNESDAY');
	var lbl_thursday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_THURSDAY');
	var lbl_friday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FRIDAY');
	var lbl_saturday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SATURDAY');
	var lbl_sunday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SUNDAY');
	var lbl_january = SUGAR.language.get('asol_Reports', 'LBL_REPORT_JANUARY');
	var lbl_february = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FEBRUARY');
	var lbl_march = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MARCH');
	var lbl_april = SUGAR.language.get('asol_Reports', 'LBL_REPORT_APRIL');
	var lbl_may = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MAY');
	var lbl_june = SUGAR.language.get('asol_Reports', 'LBL_REPORT_JUNE');
	var lbl_july = SUGAR.language.get('asol_Reports', 'LBL_REPORT_JULY');
	var lbl_august = SUGAR.language.get('asol_Reports', 'LBL_REPORT_AUGUST');
	var lbl_september = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SEPTEMBER');
	var lbl_october = SUGAR.language.get('asol_Reports', 'LBL_REPORT_OCTOBER');
	var lbl_november = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NOVEMBER');
	var lbl_december = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DECEMBER');

	var options = ["monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"]; 
	var optionsLabels = [lbl_monday, lbl_tuesday, lbl_wednesday, lbl_thursday, lbl_friday, lbl_saturday, lbl_sunday, lbl_january, lbl_february, lbl_march, lbl_april, lbl_may, lbl_june, lbl_july, lbl_august, lbl_september, lbl_october, lbl_november, lbl_december];

	for (var i=0; i<options.length; i++) {
	
		var optNew = document.createElement('option');
		optNew.text = optionsLabels[i];
		optNew.value = options[i];

		try {
			selectObject.add(optNew, null); // standards compliant; doesn't work in IE
		} catch(ex) {
			selectObject.add(optNew); // IE only
		}
	
	}

}

function insertExtendedDateValues(selectObjectId) {

	var selectObject = document.getElementById(selectObjectId);
	
	var lbl_day = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DAY');
	var lbl_week = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WEEK');
	var lbl_month = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MONTH');
	var lbl_fquarter = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FQUARTER');
	var lbl_nquarter = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NQUARTER');
	var lbl_fyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FYEAR');
	var lbl_nyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NYEAR');

	var options = ["day", "week", "month", "Nquarter", "Fquarter", "Nyear", "Fyear"]; 
	var optionsLabels = [lbl_day, lbl_week, lbl_month, lbl_nquarter, lbl_fquarter, lbl_nyear, lbl_fyear ];
	
	for (var i=0; i<options.length; i++) {
	
		var optNew = document.createElement('option');
		optNew.text = optionsLabels[i];
		optNew.value = options[i];

		try {
			selectObject.add(optNew, null); // standards compliant; doesn't work in IE
		} catch(ex) {
			selectObject.add(optNew); // IE only
		}
	
	}
	
}

function insertReducedSingleDateValues(selectObjectId) {

	var selectObject = document.getElementById(selectObjectId);
	
	var lbl_calendar = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CALENDAR');
	var lbl_weekofyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WEEKOFYEAR');
	var lbl_naturalyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NATURALYEAR');
	var lbl_fiscalyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FISCALYEAR');

	var options = ["calendar", "weekofyear", "naturalyear", "fiscalyear"]; 
	var optionsLabels = [lbl_calendar, lbl_weekofyear, lbl_naturalyear, lbl_fiscalyear ];
	
	for (var i=0; i<options.length; i++) {
	
		var optNew = document.createElement('option');
		optNew.text = optionsLabels[i];
		optNew.value = options[i];

		try {
			selectObject.add(optNew, null); // standards compliant; doesn't work in IE
		} catch(ex) {
			selectObject.add(optNew); // IE only
		}
	
	}
	
}

function insertSingleDateValues(selectObjectId) {

	var selectObject = document.getElementById(selectObjectId);
	
	var lbl_calendar = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CALENDAR');
	var lbl_dayofweek = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DAYOFWEEK');
	var lbl_weekofyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WEEKOFYEAR');
	var lbl_monthofyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MONTHOFYEAR');
	var lbl_naturalquarterofyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NATURALQUARTEROFYEAR');
	var lbl_fiscalquarterofyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FISCALQUARTEROFYEAR');
	var lbl_naturalyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_NATURALYEAR');
	var lbl_fiscalyear = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FISCALYEAR');

	var options = ["calendar", "dayofweek", "weekofyear", "monthofyear", "naturalquarterofyear", "fiscalquarterofyear", "naturalyear", "fiscalyear"]; 
	var optionsLabels = [lbl_calendar, lbl_dayofweek, lbl_weekofyear, lbl_monthofyear, lbl_naturalquarterofyear, lbl_fiscalquarterofyear, lbl_naturalyear, lbl_fiscalyear ];
	
	for (var i=0; i<options.length; i++) {
	
		var optNew = document.createElement('option');
		optNew.text = optionsLabels[i];
		optNew.value = options[i];

		try {
			selectObject.add(optNew, null); // standards compliant; doesn't work in IE
		} catch(ex) {
			selectObject.add(optNew); // IE only
		}
	
	}
	
}

function getCellTaskHtml(taskIndex, selectedValue) {
	
	return "<input type='text' id='task_name_"+taskIndex+"' class='task_name' size='30' maxlength='' value='" + selectedValue + "' title='' >";
	
}

function manageCellRangeHtml(rangeSelectId) {
		
	var rangeSelect = $("#"+rangeSelectId);
	var asolReportsTaskRow = rangeSelect.closest(".asolReportsTaskRow");
	
	
	if (rangeSelect.val() == 'monthly') {
		
		asolReportsTaskRow.find('.range_week_value').css('display', 'none');
		asolReportsTaskRow.find('.range_day_value').css('display', 'inline');
	
	} else if (rangeSelect.val() == 'weekly') {
		
		asolReportsTaskRow.find('.range_week_value').css('display', 'inline');
		asolReportsTaskRow.find('.range_day_value').css('display', 'none');
			
	} else if (rangeSelect.val() == 'daily') {
		
		asolReportsTaskRow.find('.range_week_value').css('display', 'none');
		asolReportsTaskRow.find('.range_day_value').css('display', 'none');
			
	} 
	
}

function getCellRangeHtml(taskIndex, selectedValue) {

	var lbl_monthly = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MONTHLY');
	var lbl_weekly = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WEEKLY');
	var lbl_daily = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DAILY');
	
	var cell_Range_HTML = "<select id='execution_range_"+taskIndex+"' class='execution_range' onChange='manageCellRangeHtml(this.id)'>";
	var rangeValues = ["monthly", "weekly", "daily"];
	var rangeLabels = [lbl_monthly, lbl_weekly, lbl_daily];
	for (x = 0; x < rangeValues.length; x++) {
		cell_Range_HTML += (rangeValues[x] == selectedValue) ? "<option value='"+rangeValues[x]+"' selected>"+rangeLabels[x]+"</option>" : "<option value='"+rangeValues[x]+"'>"+rangeLabels[x]+"</option>";
	}
	cell_Range_HTML += "</select>";
	return cell_Range_HTML;
	
}

function getCellDayHtml(taskIndex, selectedValueDay, selectedValueWeek, dayStyle, weekStyle) {

	var lbl_monday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MONDAY');
	var lbl_tuesday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_TUESDAY');
	var lbl_wednesday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_WEDNESDAY');
	var lbl_thursday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_THURSDAY');
	var lbl_friday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_FRIDAY');
	var lbl_saturday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SATURDAY');
	var lbl_sunday = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SUNDAY');

	var cell_Day_Parameter_HTML = "<select id='range_day_value_"+taskIndex+"' class='range_day_value' style='"+dayStyle+"'>";
	var dayValues = ["1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","20","21","22","23","24","25","26","27","28","29","30","31"];
	var dayLabels = ["01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","20","21","22","23","24","25","26","27","28","29","30","31"];
	for (x = 0; x < dayValues.length; x++) {
		cell_Day_Parameter_HTML += (dayValues[x] == selectedValueDay) ? "<option value='"+dayValues[x]+"' selected>"+dayLabels[x]+"</option>" : "<option value='"+dayValues[x]+"'>"+dayLabels[x]+"</option>";
	}
	cell_Day_Parameter_HTML += "</select>";
	
	cell_Day_Parameter_HTML += "<select id='range_week_value_"+taskIndex+"' class='range_week_value' style='"+weekStyle+"'>";
	var weekValues = ["1", "2", "3", "4", "5", "6", "7"];
	var weekLabels = [lbl_monday, lbl_tuesday, lbl_wednesday, lbl_thursday, lbl_friday, lbl_saturday, lbl_sunday];
	for (x = 0; x < weekValues.length; x++) {
		cell_Day_Parameter_HTML += (weekValues[x] == selectedValueWeek) ? "<option value='"+weekValues[x]+"' selected>"+weekLabels[x]+"</option>" : "<option value='"+weekValues[x]+"'>"+weekLabels[x]+"</option>";
	}
	cell_Day_Parameter_HTML += "</select>";
	
	return cell_Day_Parameter_HTML;

}

function getCellTimeHtml(taskIndex, selectedValue) {

	var selectedValueHour = selectedValue.split(",")[0];
	var selectedValueMinute = selectedValue.split(",")[1];
	
	var cell_Time_Parameter_HTML = "<select id='range_hour_value_"+taskIndex+"' class='range_hour_value'>";
	var hourValues = ["00","01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","20","21","22","23"];
	var hourLabels = ["00","01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","20","21","22","23"];
	for (x = 0; x < hourValues.length; x++) {
		cell_Time_Parameter_HTML += (hourValues[x] == selectedValueHour) ? "<option value='"+hourValues[x]+"' selected>"+hourLabels[x]+"</option>" : "<option value='"+hourValues[x]+"'>"+hourLabels[x]+"</option>";
	}
	cell_Time_Parameter_HTML += "</select><span style='font-weight:bold'>:</span>";
	
	cell_Time_Parameter_HTML += "<select id='range_minute_value_"+taskIndex+"' class='range_minute_value'>";
	var minuteValues = ["00","05","10","15","20","25","30","35","40","45","50","55"];
	var minuteLabels = ["00","05","10","15","20","25","30","35","40","45","50","55"];
	for (x = 0; x < minuteValues.length; x++) {
		cell_Time_Parameter_HTML += (minuteValues[x] == selectedValueMinute) ? "<option value='"+minuteValues[x]+"' selected>"+minuteLabels[x]+"</option>" : "<option value='"+minuteValues[x]+"'>"+minuteLabels[x]+"</option>";
	}
	cell_Time_Parameter_HTML += "</select>";
		
	return cell_Time_Parameter_HTML;

}
	
function getCellRangeEndDateHtml(taskIndex, selectedValue) {	

	return "<input type='text' id='range_end_date_"+taskIndex+"' class='range_end_date calendarValue'  value='" + selectedValue + "' disabled=true>" + "<img border='0' class='calendarIcon' src='themes/default/images/jscalendar.gif' alt='Enter Date' id='range_end_date_trigger_"+taskIndex+"'>";
	
}

function getCellStateHtml(taskIndex, selectedValue) {	
	
	var lbl_active = SUGAR.language.get('asol_Reports', 'LBL_REPORT_ACTIVE');
	var lbl_inactive = SUGAR.language.get('asol_Reports', 'LBL_REPORT_INACTIVE');
	
	var cell_State_HTML = "<select id='task_state_"+taskIndex+"' class='task_state' class='task_state'>";
	var stateValues = ["active", "inactive"];
	var stateLabels = [lbl_active, lbl_inactive];
	for (x = 0; x < stateValues.length; x++) {
		cell_State_HTML += (stateValues[x] == selectedValue) ? "<option value='"+stateValues[x]+"' selected>"+stateLabels[x]+"</option>" : "<option value='"+stateValues[x]+"'>"+stateLabels[x]+"</option>";
	}
	cell_State_HTML += "</select>";
	
	return cell_State_HTML;
	
}

function getCellTaskButtonsHtml() {	
	
	var DeleteButton = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DELETE_TASK');
	var DeleteTaskAlert = SUGAR.language.get('asol_Reports', 'LBL_REPORT_DELETE_TASK_ALERT');
	
	var cell_Buttons_Html = "<img class='asol_icon clickable' src='modules/asol_Reports/include_basic/images/asol_reports_delete.png' title=\""+DeleteButton+"\" onClick='if(confirm(\""+DeleteTaskAlert +" \" + $(this).closest(\".asolReportsTaskRow\").find(\".task_name\").val())) {  $(this).closest(\".asolReportsTaskRow\").remove(); }'>";
	return cell_Buttons_Html;
	
}

function insertTask(idTable) {

	var taskIndex = $('#tasksGlobalIndex').val();
	
    var table = document.getElementById(idTable);
    var row = document.createElement("tr");
    row.setAttribute("class", "oddListRowS1 asolReportsTaskRow");

    var cell_MultiRemove = document.createElement("td");
    cell_MultiRemove.className = "center";
    var cell_Task = document.createElement("td");
    var cell_Range = document.createElement("td");
    var cell_Day_Parameter = document.createElement("td");
    var cell_Time_Parameter = document.createElement("td");
    var cell_End_Date = document.createElement("td");
    var cell_State = document.createElement("td");
    var cell_Button = document.createElement("td");
    cell_Button.align = "right";

    cell_MultiRemove.innerHTML = getCellMultiRemoveHtml();
    cell_Task.innerHTML = getCellTaskHtml(taskIndex, "");				
	cell_Range.innerHTML = getCellRangeHtml(taskIndex, "");
	cell_Day_Parameter.innerHTML = getCellDayHtml(taskIndex, '', '', 'display: inline;', 'display: none;');
	cell_Time_Parameter.innerHTML = getCellTimeHtml(taskIndex, "");
    cell_End_Date.innerHTML = getCellRangeEndDateHtml(taskIndex, "", table.getElementsByTagName("tr").length);
	cell_State.innerHTML = getCellStateHtml(taskIndex, "");
    cell_Button.innerHTML = getCellTaskButtonsHtml();

    row.appendChild(cell_MultiRemove);
    row.appendChild(cell_Task);
    row.appendChild(cell_Range);
    row.appendChild(cell_Day_Parameter);
    row.appendChild(cell_Time_Parameter);
    row.appendChild(cell_End_Date);
    row.appendChild(cell_State);
    row.appendChild(cell_Button);

    table.getElementsByTagName('tbody')[0].appendChild(row);

    Calendar.setup ({ inputField : "range_end_date_"+taskIndex , daFormat : window["cal_date_format"], button : "range_end_date_trigger_"+taskIndex , singleClick : true, dateStr : '', step : 1, weekNumbers:false });

    $('#tasksGlobalIndex').val(parseInt(taskIndex)+1);
    
}

function getCellChartXAxisHtml(chartIndex, selectedValue, fieldIndex, isMainChart)
{
	var detail = false,
		detailField = null,
		fieldIndexArray = (fieldIndex != undefined) ? fieldIndex.split(",") : "",
		selectedValue	= (selectedValue != undefined) ? selectedValue : "";

	if( isMainChart )
	{
		$(".asolReportsFieldRow").each( function(index) 
		{
			var currentGroup = $(this).find('.layout_group').val();
			
			if( in_array(currentGroup, ['Detail', 'Minute Detail', 'Quarter Hour Detail', 'Hour Detail', 'Day Detail', 'DoW Detail', 'WoY Detail', 'Month Detail', 'Natural Quarter Detail', 'Fiscal Quarter Detail', 'Natural Year Detail', 'Fiscal Year Detail']) )
			{
				detail = true;
				
				detailField = this;
				
				return false;
			}
		});
		
		var cell_Chart_XAxis_HTML = "<select "+ ((detail) ? "disabled" : "multiple size=3") +" id='chart_xaxis_"+chartIndex+"' class='chart_xaxis' onChange='updateChartFunction(this.id);' >";
		
		if( detail )
		{
			var currentFunction = $(detailField).find('.function').val();
			var currentField = $(detailField).find('.field').val();
			var currentAlias = $(detailField).find('.alias').val();
			var currentIndex = $(detailField).find('.index').val();
			
			var currentKey = count_function_fields(currentIndex, currentField) + 1;
			
			cell_Chart_XAxis_HTML += "<option value='"+currentField+"' function='"+currentFunction+"' index='"+currentIndex+"' key='"+currentKey+"' selected>"+currentAlias+"</option>";
		}
		else
		{
			$(".asolReportsFieldRow").each( function(index)
			{
				var currentType = $(this).find('.layout_group').val();
				var currentFunction = $(this).find('.function').val();
				var currentField = $(this).find('.field').val();
				var currentAlias = $(this).find('.alias').val();
				var currentIndex = $(this).find('.index').val();
				
				var currentKey = count_function_fields(currentIndex, currentField) + 1;
				
				var selectedOption = (($.inArray(currentField, selectedValue) >= 0) ? true : false) && (($.inArray(currentIndex, fieldIndexArray) >= 0) ? true : false);
				
				if( in_array(currentType, ['Grouped', 'Hour Grouped', 'Day Grouped', 'DoW Grouped', 'WoY Grouped', 'Month Grouped', 'Natural Quarter Grouped', 'Fiscal Quarter Grouped', 'Natural Year Grouped', 'Fiscal Year Grouped']) )
				{
					if( selectedValue === "" )
						cell_Chart_XAxis_HTML += "<option value='"+currentField+"' function='"+currentFunction+"' index='"+currentIndex+"' key='"+currentKey+"' selected>"+currentAlias+"</option>";
					else
						cell_Chart_XAxis_HTML += (selectedOption) ? "<option value='"+currentField+"' function='"+currentFunction+"' index='"+currentIndex+"' key='"+currentKey+"' selected>"+currentAlias+"</option>" : "<option value='"+currentField+"' function='"+currentFunction+"' index='"+currentIndex+"' key='"+currentKey+"'>"+currentAlias+"</option>";
				}
			});
		}
		
		cell_Chart_XAxis_HTML += "</select>";
	}
	else
	{
		var cell_Chart_XAxis_HTML = "<select  id='chart_xaxis_"+chartIndex+"' class='chart_xaxis' onChange='updateChartFunction(this.id);' disabled></select>";
	}
	
	return cell_Chart_XAxis_HTML;
}

function getCellChartYAxisHtml(chartIndex, selectedValue, fieldIndex, yAxisSide, isMainChart) {
	
	var label_left_axis = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_LEFT_AXIS');
	var label_right_axis = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_RIGHT_AXIS');
	
	var cell_Chart_YAxis_HTML = "<select id='chart_yaxis_"+chartIndex+"' class='chart_yaxis' onChange='updateChartFunction(this.id); if (typeof window.hasPremiumJsFeatures == \"function\") { applyChartsRestrictions(); }'>";

	cell_Chart_YAxis_HTML += (selectedValue == "") ? "<option value='' function='' selected></option>" : "<option value='' function='' ></option>";
	
	$(".asolReportsFieldRow").each(function(index) {
		
		var currentFunction = $(this).find('.function').val();
		var currentType = $(this).find('.value_type').val();
		var currentField = $(this).find('.field').val();
		var currentAlias = $(this).find('.alias').val();
		var currentIndex = $(this).find('.index').val();

		var currentKey = count_function_fields(currentIndex, currentField) + 1;

		if ((currentFunction !== '0') || (in_array(currentType, ['int', 'bigint', 'decimal', 'double', 'currency'])))  {
			cell_Chart_YAxis_HTML += ((selectedValue == currentField) && (fieldIndex == currentIndex)) ? "<option value='"+currentField+"' function='"+currentFunction+"' index='"+currentIndex+"' key='"+currentKey+"' selected>"+currentAlias+"</option>" : "<option value='"+currentField+"' function='"+currentFunction+"' index='"+currentIndex+"' key='"+currentKey+"'>"+currentAlias+"</option>";
		}
		
	});
	
	cell_Chart_YAxis_HTML += "</select>";
	
	
	if ((yAxisSide == undefined) || (yAxisSide === null) || (yAxisSide.length == 0)) {
		var yAxisSide = "left";
	}
	
	cell_Chart_YAxis_HTML += "<input type='hidden' id='y_axis_side_"+chartIndex+"' class='y_axis_side' value='"+yAxisSide+"' /> "; // DO NOT DELETE trailing whitespace
	if (!isMainChart) {
		cell_Chart_YAxis_HTML += 
			"<img " + (yAxisSide == 'left' ? "" : "style='display: none;' ") + "class='y_axis_left_side middle clickable' src='modules/asol_Reports/include_basic/images/asol_reports_left_axis.png' title='"+label_left_axis+"' />"
			+ "<img " + (yAxisSide == 'right' ? "" : "style='display: none;' ") + "class='y_axis_right_side middle clickable' src='modules/asol_Reports/include_basic/images/asol_reports_right_axis.png' title='"+label_right_axis+"' />";
	}
	
	return cell_Chart_YAxis_HTML;
	
}

function getCellChartNameHtml(chartIndex, selectedValue) {	

	return "<input value='"+selectedValue+"' class='chart_name' />";

}

function getCellChartReferenceHtml(chartIndex, selectedValue) {

	return "<input class='chart_ref' type='text' value='" + (typeof(selectedValue) == 'undefined' ? '' : selectedValue) + "'>";
	
}

function getCellChartDisplayHtml(chartIndex, selectedValue, disabledAuditInputsRow, isMainChart) {

	var label_visible = SUGAR.language.get('asol_Reports', 'LBL_REPORT_VISIBLE');
	var label_hidden = SUGAR.language.get('asol_Reports', 'LBL_REPORT_HIDDEN');
	
	if (selectedValue != 'no') {
		selectedValue = 'yes';
	}
	
	var cell_Display_HTML = "<input type='hidden' class='chart_display' name='chart_display' value='"+selectedValue+"' "+disabledAuditInputsRow+">";
	
	cell_Display_HTML += 
		"<img " + (selectedValue == 'yes' ? "" : "style='display: none;' ") + (isMainChart ? "class='chart_visible clickable' " : "class='subchart_visible clickable' ") + "src='modules/asol_Reports/include_basic/images/asol_reports_visible.png' title='"+label_visible+"' />"
		+ "<img " + (selectedValue == 'no' ? "" : "style='display: none;' ") + (isMainChart ? "class='chart_hidden clickable' " : "class='subchart_hidden clickable' ") + "src='modules/asol_Reports/include_basic/images/asol_reports_hidden.png' title='"+label_hidden+"' />";

	return cell_Display_HTML;
	
}

function getInputChartFunctionHtml(chartIndex, chartFunction, index, isRelated, chartNum) {

	chartNum = (typeof chartNum === "undefined") ? 1 : chartNum;
	chartFunction = chartFunction.replace("&lt;b&gt;","").replace("&lt;/b&gt;","");
	
	return "<input type='hidden' id='chart_function_"+chartIndex+"' class='chart_function' value='"+chartFunction+"'>";

}

function getCellChartTypeHtml(chartIndex, chartEngine, selectedValue, halfChart, xAxis, xIndex, index, zIndex, chartNum) {
	
	chartNum = (typeof chartNum === "undefined") ? 1 : chartNum; 
	
	xAxis = (xAxis != undefined ) ? xAxis : "";
	xIndex = (xIndex != undefined ) ? xIndex : "";
	halfChart = (halfChart != undefined) ? halfChart : "no";
	
	var lbl_pie = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_PIE');
	var lbl_donut = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_DONUT');
	var lbl_bar = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_BAR');
	var lbl_stack = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_STACK');
	var lbl_horizontal = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_HORIZONTAL');
	var lbl_line = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_LINE');
	var lbl_scatter = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_SCATTER');
	var lbl_area = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_AREA');
	var lbl_funnel = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_FUNNEL');
	
	var cell_Type_HTML = "<select id='chart_type_"+chartIndex+"' class='chart_type' onChange='if (typeof window.hasPremiumJsFeatures == \"function\") { applyChartsRestrictions(); }'>";

	if (chartEngine === 'nvd3') {
		var typeValues = ["bar", "pie", "donut", "stack", "horizontal", "line", "scatter", "area"];
		var typeLabels = [lbl_bar, lbl_pie, lbl_donut, lbl_stack, lbl_horizontal, lbl_line, lbl_scatter, lbl_area];
		
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			var lbl_bubble = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_BUBBLE');
			typeValues.push('bubble');
			typeLabels.push(lbl_bubble);
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		
	} else if (chartEngine === 'html5') {
		var typeValues = ["bar", "pie", "stack", "horizontal", "line", "funnel"];
		var typeLabels = [lbl_bar, lbl_pie, lbl_stack, lbl_horizontal, lbl_line, lbl_funnel];
	} else if (chartEngine === 'flash') {
		var typeValues = ["bar", "pie", "stack", "horizontal", "line"];
		var typeLabels = [lbl_bar, lbl_pie, lbl_stack, lbl_horizontal, lbl_line];
	}
	
	
	for (x = 0; x < typeValues.length; x++) {
		cell_Type_HTML += (typeValues[x] == selectedValue) ? "<option value='"+typeValues[x]+"' selected>"+typeLabels[x]+"</option>" : "<option value='"+typeValues[x]+"'>"+typeLabels[x]+"</option>";
	}
	cell_Type_HTML += "</select>";
	
	if( xAxis === "" )
	{
		$(".asolReportsFieldRow").each( function(index)
		{
			var currentType = $(this).find('.layout_group').val();
			var currentFunction = $(this).find('.function').val();
			var currentField = $(this).find('.field').val();
			var currentAlias = $(this).find('.alias').val();
			var currentIndex = $(this).find('.index').val();
					
			var currentKey = count_function_fields(currentIndex, currentField) + 1;
					
			if( in_array(currentType, ['Grouped', 'Hour Grouped', 'Day Grouped', 'DoW Grouped', 'WoY Grouped', 'Month Grouped', 'Natural Quarter Grouped', 'Fiscal Quarter Grouped', 'Natural Year Grouped', 'Fiscal Year Grouped']) )
			{
				xIndex = xIndex + "," + currentIndex;
			}
		});
		
		xIndex = xIndex.slice(1, xIndex.length);
	}
	
	cell_Type_HTML += "<input type='hidden' id='chart_xIndex_"+chartIndex+"' class='chart_xIndex' value='"+xIndex+"'>";
	
	cell_Type_HTML += "<input type='hidden' id='chart_index_"+chartIndex+"' class='chart_index' value='"+index+"'>";
	
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	if (typeof window.hasPremiumJsFeatures == 'function') {
		cell_Type_HTML += "<input type='hidden' id='chart_zIndex_"+chartIndex+"' class='chart_zIndex' value='"+zIndex+"'>";
	}
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	
	cell_Type_HTML += "<input type='hidden' class='chart_number' name='chart_number' value='"+chartNum+"'>";
	
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	if (typeof window.hasPremiumJsFeatures == 'function' && chartEngine === 'nvd3' ) 
	{
		cell_Type_HTML += getHalfChart(halfChart);
	}
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	
	return cell_Type_HTML;
}


function resetChartTypes(chartEngine) {
	
	var lbl_pie = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_PIE');
	var lbl_donut = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_DONUT');
	var lbl_bar = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_BAR');
	var lbl_stack = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_STACK');
	var lbl_horizontal = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_HORIZONTAL');
	var lbl_line = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_LINE');
	var lbl_scatter = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_SCATTER');
	var lbl_funnel = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_FUNNEL');
	var lbl_area = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_AREA');
	
	$(".asolReportsChartRow").each(function(index) {
		
		var selectedValue = $(this).find('.chart_type').val();

		var cell_Type_HTML = "";
		
		if (chartEngine === 'nvd3') {
			var typeValues = ["bar", "pie", "donut", "stack", "horizontal", "line", "scatter", "area"];
			var typeLabels = [lbl_bar, lbl_pie, lbl_donut, lbl_stack, lbl_horizontal, lbl_line, lbl_scatter, lbl_area];
			
			//***********************//
			//***AlineaSol Premium***//
			//***********************//
			if (typeof window.hasPremiumJsFeatures == 'function') {
				var lbl_bubble = SUGAR.language.get('asol_Reports', 'LBL_REPORT_CHARTS_BUBBLE');
				typeValues.push('bubble');
				typeLabels.push(lbl_bubble);
			}
			//***********************//
			//***AlineaSol Premium***//
			//***********************//
			
		} else if (chartEngine === 'html5') {
			var typeValues = ["bar", "pie", "stack", "horizontal", "line", "funnel"];
			var typeLabels = [lbl_bar, lbl_pie, lbl_stack, lbl_horizontal, lbl_line, lbl_funnel];
		} else if (chartEngine === 'flash') {
			var typeValues = ["bar", "pie", "stack", "horizontal", "line"];
			var typeLabels = [lbl_bar, lbl_pie, lbl_stack, lbl_horizontal, lbl_line];
		}
		
		for (x = 0; x < typeValues.length; x++) {
			cell_Type_HTML += (typeValues[x] == selectedValue) ? "<option value='"+typeValues[x]+"' selected>"+typeLabels[x]+"</option>" : "<option value='"+typeValues[x]+"'>"+typeLabels[x]+"</option>";
		}
		
		$(this).find('.chart_type').html(cell_Type_HTML);
		
		
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			applyChartsRestrictions();
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
	});
	
}

		
function insertChart(idTable) {
	
	var reportChartsEngine = $('#report_charts_engine').val();
	var chartCurrentIndex = $('#chartsGlobalIndex').val();
	var emptyChart = getDefaultChart();
	
	var chartsTable = document.getElementById(idTable);
	var chartsGroup = document.createElement("tbody");
	chartsGroup.setAttribute("class", "asolReportsChartsGroup");
	
	var chartRow = getChartRow(emptyChart.data, emptyChart.config, reportChartsEngine, chartCurrentIndex, true);

	chartsGroup.appendChild(chartRow);
	chartsTable.appendChild(chartsGroup);
    
    $('#chartsGlobalIndex').val(parseInt(chartCurrentIndex)+1);
	
}

function updateCharts() {
	
	$(".asolReportsChartRow").each(function(index) {
		
		var selectedValueX = $(this).find('.chart_xaxis').val();
		
		var selectedValueY = $(this).find('.chart_yaxis').val();
		
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			var selectedValueZ = $(this).find('.chart_zaxis').val();
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		
		var chartCurrentNumber = $(this).find('.chart_number').val();
		
		var chartCurrentXIndex = $(this).find('.chart_xIndex').val();
		
		var chartCurrentIndex = $(this).find('.chart_index').val();
		
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			var chartCurrentZIndex = $(this).find('.chart_zIndex').val();
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		
		var yAxisSide = $(this).find('.y_axis_side').val();
		var isMainChart = $(this).hasClass('asolReportsMainChart');
		
		$(this).find('.chart_xaxis').replaceWith(getCellChartXAxisHtml(chartCurrentNumber, selectedValueX, chartCurrentXIndex, isMainChart));
	
		$(this).find('.chart_yaxis').html(getCellChartYAxisHtml(chartCurrentNumber, selectedValueY, chartCurrentIndex, yAxisSide, isMainChart));
		
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			$(this).find('.chart_zaxis').html(getCellChartZAxisHtml(chartCurrentNumber, selectedValueZ, chartCurrentZIndex));
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		
		var selectedFieldFunction = $(this).find('.chart_yaxis option:selected').attr("function");
		$(this).find('.chart_function').val(selectedFieldFunction);

	});
	
}

function updateChartFunction(chartId) {
	
	var currentChartFunction = $('#'+chartId).closest('.asolReportsChartRow').find('.chart_yaxis option:selected').attr('function');
	$('#'+chartId).closest('.asolReportsChartRow').find('.chart_function').val(currentChartFunction);
	
	var currentChartIndex = $('#'+chartId).closest('.asolReportsChartRow').find('.chart_yaxis option:selected').attr('index');
	
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	if (typeof window.hasPremiumJsFeatures == 'function') {
		var currentChartZIndex = $('#'+chartId).closest('.asolReportsChartRow').find('.chart_zaxis option:selected').attr('index');
	}
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	
	var currentChartXIndex = $.map( $('#'+chartId).closest('.asolReportsChartRow').find('.chart_xaxis option:selected'), function(val,i) { return($(val).attr('index')); } );
	
	var currentChartKey = $('#'+chartId).closest('.asolReportsChartRow').find('.chart_yaxis option:selected').attr('key');
	
	$('#'+chartId).closest('.asolReportsChartRow').find('.chart_xIndex').val(currentChartXIndex);
	
	$('#'+chartId).closest('.asolReportsChartRow').find('.chart_index').val(currentChartIndex);
	
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	if (typeof window.hasPremiumJsFeatures == 'function') {
		$('#'+chartId).closest('.asolReportsChartRow').find('.chart_zIndex').val(currentChartZIndex);
	}
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	
	$('#'+chartId).closest('.asolReportsChartRow').find('.chart_number').val(currentChartKey);
	
}

function generateUniqueString(usedStrings, originalString, readableFormat) {

	if (usedStrings.indexOf(originalString) == -1) {
		return originalString;
	}

	var numRepeats = 0;
	for(var i=0; i<usedStrings.length; i++) {
		if (usedStrings[i] == originalString) {
			numRepeats++;
		}
	}

	if ((readableFormat != undefined) && (readableFormat == true)) {
		originalString += " ("+(numRepeats+1)+")";
	} else {
		originalString += "_"+(numRepeats+1);
	}

	return generateUniqueString(usedStrings, originalString, readableFormat);

}

function formatFields(includeConfig) {

	var refList = new Array();
	
	// Object building
	var jsonFields = new Object();
	
	jsonFields['tables'] = new Array();
	jsonFields['tables'][0] = new Object();
	jsonFields['tables'][0]['data'] = new Array();
	
	if (includeConfig) {
	
		var tableConfigArray = getDefaultTableConfig();
		
		// Fields config
		var finalConfigJson = $('#tableConfiguration').val();
		if (finalConfigJson.length > 0) {
			customConfigArray = window.JSON.parse(unescape(finalConfigJson));
			tableConfigArray = overwriteAttributes(tableConfigArray, customConfigArray);
		}
	
		jsonFields['tables'][0]['config'] = tableConfigArray;
		// Fields config
		
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			var reportJoins = $("#asolReportsJoinTableConfig").val();
			jsonFields['tables'][0]['css'] = $(".configureCssStoredValue").val().replace(/'/gi, "&#039;");
			var reportTemplates = $("#reportTemplates").val();
			jsonFields['tables'][0]['templates'] = (reportTemplates == '' ? new Array() : window.JSON.parse(unescape(reportTemplates)));
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
	
	}
	
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	if (typeof window.hasPremiumJsFeatures == 'function') {
		var reportJoins = $("#asolReportsJoinTableConfig").val();
		jsonFields['tables'][0]['joins'] = (reportJoins == '' ? new Object() : window.JSON.parse(reportJoins));
	}
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
		
	var aliasList = new Array();
		
	$(".asolReportsFieldRow").each(function(index) {
		
		var jsonField = new Object();
		
		var originalAlias = $(this).find(".alias").val();
		var uniqueAlias = generateUniqueString(aliasList, originalAlias, true);
		
		aliasList.push(originalAlias);
		if (uniqueAlias != originalAlias) {
			aliasList.push(uniqueAlias); // Avoids duplicating generated names			
		}
		
		jsonField['field'] = $(this).find(".field").val();
		jsonField['alias'] = uniqueAlias;
		
		
		// Field reference
		var originalRef = $(this).find(".field_ref").val().replace(/\s/g, "");
		var fieldRef = "";
		
		if (originalRef.length > 0) {
			fieldRef = generateUniqueString(refList, originalRef, false);
			refList.push(originalRef);
			if (fieldRef != originalRef) {
				refList.push(fieldRef); // Avoids duplicating generated references			
			}
		}
		
		$(this).find(".field_ref").val(fieldRef);
		
		jsonField['fieldReference'] = fieldRef.replace(/[:]/g, '');
		
		
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			var reportLanguage = $(this).find(".language").val();
			jsonField['language'] = (reportLanguage == '' ? new Array() : window.JSON.parse(reportLanguage));
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
			
		jsonField['visible'] = $(this).find(".display").val();
		jsonField['sortDirection'] = $(this).find(".sort_dir").val();
		jsonField['sortOrder'] = $(this).find(".sort_seq").val();
		jsonField['function'] = $(this).find(".function").val();
		jsonField['sql'] = $(this).find(".configureSqlStoredValue").val().replace(/'/gi, "&#039;");
		
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			jsonField['subQuery'] = new Object();
			jsonField['subQuery']['module'] = $(this).find(".configureSubReportModule").val();
			jsonField['subQuery']['audited'] = $(this).find(".configureSubReportAudited").val();
			jsonField['subQuery']['fields'] = $(this).find(".configureSubReportFields").val();
			jsonField['subQuery']['filters'] = $(this).find(".configureSubReportFilters").val();
			if ($(this).find(".configurePhpStoredValue").length) {
				jsonField['php'] = $(this).find(".configurePhpStoredValue").val().replace(/'/gi, "&#039;");
			}
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		
		var format = new Object();
		format['type'] = $(this).find(".format_type").val();
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			var formatExtra = $(this).find(".extra_format").val();
			format['extra'] = (((typeof formatExtra != 'undefined') && (formatExtra != 'hasTemplate')) ? window.JSON.parse(formatExtra) : new Array());
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//		
		jsonField['format'] = format;
		
		jsonField['grouping'] = $(this).find(".layout_group").val();
		jsonField['groupingOrder'] = $(this).find(".group_seq").val();
		jsonField['type'] = $(this).find(".value_type").val();
		jsonField['key'] = $(this).find(".key").val();
		jsonField['isRelated'] = ($(this).find(".is_related").val() === 'true');
		jsonField['index'] = $(this).find(".index").val();
		jsonField['enumOperator'] = $(this).find(".enum_operator").val();
		jsonField['enumReference'] = $(this).find(".enum_reference").val();
			
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			var fieldTemplates = $(this).find(".templates").val();
			jsonField['templates'] = (reportTemplates == '' ? new Array() : window.JSON.parse(unescape(fieldTemplates)));
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		
		jsonFields['tables'][0]['data'][index] = jsonField;
		
	});
	
	jsonFields['version'] = window["reportsVersion"];
	
	var jsonString = window.JSON.stringify(jsonFields);
	
    return jsonString;
    
}

function formatFilters(includeConfig, includeEnums) {

	var aliasList = new Array();
	var refList = new Array();
	
	// Object building
	var jsonFilters = new Object();
	jsonFilters['data'] = new Array();
	
	if (includeConfig) {
		
		// Filters config
		var finalConfigArray = getDefaultFiltersConfig();
		
		var customConfigJson = $('#filtersConfiguration').val();
		if (customConfigJson.length > 0) {
			customConfigArray = window.JSON.parse(customConfigJson);
			finalConfigArray = overwriteAttributes(finalConfigArray, customConfigArray);
		}
	
		jsonFilters['config'] = finalConfigArray;
		// Filters config
	
	}

	$(".asolReportsFilterRow").each(function(index) {
		
		// Field associated to filter
		var associatedField = $(this).find('.filter_field').val();

		//  Filter operator
		var filterOperator = $(this).find(".filter_operator").val();
		
		// Filter data type
		var dataType = $(this).find(".filter_value_type").val();
		
		// First parameter
		if (filterOperator == "inherit") {
			
			var firstParameter =  $(this).find(".first_parameter_select_inherit").val();
			var firstParametersArray = new Array();
			firstParametersArray.push(firstParameter);
			
		} else {

			if ((in_array(dataType, ["enum", "radioenum", "multienum"])) && (in_array(filterOperator, ["equals", "not equals", "one of", "not one of"]))) {
				if ($(this).find(".first_parameter_input.inputReferenced:visible").length > 0) {
					var firstParametersArray = new Array();
					firstParametersArray.push($(this).find(".first_parameter_input").val());
				} else {
					var firstParametersArray = $(this).find(".first_parameter_select option:selected").map(function(){ return this.value; }).get();
				}
			} else if (in_array(dataType, ["tinyint(1)", "bool"])) {
				var firstParameter =  $(this).find(".first_parameter_select").val();
				var firstParametersArray = new Array();
				firstParametersArray.push(firstParameter);
			} else if ((in_array(dataType, ["date", "datetime", "datetimecombo", "timestamp"])) && (in_array(filterOperator, ["equals", "not equals", "before date", "after date", "between", "not between", "last", "this", "these", "next", "not last", "not this", "not next"]))) {
				var firstParameter =  $(this).find(".first_parameter_select").val();
				var firstParametersArray = new Array();
				firstParametersArray.push(firstParameter);
			} else {
				var firstParameter =  $(this).find(".first_parameter_input").val();
				var firstParametersArray = new Array();
				firstParametersArray.push(firstParameter);
			}
			
		}
		
		// Second and third parameter 
		if (in_array(filterOperator, ["equals", "not equals", "before date", "after date", "between", "not between"]) && in_array(dataType, ["date", "datetime", "datetimecombo", "timestamp"])) {
			if ((in_array(filterOperator, ["equals", "not equals", "before date", "after date"])) && (in_array(firstParametersArray[0], ["dayofweek", "weekofyear", "monthofyear", "naturalquarterofyear", "fiscalquarterofyear"]))) {
				var secondParametersArray = $(this).find(".second_parameter_select option:selected").map(function(){ return this.value }).get();
				var thirdParametersArray = new Array();
			} else if (in_array(filterOperator, ["between", "not between"])) {
				if (in_array(firstParametersArray[0], ["weekofyear"])) {
					var secondParameter = $(this).find(".second_parameter_select").val();
					var secondParametersArray = new Array();
					if (secondParameter.length > 0)
						secondParametersArray.push(secondParameter);
					var thirdParameter = $(this).find(".third_parameter_select").val();
					var thirdParametersArray = new Array();
					thirdParametersArray.push(thirdParameter);
				} else {
					var secondParameter = $(this).find(".second_parameter_input").val();
					var secondParametersArray = new Array();
					if (secondParameter.length > 0)
						secondParametersArray.push(secondParameter);
					var thirdParameter = $(this).find(".third_parameter_input").val();
					var thirdParametersArray = new Array();
					thirdParametersArray.push(thirdParameter);
				}
			} else {
				var secondParameter = $(this).find(".second_parameter_input").val();
				var secondParametersArray = new Array();
				if (secondParameter.length > 0)
					secondParametersArray.push(secondParameter);
				var thirdParametersArray = new Array();
			}
		} else {
			var secondParameter = $(this).find(".second_parameter_input").val();
			var secondParametersArray = new Array();
			if (secondParameter.length > 0)
				secondParametersArray.push(secondParameter);
			var thirdParametersArray = new Array();
		}
		
		// Related fields
		var relationKey = $(this).find(".filter_is_related").val();
		var isRelated = (relationKey.length > 0);
		
		// Filter index
		var filterIndex = $(this).find(".filter_index").val();
		
		// Enumeration operator
		var enumOperator = $(this).find(".filter_enum_operator").val();
		
		// Enumeration reference
		var enumRef = $(this).find(".filter_enum_reference").val();
		
		// Filter behavior
		var behavior = $(this).find(".behavior").val();
		
		// Filter reference
		var originalRef = $(this).find(".filter_ref").val().replace(/\s/g, "");
		var filterRef = "";
		
		if ((behavior == 'user_input') && (originalRef.length == 0)) {
			originalRef = "ref";
		}
		
		if (originalRef.length > 0) {
			filterRef = generateUniqueString(refList, originalRef, false);
			refList.push(originalRef);
			if (filterRef != originalRef) {
				refList.push(filterRef); // Avoids duplicating generated references			
			}
		}
		
		$(this).find(".filter_ref").val(filterRef);
		
		// Filter alias
		var originalAlias = $(this).find(".filter_alias").val();
		var filterAlias = "";
		if (originalAlias.length > 0) {
			filterAlias = generateUniqueString(aliasList, originalAlias, true);
			
			aliasList.push(originalAlias);
			if (filterAlias != originalAlias) {
				aliasList.push(filterAlias); // Avoids duplicating generated names			
			}
		}
		
		$(this).find(".filter_alias").val(filterAlias);
		
		// User options			
		if (typeof window.hasPremiumJsFeatures == 'function') {
			var optsExtended = $(this).find(".input_opts_extended").val();
			var userOptions = (((typeof optsExtended === 'undefined') || (optsExtended == 'hasTemplate')) ? new Array() : window.JSON.parse(optsExtended));
		} else {
			var userOptions = getUserOptionsObject($(this).find(".input_opts").val());		
		}
		
		// Logical operators
		var logicalParenthesis = $(this).find(".filter_parenthesis").val();
		var logicalOperator = $(this).find(".filter_logical_operator").val();
		
		
		// Mapping
		jsonFilter = new Object();
		
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			var reportTemplates = $(this).find(".templates").val();
			jsonFilter['templates'] = (reportTemplates == '' ? new Array() : window.JSON.parse(unescape(reportTemplates)));
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		
		
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			// Operator and first parameter overriding (enterprise)
			if (!in_array(dataType, ["date", "datetime", "datetimecombo", "timestamp", "bool", "tinyint(1)", "relate"])) {
				if ((userOptions.length > 0) || (jsonFilter['templates'].hasOwnProperty('enum'))) {
					filterOperator = $(this).find(".filter_operator_dropdown_generator").val();
					firstParametersArray = $(this).find(".first_parameter_select_dropdown_generator option:selected").map(function(){ return this.value }).get();
				}
			}
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//

		
		
		jsonFilter['field'] = associatedField;
		jsonFilter['operator'] = filterOperator;

		jsonFilter['parameters'] = new Object();
		jsonFilter['parameters']['first'] = firstParametersArray;
		jsonFilter['parameters']['second'] = secondParametersArray;
		jsonFilter['parameters']['third'] = thirdParametersArray;

		jsonFilter['type'] = dataType;
		jsonFilter['isRelated'] = isRelated;
		jsonFilter['relationKey'] = relationKey;
		jsonFilter['index'] = filterIndex;
		jsonFilter['enumOperator'] = enumOperator;
		jsonFilter['enumReference'] = enumRef;
		jsonFilter['filterReference'] = filterRef.replace(/[:]/g, '');
		jsonFilter['alias'] = filterAlias;
		jsonFilter['behavior'] = behavior;
		jsonFilter['userOptions'] = userOptions;
		
		
		if (includeEnums) {
			
			jsonFilter['enumValues'] = $(this).find(".first_parameter_select option").map(function(){ return $(this).val(); }).get();
			jsonFilter['enumLabels'] = new Object();
			$(this).find(".first_parameter_select option").each(function(index) {
				jsonFilter['enumLabels'][$(this).val()] = $(this).text();
			});
			
		}
		
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (typeof window.hasPremiumJsFeatures == 'function') {
			var reportLanguage = $(this).find(".language").val();
			jsonFilter['language'] = (reportLanguage == '' ? new Array() : window.JSON.parse(reportLanguage));
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		

		jsonFilter['logicalOperators'] = new Object();
		jsonFilter['logicalOperators']['parenthesis'] = logicalParenthesis;
		jsonFilter['logicalOperators']['operator'] = logicalOperator;
		
		jsonFilter['isWhereFilter'] = $(this).closest("tbody").hasClass("asolReportsFilterWhere");
		
		jsonFilters['data'].push(jsonFilter);
		
	});
	
	jsonFilters['version'] = window["reportsVersion"];

	var jsonString = window.JSON.stringify(jsonFilters);

    return jsonString;
	
}

function checkFilteringParenthesis(filterPanel) {

	var lbl_parenthesis_matching_alert = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MATCHING_PARENTHESIS_ALERT');
	var lbl_last_filter_logical_link_alert = SUGAR.language.get('asol_Reports', 'LBL_REPORT_LAST_FILTER_LOGICAL_LINK_ALERT');
	
	var returned_value = true;
    var checkParenthesis = 0;
    var lastFilterOperator = "";
    
    $("."+filterPanel+" .asolReportsFilterRow").each(function(index) {
		
		var rowParenthesis = $(this).find(".filter_parenthesis").val();
		lastFilterOperator = $(this).find(".filter_logical_operator").val();
		checkParenthesis += parseInt(rowParenthesis);
		
	});
  	
  	if (lastFilterOperator !== "") {
  		alert(lbl_last_filter_logical_link_alert);
  		returned_value = false; 
  	}

  	if (checkParenthesis != 0) {
    	alert(lbl_parenthesis_matching_alert);
    	returned_value = false; 
	}
    
    return returned_value;
	
}


function formatTasks() {

	var parsed_string = "";

	$(".asolReportsTaskRow").each(function(index) {
		
		var execution_range = $(this).find(".execution_range").val();
		
		if ($(this).find(".task_name").val() == "")
			$(this).find(".task_name").val("Task "+index);
		
		parsed_string += $(this).find(".task_name").val()+":";
		parsed_string += execution_range+":";
		
		if (execution_range == "monthly")
			parsed_string += $(this).find(".range_day_value").val()+":";
		else if (execution_range == "weekly")
			parsed_string += $(this).find(".range_week_value").val()+":";
		else
			parsed_string += ":";
		
		parsed_string += $(this).find(".range_hour_value").val()+","+$(this).find(".range_minute_value").val()+":";
        parsed_string += $(this).find(".range_end_date").val()+":";
        parsed_string += $(this).find(".task_state").val()+"|";
        
	});
	
	parsed_string = parsed_string.slice(0, -1);
	parsed_string += "${GMT}";
	
    return parsed_string;

}

function manageReportTypeSelect(selectedIndex) {
	
	if (selectedIndex == 0) { //Manual
		
		$('#scheduledDiv').hide();
		$('#distributionList').show();
				
	} else if (in_array(selectedIndex, [1, 2])) {//Internal & External
		
		$('#scheduledDiv').hide();
		$('#distributionList').hide();
	
	} else {
	
		$('#scheduledDiv').show();
		$('#distributionList').show();
		
	}

}

function formatCharts() {

	var refList = new Array();
	var namesList = new Array();

	var jsonCharts = new Object();
	jsonCharts["charts"] = new Array();
	
	$(".asolReportsChartsGroup").each(function(i) {
		
		var chartsGroup = new Object();
		
		$(this).find(".asolReportsChartRow").each(function(j) {
		
			if (($('#report_charts_engine').val() == 'nvd3') || (!$(this).hasClass('asolReportsSubChart'))) {
			
				var isMainChart = $(this).hasClass("asolReportsMainChart");
				if (isMainChart) {
					
					var originalName = $(this).find(".chart_name").val();
					if (originalName.length == 0) {
						originalName = "Chart";
					}
					
					var finalName = generateUniqueString(namesList, originalName, true);
					namesList.push(originalName);
					if (finalName != originalName) {
						namesList.push(finalName); // Avoids duplicating generated names
					}
					
					// Chart reference
					var originalRef = $(this).find(".chart_ref").val().replace(/\s/g, "");
					var chartRef = "";
					
					if (originalRef.length > 0) {
						chartRef = generateUniqueString(refList, originalRef, false);
						refList.push(originalRef);
						if (chartRef != originalRef) {
							refList.push(chartRef); // Avoids duplicating generated references			
						}
					}
					
				}
	
				var currentChart = new Object();
				currentChart["data"] = new Object();
				
				currentChart["data"]["xAxis"] = $.makeArray($(this).find('.chart_xaxis').val());
				
				currentChart["data"]["field"] = $(this).find('.chart_yaxis').val();
				
				//***********************//
				//***AlineaSol Premium***//
				//***********************//
				if (typeof window.hasPremiumJsFeatures == 'function') {
					currentChart["data"]["zAxis"] = $(this).find('.chart_zaxis').val();
				}
				//***********************//
				//***AlineaSol Premium***//
				//***********************//
					
				currentChart["data"]["label"] = (isMainChart ? finalName : null);
				currentChart["data"]["chartReference"] = (isMainChart ? chartRef.replace(/[:]/g, '') : null);
				
				currentChart["data"]["function"] = $(this).find('.chart_function').val();
				currentChart["data"]["display"] = $(this).find('.chart_display').val();
				currentChart["data"]["type"] = $(this).find('.chart_type').val();
				
				//***********************//
				//***AlineaSol Premium***//
				//***********************//
				if (typeof window.hasPremiumJsFeatures == 'function') {
					currentChart["data"]["halfChart"] = getHalfChartValue(currentChart["data"]["type"], this);
				}
				//***********************//
				//***AlineaSol Premium***//
				//***********************//
					
				currentChart["data"]["xIndex"] = $(this).find('.chart_xIndex').val();
				
				currentChart["data"]["index"] = $(this).find('.chart_index').val();
				
				//***********************//
				//***AlineaSol Premium***//
				//***********************//
				if (typeof window.hasPremiumJsFeatures == 'function') {
					currentChart["data"]["zIndex"] = $(this).find('.chart_zIndex').val();
				}
				//***********************//
				//***AlineaSol Premium***//
				//***********************//
				
				currentChart["data"]["yAxisSide"] = $(this).find('.y_axis_side').val();
				
				currentChart["config"] = new Object();
			
				var chartConfig = $(this).find('.chart_configuration').val();
				if (typeof chartConfig != 'undefined') {
					currentChart["config"] = window.JSON.parse(chartConfig);
				}
				
				//***********************//
				//***AlineaSol Premium***//
				//***********************//
				if (typeof window.hasPremiumJsFeatures == 'function') {
					if (isMainChart) {
						currentChart["data"]["subcharts"] = new Array();
						chartsGroup = currentChart;
					} else {
						chartsGroup["data"]["subcharts"].push(currentChart);
					}
				} else {
					currentChart["data"]["subcharts"] = null;
					chartsGroup = currentChart;
				}
				//***********************//
				//***AlineaSol Premium***//
				//***********************//
				
			}
			
		});
		
		jsonCharts["charts"].push(chartsGroup);
		
	});
	
	jsonCharts["version"] = window["reportsVersion"];

	var jsonString = window.JSON.stringify(jsonCharts);
	
    return jsonString;
	
}

function formatResultsLimit() {

    var parsed_string = ($("#results_limit_op").val() == "all") ? "all" : "limit${dp}"+$("#results_limit_param").val()+"${dp}"+$("#results_limit_amount").val();
    return parsed_string;
	
}

function formatExternalFilters(dashletId) {
	
	var parsed_string = "";
	var singleDashletId = dashletId.replace(/-/gi, "");
	
	if ($("#filters_hidden_inputs"+dashletId) !== 0) {
	
		var userInputVal = unescape($("#filters_hidden_inputs"+dashletId).val());
		var userInputs = userInputVal.split("${pipe}");
		
		for (var i=0; i<userInputs.length; i++) {
			
			var inputValues = userInputs[i].split("${dp}");
			var selectorId = inputValues[0].replace('.', '\\.')+singleDashletId;
			
			
			parsed_string += inputValues[0] + "${dp}" + inputValues[1];
			
			//Select1
			if (($("#"+selectorId+"_1").is("select") && ($("#"+selectorId+"_1").attr('multiple')))) {
				parsed_string += "${dp}";		
				parsed_string += $("#"+selectorId+"_1 option:selected").map(function(){ return this.value }).get().join("${dollar}");
			//Input1
			} else {
				parsed_string += "${dp}" + $("#"+selectorId+"_1").val();
			}
				
			//Select2
			if (($("#"+selectorId+"_2").is("select") && ($("#"+selectorId+"_2").attr('multiple')))) {
				parsed_string += "${dp}";		
				parsed_string += $("#"+selectorId+"_2 option:selected").map(function(){ return this.value }).get().join("${dollar}");
			//Input2
			} else {
				parsed_string += "${dp}" + $("#"+selectorId+"_2").val();
			}
			
			//Select3
			if (inputValues[2] == 3) {
				
				if (($("#"+selectorId+"_3").is("select") && ($("#"+selectorId+"_3").attr('multiple')))) {
					parsed_string += "${dp}";	
					parsed_string += $("#"+selectorId+"_3 option:selected").map(function(){ return this.value }).get().join("${dollar}");
				//Input3
				} else {
					parsed_string += "${comma}" + $("#"+selectorId+"_3").val();
				}
				
			}
			
			parsed_string +=  "${pipe}";
			
		}
		
		parsed_string = parsed_string.slice(0, -7);
		
	}
	

	return parsed_string.replace(/ /gi, "${nbsp}");
	
} 

function delete_field_filters(field_key, field_name) {

	//Check before delete if its the last one repeated field 
	if (count_fields(field_key, field_name) == 1) {
		
		$($(".asolReportsFilterRow").get().reverse()).each(function() { 
		
			if (field_key == "") {
				
				if ($(this).find(".filter_field").val() == field_name)
					$(this).remove();
									
			} else {
			
				if (($(this).find(".filter_field").val() == field_name) && ($(this).find(".filter_key").val() == field_key))
					$(this).remove();

			}
			
		});

	}
	
} 

function count_fields(field_key, field_name) {

	var counter = 0;

    $(".asolReportsFieldRow").each(function(index) {
    	
    	if (field_key == "") {

			if ($(this).find(".field").val() == field_name)
				counter++;
		
		} else {
		
			if (($(this).find(".field").val() == field_name) && ($(this).find(".key").val() == field_key))
				counter++;
		
		}
    	
    });

	return counter;
	
}

function count_function_fields(field_key, field_name) {
	
	var max_index = 0;

	$(".asolReportsFieldRow").each(function(index) {
    	
		var function_index = $(this).find(".index").val().split("_");
		
		if (field_key == "") {
			
			if ($(this).find(".field").val() == field_name)
				max_index = (function_index[1] > max_index) ? function_index[1] : max_index;
		
		} else {
		
			if (($(this).find(".field").val()) && ($(this).find(".key").val() == field_key))
				max_index = (function_index[1] > max_index) ? function_index[1] : max_index;
		
		}
    	
    });
	
	return parseInt(max_index);
	
}

function checkCreationForm(isMetaReport) {
	
	var flag = true;
	var form = document.getElementById("create_form");
	
	if (form.report_name.value == "") {
        form.action.value = 'EditView';
        form.report_name.value = 'Report Name';
        flag = false;
	}
	
	if (form.assigned_user_name.value == "") {
        form.action.value = 'EditView';
        form.assigned_user_name.value = 'admin';
        flag = false;
	}
	
	if (form.assigned_user_id.value == "") {
        form.assigned_user_id.value = 1;
        form.action.value = 'EditView';
        flag = false;
	}
	
	var emails_array = form.email_list.value.split("${pipe}");
	
    if (!check_emails_format(emails_array[7])){
        flag = false;
    }
	
	if (!check_emails_format(emails_array[8])){
        flag = false;
    }

	if (!check_emails_format(emails_array[9])){
        flag = false;
    }
	
    if (!check_execution_end_dates('tasks_Table')){
        flag = false;
    }
    
	if ((!isMetaReport) || (typeof window.hasPremiumJsFeatures == 'undefined')) {
	
		if (form.alternative_database.value >= 0) {
			
			if ((form.alternative_database_table.value == "") && (form.dynamic_tables.value == "0")) {
		        form.action.value = 'EditView';
		        form.alternative_database_table.selectedIndex = 1;
		        flag = false;
			}
			
		} else {
			
			if (form.report_module.value == "") {
				form.action.value = 'EditView';
		        form.report_module.selectedIndex = 1;
		        flag = false;
			}
			
		}
	
	    if (!checkFilteringParenthesis('asolReportsFilterWhere')) {
	    	flag = false;
		}
	    
	    if (!checkFilteringParenthesis('asolReportsFilterHaving')) {
	    	flag = false;
		}
	    
	    if (!check_mysql_functions_insecurity()) {
	    	flag = false;
	    }
	    
	    if (!check_stored_uri_info_deleted()) {
	    	flag = false;
	    }
	    
	    //***AlineaSol Premium***//
	    if (typeof window.hasPremiumJsFeatures == 'function') {
	    
	    	if (!check_php_functions_insecurity()) {
		    	flag = false;
		    }
	    	
	    	if (!check_inherit_subeditor_filters()) {
		    	flag = false;
		    }
	    
	    }
	    //***AlineaSol Premium***//
	    
	    check_scheduled_user_input_report();

	}
    
    return flag;

}

function check_scheduled_user_input_report() {
	
	var scheduledUserInputReportAlert = SUGAR.language.get('asol_Reports', 'LBL_REPORT_SCHEDULED_USER_INPUT_ALERT').replace("\\n", "\n");
    var hasUserInputs = false;
    var reportType = $('#report_type').val();
    
    $(".asolReportsFilterRow").each(function(index) {
    	
    	if ($(this).find(".behavior").val() == 'user_input') {
			hasUserInputs = true;
			return false;
		}
    	
    });

  	if ((in_array(reportType, ["scheduled", "stored"])) && hasUserInputs) {
  		alert(scheduledUserInputReportAlert);
  	}
	
}


function check_stored_uri_info_deleted() {

	var storedUriInfoDeletedAlert = SUGAR.language.get('asol_Reports', 'LBL_REPORT_STORED_URI_INFO_DELETED_ALERT').replace("\\n", "\n");
	var deleteInfo = true;
	
	var reportType = $('#report_type').val();
	var storedUri = $('#report_type_uri').val();

	if ((!in_array(reportType, ["stored"])) && (storedUri !== "")) {
		deleteInfo = confirm(storedUriInfoDeletedAlert);
		if (!deleteInfo) {
			$('#report_type').val("stored");
		}
	}

	return deleteInfo;
	
}

function check_execution_end_dates(idTasksTable){

	var Execution_Date_Alert = SUGAR.language.get('asol_Reports', 'LBL_REPORT_EMPTY_EXECUTION_END_DATE_ALERT');
    var flag = true;

    $(".asolReportsTaskRow .range_end_date").each(function(index) {
    	
    	if (!$(this).val()) {
    		alert(Execution_Date_Alert);
            flag = false;
            return flag;
    	}
    	
    });

    return flag;

}

function escape_field(fieldValue){

    return fieldValue.replace(/[:]/g, "{$dp}").replace(/[|]/g, "{$pipe}");

}

function check_mysql_functions_insecurity() {
	
	var returned_value = true;
	    
    $(".asolReportsFieldRow").each(function(index) {

    	var disabledMySQLfunction = $(this).find('.configureSqlStoredValue').is(':disabled');
    	if (!disabledMySQLfunction) {
    		
			if (returned_value)
				returned_value = validate_mysql_function_insecurity($(this).find('.configureSqlStoredValue').val(), true);
			else
				validate_mysql_function_insecurity($(this).find('.configureSqlStoredValue').val(), true);
			
  		}
    	
    });

    return returned_value;
	
}

function validate_mysql_function_insecurity(mySQLFunction, showAlert) {

	//userScope -> 0: none, 1: admin, 2:everybody
	var lbl_mysql_insecurity_alert = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MYSQL_NON_ADMIN_INSECURITY');
	
	var checkInsecurity = ($('#mySQLcheckInsecurity').val() === "1") ? true : false;
	var returned_value = true;
	
	if (checkInsecurity) {
		
		if ((mySQLFunction.toUpperCase().indexOf("SELECT ") !== -1) ||
			(mySQLFunction.toUpperCase().indexOf(" FROM ") !== -1) ||
			(mySQLFunction.toUpperCase().indexOf(" LEFT JOIN ") !== -1) ||
			(mySQLFunction.toUpperCase().indexOf(" WHERE ") !== -1) ||
			(mySQLFunction.toUpperCase().indexOf(" LIMIT ") !== -1) ||
			(mySQLFunction.toUpperCase().indexOf(" ORDER BY ") !== -1)) {
			
			if (showAlert)
				alert(lbl_mysql_insecurity_alert);
			returned_value = false;
			
		}
	
	}
	
	return returned_value;
	
}

function check_emails_format(email_list){

    email_list = email_list.replace(/ /g,"");

    var Email_Alert = SUGAR.language.get('asol_Reports', 'LBL_REPORT_INVALID_EMAIL_ALERT');
    var emails = email_list.split(",");
    var flag = true;

    if (email_list !== ""){

        for (var i=0; i<emails.length; i++){

            if ((!emails[i].match("[0-9a-zA-Z]@[0-9a-zA-Z].[a-zA-Z]")) && (emails[i] !== "")){
                flag = false;
                alert("\""+emails[i]+"\" "+Email_Alert);
            }

        }

    }

        return flag;

}

function markCheckBoxes(checked) {

    if (checked)
    	$(".listViewCheck").attr('checked','checked');
    else
    	$(".listViewCheck").removeAttr('checked');

}

function in_array(element, array){

    for (i = 0; i < array.length; i++) {

        if (array[i] == element) {
        	return true;
        }

    }

    return false;

}

function htmlEscape(str) {
    return String(str)
    .replace(/&/g, '&amp;')
    .replace(/"/g, '&quot;')
    .replace(/'/g, '&#39;')
    .replace(/</g, '&lt;')
    .replace(/>/g, '&gt;');
}

function htmlEntitiesEncode(value){
    if (value) {
        return htmlEscape($('<div/>').text(value).html());
    } else {
        return '';
    }
}

function htmlUnescape(value){
    return String(value)
    .replace(/&quot;/g, '"')
    .replace(/&#39;/g, "'")
    .replace(/&lt;/g, '<')
    .replace(/&gt;/g, '>')
    .replace(/&amp;/g, '&');
}

function htmlEntitiesDecode(value) {
    if (value) {
        return htmlUnescape($('<div/>').html(value).text());
    } else {
        return '';
    }
}

function countSelectedOptions(idSelectObject) {

	return $("#"+idSelectObject+" :selected").length;

}

function manageReportManagementTabs(containerId, divId, panelClass) {
	
	if (!$('#'+divId+'_Tab').closest('li').is('.disabled, .semidisabled')) {
	
		$('.'+panelClass).hide();
		$('#'+divId).show();
		$('ul#'+containerId+' li.selected').removeClass('selected');
		$('#'+divId+'_Tab').closest('li').addClass('selected');
	
	}
	
}

function manageReportDatabase(database) {

	$.blockUI({ theme: true, title: null, message: $('#loadingBlockDiv') });
	$.ajax({ url: 'index.php?entryPoint=reportGenerateHtml&htmlTarget=reportModuleTables&selectedDb='+database+'&isSubQuery=false', 
		success: function(data) {
			if (typeof window.hasPremiumJsFeatures == 'function') {
				$('#reportDynamicTableDiv').closest('.ui-dialog').remove();
			}
			cleanUpReport('reportTreeFieldsDiv');
			$('#reportModulesTablesSpan').html(data); 
			$.unblockUI(); 
		}
	});
	
	if (database == '-1') {
		$("#tableConfigurationDialog table#fieldManagement").show();
	} else {
		$("#tableConfigurationDialog table#fieldManagement").hide();
	}
	
	if (typeof window.hasPremiumJsFeatures == 'function') {
		manageReportPremiumDatabase(database);
	}
		
}

function manageReportModule(database, module, treeMode, divId, cleanUp, swithMode, isEditView) {

	cleanUp = ((typeof window['cleanUp'] !== 'undefined' && window['cleanUp'] !== null) ? window['cleanUp'] : cleanUp);
	$.blockUI({ theme: true, title: null, message: $('#loadingBlockDiv') });

	if (database >= "0") {
		
		$.ajax({ 
			url: 'index.php?entryPoint=reportGenerateHtml&htmlTarget=reportTableFields'+treeMode+'&isAudited=0&selectedDb='+$('#alternative_database').val()+'&selectedModule='+module+'&isEditViewMode='+(isEditView ? 'true' : 'false')+'&subQueryMode='+(window["subQueryMode"] ? 'true' : 'false'), 
			success: function(data) {
				if (cleanUp) {
					if ($('#'+(window["subQueryMode"] ? 'autorefresh_sub_report' : 'autorefresh_report')).is(':checked')) { 
						cleanUpReport((window["subQueryMode"] ? 'subReportTreeFieldsDiv' : 'reportTreeFieldsDiv'), swithMode);
					} else { 
						$('#related_fields').empty(); 
					}
				}
				
				$('#'+divId).html(data);
				
				$('#addFieldsButton').prop('disabled', true); 
				$.unblockUI(); 
			}
		});
		
	} else {			

		var hasDeleted = $('#tableConfigurationDialog #deleted_usage').prop('checked');
		
		$.ajax({ 
			url: 'index.php?entryPoint=reportGenerateHtml&htmlTarget=reportTableFields'+treeMode+'&hasDeleted='+(hasDeleted ? 1 : 0)+'&isAudited='+(($((window['subQueryMode'] ? '#audited_sub_report' : '#audited_report')).is(':checked')) ? 1 : 0)+'&selectedDb='+$('#alternative_database').val()+'&selectedModule='+module+'&subQueryMode='+(window["subQueryMode"] ? 'true' : 'false'), 
			success: function(data) {
				if (cleanUp) {
					cleanUpReport(divId, swithMode);
				}
				$('#'+divId).html(data); 
				$('#addFieldsButton').prop('disabled', true); 
				$.unblockUI(); 
			}
		});
	
	}
	
	window['cleanUp'] = null;

}

function manageReportAudit(auditCheck, treeMode, divId, cleanUp) {
	
	var hasDeleted = $('#tableConfigurationDialog #deleted_usage').prop('checked');
	
	$.blockUI({ theme: true, title: null, message: $('#loadingBlockDiv') }); 
	$.ajax({ 
		url: 'index.php?entryPoint=reportGenerateHtml&htmlTarget=reportTableFields'+treeMode+'&selectedDb='+$('#alternative_database').val()+'&selectedModule='+$(window['subQueryMode'] ? '#sub_report_module' : '#report_module').val()+'&subQueryMode='+(window['subQueryMode'] ? 'true' : 'false')+'&hasDeleted='+(hasDeleted ? 1 : 0)+'&isAudited='+(($(auditCheck).is(':checked')) ? 1 : 0), 
		success: function(data) {
			if (cleanUp) {
				cleanUpReport(divId);
			}
			$('#'+divId).html(data); 
			$('#addFieldsButton').prop('disabled', true); 
			$.unblockUI(); 
		}
	});
	
}
		
function cleanUpReport(reportTreeId, switchMode) {

	switchMode = (typeof switchMode == 'undefined' ? false : switchMode);

	var showAlert = (($(".asolReportsFieldRow").length > 0) && !switchMode);
	var selector = (switchMode ? false : true);
	var charts = (switchMode ? false: true);

	if (showAlert) {
		alert(SUGAR.language.get('asol_Reports', 'LBL_REPORT_CLEANUP_ALERT'));
	}
	
	if (selector) {
		
		$(window["subQueryMode"] ? "#auditedSubReportSpan" : "#auditedReportSpan").css("visibility", "hidden");
		
		$(window["subQueryMode"] ? "#autoSubRefreshSpan" : "#autoRefreshSpan").css("display", "none");
		$("#reportDynamicTableAddImg, #reportDynamicTableCancelImg").css("display", "inline");
		
		if (typeof window.hasPremiumJsFeatures == 'function') {
			$("#"+reportTreeId).html('');
		} else {
			$("#fields").empty();
			$("#show_related_button").css('visibility', 'hidden');
			$("#related_fields").empty();
		}
		
	}
	
	$(".asolReportsFieldRow").remove();
	$(".asolReportsFilterRow").remove();
	
	$("#fieldsGlobalIndex").val('0');
	$("#filtersGlobalIndex").val('0');
	
	$("#rowIndexDisplay").val('0');

	$("#results_limit_op").val('all');
	$("#results_limit_param").val('first').css('visibility', 'hidden');
	$("#results_limit_amount").val('').css('visibility', 'hidden');

	if (charts) {
		
		$(".asolReportsChartRow").remove();
		
	}
	
}

function managePremiumFeature() {
	
}


function initVisibilityToggle(tableId, visibleIconClass, hiddenIconClass, containerClass, hideContainer, displayValueClass, textualValues, asRadioButton, thirdStatusValue, thirdIconClass, thirdIsHidden) {
	
	if ((typeof textualValues == 'undefined') || (textualValues != true)) {
		textualValues = false;
	}
	
	// Set hidden
	$('#'+tableId).off('click', '.'+visibleIconClass).on('click', '.'+visibleIconClass, function() {
		
		var e = $(this).closest('.'+containerClass);
		
		if (!asRadioButton) {
		
			if (thirdStatusValue != null) {
				
				e.find('.'+visibleIconClass).first().hide();
				e.find('.'+hiddenIconClass).first().show();
				e.find('.'+thirdIconClass).first().hide();
	
			} else {
	
				e.find('.'+hiddenIconClass).first().show();
				e.find('.'+visibleIconClass).first().hide();
				
			}
			
			e.find('.'+displayValueClass).first().val((textualValues ? "no" : 0));
				
			if(hideContainer) e.addClass('hiddenRow');
			
		}
		
	});
	
	// Set visible
	$('#'+tableId).off('click', '.'+hiddenIconClass).on('click', '.'+hiddenIconClass, function() {
		
		var e = $(this).closest('.'+containerClass); 
		
		if (thirdStatusValue != null) {
			
			e.find('.'+visibleIconClass).first().hide();
			e.find('.'+hiddenIconClass).first().hide();
			e.find('.'+thirdIconClass).first().show();
			
			e.find('.'+displayValueClass).first().val(thirdStatusValue);
			
			if (!thirdIsHidden && hideContainer) {
				e.removeClass('hiddenRow');
			}
			
		} else {
			
			if (asRadioButton) {

				$('#'+tableId).find('.'+visibleIconClass).hide().closest('.'+containerClass).addClass('hiddenRow').find('.'+displayValueClass).val((textualValues ? "no" : 0));
				$('#'+tableId).find('.'+hiddenIconClass).show();
				
			}
			
			e.find('.'+visibleIconClass).first().show();	
			e.find('.'+hiddenIconClass).first().hide();

			e.find('.'+displayValueClass).first().val((textualValues ? "yes" : 1));	
			if(hideContainer) e.removeClass('hiddenRow');
				
		}
		
	});
	
	if ((thirdStatusValue != null) && (!asRadioButton)) {
		
		$('#'+tableId).off('click', '.'+thirdIconClass).on('click', '.'+thirdIconClass, function() {
			
			var e = $(this).closest('.'+containerClass);
			
			e.find('.'+thirdIconClass).first().hide();
			e.find('.'+visibleIconClass).first().show();
			e.find('.'+hiddenIconClass).first().hide();
						
			e.find('.'+displayValueClass).first().val((textualValues ? "yes" : 1));

			if(hideContainer) e.removeClass('hiddenRow');
			
		});
	
	}
	
}

function getCellMultiRemoveHtml() {
	return "<input type='checkbox' class='massiveCheck' />";
}

function initMassiveAction(tableId, massiveCheckboxClass, massiveAllCheckboxClass, massiveActionClass) {

	$('#'+tableId).on('click', 'input.'+massiveCheckboxClass, function() {
		
		numElementsChecked = $('#'+tableId+' .'+massiveCheckboxClass+':checked').length;
		numElements = $('#'+tableId+' .'+massiveCheckboxClass).length;
		
		// Enables or disables massive operations
		$('#'+tableId+' .'+massiveActionClass).prop('disabled', (numElementsChecked == 0));
		
		// Checks or unchecks global selector
		$('#'+tableId+' .'+massiveAllCheckboxClass).prop('checked', (numElementsChecked == numElements));
		
	});
	
	$('#'+tableId+' .'+massiveAllCheckboxClass).click(function() {
		
		var checkAll = $(this).is(':checked');
		
		$('#'+tableId+' .'+massiveAllCheckboxClass).prop('checked', checkAll);
		$('#'+tableId+' .'+massiveCheckboxClass).prop('checked', checkAll);
		
		// Checks all
		$('#'+tableId+' .'+massiveActionClass).prop('disabled', !checkAll);
		
	});

}

function deleteRows(tableId, massiveCheckboxClass, massiveAllCheckboxClass, massiveActionClass, massiveAlertLabel) {
	if (confirm(SUGAR.language.get('asol_Reports', massiveAlertLabel))) {
		$('#'+tableId+' .'+massiveCheckboxClass+':checked').closest('tr').remove();
		$('#'+tableId+' .'+massiveAllCheckboxClass).prop('checked', false);
		$('#'+tableId+' .'+massiveActionClass).prop('disabled', true);
	}
}

function deleteRowsByCustomCode(tableId, massiveCheckboxClass, massiveAllCheckboxClass, massiveActionClass, massiveAlertLabel, customCodeClass) {
	if (confirm(SUGAR.language.get('asol_Reports', massiveAlertLabel))) {
		$('#'+tableId+' .'+massiveCheckboxClass+':checked').closest('tr').each(function() {
			new Function($(this).find('.'+customCodeClass).val())();
		});
		$('#'+tableId+' .'+massiveAllCheckboxClass).prop('checked', false);
		$('#'+tableId+' .'+massiveActionClass).prop('disabled', true);
	}
}

function deleteReports(deleteCheckboxClass, deletableFlagClass) {
	
	confirmMessageLabel = SUGAR.language.get('asol_Reports', 'LBL_REPORT_MULTIDELETE_ALERT');
	undeletableReportFlag = false;
	undeletableHtmlElements = new Array();
	
	$('.'+deleteCheckboxClass+':checked').each(function() {
		currentReportDeletableFlag = $(this).parent().children('.'+deletableFlagClass);
		
		if (currentReportDeletableFlag.val() == 'false') {
			undeletableReportFlag = true;
			undeletableHtmlElements[undeletableHtmlElements.length] = $(this);
		}  
	});
	
	if (undeletableReportFlag) {
		confirmMessageLabel+= '\n' + SUGAR.language.get('asol_Reports', 'LBL_REPORT_UNDELETABLE_ALERT');
	}
	
	if(confirm(confirmMessageLabel)) {
		for(i=0; i<undeletableHtmlElements.length; i++) {
			undeletableHtmlElements[i].prop('checked', false);
		}
		return true;
	} else {
		return false;
	}
	
}

// Overwrites objectA attributes with values from objectB
function overwriteAttributes(objectA, objectB) {
	for (var attribute in objectB) {
		if (objectA.hasOwnProperty(attribute)) {
			if (objectA[attribute].constructor == Object) {
				objectA[attribute] = overwriteAttributes(objectA[attribute], objectB[attribute]);
			} else {
				objectA[attribute] = objectB[attribute];
			}
		}
	}
	return objectA;
}

function populateTableConfig(tablesConfig) {

	var finalConfigArray = getDefaultTableConfig();
	finalConfigArray = overwriteAttributes(finalConfigArray, tablesConfig);
	
	var finalConfigJson = window.JSON.stringify(finalConfigArray);
	$('#tableConfiguration').val(finalConfigJson);
		
}

function populateFiltersConfig(filtersArray) {
	var finalConfigArray = getDefaultFiltersConfig();
	var customConfigArray = filtersArray.config;
	finalConfigArray = overwriteAttributes(finalConfigArray, customConfigArray);
	
	var finalConfigJson = window.JSON.stringify(finalConfigArray);
	$('#filtersConfiguration').val(finalConfigJson);
}

function showTableConfig(dataStoreElemId) {

	var finalConfigArray = getDefaultTableConfig();
	
	var customConfigJson = $('#'+dataStoreElemId).val();
	if (customConfigJson.length > 0) {
		customConfigArray = window.JSON.parse(unescape(customConfigJson));
		finalConfigArray = overwriteAttributes(finalConfigArray, customConfigArray);
	}
	
	$('#'+dataStoreElemId).val(window.JSON.stringify(finalConfigArray));
	
	$('#tableConfigurationDialog #multi_query').prop('checked', finalConfigArray.multiQuery);
	$('#tableConfigurationDialog #deleted_usage').prop('checked', finalConfigArray.deletedUsage);
	
	$('#tableConfigurationDialog #pagination_usage').prop('checked', finalConfigArray.paginationUsage);
	$('#tableConfigurationDialog #pagination_entries').val(finalConfigArray.paginationEntries);
	
	$('#tableConfigurationDialog #expand_grouped_totals').prop('checked', finalConfigArray.expandGroupedTotals);
	
	$('#tableConfigurationDialog #titles_visibility option').each(function() {
		if ($(this).val() == finalConfigArray.titles.visible.toString()) {
			$(this).prop('selected', true);
			return false; // == break
		}
	});
	
	$('#tableConfigurationDialog #headers_visibility option').each(function() {
		if ($(this).val() == finalConfigArray.headers.visible.toString()) {
			$(this).prop('selected', true);
			return false; // == break
		}
	});
	
	$('#tableConfigurationDialog #subtotals_visibility option').each(function() {
		if ($(this).val() == finalConfigArray.subtotals.visible.toString()) {
			$(this).prop('selected', true);
			return false; // == break
		}
	});
	
	$('#tableConfigurationDialog #totals_visibility option').each(function() {
		if ($(this).val() == finalConfigArray.totals.visible.toString()) {
			$(this).prop('selected', true);
			return false; // == break
		}
	});
	
	$('#tableConfigurationDialog #pagination_visibility option').each(function() {
		if ($(this).val() == finalConfigArray.pagination.visible.toString()) {
			$(this).prop('selected', true);
			return false; // == break
		}
	});
	
	$('#tableConfigurationDialog #tableConfigStore').val(dataStoreElemId);
	
	$('#tableConfigurationDialog').dialog({
		modal: true,
		overlay:
		{
			opacity: 0.8,
			background: 'black'
		},
		position: ['center', 'center'],
		title: SUGAR.language.get('asol_Reports', 'LBL_REPORT_TABLE_CONFIGURATION')
	});
}

function saveTableConfig() {
	
	var dataStoreElemId = $('#tableConfigurationDialog #tableConfigStore').val();
	
	$('#tableConfigurationDialog').dialog("close");
	
	var configJson = $('#'+dataStoreElemId).val();
	var configArray = window.JSON.parse(configJson);

	var previousDeletedUsage = configArray.deletedUsage; 
	
	if (typeof window.hasPremiumJsFeatures == 'function') {
		configArray.multiQuery = $('#tableConfigurationDialog #multi_query').prop('checked');
	}
	configArray.deletedUsage = $('#tableConfigurationDialog #deleted_usage').prop('checked');
	configArray.paginationEntries = $('#tableConfigurationDialog #pagination_entries').val();
	configArray.paginationUsage = $('#tableConfigurationDialog #pagination_usage').prop('checked');
	configArray.expandGroupedTotals = $('#tableConfigurationDialog #expand_grouped_totals').prop('checked');
	configArray.titles.visible = ($('#tableConfigurationDialog #titles_visibility').val() == 'true');
	configArray.headers.visible = ($('#tableConfigurationDialog #headers_visibility').val() == 'true');
	configArray.subtotals.visible = ($('#tableConfigurationDialog #subtotals_visibility').val() == 'true');
	configArray.totals.visible = ($('#tableConfigurationDialog #totals_visibility').val() == 'true');
	configArray.pagination.visible = $('#tableConfigurationDialog #pagination_visibility').val();
	
	var selectedDb = $('#alternative_database').val();
	if ((selectedDb == '-1') && (previousDeletedUsage != configArray.deletedUsage)) {
		window['cleanUp'] = false;
		$("#report_module").change();
	}
	
	configJson = window.JSON.stringify(configArray);
	$('#'+dataStoreElemId).val(configJson);
}

function discardTableConfig() {
	$('#tableConfigurationDialog').dialog("close");
}



function showFiltersConfig() {

	var finalConfigArray = getDefaultFiltersConfig();
	
	var customConfigJson = $('#filtersConfiguration').val();
	if (customConfigJson.length > 0) {
		customConfigArray = window.JSON.parse(customConfigJson);
		finalConfigArray = overwriteAttributes(finalConfigArray, customConfigArray);
	}
	
	$('#filtersConfiguration').val(window.JSON.stringify(finalConfigArray));
	
	$('#filtersConfigurationDialog #initial_execution').prop('checked', finalConfigArray.initialExecution);
	
	$('#filtersConfigurationDialog').dialog({
		modal: true,
		overlay:
		{
			opacity: 0.8,
			background: 'black'
		},
		position: ['center', 'center'],
		title: SUGAR.language.get('asol_Reports', 'LBL_REPORT_FILTERS_CONFIGURATION')
	});
	
}

function saveFiltersConfig() {
	
	$('#filtersConfigurationDialog').dialog("close");
	
	var configJson = $('#filtersConfiguration').val();
	var configArray = window.JSON.parse(configJson);

	configArray.initialExecution = $('#filtersConfigurationDialog #initial_execution').prop('checked');
	
	configJson = window.JSON.stringify(configArray);
	$('#filtersConfiguration').val(configJson);
}

function discardFiltersConfig() {
	$('#filtersConfigurationDialog').dialog("close");
}

function showFieldOrdering() {
	
	var fieldsOrdered = new Array();
	var fieldsUnordered = new Array();
	$('#fields_Table .asolReportsFieldRow').each(function() {
		if (in_array($(this).find('.sort_dir').val(), ['ASC', 'DESC'])) {
			var currentField = new Object();
			currentField.sequence = $(this).find('.sort_seq').val();
			currentField.field = $(this).find('.field').val();
			currentField.alias = $(this).find('.alias').val();
			currentField.index = $(this).find('.index').val();
			if (currentField.sequence === '') {
				currentField.unordered = true;
				fieldsUnordered.push(currentField);
			} else {
				currentField.unordered = false;
				fieldsOrdered[(isNaN(parseInt(currentField.sequence)) ? currentField.sequence.charCodeAt(0) : parseInt(currentField.sequence))] = currentField;
			}
		}
	});
	
	var fieldOrderingListHtml = '';
	fieldsOrdered.concat(fieldsUnordered).forEach(function(currentField) {
		fieldOrderingListHtml += '<tr class="fieldOrderItem">';
		fieldOrderingListHtml += '<td><input type="hidden" class="index" value="'+currentField.index+'"><input type="hidden" class="field" value="'+currentField.field+'">'+currentField.alias+'</td>';
		fieldOrderingListHtml += '</tr>';
	});
	
	$('#tableFieldOrderingDialog .fieldOrderListContainer').html(fieldOrderingListHtml);
	jQueryReports('#tableFieldOrderingDialog .fieldOrderListContainer').sortable({ items: '.fieldOrderItem'});
	
	$('#tableFieldOrderingDialog').dialog({
		modal: true,
		overlay:
		{
			opacity: 0.8,
			background: 'black'
		},
		position: ['center', 'center'],
		title: SUGAR.language.get('asol_Reports', 'LBL_REPORT_FIELD_ORDERING')
	});
	
}

function saveFieldOrdering() {
	
	$('#tableFieldOrderingDialog').dialog("close");
	
	var currentSequence = 1;
	
	$('#tableFieldOrderingDialog .fieldOrderItem').each(function() {
		
		var currentField = $(this).find('.field').val();
		var currentIndex = $(this).find('.index').val();
		var currentOrdinalChar = getOrdinalChar(currentSequence);
		
		$('#fields_Table .asolReportsFieldRow').each(function() {
			if ((currentIndex == $(this).find('.index').val()) && (currentField == $(this).find('.field').val())) {
				$(this).find('.sort_seq').val(currentSequence);
				$(this).find('.sort_seq_span').html(currentSequence+currentOrdinalChar);
				return false;
			}
		});
		currentSequence++;
		
	});
	
}

function discardFieldOrdering() {
	$('#tableFieldOrderingDialog').dialog("close");
}

function showGroupOrdering() {
	
	var groupsOrdered = new Array();
	var groupsUnordered = new Array();
	$('#fields_Table .asolReportsFieldRow').each(function() {
		if (in_array($(this).find('.layout_group').val(), ['Grouped', 'Hour Grouped', 'Day Grouped', 'DoW Grouped', 'WoY Grouped', 'Month Grouped', 'Natural Quarter Grouped', 'Fiscal Quarter Grouped', 'Natural Year Grouped', 'Fiscal Year Grouped'])) {
			var currentGroup = new Object();
			currentGroup.sequence = $(this).find('.group_seq').val();
			currentGroup.field = $(this).find('.field').val();
			currentGroup.alias = $(this).find('.alias').val();
			currentGroup.index = $(this).find('.index').val();
			if (currentGroup.sequence === '') {
				currentGroup.unordered = true;
				groupsUnordered.push(currentGroup);
			} else {
				currentGroup.unordered = false;
				groupsOrdered[(isNaN(parseInt(currentGroup.sequence)) ? currentGroup.sequence.charCodeAt(0) : parseInt(currentGroup.sequence))] = currentGroup;
			}
		}
	});
	
	var groupOrderingListHtml = '';
	groupsOrdered.concat(groupsUnordered).forEach(function(currentGroup) {
		groupOrderingListHtml += '<tr class="groupOrderItem">';
		groupOrderingListHtml += '<td><input type="hidden" class="index" value="'+currentGroup.index+'"><input type="hidden" class="field" value="'+currentGroup.field+'">'+currentGroup.alias+'</td>';
		groupOrderingListHtml += '</tr>';
	});
	
	$('#tableGroupOrderingDialog .groupOrderListContainer').html(groupOrderingListHtml);
	jQueryReports('#tableGroupOrderingDialog .groupOrderListContainer').sortable({ items: '.groupOrderItem'});
	
	$('#tableGroupOrderingDialog').dialog({
		modal: true,
		overlay:
		{
			opacity: 0.8,
			background: 'black'
		},
		position: ['center', 'center'],
		title: SUGAR.language.get('asol_Reports', 'LBL_REPORT_GROUP_ORDERING')
	});
	
}

function saveGroupOrdering() {
	
	$('#tableGroupOrderingDialog').dialog("close");
	
	var currentSequence = 1;
	
	$('#tableGroupOrderingDialog .groupOrderItem').each(function() {
		
		var currentField = $(this).find('.field').val();
		var currentIndex = $(this).find('.index').val();
		var currentOrdinalChar = getOrdinalChar(currentSequence);
		
		$('#fields_Table .asolReportsFieldRow').each(function() {
			if ((currentIndex == $(this).find('.index').val()) && (currentField == $(this).find('.field').val())) {
				$(this).find('.group_seq').val(currentSequence);
				$(this).find('.group_seq_span').html(currentSequence+currentOrdinalChar);
				return false;
			}
		});
		currentSequence++;
		
	});
	
}

function discardGroupOrdering() {
	$('#tableGroupOrderingDialog').dialog("close");
}

function getOrdinalChar(cardinalNumber) {
	
	cardinalNumber = parseInt(cardinalNumber);
	
	switch (cardinalNumber) {
	
		case 1:
			return SUGAR.language.get('asol_Reports', 'LBL_REPORT_FIRST_ORDINAL_CHARACTER');
			
		case 2:
			return SUGAR.language.get('asol_Reports', 'LBL_REPORT_SECOND_ORDINAL_CHARACTER');
			
		case 3:
			return SUGAR.language.get('asol_Reports', 'LBL_REPORT_THIRD_ORDINAL_CHARACTER');
			
		default:
			return SUGAR.language.get('asol_Reports', 'LBL_REPORT_NTH_ORDINAL_CHARACTER');
	
	}
	
}

function getRelatedFields(showSecondRelated, linkField, relatedKey, relatedModule) {

	var hasDeleted = $('#tableConfigurationDialog #deleted_usage').prop('checked');
	var fieldsSelect = (showSecondRelated ? $('select#related_fields') : $('select#fields'));
	
	var mainRelatedKey = (relatedKey == null ? $(fieldsSelect).find('option:selected').attr('fieldKey') : relatedKey);
	var mainRelatedModule = (relatedModule == null ? $(fieldsSelect).find('option:selected').attr('fieldModule') : relatedModule);
	
	var fieldsSelectValue = (linkField == null ? $(fieldsSelect).val() : linkField);
	if (fieldsSelectValue) {
		var getLinks = ((linkField != null) || ($(fieldsSelect).find('option:selected').get(0).style.color != ''));
		if (getLinks) { 
			$.blockUI({ theme: true, title: null, message: $('#loadingBlockDiv') }); 
			$.ajax({ 
				url: 'index.php?entryPoint=reportGenerateHtml&htmlTarget=reportRelatedTableFields&selectedDb='+$('#alternative_database').val()+'&selectedModule='+$('#report_module').val()+'&mainRelatedKey='+mainRelatedKey+'&mainRelatedModule='+mainRelatedModule+'&selectedRhsKey='+fieldsSelectValue+'&hasDeleted='+(hasDeleted ? 1 : 0)+'&isAudited='+(($('#audited_report').is(':checked')) ? 1 : 0), 
				success: function(data) { 
					$('#reportTableRelatedFieldsDiv').html(data); $.unblockUI();

					if (typeof window.hasPremiumJsFeatures == 'function') {
						generateBreadbrumbTrail(showSecondRelated, fieldsSelectValue, mainRelatedKey, mainRelatedModule);
					}
					
				}
			}); 
		} 
	}

}

function setShowRelatedButtonVisibility(showSecondRelated) {
	
	var fieldsSelectDom = (showSecondRelated ? $('select#related_fields')[0] : $('select#fields')[0]);
	
	var showRelatedButtonId = (showSecondRelated ? 'show_second_related_button' : 'show_related_button');
	var addFieldsButtonId = (showSecondRelated ? 'addRelatedFieldsButton' : 'addFieldsButton');
		
	if (fieldsSelectDom.selectedIndex != -1) { 
		var linkColor = fieldsSelectDom.options[fieldsSelectDom.selectedIndex].style.color;
		if (linkColor != '') {
			$('#'+showRelatedButtonId).css('visibility', 'visible');
		} else { 
			$('#'+showRelatedButtonId).css('visibility', 'hidden');
		}
	}
	document.getElementById(addFieldsButtonId).disabled = (fieldsSelectDom.selectedIndex == -1);
		
}

function getReportVariableHover(currentField, currentModule, currentKey, button) {
	
	var dotSplittedField = currentField.split('.');
	var keyUsageValue = getKeyUsageValue(currentKey);
	var isCustomField = (dotSplittedField[0].substr(-('_cstm'.length)) === '_cstm');
	
	var usedVariable = (((dotSplittedField.length) > 1 && (keyUsageValue != '')) ? '${'+currentModule+(isCustomField ? '_Cstm' : '')+'->'+keyUsageValue+'->'+dotSplittedField[1]+'}' : (isCustomField ? '${bean_cstm->'+dotSplittedField[1]+'}' : '${bean->'+currentField+'}'));
	$('#variableClipboardCopyDiv').find('#asolReportsVar').text(usedVariable);
	
	$('#variableClipboardCopyDiv').dialog({
		modal: true,
		resizable: false,
		height: 110,
        width: 700,
		overlay:
		{
			opacity: 0.8,
			background: 'black'
		},
		position: { my: "left bottom", at: "right top", of: button },
		title: SUGAR.language.get('asol_Reports', 'LBL_REPORT_VARIABLE_REF'),	
	}).css('text-align', 'center');

	clipboardDialogClosed = false;
	
	$("div.zclip").remove();
	$("a#asolReportsVar").zclip({
		path: "modules/asol_Reports/include_basic/js/ZeroClipboard/ZeroClipboard.swf",
		copy: function() {
			return $("a#asolReportsVar").text();
		},
		beforeCopy: function() { },
		afterCopy: function() {
			if (!clipboardDialogClosed) {
				$('#variableClipboardCopyDiv').dialog('close');
				clipboardDialogClosed = true;
				ajaxStatus.showStatus(SUGAR.language.get('asol_Reports', 'LBL_REPORT_VARIABLE_COPIED'));
				setTimeout(function(){ ajaxStatus.hideStatus() }, 2000);
			}
		}
	});
	
}
	
function getKeyUsageValue(currentKey) {
	
	var usedKeys = new Array();
	currentKey.split(";").forEach(function(currentKey, keyIndex) {
		var keyArray = currentKey.split(" ");
		usedKeys.push((keyArray.length == 3) ? keyArray[0] : currentKey); 
	});
	
	return usedKeys.join('::');
	
}

function setCodeMirrorEditor(textAreaId, editorMode) {

	if (typeof window['codeMirror_'+textAreaId] === "undefined") {
			
		window['codeMirror_'+textAreaId] = CodeMirror.fromTextArea(document.getElementById(textAreaId), {
		    lineNumbers: true,
		    lineWrapping: true,
		    matchBrackets: true,
		    mode: editorMode,
		    indentUnit: 4,
		    indentWithTabs: true,
		    enterMode: "keep",
		    tabMode: "shift",
		    autofocus: true
		});
		
		$('#'+textAreaId).next('.CodeMirror').resizable({
		    handles: 'n, s'
		});
	
	}
	
	return window['codeMirror_'+textAreaId];
	
}

function insertAtActiveCodeMirrorCursor(clickReference) {

	var codeMirrorId = $(".CodeMirror:visible").prev("textarea").attr("id");
	var value = $(clickReference).closest("td").text();
	var codeMirrorEnabled = (typeof $(".CodeMirror textarea:disabled").attr("disabled") === "undefined");
	
	if ((typeof window['codeMirror_'+codeMirrorId] !== "undefined") && codeMirrorEnabled)  {
		
		var coreMirrorCursor = window['codeMirror_'+codeMirrorId].getCursor();
		window['codeMirror_'+codeMirrorId].replaceRange(value, coreMirrorCursor, coreMirrorCursor);
		window['codeMirror_'+codeMirrorId].focus();
		
	}
	
}
	
function openExportReportDialog(button, dashletId) {

	var time = 250;
	
	window['exportButtonTimeout'] = setTimeout( function(){
		$('#asolReportExportDiv'+dashletId).show().position({
			my: "left top",
			at: "left bottom",
			of: button
		});
	}, time);

}

function generateExportedFile(fileType, attachmentFormat, reportId, isDashlet, dashletId) {

	//***** Compatibilize Old Method Arguments *****//
	if (arguments.length == 3) {
		dashletId = attachmentFormat;
		isDashlet = (dashletId != '');
	}
	//***** Compatibilize Old Method Arguments *****//
	
	var hasCharts = ((in_array(fileType, ['html', 'pdf'])) || ((fileType == 'email') && (in_array(attachmentFormat, ['html', 'pdf']))));

	if (hasCharts) {
		generateChartsPng(isDashlet, dashletId); 
	} else {
		if (typeof document["export_form"+dashletId]["pngs"] !== 'undefined') 
			document["export_form"+dashletId]["pngs"].value = '';
		if (typeof document["export_form"+dashletId]["legends"] !== 'undefined') 
			document["export_form"+dashletId]["legends"].value = '';
		if (typeof document["export_form"+dashletId]["engines"] !== 'undefined') 
			document["export_form"+dashletId]["engines"].value = '';
	}
	
	document["export_form"+dashletId]["fileType"].value = fileType;
	document["export_form"+dashletId]["mimeType"].value = getMimeTypeFromExtension(fileType);
	
	if (in_array(fileType, ["email", "app"])) {
		
		document["export_form"+dashletId]["getContent"].value = "true";
		
		var requestParameters = new Object();
		
		$('#export_form'+dashletId).find("input[type=hidden]").each(function(index, obj) {
			requestParameters[obj.name] = obj.value;
		});
		
		ajaxStatus.showStatus(SUGAR.language.get('asol_Reports', (fileType == 'email' ? 'LBL_REPORT_SENDING_EMAILS' : 'LBL_REPORT_SENDING_TO_APP')));

		$.ajax({ 
			url: 'index.php',
			type: 'POST',
			data: requestParameters,
			success: function() {
				ajaxStatus.showStatus("OK!");
				setTimeout(function(){ ajaxStatus.hideStatus() }, 2000);
			}
		});
		
	} else {

		if ((typeof window.hasPremiumJsFeatures == 'function') && (window["isMetaReport"+dashletId])) {
			
			getMetaExportedFile(reportId, dashletId);
			
		} else {
		
			$.ajax({ 
				url: 'index.php',
				type: 'POST',
				data: { 
					entryPoint: 'reportAjaxActions',
					actionTarget: 'downloadReportAttachment',
					getContent: 'false'
				},
				success: function() {
					$('#export_form'+dashletId)[0].submit();
				}
			});
	
		}
		
	}
	
}

function getMimeTypeFromExtension(fileType) {
	
	var mimeType = null;
	
	switch(fileType) {
		case "html":
			mimeType = "text/html";
			break;
		case "pdf":
			mimeType = "application/pdf";
			break;
		case "csv":
		case "csvc":
		case "xls":
		case "xlsc":
			mimeType = "application/excel";
			break;
		default:
			mimeType = "application/octet-stream";
	}
	
	return mimeType;
	
}

function highlightAssociatedRows(reference, rowType, highlight) {
	
	var targetRowClass = (rowType == 'field' ? 'asolReportsFilterRow' : 'asolReportsFieldRow');
	
	var sourceIndexClass = (rowType == 'field' ? 'index' : 'filter_index');
	var targetIndexClass = (rowType == 'field' ? 'filter_index' : 'index');
	var sourceFieldClass = (rowType == 'field' ? 'field' : 'filter_field');
	var targetFieldClass = (rowType == 'field' ? 'filter_field' : 'field');
	
	if (highlight) {
		$(reference).addClass('rowHighlightedHover');
	} else {
		$(reference).removeClass('rowHighlightedHover');
	}
	
	$("."+targetRowClass).each(function(index) {
		if (($(reference).find('.'+sourceIndexClass).val() == $(this).find('.'+targetIndexClass).val()) && ($(reference).find('.'+sourceFieldClass).val() == $(this).find('.'+targetFieldClass).val())) {
			if (highlight) {
				$(this).addClass('rowHighlightedRelated');
			} else {
				$(this).removeClass('rowHighlightedRelated');
			}
		}
	});
	
}

function generateChartsPng(isDashlet, dashletId) {
	
	var chartArray = new Array();
	var legendArray = new Array();
	var engineArray = new Array();
	
	var reportSelector = (isDashlet ? 'externalHtmlReport' + dashletId : (window['hasExternalDivContainer'] ? 'externalHtmlReport' : (window['isMetaReport'] ? 'metaReportExecution' : 'internalHtmlReport')));
	
	$("#"+reportSelector).find(".asolChartContainer").each(function(key) {

		engineArray[key] = $(this).attr("engine");
		
		switch ($(this).attr("engine")) {
			
			case "flash":
				var flashObject = $(this).find("object").get(0);
				chartArray[key] = flashObject.getEncodedPNG();
				break;
			
			case "html5":
				var html5Canvas = $(this).find("canvas").get(0);
				chartArray[key] = html5Canvas.toDataURL("image/png");
				
				var html5Legend = encodeURIComponent($(this).find("div.legend").html());
				legendArray[key] = html5Legend;
				break;
			
			case "nvd3":
				var nvd3Svg = '<svg xmlns="http://www.w3.org/2000/svg" style="width:'+$(this).find("svg").width()+'; height:'+$(this).find("svg").height()+';">'+$(this).find("svg").html()+'</svg>';
				chartArray[key] = escape(nvd3Svg);
			
				var nvd3Title = escape($(this).find("h4").html());
				legendArray[key] = nvd3Title;
				break;
		
		}
			
		document['export_form'+dashletId].pngs.value = chartArray.join('%pngSeparator');
		document['export_form'+dashletId].legends.value = legendArray.join('%legendSeparator');
		document['export_form'+dashletId].engines.value = engineArray.join(';');
		
	});
		
}