<?php

require_once("modules/asol_Reports/include_basic/reportsUtils.php");

$actionTarget = $_REQUEST['actionTarget'];
$actionValue = json_decode(html_entity_decode($_REQUEST['actionValue'], ENT_QUOTES), true);

if ($actionTarget == 'saveReportFields') {

	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	$extraParams = array('fieldsConfig' => $actionValue);
	$saveReportFieldsAlert = asol_ReportsUtils::managePremiumFeature("reportFieldsManagement", "reportFunctions.php", "saveReportFields", $extraParams);
	$returnedHtml = ($saveReportFieldsAlert !== false) ? translate('LBL_REPORT_FIELD_CREATION_OK', 'asol_Reports') : translate('LBL_REPORT_FIELD_CREATION_NOK', 'asol_Reports');
	//***********************//
	//***AlineaSol Premium***//
	//***********************//
	
} else if ($actionTarget == 'downloadReportAttachment') {
	
	$mimeType = (!empty($_REQUEST['mimeType']) ? $_REQUEST['mimeType'] : 'application/octet-stream');
	$fileName = $_REQUEST['fileName'];
	$fileContent = str_replace(" ", "+", $_REQUEST['fileContent']);
	$isBase64Content = ($_REQUEST['isBase64Content'] === 'true' ? true : false);
	$getContent = ($_REQUEST['getContent'] === 'true' ? true : false);
	
	if ($getContent) {

		//***********************//
		//***AlineaSol Premium***//
		//***********************//
		if (!$isBase64Content) {
	
			$extraParams = array(
				'phpFunction' => $fieldDef['php'],
				'currentRow' => $rowValues,
				'currentValue' => $rowValues[$fieldDef['alias']],
				'referenceAlias' => $referenceAlias
			);
			$returnedPhpFunction = asol_ReportsUtils::managePremiumFeature("reportPhpFunctions", "reportFunctions.php", "getReportPhpFunctionResultWithReplacedVariables", unserialize(base64_decode($fileContent)));
			$fileContent = ($returnedPhpFunction !== false) ? $returnedPhpFunction : $fileContent;
		
		}
		//***********************//
		//***AlineaSol Premium***//
		//***********************//
			
		
		header("Content-Type: ".$mimeType);
		header("Content-Disposition: attachment; filename=\"".$fileName."\"");
		header("Content-Description: File Transfer");
		header("Content-Transfer-Encoding: binary");
		header("Content-Length: ".mb_strlen(base64_decode($fileContent), "8bit")."\"");
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Pragma: public");
		 
		ob_clean();
		flush();
		
		$returnedHtml = base64_decode($fileContent);

	}
	
} else if ($actionTarget == 'downloadExportedReport') {

	$mimeType = (!empty($_REQUEST['mimeType']) ? $_REQUEST['mimeType'] : 'application/octet-stream');
	$fileName = $_REQUEST['fileName'];
	$fileType = $_REQUEST['fileType'];
	$getContent = ($_REQUEST['getContent'] === 'true' ? true : false);
	$isWsExecution = ($_REQUEST['isWsExecution'] === '1' ? true : false);

	if ($getContent) {

		$pngs = $_REQUEST['pngs'];
		$legends = $_REQUEST['legends'];
		$engines = $_REQUEST['engines'];
		
		if ($isWsExecution) {
		
			require_once("modules/asol_Reports/include_basic/generateReportsFunctions.php");
			
			//***********************//
			//***AlineaSol Premium***//
			//***********************//
			$extraParams = array(
				'fileName' => $fileName
			);
			$downloadedWebServiceReport = asol_ReportsUtils::managePremiumFeature("webServiceReport", "reportFunctions.php", "downloadWebServiceReport", $extraParams);
			
			$exportedReportData = ($downloadedWebServiceReport !== false ? $downloadedWebServiceReport : null);
			
			$unserializedReport = $exportedReportData['unserializedReport'];
			$reportDate = $exportedReportData['reportDate'];
			$userTZ = $exportedReportData['userTZ'];
			
			$downloadedFile = asol_ReportsGenerationFunctions::processDownloadRequest($unserializedReport, $userTZ, $reportDate, $fileType, $pngs, $legends, $engines);
			//***********************//
			//***AlineaSol Premium***//
			//***********************//
			
		} else {

			require_once("modules/asol_Reports/include_basic/generateReportsFunctions.php");
			
			$exportedReportData = asol_ReportsGenerationFunctions::getExportedSerializedReportFileContent($fileName);
			$unserializedReport = $exportedReportData['unserializedReport'];
			$reportDate = $exportedReportData['reportDate'];
			$userTZ = $exportedReportData['userTZ'];
			
			$downloadedFile = asol_ReportsGenerationFunctions::processDownloadRequest($unserializedReport, $userTZ, $reportDate, $fileType, $pngs, $legends, $engines);
			
		}
		
		$returnedHtml = $downloadedFile['fileContent'];
		
		header("Content-Type: ".$mimeType);
		header("Content-Disposition: attachment; filename=\"".$downloadedFile['fileName']."\"");
		header("Content-Description: File Transfer");
		header("Content-Transfer-Encoding: binary");
		header("Content-Length: ".mb_strlen($returnedHtml, "8bit")."\"");
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Pragma: public");
		 
		ob_clean();
		flush();
		
	}
	
} else if ($actionTarget == 'getCurrentReportSQL') {
	
	require_once("modules/asol_Reports/include_basic/generateReportsFunctions.php");
	
	global $current_user;
	
	$currentSql = null;
	$subQueryMode = ($_REQUEST['subQueryMode'] == '1' ? true : false);
	
	if ($subQueryMode) {

		$subQueryData = json_decode(html_entity_decode($_REQUEST['subQuery']), true);
		
		if (!empty($subQueryData['module'])) {

			$phpDateTime = new DateTime(null, new DateTimeZone($current_user->getPreference("timezone")));
			$hourOffset = $phpDateTime->getOffset();
			
			$currentUserAsolConfig = asol_ReportsGenerationFunctions::getCurrentUserAsolConfig($current_user->id);
					
			$alternativeDb = ($_REQUEST['selectedDb'] >= 0) ? $_REQUEST['selectedDb'] : false;
			$hasDeleted = (isset($_REQUEST['hasDeleted']) ? ($_REQUEST['hasDeleted'] == '1' ? true : false) : false);
			$externalDataBaseQueryParams = asol_ReportsGenerationFunctions::manageExternalDatabaseQueries($alternativeDb, $subQueryData['module'], true);
			$domainField = $externalDataBaseQueryParams["domainField"];
			
			//***********************//
			//***AlineaSol Premium***//
			//***********************//
			$predefinedTemplatesResult = asol_ReportsUtils::managePremiumFeature("templatesReports", "reportFunctions.php", "getPredefinedTemplates", array('json_encode' => false, 'currentModule' => null/*$report_module*/));
			$predefinedTemplates = ($predefinedTemplatesResult !== false ? $predefinedTemplatesResult : null);
			//***********************//
			//***AlineaSol Premium***//
			//***********************//
			
			$extraParams = array(
				'alternativeDb' => $_REQUEST['selectedDb'],
				'hasDeleted' => $hasDeleted,
				'subQuery' => $subQueryData, 
				'index' => $_REQUEST['index'], 
				'hourOffset' => $hourOffset, 
				'quarterMonth' => $currentUserAsolConfig["quarter_month"], 
				'weekStart' => $currentUserAsolConfig["week_start"], 
				'currentUser' => $current_user, 
				'schedulerCall' => false, 
				'reportDomain' => $current_user->asol_default_domain, 
				'domainField' => $domainField, 
				'sqlTemplates' => $predefinedTemplates['sql']
			);
			
			$currentSql = asol_ReportsUtils::managePremiumFeature("subReports", "reportFunctions.php", "getSqlFromSubReport", $extraParams);
		
		}	
		
		$returnedHtml = ((!empty($currentSql) && ($currentSql !== false)) ? $currentSql : 'No Query Available');
		
	}
	
}

echo $returnedHtml;
