<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

$dictionary['Sequences'] = array(
		'table' => 'sequences',
		'audited' => true,
		'comment' => 'Sequences Module',
		'duplicate_merge' => true,
		'unified_search' => true,
		'optimistic_locking' => true,
		'engine' => 'innodb',

		'fields' => array(
		        'draw' => array(
						'type' => 'varchar',
						'name' => 'draw',
						'vname' => 'LBL_DRAW',
		        		'popupHelp' => 'LBL_DRAW_HINT',
						'len' => '255',
		                'source' => 'non-db',
		        ),
				'initial_sequencing' => array(
						'type' => 'custom',
						'name' => 'initial_sequencing',
						'vname' => 'LBL_INITIAL_SEQUENCING',
				        'source' => 'non-db',
				),
				'code_prefix' => array(
						'type' => 'varchar',
						'name' => 'code_prefix',
						'vname' => 'LBL_CODE_PREFIX',
						'audited' => true,
						'required' => false,
				),
				'code_suffix' => array(
						'name' => 'code_suffix',
						'vname' => 'LBL_CODE_SUFFIX',
						'type' => 'varchar',
						'audited' => true,
						'required' => false,
				),
				'code_seperator' => array(
						'type' => 'char',
						'len' => '1',
						'name' => 'code_seperator',
						'vname' => 'LBL_CODE_SEPERATOR',
						'audited' => true,
						'required' => false,
				),
				'code_field' => array(
						'type' => 'varchar',
						'name' => 'code_field',
						'vname' => 'LBL_CODE_FIELD',
						'audited' => true,
						'required' => true,
						'function'=>array('name'=>'getFieldDropDown', 'returns'=>'html', 'include' => 'modules/Sequences/functions.php'),
				),
				'sequence_add_date' => array(
						'type' => 'bool',
						'name' => 'sequence_add_date',
						'vname' => 'LBL_ADD_DATE',
						'audited' => true,
						'required' => false,
						'massupdate' => false,
				),
				'sequence_readonly' => array(
						'type' => 'bool',
						'name' => 'sequence_readonly',
						'vname' => 'LBL_READONLY',
						'audited' => true,
						'required' => false,
						'massupdate' => false,
				),
				'sequence_date_format' => array(
						'type' => 'enum',
						'name' => 'sequence_date_format',
						'vname' => 'LBL_DATE_FORMAT',
						'audited' => true,
						'required' => false,
						'massupdate' => false,
						'options' => 'sequences_date_formates_dom',
				),
				'zero_padding' => array(
						'type' => 'int',
						'name' => 'zero_padding',
						'vname' => 'LBL_ZERO_PADDING',
						'audited' => true,
						'massupdate' => false,
						'required' => false,
				),
				'type' => array(
						'type' => 'enum',
						'name' => 'type',
						'vname' => 'LBL_TYPE',
						'audited' => true,
						'required' => true,
						'massupdate' => false,
						'dbType' => 'int',
						'options' => 'sequences_types_dom',
				),
				'first_num' => array(
						'type' => 'int',
						'name' => 'first_num',
						'vname' => 'LBL_FIRST_NUM',
						'audited' => true,
						'massupdate' => false,
						'required' => false,
						'disable_num_format' => true,
				),
				'next_num' => array(
						'type' => 'int',
						'name' => 'next_num',
						'vname' => 'LBL_NEXT_NUM',
						'audited' => true,
						'massupdate' => false,
						'required' => false,
						'disable_num_format' => true,
				),
				'parent_type' => array (
						'name' => 'parent_type',
						'type' => 'custom',
						'dbType' => 'varchar',
						'vname' => 'LBL_PARENT_TYPE',
						'required' => true,
						'massupdate' => false,
						//'default' => 'Accounts',
						'function'=>array('name'=>'getParentDropDown', 'returns'=>'html', 'include' => 'modules/Sequences/functions.php'),
				),
				'parent_id' => array (
						'name' => 'parent_id',
						'vname' => 'LBL_PARENT_ID',
						'type' => 'id',
						'required' => true,
						'reportable'=>false,
						'massupdate' => false,
						'source' => 'non-db',
				),
				'parent_name' => array(
						'name'=> 'parent_name',
						'parent_type' => 'record_type_display',
						'type_name' => 'parent_type',
						'id_name' => 'parent_id',
						'vname' => 'LBL_PARENT_NAME',
						'type' => 'parent',
						'group' => 'parent_name',
						'source' => 'non-db',
						'required' => true,
						'massupdate' => false,
						'options' => 'record_type_display_notes',
				),
		        'sequence_ordering' => array(
						'name'=> 'sequence_ordering',
						'vname' => 'LBL_SEQUENCE_ORDERING',
						'type' => 'custom',
		                'dbType' => 'varchar',
						'required' => false,
						'massupdate' => false,
		                'studio' => false
				),
		),
		'indices' => array(
				array('name' =>'idx1', 'type' =>'index',   'fields'=>array('assigned_user_id')),
				array('name' =>'idx2', 'type' =>'index',   'fields'=>array('modified_user_id')),
				array('name' =>'idx3', 'type' =>'index',   'fields'=>array('created_by')),
		),
		'relationships' => array (),
);

require_once('include/SugarObjects/VardefManager.php');
VardefManager::createVardef('Sequences','Sequences', array('basic','assignable'));

?>
