<?php
require_once('modules/Sequences/Sequences.php');

/**
 * this function just build the html for displaying in the EditView.
*/
function getFieldDropDown($focus, $field='code_field', $value='', $view='DetailView') {
	if($view == 'EditView' || $view == 'MassUpdate' || $view == 'QuickCreate') {
		if (empty($focus->parent_type)) {
			$focus->parent_type = 'Accounts';
		}

		global $current_language, $mod_strings;

		$metadataFile = null;
		$foundViewDefs = false;
		$viewdefs = array();

		if(!empty($_REQUEST['data_type'])){
			$data_type = $_REQUEST['data_type'];
		} else if(!empty($focus->type)){
			$data_type = $focus->type;
		} else {
			$data_type = 1;
		}

		if(file_exists('custom/modules/' . $focus->parent_type . '/metadata/editviewdefs.php')){
			$metadataFile = 'custom/modules/' . $focus->parent_type . '/metadata/editviewdefs.php';
			$foundViewDefs = true;
		} else {
			if(file_exists('custom/modules/'.$focus->parent_type.'/metadata/metafiles.php')){
				require_once('custom/modules/'.$focus->parent_type.'/metadata/metafiles.php');
				if(!empty($metafiles[$focus->parent_type]['editviewdefs'])){
					$metadataFile = $metafiles[$focus->parent_type]['editviewdefs'];
					$foundViewDefs = true;
				}
			} elseif(file_exists('modules/'.$focus->parent_type.'/metadata/metafiles.php')){
				require_once('modules/'.$focus->parent_type.'/metadata/metafiles.php');
				if(!empty($metafiles[$focus->parent_type]['editviewdefs'])){
					$metadataFile = $metafiles[$focus->parent_type]['editviewdefs'];
					$foundViewDefs = true;
				}
			}
		}

		if(!$foundViewDefs AND file_exists('modules/'.$focus->parent_type.'/metadata/editviewdefs.php')){
			$metadataFile = 'modules/'.$focus->parent_type.'/metadata/editviewdefs.php';
			$foundViewDefs = true;
		}

		$GLOBALS['log']->debug("metadatafile for fields in sequence =". $metadataFile);

		// include the file for scanning in the arrey for all possible fields
		if($foundViewDefs){

			$bean = null;
			$bean_mod_strings = return_module_language($current_language, $focus->parent_type);

			if(!empty($GLOBALS['beanList'][$focus->parent_type])){
				$class = $GLOBALS['beanList'][$focus->parent_type];
				if(!empty($GLOBALS['beanFiles'][$class])){
					require_once($GLOBALS['beanFiles'][$class]);

					// force to build the aimed bean and the cached vardefs file
					// only here we have all obligatory fields for a possible sequence
					$bean = new $class();

				}
			}

			include_once($metadataFile);

			$html = "<select id='code_field' name='code_field' tabindex='2'>";
			foreach($viewdefs[$focus->parent_type]['EditView']['panels'] as $group => $rows){
				// loop through the whole editviewdefs and find out, which fields are allowed to have a sequence

				if(is_string($group) AND $group != "default"){
					// if there are some labels for each panel
					$html .= "<optgroup label='".(isset($bean_mod_strings[strtoupper($group)]) ? $bean_mod_strings[strtoupper($group)] : strtoupper($group))."'>";
				}

				foreach($rows as $row){
					if(!is_array($row)){
						// diffenrent settings in editviewdefs can crash the foreach. force artificial array
						$row = array($row);
					}
					foreach($row as $column){

						if(is_array($column)){
							$col = $column['name'];
						} else {
							$col = $column;
						}

						if(@$bean->field_defs[$col]['source'] != 'non-db' AND (isset($bean->field_defs[$col]['type']) && in_array($bean->field_defs[$col]['type'], $focus->supported_types[$data_type])) AND !empty($col)){
							$html .= "<option value='$col'";
							if($value == $col){
								$html .= " selected='selected'";
							}
							if(isset($bean->field_defs[$col]['default']) && ($bean->field_defs[$col]['default'] === 0 || !empty($bean->field_defs[$col]['default']))){
								$html .= "disabled='disabled'";
							}
							$html .= ">$col</option>";
						}
					}
				}

				if(is_string($group)){
					$html .= "</optgroup>";
				}
			}
			$html .= "</select><br/>".$mod_strings['LBL_HINT_FOR_FIELDS'];

		} elseif(!empty($focus->parent_type)) {
			$html = "<input id='code_field' name='code_field' value='$focus->code_field' type='text' tabindex='2'/>";
			$html .= "<br/>".$mod_strings['LBL_NO_EDITVIEWDEFS'];
		}

		return $html;

	} else {
		return $focus->code_field;
	}
}

function getParentDropDown($focus, $field='parent_type', $value='', $view='DetailView') {
	$views = array('EditView', 'MassUpdate', 'QuickCreate', 'SearchForm_basic_search', 'SearchForm_advanced_search');
	if(in_array($view, $views)) {
		global $moduleList, $modInvisList, $app_list_strings;
		asort($moduleList);
		// global $beanList;
		// asort($beanList);

		if(empty($value)) {
			if (isset($_REQUEST[$field.'_basic'])) {
				$value = $_REQUEST[$field.'_basic'];
			}
			if (isset($_REQUEST[$field.'_advanced'])) {
				$value = $_REQUEST[$field.'_advanced'];
			}
		}
		// sugarbeans, where we dont want to have a sequence. core modules with key functions
		// here u can add more beans, u dont want to be listed for sequences
		// switch beans or modules to the level u want to habe sequences
		$beans_noSequence = array('ACLRole', 'ACLAction', 'vCal', 'iFrame', 'Tracker',
				'Feed', 'Audit', 'Role', 'Relationship', 'SavedSearch',
				'Dashboard', 'Group', 'Version', 'ImportMap', 'Connectors',
				'FieldsMetaData', 'DynamicField', 'CustomFields', 'MergeRecord',
				'UserPreference', 'Administration', 'UsersLastImport', 'Release',
				'EmailMan', 'EmailTemplate', 'EmailMarketing', 'EmailAddress',
				'InboundEmail', 'DocumentRevision', 'Currency', 'CampaignLog',
				'CampaignTracker', 'SugarFeed', 'Scheduler', 'SchedulersJob',
		);

		// sugarmodules, where we dont want to have a sequence. core modules with key functions
		// here u can add more modules, u dont want to be listed for sequences
		$modules_noSequence = array('Feed', 'Calendar', 'Activities', 'History', 'Home');

		$html = "";
		if($view != 'SearchForm_basic_search' && $view != 'SearchForm_advanced_search') {
			$html = "<select id='$field' name='$field' tabindex='2' onchange='changeFields(this.value);'>";
		}
		
		foreach ($moduleList as $module) {
			if(!in_array($module, $modules_noSequence) && !in_array($module, $modInvisList)) {
				$html .= "<option value='$module'";
				if ((is_array($value) && in_array($app_list_strings['moduleList'][$module], $value)) ||
				(is_array($value) && in_array($module, $value)) ||
				($value == $app_list_strings['moduleList'][$module] && $value != '') ||
				($value == $module)) {
					$html .= " selected='selected'";
				}
				$html .= ">".(empty($app_list_strings['moduleList'][$module]) ? $module : $app_list_strings['moduleList'][$module])."</option>";
			}
		}
		if($view != 'SearchForm_basic_search' && $view != 'SearchForm_advanced_search') {
			$html .= "</select>";
		}
		return $html;
	} else {
		return $focus->{$field};
	}
}

if(@$_REQUEST['to_pdf'] && @$_REQUEST['search_form_only'] != 'true'){
	$focus = new Sequences();
	$focus->parent_type = $_REQUEST['parent_type'];
	echo getFieldDropDown($focus, '', '', 'EditView');
}
?>
