<?php

if (!defined('sugarEntry') || !sugarEntry)
    die('Not A Valid Entry Point');

require_once('include/utils.php');
require_once('include/utils/logic_utils.php');

class Sequences extends Basic {

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $code_suffix;
    public $code_seperator;
    public $code_field;
    public $sequence_add_date;
    public $sequence_date_format;
    public $zero_padding;
    public $first_num;
    public $next_num;
    public $code_prefix;
    public $sequence_readonly;
    public $type;
    public $draw;
    public $initial_sequencing;
    public $sequence_ordering;
    public $parent_type;
    public $parent_id;
    public $parent_name;
    public $supported_types = array(1 => array('varchar', 'name', 'text'), 2 => array('tinyint', 'int', 'float', 'double'));
    public $module_dir = "Sequences";
    public $table_name = "sequences";
    public $object_name = "Sequences";
    public $new_schema = true;
    public $importable = true;
    private $use_transactions = false;

    public function Sequences() {
        parent::Basic();

        global $dictionary;
        if (!empty($dictionary[$this->object_name]['engine']) && strtolower($dictionary[$this->object_name]['engine']) == "innodb") {
            $this->use_transactions = true;
        }
    }

    public function get_summary_text() {
        return "Sequence: " . $this->name;
    }

    public function fill_in_additional_detail_fields() {
        parent::fill_in_additional_detail_fields();

        global $app_list_strings;
        $this->parent_type = isset($app_list_strings['moduleList'][$this->parent_type]) ? $app_list_strings['moduleList'][$this->parent_type] : $this->parent_type;
        $this->draw = $this->getDraw($this->id);

        if (empty($this->id) || empty($this->sequence_ordering)) {
            $this->sequence_ordering = array('code_prefix', 'first_num', 'sequence_date_format', 'code_suffix');
        } else {
            $this->sequence_ordering = explode("|", $this->sequence_ordering);
        }
    }

    private function updateNextNum($id, $next_num) {

        $update = "UPDATE " . $this->table_name . " SET next_num = '" . $next_num . "' WHERE id = '" . $id . "'";
        $this->db->query($update);
    }

    /**
     * function for retrieving the maximum sequence
     * the whole field is splitted by sql functions for having the only the number and parse it into an INT
     */
    private function getMaxValue($field, $table, $rule) {

        global $sugar_config;

        $db_type = strtolower($sugar_config['dbconfig']['db_type']);
        $ordering = explode("|", $rule['sequence_ordering']);
        $offLeft = $offRight = $i = 0;
        if ($rule['code_prefix'] != "") {
            $offRight += strlen($rule['code_prefix']) + strlen($rule['code_seperator']);
        }
        if ($rule['code_suffix'] != "") {
            $offRight += strlen($rule['code_suffix']) + strlen($rule['code_seperator']);
        }
        if (!empty($rule['sequence_add_date']) && $rule['sequence_date_format'] != "") {
            $offRight += strlen(date($rule['sequence_date_format'])) + strlen($rule['code_seperator']);
        }
        $sql = "SELECT MAX";
        if ($ordering[0] == 'first_num') {
            // number at front
            if ($db_type == 'mssql') {
                $sql .= "( CAST( SUBSTRING( $field, 1, ( LEN( $field ) - $offRight ) ) AS INT ) )";
            } else if ($db_type == 'mysql') {
                $sql .= "( CAST( SUBSTR( $field, 1, ( LENGTH( $field ) - $offRight ) ) AS UNSIGNED ) )";
            }
        } else if ($ordering[3] == 'first_num') {
            // number at end
            if ($db_type == 'mssql') {
                $sql .= "( CAST( SUBSTRING( $field, $offRight + 1 ) AS INT ) )";
            } else if ($db_type == 'mysql') {
                $sql .= "( CAST( SUBSTR( $field, $offRight + 1 ) AS UNSIGNED ) )";
            }
        } else {
            while ($i < count($ordering)) {
                if ($ordering[$i] == 'first_num') {
                    break;
                } else {
                    if ($ordering[$i] == 'sequence_date_format' && !empty($rule['sequence_add_date'])) {
                        $offLeft += strlen(date($rule[$ordering[$i]]));
                    } else {
                        $offLeft += strlen($rule[$ordering[$i]]);
                    }
                    if (!empty($rule['code_seperator'])) {
                        $offLeft += strlen($rule['code_seperator']);
                    }
                }
                $i++;
            }

            if ($db_type == 'mssql') {
                $sql .= "( CAST( SUBSTRING( $field, $offLeft + 1, ( LEN( $field ) - $offRight ) ) AS INT ) )";
            } else if ($db_type == 'mysql') {
                $sql .= "( CAST( SUBSTR( $field, $offLeft + 1, ( LENGTH( $field ) - $offRight ) ) AS UNSIGNED ) )";
            }
        }

        $sql .= " AS $field
		FROM $table ";

        if ($this->db->tableExists($table . "_cstm")) {
            $sql .= "LEFT JOIN " . $table . "_cstm ON " . $table . "_cstm.id_c = " . $table . ".id ";
        }

        $sql .= "WHERE " . ($db_type == 'mssql' ? "LEN" : "LENGTH") . "( $field ) - $offRight > 0 ORDER BY $field ";
        $GLOBALS['log']->info("finding maxValue query is: " . $sql);
        $result = $this->db->query($sql, true, " Error receiving the max sequence of $table for field $field: ");
        if (empty($result)) {
            return 0;
        }

        $row = $this->db->fetchByAssoc($result);
        if (empty($row)) {
            return 0;
        }

        return (int) $row[$field];
    }

    /**
     * function returns the new number for the next sequence.
     * the number is stored at the end of the new sequence
     */
    private function getNextNumber($rule, $maxValue) {
        return sprintf("%0" . $rule['zero_padding'] . "s", $maxValue);
    }

    /**
     *
     * retrieve rules for sequence
     * @param string id of sequence field
     * @return array rules
     */
    private function getRules($id) {
        $row = array();
        $sql = "SELECT code_prefix, code_suffix, code_seperator, sequence_add_date,
				sequence_date_format, zero_padding, first_num, next_num, sequence_ordering 
				FROM $this->table_name 
				WHERE id = '$id'";
        $result = $this->db->query($sql, false, "error with select of stored informations for the field");
        if (!empty($result)) {
            $row = $this->db->fetchByAssoc($result);
        }
        return $row;
    }

    /**
     * function to generate the automatic sequence for a specified module
     * the sequence is build by the parameters saved at the company settings in the administration area
     * the interation will be generated by the params zeropadding and firstnum
     *
     * @param id $id - the id of the field
     * @param string $field - the name of the field
     * @param string $bean_table - the name fo the table for the aimed sequence
     * @return string - the new sequence
     */
    public function buildSequence($id, $field, $bean_table, &$maxValue = 0) {

        $sequence = "";

        if ($this->use_transactions) {
            // mysqli supports multi_queries
            $this->db->query("BEGIN");
        }

        $row = $this->getRules($id);

        $ordering = explode("|", $row['sequence_ordering']);

        for ($i = 0; $i < count($ordering); $i++) {

            if ($i > 0 && $row[$ordering[$i]] != "" && $sequence != "") {
                if ($ordering[$i] == 'sequence_date_format') {
                    if ($row['sequence_add_date'] == 1) {
                        $sequence .= $row['code_seperator'];
                    }
                } else {
                    $sequence .= $row['code_seperator'];
                }
            }
            if ($ordering[$i] == 'first_num') {
                if ($maxValue === 0) {
                    $maxValue = $this->getMaxValue($field, $bean_table, $row);
                    if ($maxValue === 0) {
                        $maxValue = (int) $row['first_num'];
                        $sequence .= $this->getNextNumber($row, $maxValue);
                        $GLOBALS['log']->info("current maxValue is: " . $maxValue);
                    } else {
                        $sequence .= $this->getNextNumber($row, $maxValue + 1);
                        $GLOBALS['log']->info("current maxValue is: " . $maxValue + 1);
                    }
                } else {
                    // this can only be called, if we have a batch job, because maxValue is a hard reference
                    $maxValue = (int) $row['next_num'];
                    $sequence .= $this->getNextNumber($row, $maxValue);
                    $GLOBALS['log']->info("current maxValue is: " . $maxValue);
                }
                // alternative way could be, use a static counter and increment the memory var. its faster but lesser safe
                $this->updateNextNum($id, (!empty($row['first_num']) || (int) $row['first_num'] === 0) ? ++$maxValue : '');
            } else if ($ordering[$i] == 'sequence_date_format') {
                if ($row['sequence_add_date'] == 1) {
                    $sequence .= date($row['sequence_date_format']);
                }
            } else if (!empty($row[$ordering[$i]])) {
                $sequence .= $row[$ordering[$i]];
            }
        }

        if ($this->use_transactions) {
            $this->db->query("COMMIT");
        }

        return $sequence;
    }

    public function createLogicHook() {
        // let the index of the hook null, to ensure the right order, if there are more hooks with the same event
        $hook = array(null, $this->module_dir, 'modules/' . $this->module_dir . '/HooksForSequence.php', 'HooksForSequence', 'after_retrieve');
        check_logic_hook_file($this->parent_type, 'after_retrieve', $hook);
        $hook = array(null, $this->module_dir, 'modules/' . $this->module_dir . '/HooksForSequence.php', 'HooksForSequence', 'before_save');
        check_logic_hook_file($this->parent_type, 'before_save', $hook);
    }

    public function mark_deleted($id) {

        parent::mark_deleted($id);

        // we need to check, if there are more sequences with the same module type
        // otherwise I would delete a single hook, which represents the other sequennces by the same parent_type
        $sql = "SELECT count(*) c FROM " . $this->table_name . " WHERE deleted = 0 AND parent_type = '" . $this->parent_type . "'";
        $row = $this->db->fetchOne($sql);

        if ($row && $row['c'] > 0 && file_exists('custom/modules/' . $this->parent_type . '/logic_hooks.php')) {

            $hook_array = array();
            $rewrite_hooks = false;

            include('custom/modules/' . $this->parent_type . '/logic_hooks.php');

            if (count($hook_array) > 0) {
                $j = 0;
                foreach ($hook_array as $key => $array) {
                    $j++;

                    if (is_array($array)) {

                        foreach ($array as $i => $hook) {
                            if ($hook[1] == $this->module_dir) {
                                unset($hook_array[$key][$i]);
                                $rewrite_hooks = true;
                            }
                        }
                    }

                    if ($i == 0 AND $j <= 1) {
                        unlink('custom/modules/' . $this->parent_type . '/logic_hooks.php');
                        $rewrite_hooks = false;
                    }
                }
            }

            if ($rewrite_hooks) {

                $fp = sugar_fopen('custom/modules/' . $this->parent_type . '/logic_hooks.php', 'wb');

                fwrite($fp, replace_or_add_logic_type($hook_array));
                fclose($fp);
            }
        }
    }

    public function getDraw($id = "") {

        if (empty($id)) {
            $id = $this->id;
        }

        $sql = "SELECT code_prefix, code_suffix, code_seperator, sequence_add_date,
		sequence_date_format, zero_padding, next_num, first_num, sequence_ordering 
		FROM $this->table_name
		WHERE id = '$id'";

        $result = $this->db->query($sql, false, "error with select of stored informations for build the DRAW");
        $row = $this->db->fetchByAssoc($result);

        $this->draw = "";
        $ordering = explode("|", $row['sequence_ordering']);

        for ($i = 0; $i < count($ordering); $i++) {
            if ($i > 0 && $row[$ordering[$i]] != "" && $this->draw != "") {
                if ($ordering[$i] == 'sequence_date_format') {
                    if ($row['sequence_add_date'] == 1) {
                        $this->draw .= $row['code_seperator'];
                    }
                } else {
                    $this->draw .= $row['code_seperator'];
                }
            }
            if ($ordering[$i] == 'first_num') {
                if (!empty($row['next_num']) || (int) $row['next_num'] === 0) {
                    $this->draw .= $this->getNextNumber($row, $row['next_num']);
                }
            } else if ($ordering[$i] == 'sequence_date_format') {
                if ($row['sequence_add_date'] == 1) {
                    $this->draw .= date($row['sequence_date_format']);
                }
            } else if (!empty($row[$ordering[$i]])) {
                $this->draw .= $row[$ordering[$i]];
            }
        }

        return $this->draw;
    }

    public function get_list_view_data() {

        global $current_language;
        $app_list_strings = return_app_list_strings_language($current_language);
        $mod_strings = return_module_language($current_language, $this->module_dir);

        $the_array = parent::get_list_view_data();
        // rebuild hooks, if they are missing. e.g. after installing with keeping the tables
        $this->createLogicHook();

        $the_array['PARENT_TYPE'] = isset($app_list_strings['moduleList'][$the_array['PARENT_TYPE']]) ? $app_list_strings['moduleList'][$the_array['PARENT_TYPE']] : $the_array['PARENT_TYPE'];
        $the_array['DRAW'] = $this->getDraw($this->id);
        $the_array['INITIAL_SEQUENCING'] = '<button class="button" type="button" onclick="displayWarning(\'' . $this->id . '\');">' . $mod_strings['LBL_INITIAL_FILL'] . '</button>';

        return $the_array;
    }

    public function bean_implements($interface) {
        switch ($interface) {
            case 'ACL':return true;
        }
        return false;
    }

    public function save($check_notify = false) {
        if (empty($this->id)) {
            $this->next_num = $this->first_num;
        }
        if (isset($_REQUEST['position']) && count($_REQUEST['position'] > 0)) {
            $this->sequence_ordering = implode("|", $_REQUEST['position']);
        }

        return parent::save($check_notify);
    }

    public static function doSchedulerTask() {
        
        $bean = new Sequences();
        $sequences = $bean->get_full_list();
        foreach ($sequences as $sequence) {
            $sequence->inititalFill();
        }
    }

    public function inititalFill() {

        if (empty($this->id)) {
            return;
        }

        $tmp = null;
        $maxValue = 0;
        // select all the important fields for generating the sequence in the custom logic
        if (!empty($GLOBALS['beanList'][$this->parent_type])) {
            $class = $GLOBALS['beanList'][$this->parent_type];
            if (!empty($GLOBALS['beanFiles'][$class])) {
                require_once($GLOBALS['beanFiles'][$class]);

                // force to build the aimed bean and the cached vardefs file
                // only here we have all obligatory fields for a possible sequence
                $tmp = new $class();
            }
        }

        if (!$tmp) {
            return;
        }

        $sql = "";
        if ($this->db->tableExists($tmp->table_name . "_cstm")) {
            $sql = "SELECT id, id_c, " . $this->code_field . " 
	                FROM " . $tmp->table_name . " LEFT JOIN " . $tmp->table_name . "_cstm ON " . $tmp->table_name . "_cstm.id_c = " . $tmp->table_name . ".id 
	                WHERE " . $tmp->table_name . ".deleted = 0 ";
        } else {
            $sql = "SELECT id, " . $this->code_field . " 
	                FROM " . $tmp->table_name . " 
	                WHERE " . $tmp->table_name . ".deleted = 0 ";
        }
        $sql .= "ORDER BY " . $tmp->table_name . ".date_entered ASC";
        $result = $this->db->query($sql, false, "error at initial fill for " . $this->parent_type);

        if (empty($result)) {
            return;
        } else {

            while ($row = $this->db->fetchByAssoc($result)) {
                if (empty($row[$this->code_field]) && $row[$this->code_field] !== '0' && $row[$this->code_field] !== 0) {
                    $sequence = $this->buildSequence($this->id, $this->code_field, $tmp->table_name, $maxValue);
                    if (isset($tmp->field_defs[$this->code_field]['source']) && $tmp->field_defs[$this->code_field]['source'] == 'custom_fields') {
                        if (empty($row['id_c'])) {
                            $this->db->query("INSERT INTO " . $tmp->table_name . "_cstm SET " . $this->code_field . " = '" . $sequence . "', id_c = '" . $row['id'] . "'");
                        } else {
                            $this->db->query("UPDATE " . $tmp->table_name . "_cstm SET " . $this->code_field . " = '" . $sequence . "' WHERE id_c = '" . $row['id'] . "'");
                        }
                    } else {
                        $this->db->query("UPDATE " . $tmp->table_name . " SET " . $this->code_field . " = '" . $sequence . "' WHERE id = '" . $row['id'] . "'");
                    }
                }
            }
        }

        return null;
    }

}
