<?php

require_once('modules/Sequences/Sequences.php');

class HooksForSequence {

    private $bean;
    private $sequence;
    private $modulePrefix;
    // added for backdoor hack for ajax_load support at sugar
    private $script = "";
    private static $ajaxHelper = false;
    private static $beanScripts = array();
    private static $whiteActions = array('ConvertLead', 'EditView', 'QuickCreate', 'SubpanelCreates', 'Import');

    public function HooksForSequence() {
        
    }

    /**
     * set the references and checks, if the given module in the request is allowed to build a sequence
     * remember: "after_retrieve" is the important hook for each module.
     * "after_ui_frame" ist just for the access into the logic by creating a new record!
     */
    private function initialize(&$bean) {

        $this->bean = & $bean;
        $this->sequence = new Sequences();

        $hook_is_ready = false;
        $hook_array = array();

        if (!empty($_REQUEST['ajax_load']) && !empty($this->bean->id)) {
            // dont remove that. it is mandatory for saving the actual JS script into an static memory for later output
            HooksForSequence::$ajaxHelper = true;
            HooksForSequence::$beanScripts[$this->bean->id] = "";
        }

        if (file_exists('custom/modules/' . $bean->module_dir . '/logic_hooks.php')) {
            include('custom/modules/' . $bean->module_dir . '/logic_hooks.php');

            if (isset($hook_array['after_retrieve']) && is_array($hook_array['after_retrieve'])) {
                foreach ($hook_array['after_retrieve'] as $hook) {
                    if (($hook[1] == $this->sequence->module_dir)) {
                        return $hook_is_ready = true;
                    }
                }
            }
        }

        return $hook_is_ready;
    }

    /**
     * "normal" logic hook call called by custom_logic "after_retrieve"
     * when a value need to be updated or is not set right now, this function will help with the autofill sequence
     */
    public function after_retrieve(&$bean, $event, $arguments) {

        if ($this->initialize($bean) && $bean->module_dir == $_REQUEST['module']) {
            // only when there is a view to editview or quickcreate on subpanel
            if (in_array($_REQUEST['action'], self::$whiteActions)) {
                $this->setHookedFieldValues();
            }
        }

        return null;
    }

    /**
     * "normal" logic hook call called by custom_logic "before_save"
     * when a value need to be updated or is not set right now, this function will help with the autofill sequence
     * this is also a recreate of a sequence, to backup the delta time from edit to save action
     */
    public function before_save(&$bean, $event, $arguments) {

        if ($this->initialize($bean) && ($bean->module_dir == $_REQUEST['module'] || $bean->in_import === true)) {
            $this->setHookedFieldValues();
        }
        return null;
    }

    /**
     * logic hook call after the rendering of the frame. standard sugar hook since 4.5
     * this method is always called by the general loic hooks file. here no bean exists, thus we have to create the target bean
     * if there is no file in /custom/modules/logic_hooks.php with the hook "after_ui_frame" this call won't be possible!
     */
    public function after_ui_frame($event, $arguments) {
        // is called by the generic hook array. need to be activated
        $module = "";

        if (empty($_REQUEST['record'])) {
            // hier geht die sequence vom subpanelcreate aus und das zielmodul ist param target_module
            if (!empty($_REQUEST['target_module'])) {
                $module = $_REQUEST['target_module'];
            } else {
                $module = $_REQUEST['module'];
            }

            if (!empty($GLOBALS['beanList'][$module])) {
                $class = $GLOBALS['beanList'][$module];
                if (!empty($GLOBALS['beanFiles'][$class])) {
                    require_once($GLOBALS['beanFiles'][$class]);

                    if ($this->initialize(new $class()) && (in_array($_REQUEST['action'], self::$whiteActions) || in_array($_REQUEST['target_action'], self::$whiteActions))) {
                        $this->setHookedFieldValues();
                    }
                }
            }
        } else if ($_REQUEST['action'] == 'ConvertLead' && $_REQUEST['module'] == 'Leads') {
            // just for convert.lead action
            $medataDataFile = 'modules/Leads/metadata/convertdefs.php';
            if (file_exists("custom/$medataDataFile")) {
                $medataDataFile = "custom/$medataDataFile";
            }
            $viewdefs = array();
            include($medataDataFile);
            foreach ($viewdefs as $module => $vdef) {
                if (!empty($GLOBALS['beanList'][$module])) {
                    $class = $GLOBALS['beanList'][$module];
                    if (!empty($GLOBALS['beanFiles'][$class])) {
                        require_once($GLOBALS['beanFiles'][$class]);
                        $this->initialize(new $class());
                        if (in_array($_REQUEST['action'], self::$whiteActions) || in_array($_REQUEST['target_action'], self::$whiteActions)) {
                            $this->modulePrefix = $module;
                            $this->setHookedFieldValues();
                        }
                    }
                }
            }
        }

        if (self::$ajaxHelper == true && isset(HooksForSequence::$beanScripts[$_REQUEST['record']])) {
            // now we can output the JS script and remove it without disturbing the JSON content and leading into an error!
            echo HooksForSequence::$beanScripts[$_REQUEST['record']];
            unset(HooksForSequence::$beanScripts[$_REQUEST['record']]);
            if (count(HooksForSequence::$beanScripts) == 0) {
                HooksForSequence::$ajaxHelper = false;
            }
        }

        return null;
    }

    /**
     * display the generated sequences at the form
     * also blocks if choosen the field for further manual entries
     */
    private function displayValueByJS($field, $readonly, $value) {

        if (!empty($this->modulePrefix)) {
            // hack for foreign fields like of Contacts moduel for convert.lead view
            $field = $this->modulePrefix . $field;
        }

        $this->script = "<script type='text/javascript'>
			function setSequenceToHTML(){

				var loaded = false;
				
				var img = document.createElement('img');
				img.src = '" . SugarThemeRegistry::current()->getImageURL('helpInline.png') . "';
				img.onclick = function(){
					return SUGAR.util.showHelpTips(img, SUGAR.language.get('app_strings','LBL_SEQUENCE_HINT'), '', '');
				};
				img.setAttribute('class', 'inlineHelpTip');
				
				if(document.forms['form_SubpanelQuickCreate_'+'" . $this->bean->module_dir . "']){
					if(document.forms['form_SubpanelQuickCreate_'+'" . $this->bean->module_dir . "'].elements['$field']){
						var f = document.forms['form_SubpanelQuickCreate_'+'" . $this->bean->module_dir . "'].elements['$field'];
						f.value = '$value';
						f.readOnly = $readonly;
						f.parentNode.appendChild(img);
						loaded = true;
					}
				} else if(document.getElementById('$field')){
					var f = document.getElementById('$field');
					f.value = '$value';
					f.readOnly = $readonly;
					f.parentNode.appendChild(img);
					loaded = true;
				} else if(document.getElementsByName('$field')[0]){
					var f = document.getElementsByName('$field')[0];
					f.value = '$value';
					f.readOnly = $readonly;
					f.parentNode.appendChild(img);
					loaded = true;
				}

				if(!loaded){
					setTimeout('setSequenceToHTML()', 1000);
				}

				return;
			}

			setSequenceToHTML();
			</script>";
    }

    private function doDuplicateCheck($field) {

        $nill = true;

        if (!empty($this->bean->id)) {
            $sql = "SELECT $field FROM " . $this->bean->table_name . " ";
            if ($this->bean->db->tableExists($this->bean->get_custom_table_name())) {
                $sql .= "LEFT JOIN " . $this->bean->get_custom_table_name() . " ON " . $this->bean->get_custom_table_name() . ".id_c = " . $this->bean->table_name . ".id ";
            }
            $sql .= "WHERE id = '" . $this->bean->id . "'";
            $result = $this->bean->db->query($sql, true, " Error at current sequence value check for bean: " . $this->bean->id . " at table " . $this->bean->table_name);
            $row = $this->bean->db->fetchByAssoc($result);
            if (!empty($row)) {
                // we have already a valid value
                $nill = false;
            }
        }
        if ($nill) {
            $this->bean->{$field} = "";
        }
    }

    /**
     * this method finds out, which fields of the target module has special defined sequences
     * if there are no fields, the call of the custom_logic will be aborted without any further steps
     */
    private function setHookedFieldValues() {

        // select all the important fields for generating the sequence in the custom logic
        $sql = "SELECT id, code_field, sequence_readonly FROM " . $this->sequence->table_name . "
				WHERE parent_type = '" . $this->bean->module_dir . "'
				AND deleted = 0";
        $result = $this->bean->db->query($sql, false, "error with select of sequence fields");

        if (empty($result)) {
            return null;
        } else {

            $sequence = "";

            if (!isset($_REQUEST['isDuplicate'])) {
                $_REQUEST['isDuplicate'] = false;
            }

            while ($row = $this->bean->db->fetchByAssoc($result)) {
                $this->doDuplicateCheck($row['code_field']);
                // $_REQUEST['isDuplicate'] steht mit true als string, wenn ein Duplicate ansteht
                if ((empty($this->bean->$row['code_field']) && $this->bean->$row['code_field'] !== 0 && $this->bean->$row['code_field'] !== '0') || $_REQUEST['isDuplicate'] == "true" || $_REQUEST['isDuplicate'] === true) {
                    $maxValue = 0;
                    $sequence = $this->sequence->buildSequence($row['id'], $row['code_field'], $this->bean->table_name, $maxValue);
                    $this->bean->$row['code_field'] = $sequence;
                    if (in_array($_REQUEST['action'], self::$whiteActions)) {
                        $this->displayValueByJS($row['code_field'], $row['sequence_readonly'], $sequence);
                        if (self::$ajaxHelper == false) {
                            echo $this->script;
                        } else {
                            HooksForSequence::$beanScripts[$this->bean->id] = $this->script;
                        }
                    }
                } else if (!empty($row['sequence_readonly'])) {
                    if (in_array($_REQUEST['action'], self::$whiteActions)) {
                        $this->displayValueByJS($row['code_field'], $row['sequence_readonly'], $this->bean->$row['code_field']);
                        if (self::$ajaxHelper == false) {
                            echo $this->script;
                        } else {
                            HooksForSequence::$beanScripts[$this->bean->id] = $this->script;
                        }
                    }
                }
            }
        }

        return null;
    }

}
