<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');


/*********************************************************************************
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.

 * SuiteCRM is an extension to SugarCRM Community Edition developed by Salesagility Ltd.
 * Copyright (C) 2011 - 2014 Salesagility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo and "Supercharged by SuiteCRM" logo. If the display of the logos is not
 * reasonably feasible for  technical reasons, the Appropriate Legal Notices must
 * display the words  "Powered by SugarCRM" and "Supercharged by SuiteCRM".
 ********************************************************************************/

/*********************************************************************************

 * Description:  Defines the Spanish language pack for the base application.
 * Portions created by REDK Ingeniería del Software S.L..
 * All Rights Reserved.
 * Contributor(s): REDK Software Engineering (www.redk.net)
 ********************************************************************************/
 
$app_list_strings['moduleList'] = array (
  // 'Home' => 'Inicio', // DO NOT TRANSLATE!
  'Contacts' => 'Contactos',
  'Accounts' => 'Cuentas',
  'Opportunities' => 'Oportunidades',
  'Cases' => 'Casos',
  'Notes' => 'Notas',
  'Calls' => 'Llamadas',
  'Emails' => 'Emails',
  'Meetings' => 'Reuniones',
  'Tasks' => 'Tareas',
  'Calendar' => 'Calendario',
  'Leads' => 'Clientes Potenciales',
  'Currencies' => 'Monedas',
  'Activities' => 'Actividades',
  'Bugs' => 'Gestor de Incidencias',
  'Feeds' => 'RSS',
  'iFrames' => 'Mis Sitios',
  'TimePeriods' => 'Períodos de Tiempo',
  'TaxRates' => 'Tipos de Impuestos',
  'ContractTypes' => 'Tipos de Contrato',
  'Schedulers' => 'Planificadores',
  'Project' => 'Proyectos',
  'ProjectTask' => 'Tareas de Proyecto',
  'Campaigns' => 'Campañas',
  'CampaignLog' => 'Registro de Campañas',
  'Documents' => 'Documentos',
  'DocumentRevisions' => 'Versiones de documento',
  'Connectors' => 'Conectores',
  'Roles' => 'Roles',
  'Notifications' => 'Notificaciones',
  'Sync' => 'Sincronización',
  'Users' => 'Usuarios',
  'Employees' => 'Empleados',
  'Administration' => 'Administración',
  'ACLRoles' => 'Roles',
  'InboundEmail' => 'Correo Entrante',
  'Releases' => 'Lanzamientos',
  'Prospects' => 'Público Objetivo',
  'Queues' => 'Colas',
  'EmailMarketing' => 'Marketing por Email',
  'EmailTemplates' => 'Plantillas de Email',
  'SNIP' => 'Facilidad de Sugar',
  'ProspectLists' => 'Listas de Público Objetivo',
  'SavedSearch' => 'Búsquedas Guardadas',
  'UpgradeWizard' => 'Asistente de Actualizaciones',
  'Trackers' => 'Monitorización',
  'TrackerPerfs' => 'Monitorización de Rendimiento',
  'TrackerSessions' => 'Monitorización de Sesiones',
  'TrackerQueries' => 'Consultas de Monitorización',
  'FAQ' => 'FAQ',
  'Newsletters' => 'Boletines de Noticias',
  'SugarFeed' => 'Sugar Feed',
  'KBDocuments' => 'Base de Conocimiento',
  'SugarFavorites' => 'Favoritos',
  'OAuthKeys' => 'Claves del Consumidor OAuth',
  'OAuthTokens' => 'OAuth Tokens',
  'Library' => 'Biblioteca',
  'EmailAddresses' => 'Dirección de Email',
  'Sugar_Favorites' => 'Favoritos',
);
$app_list_strings['moduleListSingular'] = array (
  'Home' => 'Inicio',
  'Dashboard' => 'Cuadro de Mando',
  'Contacts' => 'Contacto',
  'Accounts' => 'Cuenta',
  'Opportunities' => 'Oportunidad',
  'Cases' => 'Caso',
  'Notes' => 'Nota',
  'Calls' => 'Llamada',
  'Emails' => 'Email',
  'Meetings' => 'Reunión',
  'Tasks' => 'Tarea',
  'Calendar' => 'Calendario',
  'Leads' => 'Cliente Potencial',
  'Activities' => 'Actividad',
  'Bugs' => 'Gestor de Incidencias',
  'KBDocuments' => 'Base de Conocimiento',
  'Feeds' => 'RSS',
  'iFrames' => 'Mis Sitios',
  'TimePeriods' => 'Período de Tiempo',
  'Project' => 'Proyecto',
  'ProjectTask' => 'Tarea de Proyecto',
  'Prospects' => 'Público Objetivo',
  'Campaigns' => 'Campaña',
  'Documents' => 'Documento',
  'SugarFollowing' => 'SugarFollowing',
  'Sync' => 'Sincronización',
  'Users' => 'Usuario',
  'SugarFavorites' => 'SugarFavorites',
);
$app_list_strings['checkbox_dom'] = array (
  '' => '',
  1 => 'Sí',
  2 => 'No',
);
$app_list_strings['account_type_dom'] = array (
  '' => '',
  'Analyst' => 'Analista',
  'Competitor' => 'Competidor',
  'Customer' => 'Cliente',
  'Integrator' => 'Integrador',
  'Investor' => 'Inversor',
  'Partner' => 'Partner',
  'Press' => 'Prensa',
  'Prospect' => 'Prospecto',
  'Reseller' => 'Revendedor',
  'Other' => 'Otro',
);
$app_list_strings['industry_dom'] = array (
  '' => '',
  'Apparel' => 'Textil',
  'Banking' => 'Banca',
  'Biotechnology' => 'Biotecnología',
  'Chemicals' => 'Química',
  'Communications' => 'Comunicaciones',
  'Construction' => 'Construcción',
  'Consulting' => 'Consultoría',
  'Education' => 'Educación',
  'Electronics' => 'Electronica',
  'Energy' => 'Energía',
  'Engineering' => 'Ingeniería',
  'Entertainment' => 'Entretenimiento',
  'Environmental' => 'Medio ambiente',
  'Finance' => 'Finanzas',
  'Government' => 'Gobierno',
  'Healthcare' => 'Sanidad',
  'Hospitality' => 'Caridad',
  'Insurance' => 'Seguros',
  'Machinery' => 'Maquinaria',
  'Manufacturing' => 'Fabricación',
  'Media' => 'Medios de comunicación',
  'Not For Profit' => 'Sin ánimo de lucro',
  'Recreation' => 'Ocio',
  'Retail' => 'Minoristas',
  'Shipping' => 'Envíos',
  'Technology' => 'Tecnología',
  'Telecommunications' => 'Telecomunicaciones',
  'Transportation' => 'Transporte',
  'Utilities' => 'Servicios públicos',
  'Other' => 'Otro',
);
$app_list_strings['lead_source_dom'] = array (
  '' => '',
  'Cold Call' => 'Llamada en Frío',
  'Existing Customer' => 'Cliente Existente',
  'Self Generated' => 'Auto Generado',
  'Employee' => 'Empleado',
  'Partner' => 'Partner',
  'Public Relations' => 'Relaciones Públicas',
  'Direct Mail' => 'Correo Directo',
  'Conference' => 'Conferencia',
  'Trade Show' => 'Exposición',
  'Web Site' => 'Sitio Web',
  'Word of mouth' => 'Recomendación',
  'Email' => 'Email',
  'Campaign' => 'Campaña',
  'Other' => 'Otro',
);
$app_list_strings['opportunity_type_dom'] = array (
  '' => '',
  'Existing Business' => 'Negocios Existentes',
  'New Business' => 'Nuevos Negocios',
);
$app_list_strings['roi_type_dom'] = array (
  'Revenue' => 'Ingresos',
  'Investment' => 'Inversión',
  'Expected_Revenue' => 'Ingresos Esperados',
  'Budget' => 'Presupuesto',
);
$app_list_strings['opportunity_relationship_type_dom'] = array (
  '' => '',
  'Primary Decision Maker' => 'Tomador de Decisión Principal',
  'Business Decision Maker' => 'Tomador de Decisión de Negocio',
  'Business Evaluator' => 'Evaluador de Negocio',
  'Technical Decision Maker' => 'Tomador de Decisión Técnica',
  'Technical Evaluator' => 'Evaluador Técnico',
  'Executive Sponsor' => 'Patrocinador Ejecutivo',
  'Influencer' => 'Influenciador',
  'Other' => 'Otro',
);
$app_list_strings['case_relationship_type_dom'] = array (
  '' => '',
  'Primary Contact' => 'Contacto Principal',
  'Alternate Contact' => 'Contacto Alternativo',
);
$app_list_strings['payment_terms'] = array (
  '' => '',
  'Net 15' => 'Neto 15',
  'Net 30' => 'Neto 30',
);
$app_list_strings['fts_type'] = array (
  '' => '',
  'Elastic' => 'Buscar elástica',
);
$app_list_strings['sales_stage_dom'] = array (
  'Prospecting' => 'Prospecto',
  'Qualification' => 'Calificación',
  'Needs Analysis' => 'Necesita Análisis',
  'Value Proposition' => 'Propuesta de Valor',
  'Id. Decision Makers' => 'Id. Tomadores de Decisiones',
  'Perception Analysis' => 'Análisis de Percepción',
  'Proposal/Price Quote' => 'Propuesta/Presupuesto',
  'Negotiation/Review' => 'Negociación/Revisión',
  'Closed Won' => 'Ganado',
  'Closed Lost' => 'Perdido',
);
$app_list_strings['in_total_group_stages'] = array (
  'Draft' => 'Borrador',
  'Negotiation' => 'Negociación',
  'Delivered' => 'Enviado',
  'On Hold' => 'En Espera',
  'Confirmed' => 'Confirmado',
  'Closed Accepted' => 'Cerrado Aceptado',
  'Closed Lost' => 'Cerrado Perdido',
  'Closed Dead' => 'Cerrado Muerto',
);
$app_list_strings['sales_probability_dom'] = array (
  'Prospecting' => '10',
  'Qualification' => '20',
  'Needs Analysis' => '25',
  'Value Proposition' => '30',
  'Id. Decision Makers' => '40',
  'Perception Analysis' => '50',
  'Proposal/Price Quote' => '65',
  'Negotiation/Review' => '80',
  'Closed Won' => '100',
  'Closed Lost' => '',
);
$app_list_strings['activity_dom'] = array (
  'Call' => 'Llamada',
  'Meeting' => 'Reunión',
  'Task' => 'Tarea',
  'Email' => 'Email',
  'Note' => 'Nota',
);
$app_list_strings['salutation_dom'] = array (
  '' => '',
  'Mr.' => 'Sr.',
  'Ms.' => 'Sra.',
  'Mrs.' => 'Sra.',
  'Dr.' => 'Dr.',
  'Prof.' => 'Prof.',
);
$app_list_strings['reminder_time_options'] = array (
  60 => '1 minuto antes',
  300 => '5 minutos antes',
  600 => '10 minutos antes',
  900 => '15 minutos antes',
  1800 => '30 minutos antes',
  3600 => '1 hora antes',
  7200 => '2 horas antes',
  10800 => '3 horas antes',
  18000 => '5 horas antes',
  86400 => '1 día antes',
);
$app_list_strings['task_priority_dom'] = array (
  'High' => 'Alta',
  'Medium' => 'Media',
  'Low' => 'Baja',
);
$app_list_strings['task_status_dom'] = array (
  'Not Started' => 'No Iniciada',
  'In Progress' => 'En Progreso',
  'Completed' => 'Completada',
  'Pending Input' => 'Pendiente de Información',
  'Deferred' => 'Aplazada',
);
$app_list_strings['meeting_status_dom'] = array (
  'Planned' => 'Planificada',
  'Held' => 'Realizada',
  'Not Held' => 'No Realizada',
);
$app_list_strings['extapi_meeting_password'] = array (
  'WebEx' => 'WebEx',
);
$app_list_strings['meeting_type_dom'] = array (
  'Other' => 'Otro',
  'Sugar' => 'SugarCRM',
);
$app_list_strings['call_status_dom'] = array (
  'Planned' => 'Planificada',
  'Held' => 'Realizada',
  'Not Held' => 'No Realizada',
);
$app_list_strings['call_direction_dom'] = array (
  'Inbound' => 'Entrante',
  'Outbound' => 'Saliente',
);
$app_list_strings['lead_status_dom'] = array (
  '' => '',
  'New' => 'Nuevo',
  'Assigned' => 'Asignado',
  'In Process' => 'En Proceso',
  'Converted' => 'Convertido',
  'Recycled' => 'Reciclado',
  'Dead' => 'Muerto',
);
$app_list_strings['gender_list'] = array (
  'male' => 'Masculino',
  'female' => 'Femenino',
);
$app_list_strings['case_status_dom'] = array (
  'New' => 'Nuevo',
  'Assigned' => 'Asignado',
  'Closed' => 'Cerrado',
  'Pending Input' => 'Pendiente de Información',
  'Rejected' => 'Rechazado',
  'Duplicate' => 'Duplicado',
);
$app_list_strings['case_priority_dom'] = array (
  'P1' => 'Alta',
  'P2' => 'Media',
  'P3' => 'Baja',
);
$app_list_strings['user_type_dom'] = array (
  'RegularUser' => 'Usuario Normal',
  'Administrator' => 'Administrador',
);
$app_list_strings['user_status_dom'] = array (
  'Active' => 'Activo',
  'Inactive' => 'Inactivo',
);
$app_list_strings['employee_status_dom'] = array (
  'Active' => 'Activo',
  'Terminated' => 'Despedido',
  'Leave of Absence' => 'Excedencia',
);
$app_list_strings['messenger_type_dom'] = array (
  '' => '',
  'MSN' => 'MSN',
  'Yahoo!' => 'Yahoo!',
  'AOL' => 'AOL',
);
$app_list_strings['project_task_priority_options'] = array (
  'High' => 'Alta',
  'Medium' => 'Media',
  'Low' => 'Baja',
);
$app_list_strings['project_task_status_options'] = array (
  'Not Started' => 'No Iniciada',
  'In Progress' => 'En Progreso',
  'Completed' => 'Completeda',
  'Pending Input' => 'Pendiente de Información',
  'Deferred' => 'Retrasada',
);
$app_list_strings['project_task_utilization_options'] = array (
  0 => 'ninguno',
  25 => '25',
  50 => '50',
  75 => '75',
  100 => '100',
);
$app_list_strings['project_status_dom'] = array (
  'Draft' => 'Borrador',
  'In Review' => 'En Revisión',
  'Published' => 'Publicado',
);
$app_list_strings['project_duration_units_dom'] = array (
  'Days' => 'Días',
  'Hours' => 'Horas',
);
$app_list_strings['project_priority_options'] = array (
  'High' => 'Alta',
  'Medium' => 'Media',
  'Low' => 'Baja',
);
$app_list_strings['record_type_display'] = array (
  '' => '',
  'Accounts' => 'Cuenta',
  'Opportunities' => 'Oportunidad',
  'Cases' => 'Caso',
  'Leads' => 'Cliente Potencial',
  'Contacts' => 'Contacto',
  'Bugs' => 'Incidencia',
  'Project' => 'Proyecto',
  'Prospects' => 'Público Objetivo',
  'ProjectTask' => 'Tarea de Proyecto',
  'Tasks' => 'Tarea',
);
$app_list_strings['record_type_display_notes'] = array (
  'Accounts' => 'Cuenta',
  'Contacts' => 'Contacto',
  'Opportunities' => 'Oportunidad',
  'Tasks' => 'Tarea',
  'Emails' => 'Email',
  'Bugs' => 'Incidencia',
  'Project' => 'Proyecto',
  'ProjectTask' => 'Tarea de Proyecto',
  'Prospects' => 'Público Objetivo',
  'Cases' => 'Caso',
  'Leads' => 'Cliente Potencial',
  'Meetings' => 'Reunión',
  'Calls' => 'Llamada',
);
$app_list_strings['parent_type_display'] = array (
  'Accounts' => 'Cuenta',
  'Contacts' => 'Contacto',
  'Tasks' => 'Tarea',
  'Opportunities' => 'Oportunidad',
  'Bugs' => 'Incidencia',
  'Cases' => 'Caso',
  'Leads' => 'Cliente Potencial',
  'Project' => 'Proyecto',
  'ProjectTask' => 'Tarea de Proyecto',
  'Prospects' => 'Público Objetivo',
);
$app_list_strings['issue_priority_dom'] = array (
  'Urgent' => 'Urgente',
  'High' => 'Alta',
  'Medium' => 'Media',
  'Low' => 'Baja',
);
$app_list_strings['issue_resolution_dom'] = array (
  '' => '',
  'Accepted' => 'Aceptado',
  'Duplicate' => 'Duplicado',
  'Closed' => 'Cerrado',
  'Out of Date' => 'Caducado',
  'Invalid' => 'No Válido',
);
$app_list_strings['issue_status_dom'] = array (
  'New' => 'Nuevo',
  'Assigned' => 'Asignado',
  'Closed' => 'Cerrado',
  'Pending' => 'Pendiente',
  'Rejected' => 'Rechazado',
);
$app_list_strings['bug_priority_dom'] = array (
  'Urgent' => 'Urgente',
  'High' => 'Alta',
  'Medium' => 'Media',
  'Low' => 'Baja',
);
$app_list_strings['bug_resolution_dom'] = array (
  '' => '',
  'Accepted' => 'Aceptado',
  'Duplicate' => 'Duplicado',
  'Fixed' => 'Corregido',
  'Out of Date' => 'Caducado',
  'Invalid' => 'No Válido',
  'Later' => 'Pospuesto',
);
$app_list_strings['bug_status_dom'] = array (
  'New' => 'Nuevo',
  'Assigned' => 'Asignado',
  'Closed' => 'Cerrado',
  'Pending' => 'Pendiente',
  'Rejected' => 'Rechazado',
);
$app_list_strings['bug_type_dom'] = array (
  'Defect' => 'Defecto',
  'Feature' => 'Característica',
);
$app_list_strings['case_type_dom'] = array (
  'Administration' => 'Administración',
  'Product' => 'Producto',
  'User' => 'Usuario',
);
$app_list_strings['source_dom'] = array (
  '' => '',
  'Internal' => 'Interno',
  'Forum' => 'Foro',
  'Web' => 'Web',
  'InboundEmail' => 'Email',
);
$app_list_strings['product_category_dom'] = array (
  '' => '',
  'Accounts' => 'Cuentas',
  'Activities' => 'Actividades',
  'Bug Tracker' => 'Seguimiento de Incidencias',
  'Calendar' => 'Calendario',
  'Calls' => 'Llamadas',
  'Campaigns' => 'Campañas',
  'Cases' => 'Casos',
  'Contacts' => 'Contactos',
  'Currencies' => 'Monedas',
  'Dashboard' => 'Cuadro de Mando',
  'Documents' => 'Documentos',
  'Emails' => 'Emails',
  'Feeds' => 'Fuentes RSS',
  'Forecasts' => 'Previsiones',
  'Help' => 'Ayuda',
  'Home' => 'Inicio',
  'Leads' => 'Clientes Potenciales',
  'Meetings' => 'Reuniones',
  'Notes' => 'Notas',
  'Opportunities' => 'Oportunidades',
  'Outlook Plugin' => 'Plugin de Outlook',
  'Projects' => 'Proyectos',
  'Quotes' => 'Presupuestos',
  'Releases' => 'Lanzamientos',
  'RSS' => 'Fuentes RSS',
  'Studio' => 'Estudio',
  'Upgrade' => 'Actualización',
  'Users' => 'Usuarios',
);
$app_list_strings['campaign_status_dom'] = array (
  '' => '',
  'Planning' => 'Planificación',
  'Active' => 'Activa',
  'Inactive' => 'Inactiva',
  'Complete' => 'Completa',
  'In Queue' => 'En cola',
  'Sending' => 'En envío',
);
$app_list_strings['campaign_type_dom'] = array (
  '' => '',
  'Telesales' => 'Televenta',
  'Mail' => 'Correo',
  'Email' => 'Email',
  'Print' => 'Imprenta',
  'Web' => 'Web',
  'Radio' => 'Radio',
  'Television' => 'Televisión',
  'NewsLetter' => 'Boletín de Noticias',
);
$app_list_strings['newsletter_frequency_dom'] = array (
  '' => '',
  'Weekly' => 'Semanal',
  'Monthly' => 'Mensual',
  'Quarterly' => 'Trimestral',
  'Annually' => 'Anual',
);
$app_list_strings['notifymail_sendtype'] = array (
  'SMTP' => 'SMTP',
);
$app_list_strings['dom_cal_month_long'] = array (
  0 => '',
  1 => 'Enero',
  2 => 'Febrero',
  3 => 'Marzo',
  4 => 'Abril',
  5 => 'Mayo',
  6 => 'Junio',
  7 => 'Julio',
  8 => 'Agosto',
  9 => 'Septiembre',
  10 => 'Octubre',
  11 => 'Noviembre',
  12 => 'Diciembre',
);
$app_list_strings['dom_cal_month_short'] = array (
  0 => '',
  1 => 'Ene',
  2 => 'Feb',
  3 => 'Mar',
  4 => 'Abr',
  5 => 'May',
  6 => 'Jun',
  7 => 'Jul',
  8 => 'Ago',
  9 => 'Sep',
  10 => 'Oct',
  11 => 'Nov',
  12 => 'Dic',
);
$app_list_strings['dom_cal_day_long'] = array (
  0 => '',
  1 => 'Domingo',
  2 => 'Lunes',
  3 => 'Martes',
  4 => 'Miércoles',
  5 => 'Jueves',
  6 => 'Viernes',
  7 => 'Sábado',
);
$app_list_strings['dom_cal_day_short'] = array (
  0 => '',
  1 => 'Dom',
  2 => 'Lun',
  3 => 'Mar',
  4 => 'Mié',
  5 => 'Jue',
  6 => 'Vie',
  7 => 'Sáb',
);
$app_list_strings['dom_meridiem_lowercase'] = array (
  'am' => 'am',
  'pm' => 'pm',
);
$app_list_strings['dom_meridiem_uppercase'] = array (
  'AM' => 'AM',
  'PM' => 'PM',
);
$app_list_strings['dom_report_types'] = array (
  'tabular' => 'Filas y Columnas',
  'summary' => 'Resumen',
  'detailed_summary' => 'Resumen con detalles',
  'Matrix' => 'Matriz',
);
$app_list_strings['dom_email_types'] = array (
  'out' => 'Enviado',
  'archived' => 'Archivado',
  'draft' => 'Borrador',
  'inbound' => 'Entrante',
  'campaign' => 'Campaña',
);
$app_list_strings['dom_email_status'] = array (
  'archived' => 'Archivado',
  'closed' => 'Cerrado',
  'draft' => 'Borrador',
  'read' => 'Leído',
  'replied' => 'Respondido',
  'sent' => 'Enviado',
  'send_error' => 'Error de Envío',
  'unread' => 'No leído',
);
$app_list_strings['dom_email_archived_status'] = array (
  'archived' => 'Archivado',
);
$app_list_strings['dom_email_server_type'] = array (
  '' => '--Ninguno--',
  'imap' => 'IMAP',
);
$app_list_strings['dom_mailbox_type'] = array (
  'pick' => '--Ninguno--',
  'createcase' => 'Nuevo Caso',
  'bounce' => 'Gestión de Rebotes',
);
$app_list_strings['dom_email_distribution'] = array (
  '' => '--Ninguno--',
  'direct' => 'Asignación Directa',
  'roundRobin' => 'Round-Robin',
  'leastBusy' => 'Menos-Ocupado',
);
$app_list_strings['dom_email_distribution_for_auto_create'] = array (
  'roundRobin' => 'Turno Rotatorio',
  'leastBusy' => 'Menos Ocupado',
);
$app_list_strings['dom_email_errors'] = array (
  1 => 'Seleccione sólo un usuario cuando realice una Asignación Directa de elementos.',
  2 => 'Debe asignar Sólo Elementos Marcados cuando realice una Asignación Directa de elementos.',
);
$app_list_strings['dom_email_bool'] = array (
  'bool_true' => 'Sí',
  'bool_false' => 'No',
);
$app_list_strings['dom_int_bool'] = array (
  1 => 'Sí',
  0 => 'No',
);
$app_list_strings['dom_switch_bool'] = array (
  'on' => 'Sí',
  'off' => 'No',
  '' => 'No',
);
$app_list_strings['dom_email_link_type'] = array (
  'sugar' => 'Cliente de correo de Sugar',
  'mailto' => 'Cliente de correo externo',
);
$app_list_strings['dom_email_editor_option'] = array (
  '' => 'Formato de correo por defecto',
  'html' => 'Correo HTML',
  'plain' => 'Correo con texto plano',
);
$app_list_strings['schedulers_times_dom'] = array (
  'not run' => 'Hora de Ejecución Pasada, No Ejecutado',
  'ready' => 'Listo',
  'in progress' => 'En Progreso',
  'failed' => 'Fallado',
  'completed' => 'Completado',
  'no curl' => 'No ejecutado: cURL no está disponible',
);
$app_list_strings['scheduler_status_dom'] = array (
  'Active' => 'Activo',
  'Inactive' => 'Inactivo',
);
$app_list_strings['scheduler_period_dom'] = array (
  'min' => 'Minutos',
  'hour' => 'Horas',
);
$app_list_strings['forecast_schedule_status_dom'] = array (
  'Active' => 'Activo',
  'Inactive' => 'Inactivo',
);
$app_list_strings['forecast_type_dom'] = array (
  'Direct' => 'Directo',
  'Rollup' => 'Rollup',
);
$app_list_strings['document_category_dom'] = array (
  '' => '',
  'Marketing' => 'Marketing',
  'Knowledege Base' => 'Base de Conocimiento',
  'Sales' => 'Ventas',
);
$app_list_strings['document_subcategory_dom'] = array (
  '' => '',
  'Marketing Collateral' => 'Impresos de Marketing',
  'Product Brochures' => 'Folletos de Producto',
  'FAQ' => 'FAQ',
);
$app_list_strings['document_status_dom'] = array (
  'Active' => 'Activo',
  'Draft' => 'Borrador',
  'FAQ' => 'FAQ',
  'Expired' => 'Caducado',
  'Under Review' => 'En Revisión',
  'Pending' => 'Pendiente',
);
$app_list_strings['document_template_type_dom'] = array (
  '' => '',
  'mailmerge' => 'Combinar correspondencia',
  'eula' => 'CLUF',
  'nda' => 'ANR',
  'license' => 'Contrato de Licencia',
);
$app_list_strings['dom_meeting_accept_options'] = array (
  'accept' => 'Aceptar',
  'decline' => 'Rechazar',
  'tentative' => 'Tentativa',
);
$app_list_strings['dom_meeting_accept_status'] = array (
  'accept' => 'Aceptado',
  'decline' => 'Rechazado',
  'tentative' => 'Tentativa',
  'none' => 'Ninguno',
);
$app_list_strings['duration_intervals'] = array (
  0 => '00',
  15 => '15',
  30 => '30',
  45 => '45',
);
$app_list_strings['repeat_type_dom'] = array (
  '' => 'Ninguno',
  'Daily' => 'Diario',
  'Weekly' => 'Semanal',
  'Monthly' => 'Mensual',
  'Yearly' => 'Anual',
);
$app_list_strings['repeat_intervals'] = array (
  '' => '',
  'Daily' => 'Diario',
  'Weekly' => 'Semanal',
  'Monthly' => 'Mensual',
  'Yearly' => 'Anual',
);
$app_list_strings['duration_dom'] = array (
  '' => 'Ninguna',
  900 => '15 minutos',
  1800 => '30 minutos',
  2700 => '45 minutos',
  3600 => '1 hora',
  5400 => '1.5 horas',
  7200 => '2 horas',
  10800 => '3 horas',
  21600 => '6 horas',
  86400 => '1 día',
  172800 => '2 días',
  259200 => '3 días',
  604800 => '1 semana',
);
$app_list_strings['prospect_list_type_dom'] = array (
  'default' => 'Por Defecto',
  'seed' => 'Cabeza de Serie',
  'exempt_domain' => 'Lista de Exclusión - Por Dominio',
  'exempt_address' => 'Lista de Exclusión - Por Dirección de Email',
  'exempt' => 'Lista de Exclusión - Por Id',
  'test' => 'Prueba',
);
$app_list_strings['email_settings_num_dom'] = array (
  10 => '10',
  20 => '20',
  50 => '50',
);
$app_list_strings['email_marketing_status_dom'] = array (
  '' => '',
  'active' => 'Activo',
  'inactive' => 'Inactivo',
);
$app_list_strings['campainglog_activity_type_dom'] = array (
  '' => '',
  'targeted' => 'Mensaje Enviado/Intentado',
  'send error' => 'Mensajes Rebotados,Otra causa',
  'invalid email' => 'Mensajes Rebotados,Email no válido',
  'link' => 'Enlace',
  'viewed' => 'Mensaje Visto',
  'removed' => 'Descartado',
  'lead' => 'Clientes Potenciales Creados',
  'contact' => 'Contactos Creados',
  'blocked' => 'Excluidos por dirección o dominio',
);
$app_list_strings['campainglog_target_type_dom'] = array (
  'Contacts' => 'Contactos',
  'Users' => 'Usuarios',
  'Prospects' => 'Público Objetivo',
  'Leads' => 'Clientes Potenciales',
  'Accounts' => 'Cuentas',
);
$app_list_strings['merge_operators_dom'] = array (
  'like' => 'Contiene',
  'exact' => 'Exactamente',
  'start' => 'Comienza con',
);
$app_list_strings['custom_fields_importable_dom'] = array (
  'true' => 'Sí',
  'false' => 'No',
  'required' => 'Requerido',
);
$app_list_strings['Elastic_boost_options'] = array (
  0 => 'Inhabilitado',
  1 => 'Bajo impulso',
  2 => 'Medio impulso',
  3 => 'Alto impulso',
);
$app_list_strings['custom_fields_merge_dup_dom'] = array (
  0 => 'Inhabilitado',
  1 => 'Habilitado',
);
$app_list_strings['navigation_paradigms'] = array (
  'm' => 'Módulos',
  'gm' => 'Módulos Agrupados',
);
$app_list_strings['projects_priority_options'] = array (
  'high' => 'Alta',
  'medium' => 'Media',
  'low' => 'Baja',
);
$app_list_strings['projects_status_options'] = array (
  'notstarted' => 'No Iniciado',
  'inprogress' => 'En Progreso',
  'completed' => 'Completado',
);
$app_list_strings['chart_strings'] = array (
  'expandlegend' => 'Expandir Leyenda',
  'collapselegend' => 'Contraer Leyenda',
  'clickfordrilldown' => 'Clic para Profundizar',
  'drilldownoptions' => 'Opciones de Profundización',
  'detailview' => 'Más Detalles...',
  'piechart' => 'Gráfico Circular',
  'groupchart' => 'Gráfico Agrupado',
  'stackedchart' => 'Gráfico Apilado',
  'barchart' => 'Gráfico de Barras',
  'horizontalbarchart' => 'Gráfico de Barras Horizontal',
  'linechart' => 'Gráfico de Líneas',
  'noData' => 'Datos no disponibles',
  'print' => 'Imprimir',
  'pieWedgeName' => 'secciones',
);
$app_list_strings['release_status_dom'] = array (
  'Active' => 'Activo',
  'Inactive' => 'Inactivo',
);
$app_list_strings['email_settings_for_ssl'] = array (
  0 => '',
  1 => 'SSL',
  2 => 'TLS',
);
$app_list_strings['import_enclosure_options'] = array (
  '\'' => 'Comillas Simples ($#39;)',
  '"' => 'Comillas Dobles (")',
  '' => 'Ninguno',
  'other' => 'Otro:',
);
$app_list_strings['import_delimeter_options'] = array (
  ',' => ',',
  ';' => ';',
  '\\t' => '\\t',
  '.' => '.',
  ':' => ':',
  '|' => '|',
  'other' => 'Otro:',
);
$app_list_strings['link_target_dom'] = array (
  '_blank' => 'Nueva Ventana',
  '_self' => 'Misma Ventana',
);
$app_list_strings['dashlet_auto_refresh_options'] = array (
  '-1' => 'No actualizar automáticamente',
  '30' => 'Cada 30 segundos',
  '60' => 'Cada minuto',
  '180' => 'Cada 3 minutos',
  '300' => 'Cada 5 minutos',
  '600' => 'Cada 10 minutos',
);
$app_list_strings['dashlet_auto_refresh_options_admin'] = array (
  '-1' => 'Nunca',
  '30' => 'Cada 30 segundos',
  '60' => 'Cada minuto',
  '180' => 'Cada 3 minutos',
  '300' => 'Cada 5 minutos',
  '600' => 'Cada 10 minutos',
);
$app_list_strings['date_range_search_dom'] = array (
  '=' => 'Igual a',
  'not_equal' => 'Distinto de',
  'greater_than' => 'Después de',
  'less_than' => 'Antes de',
  'last_7_days' => 'Últimos 7 días',
  'next_7_days' => 'Próximos 7 días',
  'last_30_days' => 'Últimos 30 días',
  'next_30_days' => 'Próximos 30 días',
  'last_month' => 'Último mes',
  'this_month' => 'Este mes',
  'next_month' => 'Próximo mes',
  'last_year' => 'Último año',
  'this_year' => 'Este año',
  'next_year' => 'Próximo año',
  'between' => 'Está entre',
);
$app_list_strings['numeric_range_search_dom'] = array (
  '=' => 'Igual a',
  'not_equal' => 'Distinto de',
  'greater_than' => 'Mayor que',
  'greater_than_equals' => 'Mayor o Igual que',
  'less_than' => 'Menor que',
  'less_than_equals' => 'Menor o Igual a',
  'between' => 'Está entre',
);
$app_list_strings['lead_conv_activity_opt'] = array (
  'copy' => 'Copiar',
  'move' => 'Mover',
  'donothing' => 'No hacer nada',
);
$app_list_strings['library_type'] = array (
  'Books' => 'Libro',
  'Music' => 'Música',
  'DVD' => 'DVD',
  'Magazines' => 'Revistas',
);
$app_list_strings['kbdocument_status_dom'] = array (
  'Draft' => 'Borrador',
  'Expired' => 'Caducado',
  'In Review' => 'En Revisión',
  'Published' => 'Publicado',
);
$app_list_strings['kbadmin_actions_dom'] = array (
  '' => '--Acciones de Admin.--',
  'Create New Tag' => 'Crear Nueva EtiquetaTag',
  'Delete Tag' => 'Eliminar Etiqueta',
  'Rename Tag' => 'Renombrar Etiqueta',
  'Move Selected Articles' => 'Mover Artículos Seleccionados',
  'Apply Tags On Articles' => 'Aplicar Etiquetas a Artículos',
  'Delete Selected Articles' => 'Eliminar Artículos Seleccionados',
);
$app_list_strings['kbdocument_attachment_option_dom'] = array (
  '' => '',
  'some' => 'Tiene Adjuntos',
  'none' => 'No Tiene',
  'mime' => 'Especificar Tipo MIME',
  'name' => 'Especificar Nombre',
);
$app_list_strings['kbdocument_viewing_frequency_dom'] = array (
  '' => '',
  'Top_5' => '5 Principales',
  'Top_10' => '10 Principales',
  'Top_20' => '20 Principales',
  'Bot_5' => '5 Últimos',
  'Bot_10' => '10 Últimos',
  'Bot_20' => '20 Últimos',
);
$app_list_strings['kbdocument_canned_search'] = array (
  'all' => 'Todos',
  'added' => 'Añadido en los Últimos 30 días',
  'pending' => 'Pendiente de mi Aprobación',
  'updated' => 'Actualizado en los Últimos 30 días',
  'faqs' => 'COMOs',
);
$app_list_strings['kbdocument_date_filter_options'] = array (
  '' => '',
  'on' => 'En',
  'before' => 'Antes de',
  'after' => 'Después de',
  'between_dates' => 'Está Entre',
  'last_7_days' => 'Últimos 7 Días',
  'next_7_days' => 'Próximos 7 Días',
  'last_month' => 'Último Mes',
  'this_month' => 'Este Mes',
  'next_month' => 'Próximo Mes',
  'last_30_days' => 'Últimos 30 Días',
  'next_30_days' => 'Próximos 30 Días',
  'last_year' => 'Último Año',
  'this_year' => 'Este Año',
  'next_year' => 'Próximo Año',
  'isnull' => 'Es Nulo',
);
$app_list_strings['countries_dom'] = array (
  '' => '',
  'ABU DHABI' => 'ABU DHABI',
  'ADEN' => 'ADEN',
  'AFGHANISTAN' => 'AFGHANISTAN',
  'ALBANIA' => 'ALBANIA',
  'ALGERIA' => 'ALGERIA',
  'AMERICAN SAMOA' => 'AMERICAN SAMOA',
  'ANDORRA' => 'ANDORRA',
  'ANGOLA' => 'ANGOLA',
  'ANTARCTICA' => 'ANTARCTICA',
  'ANTIGUA' => 'ANTIGUA',
  'ARGENTINA' => 'ARGENTINA',
  'ARMENIA' => 'ARMENIA',
  'ARUBA' => 'ARUBA',
  'AUSTRALIA' => 'AUSTRALIA',
  'AUSTRIA' => 'AUSTRIA',
  'AZERBAIJAN' => 'AZERBAIJAN',
  'BAHAMAS' => 'BAHAMAS',
  'BAHRAIN' => 'BAHRAIN',
  'BANGLADESH' => 'BANGLADESH',
  'BARBADOS' => 'BARBADOS',
  'BELARUS' => 'BELARUS',
  'BELGIUM' => 'BELGIUM',
  'BELIZE' => 'BELIZE',
  'BENIN' => 'BENIN',
  'BERMUDA' => 'BERMUDA',
  'BHUTAN' => 'BHUTAN',
  'BOLIVIA' => 'BOLIVIA',
  'BOSNIA' => 'BOSNIA',
  'BOTSWANA' => 'BOTSWANA',
  'BOUVET ISLAND' => 'BOUVET ISLAND',
  'BRAZIL' => 'BRAZIL',
  'BRITISH ANTARCTICA TERRITORY' => 'BRITISH ANTARCTICA TERRITORY',
  'BRITISH INDIAN OCEAN TERRITORY' => 'BRITISH INDIAN OCEAN TERRITORY',
  'BRITISH VIRGIN ISLANDS' => 'BRITISH VIRGIN ISLANDS',
  'BRITISH WEST INDIES' => 'BRITISH WEST INDIES',
  'BRUNEI' => 'BRUNEI',
  'BULGARIA' => 'BULGARIA',
  'BURKINA FASO' => 'BURKINA FASO',
  'BURUNDI' => 'BURUNDI',
  'CAMBODIA' => 'CAMBODIA',
  'CAMEROON' => 'CAMEROON',
  'CANADA' => 'CANADA',
  'CANAL ZONE' => 'CANAL ZONE',
  'CANARY ISLAND' => 'ISLAS CANARIAS',
  'CAPE VERDI ISLANDS' => 'CAPE VERDI ISLANDS',
  'CAYMAN ISLANDS' => 'ISLAS CAIMAN',
  'CEVLON' => 'CEVLON',
  'CHAD' => 'CHAD',
  'CHANNEL ISLAND UK' => 'CHANNEL ISLAND UK',
  'CHILE' => 'CHILE',
  'CHINA' => 'CHINA',
  'CHRISTMAS ISLAND' => 'CHRISTMAS ISLAND',
  'COCOS (KEELING) ISLAND' => 'COCOS (KEELING) ISLAND',
  'COLOMBIA' => 'COLOMBIA',
  'COMORO ISLANDS' => 'COMORO ISLANDS',
  'CONGO' => 'CONGO',
  'CONGO KINSHASA' => 'CONGO KINSHASA',
  'COOK ISLANDS' => 'COOK ISLANDS',
  'COSTA RICA' => 'COSTA RICA',
  'CROATIA' => 'CROACIA',
  'CUBA' => 'CUBA',
  'CURACAO' => 'CURACAO',
  'CYPRUS' => 'CHIPRE',
  'CZECH REPUBLIC' => 'REPÚBLICA CHECA',
  'DAHOMEY' => 'DAHOMEY',
  'DENMARK' => 'DINAMARCA',
  'DJIBOUTI' => 'YIBUTI',
  'DOMINICA' => 'DOMINICA',
  'DOMINICAN REPUBLIC' => 'REPÚBLICA DOMINICANA',
  'DUBAI' => 'DUBAI',
  'ECUADOR' => 'ECUADOR',
  'EGYPT' => 'EGIPTO',
  'EL SALVADOR' => 'EL SALVADOR',
  'EQUATORIAL GUINEA' => 'GUINEA ECUATORIAL',
  'ESTONIA' => 'ESTONIA',
  'ETHIOPIA' => 'ETHIOPIA',
  'FAEROE ISLANDS' => 'FAEROE ISLANDS',
  'FALKLAND ISLANDS' => 'FALKLAND ISLANDS',
  'FIJI' => 'FIJI',
  'FINLAND' => 'FINLANDIA',
  'FRANCE' => 'FRANCIA',
  'FRENCH GUIANA' => 'GUAYANA FRANCESA',
  'FRENCH POLYNESIA' => 'POLINESIA FRANCESA',
  'GABON' => 'GABON',
  'GAMBIA' => 'GAMBIA',
  'GEORGIA' => 'GEORGIA',
  'GERMANY' => 'ALEMANIA',
  'GHANA' => 'GHANA',
  'GIBRALTAR' => 'GIBRALTAR',
  'GREECE' => 'GRECIA',
  'GREENLAND' => 'GROENLANDIA',
  'GUADELOUPE' => 'GUADELOUPE',
  'GUAM' => 'GUAM',
  'GUATEMALA' => 'GUATEMALA',
  'GUINEA' => 'GUINEA',
  'GUYANA' => 'GUYANA',
  'HAITI' => 'HAITI',
  'HONDURAS' => 'HONDURAS',
  'HONG KONG' => 'HONG KONG',
  'HUNGARY' => 'HUNGRÍA',
  'ICELAND' => 'ISLANDIA',
  'IFNI' => 'IFNI',
  'INDIA' => 'INDIA',
  'INDONESIA' => 'INDONESIA',
  'IRAN' => 'IRAN',
  'IRAQ' => 'IRAQ',
  'IRELAND' => 'IRLANDA',
  'ISRAEL' => 'ISRAEL',
  'ITALY' => 'ITALIA',
  'IVORY COAST' => 'COSTA DE MARFIL',
  'JAMAICA' => 'JAMAICA',
  'JAPAN' => 'JAPON',
  'JORDAN' => 'JORDANIA',
  'KAZAKHSTAN' => 'KAZAJSTÁN',
  'KENYA' => 'KENIA',
  'KOREA' => 'KOREA',
  'KOREA, SOUTH' => 'COREA DEL SUR',
  'KUWAIT' => 'KUWAIT',
  'KYRGYZSTAN' => 'KIRGUISTÁN',
  'LAOS' => 'LAOS',
  'LATVIA' => 'LETONIA',
  'LEBANON' => 'LÍBANO',
  'LEEWARD ISLANDS' => 'ISLAS DE SOTAVENTO',
  'LESOTHO' => 'LESOTHO',
  'LIBYA' => 'LIBIA',
  'LIECHTENSTEIN' => 'LIECHTENSTEIN',
  'LITHUANIA' => 'LITUANIA',
  'LUXEMBOURG' => 'LUXEMBURGO',
  'MACAO' => 'MACAO',
  'MACEDONIA' => 'MACEDONIA',
  'MADAGASCAR' => 'MADAGASCAR',
  'MALAWI' => 'MALAWI',
  'MALAYSIA' => 'MALAYSIA',
  'MALDIVES' => 'MALDIVES',
  'MALI' => 'MALI',
  'MALTA' => 'MALTA',
  'MARTINIQUE' => 'MARTINIQUE',
  'MAURITANIA' => 'MAURITANIA',
  'MAURITIUS' => 'MAURITIUS',
  'MELANESIA' => 'MELANESIA',
  'MEXICO' => 'MÉXICO',
  'MOLDOVIA' => 'MOLDOVIA',
  'MONACO' => 'MONACO',
  'MONGOLIA' => 'MONGOLIA',
  'MOROCCO' => 'MARRUECOS',
  'MOZAMBIQUE' => 'MOZAMBIQUE',
  'MYANAMAR' => 'MYANAMAR',
  'NAMIBIA' => 'NAMIBIA',
  'NEPAL' => 'NEPAL',
  'NETHERLANDS' => 'PAÍSES BAJOS',
  'NETHERLANDS ANTILLES' => 'ANTILLAS HOLANDESAS',
  'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'ANTILLAS HOLANDESAS NEUTRAL ZONE',
  'NEW CALADONIA' => 'NUEVA CALADONIA',
  'NEW HEBRIDES' => 'NEW HEBRIDES',
  'NEW ZEALAND' => 'NUEVA ZELANDA',
  'NICARAGUA' => 'NICARAGUA',
  'NIGER' => 'NIGER',
  'NIGERIA' => 'NIGERIA',
  'NORFOLK ISLAND' => 'ISLA NORFOLK',
  'NORWAY' => 'NORWAY',
  'OMAN' => 'OMAN',
  'OTHER' => 'OTHER',
  'PACIFIC ISLAND' => 'ISLA DEL PACIFICO',
  'PAKISTAN' => 'PAKISTAN',
  'PANAMA' => 'PANAMA',
  'PAPUA NEW GUINEA' => 'PAPUA NUEVA GUINEA',
  'PARAGUAY' => 'PARAGUAY',
  'PERU' => 'PERU',
  'PHILIPPINES' => 'FILIPINAS',
  'POLAND' => 'POLONIA',
  'PORTUGAL' => 'PORTUGAL',
  'PORTUGUESE TIMOR' => 'PORTUGUESE TIMOR',
  'PUERTO RICO' => 'PUERTO RICO',
  'QATAR' => 'QATAR',
  'REPUBLIC OF BELARUS' => 'REPÚBLICA DE BIELORRUSIA',
  'REPUBLIC OF SOUTH AFRICA' => 'REPÚBLICA DE SUDÁFRICA',
  'REUNION' => 'REUNION',
  'ROMANIA' => 'RUMANIA',
  'RUSSIA' => 'RUSIA',
  'RWANDA' => 'RUANDA',
  'RYUKYU ISLANDS' => 'RYUKYU ISLANDS',
  'SABAH' => 'SABAH',
  'SAN MARINO' => 'SAN MARINO',
  'SAUDI ARABIA' => 'ARABIA SAUDITA',
  'SENEGAL' => 'SENEGAL',
  'SERBIA' => 'SERBIA',
  'SEYCHELLES' => 'SEYCHELLES',
  'SIERRA LEONE' => 'SIERRA LEONE',
  'SINGAPORE' => 'SINGAPORE',
  'SLOVAKIA' => 'SLOVAKIA',
  'SLOVENIA' => 'SLOVENIA',
  'SOMALILIAND' => 'SOMALILIAND',
  'SOUTH AFRICA' => 'SUDÁFRICA',
  'SOUTH YEMEN' => 'SOUTH YEMEN',
  'SPAIN' => 'ESPAÑA',
  'SPANISH SAHARA' => 'SAHARA ESPAÑOL',
  'SRI LANKA' => 'SRI LANKA',
  'ST. KITTS AND NEVIS' => 'ST. KITTS AND NEVIS',
  'ST. LUCIA' => 'ST. LUCIA',
  'SUDAN' => 'SUDAN',
  'SURINAM' => 'SURINAM',
  'SW AFRICA' => 'SW AFRICA',
  'SWAZILAND' => 'SWAZILAND',
  'SWEDEN' => 'SUECIA',
  'SWITZERLAND' => 'SUIZA',
  'SYRIA' => 'SIRIA',
  'TAIWAN' => 'TAIWAN',
  'TAJIKISTAN' => 'TAJIKISTAN',
  'TANZANIA' => 'TANZANIA',
  'THAILAND' => 'THAILAND',
  'TONGA' => 'TONGA',
  'TRINIDAD' => 'TRINIDAD',
  'TUNISIA' => 'TUNISIA',
  'TURKEY' => 'TURKEY',
  'UGANDA' => 'UGANDA',
  'UKRAINE' => 'UCRANIA',
  'UNITED ARAB EMIRATES' => 'EMIRATOS ÁRABES UNIDOS',
  'UNITED KINGDOM' => 'REINO UNIDO',
  'UPPER VOLTA' => 'ALTO VOLTA',
  'URUGUAY' => 'URUGUAY',
  'US PACIFIC ISLAND' => 'EE.UU. ISLA DEL PACIFICO',
  'US VIRGIN ISLANDS' => 'ISLAS VÍRGENES DE EE.UU.',
  'USA' => 'EE.UU.',
  'UZBEKISTAN' => 'UZBEKISTÁN',
  'VANUATU' => 'VANUATU',
  'VATICAN CITY' => 'CIUDAD DEL VATICANO',
  'VENEZUELA' => 'VENEZUELA',
  'VIETNAM' => 'VIETNAM',
  'WAKE ISLAND' => 'WAKE ISLAND',
  'WEST INDIES' => 'ANTILLAS',
  'WESTERN SAHARA' => 'SAHARA OCCIDENTAL',
  'YEMEN' => 'YEMEN',
  'ZAIRE' => 'ZAIRE',
  'ZAMBIA' => 'ZAMBIA',
  'ZIMBABWE' => 'ZIMBABWE',
);
$app_list_strings['charset_dom'] = array (
  'BIG-5' => 'BIG-5 (Taiwan y Hong Kong)',
  'CP1251' => 'CP1251 (Cirílico de MS)',
  'CP1252' => 'CP1252 (Europa Occidental y EEUU de Ms)',
  'EUC-CN' => 'EUC-CN (Chino Simplificado GB2312)',
  'EUC-JP' => 'EUC-JP (Japonés Unix)',
  'EUC-KR' => 'EUC-KR (Coreano)',
  'EUC-TW' => 'EUC-TW (Taiwanés)',
  'ISO-2022-JP' => 'ISO-2022-JP (Japonés)',
  'ISO-2022-KR' => 'ISO-2022-KR (Coreano)',
  'ISO-8859-1' => 'ISO-8859-1 (Europa Occidental y EEUU)',
  'ISO-8859-2' => 'ISO-8859-2 (Centroeuropa y Europa del Este)',
  'ISO-8859-3' => 'ISO-8859-3 (Latín 3)',
  'ISO-8859-4' => 'ISO-8859-4 (Latín 4)',
  'ISO-8859-5' => 'ISO-8859-5 (Cirílico)',
  'ISO-8859-6' => 'ISO-8859-6 (Árabe)',
  'ISO-8859-7' => 'ISO-8859-7 (Griego)',
  'ISO-8859-8' => 'ISO-8859-8 (Hebreo)',
  'ISO-8859-9' => 'ISO-8859-9 (Latín 5)',
  'ISO-8859-10' => 'ISO-8859-10 (Latín 6)',
  'ISO-8859-13' => 'ISO-8859-13 (Latín 7)',
  'ISO-8859-14' => 'ISO-8859-14 (Latín 8)',
  'ISO-8859-15' => 'ISO-8859-15 (Latín 9)',
  'KOI8-R' => 'KOI8-R (Cirílico Ruso)',
  'KOI8-U' => 'KOI8-U (Cirílico Ucraniano)',
  'SJIS' => 'SJIS (Japonés de MS)',
  'UTF-8' => 'UTF-8',
);
$app_list_strings['timezone_dom'] = array (
  'Africa/Algiers' => 'Africa/Algiers',
  'Africa/Luanda' => 'Africa/Luanda',
  'Africa/Porto-Novo' => 'Africa/Porto-Novo',
  'Africa/Gaborone' => 'Africa/Gaborone',
  'Africa/Ouagadougou' => 'Africa/Ouagadougou',
  'Africa/Bujumbura' => 'Africa/Bujumbura',
  'Africa/Douala' => 'Africa/Douala',
  'Atlantic/Cape_Verde' => 'Atlantic/Cape_Verde',
  'Africa/Bangui' => 'Africa/Bangui',
  'Africa/Ndjamena' => 'Africa/Ndjamena',
  'Indian/Comoro' => 'Indian/Comoro',
  'Africa/Kinshasa' => 'Africa/Kinshasa',
  'Africa/Lubumbashi' => 'Africa/Lubumbashi',
  'Africa/Brazzaville' => 'Africa/Brazzaville',
  'Africa/Abidjan' => 'Africa/Abidjan',
  'Africa/Djibouti' => 'Africa/Djibouti',
  'Africa/Cairo' => 'Africa/Cairo',
  'Africa/Malabo' => 'Africa/Malabo',
  'Africa/Asmera' => 'Africa/Asmera',
  'Africa/Addis_Ababa' => 'Africa/Addis_Ababa',
  'Africa/Libreville' => 'Africa/Libreville',
  'Africa/Banjul' => 'Africa/Banjul',
  'Africa/Accra' => 'Africa/Accra',
  'Africa/Conakry' => 'Africa/Conakry',
  'Africa/Bissau' => 'Africa/Bissau',
  'Africa/Nairobi' => 'Africa/Nairobi',
  'Africa/Maseru' => 'Africa/Maseru',
  'Africa/Monrovia' => 'Africa/Monrovia',
  'Africa/Tripoli' => 'Africa/Tripoli',
  'Indian/Antananarivo' => 'Indian/Antananarivo',
  'Africa/Blantyre' => 'Africa/Blantyre',
  'Africa/Bamako' => 'Africa/Bamako',
  'Africa/Nouakchott' => 'Africa/Nouakchott',
  'Indian/Mauritius' => 'Indian/Mauritius',
  'Indian/Mayotte' => 'Indian/Mayotte',
  'Africa/Casablanca' => 'Africa/Casablanca',
  'Africa/El_Aaiun' => 'Africa/El_Aaiun',
  'Africa/Maputo' => 'Africa/Maputo',
  'Africa/Windhoek' => 'Africa/Windhoek',
  'Africa/Niamey' => 'Africa/Niamey',
  'Africa/Lagos' => 'Africa/Lagos',
  'Indian/Reunion' => 'Indian/Reunion',
  'Africa/Kigali' => 'Africa/Kigali',
  'Atlantic/St_Helena' => 'Atlantic/St_Helena',
  'Africa/Sao_Tome' => 'Africa/Sao_Tome',
  'Africa/Dakar' => 'Africa/Dakar',
  'Indian/Mahe' => 'Indian/Mahe',
  'Africa/Freetown' => 'Africa/Freetown',
  'Africa/Mogadishu' => 'Africa/Mogadishu',
  'Africa/Johannesburg' => 'Africa/Johannesburg',
  'Africa/Khartoum' => 'Africa/Khartoum',
  'Africa/Mbabane' => 'Africa/Mbabane',
  'Africa/Dar_es_Salaam' => 'Africa/Dar_es_Salaam',
  'Africa/Lome' => 'Africa/Lome',
  'Africa/Tunis' => 'Africa/Tunis',
  'Africa/Kampala' => 'Africa/Kampala',
  'Africa/Lusaka' => 'Africa/Lusaka',
  'Africa/Harare' => 'Africa/Harare',
  'Antarctica/Casey' => 'Antarctica/Casey',
  'Antarctica/Davis' => 'Antarctica/Davis',
  'Antarctica/Mawson' => 'Antarctica/Mawson',
  'Indian/Kerguelen' => 'Indian/Kerguelen',
  'Antarctica/DumontDUrville' => 'Antarctica/DumontDUrville',
  'Antarctica/Syowa' => 'Antarctica/Syowa',
  'Antarctica/Vostok' => 'Antarctica/Vostok',
  'Antarctica/Rothera' => 'Antarctica/Rothera',
  'Antarctica/Palmer' => 'Antarctica/Palmer',
  'Antarctica/McMurdo' => 'Antarctica/McMurdo',
  'Asia/Kabul' => 'Asia/Kabul',
  'Asia/Yerevan' => 'Asia/Yerevan',
  'Asia/Baku' => 'Asia/Baku',
  'Asia/Bahrain' => 'Asia/Bahrain',
  'Asia/Dhaka' => 'Asia/Dhaka',
  'Asia/Thimphu' => 'Asia/Thimphu',
  'Indian/Chagos' => 'Indian/Chagos',
  'Asia/Brunei' => 'Asia/Brunei',
  'Asia/Rangoon' => 'Asia/Rangoon',
  'Asia/Phnom_Penh' => 'Asia/Phnom_Penh',
  'Asia/Beijing' => 'Asia/Beijing',
  'Asia/Harbin' => 'Asia/Harbin',
  'Asia/Shanghai' => 'Asia/Shanghai',
  'Asia/Chongqing' => 'Asia/Chongqing',
  'Asia/Urumqi' => 'Asia/Urumqi',
  'Asia/Kashgar' => 'Asia/Kashgar',
  'Asia/Hong_Kong' => 'Asia/Hong_Kong',
  'Asia/Taipei' => 'Asia/Taipei',
  'Asia/Macau' => 'Asia/Macau',
  'Asia/Nicosia' => 'Asia/Nicosia',
  'Asia/Tbilisi' => 'Asia/Tbilisi',
  'Asia/Dili' => 'Asia/Dili',
  'Asia/Calcutta' => 'Asia/Calcutta',
  'Asia/Jakarta' => 'Asia/Jakarta',
  'Asia/Pontianak' => 'Asia/Pontianak',
  'Asia/Makassar' => 'Asia/Makassar',
  'Asia/Jayapura' => 'Asia/Jayapura',
  'Asia/Tehran' => 'Asia/Tehran',
  'Asia/Baghdad' => 'Asia/Baghdad',
  'Asia/Jerusalem' => 'Asia/Jerusalem',
  'Asia/Tokyo' => 'Asia/Tokyo',
  'Asia/Amman' => 'Asia/Amman',
  'Asia/Almaty' => 'Asia/Almaty',
  'Asia/Qyzylorda' => 'Asia/Qyzylorda',
  'Asia/Aqtobe' => 'Asia/Aqtobe',
  'Asia/Aqtau' => 'Asia/Aqtau',
  'Asia/Oral' => 'Asia/Oral',
  'Asia/Bishkek' => 'Asia/Bishkek',
  'Asia/Seoul' => 'Asia/Seoul',
  'Asia/Pyongyang' => 'Asia/Pyongyang',
  'Asia/Kuwait' => 'Asia/Kuwait',
  'Asia/Vientiane' => 'Asia/Vientiane',
  'Asia/Beirut' => 'Asia/Beirut',
  'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
  'Asia/Kuching' => 'Asia/Kuching',
  'Indian/Maldives' => 'Indian/Maldives',
  'Asia/Hovd' => 'Asia/Hovd',
  'Asia/Ulaanbaatar' => 'Asia/Ulaanbaatar',
  'Asia/Choibalsan' => 'Asia/Choibalsan',
  'Asia/Katmandu' => 'Asia/Katmandu',
  'Asia/Muscat' => 'Asia/Muscat',
  'Asia/Karachi' => 'Asia/Karachi',
  'Asia/Gaza' => 'Asia/Gaza',
  'Asia/Manila' => 'Asia/Manila',
  'Asia/Qatar' => 'Asia/Qatar',
  'Asia/Riyadh' => 'Asia/Riyadh',
  'Asia/Singapore' => 'Asia/Singapore',
  'Asia/Colombo' => 'Asia/Colombo',
  'Asia/Damascus' => 'Asia/Damascus',
  'Asia/Dushanbe' => 'Asia/Dushanbe',
  'Asia/Bangkok' => 'Asia/Bangkok',
  'Asia/Ashgabat' => 'Asia/Ashgabat',
  'Asia/Dubai' => 'Asia/Dubai',
  'Asia/Samarkand' => 'Asia/Samarkand',
  'Asia/Tashkent' => 'Asia/Tashkent',
  'Asia/Saigon' => 'Asia/Saigon',
  'Asia/Aden' => 'Asia/Aden',
  'Australia/Darwin' => 'Australia/Darwin',
  'Australia/Perth' => 'Australia/Perth',
  'Australia/Brisbane' => 'Australia/Brisbane',
  'Australia/Lindeman' => 'Australia/Lindeman',
  'Australia/Adelaide' => 'Australia/Adelaide',
  'Australia/Hobart' => 'Australia/Hobart',
  'Australia/Currie' => 'Australia/Currie',
  'Australia/Melbourne' => 'Australia/Melbourne',
  'Australia/Sydney' => 'Australia/Sydney',
  'Australia/Broken_Hill' => 'Australia/Broken_Hill',
  'Indian/Christmas' => 'Indian/Christmas',
  'Pacific/Rarotonga' => 'Pacific/Rarotonga',
  'Indian/Cocos' => 'Indian/Cocos',
  'Pacific/Fiji' => 'Pacific/Fiji',
  'Pacific/Gambier' => 'Pacific/Gambier',
  'Pacific/Marquesas' => 'Pacific/Marquesas',
  'Pacific/Tahiti' => 'Pacific/Tahiti',
  'Pacific/Guam' => 'Pacific/Guam',
  'Pacific/Tarawa' => 'Pacific/Tarawa',
  'Pacific/Enderbury' => 'Pacific/Enderbury',
  'Pacific/Kiritimati' => 'Pacific/Kiritimati',
  'Pacific/Saipan' => 'Pacific/Saipan',
  'Pacific/Majuro' => 'Pacific/Majuro',
  'Pacific/Kwajalein' => 'Pacific/Kwajalein',
  'Pacific/Truk' => 'Pacific/Truk',
  'Pacific/Ponape' => 'Pacific/Ponape',
  'Pacific/Kosrae' => 'Pacific/Kosrae',
  'Pacific/Nauru' => 'Pacific/Nauru',
  'Pacific/Noumea' => 'Pacific/Noumea',
  'Pacific/Auckland' => 'Pacific/Auckland',
  'Pacific/Chatham' => 'Pacific/Chatham',
  'Pacific/Niue' => 'Pacific/Niue',
  'Pacific/Norfolk' => 'Pacific/Norfolk',
  'Pacific/Palau' => 'Pacific/Palau',
  'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
  'Pacific/Pitcairn' => 'Pacific/Pitcairn',
  'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
  'Pacific/Apia' => 'Pacific/Apia',
  'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
  'Pacific/Fakaofo' => 'Pacific/Fakaofo',
  'Pacific/Tongatapu' => 'Pacific/Tongatapu',
  'Pacific/Funafuti' => 'Pacific/Funafuti',
  'Pacific/Johnston' => 'Pacific/Johnston',
  'Pacific/Midway' => 'Pacific/Midway',
  'Pacific/Wake' => 'Pacific/Wake',
  'Pacific/Efate' => 'Pacific/Efate',
  'Pacific/Wallis' => 'Pacific/Wallis',
  'Europe/London' => 'Europe/London',
  'Europe/Dublin' => 'Europe/Dublin',
  'WET' => 'WET',
  'CET' => 'CET',
  'MET' => 'MET',
  'EET' => 'EET',
  'Europe/Tirane' => 'Europe/Tirane',
  'Europe/Andorra' => 'Europe/Andorra',
  'Europe/Vienna' => 'Europe/Vienna',
  'Europe/Minsk' => 'Europe/Minsk',
  'Europe/Brussels' => 'Europe/Brussels',
  'Europe/Sofia' => 'Europe/Sofia',
  'Europe/Prague' => 'Europe/Prague',
  'Europe/Copenhagen' => 'Europe/Copenhagen',
  'Atlantic/Faeroe' => 'Atlantic/Faeroe',
  'America/Danmarkshavn' => 'America/Danmarkshavn',
  'America/Scoresbysund' => 'America/Scoresbysund',
  'America/Godthab' => 'America/Godthab',
  'America/Thule' => 'America/Thule',
  'Europe/Tallinn' => 'Europe/Tallinn',
  'Europe/Helsinki' => 'Europe/Helsinki',
  'Europe/Paris' => 'Europe/Paris',
  'Europe/Berlin' => 'Europe/Berlin',
  'Europe/Gibraltar' => 'Europe/Gibraltar',
  'Europe/Athens' => 'Europe/Athens',
  'Europe/Budapest' => 'Europe/Budapest',
  'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
  'Europe/Rome' => 'Europe/Rome',
  'Europe/Riga' => 'Europe/Riga',
  'Europe/Vaduz' => 'Europe/Vaduz',
  'Europe/Vilnius' => 'Europe/Vilnius',
  'Europe/Luxembourg' => 'Europe/Luxembourg',
  'Europe/Malta' => 'Europe/Malta',
  'Europe/Chisinau' => 'Europe/Chisinau',
  'Europe/Monaco' => 'Europe/Monaco',
  'Europe/Amsterdam' => 'Europe/Amsterdam',
  'Europe/Oslo' => 'Europe/Oslo',
  'Europe/Warsaw' => 'Europe/Warsaw',
  'Europe/Lisbon' => 'Europe/Lisbon',
  'Atlantic/Azores' => 'Atlantic/Azores',
  'Atlantic/Madeira' => 'Atlantic/Madeira',
  'Europe/Bucharest' => 'Europe/Bucharest',
  'Europe/Kaliningrad' => 'Europe/Kaliningrad',
  'Europe/Moscow' => 'Europe/Moscow',
  'Europe/Samara' => 'Europe/Samara',
  'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
  'Asia/Omsk' => 'Asia/Omsk',
  'Asia/Novosibirsk' => 'Asia/Novosibirsk',
  'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
  'Asia/Irkutsk' => 'Asia/Irkutsk',
  'Asia/Yakutsk' => 'Asia/Yakutsk',
  'Asia/Vladivostok' => 'Asia/Vladivostok',
  'Asia/Sakhalin' => 'Asia/Sakhalin',
  'Asia/Magadan' => 'Asia/Magadan',
  'Asia/Kamchatka' => 'Asia/Kamchatka',
  'Asia/Anadyr' => 'Asia/Anadyr',
  'Europe/Belgrade' => 'Europe/Belgrade',
  'Europe/Madrid' => 'Europe/Madrid',
  'Africa/Ceuta' => 'Africa/Ceuta',
  'Atlantic/Canary' => 'Atlantic/Canary',
  'Europe/Stockholm' => 'Europe/Stockholm',
  'Europe/Zurich' => 'Europe/Zurich',
  'Europe/Istanbul' => 'Europe/Istanbul',
  'Europe/Kiev' => 'Europe/Kiev',
  'Europe/Uzhgorod' => 'Europe/Uzhgorod',
  'Europe/Zaporozhye' => 'Europe/Zaporozhye',
  'Europe/Simferopol' => 'Europe/Simferopol',
  'America/New_York' => 'America/New_York',
  'America/Chicago' => 'America/Chicago',
  'America/North_Dakota/Center' => 'America/North_Dakota/Center',
  'America/Denver' => 'America/Denver',
  'America/Los_Angeles' => 'America/Los_Angeles',
  'America/Juneau' => 'America/Juneau',
  'America/Yakutat' => 'America/Yakutat',
  'America/Anchorage' => 'America/Anchorage',
  'America/Nome' => 'America/Nome',
  'America/Adak' => 'America/Adak',
  'Pacific/Honolulu' => 'Pacific/Honolulu',
  'America/Phoenix' => 'America/Phoenix',
  'America/Boise' => 'America/Boise',
  'America/Indiana/Indianapolis' => 'America/Indiana/Indianapolis',
  'America/Indiana/Marengo' => 'America/Indiana/Marengo',
  'America/Indiana/Knox' => 'America/Indiana/Knox',
  'America/Indiana/Vevay' => 'America/Indiana/Vevay',
  'America/Kentucky/Louisville' => 'America/Kentucky/Louisville',
  'America/Kentucky/Monticello' => 'America/Kentucky/Monticello',
  'America/Detroit' => 'America/Detroit',
  'America/Menominee' => 'America/Menominee',
  'America/St_Johns' => 'America/St_Johns',
  'America/Goose_Bay' => 'America/Goose_Bay',
  'America/Halifax' => 'America/Halifax',
  'America/Glace_Bay' => 'America/Glace_Bay',
  'America/Montreal' => 'America/Montreal',
  'America/Toronto' => 'America/Toronto',
  'America/Thunder_Bay' => 'America/Thunder_Bay',
  'America/Nipigon' => 'America/Nipigon',
  'America/Rainy_River' => 'America/Rainy_River',
  'America/Winnipeg' => 'America/Winnipeg',
  'America/Regina' => 'America/Regina',
  'America/Swift_Current' => 'America/Swift_Current',
  'America/Edmonton' => 'America/Edmonton',
  'America/Vancouver' => 'America/Vancouver',
  'America/Dawson_Creek' => 'America/Dawson_Creek',
  'America/Pangnirtung' => 'America/Pangnirtung',
  'America/Iqaluit' => 'America/Iqaluit',
  'America/Coral_Harbour' => 'America/Coral_Harbour',
  'America/Rankin_Inlet' => 'America/Rankin_Inlet',
  'America/Cambridge_Bay' => 'America/Cambridge_Bay',
  'America/Yellowknife' => 'America/Yellowknife',
  'America/Inuvik' => 'America/Inuvik',
  'America/Whitehorse' => 'America/Whitehorse',
  'America/Dawson' => 'America/Dawson',
  'America/Cancun' => 'America/Cancun',
  'America/Merida' => 'America/Merida',
  'America/Monterrey' => 'America/Monterrey',
  'America/Mexico_City' => 'America/Mexico_City',
  'America/Chihuahua' => 'America/Chihuahua',
  'America/Hermosillo' => 'America/Hermosillo',
  'America/Mazatlan' => 'America/Mazatlan',
  'America/Tijuana' => 'America/Tijuana',
  'America/Anguilla' => 'America/Anguilla',
  'America/Antigua' => 'America/Antigua',
  'America/Nassau' => 'America/Nassau',
  'America/Barbados' => 'America/Barbados',
  'America/Belize' => 'America/Belize',
  'Atlantic/Bermuda' => 'Atlantic/Bermuda',
  'America/Cayman' => 'America/Cayman',
  'America/Costa_Rica' => 'America/Costa_Rica',
  'America/Havana' => 'America/Havana',
  'America/Dominica' => 'America/Dominica',
  'America/Santo_Domingo' => 'America/Santo_Domingo',
  'America/El_Salvador' => 'America/El_Salvador',
  'America/Grenada' => 'America/Grenada',
  'America/Guadeloupe' => 'America/Guadeloupe',
  'America/Guatemala' => 'America/Guatemala',
  'America/Port-au-Prince' => 'America/Port-au-Prince',
  'America/Tegucigalpa' => 'America/Tegucigalpa',
  'America/Jamaica' => 'America/Jamaica',
  'America/Martinique' => 'America/Martinique',
  'America/Montserrat' => 'America/Montserrat',
  'America/Managua' => 'America/Managua',
  'America/Panama' => 'America/Panama',
  'America/Puerto_Rico' => 'America/Puerto_Rico',
  'America/St_Kitts' => 'America/St_Kitts',
  'America/St_Lucia' => 'America/St_Lucia',
  'America/Miquelon' => 'America/Miquelon',
  'America/St_Vincent' => 'America/St_Vincent',
  'America/Grand_Turk' => 'America/Grand_Turk',
  'America/Tortola' => 'America/Tortola',
  'America/St_Thomas' => 'America/St_Thomas',
  'America/Argentina/Buenos_Aires' => 'America/Argentina/Buenos_Aires',
  'America/Argentina/Cordoba' => 'America/Argentina/Cordoba',
  'America/Argentina/Tucuman' => 'America/Argentina/Tucuman',
  'America/Argentina/La_Rioja' => 'America/Argentina/La_Rioja',
  'America/Argentina/San_Juan' => 'America/Argentina/San_Juan',
  'America/Argentina/Jujuy' => 'America/Argentina/Jujuy',
  'America/Argentina/Catamarca' => 'America/Argentina/Catamarca',
  'America/Argentina/Mendoza' => 'America/Argentina/Mendoza',
  'America/Argentina/Rio_Gallegos' => 'America/Argentina/Rio_Gallegos',
  'America/Argentina/Ushuaia' => 'America/Argentina/Ushuaia',
  'America/Aruba' => 'America/Aruba',
  'America/La_Paz' => 'America/La_Paz',
  'America/Noronha' => 'America/Noronha',
  'America/Belem' => 'America/Belem',
  'America/Fortaleza' => 'America/Fortaleza',
  'America/Recife' => 'America/Recife',
  'America/Araguaina' => 'America/Araguaina',
  'America/Maceio' => 'America/Maceio',
  'America/Bahia' => 'America/Bahia',
  'America/Sao_Paulo' => 'America/Sao_Paulo',
  'America/Campo_Grande' => 'America/Campo_Grande',
  'America/Cuiaba' => 'America/Cuiaba',
  'America/Porto_Velho' => 'America/Porto_Velho',
  'America/Boa_Vista' => 'America/Boa_Vista',
  'America/Manaus' => 'America/Manaus',
  'America/Eirunepe' => 'America/Eirunepe',
  'America/Rio_Branco' => 'America/Rio_Branco',
  'America/Santiago' => 'America/Santiago',
  'Pacific/Easter' => 'Pacific/Easter',
  'America/Bogota' => 'America/Bogota',
  'America/Curacao' => 'America/Curacao',
  'America/Guayaquil' => 'America/Guayaquil',
  'Pacific/Galapagos' => 'Pacific/Galapagos',
  'Atlantic/Stanley' => 'Atlantic/Stanley',
  'America/Cayenne' => 'America/Cayenne',
  'America/Guyana' => 'America/Guyana',
  'America/Asuncion' => 'America/Asuncion',
  'America/Lima' => 'America/Lima',
  'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
  'America/Paramaribo' => 'America/Paramaribo',
  'America/Port_of_Spain' => 'America/Port_of_Spain',
  'America/Montevideo' => 'America/Montevideo',
  'America/Caracas' => 'America/Caracas',
);
$app_list_strings['eapm_list'] = array (
  'Sugar' => 'Sugar',
  'WebEx' => 'WebEx',
  'GoToMeeting' => 'GoToMeeting',
  'IBMSmartCloud' => 'IBM SmartCloud',
  'Google' => 'Google',
  'Box' => 'Box.net',
  'Facebook' => 'Facebook',
  'Twitter' => 'Twitter',
);
$app_list_strings['eapm_list_import'] = array (
  'Google' => 'Contactos de Google',
);
$app_list_strings['eapm_list_documents'] = array (
  'Google' => 'Documentos de Google',
);
$app_list_strings['token_status'] = array (
  1 => 'Solicitud',
  2 => 'Acceso',
  3 => 'Invalido',
);
$app_list_strings['emailTemplates_type_list'] = array (
  '' => '',
  'campaign' => 'Campaña',
  'email' => 'Email',
);
$app_list_strings['emailTemplates_type_list_campaigns'] = array (
  '' => '',
  'campaign' => 'Campaña',
);
$app_list_strings['emailTemplates_type_list_no_workflow'] = array (
  '' => '',
  'campaign' => 'Campaña',
  'email' => 'Email',
);
$app_list_strings['language_pack_name'] = 'Español';

$app_strings = array (
  'LBL_TOUR_NEXT' => 'Siguiente',
  'LBL_TOUR_SKIP' => 'Saltar',
  'LBL_TOUR_BACK' => 'Atrás',
  'LBL_TOUR_CLOSE' => 'Cerrar:',
  'LBL_TOUR_TAKE_TOUR' => 'Visita guiada',
  'LBL_MY_AREA_LINKS' => 'Mi área de enlaces:',
  'LBL_GETTINGAIR' => 'Cogiendo Aire',
  'LBL_WELCOMEBAR' => 'Bienvenido',
  'LBL_ADVANCEDSEARCH' => 'Búsqueda avanzada',
  'LBL_MOREDETAIL' => 'Más detalles',
  'LBL_EDIT_INLINE' => 'Editar en línea',
  'LBL_VIEW_INLINE' => 'Ver',
  'LBL_BASIC_SEARCH' => 'Buscar',
  'LBL_PROJECT_MINUS' => 'Quitar',
  'LBL_PROJECT_PLUS' => 'Añadir',
  'LBL_Blank' => ' ',
  'LBL_ICON_COLUMN_1' => 'Columna',
  'LBL_ICON_COLUMN_2' => '2 columnas',
  'LBL_ICON_COLUMN_3' => '3 Columnas',
  'LBL_ADVANCED_SEARCH' => 'Búsqueda avanzada',
  'LBL_ID_FF_ADD' => 'Añadir',
  'LBL_HIDE_SHOW' => 'Ocultar/Mostrar',
  'LBL_DELETE_INLINE' => 'Eliminar',
  'LBL_PLUS_INLINE' => 'Añadir',
  'LBL_ID_FF_CLEAR' => 'Limpiar',
  'LBL_ID_FF_VCARD' => 'vCard',
  'LBL_ID_FF_REMOVE' => 'Quitar',
  'LBL_ADD' => 'Añadir',
  'LBL_COMPANY_LOGO' => 'Logo compañia',
  'LBL_JS_CALENDAR' => 'Calendario',
  'LBL_ADVANCED' => 'Avanzado',
  'LBL_BASIC' => 'Básico',
  'LBL_MODULE_FILTER' => 'Filtrar por',
  'LBL_CONNECTORS_POPUPS' => 'Conectores Popups',
  'LBL_CLOSEINLINE' => 'Cerrado',
  'LBL_EDITINLINE' => 'Editar',
  'LBL_VIEWINLINE' => 'Ver',
  'LBL_INFOINLINE' => 'Información',
  'LBL_POWERED_BY_SUGARCRM' => 'Desarrollado por SugarCRM',
  'LBL_PRINT' => 'Imprimir',
  'LBL_HELP' => 'Ayuda',
  'LBL_ID_FF_SELECT' => 'Seleccionar',
  'DEFAULT' => 'Básico',
  'LBL_SORT' => 'Ordenar',
  'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'Agregar Servidor...',
  'LBL_EMAIL_SMTP_SSL_OR_TLS' => '¿Habilitar SMTP sobre SSL o TLS?',
  'LBL_NO_ACTION' => 'No hay ninguna acción con ese nombre.',
  'LBL_NO_DATA' => 'Sin Datos',
  'LBL_ROUTING_ADD_RULE' => 'Agregar Regla',
  'LBL_ROUTING_ALL' => 'Al menos',
  'LBL_ROUTING_ANY' => 'Cualquiera',
  'LBL_ROUTING_BREAK' => '-',
  'LBL_ROUTING_BUTTON_CANCEL' => 'Cancelar',
  'LBL_ROUTING_BUTTON_SAVE' => 'Guardar Regla',
  'LBL_ROUTING_ACTIONS_COPY_MAIL' => 'Copiar Mail',
  'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'Eliminar Objeto Sugar',
  'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'Eliminar Archivo',
  'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'Eliminar Email',
  'LBL_ROUTING_ACTIONS_FORWARD' => 'Reenviar Email',
  'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'Marcar Email para Seguimiento',
  'LBL_ROUTING_ACTIONS_MARK_READ' => 'Marcar como Leído',
  'LBL_ROUTING_ACTIONS_MARK_UNREAD' => 'Marcar como No leído',
  'LBL_ROUTING_ACTIONS_MOVE_MAIL' => 'Mover Email',
  'LBL_ROUTING_ACTIONS_PEFORM' => 'Realizar las siguientes acciones',
  'LBL_ROUTING_ACTIONS_REPLY' => 'Responder al Email',
  'LBL_ROUTING_CHECK_RULE' => 'Se ha detectado un error:',
  'LBL_ROUTING_CHECK_RULE_DESC' => 'Por favor, verifique todos los campos que han sido marcados.',
  'LBL_ROUTING_CONFIRM_DELETE' => '¿Está seguro de que desea eliminar esta regla?<br />Esta operación no puede hacerse atrás.',
  'LBL_ROUTING_FLAGGED' => 'conjunto de marcas de seguimiento',
  'LBL_ROUTING_FORM_DESC' => 'Las reglas se activan inmediatamente tras ser guardadas.',
  'LBL_ROUTING_FW' => 'RV:',
  'LBL_ROUTING_LIST_TITLE' => 'Reglas',
  'LBL_ROUTING_MATCH' => 'Si',
  'LBL_ROUTING_MATCH_2' => 'de las siguientes condiciones se cumple:',
  'LBL_NOTIFICATIONS' => 'Notificaciones',
  'LBL_ROUTING_MATCH_CC_ADDR' => 'CC',
  'LBL_ROUTING_MATCH_DESCRIPTION' => 'Contenido del Cuerpo',
  'LBL_ROUTING_MATCH_FROM_ADDR' => 'De',
  'LBL_ROUTING_MATCH_NAME' => 'Asunto',
  'LBL_ROUTING_MATCH_PRIORITY_HIGH' => 'Alta Prioridad',
  'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => 'Prioridad Normal',
  'LBL_ROUTING_MATCH_PRIORITY_LOW' => 'Baja Prioridad',
  'LBL_ROUTING_MATCH_TO_ADDR' => 'A',
  'LBL_ROUTING_MATCH_TYPE_MATCH' => 'Contiene',
  'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'No contiene',
  'LBL_ROUTING_NAME' => 'Nombre de Regla',
  'LBL_ROUTING_NEW_NAME' => 'Nueva Regla',
  'LBL_ROUTING_ONE_MOMENT' => 'Un momento, por favor...',
  'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => 'Mensaje original a continuación.',
  'LBL_ROUTING_RE' => 'RE:',
  'LBL_ROUTING_SAVING_RULE' => 'Guardando Regla',
  'LBL_ROUTING_SUB_DESC' => 'Las reglas marcadas están activas. Haga clic en un nombre para editarlas.',
  'LBL_ROUTING_TO' => 'a',
  'LBL_ROUTING_TO_ADDRESS' => 'a la dirección',
  'LBL_ROUTING_WITH_TEMPLATE' => 'con la plantilla',
  'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => 'Los campos Teléfono y Dirección de su formulario ya tienen valor asignado. Para sobrescribir dichos valores con el teléfono/dirección de la Cuenta que ha seleccionado, haga clic en "Aceptar". Para mantener los valores actuales, haga clic en "Cancelar".',
  'LBL_DROP_HERE' => '[Soltar Aquí]',
  'LBL_EMAIL_ACCOUNTS_EDIT' => 'Editar',
  'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'Establecer configuración para Gmail&amp;#153;',
  'LBL_EMAIL_ACCOUNTS_NAME' => 'Nombre',
  'LBL_EMAIL_ACCOUNTS_OUTBOUND' => 'Propiedades del Servidor de Correo Saliente',
  'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'Agente de transferencia de correo (MTA)',
  'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => '¿Usar Autenticación SMTP?',
  'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'Contraseña SMTP',
  'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'Puerto SMTP',
  'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'Servidor SMTP',
  'LBL_EMAIL_ACCOUNTS_SMTPSSL' => 'Usar SSL en la conexión',
  'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'Nombre de usuario SMTP',
  'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'Por Defecto',
  'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => 'Aviso: Falta el nombre de usuario y la contraseña para la cuenta de correo saliente.',
  'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'Hace falta el nombre de usuario SMTP',
  'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'Hace falta la contraseña SMTP',
  'LBL_EMAIL_ACCOUNTS_TITLE' => 'Administración de Cuentas de Correo',
  'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'El Protocolo de Servidores de Correo de tipo POP3 no estará soportado en la siguiente versión. Sólo se soportará IMAP.',
  'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'Configurar Cuentas de Correo para ver correos entrantes de sus cuentas de correo.',
  'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => 'Proporcionar información del servidor de correo SMTP a utilizar para el correo saliente en Cuentas de Correo.',
  'LBL_EMAIL_ADD' => 'Agregar Dirección',
  'LBL_EMAIL_ADDRESS_BOOK_ADD' => 'Hecho',
  'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'Borrar',
  'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'Para:',
  'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'Cc:',
  'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'Cco:',
  'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'Para/Cc/Cco',
  'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'Nueva Lista',
  'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'Dirección de Email',
  'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => 'Sólo se permite la edición de Contactos, de momento.',
  'LBL_EMAIL_ADDRESS_BOOK_FILTER' => 'Filtro',
  'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => 'Nombre/Cuenta',
  'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => 'Apellidos',
  'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => 'Mis Contactos',
  'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => 'Mis Listas de Correo',
  'LBL_EMAIL_ADDRESS_BOOK_NAME' => 'Nombre',
  'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'No se han encontrado ninguna dirección',
  'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => 'Guardar y Agregar a la Libreta de Direcciones',
  'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => 'Búsqueda',
  'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'Seleccionar Destinatarios de Correo',
  'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'Libreta de Direcciones',
  'LBL_EMAIL_REPORTS_TITLE' => 'Informes',
  'LBL_EMAIL_REMOVE_SMTP_WARNING' => '¡Aviso! La cuenta de correo saliente que está intentando eliminar está asociada a una cuenta de correo entrante existente.  ¿Está seguro de que quiere continuar?',
  'LBL_EMAIL_ADDRESSES' => 'Email',
  'LBL_EMAIL_ADDRESS_PRIMARY' => 'Dirección de Email',
  'LBL_EMAIL_ADDRESSES_TITLE' => 'Direcciones de Email',
  'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'Importar a Sugar',
  'LBL_EMAIL_ASSIGNMENT' => 'Asignación',
  'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'Adjuntar',
  'LBL_EMAIL_ATTACHMENT' => 'Adjuntar',
  'LBL_EMAIL_ATTACHMENTS' => 'Desde el Equipo Local',
  'LBL_EMAIL_ATTACHMENTS2' => 'Desde Documentos Sugar',
  'LBL_EMAIL_ATTACHMENTS3' => 'Adjuntos de Plantilla',
  'LBL_EMAIL_ATTACHMENTS_FILE' => 'Archivo',
  'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'Documento',
  'LBL_EMAIL_ATTACHMENTS_EMBEDED' => 'Incrustado',
  'LBL_EMAIL_BCC' => 'CCO',
  'LBL_EMAIL_CANCEL' => 'Cancelar',
  'LBL_EMAIL_CC' => 'CC',
  'LBL_EMAIL_CHARSET' => 'Juego de Caracteres',
  'LBL_EMAIL_CHECK' => 'Comprobar Correo',
  'LBL_EMAIL_CHECKING_NEW' => 'Comprobando Correo Nuevo',
  'LBL_EMAIL_CHECKING_DESC' => 'Un momento, por favor... <br><br>Si es la primera comprobación para esta cuenta de correo, puede tardar un poco.',
  'LBL_EMAIL_CLOSE' => 'Cerrar',
  'LBL_EMAIL_COFFEE_BREAK' => 'Comprobando Correo Nuevo. <br><br>Las cuentas de correo con gran volumen pueden tardar una cantidad considerable de tiempo.',
  'LBL_EMAIL_COMMON' => 'Común',
  'LBL_EMAIL_COMPOSE' => 'Correo',
  'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'Por favor, introduzca los destinatarios de este correo.',
  'LBL_EMAIL_COMPOSE_LINK_TO' => 'Asociar con',
  'LBL_EMAIL_COMPOSE_NO_BODY' => 'El cuerpo de este mensaje está vacío.  ¿Enviar de todas formas?',
  'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'Este mensaje no tiene asunto.  ¿Enviar de todas formas?',
  'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '(sin asunto)',
  'LBL_EMAIL_COMPOSE_READ' => 'Leer y Redactar Correo',
  'LBL_EMAIL_COMPOSE_SEND_FROM' => 'Enviar Cuenta de Correo',
  'LBL_EMAIL_COMPOSE_OPTIONS' => 'Opciones',
  'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'Por favor, introduzca una dirección de correo válida para los campos Para, CC y CCO',
  'LBL_EMAIL_CONFIRM_CLOSE' => '¿Descartar este correo?',
  'LBL_EMAIL_CONFIRM_DELETE' => '¿Desea quitar estas entradas de su Libreta de Direcciones?',
  'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => '¿Está seguro de que desea eliminar esta firma?',
  'LBL_EMAIL_CREATE_NEW' => '--Crear Al Guardar--',
  'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => 'Múltiple',
  'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'Vacío',
  'LBL_EMAIL_DATE_SENT_BY_SENDER' => 'Fecha de Envío por Remitente',
  'LBL_EMAIL_DATE_RECEIVED' => 'Fecha de Recepción',
  'LBL_EMAIL_ASSIGNED_TO_USER' => 'Asignado a Usuario',
  'LBL_EMAIL_DATE_TODAY' => 'Hoy',
  'LBL_EMAIL_DATE_YESTERDAY' => 'Ayer',
  'LBL_EMAIL_DD_TEXT' => 'email(s) seleccionados.',
  'LBL_EMAIL_DEFAULTS' => 'Por defecto',
  'LBL_EMAIL_DELETE' => 'Eliminar',
  'LBL_EMAIL_DELETE_CONFIRM' => '¿Eliminar mensajes seleccionados?',
  'LBL_EMAIL_DELETE_SUCCESS' => 'Email eliminado satisfactoriamente.',
  'LBL_EMAIL_DELETING_MESSAGE' => 'Eliminando Mensaje',
  'LBL_EMAIL_DETAILS' => 'Detalles',
  'LBL_EMAIL_DISPLAY_MSG' => 'Mostrando emails {0} - {1} de {2}',
  'LBL_EMAIL_ADDR_DISPLAY_MSG' => 'Mostrando direcciones de email {0} - {1} de {2}',
  'LBL_EMAIL_EDIT_CONTACT' => 'Editar Contacto',
  'LBL_EMAIL_EDIT_CONTACT_WARN' => 'Sólo se utilizará la Dirección principal de cada Contacto.',
  'LBL_EMAIL_EDIT_MAILING_LIST' => 'Editar Lista de Correo',
  'LBL_EMAIL_EMPTYING_TRASH' => 'Vaciando Papelera',
  'LBL_EMAIL_DELETING_OUTBOUND' => 'Eliminando servidor saliente',
  'LBL_EMAIL_CLEARING_CACHE_FILES' => 'Limpiando archivos de la caché',
  'LBL_EMAIL_EMPTY_MSG' => 'No hay emails que mostrar.',
  'LBL_EMAIL_EMPTY_ADDR_MSG' => 'No hay direcciones de correo que mostrar.',
  'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'El nombre de carpeta debe ser único y no vacío. Por favor, inténtelo de nuevo.',
  'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'No puede borrarse la carpeta. O la carpeta o sus hijos tienen correos o una bandeja de correo asociada.',
  'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => 'No se ha podido determinar la carpeta pretendida a partir del contexto. Inténtelo de nuevo.',
  'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => 'Por favor, compruebe su configuración.',
  'LBL_EMAIL_ERROR_CONTACT_NAME' => 'Por favor, asegúrese de que introduce un apellido.',
  'LBL_EMAIL_ERROR_DESC' => 'Se han detectado errores:',
  'LBL_EMAIL_DELETE_ERROR_DESC' => 'No tiene acceso a este área. Contacte con el administrador del sitio para obtener acceso.',
  'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'Los nombres de carpetas Sugar deben ser únicos.',
  'LBL_EMAIL_ERROR_EMPTY' => 'Por favor, introduzca algún criterio de búsqueda.',
  'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'Ha ocurrido un error',
  'LBL_EMAIL_ERROR_LIST_NAME' => 'Ya existe una lista de correo con ese nombre',
  'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'Mensaje eliminado del servidor',
  'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'O el mensaje se ha eliminado en el servidor o ha sido movido a otra carpeta',
  'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'La conexión con el servidor de correo ha fallado. Por favor, contacte con su Administrador',
  'LBL_EMAIL_ERROR_MOVE' => 'De momento no está soportado el mover correo entre servidores y/o cuentas de correo.',
  'LBL_EMAIL_ERROR_MOVE_TITLE' => 'Error al Mover',
  'LBL_EMAIL_ERROR_NAME' => 'Se requiere un nombre.',
  'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'Se requiere la Dirección del Remitente. Por favor, introduzca una dirección de correo válida.',
  'LBL_EMAIL_ERROR_NO_FILE' => 'Por favor, proporcione un archivo.',
  'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'De momento, no está soportado el cambio de nombre en carpetas IMAP.',
  'LBL_EMAIL_ERROR_SERVER' => 'Se requiere una dirección de servidor de correo.',
  'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'La cuenta de correo puede no haber sido guardada.',
  'LBL_EMAIL_ERROR_TIMEOUT' => 'Ha ocurrido un error en la comunicación con el servidor de correo.',
  'LBL_EMAIL_ERROR_USER' => 'Se requiere un nombre de inicio de sesión.',
  'LBL_EMAIL_ERROR_PASSWORD' => 'Se requiere una contraseña.',
  'LBL_EMAIL_ERROR_PORT' => 'Se requiere un puerto del servidor de correo.',
  'LBL_EMAIL_ERROR_PROTOCOL' => 'Se requiere un protocolo en el servidor.',
  'LBL_EMAIL_ERROR_MONITORED_FOLDER' => 'Se requiere una Carpeta Monitorizada.',
  'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'Se requiere una Carpeta de Papelera.',
  'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'Esta información no setá disponible',
  'LBL_EMAIL_ERROR_NO_OUTBOUND' => 'No se ha especificado un servidor de correo saliente.',
  'LBL_EMAIL_FOLDERS_ACTIONS' => 'Mover A',
  'LBL_EMAIL_FOLDERS_ADD' => 'Agregar',
  'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => 'Agregar Nueva Carpeta',
  'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'Renombrar Carpeta',
  'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => 'Guardar',
  'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'Agregar esta carpeta a',
  'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'Esta carpeta no puede ser cambiada',
  'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => '¿Está seguro de que quiere eliminar esta carpeta?\\nEste proceso no puede ser vuelto atrás.\\nLa eliminación de carpetas se aplicará en cascada a todas las carpetas contenidas.',
  'LBL_EMAIL_FOLDERS_NEW_FOLDER' => 'Nombre de la Nueva Carpeta',
  'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'Por favor, seleccione una carpeta antes de realizar esta acción.',
  'LBL_EMAIL_FOLDERS_TITLE' => 'Administración de Carpetas',
  'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'Usando el Grupo',
  'LBL_EMAIL_FORWARD' => 'Reenviar',
  'LBL_EMAIL_DELIMITER' => '::;::',
  'LBL_EMAIL_DOWNLOAD_STATUS' => '[[count]] de [[total]] emails descargados',
  'LBL_EMAIL_FOUND' => 'Encontrado',
  'LBL_EMAIL_FROM' => 'De',
  'LBL_EMAIL_GROUP' => 'grupo',
  'LBL_EMAIL_UPPER_CASE_GROUP' => 'Grupo',
  'LBL_EMAIL_HOME_FOLDER' => 'Inicio',
  'LBL_EMAIL_HTML_RTF' => 'Enviar HTML',
  'LBL_EMAIL_IE_DELETE' => 'Eliminando Cuenta de Correo',
  'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'Eliminando firma',
  'LBL_EMAIL_IE_DELETE_CONFIRM' => '¿Está seguro de que desea eliminar esta cuenta de correo?',
  'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => 'Borrado satisfactorio.',
  'LBL_EMAIL_IE_SAVE' => 'Guardando Información de Cuenta de Correo',
  'LBL_EMAIL_IMPORTING_EMAIL' => 'Importando Email',
  'LBL_EMAIL_IMPORT_EMAIL' => 'Importar en Sugar',
  'LBL_EMAIL_IMPORT_SETTINGS' => 'Configuración de Importación',
  'LBL_EMAIL_INVALID' => 'No válido',
  'LBL_EMAIL_LOADING' => 'Cargando...',
  'LBL_EMAIL_MARK' => 'Marcar',
  'LBL_EMAIL_MARK_FLAGGED' => 'Como Etiquetado',
  'LBL_EMAIL_MARK_READ' => 'Como Leído',
  'LBL_EMAIL_MARK_UNFLAGGED' => 'Como No Etiquetado',
  'LBL_EMAIL_MARK_UNREAD' => 'Como no Ledído',
  'LBL_EMAIL_ASSIGN_TO' => 'Asignar a',
  'LBL_EMAIL_MENU_ADD_FOLDER' => 'Crear Carpeta',
  'LBL_EMAIL_MENU_COMPOSE' => 'Redactar para',
  'LBL_EMAIL_MENU_DELETE_FOLDER' => 'Eliminar Carpeta',
  'LBL_EMAIL_MENU_EDIT' => 'Editar',
  'LBL_EMAIL_MENU_EMPTY_TRASH' => 'Vaciar Papelera',
  'LBL_EMAIL_MENU_SYNCHRONIZE' => 'Sincronizar',
  'LBL_EMAIL_MENU_CLEAR_CACHE' => 'Limpiar archivos de caché',
  'LBL_EMAIL_MENU_REMOVE' => 'Quitar',
  'LBL_EMAIL_MENU_RENAME' => 'Renombrar',
  'LBL_EMAIL_MENU_RENAME_FOLDER' => 'Renombrar Carpeta',
  'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'Renombrando Carpeta',
  'LBL_EMAIL_MENU_MAKE_SELECTION' => 'Por favor, realice una selección antes de intentar esta operación.',
  'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'Crear una Carpeta (remota o en Sugar)',
  'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'Archivar estos emails en SugarCRM',
  'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => 'Enviar por Email a las listas de Correo seleccionadas',
  'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => 'Enviar por Email a este Contacto',
  'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => 'Quitar un Contacto',
  'LBL_EMAIL_MENU_HELP_DELETE' => 'Eliminar estos emails',
  'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'Eliminar una Carpeta (remota o en Sugar)',
  'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => 'Editar un Contacto',
  'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'Editar una Lista de Correo',
  'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'Vacía todas las carpetas de Papelera de sus cuentas de correo',
  'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'Marcar estos emails como etiquetados',
  'LBL_EMAIL_MENU_HELP_MARK_READ' => 'Marcar estos emails como leídos',
  'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'Marcar estos emails no etiquetados',
  'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'Marcar estos emails no leídos',
  'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'Quita las Listas de Correo',
  'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'Renombrar una Carpeta (remota o en Sugar)',
  'LBL_EMAIL_MENU_HELP_REPLY' => 'Responder a estos emails',
  'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'Responder a todos los destinatarios de estos emails',
  'LBL_EMAIL_MESSAGES' => 'mensajes',
  'LBL_EMAIL_ML_NAME' => 'Nombre de Lista',
  'LBL_EMAIL_ML_ADDRESSES_1' => 'Lista de Direcciones Seleccionada',
  'LBL_EMAIL_ML_ADDRESSES_2' => 'Lista de Direcciones Disponibles',
  'LBL_EMAIL_MULTISELECT' => '<b>Ctrl-Clic</b> para seleccionar múltiples<br />(los usuarios de Mac pueden usar <b>CMD-Clic</b>)',
  'LBL_EMAIL_NO' => 'No',
  'LBL_EMAIL_NOT_SENT' => 'El sistema no puede procesar su petición. Por favor, póngase en contacto con el administrador del sistema.',
  'LBL_EMAIL_OK' => 'Aceptar',
  'LBL_EMAIL_ONE_MOMENT' => 'Un momento, por favor...',
  'LBL_EMAIL_OPEN_ALL' => 'Abrir Múltiples Mensajes',
  'LBL_EMAIL_OPTIONS' => 'Opciones',
  'LBL_EMAIL_QUICK_COMPOSE' => 'Redacción Rápida',
  'LBL_EMAIL_OPT_OUT' => 'Rehusado',
  'LBL_EMAIL_OPT_OUT_AND_INVALID' => 'Rehusado e invalido',
  'LBL_EMAIL_PAGE_AFTER' => 'de {0}',
  'LBL_EMAIL_PAGE_BEFORE' => 'Página',
  'LBL_EMAIL_PERFORMING_TASK' => 'Realizando Tarea',
  'LBL_EMAIL_PRIMARY' => 'Principal',
  'LBL_EMAIL_PRINT' => 'Imprimir',
  'LBL_EMAIL_QC_BUGS' => 'Incidencia',
  'LBL_EMAIL_QC_CASES' => 'Caso',
  'LBL_EMAIL_QC_LEADS' => 'Cliente Potencial',
  'LBL_EMAIL_QC_CONTACTS' => 'Contacto',
  'LBL_EMAIL_QC_TASKS' => 'Tarea',
  'LBL_EMAIL_QC_OPPORTUNITIES' => 'Oportunidad',
  'LBL_EMAIL_QUICK_CREATE' => 'Creación Rápida',
  'LBL_EMAIL_REBUILDING_FOLDERS' => 'Reconstruyendo Carpetas',
  'LBL_EMAIL_RELATE_TO' => 'Relacionar con',
  'LBL_EMAIL_VIEW_RELATIONSHIPS' => 'Ver Relaciones',
  'LBL_EMAIL_RECORD' => 'Registro de Email',
  'LBL_EMAIL_REMOVE' => 'Quitar',
  'LBL_EMAIL_REPLY' => 'Responder',
  'LBL_EMAIL_REPLY_ALL' => 'Responder a Todos',
  'LBL_EMAIL_REPLY_TO' => 'Responder a',
  'LBL_EMAIL_RETRIEVING_LIST' => 'Recuperando Lista de Emails',
  'LBL_EMAIL_RETRIEVING_MESSAGE' => 'Recuperando Mensaje',
  'LBL_EMAIL_RETRIEVING_RECORD' => 'Recuperando Registro de Email',
  'LBL_EMAIL_SELECT_ONE_RECORD' => 'Por favor, seleccione un único registro de email',
  'LBL_EMAIL_RETURN_TO_VIEW' => '¿Volver a Módulo Anterior?',
  'LBL_EMAIL_REVERT' => 'Revertir',
  'LBL_EMAIL_RELATE_EMAIL' => 'Relacionar Email',
  'LBL_EMAIL_RULES_TITLE' => 'Administración de Reglas',
  'LBL_EMAIL_SAVE' => 'Guardar',
  'LBL_EMAIL_SAVE_AND_REPLY' => 'Guardar y Responder',
  'LBL_EMAIL_SAVE_DRAFT' => 'Guardar Borrador',
  'LBL_EMAIL_SEARCHING' => 'Llevando a cabo la Búsqueda',
  'LBL_EMAIL_SEARCH_ADVANCED' => 'Búsqueda Avanzada',
  'LBL_EMAIL_SEARCH_DATE_FROM' => 'Fecha Desde',
  'LBL_EMAIL_SEARCH_DATE_UNTIL' => 'Fecha Hasta',
  'LBL_EMAIL_SEARCH_FULL_TEXT' => 'Texto del Cuerpo',
  'LBL_EMAIL_SEARCH_NO_RESULTS' => 'No hay resultados para sus criterios de búsqueda.',
  'LBL_EMAIL_SEARCH_RESULTS_TITLE' => 'Resultados de la Búsqueda',
  'LBL_EMAIL_SEARCH_TITLE' => 'Búsqueda Simple',
  'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'Buscar cuenta de correo',
  'LBL_EMAIL_SELECT' => 'Seleccionar',
  'LBL_EMAIL_SEND' => 'Enviar',
  'LBL_EMAIL_SENDING_EMAIL' => 'Enviando Email',
  'LBL_EMAIL_SETTINGS' => 'Configuración',
  'LBL_EMAIL_SETTINGS_2_ROWS' => '2 Filas',
  'LBL_EMAIL_SETTINGS_3_COLS' => '3 Columnas',
  'LBL_EMAIL_SETTINGS_LAYOUT' => 'Estilo de Presentación',
  'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'Cuentas de Correo',
  'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'Limpiar Formulario',
  'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => 'Importar Email en Visualización',
  'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => 'Comprobar Correo Nuevo',
  'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'Usar Panel de Previsualización',
  'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'Usar Ventana Emergente',
  'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'Número de emails por página',
  'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'Editar Cuenta de Correo',
  'LBL_EMAIL_SETTINGS_FOLDERS' => 'Carpetas',
  'LBL_EMAIL_SETTINGS_FROM_ADDR' => 'Dirección de Remitente',
  'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'Dirección para Notificación de Prueba:',
  'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => 'Dirección del Destinatario',
  'LBL_EMAIL_SETTINGS_FROM_NAME' => 'Nombre de Remitente',
  'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => 'Dirección de Responder a',
  'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'Pantalla Completa',
  'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'Sincronizar Todas las Cuentas de Correo',
  'LBL_EMAIL_TEST_NOTIFICATION_SENT' => 'Se ha enviado un correo electrónico a la dirección  utilizando la configuración de correo saliente proporcionada. Por favor, compruebe si ha recibido el correo para verificar que la configuración es correcta.',
  'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => 'Esta acción sincronizará las cuentas de correo y su contenido.',
  'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => '¿Realizar una sincronización completa?\\nPara cuentas de correo grandes, puede durar varios minutos.',
  'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'Haga clic en la Tecla Shift o en la tecla Ctrl para seleccionar carpetas múltiples.',
  'LBL_EMAIL_SETTINGS_GENERAL' => 'General',
  'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => 'Carpetas de Grupo Disponibles',
  'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'Crear Carpetas de Grupo',
  'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'Guardando Carpetas de Grupo',
  'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'Recuperando Carpetas de Grupo',
  'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'Editar Carpetas de Grupo',
  'LBL_EMAIL_SETTINGS_NAME' => 'Nombre de Cuenta de Correo',
  'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'Seleccione el número de correos por página en la Bandeja de Entrada. Estas opciones pueden requerir de un refresco de página para ser activadas.',
  'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'Recuperando Email de Cuenta',
  'LBL_EMAIL_SETTINGS_RULES' => 'Reglas',
  'LBL_EMAIL_SETTINGS_SAVED' => 'La configuración ha sido guardada.\\n\\nDebe recargar la página para que la nueva configuración tenga efecto.',
  'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'Enviar Sólo Correos con Texto Plano',
  'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => 'Activas',
  'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'Emails por Página',
  'LBL_EMAIL_SETTINGS_TAB_POS' => 'Poner Pestañas Abajo',
  'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => 'Configuración Visual',
  'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => 'Preferencias',
  'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => 'Mostrar Avanzado',
  'LBL_EMAIL_SETTINGS_USER_FOLDERS' => 'Carpetas de Usuario Disponibles',
  'LBL_EMAIL_ERROR_PREPEND' => 'Error:',
  'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => 'El servidor de correo saliente seleccionado para la cuenta de correo que está utilizando no es válido.  Compruebe la configuración o seleccione un servidor de correo distinto para la cuenta.',
  'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => 'No se ha configurado un servidor de correo saliente para el envío de correos. Por favor, configure o seleccione un servidor de correo saliente para la cuenta de correo que está utilizando en Configuración >> Cuenta de Correo.',
  'LBL_EMAIL_SHOW_READ' => 'Mostrar Todo',
  'LBL_EMAIL_SHOW_UNREAD_ONLY' => 'Mostrar Sólo No leídos',
  'LBL_EMAIL_SIGNATURES' => 'Firmas',
  'LBL_EMAIL_SIGNATURE_CREATE' => 'Nueva Firma',
  'LBL_EMAIL_SIGNATURE_NAME' => 'Nombre de la Firma',
  'LBL_EMAIL_SIGNATURE_TEXT' => 'Cuerpo de la Firma',
  'LBL_SMTPTYPE_GMAIL' => 'Gmail',
  'LBL_SMTPTYPE_YAHOO' => 'Yahoo! Mail',
  'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
  'LBL_SMTPTYPE_OTHER' => 'Otro:',
  'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ Carpetas Remotas ]',
  'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ Carpetas de Sugar ]',
  'LBL_EMAIL_SUBJECT' => 'Asunto',
  'LBL_EMAIL_TO' => 'Para',
  'LBL_EMAIL_SUCCESS' => 'Éxito',
  'LBL_EMAIL_SUGAR_FOLDER' => 'CarpetaDeSugar',
  'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'El cuerpo de la plantilla de correo está vacío',
  'LBL_EMAIL_TEMPLATES' => 'Plantillas',
  'LBL_EMAIL_TEXT_FIRST' => 'Página Primera',
  'LBL_EMAIL_TEXT_PREV' => 'Página Anterior',
  'LBL_EMAIL_TEXT_NEXT' => 'Página Siguiente',
  'LBL_EMAIL_TEXT_LAST' => 'Página Última',
  'LBL_EMAIL_TEXT_REFRESH' => 'Actualizar',
  'LBL_EMAIL_TOGGLE_LIST' => 'Cambiar Lista',
  'LBL_EMAIL_VIEW' => 'Ver',
  'LBL_EMAIL_VIEWS' => 'Vistas',
  'LBL_EMAIL_VIEW_HEADERS' => 'Mostrar Cabeceras',
  'LBL_EMAIL_VIEW_PRINTABLE' => 'Versión Imprimible',
  'LBL_EMAIL_VIEW_RAW' => 'Mostrar Código Fuente del Email',
  'LBL_EMAIL_VIEW_UNSUPPORTED' => 'Esta característica no está soportada cuando se usa con POP3.',
  'LBL_DEFAULT_LINK_TEXT' => 'Texto de enlace por defecto.',
  'LBL_EMAIL_YES' => 'Sí',
  'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'Enviar Correo de Prueba',
  'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'Correo de Prueba Enviado',
  'LBL_EMAIL_CHECK_INTERVAL_DOM' => 
  array (
    '-1' => 'Manualmente',
    '5' => 'Cada 5 minutos',
    '15' => 'Cada 15 minutos',
    '30' => 'Cada 30 minutos',
    '60' => 'Cada hora',
  ),
  'LBL_EMAIL_MESSAGE_NO' => 'Mensaje Nº',
  'LBL_EMAIL_IMPORT_SUCCESS' => 'Importación Existosa',
  'LBL_EMAIL_IMPORT_FAIL' => 'Importación Fallida debido a que el mensaje ya ha sido importado o eliminado del servidor',
  'LBL_LINK_NONE' => 'Ninguno',
  'LBL_LINK_ALL' => 'Todos',
  'LBL_LINK_RECORDS' => 'Registros',
  'LBL_LINK_SELECT' => 'Seleccionar',
  'LBL_LINK_ACTIONS' => 'Acciones',
  'LBL_LINK_MORE' => 'Más',
  'LBL_CLOSE_ACTIVITY_HEADER' => 'Confirmar',
  'LBL_CLOSE_ACTIVITY_CONFIRM' => '¿Desea cerrar este #module#?',
  'LBL_CLOSE_ACTIVITY_REMEMBER' => 'No mostrar este mensaje en el futuro: &amp;nbsp;',
  'LBL_INVALID_FILE_EXTENSION' => 'Extensión de archivo invalida',
  'ERR_AJAX_LOAD' => 'Se produjo un error:',
  'ERR_AJAX_LOAD_FAILURE' => 'Se ha producido un error al procesar su petición, por favor inténtelo de nuevo más tarde.',
  'ERR_AJAX_LOAD_FOOTER' => 'Si persiste el error, por favor solicite al administrador que deshabilite Ajax para este módulo',
  'ERR_CREATING_FIELDS' => 'Error al rellenar los campos adicionales de detalle:',
  'ERR_CREATING_TABLE' => 'Error al crear la tabla:',
  'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'No puede utilizarse el mismo carácter como separador decimal que el utilizado como separador de miles.\\n\\n  Por favor, cambie los valores.',
  'ERR_DELETE_RECORD' => 'Debe especificar un número de registro para eliminar el contacto.',
  'ERR_EXPORT_DISABLED' => 'Exportación deshabilitada.',
  'ERR_EXPORT_TYPE' => 'Error exportando',
  'ERR_INVALID_AMOUNT' => 'Por favor, introduzca una cantidad válida.',
  'ERR_INVALID_DATE_FORMAT' => 'El formato de fecha debe ser:',
  'ERR_INVALID_DATE' => 'Por favor, introduzca una fecha válida.',
  'ERR_INVALID_DAY' => 'Por favor, introduzca un día válido.',
  'ERR_INVALID_EMAIL_ADDRESS' => 'no es una dirección de correo válida.',
  'ERR_INVALID_FILE_REFERENCE' => 'Referencia a archivo no válida',
  'ERR_INVALID_HOUR' => 'Por favor, introduzca una hora válida.',
  'ERR_INVALID_MONTH' => 'Por favor, introduzca un mes válido.',
  'ERR_INVALID_TIME' => 'Por favor, introduzca una hora válida.',
  'ERR_INVALID_YEAR' => 'Por favor, introduzca un año válido de 4 dígitos.',
  'ERR_NEED_ACTIVE_SESSION' => 'Debe tener una sesión activa para exportar el contenido.',
  'ERR_NO_HEADER_ID' => 'Esta funcionalidad no está disponible con este tema.',
  'ERR_NOT_ADMIN' => 'Acceso no autorizado a la administración.',
  'ERR_MISSING_REQUIRED_FIELDS' => 'Falta campo requerido:',
  'ERR_INVALID_REQUIRED_FIELDS' => 'Campo requerido no válido:',
  'ERR_INVALID_VALUE' => 'Valor no válido:',
  'ERR_NO_SUCH_FILE' => 'El archivo no existe en el sistema',
  'ERR_NO_SINGLE_QUOTE' => 'No podemos utilizar las comillas simples para',
  'ERR_NOTHING_SELECTED' => 'Por favor, realice una selección antes de proceder.',
  'ERR_OPPORTUNITY_NAME_DUPE' => 'Ya existe una oportunidad con el nombre %s.  Por favor, introduzca otro nombre a continuación.',
  'ERR_OPPORTUNITY_NAME_MISSING' => 'No ha introducido un nombre para la oportunidad.  Por favor, introduzca un nombre para la oportunidad a continuación.',
  'ERR_POTENTIAL_SEGFAULT' => 'Se ha detectado un posible error de segmentación de Apache.  Por favor, notifique a su administrador del sistema para que le confirme este problema y lo reporte a SugarCRM.',
  'ERR_SELF_REPORTING' => 'Un usuario no puede ser informador de si mismo.',
  'ERR_SINGLE_QUOTE' => 'La comilla simple no está soportada en este campo.  Por favor, cambie el valor.',
  'ERR_SQS_NO_MATCH_FIELD' => 'No se han encontrado coincidencias para el campo:',
  'ERR_SQS_NO_MATCH' => 'Sin coincidencias',
  'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'Por favor, especifique el índice &amp;#39;clave&amp;#39; en el atributo displayParams para la definición de Meta-Datos',
  'ERR_EXISTING_PORTAL_USERNAME' => 'Error: El Nombre de Portal ya ha sido asignado a otro contacto.',
  'ERR_COMPATIBLE_PRECISION_VALUE' => 'El valor del campo no es compatible con el tipo de precisión',
  'ERR_EXTERNAL_API_SAVE_FAIL' => 'Se produjo un error al tratar de salvar en la cuenta externa.',
  'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'Se produjo un error durante la carga. Asegúrese de que el archivo que está cargando no está vacío.',
  'ERR_NO_DB' => 'No se ha podido realizar una conexión a la base de datos. Por favor, consulte sugarcrm.log para más detalles.',
  'ERR_DB_FAIL' => 'Error de base de datos. Por favor, consulte sugarcrm.log para más detalles.',
  'ERR_EXTERNAL_API_403' => 'Permiso denegado. El tipo de archivo no es compatible.',
  'ERR_DB_VERSION' => 'Archivos de Sugar CRM {0} sólo se puede utilizar con una base de datos de Sugar CRM {1}.',
  'LBL_ACCOUNT' => 'Cuenta',
  'LBL_OLD_ACCOUNT_LINK' => 'Cuenta Antigua',
  'LBL_ACCOUNTS' => 'Cuentas',
  'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'Actividades',
  'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
  'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'Ver Resumen',
  'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'Ver Resumen [Alt+H]',
  'LBL_ADD_BUTTON_KEY' => 'A',
  'LBL_ADD_BUTTON_TITLE' => 'Agregar [Alt+A]',
  'LBL_ADD_BUTTON' => 'Agregar',
  'LBL_ADD_DOCUMENT' => 'Agregar Documento',
  'LBL_REPLACE_BUTTON' => 'Reemplazar',
  'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
  'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'Agregar A Lista de Público Objetivo',
  'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'Agregar A Lista de Público Objetivo',
  'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'Clic para Cerrar',
  'LBL_ADDITIONAL_DETAILS_CLOSE' => 'Cerrar',
  'LBL_ADDITIONAL_DETAILS' => 'Detalles Adicionales',
  'LBL_ADMIN' => 'Admin',
  'LBL_ALT_HOT_KEY' => 'Alt+',
  'LBL_ARCHIVE' => 'Archivo',
  'LBL_ASSIGNED_TO_USER' => 'Asignado a Usuario',
  'LBL_ASSIGNED_TO' => 'Asignado a:',
  'LBL_BACK' => 'Atrás',
  'LBL_BILL_TO_ACCOUNT' => 'Cargar en Cuenta',
  'LBL_BILL_TO_CONTACT' => 'Cargar a Contacto',
  'LBL_BILLING_ADDRESS' => 'Dirección de Facturación',
  'LBL_QUICK_CREATE_TITLE' => 'Creación rápida',
  'LBL_BROWSER_TITLE' => 'SugarCRM - CRM Comercial de Fuentes Abiertas',
  'LBL_BUGS' => 'Incidencias',
  'LBL_BY' => 'por',
  'LBL_CALLS' => 'Llamadas',
  'LBL_CALL' => 'Llamada',
  'LBL_CAMPAIGNS_SEND_QUEUED' => 'Enviar Emails de Campaña Encolados',
  'LBL_SUBMIT_BUTTON_LABEL' => 'Enviar',
  'LBL_CASE' => 'Caso',
  'LBL_CASES' => 'Casos',
  'LBL_CHANGE_BUTTON_KEY' => 'G',
  'LBL_CHANGE_PASSWORD' => 'Cambiar contraseña',
  'LBL_CHANGE_BUTTON_LABEL' => 'Cambiar',
  'LBL_CHANGE_BUTTON_TITLE' => 'Cambiar [Alt+G]',
  'LBL_CHARSET' => 'UTF-8',
  'LBL_CHECKALL' => 'Marcar Todos',
  'LBL_CITY' => 'Ciudad',
  'LBL_CLEAR_BUTTON_KEY' => 'C',
  'LBL_CLEAR_BUTTON_LABEL' => 'Limpiar',
  'LBL_CLEAR_BUTTON_TITLE' => 'Limpiar [Alt+C]',
  'LBL_CLEARALL' => 'Desmarcar Todos',
  'LBL_CLOSE_BUTTON_TITLE' => 'Cerrar',
  'LBL_CLOSE_BUTTON_KEY' => 'Q',
  'LBL_CLOSE_WINDOW' => 'Cerrar Ventana',
  'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
  'LBL_CLOSEALL_BUTTON_LABEL' => 'Cerrar Todo',
  'LBL_CLOSEALL_BUTTON_TITLE' => 'Cerrar Todo [Alt+I]',
  'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'Cerrar y Crear Nuevo',
  'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'Cerrar y Crear Nuevo',
  'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
  'LBL_OPEN_ITEMS' => 'Elementos Abiertos:',
  'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
  'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'Redactar Correo',
  'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'Redactar Correo [Alt+L]',
  'LBL_SEARCH_DROPDOWN_YES' => 'Sí',
  'LBL_SEARCH_DROPDOWN_NO' => 'No',
  'LBL_CONTACT_LIST' => 'Lista de Contactos',
  'LBL_CONTACT' => 'Contacto',
  'LBL_CONTACTS' => 'Contactos',
  'LBL_CONTRACTS' => 'Contratos',
  'LBL_COUNTRY' => 'País:',
  'LBL_CREATE_BUTTON_LABEL' => 'Crear',
  'LBL_CREATED_BY_USER' => 'Creado por Usuario',
  'LBL_CREATED_USER' => 'Creado por Usuario',
  'LBL_CREATED_ID' => 'Creado por Id',
  'LBL_CREATED' => 'Creado por',
  'LBL_CURRENT_USER_FILTER' => 'Mis Elementos:',
  'LBL_CURRENCY' => 'Moneda:',
  'LBL_DOCUMENTS' => 'Documentos',
  'LBL_DATE_ENTERED' => 'Fecha de Creación:',
  'LBL_DATE_MODIFIED' => 'Fecha de Modificación:',
  'LBL_EDIT_BUTTON' => 'Editar',
  'LBL_DUPLICATE_BUTTON' => 'Duplicar',
  'LBL_DELETE_BUTTON' => 'Eliminar',
  'LBL_DELETE' => 'Eliminar',
  'LBL_DELETED' => 'Eliminado',
  'LBL_DIRECT_REPORTS' => 'Informa a',
  'LBL_DONE_BUTTON_KEY' => 'X',
  'LBL_DONE_BUTTON_LABEL' => 'Hecho',
  'LBL_DONE_BUTTON_TITLE' => 'Hecho [Alt+X]',
  'LBL_DST_NEEDS_FIXIN' => 'La aplicación requiere que se aplique una reparación de Horario de Verano.  Por favor, vaya al vínculo <a href="index.php?module=Administration&amp;action=DstFix">Reparar</a> en la consola de Administración y aplique la reparación de Horario de Verano.',
  'LBL_EDIT_AS_NEW_BUTTON_LABEL' => 'Editar Como Nuevo',
  'LBL_EDIT_AS_NEW_BUTTON_TITLE' => 'Editar Como Nuevo',
  'LBL_FAVORITES' => 'Favoritos',
  'LBL_FILTER_MENU_BY' => 'Filtrar menú por',
  'LBL_VCARD' => 'vCard',
  'LBL_EMPTY_VCARD' => 'Por favor, seleccione un archivo vCard',
  'LBL_IMPORT_VCARD' => 'Importar vCard:',
  'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
  'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'Importar vCard',
  'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'Importar vCard [Alt+I]',
  'LBL_VIEW_BUTTON_KEY' => 'V',
  'LBL_VIEW_BUTTON_LABEL' => 'Ver',
  'LBL_VIEW_BUTTON_TITLE' => 'Ver [Alt+V]',
  'LBL_VIEW_BUTTON' => 'Ver',
  'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
  'LBL_EMAIL_PDF_BUTTON_LABEL' => 'Enviar como PDF',
  'LBL_EMAIL_PDF_BUTTON_TITLE' => 'Enviar como PDF [Alt+M]',
  'LBL_EMAILS' => 'Correos',
  'LBL_EMPLOYEES' => 'Empleados',
  'LBL_ENTER_DATE' => 'Introducir Fecha',
  'LBL_EXPORT_ALL' => 'Exportar Todo',
  'LBL_EXPORT' => 'Exportar',
  'LBL_FAVORITES_FILTER' => 'Mis Favoritos:',
  'LBL_GO_BUTTON_LABEL' => 'Adelante',
  'LBL_GS_HELP' => 'Los campos de este módulo utilizado en esta búsqueda aparecen más arriba. El texto resaltado con los criterios requeridos.',
  'LBL_HIDE' => 'Ocultar',
  'LBL_ID' => 'ID',
  'LBL_IMPORT' => 'Importar',
  'LBL_IMPORT_STARTED' => 'Importación iniciada:',
  'LBL_MISSING_CUSTOM_DELIMITER' => 'Debe especificar un delimitador particular.',
  'LBL_LAST_VIEWED' => 'Recientes',
  'LBL_SHOW_LESS' => 'Mostrar menos',
  'LBL_SHOW_MORE' => 'Mostrar más',
  'LBL_TODAYS_ACTIVITIES' => 'Actividades de Hoy',
  'LBL_LEADS' => 'Clientes Potenciales',
  'LBL_LESS' => 'menos',
  'LBL_CAMPAIGN' => 'Campaña:',
  'LBL_CAMPAIGNS' => 'Campañas',
  'LBL_CAMPAIGNLOG' => 'LogDeCampaña',
  'LBL_CAMPAIGN_CONTACT' => 'Campañas',
  'LBL_CAMPAIGN_ID' => 'campaña_id',
  'LBL_SITEMAP' => 'Mapa del sitio',
  'LBL_THEME' => 'Tema:',
  'LBL_THEME_PICKER' => 'Estilo de Página',
  'LBL_THEME_PICKER_IE6COMPAT_CHECK' => 'Aviso: Internet Explorer 6 no estará soportado para el tema seleccionado. Haga clic en Aceptar para seleccionarlo de todas maneras o Cancelar para seleccionar otro tema.',
  'LBL_FOUND_IN_RELEASE' => 'Encontrado en Versión',
  'LBL_FIXED_IN_RELEASE' => 'Corregido en Versión',
  'LBL_LIST_ACCOUNT_NAME' => 'Nombre Cuenta',
  'LBL_LIST_ASSIGNED_USER' => 'Usuario',
  'LBL_LIST_CONTACT_NAME' => 'Nombre Contacto',
  'LBL_LIST_CONTACT_ROLE' => 'Rol Contacto',
  'LBL_LIST_DATE_ENTERED' => 'Fecha de Creación',
  'LBL_LIST_EMAIL' => 'Correo',
  'LBL_LIST_NAME' => 'Nombre',
  'LBL_LIST_OF' => 'de',
  'LBL_LIST_PHONE' => 'Teléfono',
  'LBL_LIST_RELATED_TO' => 'Relacionado con',
  'LBL_LIST_USER_NAME' => 'Nombre de Usuario',
  'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => '¿Está seguro de que desea actualizar la lista entera?',
  'LBL_LISTVIEW_NO_SELECTED' => 'Por favor, seleccione al menos 1 registro para proceder.',
  'LBL_LISTVIEW_TWO_REQUIRED' => 'Por favor, seleccione al menos 2 registros para proceder.',
  'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => 'Por favor, seleccione menos de 10 registros para proceder.',
  'LBL_LISTVIEW_ALL' => 'Todo',
  'LBL_LISTVIEW_NONE' => 'Quitar Selección',
  'LBL_LISTVIEW_OPTION_CURRENT' => 'Seleccionar Página Actual',
  'LBL_LISTVIEW_OPTION_ENTIRE' => 'Seleccionar Todo',
  'LBL_LISTVIEW_OPTION_SELECTED' => 'Registros Seleccionados',
  'LBL_LISTVIEW_SELECTED_OBJECTS' => 'Seleccionados:',
  'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'Juan',
  'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'Pérez',
  'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'Sr.',
  'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Mago del Código Fuente',
  'LBL_LOGIN_TO_ACCESS' => 'Por favor, inicie la sesión para acceder a este área.',
  'LBL_LOGOUT' => 'Salir',
  'LBL_PROFILE' => 'Perfil',
  'LBL_MAILMERGE_KEY' => 'M',
  'LBL_MAILMERGE' => 'Combinar Correspondencia',
  'LBL_MASS_UPDATE' => 'Actualización Masiva',
  'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => 'No hay campos disponibles para la operación de actualización masiva.',
  'LBL_OPT_OUT_FLAG_PRIMARY' => 'Rehusar para Email Principal',
  'LBL_MEETINGS' => 'Reuniones',
  'LBL_MEETING' => 'Reunión',
  'LBL_MEETING_GO_BACK' => 'Volver a la reunión',
  'LBL_MEMBERS' => 'Miembros',
  'LBL_MEMBER_OF' => 'Miembro de',
  'LBL_MODIFIED_BY_USER' => 'Modificado por Usuario',
  'LBL_MODIFIED_USER' => 'Modificado por Usuario',
  'LBL_MODIFIED' => 'Modificado por',
  'LBL_MODIFIED_NAME' => 'Modificado por Nombre',
  'LBL_MODIFIED_ID' => 'Modificado por Id',
  'LBL_MORE' => 'Más',
  'LBL_MY_ACCOUNT' => 'Mi Configuración',
  'LBL_NAME' => 'Nombre',
  'LBL_NEW_BUTTON_KEY' => 'N',
  'LBL_NEW_BUTTON_LABEL' => 'Nuevo',
  'LBL_NEW_BUTTON_TITLE' => 'Nuevo [Alt+N]',
  'LBL_NEXT_BUTTON_LABEL' => 'Siguiente',
  'LBL_NONE' => '-ninguno-',
  'LBL_NOTES' => 'Notas',
  'LBL_OPENALL_BUTTON_KEY' => 'O',
  'LBL_OPENALL_BUTTON_LABEL' => 'Abrir Todo',
  'LBL_OPENALL_BUTTON_TITLE' => 'Abrir Todo [Alt+O]',
  'LBL_OPENTO_BUTTON_KEY' => 'T',
  'LBL_OPENTO_BUTTON_LABEL' => 'Abrir En:',
  'LBL_OPENTO_BUTTON_TITLE' => 'Abrir En: [Alt+T]',
  'LBL_OPPORTUNITIES' => 'Oportunidades',
  'LBL_OPPORTUNITY_NAME' => 'Nombre de Oportunidad',
  'LBL_OPPORTUNITY' => 'Oportunidad',
  'LBL_OR' => 'O',
  'LBL_LOWER_OR' => 'o',
  'LBL_PANEL_ASSIGNMENT' => 'Otro',
  'LBL_PANEL_ADVANCED' => 'Más Información',
  'LBL_PARENT_TYPE' => 'Tipo de Padre',
  'LBL_PERCENTAGE_SYMBOL' => '%',
  'LBL_PHASE' => 'Fase',
  'LBL_POSTAL_CODE' => 'Código Postal:',
  'LBL_PRIMARY_ADDRESS_CITY' => 'Ciudad de dirección principal:',
  'LBL_PRIMARY_ADDRESS_COUNTRY' => 'País de dirección principal:',
  'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'CP de dirección principal:',
  'LBL_PRIMARY_ADDRESS_STATE' => 'Estado/Provincia de dirección principal:',
  'LBL_PRIMARY_ADDRESS_STREET_2' => 'Calle de dirección principal 2',
  'LBL_PRIMARY_ADDRESS_STREET_3' => 'Calle de dirección principal 3',
  'LBL_PRIMARY_ADDRESS_STREET' => 'Calle de dirección principal:',
  'LBL_PRIMARY_ADDRESS' => 'Dirección principal:',
  'LBL_BILLING_STREET' => 'Calle:',
  'LBL_SHIPPING_STREET' => 'Calle:',
  'LBL_PRODUCT_BUNDLES' => 'Juegos de Productos',
  'LBL_PRODUCTS' => 'Productos',
  'LBL_PROJECT_TASKS' => 'Tareas de Proyecto',
  'LBL_PROJECTS' => 'Proyectos',
  'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
  'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'Crear Oportunidad a partir de Presupuesto',
  'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'Crear Oportunidad a partir de Presupuesto [Alt+O]',
  'LBL_QUOTES_SHIP_TO' => 'Presupuestos enviados a',
  'LBL_QUOTES' => 'Presupuestos',
  'LBL_RELATED' => 'Relacionado',
  'LBL_RELATED_INFORMATION' => 'Información Relacionada',
  'LBL_RELATED_RECORDS' => 'Registros Relacionados',
  'LBL_REMOVE' => 'Quitar',
  'LBL_REPORTS_TO' => 'Informa a',
  'LBL_REQUIRED_SYMBOL' => '*',
  'LBL_REQUIRED_TITLE' => 'Indica que es un campo requerido',
  'LBL_EMAIL_DONE_BUTTON_LABEL' => 'Hecho',
  'LBL_SAVE_AS_BUTTON_KEY' => 'A',
  'LBL_SAVE_AS_BUTTON_LABEL' => 'Guardar Como',
  'LBL_SAVE_AS_BUTTON_TITLE' => 'Guardar Como [Alt+A]',
  'LBL_FULL_FORM_BUTTON_KEY' => 'F',
  'LBL_FULL_FORM_BUTTON_LABEL' => 'Formulario Completo',
  'LBL_FULL_FORM_BUTTON_TITLE' => 'Formulario Completo [Alt+F]',
  'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
  'LBL_SAVE_NEW_BUTTON_LABEL' => 'Guardar y Crear Nuevo',
  'LBL_SAVE_NEW_BUTTON_TITLE' => 'Guardar y Crear Nuevo [Alt+V]',
  'LBL_SAVE_OBJECT' => 'Guardar {0}',
  'LBL_SEARCH_BUTTON_KEY' => 'Q',
  'LBL_SEARCH_BUTTON_LABEL' => 'Buscar',
  'LBL_SEARCH_BUTTON_TITLE' => 'Buscar [Alt+Q]',
  'LBL_SEARCH' => 'Buscar',
  'LBL_SEARCH_TIPS' => 'Pulse el botón de búsqueda o haga clic en Enter para obtener una coincidencia exacta para ellos.',
  'LBL_SEARCH_TIPS_2' => 'Pulse el botón de búsqueda o haga clic en Enter para obtener una coincidencia exacta para',
  'LBL_SEARCH_MORE' => 'más',
  'LBL_SEE_ALL' => 'Ver Todo',
  'LBL_UPLOAD_IMAGE_FILE_INVALID' => 'Formato de archivo no válido, sólo es posible subir archivos con imágenes.',
  'LBL_SELECT_BUTTON_KEY' => 'T',
  'LBL_SELECT_BUTTON_LABEL' => 'Seleccionar',
  'LBL_SELECT_BUTTON_TITLE' => 'Seleccionar [Alt+T]',
  'LBL_SELECT_TEAMS_KEY' => 'Z',
  'LBL_SELECT_TEAMS_LABEL' => 'Agregar Equipo(s)',
  'LBL_SELECT_TEAMS_TITLE' => 'Agregar Equipo(s) [Alt+Z]',
  'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
  'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'Explorar Documentos',
  'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'Explorar Documentos [Alt+B]',
  'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
  'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'Seleccionar Contacto',
  'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'Seleccionar Contacto [Alt+T]',
  'LBL_GRID_SELECTED_FILE' => 'archivo seleccionado',
  'LBL_GRID_SELECTED_FILES' => 'archivos seleccionados',
  'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'Seleccionar desde Informes',
  'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'Seleccionar Informes',
  'LBL_SELECT_USER_BUTTON_KEY' => 'U',
  'LBL_SELECT_USER_BUTTON_LABEL' => 'Seleccionar Usuario',
  'LBL_SELECT_USER_BUTTON_TITLE' => 'Seleccionar Usuario [Alt+U]',
  'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => 'Limpiar relación',
  'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => 'Limpiar selección',
  'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => 'Limpiar selección',
  'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => 'Limpiar colección',
  'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => 'Limpiar selección',
  'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => 'Limpiar selección',
  'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
  'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'Seleccionar archivo [Alt+F]',
  'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'Seleccionar archivo',
  'LBL_ACCESSKEY_CLEAR_FILE_KEY' => 'Limpiar archivos',
  'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'Limpiar archivo',
  'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'Limpiar archivo',
  'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
  'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'Seleccionar usuario [Alt+U]',
  'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'Seleccionar usuario',
  'LBL_ACCESSKEY_CLEAR_USERS_KEY' => 'Limpiar usuarios',
  'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'Limpiar usuario',
  'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'Limpiar usuairo',
  'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
  'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => 'Seleccionar cuenta [Alt+A]',
  'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => 'Seleccionar cuenta',
  'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => 'Limpiar cuentas',
  'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => 'Limpiar cuenta',
  'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => 'Limpiar cuenta',
  'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
  'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'Seleccionar campaña [Alt+M]',
  'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'Seleccionar campaña',
  'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => 'Limpiar campañas',
  'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'Limpiar campaña',
  'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'Limpiar campaña',
  'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
  'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => 'Seleccionar contacto [Alt+C]',
  'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => 'Seleccionar contacto',
  'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => 'Limpiar contactos',
  'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => 'Limpiar contacto',
  'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => 'Limpiar contacto',
  'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
  'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'Seleccionar equipo [Alt+Z]',
  'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'Seleccionar equipo',
  'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => 'Limpiar equipos',
  'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'Limpiar equipo',
  'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'Limpiar equipo',
  'LBL_SERVER_RESPONSE_RESOURCES' => 'Recursos usados para construir esta página (consultas, archivos)',
  'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'segundos.',
  'LBL_SERVER_RESPONSE_TIME' => 'Tiempo de respuesta del servidor:',
  'LBL_SERVER_MEMORY_BYTES' => 'bytes',
  'LBL_SERVER_MEMORY_USAGE' => 'Uso de la memoria del servidor: {0} ({1})',
  'LBL_SERVER_MEMORY_LOG_MESSAGE' => 'Uso: - modulo: {0} - acción: {1}',
  'LBL_SERVER_PEAK_MEMORY_USAGE' => 'Uso de la memoria máxima del servidor: {0} ({1})',
  'LBL_SHIP_TO_ACCOUNT' => 'Enviar a Cuenta',
  'LBL_SHIP_TO_CONTACT' => 'Enviar a Contacto',
  'LBL_SHIPPING_ADDRESS' => 'Dirección de Envío',
  'LBL_SHORTCUTS' => 'Atajos',
  'LBL_SHOW' => 'Mostrar',
  'LBL_SQS_INDICATOR' => '',
  'LBL_STATE' => 'Estado/Provincia:',
  'LBL_STATUS_UPDATED' => '¡Su estado para este evento ha sido actualizado!',
  'LBL_STATUS' => 'Estado:',
  'LBL_STREET' => 'Calle',
  'LBL_SUBJECT' => 'Asunto',
  'LBL_INBOUNDEMAIL_ID' => 'ID de Correo Entrante',
  'LBL_SUGAR_COPYRIGHT' => '&amp;copy; 2004-2011 SugarCRM Inc. El Programa ha sido proporcionado TAL CUAL, sin garantía de ningún tipo.  Licenciado bajo la <a href="LICENSE.txt" target="_blank" class="copyRightLink">AGPLv3</a>.<br />SugarCRM es una marca registrada de SugarCRM, Inc.  Cualquier otro nombre de compañía o producto puede ser marca registrada de las respectivas compañías con las que esté asociado.',
  'LBL_SUGAR_COPYRIGHT_SUB' => '&amp;copy; 2004-2011 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> Todos los Derechos Reservados.<br />SugarCRM es una marca registrada de SugarCRM, Inc. Cualquier otro nombre de compañía o producto puede ser marca registrada de las respectivas compañías con las que esté asociado.',
  'LBL_SYNC' => 'Sincronizar',
  'LBL_TABGROUP_ALL' => 'Todo',
  'LBL_TABGROUP_ACTIVITIES' => 'Actividades',
  'LBL_TABGROUP_COLLABORATION' => 'Colaboración',
  'LBL_TABGROUP_HOME' => 'Inicio',
  'LBL_TABGROUP_MARKETING' => 'Marketing',
  'LBL_TABGROUP_MY_PORTALS' => 'Mis Sitios',
  'LBL_TABGROUP_OTHER' => 'Otro',
  'LBL_TABGROUP_REPORTS' => 'Informes',
  'LBL_TABGROUP_SALES' => 'Ventas',
  'LBL_TABGROUP_SUPPORT' => 'Soporte',
  'LBL_TABGROUP_TOOLS' => 'Herramientas',
  'LBL_TASKS' => 'Tareas',
  'LBL_TEAMS_LINK' => 'Equipos',
  'LBL_THEME_COLOR' => 'Color',
  'LBL_THEME_FONT' => 'Fuente',
  'LBL_THOUSANDS_SYMBOL' => 'K',
  'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
  'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'Archivar Correo',
  'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'Archivar Correo [Alt+K]',
  'LBL_UNAUTH_ADMIN' => 'Acceso no autorizado a la administración',
  'LBL_UNDELETE_BUTTON_LABEL' => 'Restaurar',
  'LBL_UNDELETE_BUTTON_TITLE' => 'Restaurar [Alt+D]',
  'LBL_UNDELETE_BUTTON' => 'Restaurar',
  'LBL_UNDELETE' => 'Restaurar',
  'LBL_UNSYNC' => 'Desincronizar',
  'LBL_UPDATE' => 'Actualizar',
  'LBL_USER_LIST' => 'Lista de Usuarios',
  'LBL_USERS_SYNC' => 'Sincronización de Usuarios',
  'LBL_USERS' => 'Usuarios',
  'LBL_VERIFY_EMAIL_ADDRESS' => 'Comprobando la entrada de correo actual...',
  'LBL_VERIFY_PORTAL_NAME' => 'Comprobando el nombre de portal actual...',
  'LBL_VIEW_IMAGE' => 'ver',
  'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
  'LBL_VIEW_PDF_BUTTON_LABEL' => 'Imprimir como PDF',
  'LBL_VIEW_PDF_BUTTON_TITLE' => 'Imprimir como PDF [Alt+P]',
  'LNK_ABOUT' => 'Acerca de',
  'LNK_ADVANCED_SEARCH' => 'Búsqueda Avanzada',
  'LNK_BASIC_SEARCH' => 'Búsqueda Básica',
  'LNK_SEARCH_FTS_VIEW_ALL' => 'Ver todos los resultados',
  'LNK_SEARCH_NONFTS_VIEW_ALL' => 'Mostrar Todo',
  'LNK_CLOSE' => 'cerrar',
  'LBL_MODIFY_CURRENT_SEARCH' => 'Modificar búsqueda actual',
  'LNK_SAVED_VIEWS' => 'Opciones de Diseño',
  'LNK_DELETE_ALL' => 'elim todo',
  'LNK_DELETE' => 'elim',
  'LNK_EDIT' => 'editar',
  'LNK_GET_LATEST' => 'Obtener última',
  'LNK_GET_LATEST_TOOLTIP' => 'Reemplazar con última versión',
  'LNK_HELP' => 'Ayuda',
  'LNK_CREATE' => 'Crear',
  'LNK_LIST_END' => 'Fin',
  'LNK_LIST_NEXT' => 'Siguiente',
  'LNK_LIST_PREVIOUS' => 'Anterior',
  'LNK_LIST_RETURN' => 'Volver a lista',
  'LNK_LIST_START' => 'Inicio',
  'LNK_LOAD_SIGNED' => 'Firmar',
  'LNK_LOAD_SIGNED_TOOLTIP' => 'Reemplazar con documento firmado',
  'LNK_PRINT' => 'Imprimir',
  'LNK_BACKTOTOP' => 'Volver al parte superior',
  'LNK_REMOVE' => 'quit',
  'LNK_RESUME' => 'Continuar',
  'LNK_VIEW_CHANGE_LOG' => 'Ver Registro de Cambios',
  'NTC_CLICK_BACK' => 'Por favor, presione el botón anterior del navegador y corrija el error.',
  'NTC_DATE_FORMAT' => '(aaaa-mm-dd)',
  'NTC_DATE_TIME_FORMAT' => '(aaaa-mm-dd 24:00)',
  'NTC_DELETE_CONFIRMATION_MULTIPLE' => '¿Está seguro de que desea eliminar los registros seleccionados?',
  'NTC_TEMPLATE_IS_USED' => 'La plantilla se está utilizando en al menos un registro de marketing por email. ¿Está seguro de que desea eliminarla?',
  'NTC_TEMPLATES_IS_USED' => 'Las siguientes plantillas se están utilizando en registros de marketing por email. ¿Está seguro de que desea eliminarlas?',
  'NTC_DELETE_CONFIRMATION' => '¿Está seguro de que desea eliminar esta registro?',
  'NTC_DELETE_CONFIRMATION_NUM' => '¿Está seguro de que desea eliminar el (los)',
  'NTC_UPDATE_CONFIRMATION_NUM' => '¿Está seguro de que desea actualizar el (los)',
  'NTC_DELETE_SELECTED_RECORDS' => 'registro(s) seleccionado(s)?',
  'NTC_LOGIN_MESSAGE' => 'Por favor, introduzca su nombre de usuario y contraseña.',
  'NTC_NO_ITEMS_DISPLAY' => 'ninguno',
  'NTC_REMOVE_CONFIRMATION' => '¿Está seguro de que desea quitar esta relación?',
  'NTC_REQUIRED' => 'Indica un campo requerido',
  'NTC_SUPPORT_SUGARCRM' => 'Soporte el proyecto de fuentes abiertos SugarCRM mediante una donación a través de PayPal - ¡es rápido, gratis y seguro!',
  'NTC_TIME_FORMAT' => '(24:00)',
  'NTC_WELCOME' => 'Bienvenido',
  'NTC_YEAR_FORMAT' => '(aaaa)',
  'LOGIN_LOGO_ERROR' => 'Por favor, reemplace los logos de SugarCRM.',
  'ERROR_FULLY_EXPIRED' => 'La licencia de su compañía para SugarCRM ha caducado hace más de 30 días y necesita ser actualizada. Sólo los administradores podrán iniciar la sesión.',
  'ERROR_LICENSE_EXPIRED' => 'La licencia de su compañía para SugarCRM debe ser actualizada. Sólo los administradores podrán iniciar la sesión',
  'ERROR_LICENSE_VALIDATION' => 'La licencia para SugarCRM de su compañía necesita ser validada. Sólo los administradores pueden iniciar la sesión',
  'WARN_BROWSER_VERSION_WARNING' => '<p><b>Aviso: </b>Su navegador o la versión de su navegador no es compatible.</p><p>Se recomiendan las siguientes versiones de navegadores:</p><ul><li>Internet Explorer 9</li><li>Mozilla Firefox 14, 15 </li><li>Safari 6</li><li>Google Chrome 22 (or latest version)</li></ul>',
  'WARN_LICENSE_SEATS' => 'Aviso: El número de usuarios activos ha alcanzado el número máximo de licencias permitidas.',
  'WARN_LICENSE_SEATS_MAXED' => 'Aviso: El número de usuarios activos supera el número máximo de licencias permitidas.',
  'WARN_ONLY_ADMINS' => 'Sólo los administradores pueden iniciar la sesión.',
  'WARN_UNSAVED_CHANGES' => 'Está a punto de abandonar este registro sin guardar los cambios que haya podido realizar. ¿Está seguro de que desea salir de este registro?',
  'ERROR_NO_RECORD' => 'Error al recuperar registro.  Este registro puede haber sido eliminado o puede que no esté autorizado para verlo.',
  'ERROR_TYPE_NOT_VALID' => 'Error. Este tipo no es válido.',
  'ERROR_NO_BEAN' => 'Falló la obtención del bean',
  'LBL_DUP_MERGE' => 'Buscar Duplicados',
  'LBL_MANAGE_SUBSCRIPTIONS' => 'Administrar Suscripciones',
  'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'Administrar Suscripciones a',
  'LBL_SUBSCRIBE' => 'Suscribir',
  'LBL_UNSUBSCRIBE' => 'Eliminar Suscripción',
  'LBL_LOADING' => 'Cargando ...',
  'LBL_SEARCHING' => 'Buscando...',
  'LBL_SAVING_LAYOUT' => 'Guardando Diseño ...',
  'LBL_SAVED_LAYOUT' => 'El diseño ha sido guardado.',
  'LBL_SAVED' => 'Guardado',
  'LBL_SAVING' => 'Guardando',
  'LBL_FAILED' => '¡Error!',
  'LBL_DISPLAY_COLUMNS' => 'Mostrar Columnas',
  'LBL_HIDE_COLUMNS' => 'Ocultar Columnas',
  'LBL_SEARCH_CRITERIA' => 'Criterios de Búsqueda',
  'LBL_SAVED_VIEWS' => 'Vistas Guardadas',
  'LBL_PROCESSING_REQUEST' => 'Procesando...',
  'LBL_REQUEST_PROCESSED' => 'Hecho',
  'LBL_AJAX_FAILURE' => 'Fallo de Ajax',
  'LBL_MERGE_DUPLICATES' => 'Combinar',
  'LBL_SAVED_SEARCH_SHORTCUT' => 'Búsquedas Guardadas',
  'LBL_SEARCH_POPULATE_ONLY' => 'Realizar una búsqueda utilizando el formulario de búsqueda anterior',
  'LBL_DETAILVIEW' => 'Vista de Detalle',
  'LBL_LISTVIEW' => 'Vista de Lista',
  'LBL_EDITVIEW' => 'Vista de Edición',
  'LBL_SEARCHFORM' => 'Formulario de Búsqueda',
  'LBL_SAVED_SEARCH_ERROR' => 'Por favor, introduzca un nombre para esta vista.',
  'LBL_DISPLAY_LOG' => 'Mostrar Traza',
  'ERROR_JS_ALERT_SYSTEM_CLASS' => 'Sistema',
  'ERROR_JS_ALERT_TIMEOUT_TITLE' => 'Cierre de la Sesión',
  'ERROR_JS_ALERT_TIMEOUT_MSG_1' => 'Su sesión va a expirar en 2 minutos. Por favor, guarde su trabajo.',
  'ERROR_JS_ALERT_TIMEOUT_MSG_2' => 'Su sesión ha expirado.',
  'MSG_JS_ALERT_MTG_REMINDER_AGENDA' => 'Agenda:',
  'MSG_JS_ALERT_MTG_REMINDER_MEETING' => 'Reunión',
  'MSG_JS_ALERT_MTG_REMINDER_CALL' => 'Llamada',
  'MSG_JS_ALERT_MTG_REMINDER_TIME' => 'Hora:',
  'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'Lugar:',
  'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'Descripción:',
  'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'Haga clic en Aceptar para acceder a esta llamada o haga clic en Cancelar para cerrar este mensaje.',
  'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'Haga clic en Aceptar para ver esta reunión o en Cancelar para omitir este mensaje.',
  'MSG_LIST_VIEW_NO_RESULTS_BASIC' => 'No se encontraron resultados.',
  'MSG_LIST_VIEW_NO_RESULTS' => 'No se encontraron resultados.',
  'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => 'Crear como uno nuevo',
  'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => 'Actualmente no tiene registros guardados.',
  'MSG_EMPTY_LIST_VIEW_NO_RESULTS_SUBMSG' => 'Aprender más sobre el módulo. Para obtener más información, use el menú desplegable de usuario localizado en la barra de navegación principal para acceder a Ayuda.',
  'LBL_CLICK_HERE' => 'Haga clic aquí',
  'LBL_ADD_TO_FAVORITES' => 'Agregar a Mis Favoritos',
  'LBL_MARK_AS_FAVORITES' => 'Marcar como Favorito',
  'LBL_CREATE_CONTACT' => 'Nuevo Contacto',
  'LBL_CREATE_CASE' => 'Nuevo Caso',
  'LBL_CREATE_NOTE' => 'Nueva Nota',
  'LBL_CREATE_OPPORTUNITY' => 'Nueva Oportunidad',
  'LBL_SCHEDULE_CALL' => 'Registrar Llamada',
  'LBL_SCHEDULE_MEETING' => 'Programar Reunión',
  'LBL_CREATE_TASK' => 'Nueva Tarea',
  'LBL_REMOVE_FROM_FAVORITES' => 'Quitar de Mis Favoritos',
  'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'Generar Formulario',
  'LBL_SAVE_WEB_TO_LEAD_FORM' => 'Guardar Formulario Web A Cliente Potencial',
  'LBL_PLEASE_SELECT' => 'Por favor, Seleccione',
  'LBL_REDIRECT_URL' => 'URL de Redirección',
  'LBL_RELATED_CAMPAIGN' => 'Campaña relacionada',
  'LBL_ADD_ALL_LEAD_FIELDS' => 'Agregar Todos los Campos',
  'LBL_REMOVE_ALL_LEAD_FIELDS' => 'Quitar Todos los Campos',
  'LBL_ONLY_IMAGE_ATTACHMENT' => 'Sólo puede incluirse un adjunto de tipo imagen',
  'LBL_TRAINING' => 'Soporte',
  'ERR_DATABASE_CONN_DROPPED' => 'Error ejecutando una consulta. Posiblemente su base de datos se ha desconectado. Por favor, actualice esta página. Es posible que incluso necesite reiniciar su servidor web.',
  'ERR_MSSQL_DB_CONTEXT' => 'Cambiado el contexto de base de datos a',
  'ERR_MSSQL_WARNING' => 'Aviso:',
  'ERR_MISSING_VARDEF_NAME' => 'Aviso: el campo [[field]] no tiene una entrada mapeada en el archivo vardefs.php de [moduleDir]',
  'ERR_CANNOT_CREATE_METADATA_FILE' => 'Error: No existe el archivo [[file]].  No se ha podido crear porque el archivo con el HTML correspondiente no ha sido encontrado.',
  'ERR_CANNOT_FIND_MODULE' => 'Error: El módulo [module] no existe.',
  'LBL_ALT_ADDRESS' => 'Otra Dirección:',
  'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'Error: Hay un número de argumentos desigual para los elementos &amp;#39;key&amp;#39; y &amp;#39;copy&amp;#39; en el array displayParams.',
  'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'Falta el índice del Array en displayParams para:',
  'LBL_DASHLET_CONFIGURE_GENERAL' => 'General',
  'LBL_DASHLET_CONFIGURE_FILTERS' => 'Filtros',
  'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'Sólo Mis Elementos',
  'LBL_DASHLET_CONFIGURE_TITLE' => 'Título',
  'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Mostrar Filas',
  'LBL_CREATING_NEW_PAGE' => 'Creando Nueva Página ...',
  'LBL_NEW_PAGE_FEEDBACK' => 'Ha creado una nueva página. Puede agregar nuevo contenido con la opción de menú Agregar Sugar Dashlets.',
  'LBL_DELETE_PAGE_CONFIRM' => '¿Está seguro de que desea eliminar esta página?',
  'LBL_SAVING_PAGE_TITLE' => 'Guardando Título de Página ...',
  'LBL_RETRIEVING_PAGE' => 'Recuperando Página ...',
  'LBL_MAX_DASHLETS_REACHED' => 'Ha alcanzado el máximo número de dashlets establecido por su administrador. Por favor, quite un Sugar Dashlet para poder agregar más.',
  'LBL_ADDING_DASHLET' => 'Agregando Sugar Dashlet ...',
  'LBL_ADDED_DASHLET' => 'Sugar Dashlet Agregado',
  'LBL_REMOVE_DASHLET_CONFIRM' => '¿Está seguro de que desea quitar el Sugar Dashlet?',
  'LBL_REMOVING_DASHLET' => 'Quitando Sugar Dashlet ...',
  'LBL_REMOVED_DASHLET' => 'Sugar Dashlet Quitado',
  'LBL_ADD_PAGE' => 'Agregar Página',
  'LBL_DELETE_PAGE' => 'Eliminar Página',
  'LBL_CHANGE_LAYOUT' => 'Cambiar Diseño',
  'LBL_RENAME_PAGE' => 'Renombrar Página',
  'LBL_LOADING_PAGE' => 'Cargando página, espere por favor...',
  'LBL_RELOAD_PAGE' => 'Por favor, <a href="javascript: window.location.reload()">recargue la ventana</a> para usar este Sugar Dashlet.',
  'LBL_ADD_DASHLETS' => 'Agregar Dashlets',
  'LBL_CLOSE_DASHLETS' => 'Cerrar',
  'LBL_OPTIONS' => 'Opciones',
  'LBL_NUMBER_OF_COLUMNS' => 'Seleccione el número de columnas',
  'LBL_1_COLUMN' => '1 Columna',
  'LBL_2_COLUMN' => '2 Columnas',
  'LBL_3_COLUMN' => '3 Columnas',
  'LBL_PAGE_NAME' => 'Nombre de página',
  'LBL_SEARCH_RESULTS' => 'Resultados de Búsqueda',
  'LBL_SEARCH_MODULES' => 'Módulos',
  'LBL_SEARCH_CHARTS' => 'Gráficos',
  'LBL_SEARCH_REPORT_CHARTS' => 'Gráficos de Informe',
  'LBL_SEARCH_TOOLS' => 'Herramientas',
  'LBL_SEARCH_HELP_TITLE' => 'Consejos de Búsqueda',
  'LBL_SEARCH_HELP_CLOSE_TOOLTIP' => 'Cerrar',
  'LBL_SEARCH_RESULTS_FOUND' => 'Resultados de la búsqueda',
  'LBL_SEARCH_RESULTS_TIME' => 'ms.',
  'ERR_BLANK_PAGE_NAME' => 'Por favor, introduzca un nombre de página.',
  'LBL_NO_IMAGE' => 'Sin Imagen',
  'LBL_MODULE' => 'Módulo',
  'LBL_COPY_ADDRESS_FROM_LEFT' => 'Copiar dirección de la izquierda:',
  'LBL_SAVE_AND_CONTINUE' => 'Guardar y Continuar',
  'LBL_SEARCH_HELP_TEXT' => 'Al utilizar el operador % como comodín puede hacer su búsqueda más amplio. Por ejemplo, el INSEAD de sólo la búsqueda de resultados que la igualdad de "Manzanas", que podría cambiar su búsqueda a "Manzanas%", que coinciden con los resultados que comienzan con la palabra, sino que las manzanas pueden contener otros personajes también.',
  'ERR_QUERY_LIMIT' => 'Error: Límite de $limit consultas alcanzado en el módulo $module.',
  'ERROR_NOTIFY_OVERRIDE' => 'Error: ResourceObserver->notify() necesita ser reemplazado.',
  'ERR_MONITOR_FILE_MISSING' => 'Error: No se puede crear monitor porque el archivo de metadatos está vacío o el archivo no existe.',
  'ERR_MONITOR_NOT_CONFIGURED' => 'Error: No hay monitor configurado para el nombre solicitado',
  'ERR_UNDEFINED_METRIC' => 'Error: No se puede establecer el valor de métrica definido',
  'ERR_STORE_FILE_MISSING' => 'Error: No se puede encontrar el archivo de la aplicación de la tienda',
  'LBL_MONITOR_ID' => 'Monitor de Id',
  'LBL_USER_ID' => 'ID Usuario',
  'LBL_MODULE_NAME' => 'Nombre de Módulo',
  'LBL_ITEM_ID' => 'Ítem Id',
  'LBL_ITEM_SUMMARY' => 'Ítem resumen',
  'LBL_ACTION' => 'Acción',
  'LBL_SESSION_ID' => 'Sesión Id',
  'LBL_BREADCRUMBSTACK_CREATED' => 'BreadCrumbStack creado por el usuario id {0}',
  'LBL_VISIBLE' => 'Dato visible',
  'LBL_DATE_LAST_ACTION' => 'Fecha de última acción',
  'MSG_IS_NOT_BEFORE' => 'no antes de',
  'MSG_IS_MORE_THAN' => 'es más que',
  'MSG_IS_LESS_THAN' => 'es menor que',
  'MSG_SHOULD_BE' => 'debe ser',
  'MSG_OR_GREATER' => 'o más',
  'LBL_PORTAL_WELCOME_TITLE' => 'Bienvenido a Sugar Portal 5.1.0',
  'LBL_PORTAL_WELCOME_INFO' => 'El Portal de Sugar es un marco que proporciona en tiempo real punto de vista de los casos, los errores y boletines de noticias a los clientes, etc. Se trata de una interfaz externa de Sugar que se puede implementar en cualquier sitio web. Manténgase atento a las características de servicio al cliente como el auto de Gestión de Proyectos y foros en nuestras futuras versiones.',
  'LBL_LIST' => 'Lista',
  'LBL_CREATE_BUG' => 'Crear incidencia',
  'LBL_NO_RECORDS_FOUND' => '- 0 Registros Encontrados -',
  'DATA_TYPE_DUE' => 'Vencimiento:',
  'DATA_TYPE_START' => 'Inicio:',
  'DATA_TYPE_SENT' => 'Enviado:',
  'DATA_TYPE_MODIFIED' => 'Modificado:',
  'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => 'Total',
  'LBL_OBJECT_IMAGE' => 'imagen objeto',
  'LBL_MASSUPDATE_DATE' => 'Seleccionar fecha',
  'LBL_VALIDATE_RANGE' => 'no está dentro del rango válido',
  'LBL_DROPDOWN_LIST_ALL' => 'Todos',
  'LBL_OPERATOR_IN_TEXT' => 'es uno de los siguientes:',
  'LBL_OPERATOR_NOT_IN_TEXT' => 'no es uno de los siguientes:',
  'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'Error: La cantidad del Array del parámetro bean no coincide con la cantidad del Array del resultado.',
  'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'Error: Falta el módulo de entrada de asignación.',
  'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'Error: No se puede recuperar datos de {0} conector. Actualmente, el servicio puede ser inaccesible o los ajustes de configuración pueden no ser válidas. Mensaje de error del conector: ({1}).',
  'LBL_MERGE_CONNECTORS' => 'Obtener datos',
  'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
  'LBL_REMOVE_MODULE_ENTRY' => '¿Está usted seguro de que quiere desactivar la integración del conector de este módulo?',
  'LBL_FASTCGI_LOGGING' => 'Para unos resultados óptimos al utilizar el sapi IIS/FastCGI, establezca fastcgi.logging a 0 en su archivo php.ini.',
  'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'El equipo Global no se pueden eliminar.',
  'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'Este equipo privado [{0}] no puede ser eliminado hasta que el usuario [{1}] se elimine.',
  'LBL_NO_FLASH_PLAYER' => 'Usted tiene Adobe Flash apagado o está utilizando una versión anterior del reproductor de Adobe Flash Player. Para obtener la última versión de Flash Player, <a href="http://www.adobe.com/go/getflashplayer/">clic aquí</a>.',
  'LBL_COLLECTION_NAME' => 'Nombre',
  'LBL_COLLECTION_PRIMARY' => 'Principal',
  'ERROR_MISSING_COLLECTION_SELECTION' => 'Campo vacío requerido',
  'LBL_COLLECTION_EXACT' => 'Exactamente',
  'LBL_ASSIGNED_TO_NAME' => 'Asignado a',
  'LBL_DESCRIPTION' => 'Descripción',
  'LBL_YESTERDAY' => 'Ayer',
  'LBL_TODAY' => 'hoy',
  'LBL_TOMORROW' => 'mañana',
  'LBL_NEXT_WEEK' => 'la semana que viene',
  'LBL_NEXT_MONDAY' => 'próximo lunes',
  'LBL_NEXT_FRIDAY' => 'próximo viernes',
  'LBL_TWO_WEEKS' => 'dos semanas',
  'LBL_NEXT_MONTH' => 'el mes que viene',
  'LBL_FIRST_DAY_OF_NEXT_MONTH' => 'primer día del próximo mes',
  'LBL_THREE_MONTHS' => 'tres meses',
  'LBL_SIXMONTHS' => 'seis meses',
  'LBL_NEXT_YEAR' => 'próximo año',
  'LBL_FILTERED' => 'Filtrado',
  'LBL_HOURS' => 'Horas',
  'LBL_MINUTES' => 'Minutos',
  'LBL_MERIDIEM' => 'Meridiem',
  'LBL_DATE' => 'Fecha',
  'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => 'Actualización automática',
  'LBL_DURATION_DAY' => 'día',
  'LBL_DURATION_HOUR' => 'hora',
  'LBL_DURATION_MINUTE' => 'minuto',
  'LBL_DURATION_DAYS' => 'días',
  'LBL_DURATION_HOURS' => 'horas',
  'LBL_DURATION_MINUTES' => 'minutos',
  'LBL_CHOOSE_MONTH' => 'Elegir mes',
  'LBL_ENTER_YEAR' => 'Poner año',
  'LBL_ENTER_VALID_YEAR' => 'Por favor, poner un año valido',
  'LBL_INVALID_USA_PHONE_FORMAT' => 'Por favor, introduce un número de teléfono de EE.UU., incluyendo código de área.',
  'ERR_FILE_WRITE' => 'Error: No se pudo escribir el archivo {0}. Por favor, revise el sistema y los permisos del servidor web.',
  'ERR_FILE_NOT_FOUND' => 'Error: No se puede cargar el archivo {0}. Por favor, compruebe los permisos del sistema y del servidor web.',
  'LBL_AND' => 'y',
  'LBL_BEFORE' => 'Antes de',
  'LBL_UPLOAD_FROM_COMPUTER' => 'Cargar de vuestro ordenador',
  'LBL_SEARCH_EXTERNAL_API' => 'Fichero en fuente externa',
  'LBL_EXTERNAL_SECURITY_LEVEL' => 'Seguridad',
  'LBL_SHARE_PRIVATE' => 'Privado',
  'LBL_SHARE_COMPANY' => 'Compañía',
  'LBL_SHARE_LINKABLE' => 'Enlazable',
  'LBL_SHARE_PUBLIC' => 'Público',
  'LBL_RSS_FEED' => 'RSS Feed',
  'LBL_RSS_RECORDS_FOUND' => 'registro(s) encontrado(s)',
  'ERR_RSS_INVALID_INPUT' => 'RSS no tiene una entrada valida',
  'ERR_RSS_INVALID_RESPONSE' => 'RSS no tiene una respuesta validad para este metodo',
  'ERR_GOOGLE_API_415' => 'Google Docs no soporta el formato del fichero.',
  'LBL_EMPTY' => 'Vacío',
  'LBL_IS_EMPTY' => 'Está Vacío',
  'LBL_IS_NOT_EMPTY' => 'No está Vacío',
  'LBL_IMPORT_SAMPLE_FILE_TEXT' => '"Este es un archivo de importación de muestra que es un ejemplo de los contenidos que se espera de un archivo que está listo para la importación." "El archivo es uno delimitado por comas .csv, usando comillas como el calificador de campo." "La fila de encabezado es la fila de arriba la mayoría en el archivo que contiene las etiquetas de campo como si fuera a ver en la aplicación." "Estas etiquetas se utilizan para el mapeo de los datos en el archivo de los campos de la aplicación." "Notas: Los nombres de base de datos también podrían ser utilizados en la cabecera. Esto es útil cuando usted está usando phpMyAdmin o cualquier otra herramienta de bases de datos para proporcionar una lista de exportación de datos a importar." "El orden de las columnas no es crítico, el proceso de importación coincide con los datos en los campos apropiados basados ​​en la fila de cabecera". "Para utilizar este archivo como plantilla, haga lo siguiente:" "1. Quitar las filas de la muestra de los datos" "2. Retire el texto de ayuda que usted está leyendo ahora mismo" "3. de entrada de sus propios datos en las filas correspondientes y columnas" " 4. Guarde el archivo en una ubicación conocida de su sistema " " 5. Haga clic en la opción Importar en el menú Acciones en la aplicación y elegir el archivo a subir "',
  'LBL_EXPORT_ASSIGNED_USER_ID' => 'Asignado a',
  'LBL_EXPORT_ASSIGNED_USER_NAME' => 'Usuario asignado',
  'LBL_EXPORT_REPORTS_TO_ID' => 'Informa a Id',
  'LBL_EXPORT_FULL_NAME' => 'Nombre Completo',
  'LBL_EXPORT_TEAM_ID' => 'ID de equipo',
  'LBL_EXPORT_TEAM_NAME' => 'Equipos',
  'LBL_EXPORT_TEAM_SET_ID' => 'ID Conjunto de equipo',
  'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'Navegando...',
  'LBL_PENDING_NOTIFICATIONS' => 'Notificaciones',
  'LBL_ALT_ADD_TEAM_ROW' => 'Añadir nuevo registro de equipo.',
  'LBL_ALT_REMOVE_TEAM_ROW' => 'Eliminar equipo',
  'LBL_ALT_SPOT_SEARCH' => 'Lugar de búsqueda',
  'LBL_ALT_SORT_DESC' => 'Ordenado descendente',
  'LBL_ALT_SORT_ASC' => 'Ordenado ascendente',
  'LBL_ALT_SORT' => 'Ordenar',
  'LBL_ALT_SHOW_OPTIONS' => 'Mostrar opciones',
  'LBL_ALT_HIDE_OPTIONS' => 'Ocultar opciones',
  'LBL_ALT_MOVE_COLUMN_LEFT' => 'Mover selección a la lista de la izquierda',
  'LBL_ALT_MOVE_COLUMN_RIGHT' => 'Mover selección a la lista de la derecha',
  'LBL_ALT_MOVE_COLUMN_UP' => 'Mover selección hacia arriba en el orden de la lista',
  'LBL_ALT_MOVE_COLUMN_DOWN' => 'Mover selección hacia abajo en el orden de la lista',
  'LBL_ALT_INFO' => 'Información',
  'MSG_DUPLICATE' => 'El registro {0} que está a punto de crear puede ser un duplicado de un registro {0} que ya existe. {1} registros que contienen nombres similares se enumeran a continuación.<br />Haga clic en Crear {1} para continuar la creación de este nuevo {0}, o seleccionar un archivo {0} se enumeran a continuación.',
  'MSG_SHOW_DUPLICATES' => 'El registro {0} que está a punto de crear puede ser un duplicado de un registro {0} que ya existe. {1} registros que contienen nombres similares se enumeran a continuación. Haga clic en Guardar para continuar con la creación de este nuevo {0}, o haga clic en Cancelar para volver al módulo sin necesidad de crear {0}.',
  'LBL_EMAIL_TITLE' => 'Email',
  'LBL_EMAIL_OPT_TITLE' => 'Email rehusado',
  'LBL_EMAIL_INV_TITLE' => 'email invalido',
  'LBL_EMAIL_PRIM_TITLE' => 'email principal',
  'LBL_SELECT_ALL_TITLE' => 'Seleccionar todo',
  'LBL_SELECT_THIS_ROW_TITLE' => 'Seleccionar esta fila',
  'LBL_TEAM_SELECTED_TITLE' => 'Equipo seleccionado',
  'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'Seleccione para hacer este equipo el principal',
  'UPLOAD_ERROR_TEXT' => 'ERROR: Hubo un error durante la subida. Código de error: {0} - {1}',
  'UPLOAD_ERROR_TEXT_SIZEINFO' => 'ERROR: Hubo un error durante la subida. Código de error: {0} - {1}. El upload_maxsize es {2}',
  'UPLOAD_ERROR_HOME_TEXT' => 'ERROR: Se ha producido un error durante la subida, por favor póngase en contacto con un administrador para obtener ayuda.',
  'UPLOAD_MAXIMUM_EXCEEDED' => 'El tamaño de la ({0} bytes) Superó el máximo permitido: {1} bytes',
  'LBL_EDIT_BUTTON_KEY' => 'E',
  'LBL_EDIT_BUTTON_LABEL' => 'Editar',
  'LBL_EDIT_BUTTON_TITLE' => 'Editar [Alt+E]',
  'LBL_DUPLICATE_BUTTON_KEY' => 'U',
  'LBL_DUPLICATE_BUTTON_LABEL' => 'Duplicar',
  'LBL_DUPLICATE_BUTTON_TITLE' => 'Duplicar [Alt+U]',
  'LBL_DELETE_BUTTON_KEY' => 'D',
  'LBL_DELETE_BUTTON_LABEL' => 'Eliminar',
  'LBL_DELETE_BUTTON_TITLE' => 'Eliminar [Alt+D]',
  'LBL_SAVE_BUTTON_KEY' => 'S',
  'LBL_SAVE_BUTTON_LABEL' => 'Guardar',
  'LBL_SAVE_BUTTON_TITLE' => 'Guardar [Alt+S]',
  'LBL_CANCEL_BUTTON_KEY' => 'X',
  'LBL_CANCEL_BUTTON_LABEL' => 'Cancelar',
  'LBL_CANCEL_BUTTON_TITLE' => 'Cancelar [Alt+X]',
  'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
  'LBL_ADV_SEARCH_LNK_KEY' => '8',
  'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
  'LBL_GLOBAL_SEARCH_LNK_KEY' => '',
  'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'Atajos de teclado',
  'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>Funcionalidad en formularios- Alt+</strong><br/> I = editar (detailview)<br/> U = duplicar (detailview)<br/> D = borrar (detailview)<br/> A = guardar (editview)<br/> L = cancelar (editview) <br/><br/></p><p><strong>Búsquedas y Navegación  - Alt+</strong><br/> 7 = Primer elemento en el formulario de edición<br/> 8 = Enlace de búsqueda avanzada<br/> 9 = Primer elemento en el formulario de búsqueda<br/> 0 = Elemento en búsqueda unificada<br></p>',
  'ERR_CONNECTOR_NOT_ARRAY' => 'conector serie en {0} ha definido incorrectamente o está vacío y no se podían usar.',
  'ERR_SUHOSIN' => 'El flujo de subida está bloqueado por Suhosin, añade un "upload" en suhosin.executor.include.whitelist (Ver sugarcrm.log para más información)',
  'LBL_CREATE_KB_DOCUMENT' => 'Crear artículo',
  'documentation' => 
  array (
    'COM' => '05_Sugar_Community_Edition',
    'CORP' => '03_Sugar_Corporate',
    'ENT' => '02_Sugar_Enterprise',
    'LBL_DOCS' => 'Documentación',
    'PRO' => '04_Sugar_Professional',
    'ULT' => '02_Sugar_Ultimate',
  ),
);

// DISYTEL: Additional Translations
$app_list_strings['product_category_dom']['Bugs'] = 'Incidencias';
$app_strings['LBL_EMAIL_ADDRESS_BOOK_TITLE_ICON'] = '<img src="themes/Suite7/images/icon_email_addressbook.gif?v=fqXdFZ_r6FC1K7P_Fy3mVw"     alt="Libreta de Direcciones" /> Libreta de Direcciones';
$app_strings['LBL_EMAIL_ADDRESS_BOOK_TITLE_ICON_SHORT'] = '<img src="themes/Suite7/images/icon_email_addressbook.gif?v=fqXdFZ_r6FC1K7P_Fy3mVw"  width="14" height="14" align=absmiddle border=0 alt="" />';
$app_strings['LBL_EMAIL_FOLDERS'] = '<img src="themes/Suite7/images/icon_email_folder.gif?v=fqXdFZ_r6FC1K7P_Fy3mVw"    align=absmiddle border=0 alt="" />Carpetas';
$app_strings['LBL_EMAIL_FOLDERS_SHORT'] = '<img src="themes/Suite7/images/icon_email_folder.gif?v=fqXdFZ_r6FC1K7P_Fy3mVw"    align=absmiddle border=0 alt="" />';
$app_strings['LBL_EMAIL_SEARCH'] = '<img src="themes/Suite7/images/Search.gif?v=fqXdFZ_r6FC1K7P_Fy3mVw"    align=absmiddle border=0 alt="" />';
$app_strings['LBL_EMAIL_SEARCH_SHORT'] = '<img src="themes/Suite7/images/Search.gif?v=fqXdFZ_r6FC1K7P_Fy3mVw"    align=absmiddle border=0 alt="" />';
$app_strings['ERR_EXTERNAL_API_NO_OAUTH_TOKEN'] = 'No se encuentra el Token de Acceso OAuth.';
$app_strings['LBL_EMPTY_REQUIRED_VCARD'] = 'La vCard no tiene todos los campos requeridos para este módulo. Por favor consulte sugarcrm.log para más detalles.';
$app_strings['LBL_VCARD_ERROR_FILESIZE'] = 'El archivo subido excede el límite de tamaño, el cual se especificó en el formulario HTML.';
$app_strings['LBL_VCARD_ERROR_DEFAULT'] = 'Hubo un error subiendo el archivo vCard. Por favor consulte sugarcrm.log para más detalles.';
$app_strings['ERROR_LICENSE_FULLY_EXPIRED'] = 'La Suscripción de su Companía al Producto SugarCRM ha expirado y necesita ser renovada. Sólo los administradores pueden ingresar cuando expiró una Suscripción. Si tiene alguna inquietud, por favor contacte con su administrador.';
$app_strings['WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING'] = '<b>Advertencia:</b> Su navegador está en modo compatibilidad IE el cual no es soportado.';
$app_strings['MSG_JS_ALERT_MTG_REMINDER_STATUS'] = 'Estado: ';
$app_strings['MSG_JS_ALERT_MTG_REMINDER_RELATED_TO'] = 'Relacionado A: ';
$app_strings['LBL_CHOOSE_START_AND_END_DATES'] = 'Por favor seleccione un rango de fecha inicial y un rango de fecha final';
$app_strings['LBL_CHOOSE_START_AND_END_ENTRIES'] = 'Por favor seleccione un rango de entrada de inicio y de finalización';
$app_strings['UPLOAD_REQUEST_ERROR'] = 'Ocurrió un error. Por favor actualice su página y vuelva a intentarlo.';
$app_strings['ERR_BAD_RESPONSE_FROM_SERVER'] = 'Respuesta incorrecta del servidor';
