<?php

// custom/modules/Cases/CasesJjwg_MapsLogicHook.php

if (!defined('sugarEntry') || !sugarEntry)
    die('Not A Valid Entry Point');

class CasesJjwg_MapsLogicHook {

    function updateGeocodeInfo(&$bean, $event, $arguments) {
        // before_save
        $jjwg_Maps = get_module_info('jjwg_Maps');
        if ($jjwg_Maps->settings['logic_hooks_enabled']) {
            $jjwg_Maps->updateGeocodeInfo($bean);
        }
        switch ($bean->estado_servicio_c) {
            case '3':
                $bean->task_descripcion_c = 'Nuevo servicio '. $bean->case_number.' ASIGNADO. Actualizar.';
                break;
            case '5':
                $bean->task_descripcion_c = 'Servicio '. $bean->case_number . ' DIAGNOSTICADO. Revisar y dar seguimiento.';
                break;
            case '7':
                $bean->task_descripcion_c = 'Servicio '. $bean->case_number . ' NO AUTORIZADO. Regresar a administración.';
                break;
            case '8':
                $bean->task_descripcion_c = 'Servicio '. $bean->case_number . ' AUTORIZADO. Poceder a reparar.';
                break;
            case '11':
                $bean->task_descripcion_c = 'Servicio '. $bean->case_number . ' REPARADO. Solicitarlo a taller.';
                break;
            case '12':
                $bean->task_descripcion_c = 'Servicio '. $bean->case_number . ' entregado a administración.';
                break;
            default:
                $bean->task_descripcion_c = '';
                break;
        }

        $cliente = new Account();
        $cliente->retrieve($bean->account_id);

        $Numeros = '';
        if(!empty($cliente->num_exterior_c)){
            $Numeros = 'No.' . $cliente->num_exterior_c . ' ';
        }   
        if(!empty($cliente->num_interior_c)){
            $Numeros = $Numeros . 'Int.' . $cliente->num_interior_c . ' ';
        }
        $bean->direccion_cliente_c = $cliente->callenumero_c . ' ' . $Numeros . ' ' . $cliente->colonia_c . ' ' . $cliente->ciudad_c . ' ' . $cliente->estado_c . ' ' . $cliente->pais_c . ' C.P.' . $cliente->cp_c;
        //write_to_log('',$bean);
        $bean->telefono_cliente_c = $cliente->celular_c;

        global $app_list_strings;
        $Equipo = $app_list_strings['producto_list'][$bean->producto_c];
        //write_to_log($Equipo);
        $pos1 = strpos($Equipo, '(');
        $pos2 = strpos($Equipo, ')');
        if($pos1>1 && $pos2>$pos1){
            $pos1++;
            $clave = substr($Equipo,$pos1,$pos2-$pos1);
            $Equipo =  substr($Equipo,0,$pos1-2);
            $bean->clave_para_hoja_c = $clave;
        }
        $bean->equipo_para_hoja_c = $Equipo;
    }
    
    function updateRelatedMeetingsGeocodeInfo(&$bean, $event, $arguments) {
        // after_save
        $jjwg_Maps = get_module_info('jjwg_Maps');
        if ($jjwg_Maps->settings['logic_hooks_enabled']) {
            $jjwg_Maps->updateRelatedMeetingsGeocodeInfo($bean);
        }
    }

    function addRelationship(&$bean, $event, $arguments) {
        // after_relationship_add
        $GLOBALS['log']->info(__METHOD__.' $arguments: '.print_r($arguments, true));
        // $arguments['module'], $arguments['related_module'], $arguments['id'] and $arguments['related_id'] 
        $jjwg_Maps = get_module_info('jjwg_Maps');
        if ($jjwg_Maps->settings['logic_hooks_enabled']) {
            $focus = get_module_info($arguments['module']);
            if (!empty($arguments['id'])) {
                $focus->retrieve($arguments['id']);
                $focus->custom_fields->retrieve();
                $jjwg_Maps->updateGeocodeInfo($focus, true);
                if ($focus->jjwg_maps_address_c != $focus->fetched_row['jjwg_maps_address_c']) {
                    $focus->save(false);
                }
            }
        }
    }
    
    function deleteRelationship(&$bean, $event, $arguments) {
        // after_relationship_delete
        $GLOBALS['log']->info(__METHOD__.' $arguments: '.print_r($arguments, true));
        // $arguments['module'], $arguments['related_module'], $arguments['id'] and $arguments['related_id'] 
        $jjwg_Maps = get_module_info('jjwg_Maps');
        if ($jjwg_Maps->settings['logic_hooks_enabled']) {
            $focus = get_module_info($arguments['module']);
            if (!empty($arguments['id'])) {
                $focus->retrieve($arguments['id']);
                $focus->custom_fields->retrieve();
                $jjwg_Maps->updateGeocodeInfo($focus, true);
                if ($focus->jjwg_maps_address_c != $focus->fetched_row['jjwg_maps_address_c']) {
                    $focus->save(false);
                }
            }
        }
    }
    
}
