<?php
 
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

class ReportChartDashletApi extends SugarApi {
	
    public function registerApiRest() {
        return array(
            'GetReportDataEndpoint' => array(
                'reqType' => 'GET',
                'path' => array('asol', 'GetReportData'),
                'pathVars' => array(''),
                'method' => 'GetReportData',
                'shortHelp' => '',
                'longHelp' => '',
            ),
        );
    }

    /**
     * Method to be used for my MyEndpoint/GetExample endpoint
     */
    public function GetReportData($api, $args) {
    	
    	global $current_user, $db;
    	
    	require_once('modules/asol_Reports/include_basic/generateReport.php');
    	require_once('modules/asol_Reports/include_basic/generateReportsFunctions.php');
    	require_once('modules/asol_Reports/include_basic/reportsUtils.php');
			
    	$displayReportDashlet = true;
    	$reportId = $args['reportId'];
    	$isMetaReport = (asol_Report::getReportBean($reportId)->is_meta === '1');
    	$dashletId = create_guid();
    	$fixedDashletId = str_replace("-", "", $dashletId);
    	
    	//**************************//
		//***Is Domains Installed***//
		//**************************//
		if (asol_ReportsUtils::isDomainsInstalled()) {
			
			$reportDomainQuery = $db->query("SELECT asol_reports.asol_domain_id as domain_id, asol_domains.name as domain_name FROM asol_reports LEFT JOIN asol_domains ON asol_reports.asol_domain_id=asol_domains.id WHERE asol_reports.id='".$reportId."'");
			$reportDomainRow = $db->fetchByAssoc($reportDomainQuery);
			$displayReportDashlet = ((empty($reportId)) || (asol_ReportsGenerationFunctions::manageReportDomain($reportId, $current_user->asol_default_domain, $reportDomainRow['domain_id'])));
				
		}
		//**************************//
		//***Is Domains Installed***//
		//**************************//
		
		if ($displayReportDashlet) {
			
			if (!empty($reportId)) {

				$getLibraries = ($_REQUEST['getLibraries'] === 'true' ? true : false);

				$reportHtml = ($getLibraries ? asol_ReportsGenerationFunctions::generateDashletLibraries($reportId, $isMetaReport) : '').	
				'<script>'.asol_ReportsGenerationFunctions::getReloadCurrentDashletScriptFunction($reportId, true, $dashletId, '', false, null, null, $current_user->id, false, false).'</script>'.
				'<div id="externalHtmlReport'.$dashletId.'" class="table table-striped dataTable">
					<img id="loadingGIF'.$dashletId.'" src="themes/default/images/img_loading.gif"><span id="loadingTEXT'.$dashletId.'">'.translate("LBL_REPORT_LOADING", "asol_Reports").'</span>
					'.displayReport($reportId, null, '', '', '', '', true, $dashletId, false, false, true, false, null, null, true, null).'
				</div>';
				
			} else {
				
				$reportHtml = '<div align="center">No Report Selected</div>';
				
			}
			
		} else {
			
			$reportHtml = '<div align="center"></div>';
			
		}
		
		$reportHtml = str_replace(chr(9), "", str_replace(chr(13), "", str_replace(chr(10), "", $reportHtml)));
		
    	return json_decode(json_encode(array('dashletId' => $dashletId, 'html' => $reportHtml)));
		
    }

}

?>
