<?php 
 $GLOBALS["dictionary"]["Sequences"]=array (
  'table' => 'sequences',
  'audited' => true,
  'comment' => 'Sequences Module',
  'duplicate_merge' => true,
  'unified_search' => true,
  'optimistic_locking' => true,
  'engine' => 'innodb',
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'required' => true,
      'importable' => 'required',
      'duplicate_merge' => 'enabled',
      'merge_filter' => 'selected',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'sequences_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'sequences_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'sequences_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'draw' => 
    array (
      'type' => 'varchar',
      'name' => 'draw',
      'vname' => 'LBL_DRAW',
      'popupHelp' => 'LBL_DRAW_HINT',
      'len' => '255',
      'source' => 'non-db',
    ),
    'initial_sequencing' => 
    array (
      'type' => 'custom',
      'name' => 'initial_sequencing',
      'vname' => 'LBL_INITIAL_SEQUENCING',
      'source' => 'non-db',
    ),
    'code_prefix' => 
    array (
      'type' => 'varchar',
      'name' => 'code_prefix',
      'vname' => 'LBL_CODE_PREFIX',
      'audited' => true,
      'required' => false,
    ),
    'code_suffix' => 
    array (
      'name' => 'code_suffix',
      'vname' => 'LBL_CODE_SUFFIX',
      'type' => 'varchar',
      'audited' => true,
      'required' => false,
    ),
    'code_seperator' => 
    array (
      'type' => 'char',
      'len' => '1',
      'name' => 'code_seperator',
      'vname' => 'LBL_CODE_SEPERATOR',
      'audited' => true,
      'required' => false,
    ),
    'code_field' => 
    array (
      'type' => 'varchar',
      'name' => 'code_field',
      'vname' => 'LBL_CODE_FIELD',
      'audited' => true,
      'required' => true,
      'function' => 
      array (
        'name' => 'getFieldDropDown',
        'returns' => 'html',
        'include' => 'modules/Sequences/functions.php',
      ),
    ),
    'sequence_add_date' => 
    array (
      'type' => 'bool',
      'name' => 'sequence_add_date',
      'vname' => 'LBL_ADD_DATE',
      'audited' => true,
      'required' => false,
      'massupdate' => false,
    ),
    'sequence_readonly' => 
    array (
      'type' => 'bool',
      'name' => 'sequence_readonly',
      'vname' => 'LBL_READONLY',
      'audited' => true,
      'required' => false,
      'massupdate' => false,
    ),
    'sequence_date_format' => 
    array (
      'type' => 'enum',
      'name' => 'sequence_date_format',
      'vname' => 'LBL_DATE_FORMAT',
      'audited' => true,
      'required' => false,
      'massupdate' => false,
      'options' => 'sequences_date_formates_dom',
    ),
    'zero_padding' => 
    array (
      'type' => 'int',
      'name' => 'zero_padding',
      'vname' => 'LBL_ZERO_PADDING',
      'audited' => true,
      'massupdate' => false,
      'required' => false,
    ),
    'type' => 
    array (
      'type' => 'enum',
      'name' => 'type',
      'vname' => 'LBL_TYPE',
      'audited' => true,
      'required' => true,
      'massupdate' => false,
      'dbType' => 'int',
      'options' => 'sequences_types_dom',
    ),
    'first_num' => 
    array (
      'type' => 'int',
      'name' => 'first_num',
      'vname' => 'LBL_FIRST_NUM',
      'audited' => true,
      'massupdate' => false,
      'required' => false,
      'disable_num_format' => true,
    ),
    'next_num' => 
    array (
      'type' => 'int',
      'name' => 'next_num',
      'vname' => 'LBL_NEXT_NUM',
      'audited' => true,
      'massupdate' => false,
      'required' => false,
      'disable_num_format' => true,
    ),
    'parent_type' => 
    array (
      'name' => 'parent_type',
      'type' => 'custom',
      'dbType' => 'varchar',
      'vname' => 'LBL_PARENT_TYPE',
      'required' => true,
      'massupdate' => false,
      'function' => 
      array (
        'name' => 'getParentDropDown',
        'returns' => 'html',
        'include' => 'modules/Sequences/functions.php',
      ),
    ),
    'parent_id' => 
    array (
      'name' => 'parent_id',
      'vname' => 'LBL_PARENT_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => false,
      'massupdate' => false,
      'source' => 'non-db',
    ),
    'parent_name' => 
    array (
      'name' => 'parent_name',
      'parent_type' => 'record_type_display',
      'type_name' => 'parent_type',
      'id_name' => 'parent_id',
      'vname' => 'LBL_PARENT_NAME',
      'type' => 'parent',
      'group' => 'parent_name',
      'source' => 'non-db',
      'required' => true,
      'massupdate' => false,
      'options' => 'record_type_display_notes',
    ),
    'sequence_ordering' => 
    array (
      'name' => 'sequence_ordering',
      'vname' => 'LBL_SEQUENCE_ORDERING',
      'type' => 'custom',
      'dbType' => 'varchar',
      'required' => false,
      'massupdate' => false,
      'studio' => false,
    ),
  ),
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'sequencespk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
    0 => 
    array (
      'name' => 'idx1',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'assigned_user_id',
      ),
    ),
    1 => 
    array (
      'name' => 'idx2',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'modified_user_id',
      ),
    ),
    2 => 
    array (
      'name' => 'idx3',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'created_by',
      ),
    ),
  ),
  'relationships' => 
  array (
    'sequences_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Sequences',
      'rhs_table' => 'sequences',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'sequences_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Sequences',
      'rhs_table' => 'sequences',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'sequences_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Sequences',
      'rhs_table' => 'sequences',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'templates' => 
  array (
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => false,
);