<?php 
 $GLOBALS["dictionary"]["Pagos_Pagos_de_Clientes"]=array (
  'table' => 'pagos_pagos_de_clientes',
  'audited' => true,
  'duplicate_merge' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'vname' => 'LBL_NAME',
      'comment' => 'Name of the Sale',
      'unified_search' => false,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'audited' => true,
      'merge_filter' => 'disabled',
      'required' => true,
      'importable' => 'required',
      'comments' => 'Folio',
      'help' => 'Tecle el nombre del pago Ej.: 12316-3    o    12316 Enganche 2',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Description of the sale',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'pagos_pagos_de_clientes_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'pagos_pagos_de_clientes_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'pagos_pagos_de_clientes_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'pagos_pagos_de_clientes_type' => 
    array (
      'name' => 'pagos_pagos_de_clientes_type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'options' => 'pagos_pagos_de_clientes_type_dom',
      'len' => 100,
      'comment' => 'The Sale is of this type',
    ),
    'lead_source' => 
    array (
      'name' => 'lead_source',
      'vname' => 'LBL_LEAD_SOURCE',
      'type' => 'enum',
      'options' => 'lead_source_dom',
      'len' => '50',
      'comment' => 'Source of the sale',
    ),
    'amount' => 
    array (
      'name' => 'amount',
      'vname' => 'LBL_AMOUNT',
      'type' => 'currency',
      'dbType' => 'double',
      'comment' => 'Unconverted amount of the sale',
      'duplicate_merge' => 'disabled',
      'required' => true,
    ),
    'amount_usdollar' => 
    array (
      'name' => 'amount_usdollar',
      'vname' => 'LBL_AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'amount',
      'dbType' => 'double',
      'disable_num_format' => true,
      'audited' => true,
      'comment' => 'Formatted amount of the sale',
    ),
    'currency_id' => 
    array (
      'name' => 'currency_id',
      'type' => 'id',
      'group' => 'currency_id',
      'vname' => 'LBL_CURRENCY',
      'function' => 
      array (
        'name' => 'getCurrencyDropDown',
        'returns' => 'html',
      ),
      'reportable' => false,
      'comment' => 'Currency used for display purposes',
    ),
    'currency_name' => 
    array (
      'name' => 'currency_name',
      'rname' => 'name',
      'id_name' => 'currency_id',
      'vname' => 'LBL_CURRENCY_NAME',
      'type' => 'relate',
      'isnull' => 'true',
      'table' => 'currencies',
      'module' => 'Currencies',
      'source' => 'non-db',
      'function' => 
      array (
        'name' => 'getCurrencyNameDropDown',
        'returns' => 'html',
      ),
      'studio' => 'false',
    ),
    'currency_symbol' => 
    array (
      'name' => 'currency_symbol',
      'rname' => 'symbol',
      'id_name' => 'currency_id',
      'vname' => 'LBL_CURRENCY_SYMBOL',
      'type' => 'relate',
      'isnull' => 'true',
      'table' => 'currencies',
      'module' => 'Currencies',
      'source' => 'non-db',
      'function' => 
      array (
        'name' => 'getCurrencySymbolDropDown',
        'returns' => 'html',
      ),
    ),
    'date_closed' => 
    array (
      'name' => 'date_closed',
      'vname' => 'LBL_DATE_CLOSED',
      'type' => 'date',
      'audited' => true,
      'required' => true,
      'comment' => 'Expected or actual date the sale will close',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'comments' => 'Fecha de Creacion',
      'merge_filter' => 'disabled',
      'help' => 'Seleccione en el calendario la fecha en que se genero la orden de compra ',
    ),
    'next_step' => 
    array (
      'name' => 'next_step',
      'vname' => 'LBL_NEXT_STEP',
      'type' => 'varchar',
      'len' => '100',
      'comment' => 'The next step in the sales process',
    ),
    'sales_stage' => 
    array (
      'name' => 'sales_stage',
      'vname' => 'LBL_SALES_STAGE',
      'type' => 'enum',
      'options' => 'sales_stage_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'Indication of progression towards closure',
      'required' => true,
      'importable' => 'required',
    ),
    'probability' => 
    array (
      'name' => 'probability',
      'vname' => 'LBL_PROBABILITY',
      'type' => 'int',
      'dbType' => 'double',
      'audited' => true,
      'comment' => 'The probability of closure',
      'validation' => 
      array (
        'type' => 'range',
        'min' => 0,
        'max' => 100,
      ),
    ),
    'vencimiento_c' => 
    array (
      'options' => 'date_range_search_dom',
      'labelValue' => 'Vencimiento',
      'enable_range_search' => '1',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'vencimiento_c',
      'vname' => 'LBL_VENCIMIENTO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccione en el calendario la fecha en que se tiene que liquidar este pago',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesvencimiento_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'se_paga_com__c' => 
    array (
      'labelValue' => 'SE PAGA COM AG',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'se_paga_com__c',
      'vname' => 'LBL_SE_PAGA_COM_',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'se_paga_com_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Pagos_Pagos_de_Clientesse_paga_com__c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'poliza_ingreso_no__c' => 
    array (
      'labelValue' => 'Poliza Ingreso #',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'poliza_ingreso_no__c',
      'vname' => 'LBL_POLIZA_INGRESO_NO_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientespoliza_ingreso_no__c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'reg_en_decaspel__c' => 
    array (
      'labelValue' => 'Registrado en Decaspel',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'reg_en_decaspel__c',
      'vname' => 'LBL_REG_EN_DECASPEL_',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => 'NO',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'reg_en_decaspel_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Pagos_Pagos_de_Clientesreg_en_decaspel__c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'users_pagos_pagos_de_clientes_1' => 
    array (
      'name' => 'users_pagos_pagos_de_clientes_1',
      'type' => 'link',
      'relationship' => 'users_pagos_pagos_de_clientes_1',
      'source' => 'non-db',
      'module' => 'Users',
      'bean_name' => 'User',
      'vname' => 'LBL_USERS_PAGOS_PAGOS_DE_CLIENTES_1_FROM_USERS_TITLE',
      'id_name' => 'users_pagos_pagos_de_clientes_1users_ida',
    ),
    'users_pagos_pagos_de_clientes_1_name' => 
    array (
      'name' => 'users_pagos_pagos_de_clientes_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_USERS_PAGOS_PAGOS_DE_CLIENTES_1_FROM_USERS_TITLE',
      'save' => true,
      'id_name' => 'users_pagos_pagos_de_clientes_1users_ida',
      'link' => 'users_pagos_pagos_de_clientes_1',
      'table' => 'users',
      'module' => 'Users',
      'rname' => 'name',
    ),
    'users_pagos_pagos_de_clientes_1users_ida' => 
    array (
      'name' => 'users_pagos_pagos_de_clientes_1users_ida',
      'type' => 'link',
      'relationship' => 'users_pagos_pagos_de_clientes_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_USERS_PAGOS_PAGOS_DE_CLIENTES_1_FROM_PAGOS_PAGOS_DE_CLIENTES_TITLE',
    ),
    'comisiones_c' => 
    array (
      'labelValue' => 'Comisión Pagada al Vendedor',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'comisiones_c',
      'vname' => 'LBL_COMISIONES',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'Pagos_Pagos_de_Clientescomisiones_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'porcentage_de_comicion_c' => 
    array (
      'labelValue' => 'Porcentaje de Comision',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'porcentage_de_comicion_c',
      'vname' => 'LBL_PORCENTAGE_DE_COMICION ',
      'type' => 'dynamicenum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'promocion_porcent_pago_1_TC_list',
      'studio' => 'visible',
      'dbType' => 'enum',
      'parentenum' => 'Promocion_Pago_TC_list',
      'id' => 'Pagos_Pagos_de_Clientesporcentage_de_comicion_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'obcervaciones_del_pago_c' => 
    array (
      'labelValue' => 'obcervaciones del pago',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'obcervaciones_del_pago_c',
      'vname' => 'LBL_OBCERVACIONES_DEL_PAGO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'Tecle lo relevante del pago , anticipos  integrados , etc.',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesobcervaciones_del_pago_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'complemento_pago__c' => 
    array (
      'labelValue' => 'Complemento de Pago',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'complemento_pago__c',
      'vname' => 'LBL_COMPLEMENTO_PAGO_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'Digite el folio del complemento de pago',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientescomplemento_pago__c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'cuentas_banco_c' => 
    array (
      'labelValue' => 'Depositado en la Cuenta ',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cuentas_banco_c',
      'vname' => 'LBL_CUENTAS_BANCO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Cuentas_banco_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Pagos_Pagos_de_Clientescuentas_banco_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'banco_bancos_pagos_pagos_de_clientes' => 
    array (
      'name' => 'banco_bancos_pagos_pagos_de_clientes',
      'type' => 'link',
      'relationship' => 'banco_bancos_pagos_pagos_de_clientes',
      'source' => 'non-db',
      'module' => 'Banco_Bancos',
      'bean_name' => false,
      'vname' => 'LBL_BANCO_BANCOS_PAGOS_PAGOS_DE_CLIENTES_FROM_BANCO_BANCOS_TITLE',
      'id_name' => 'banco_bancos_pagos_pagos_de_clientesbanco_bancos_ida',
    ),
    'banco_bancos_pagos_pagos_de_clientes_name' => 
    array (
      'name' => 'banco_bancos_pagos_pagos_de_clientes_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_BANCO_BANCOS_PAGOS_PAGOS_DE_CLIENTES_FROM_BANCO_BANCOS_TITLE',
      'save' => true,
      'id_name' => 'banco_bancos_pagos_pagos_de_clientesbanco_bancos_ida',
      'link' => 'banco_bancos_pagos_pagos_de_clientes',
      'table' => 'banco_bancos',
      'module' => 'Banco_Bancos',
      'rname' => 'name',
    ),
    'banco_bancos_pagos_pagos_de_clientesbanco_bancos_ida' => 
    array (
      'name' => 'banco_bancos_pagos_pagos_de_clientesbanco_bancos_ida',
      'type' => 'link',
      'relationship' => 'banco_bancos_pagos_pagos_de_clientes',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'left',
      'vname' => 'LBL_BANCO_BANCOS_PAGOS_PAGOS_DE_CLIENTES_FROM_BANCO_BANCOS_TITLE',
    ),
    'folio_anticipo_c' => 
    array (
      'labelValue' => 'folio anticipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'folio_anticipo_c',
      'vname' => 'LBL_FOLIO_ANTICIPO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesfolio_anticipo_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'facturar_en_c' => 
    array (
      'labelValue' => 'si requ fact facturar en',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'facturar_en_c',
      'vname' => 'LBL_FACTURAR_EN',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => 'SAIT',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'facturar_en_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Pagos_Pagos_de_Clientesfacturar_en_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'fecha_del_pago_c' => 
    array (
      'options' => 'date_range_search_dom',
      'labelValue' => 'Fecha Pago',
      'enable_range_search' => '1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_del_pago_c',
      'vname' => 'LBL_FECHA_DEL_PAGO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccione en el Calendario la fecha en la que nosotros recibimos el soporte del pago: FICHA DE DEPOCITO (CUANDO AVISA EL CLIENTE )',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesfecha_del_pago_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'retorno_mov_c' => 
    array (
      'labelValue' => 'retorno mov',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'retorno_mov_c',
      'vname' => 'LBL_RETORNO_MOV',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'En que movimiento se retorno el $ a ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesretorno_mov_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'rf_c' => 
    array (
      'labelValue' => '¿Facturar?',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'rf_c',
      'vname' => 'LBL_RF',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'si_no_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Pagos_Pagos_de_Clientesrf_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'factura_coi_c' => 
    array (
      'labelValue' => 'Fac. SAE',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'factura_coi_c',
      'vname' => 'LBL_FACTURA_COI',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => 'NO APLICA',
      'no_default' => false,
      'comments' => '',
      'help' => 'Tecle el Numero de Factura SAE que le cooresponde a este pago',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '30',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesfactura_coi_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'uso_cfdi__c' => 
    array (
      'labelValue' => 'Uso de CFDI',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'uso_cfdi__c',
      'vname' => 'LBL_USO_CFDI_',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'uso_de_CFDI_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Pagos_Pagos_de_Clientesuso_cfdi__c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'agend_cob__c' => 
    array (
      'labelValue' => 'Agendado a Cobranza',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'agend_cob__c',
      'vname' => 'LBL_AGEND_COB_',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => 'NO',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Agendado_cobranza_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Pagos_Pagos_de_Clientesagend_cob__c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'saldo_c' => 
    array (
      'labelValue' => 'Saldo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'saldo_c',
      'vname' => 'LBL_SALDO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'Esta es la cantidad que queda a deber el cliente : Restar  campo POR PAGAR - IMPORTE PAGADO',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'Pagos_Pagos_de_Clientessaldo_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'folio_c' => 
    array (
      'labelValue' => 'Folio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'folio_c',
      'vname' => NULL,
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Folio',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesfolio_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'es_reg_de_cobranza_c' => 
    array (
      'labelValue' => 'Reg de ',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'es_reg_de_cobranza_c',
      'vname' => 'LBL_ES_REG_DE_COBRANZA',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'es_reg_de_cobranzA_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Pagos_Pagos_de_Clienteses_reg_de_cobranza_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'pasar_c' => 
    array (
      'labelValue' => 'Como pagara el cliente',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pasar_c',
      'vname' => 'LBL_PASAR',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'Seleccione',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'pasar_0',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Pagos_Pagos_de_Clientespasar_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'codigo_desbloqueo_c' => 
    array (
      'labelValue' => 'CODIGO DESBLOQUEO',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'codigo_desbloqueo_c',
      'vname' => 'LBL_CODIGO_DESBLOQUEO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '50',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientescodigo_desbloqueo_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'registro_en_bitacora_c' => 
    array (
      'labelValue' => 'Registro en Bitacora de Cobranza',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'registro_en_bitacora_c',
      'vname' => 'LBL_REGISTRO_EN_BITACORA',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesregistro_en_bitacora_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'accounts_pagos_pagos_de_clientes_1' => 
    array (
      'name' => 'accounts_pagos_pagos_de_clientes_1',
      'type' => 'link',
      'relationship' => 'accounts_pagos_pagos_de_clientes_1',
      'source' => 'non-db',
      'module' => 'Accounts',
      'bean_name' => 'Account',
      'vname' => 'LBL_ACCOUNTS_PAGOS_PAGOS_DE_CLIENTES_1_FROM_ACCOUNTS_TITLE',
      'id_name' => 'accounts_pagos_pagos_de_clientes_1accounts_ida',
    ),
    'accounts_pagos_pagos_de_clientes_1_name' => 
    array (
      'name' => 'accounts_pagos_pagos_de_clientes_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_ACCOUNTS_PAGOS_PAGOS_DE_CLIENTES_1_FROM_ACCOUNTS_TITLE',
      'save' => true,
      'id_name' => 'accounts_pagos_pagos_de_clientes_1accounts_ida',
      'link' => 'accounts_pagos_pagos_de_clientes_1',
      'table' => 'accounts',
      'module' => 'Accounts',
      'rname' => 'name',
    ),
    'accounts_pagos_pagos_de_clientes_1accounts_ida' => 
    array (
      'name' => 'accounts_pagos_pagos_de_clientes_1accounts_ida',
      'type' => 'link',
      'relationship' => 'accounts_pagos_pagos_de_clientes_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_ACCOUNTS_PAGOS_PAGOS_DE_CLIENTES_1_FROM_PAGOS_PAGOS_DE_CLIENTES_TITLE',
    ),
    'ef_depocitado_c' => 
    array (
      'labelValue' => '(no usar) Ef Depocitado ',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ef_depocitado_c',
      'vname' => 'LBL_EF_DEPOCITADO',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'indique si se depocito el efectivo de este pago',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'se_paga_com_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Pagos_Pagos_de_Clientesef_depocitado_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'comision_bancaria_c' => 
    array (
      'labelValue' => 'Comision Bancaria',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'comision_bancaria_c',
      'vname' => 'LBL_COMISION_BANCARIA',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Tecle El monto De la comision  que cobro el banco por hacer este pago',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'Pagos_Pagos_de_Clientescomision_bancaria_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'ft_orden_p__c' => 
    array (
      'labelValue' => 'FT orden ',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ft_orden_p__c',
      'vname' => 'LBL_FT_ORDEN_P_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesft_orden_p__c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'autorisacion_del_banco_c' => 
    array (
      'labelValue' => 'Autorización del Banco',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'autorisacion_del_banco_c',
      'vname' => 'LBL_AUTORISACION_DEL_BANCO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Capture el numero de autorizacion del banco que aparece en el Voucher',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesautorisacion_del_banco_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'promocion_pago_tc_c' => 
    array (
      'labelValue' => 'promocion pago TC',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'promocion_pago_tc_c',
      'vname' => 'LBL_PROMOCION_PAGO_TC',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccione como fue el  pago si a: TC debito, TC directo,3,6,9,12',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Promocion_Pago_TC_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Pagos_Pagos_de_Clientespromocion_pago_tc_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'tipo_factura_c' => 
    array (
      'labelValue' => 'Tipo Factura (PAGO)',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tipo_factura_c',
      'vname' => 'LBL_TIPO_FACTURA',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'tipo_factura_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Pagos_Pagos_de_Clientestipo_factura_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'importe_c' => 
    array (
      'options' => 'numeric_range_search_dom',
      'labelValue' => 'Por Pagar',
      'enable_range_search' => '1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_c',
      'vname' => 'LBL_IMPORTE',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'Tecle la cantidad que debera pagar el cliente',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'precision' => 6,
      'id' => 'Pagos_Pagos_de_Clientesimporte_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'ef_dep_en_cuenta__c' => 
    array (
      'labelValue' => 'EF DEPOCITADO EN CUENTA',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ef_dep_en_cuenta__c',
      'vname' => 'LBL_EF_DEP_EN_CUENTA_',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Cuentas_banco_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Pagos_Pagos_de_Clientesef_dep_en_cuenta__c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'forma_de_pago_c' => 
    array (
      'labelValue' => 'Forma de Pago',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'forma_de_pago_c',
      'vname' => 'LBL_FORMA_DE_PAGO',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => 'Seleccione',
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccione como pago el cliente ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'forma_de_pago_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Pagos_Pagos_de_Clientesforma_de_pago_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'importe_pagado_c' => 
    array (
      'options' => 'numeric_range_search_dom',
      'labelValue' => 'Importe Pagado',
      'enable_range_search' => '1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_pagado_c',
      'vname' => 'LBL_IMPORTE_PAGADO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'Capture la cantidad pagada por el cliente',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'precision' => 6,
      'id' => 'Pagos_Pagos_de_Clientesimporte_pagado_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'pagos_pagos_de_clientes_anti_anticipos_1' => 
    array (
      'name' => 'pagos_pagos_de_clientes_anti_anticipos_1',
      'type' => 'link',
      'relationship' => 'pagos_pagos_de_clientes_anti_anticipos_1',
      'source' => 'non-db',
      'module' => 'ANTI_Anticipos',
      'bean_name' => 'ANTI_Anticipos',
      'vname' => 'LBL_PAGOS_PAGOS_DE_CLIENTES_ANTI_ANTICIPOS_1_FROM_ANTI_ANTICIPOS_TITLE',
      'id_name' => 'pagos_pagos_de_clientes_anti_anticipos_1anti_anticipos_idb',
    ),
    'pagos_pagos_de_clientes_anti_anticipos_1_name' => 
    array (
      'name' => 'pagos_pagos_de_clientes_anti_anticipos_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_PAGOS_PAGOS_DE_CLIENTES_ANTI_ANTICIPOS_1_FROM_ANTI_ANTICIPOS_TITLE',
      'save' => true,
      'id_name' => 'pagos_pagos_de_clientes_anti_anticipos_1anti_anticipos_idb',
      'link' => 'pagos_pagos_de_clientes_anti_anticipos_1',
      'table' => 'anti_anticipos',
      'module' => 'ANTI_Anticipos',
      'rname' => 'name',
    ),
    'pagos_pagos_de_clientes_anti_anticipos_1anti_anticipos_idb' => 
    array (
      'name' => 'pagos_pagos_de_clientes_anti_anticipos_1anti_anticipos_idb',
      'type' => 'link',
      'relationship' => 'pagos_pagos_de_clientes_anti_anticipos_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'left',
      'vname' => 'LBL_PAGOS_PAGOS_DE_CLIENTES_ANTI_ANTICIPOS_1_FROM_ANTI_ANTICIPOS_TITLE',
    ),
    'fact_sait_c' => 
    array (
      'labelValue' => 'fact SAIT',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fact_sait_c',
      'vname' => 'LBL_FACT_SAIT',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'digite la el No. fact de SAIT',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesfact_sait_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'fg_orden_p__c' => 
    array (
      'labelValue' => 'FG orden ',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fg_orden_p__c',
      'vname' => 'LBL_FG_ORDEN_P_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesfg_orden_p__c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'fecha_recepcion_pago_c' => 
    array (
      'options' => 'date_range_search_dom',
      'labelValue' => 'Recep. Pago EN BANCO',
      'enable_range_search' => '1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_recepcion_pago_c',
      'vname' => 'LBL_FECHA_RECEPCION_PAGO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccione en el Calendario la fecha en la que nosotros recibimos el soporte del pago: FICHA DE DEPOCITO',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesfecha_recepcion_pago_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'resultado_c' => 
    array (
      'labelValue' => 'Resultado',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'resultado_c',
      'vname' => 'LBL_RESULTADO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'Seleccione',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'resultado_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Pagos_Pagos_de_Clientesresultado_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'aos_invoices_pagos_pagos_de_clientes_1' => 
    array (
      'name' => 'aos_invoices_pagos_pagos_de_clientes_1',
      'type' => 'link',
      'relationship' => 'aos_invoices_pagos_pagos_de_clientes_1',
      'source' => 'non-db',
      'module' => 'AOS_Invoices',
      'bean_name' => 'AOS_Invoices',
      'vname' => 'LBL_AOS_INVOICES_PAGOS_PAGOS_DE_CLIENTES_1_FROM_AOS_INVOICES_TITLE',
      'id_name' => 'aos_invoices_pagos_pagos_de_clientes_1aos_invoices_ida',
    ),
    'aos_invoices_pagos_pagos_de_clientes_1_name' => 
    array (
      'name' => 'aos_invoices_pagos_pagos_de_clientes_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_AOS_INVOICES_PAGOS_PAGOS_DE_CLIENTES_1_FROM_AOS_INVOICES_TITLE',
      'save' => true,
      'id_name' => 'aos_invoices_pagos_pagos_de_clientes_1aos_invoices_ida',
      'link' => 'aos_invoices_pagos_pagos_de_clientes_1',
      'table' => 'aos_invoices',
      'module' => 'AOS_Invoices',
      'rname' => 'name',
    ),
    'aos_invoices_pagos_pagos_de_clientes_1aos_invoices_ida' => 
    array (
      'name' => 'aos_invoices_pagos_pagos_de_clientes_1aos_invoices_ida',
      'type' => 'link',
      'relationship' => 'aos_invoices_pagos_pagos_de_clientes_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_AOS_INVOICES_PAGOS_PAGOS_DE_CLIENTES_1_FROM_PAGOS_PAGOS_DE_CLIENTES_TITLE',
    ),
    'trermin_tc_c' => 
    array (
      'labelValue' => '4 últimos dígitos de la TC',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'trermin_tc_c',
      'vname' => 'LBL_TRERMIN_TC',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'TECLEE LOS ULTIMOS CUATRO DIGITOS DE LA TC CON LA QUE PAGO EL CLIENTE',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientestrermin_tc_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'folio_pago_ef_sait__c' => 
    array (
      'labelValue' => 'folio pago EF SAIT',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'folio_pago_ef_sait__c',
      'vname' => 'LBL_FOLIO_PAGO_EF_SAIT_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesfolio_pago_ef_sait__c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'reg_en_decaspel_p_c' => 
    array (
      'labelValue' => '(no Usar) Registrado en DECASPEL',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'reg_en_decaspel_p_c',
      'vname' => 'LBL_REG_EN_DECASPEL_P',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'delecione la casilla cuando ya se haya registrado el pago en decaspel',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesreg_en_decaspel_p_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'lpagada_c' => 
    array (
      'labelValue' => 'lpagada',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'lpagada_c',
      'vname' => 'LBL_LPAGADA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => 'N',
      'no_default' => false,
      'comments' => 'S / N',
      'help' => 'S / N',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '1',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clienteslpagada_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'esautogenerado_c' => 
    array (
      'labelValue' => 'esAutoGenerado',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'esautogenerado_c',
      'vname' => 'LBL_ESAUTOGENERADO',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '5',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'Pagos_Pagos_de_Clientesesautogenerado_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'fcompag_c' => 
    array (
      'labelValue' => 'Fecha Pago de Comisión',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fcompag_c',
      'vname' => 'LBL_FCOMPAG',
      'type' => 'date',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'display_default' => 'now',
      'id' => 'Pagos_Pagos_de_Clientesfcompag_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'comision_ya_pagada_c' => 
    array (
      'labelValue' => 'Comisión ya pagada',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'comision_ya_pagada_c',
      'vname' => 'LBL_COMISION_YA_PAGADA',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => 'Seleccionar cuando ya se haya pagado la Comision al Vendedor',
      'help' => 'Seleccionar cuando ya se haya pagado la Comision al Vendedor',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientescomision_ya_pagada_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'depositado_c' => 
    array (
      'labelValue' => 'Depositado anterior',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'depositado_c',
      'vname' => 'LBL_DEPOSITADO',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => 'Dinero depositado en Bancos',
      'help' => 'Dinero depositado en Bancos',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesdepositado_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'rem_pago_c' => 
    array (
      'labelValue' => 'Remision',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'rem_pago_c',
      'vname' => 'LBL_REM_PAGO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'Digite el numero de remision',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '50',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientesrem_pago_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'pago_gastos_c' => 
    array (
      'labelValue' => 'Gastos',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pago_gastos_c',
      'vname' => 'LBL_PAGO_GASTOS',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => 'En este Pago se consideran los importes de Gastos y/o Servicios',
      'help' => 'En este Pago se consideran los importes de Gastos y/o Servicios',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientespago_gastos_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'cod_desbloqueo_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cod_desbloqueo_c',
      'vname' => 'LBL_COD_DESBLOQUEO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Capture el codigo de desbloqueo  correspondiente al pago',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Pagos_Pagos_de_Clientescod_desbloqueo_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
    'fecha_recepcion_efevtivo_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_recepcion_efevtivo_c',
      'vname' => 'FECHA RECEPCION EFEVTIVO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'la fecha en que se entrega el efectivo en admin',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'Pagos_Pagos_de_Clientesfecha_recepcion_efevtivo_c',
      'custom_module' => 'Pagos_Pagos_de_Clientes',
    ),
  ),
  'relationships' => 
  array (
    'pagos_pagos_de_clientes_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Pagos_Pagos_de_Clientes',
      'rhs_table' => 'pagos_pagos_de_clientes',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'pagos_pagos_de_clientes_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Pagos_Pagos_de_Clientes',
      'rhs_table' => 'pagos_pagos_de_clientes',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'pagos_pagos_de_clientes_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Pagos_Pagos_de_Clientes',
      'rhs_table' => 'pagos_pagos_de_clientes',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_locking' => true,
  'unified_search' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'pagos_pagos_de_clientespk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'sale' => 'sale',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);