<?php 
 $GLOBALS["dictionary"]["Case"]=array (
  'table' => 'cases',
  'audited' => true,
  'unified_search' => true,
  'full_text_search' => true,
  'unified_search_default_enabled' => true,
  'duplicate_merge' => true,
  'comment' => 'Cases are issues or problems that a customer asks a support representative to resolve',
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_SUBJECT',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'audited' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'The short description of the bug',
      'merge_filter' => 'disabled',
      'required' => false,
      'importable' => 'required',
      'comments' => 'Name',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => false,
      'options' => 'date_range_search_dom',
      'comments' => 'Date record created',
      'merge_filter' => 'disabled',
      'audited' => true,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => '6',
      'cols' => '40',
      'help' => 'Solicite al cliente que describa la falla que presenta el equipo, toda la informacion y lo mas detallada posible al respecto eje. : Cual es la falla que presenta (detallada) Cuando la presenta Desde cuando la presenta  Si hubo algun detonante (caidas,  variaciones de voltaje, etc.)   Mientras mas informaci&oacute;n nos proporcione  mas sencillo sera  encontrar la falla',
      'comments' => 'Full text of the note',
      'merge_filter' => 'disabled',
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'cases_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'cases_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'cases_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'case_number' => 
    array (
      'name' => 'case_number',
      'vname' => 'LBL_NUMBER',
      'type' => 'int',
      'readonly' => true,
      'len' => 11,
      'required' => true,
      'auto_increment' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'Visual unique identifier',
      'duplicate_merge' => 'disabled',
      'disable_num_format' => true,
      'studio' => 
      array (
        'quickcreate' => false,
      ),
      'comments' => 'Folio',
      'merge_filter' => 'disabled',
      'enable_range_search' => false,
      'autoinc_next' => '2269',
      'min' => false,
      'max' => false,
    ),
    'type' => 
    array (
      'name' => 'type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'options' => 'case_type_dom',
      'len' => 255,
      'comment' => 'The type of issue (ex: issue, feature)',
      'merge_filter' => 'enabled',
    ),
    'status' => 
    array (
      'name' => 'status',
      'vname' => 'LBL_STATUS',
      'type' => 'dynamicenum',
      'options' => 'case_status_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'The status of the case',
      'comments' => 'The status of the case',
      'merge_filter' => 'disabled',
      'help' => '',
      'dbtype' => 'enum',
      'parentenum' => 'state',
    ),
    'priority' => 
    array (
      'name' => 'priority',
      'vname' => 'LBL_PRIORITY',
      'type' => 'enum',
      'options' => 'case_priority_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'The priority of the case',
    ),
    'resolution' => 
    array (
      'name' => 'resolution',
      'vname' => 'LBL_RESOLUTION',
      'type' => 'text',
      'comment' => 'The resolution of the case',
      'help' => '1.-Describir la(s) posible(s) causa(s) de la falla, lo mas sencilla posible (para que se le pueda explicar al cliente) 2.- Describir la correcci&oacute;n  de la falla ',
      'comments' => 'The resolution of the case',
      'merge_filter' => 'disabled',
      'cols' => 80,
      'rows' => 6,
    ),
    'work_log' => 
    array (
      'name' => 'work_log',
      'vname' => 'LBL_WORK_LOG',
      'type' => 'text',
      'comment' => 'Free-form text used to denote activities of interest',
    ),
    'account_name' => 
    array (
      'name' => 'account_name',
      'rname' => 'name',
      'id_name' => 'account_id',
      'vname' => 'LBL_ACCOUNT_NAME',
      'type' => 'relate',
      'link' => 'accounts',
      'table' => 'accounts',
      'join_name' => 'accounts',
      'isnull' => 'true',
      'module' => 'Accounts',
      'dbType' => 'varchar',
      'len' => 100,
      'source' => 'non-db',
      'unified_search' => true,
      'comment' => 'The name of the account represented by the account_id field',
      'required' => true,
      'importable' => 'required',
    ),
    'account_name1' => 
    array (
      'name' => 'account_name1',
      'source' => 'non-db',
      'type' => 'text',
      'len' => 100,
      'importable' => 'false',
      'studio' => 
      array (
        'formula' => false,
      ),
    ),
    'account_id' => 
    array (
      'name' => 'account_id',
      'type' => 'relate',
      'dbType' => 'id',
      'rname' => 'id',
      'module' => 'Accounts',
      'id_name' => 'account_id',
      'reportable' => false,
      'vname' => 'LBL_ACCOUNT_ID',
      'audited' => true,
      'massupdate' => false,
      'comment' => 'The account to which the case is associated',
    ),
    'state' => 
    array (
      'name' => 'state',
      'vname' => 'LBL_STATE',
      'type' => 'enum',
      'options' => 'case_state_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'The state of the case (i.e. open/closed)',
      'default' => 'Open',
      'parentenum' => 'status',
      'merge_filter' => 'disabled',
      'comments' => 'The state of the case (i.e. open/closed)',
    ),
    'tasks' => 
    array (
      'name' => 'tasks',
      'type' => 'link',
      'relationship' => 'case_tasks',
      'source' => 'non-db',
      'vname' => 'LBL_TASKS',
    ),
    'notes' => 
    array (
      'name' => 'notes',
      'type' => 'link',
      'relationship' => 'case_notes',
      'source' => 'non-db',
      'vname' => 'LBL_NOTES',
    ),
    'meetings' => 
    array (
      'name' => 'meetings',
      'type' => 'link',
      'relationship' => 'case_meetings',
      'bean_name' => 'Meeting',
      'source' => 'non-db',
      'vname' => 'LBL_MEETINGS',
    ),
    'emails' => 
    array (
      'name' => 'emails',
      'type' => 'link',
      'relationship' => 'emails_cases_rel',
      'source' => 'non-db',
      'vname' => 'LBL_EMAILS',
    ),
    'documents' => 
    array (
      'name' => 'documents',
      'type' => 'link',
      'relationship' => 'documents_cases',
      'source' => 'non-db',
      'vname' => 'LBL_DOCUMENTS_SUBPANEL_TITLE',
    ),
    'calls' => 
    array (
      'name' => 'calls',
      'type' => 'link',
      'relationship' => 'case_calls',
      'source' => 'non-db',
      'vname' => 'LBL_CALLS',
    ),
    'bugs' => 
    array (
      'name' => 'bugs',
      'type' => 'link',
      'relationship' => 'cases_bugs',
      'source' => 'non-db',
      'vname' => 'LBL_BUGS',
    ),
    'contacts' => 
    array (
      'name' => 'contacts',
      'type' => 'link',
      'relationship' => 'contacts_cases',
      'source' => 'non-db',
      'vname' => 'LBL_CONTACTS',
    ),
    'accounts' => 
    array (
      'name' => 'accounts',
      'type' => 'link',
      'relationship' => 'account_cases',
      'link_type' => 'one',
      'side' => 'right',
      'source' => 'non-db',
      'vname' => 'LBL_ACCOUNT',
    ),
    'project' => 
    array (
      'name' => 'project',
      'type' => 'link',
      'relationship' => 'projects_cases',
      'source' => 'non-db',
      'vname' => 'LBL_PROJECTS',
    ),
    'producto_c' => 
    array (
      'labelValue' => 'Equipo',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'producto_c',
      'vname' => 'LBL_PRODUCTO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccione el equipo que esta recibiendo',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'producto_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Casesproducto_c',
      'custom_module' => 'Cases',
    ),
    't_recepcion_c' => 
    array (
      'labelValue' => 't Recepcion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 't_recepcion_c',
      'vname' => 'LBL_T_RECEPCION',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'Casest_recepcion_c',
      'custom_module' => 'Cases',
    ),
    'case_update_form' => 
    array (
      'required' => false,
      'name' => 'case_update_form',
      'vname' => 'LBL_CASE_UPDATE_FORM',
      'type' => 'function',
      'source' => 'non-db',
      'massupdate' => 0,
      'studio' => 'visible',
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => false,
      'function' => 
      array (
        'name' => 'display_update_form',
        'returns' => 'html',
        'include' => 'modules/AOP_Case_Updates/Case_Updates.php',
      ),
    ),
    'asunto2_c' => 
    array (
      'labelValue' => 'Asunto2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'asunto2_c',
      'vname' => 'LBL_ASUNTO2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casesasunto2_c',
      'custom_module' => 'Cases',
    ),
    't_serie_c' => 
    array (
      'labelValue' => 't Serie',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 't_serie_c',
      'vname' => 'LBL_T_SERIE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casest_serie_c',
      'custom_module' => 'Cases',
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_cases',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'serie_c' => 
    array (
      'labelValue' => 'No. de Serie del Equipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'serie_c',
      'vname' => 'LBL_SERIE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Capture el numero de serie del equipo que esta recibiendo',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'Casesserie_c',
      'custom_module' => 'Cases',
    ),
    'asignado_c' => 
    array (
      'labelValue' => 'Asignado',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'asignado_c',
      'vname' => 'LBL_ASIGNADO',
      'type' => 'dynamicenum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'asignado_list',
      'studio' => 'visible',
      'dbType' => 'enum',
      'parentenum' => 'case_status_dom',
      'id' => 'Casesasignado_c',
      'custom_module' => 'Cases',
    ),
    'direccion_cliente_c' => 
    array (
      'labelValue' => 'Direccion Cliente',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'direccion_cliente_c',
      'vname' => 'LBL_DIRECCION_CLIENTE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casesdireccion_cliente_c',
      'custom_module' => 'Cases',
    ),
    'fecha_hora_envio_c' => 
    array (
      'labelValue' => 'Fecha y Hora de Envio al Cliente',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_hora_envio_c',
      'vname' => 'LBL_FECHA_HORA_ENVIO',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'Casesfecha_hora_envio_c',
      'custom_module' => 'Cases',
    ),
    'mejora_probable__c' => 
    array (
      'labelValue' => 'Mejora probable',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mejora_probable__c',
      'vname' => 'LBL_MEJORA_PROBABLE_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'Casesmejora_probable__c',
      'custom_module' => 'Cases',
    ),
    'imprimir_formato_c' => 
    array (
      'labelValue' => 'Imprimir Formato',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'imprimir_formato_c',
      'vname' => 'LBL_IMPRIMIR_FORMATO',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccione esta casilla para enviar por correo el formato de servicio al cliente',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casesimprimir_formato_c',
      'custom_module' => 'Cases',
    ),
    't_folio_c' => 
    array (
      'labelValue' => 't Folio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 't_folio_c',
      'vname' => 'LBL_T_FOLIO',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'Casest_folio_c',
      'custom_module' => 'Cases',
    ),
    'clave_para_hoja_c' => 
    array (
      'labelValue' => 'Clave Para hoja',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'clave_para_hoja_c',
      'vname' => 'LBL_CLAVE_PARA_HOJA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '50',
      'size' => '20',
      'id' => 'Casesclave_para_hoja_c',
      'custom_module' => 'Cases',
    ),
    'producto__c' => 
    array (
      'labelValue' => 'Producto',
      'required' => false,
      'source' => 'non-db',
      'name' => 'producto__c',
      'vname' => 'LBL_PRODUCTO_',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'aos_products_id_c',
      'ext2' => 'AOS_Products',
      'module' => 'AOS_Products',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'Casesproducto__c',
      'custom_module' => 'Cases',
    ),
    'update_text' => 
    array (
      'required' => false,
      'name' => 'update_text',
      'vname' => 'LBL_UPDATE_TEXT',
      'source' => 'non-db',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => 6,
      'cols' => 80,
      'id' => 'Casesupdate_text',
    ),
    'fecha_de_compra_c' => 
    array (
      'labelValue' => 'Fecha de Compra',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_de_compra_c',
      'vname' => 'LBL_FECHA_DE_COMPRA',
      'type' => 'date',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccione EN EL CALENDARIO la fecha en la que se adquirio el equipo',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'Casesfecha_de_compra_c',
      'custom_module' => 'Cases',
    ),
    'costo_reparacion_c' => 
    array (
      'labelValue' => 'Costo de la Reparacion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'costo_reparacion_c',
      'vname' => 'LBL_COSTO_REPARACION',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Capture el costo de la reparacion  (pezas y MO)',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'Casescosto_reparacion_c',
      'custom_module' => 'Cases',
    ),
    'estado_servicio_c' => 
    array (
      'labelValue' => 'El servicio se encuentra en:',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'estado_servicio_c',
      'vname' => 'LBL_ESTADO_SERVICIO',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'estado_servicio_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Casesestado_servicio_c',
      'custom_module' => 'Cases',
    ),
    'num_guia_c' => 
    array (
      'labelValue' => 'Número de Guía',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'num_guia_c',
      'vname' => 'LBL_NUM_GUIA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Capture el numero de guia utilizado',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '30',
      'size' => '20',
      'id' => 'Casesnum_guia_c',
      'custom_module' => 'Cases',
    ),
    'producto_cal__c' => 
    array (
      'labelValue' => 'Producto  Serv',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'producto_cal__c',
      'vname' => 'LBL_PRODUCTO_CAL_',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'producto_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Casesproducto_cal__c',
      'custom_module' => 'Cases',
    ),
    'mantenimiento_c' => 
    array (
      'labelValue' => '¿Que mantenimiento le da al equipo?',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mantenimiento_c',
      'vname' => 'LBL_MANTENIMIENTO',
      'type' => 'text',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Solicite al Dr. le describa el mantenimiento que le da al equipo que trae a servicio y capturelo aqui',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'Casesmantenimiento_c',
      'custom_module' => 'Cases',
    ),
    'aop_case_events' => 
    array (
      'name' => 'aop_case_events',
      'type' => 'link',
      'relationship' => 'cases_aop_case_events',
      'source' => 'non-db',
      'id_name' => 'case_id',
      'vname' => 'LBL_AOP_CASE_EVENTS',
    ),
    'costo_de_envio_c' => 
    array (
      'labelValue' => 'Costo de Envio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'costo_de_envio_c',
      'vname' => 'LBL_COSTO_DE_ENVIO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Capture el costo del envio',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'Casescosto_de_envio_c',
      'custom_module' => 'Cases',
    ),
    'mensajeria_d_c' => 
    array (
      'labelValue' => 'Mensajeria d',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensajeria_d_c',
      'vname' => 'LBL_MENSAJERIA_D',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccione la mensageria  utilizada',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'mensajeria_d_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Casesmensajeria_d_c',
      'custom_module' => 'Cases',
    ),
    'refacciones_reparacion_c' => 
    array (
      'labelValue' => 'Piezas Requeridas',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'refacciones_reparacion_c',
      'vname' => 'LBL_REFACCIONES_REPARACION',
      'type' => 'text',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Taller  enlistara aqui las piezas que se requieren  para  efectuar el servicio',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'Casesrefacciones_reparacion_c',
      'custom_module' => 'Cases',
    ),
    'total_c' => 
    array (
      'labelValue' => 'Total',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'total_c',
      'vname' => 'LBL_TOTAL',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Capture el total a pagar',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'Casestotal_c',
      'custom_module' => 'Cases',
    ),
    'equipo_para_hoja_c' => 
    array (
      'labelValue' => 'Equipo para hoja',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'equipo_para_hoja_c',
      'vname' => 'LBL_EQUIPO_PARA_HOJA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '50',
      'size' => '20',
      'id' => 'Casesequipo_para_hoja_c',
      'custom_module' => 'Cases',
    ),
    't_equipo_a_reparar_c' => 
    array (
      'labelValue' => 't Equipo a reparar',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 't_equipo_a_reparar_c',
      'vname' => 'LBL_T_EQUIPO_A_REPARAR',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'producto_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Casest_equipo_a_reparar_c',
      'custom_module' => 'Cases',
    ),
    'reparacion_realizada_c' => 
    array (
      'labelValue' => 'reparacion realizada',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'reparacion_realizada_c',
      'vname' => 'LBL_REPARACION_REALIZADA',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'Describa la reparacion  realizada  de modo que  administracion pueda explicarselo al Ciliente',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'Casesreparacion_realizada_c',
      'custom_module' => 'Cases',
    ),
    'tipo_de_servicio_c' => 
    array (
      'labelValue' => 'El Servicio se tomara como',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tipo_de_servicio_c',
      'vname' => 'LBL_TIPO_DE_SERVICIO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'Servicio',
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccione si el servicio se tomara como: SERVICIO (Generando un costo por reparacion y mensageria)  o como  GARANTIA (sin costo de reparacion,  solo costo de mensageria)',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'tipo_de_servicio_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Casestipo_de_servicio_c',
      'custom_module' => 'Cases',
    ),
    'investigacion_c' => 
    array (
      'labelValue' => 'Investigacion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'investigacion_c',
      'vname' => 'LBL_INVESTIGACION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casesinvestigacion_c',
      'custom_module' => 'Cases',
    ),
    't_descripcion_falla_c' => 
    array (
      'labelValue' => 't Descripcion de la Falla',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 't_descripcion_falla_c',
      'vname' => 'LBL_T_DESCRIPCION_FALLA',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'Casest_descripcion_falla_c',
      'custom_module' => 'Cases',
    ),
    'estado_admin_c' => 
    array (
      'labelValue' => 'Estado Servicio Admin',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'estado_admin_c',
      'vname' => 'LBL_ESTADO_ADMIN',
      'type' => 'dynamicenum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'estado_admin_c_list',
      'studio' => 'visible',
      'dbType' => 'enum',
      'parentenum' => 'estado_servicio_c',
      'id' => 'Casesestado_admin_c',
      'custom_module' => 'Cases',
    ),
    'requiere_factura_c' => 
    array (
      'labelValue' => 'Requiere Factura',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'requiere_factura_c',
      'vname' => 'LBL_REQUIERE_FACTURA',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'si_no_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Casesrequiere_factura_c',
      'custom_module' => 'Cases',
    ),
    'folio_factura_sae_c' => 
    array (
      'labelValue' => 'Folio factura SAE',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'folio_factura_sae_c',
      'vname' => 'LBL_FOLIO_FACTURA_SAE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'Capture el folio dela factura SAE',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casesfolio_factura_sae_c',
      'custom_module' => 'Cases',
    ),
    'estado_taller_c' => 
    array (
      'labelValue' => 'Estado del Servicio en Taller',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'estado_taller_c',
      'vname' => 'LBL_ESTADO_TALLER',
      'type' => 'dynamicenum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'estado_taller_list',
      'studio' => 'visible',
      'dbType' => 'enum',
      'parentenum' => 'estado_servicio_c',
      'id' => 'Casesestado_taller_c',
      'custom_module' => 'Cases',
    ),
    'numero_de_lote_c' => 
    array (
      'labelValue' => 'Número De Lote',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numero_de_lote_c',
      'vname' => 'LBL_NUMERO_DE_LOTE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '50',
      'size' => '20',
      'id' => 'Casesnumero_de_lote_c',
      'custom_module' => 'Cases',
    ),
    'fecha_fin_de_rep__c' => 
    array (
      'labelValue' => 'fecha fin de rep',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_fin_de_rep__c',
      'vname' => 'LBL_FECHA_FIN_DE_REP_',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccione la fecha y hora en la que  se termino la reparacion',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'Casesfecha_fin_de_rep__c',
      'custom_module' => 'Cases',
    ),
    't_cliente_c' => 
    array (
      'labelValue' => 't Cliente',
      'required' => false,
      'source' => 'non-db',
      'name' => 't_cliente_c',
      'vname' => 'LBL_T_CLIENTE_C',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => NULL,
      'ext2' => 'Accounts',
      'module' => 'Accounts',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'Casest_cliente_c',
      'custom_module' => 'Cases',
    ),
    'folio_crm_orden_de_compra_c' => 
    array (
      'labelValue' => 'folio CRM orden de compra',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'folio_crm_orden_de_compra_c',
      'vname' => 'LBL_FOLIO_CRM_ORDEN_DE_COMPRA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'Capture el  folio  asignado de la orden de compre  de CRM',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casesfolio_crm_orden_de_compra_c',
      'custom_module' => 'Cases',
    ),
    'internal' => 
    array (
      'name' => 'internal',
      'source' => 'non-db',
      'vname' => 'LBL_INTERNAL',
      'type' => 'bool',
      'studio' => 'visible',
    ),
    'aop_case_updates_threaded' => 
    array (
      'required' => false,
      'name' => 'aop_case_updates_threaded',
      'vname' => 'LBL_AOP_CASE_UPDATES_THREADED',
      'type' => 'function',
      'source' => 'non-db',
      'massupdate' => 0,
      'studio' => 'visible',
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => false,
      'function' => 
      array (
        'name' => 'display_updates',
        'returns' => 'html',
        'include' => 'modules/AOP_Case_Updates/Case_Updates.php',
      ),
    ),
    'aop_case_updates' => 
    array (
      'name' => 'aop_case_updates',
      'type' => 'link',
      'relationship' => 'cases_aop_case_updates',
      'source' => 'non-db',
      'id_name' => 'case_id',
      'vname' => 'LBL_AOP_CASE_UPDATES',
    ),
    'case_attachments_display' => 
    array (
      'required' => false,
      'name' => 'case_attachments_display',
      'vname' => 'LBL_CASE_ATTACHMENTS_DISPLAY',
      'type' => 'function',
      'source' => 'non-db',
      'massupdate' => 0,
      'studio' => 'visible',
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => false,
      'function' => 
      array (
        'name' => 'display_case_attachments',
        'returns' => 'html',
        'include' => 'modules/AOP_Case_Updates/Case_Updates.php',
      ),
    ),
    'contact_created_by' => 
    array (
      'name' => 'contact_created_by',
      'type' => 'link',
      'relationship' => 'cases_created_contact',
      'module' => 'Contacts',
      'bean_name' => 'Contact',
      'link_type' => 'one',
      'source' => 'non-db',
      'vname' => 'LBL_CONTACT_CREATED_BY',
      'side' => 'left',
      'id_name' => 'contact_created_by_id',
    ),
    'contact_created_by_name' => 
    array (
      'name' => 'contact_created_by_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_CONTACT_CREATED_BY_NAME',
      'save' => true,
      'id_name' => 'contact_created_by_id',
      'link' => 'cases_created_contact',
      'table' => 'Contacts',
      'module' => 'Contacts',
      'rname' => 'name',
    ),
    'contact_created_by_id' => 
    array (
      'name' => 'contact_created_by_id',
      'type' => 'id',
      'reportable' => false,
      'vname' => 'LBL_CONTACT_CREATED_BY_ID',
    ),
    'folio_orden_compra_fisica_c' => 
    array (
      'labelValue' => 'folio orden compra fisica',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'folio_orden_compra_fisica_c',
      'vname' => 'LBL_FOLIO_ORDEN_COMPRA_FISICA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'Capture el folio de la orden de compra fisica ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casesfolio_orden_compra_fisica_c',
      'custom_module' => 'Cases',
    ),
    'imputable_a__c' => 
    array (
      'labelValue' => 'imputable a',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'imputable_a__c',
      'vname' => 'LBL_IMPUTABLE_A_',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'imputable_a_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Casesimputable_a__c',
      'custom_module' => 'Cases',
    ),
    'accion_a_tomar_serv__c' => 
    array (
      'labelValue' => 'ACCION A TOMAR ',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'accion_a_tomar_serv__c',
      'vname' => 'LBL_ACCION_A_TOMAR_SERV_',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'accion_a_tomar_serv_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Casesaccion_a_tomar_serv__c',
      'custom_module' => 'Cases',
    ),
    'mensajeria_c' => 
    array (
      'labelValue' => 'Mensajeria TEXTO',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensajeria_c',
      'vname' => 'LBL_MENSAJERIA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'Casesmensajeria_c',
      'custom_module' => 'Cases',
    ),
    'firma_del_cliente_c' => 
    array (
      'labelValue' => 'firma del cliente',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'firma_del_cliente_c',
      'vname' => 'LBL_FIRMA_DEL_CLIENTE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casesfirma_del_cliente_c',
      'custom_module' => 'Cases',
    ),
    'folio_factura_nota_c' => 
    array (
      'labelValue' => 'Folio de Orden de Compra',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'folio_factura_nota_c',
      'vname' => 'LBL_FOLIO_FACTURA_NOTA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Capture el folio de la orden de compra del con la el cliente adquirio el equipo',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '30',
      'size' => '20',
      'id' => 'Casesfolio_factura_nota_c',
      'custom_module' => 'Cases',
    ),
    'inventario_c' => 
    array (
      'labelValue' => 'Inventario del equipo Recibido',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'inventario_c',
      'vname' => 'LBL_INVENTARIO',
      'type' => 'text',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Enliste las piezas que esta recibiendo con el equipo y capturelo aqui (con el fin de evitar malos entendidos con el Dr. al momento de finalizar el servicio',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '40',
      'id' => 'Casesinventario_c',
      'custom_module' => 'Cases',
    ),
    'folio_fisico_c' => 
    array (
      'labelValue' => 'Folio Fisico',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'folio_fisico_c',
      'vname' => 'LBL_FOLIO_FISICO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'Casesfolio_fisico_c',
      'custom_module' => 'Cases',
    ),
    'fecha_indicacion_cliente_c' => 
    array (
      'labelValue' => 'Fecha Indicación Cliente',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_indicacion_cliente_c',
      'vname' => 'LBL_FECHA_INDICACION_CLIENTE',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'Casesfecha_indicacion_cliente_c',
      'custom_module' => 'Cases',
    ),
    't_recibido_por_c' => 
    array (
      'labelValue' => 't Recibido por',
      'required' => false,
      'source' => 'non-db',
      'name' => 't_recibido_por_c',
      'vname' => 'LBL_T_RECIBIDO_POR',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'user_id1_c',
      'ext2' => 'Users',
      'module' => 'Users',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'Casest_recibido_por_c',
      'custom_module' => 'Cases',
    ),
    'riesgo_c' => 
    array (
      'labelValue' => 'Riesgo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'riesgo_c',
      'vname' => 'LBL_RIESGO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casesriesgo_c',
      'custom_module' => 'Cases',
    ),
    'condiciones_llega_c' => 
    array (
      'labelValue' => 'Condiciones en que llega el equipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'condiciones_llega_c',
      'vname' => 'LBL_CONDICIONES_LLEGA',
      'type' => 'text',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Describa las condiciones en las que llega el equipo, ejem. Si persenta raspones, golpes, manchas, la caja rota, etc. (cualquier detalle que se pueda convertir en un problema en el futuro)',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'Casescondiciones_llega_c',
      'custom_module' => 'Cases',
    ),
    'fecha_diagnostico_c' => 
    array (
      'labelValue' => 'Fecha Diagnostico',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_diagnostico_c',
      'vname' => 'LBL_FECHA_DIAGNOSTICO',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'Casesfecha_diagnostico_c',
      'custom_module' => 'Cases',
    ),
    'el_cliente_acepta_reparacion_c' => 
    array (
      'labelValue' => 'El Cliente acepta Reparacion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'el_cliente_acepta_reparacion_c',
      'vname' => 'LBL_EL_CLIENTE_ACEPTA_REPARACION',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'si_no_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Casesel_cliente_acepta_reparacion_c',
      'custom_module' => 'Cases',
    ),
    'agente_c' => 
    array (
      'labelValue' => 'Agente que recibe el eqipo',
      'required' => false,
      'source' => 'non-db',
      'name' => 'agente_c',
      'vname' => 'LBL_AGENTE',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Selecione  el agente que esta recibiendo el equipo',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'user_id_c',
      'ext2' => 'Users',
      'module' => 'Users',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'Casesagente_c',
      'custom_module' => 'Cases',
    ),
    'origen_de_falla__c' => 
    array (
      'labelValue' => 'origen de Falla',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'origen_de_falla__c',
      'vname' => 'LBL_ORIGEN_DE_FALLA_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'Casesorigen_de_falla__c',
      'custom_module' => 'Cases',
    ),
    'telefono_cliente_c' => 
    array (
      'labelValue' => 'Telefono Cliente',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'telefono_cliente_c',
      'vname' => 'LBL_TELEFONO_CLIENTE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casestelefono_cliente_c',
      'custom_module' => 'Cases',
    ),
    'fecha_hora_taller_c' => 
    array (
      'labelValue' => 'Fecha y hora de asignación al Taller',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_hora_taller_c',
      'vname' => 'LBL_FECHA_HORA_TALLER',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccionar “EN EL CALENDARIO” la fecha  y hora en que se le asigno  el servicio a taller',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'Casesfecha_hora_taller_c',
      'custom_module' => 'Cases',
    ),
    'task_descripcion_c' => 
    array (
      'labelValue' => 'task descripcion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task_descripcion_c',
      'vname' => 'LBL_TASK_DESCRIPCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casestask_descripcion_c',
      'custom_module' => 'Cases',
    ),
    'account_id_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'account_id_c',
      'vname' => 'LBL_T_CLIENTE_ACCOUNT_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'Casesaccount_id_c',
      'custom_module' => 'Cases',
    ),
    'aos_products_id_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'aos_products_id_c',
      'vname' => 'LBL_PRODUCTO__AOS_PRODUCTS_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'Casesaos_products_id_c',
      'custom_module' => 'Cases',
    ),
    'currency_id' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'currency_id',
      'vname' => 'LBL_CURRENCY',
      'type' => 'currency_id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'dbType' => 'id',
      'studio' => 'visible',
      'function' => 
      array (
        'name' => 'getCurrencyDropDown',
        'returns' => 'html',
      ),
      'id' => 'Casescurrency_id',
      'custom_module' => 'Cases',
    ),
    'inicio_de_la_reparacion_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'inicio_de_la_reparacion_c',
      'vname' => 'LBL_INICIO_DE_LA_REPARACION',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'Casesinicio_de_la_reparacion_c',
      'custom_module' => 'Cases',
    ),
    'observaciones_del_servicio_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'observaciones_del_servicio_c',
      'vname' => 'LBL_OBSERVACIONES_DEL_SERVICIO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'ANOTA  ALGO DEL HISTORICO DEL SERVICIO',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casesobservaciones_del_servicio_c',
      'custom_module' => 'Cases',
    ),
    'pruebasistemas_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pruebasistemas_c',
      'vname' => 'LBL_PRUEBASISTEMAS',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casespruebasistemas_c',
      'custom_module' => 'Cases',
    ),
    'quien_hiso_la_reparacion_c' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'quien_hiso_la_reparacion_c',
      'vname' => 'LBL_QUIEN_HISO_LA_REPARACION',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'perzona que reparo el equipo',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'user_id2_c',
      'ext2' => 'Users',
      'module' => 'Users',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'Casesquien_hiso_la_reparacion_c',
      'custom_module' => 'Cases',
    ),
    'reparacion_parcial_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'reparacion_parcial_c',
      'vname' => 'LBL_REPARACION_PARCIAL',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'SELECCIONA EN CASO DE UE LA REPARACION NOSE HAYA TERMINADO',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casesreparacion_parcial_c',
      'custom_module' => 'Cases',
    ),
    'revizado_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'revizado_c',
      'vname' => 'LBL_REVIZADO',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Casesrevizado_c',
      'custom_module' => 'Cases',
    ),
    'serv_asignado_a_c' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'serv_asignado_a_c',
      'vname' => 'LBL_SERV_ASIGNADO_A',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'user_id3_c',
      'ext2' => 'Users',
      'module' => 'Users',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'Casesserv_asignado_a_c',
      'custom_module' => 'Cases',
    ),
    'serv_cot_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'serv_cot_c',
      'vname' => 'LBL_SERV_COT',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'Casesserv_cot_c',
      'custom_module' => 'Cases',
    ),
    'ubicacion_del_servicio_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ubicacion_del_servicio_c',
      'vname' => 'LBL_UBICACION_DEL_SERVICIO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'UBICACION_SERV_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Casesubicacion_del_servicio_c',
      'custom_module' => 'Cases',
    ),
    'ubicacion_serv_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ubicacion_serv_c',
      'vname' => 'LBL_UBICACION_SERV',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'UBICACION_SERV_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Casesubicacion_serv_c',
      'custom_module' => 'Cases',
    ),
    'user_id1_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'user_id1_c',
      'vname' => 'LBL_T_RECIBIDO_POR_USER_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'Casesuser_id1_c',
      'custom_module' => 'Cases',
    ),
    'user_id2_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'user_id2_c',
      'vname' => 'LBL_QUIEN_HISO_LA_REPARACION_USER_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'Casesuser_id2_c',
      'custom_module' => 'Cases',
    ),
    'user_id3_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'user_id3_c',
      'vname' => 'LBL_SERV_ASIGNADO_A_USER_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'Casesuser_id3_c',
      'custom_module' => 'Cases',
    ),
    'user_id_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'user_id_c',
      'vname' => 'LBL_AGENTE_USER_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'Casesuser_id_c',
      'custom_module' => 'Cases',
    ),
  ),
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'casespk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
    'number' => 
    array (
      'name' => 'casesnumk',
      'type' => 'unique',
      'fields' => 
      array (
        0 => 'case_number',
      ),
    ),
    0 => 
    array (
      'name' => 'case_number',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'case_number',
      ),
    ),
    1 => 
    array (
      'name' => 'idx_case_name',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'name',
      ),
    ),
    2 => 
    array (
      'name' => 'idx_account_id',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'account_id',
      ),
    ),
    3 => 
    array (
      'name' => 'idx_cases_stat_del',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'assigned_user_id',
        1 => 'status',
        2 => 'deleted',
      ),
    ),
  ),
  'relationships' => 
  array (
    'cases_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Cases',
      'rhs_table' => 'cases',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'cases_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Cases',
      'rhs_table' => 'cases',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'cases_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Cases',
      'rhs_table' => 'cases',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'case_calls' => 
    array (
      'lhs_module' => 'Cases',
      'lhs_table' => 'cases',
      'lhs_key' => 'id',
      'rhs_module' => 'Calls',
      'rhs_table' => 'calls',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Cases',
    ),
    'case_tasks' => 
    array (
      'lhs_module' => 'Cases',
      'lhs_table' => 'cases',
      'lhs_key' => 'id',
      'rhs_module' => 'Tasks',
      'rhs_table' => 'tasks',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Cases',
    ),
    'case_notes' => 
    array (
      'lhs_module' => 'Cases',
      'lhs_table' => 'cases',
      'lhs_key' => 'id',
      'rhs_module' => 'Notes',
      'rhs_table' => 'notes',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Cases',
    ),
    'case_meetings' => 
    array (
      'lhs_module' => 'Cases',
      'lhs_table' => 'cases',
      'lhs_key' => 'id',
      'rhs_module' => 'Meetings',
      'rhs_table' => 'meetings',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Cases',
    ),
    'case_emails' => 
    array (
      'lhs_module' => 'Cases',
      'lhs_table' => 'cases',
      'lhs_key' => 'id',
      'rhs_module' => 'Emails',
      'rhs_table' => 'emails',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Cases',
    ),
    'cases_created_contact' => 
    array (
      'lhs_module' => 'Contacts',
      'lhs_table' => 'contacts',
      'lhs_key' => 'id',
      'rhs_module' => 'Cases',
      'rhs_table' => 'cases',
      'rhs_key' => 'contact_created_by_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_locking' => true,
  'templates' => 
  array (
    'issue' => 'issue',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);