<?php 
 $GLOBALS["dictionary"]["Account"]=array (
  'table' => 'accounts',
  'audited' => true,
  'unified_search' => true,
  'full_text_search' => true,
  'unified_search_default_enabled' => true,
  'duplicate_merge' => true,
  'comment' => 'Accounts are organizations or entities that are the target of selling, support, and marketing activities, or have already purchased products or services',
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'type' => 'name',
      'dbType' => 'varchar',
      'vname' => 'LBL_NAME',
      'len' => '160',
      'comment' => 'Name of the Company',
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'audited' => true,
      'required' => true,
      'importable' => 'required',
      'merge_filter' => 'disabled',
      'comments' => '',
      'help' => 'Nombre del Negocio o Nombre Completo del Dr. (Sin titulo "DR.") (Apellido Paterno,Apellido Materno y Nombre(s))   -  OJO: No es el Nombre de Facturacion',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'accounts_created_by',
      'vname' => 'LBL_CREATED_BY_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'accounts_modified_user',
      'vname' => 'LBL_MODIFIED_BY_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'accounts_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'account_type' => 
    array (
      'name' => 'account_type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'options' => 'account_type_dom',
      'len' => 100,
      'comment' => 'The Company is of this type',
      'default' => '',
      'comments' => 'Tipo Nousar',
      'merge_filter' => 'disabled',
      'massupdate' => 0,
      'required' => false,
      'help' => 'SELECCIONE QUE TIPO DE CLIENTE ES ?',
    ),
    'industry' => 
    array (
      'name' => 'industry',
      'vname' => 'LBL_INDUSTRY',
      'type' => 'enum',
      'options' => 'industry_dom',
      'len' => 50,
      'comment' => 'The company belongs in this industry',
      'merge_filter' => 'enabled',
    ),
    'annual_revenue' => 
    array (
      'name' => 'annual_revenue',
      'vname' => 'LBL_ANNUAL_REVENUE',
      'type' => 'varchar',
      'len' => 100,
      'comment' => 'Annual revenue for this company',
      'merge_filter' => 'enabled',
    ),
    'phone_fax' => 
    array (
      'name' => 'phone_fax',
      'vname' => 'LBL_FAX',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'The fax phone number of this company',
    ),
    'billing_address_street' => 
    array (
      'name' => 'billing_address_street',
      'vname' => 'LBL_BILLING_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => '150',
      'comment' => 'The street address used for billing address',
      'group' => 'billing_address',
      'merge_filter' => 'disabled',
      'comments' => 'The street address used for billing address',
    ),
    'billing_address_street_2' => 
    array (
      'name' => 'billing_address_street_2',
      'vname' => 'LBL_BILLING_ADDRESS_STREET_2',
      'type' => 'varchar',
      'len' => '150',
      'source' => 'non-db',
    ),
    'billing_address_street_3' => 
    array (
      'name' => 'billing_address_street_3',
      'vname' => 'LBL_BILLING_ADDRESS_STREET_3',
      'type' => 'varchar',
      'len' => '150',
      'source' => 'non-db',
    ),
    'billing_address_street_4' => 
    array (
      'name' => 'billing_address_street_4',
      'vname' => 'LBL_BILLING_ADDRESS_STREET_4',
      'type' => 'varchar',
      'len' => '150',
      'source' => 'non-db',
    ),
    'billing_address_city' => 
    array (
      'name' => 'billing_address_city',
      'vname' => 'LBL_BILLING_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => '100',
      'comment' => 'The city used for billing address',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_state' => 
    array (
      'name' => 'billing_address_state',
      'vname' => 'LBL_BILLING_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => '100',
      'group' => 'billing_address',
      'comment' => 'The state used for billing address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_postalcode' => 
    array (
      'name' => 'billing_address_postalcode',
      'vname' => 'LBL_BILLING_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => '20',
      'group' => 'billing_address',
      'comment' => 'The postal code used for billing address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_country' => 
    array (
      'name' => 'billing_address_country',
      'vname' => 'LBL_BILLING_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'billing_address',
      'comment' => 'The country used for the billing address',
      'merge_filter' => 'enabled',
    ),
    'rating' => 
    array (
      'name' => 'rating',
      'vname' => 'LBL_RATING',
      'type' => 'varchar',
      'len' => 100,
      'comment' => 'An arbitrary rating for this company for use in comparisons with others',
    ),
    'phone_office' => 
    array (
      'name' => 'phone_office',
      'vname' => 'LBL_PHONE_OFFICE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'audited' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'The office phone number',
      'merge_filter' => 'disabled',
      'help' => 'CAPTURA SOLO LOS DIGITOS (Sin Espacios ni Signos ( (),-,/) Eje :55667788',
      'comments' => 'The office phone number',
    ),
    'phone_alternate' => 
    array (
      'name' => 'phone_alternate',
      'vname' => 'LBL_PHONE_ALT',
      'type' => 'phone',
      'group' => 'phone_office',
      'dbType' => 'varchar',
      'len' => 100,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'An alternate phone number',
      'merge_filter' => 'disabled',
      'help' => 'CAPTURA SOLO LOS DIGITOS (Sin Espacios ni Signos ( (),-,/) Eje :55667788',
      'comments' => 'An alternate phone number',
    ),
    'website' => 
    array (
      'name' => 'website',
      'vname' => 'LBL_WEBSITE',
      'type' => 'url',
      'dbType' => 'varchar',
      'len' => 255,
      'comment' => 'URL of website for the company',
    ),
    'ownership' => 
    array (
      'name' => 'ownership',
      'vname' => 'LBL_OWNERSHIP',
      'type' => 'varchar',
      'len' => 100,
      'comment' => '',
    ),
    'employees' => 
    array (
      'name' => 'employees',
      'vname' => 'LBL_EMPLOYEES',
      'type' => 'varchar',
      'len' => 10,
      'comment' => 'Number of employees, varchar to accomodate for both number (100) or range (50-100)',
    ),
    'ticker_symbol' => 
    array (
      'name' => 'ticker_symbol',
      'vname' => 'LBL_TICKER_SYMBOL',
      'type' => 'varchar',
      'len' => 10,
      'comment' => 'The stock trading (ticker) symbol for the company',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_street' => 
    array (
      'name' => 'shipping_address_street',
      'vname' => 'LBL_SHIPPING_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => 150,
      'group' => 'shipping_address',
      'comment' => 'The street address used for for shipping purposes',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_street_2' => 
    array (
      'name' => 'shipping_address_street_2',
      'vname' => 'LBL_SHIPPING_ADDRESS_STREET_2',
      'type' => 'varchar',
      'len' => 150,
      'source' => 'non-db',
    ),
    'shipping_address_street_3' => 
    array (
      'name' => 'shipping_address_street_3',
      'vname' => 'LBL_SHIPPING_ADDRESS_STREET_3',
      'type' => 'varchar',
      'len' => 150,
      'source' => 'non-db',
    ),
    'shipping_address_street_4' => 
    array (
      'name' => 'shipping_address_street_4',
      'vname' => 'LBL_SHIPPING_ADDRESS_STREET_4',
      'type' => 'varchar',
      'len' => 150,
      'source' => 'non-db',
    ),
    'shipping_address_city' => 
    array (
      'name' => 'shipping_address_city',
      'vname' => 'LBL_SHIPPING_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => 100,
      'group' => 'shipping_address',
      'comment' => 'The city used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_state' => 
    array (
      'name' => 'shipping_address_state',
      'vname' => 'LBL_SHIPPING_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => 100,
      'group' => 'shipping_address',
      'comment' => 'The state used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_postalcode' => 
    array (
      'name' => 'shipping_address_postalcode',
      'vname' => 'LBL_SHIPPING_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => 20,
      'group' => 'shipping_address',
      'comment' => 'The zip code used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_country' => 
    array (
      'name' => 'shipping_address_country',
      'vname' => 'LBL_SHIPPING_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'shipping_address',
      'comment' => 'The country used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'email1' => 
    array (
      'name' => 'email1',
      'vname' => 'LBL_EMAIL',
      'group' => 'email1',
      'type' => 'varchar',
      'function' => 
      array (
        'name' => 'getEmailAddressWidget',
        'returns' => 'html',
      ),
      'source' => 'non-db',
      'studio' => 
      array (
        'editField' => true,
        'searchview' => false,
      ),
      'full_text_search' => 
      array (
        'boost' => 3,
        'analyzer' => 'whitespace',
      ),
      'required' => false,
      'merge_filter' => 'disabled',
    ),
    'email_addresses_primary' => 
    array (
      'name' => 'email_addresses_primary',
      'type' => 'link',
      'relationship' => 'accounts_email_addresses_primary',
      'source' => 'non-db',
      'vname' => 'LBL_EMAIL_ADDRESS_PRIMARY',
      'duplicate_merge' => 'disabled',
      'studio' => 
      array (
        'formula' => false,
      ),
    ),
    'email_addresses' => 
    array (
      'name' => 'email_addresses',
      'type' => 'link',
      'relationship' => 'accounts_email_addresses',
      'source' => 'non-db',
      'vname' => 'LBL_EMAIL_ADDRESSES',
      'reportable' => false,
      'unified_search' => true,
      'rel_fields' => 
      array (
        'primary_address' => 
        array (
          'type' => 'bool',
        ),
      ),
      'studio' => 
      array (
        'formula' => false,
      ),
    ),
    'email_addresses_non_primary' => 
    array (
      'name' => 'email_addresses_non_primary',
      'type' => 'email',
      'source' => 'non-db',
      'vname' => 'LBL_EMAIL_NON_PRIMARY',
      'studio' => false,
      'reportable' => false,
      'massupdate' => false,
    ),
    'parent_id' => 
    array (
      'name' => 'parent_id',
      'vname' => 'LBL_PARENT_ACCOUNT_ID',
      'type' => 'id',
      'required' => false,
      'reportable' => false,
      'audited' => true,
      'comment' => 'Account ID of the parent of this account',
    ),
    'sic_code' => 
    array (
      'name' => 'sic_code',
      'vname' => 'LBL_SIC_CODE',
      'type' => 'varchar',
      'len' => 10,
      'comment' => 'SIC code of the account',
    ),
    'parent_name' => 
    array (
      'name' => 'parent_name',
      'rname' => 'name',
      'id_name' => 'parent_id',
      'vname' => 'LBL_MEMBER_OF',
      'type' => 'relate',
      'isnull' => 'true',
      'module' => 'Accounts',
      'table' => 'accounts',
      'massupdate' => false,
      'source' => 'non-db',
      'len' => 36,
      'link' => 'member_of',
      'unified_search' => true,
      'importable' => 'true',
    ),
    'members' => 
    array (
      'name' => 'members',
      'type' => 'link',
      'relationship' => 'member_accounts',
      'module' => 'Accounts',
      'bean_name' => 'Account',
      'source' => 'non-db',
      'vname' => 'LBL_MEMBERS',
    ),
    'member_of' => 
    array (
      'name' => 'member_of',
      'type' => 'link',
      'relationship' => 'member_accounts',
      'module' => 'Accounts',
      'bean_name' => 'Account',
      'link_type' => 'one',
      'source' => 'non-db',
      'vname' => 'LBL_MEMBER_OF',
      'side' => 'right',
    ),
    'email_opt_out' => 
    array (
      'name' => 'email_opt_out',
      'vname' => 'LBL_EMAIL_OPT_OUT',
      'source' => 'non-db',
      'type' => 'bool',
      'massupdate' => false,
      'studio' => 'false',
    ),
    'invalid_email' => 
    array (
      'name' => 'invalid_email',
      'vname' => 'LBL_INVALID_EMAIL',
      'source' => 'non-db',
      'type' => 'bool',
      'massupdate' => false,
      'studio' => 'false',
    ),
    'cases' => 
    array (
      'name' => 'cases',
      'type' => 'link',
      'relationship' => 'account_cases',
      'module' => 'Cases',
      'bean_name' => 'aCase',
      'source' => 'non-db',
      'vname' => 'LBL_CASES',
    ),
    'email' => 
    array (
      'name' => 'email',
      'type' => 'email',
      'query_type' => 'default',
      'source' => 'non-db',
      'operator' => 'subquery',
      'subquery' => 'SELECT eabr.bean_id FROM email_addr_bean_rel eabr JOIN email_addresses ea ON (ea.id = eabr.email_address_id) WHERE eabr.deleted=0 AND ea.email_address LIKE',
      'db_field' => 
      array (
        0 => 'id',
      ),
      'vname' => 'LBL_ANY_EMAIL',
      'studio' => 
      array (
        'visible' => false,
        'searchview' => true,
      ),
      'importable' => false,
    ),
    'tasks' => 
    array (
      'name' => 'tasks',
      'type' => 'link',
      'relationship' => 'account_tasks',
      'module' => 'Tasks',
      'bean_name' => 'Task',
      'source' => 'non-db',
      'vname' => 'LBL_TASKS',
    ),
    'notes' => 
    array (
      'name' => 'notes',
      'type' => 'link',
      'relationship' => 'account_notes',
      'module' => 'Notes',
      'bean_name' => 'Note',
      'source' => 'non-db',
      'vname' => 'LBL_NOTES',
    ),
    'meetings' => 
    array (
      'name' => 'meetings',
      'type' => 'link',
      'relationship' => 'account_meetings',
      'module' => 'Meetings',
      'bean_name' => 'Meeting',
      'source' => 'non-db',
      'vname' => 'LBL_MEETINGS',
    ),
    'calls' => 
    array (
      'name' => 'calls',
      'type' => 'link',
      'relationship' => 'account_calls',
      'module' => 'Calls',
      'bean_name' => 'Call',
      'source' => 'non-db',
      'vname' => 'LBL_CALLS',
    ),
    'emails' => 
    array (
      'name' => 'emails',
      'type' => 'link',
      'relationship' => 'emails_accounts_rel',
      'module' => 'Emails',
      'bean_name' => 'Email',
      'source' => 'non-db',
      'vname' => 'LBL_EMAILS',
      'studio' => 
      array (
        'formula' => false,
      ),
    ),
    'documents' => 
    array (
      'name' => 'documents',
      'type' => 'link',
      'relationship' => 'documents_accounts',
      'source' => 'non-db',
      'vname' => 'LBL_DOCUMENTS_SUBPANEL_TITLE',
    ),
    'bugs' => 
    array (
      'name' => 'bugs',
      'type' => 'link',
      'relationship' => 'accounts_bugs',
      'module' => 'Bugs',
      'bean_name' => 'Bug',
      'source' => 'non-db',
      'vname' => 'LBL_BUGS',
    ),
    'contacts' => 
    array (
      'name' => 'contacts',
      'type' => 'link',
      'relationship' => 'accounts_contacts',
      'module' => 'Contacts',
      'bean_name' => 'Contact',
      'source' => 'non-db',
      'vname' => 'LBL_CONTACTS',
    ),
    'opportunities' => 
    array (
      'name' => 'opportunities',
      'type' => 'link',
      'relationship' => 'accounts_opportunities',
      'module' => 'Opportunities',
      'bean_name' => 'Opportunity',
      'source' => 'non-db',
      'vname' => 'LBL_OPPORTUNITY',
    ),
    'project' => 
    array (
      'name' => 'project',
      'type' => 'link',
      'relationship' => 'projects_accounts',
      'module' => 'Project',
      'bean_name' => 'Project',
      'source' => 'non-db',
      'vname' => 'LBL_PROJECTS',
    ),
    'leads' => 
    array (
      'name' => 'leads',
      'type' => 'link',
      'relationship' => 'account_leads',
      'module' => 'Leads',
      'bean_name' => 'Lead',
      'source' => 'non-db',
      'vname' => 'LBL_LEADS',
    ),
    'campaigns' => 
    array (
      'name' => 'campaigns',
      'type' => 'link',
      'relationship' => 'account_campaign_log',
      'module' => 'CampaignLog',
      'bean_name' => 'CampaignLog',
      'source' => 'non-db',
      'vname' => 'LBL_CAMPAIGNLOG',
      'studio' => 
      array (
        'formula' => false,
      ),
    ),
    'campaign_accounts' => 
    array (
      'name' => 'campaign_accounts',
      'type' => 'link',
      'vname' => 'LBL_CAMPAIGNS',
      'relationship' => 'campaign_accounts',
      'source' => 'non-db',
    ),
    'campaign_id' => 
    array (
      'name' => 'campaign_id',
      'comment' => 'Campaign that generated Account',
      'vname' => 'LBL_CAMPAIGN_ID',
      'rname' => 'id',
      'id_name' => 'campaign_id',
      'type' => 'id',
      'table' => 'campaigns',
      'isnull' => 'true',
      'module' => 'Campaigns',
      'reportable' => false,
      'massupdate' => false,
      'duplicate_merge' => 'disabled',
    ),
    'campaign_name' => 
    array (
      'name' => 'campaign_name',
      'rname' => 'name',
      'vname' => 'LBL_CAMPAIGN',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'campaigns',
      'id_name' => 'campaign_id',
      'link' => 'campaign_accounts',
      'module' => 'Campaigns',
      'duplicate_merge' => 'disabled',
      'comment' => 'The first campaign name for Account (Meta-data only)',
    ),
    'prospect_lists' => 
    array (
      'name' => 'prospect_lists',
      'type' => 'link',
      'relationship' => 'prospect_list_accounts',
      'module' => 'ProspectLists',
      'source' => 'non-db',
      'vname' => 'LBL_PROSPECT_LIST',
    ),
    'saldo_crmdepsait_c' => 
    array (
      'labelValue' => 'Saldo en CRM',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'saldo_crmdepsait_c',
      'vname' => 'LBL_SALDO_CRMDEPSAIT',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'capture el saldo que tiene en  CRM',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountssaldo_crmdepsait_c',
      'custom_module' => 'Accounts',
    ),
    'observaciones_c' => 
    array (
      'labelValue' => 'Observaciones 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'observaciones_c',
      'vname' => 'LBL_OBSERVACIONES',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsobservaciones_c',
      'custom_module' => 'Accounts',
    ),
    'adeudo_cl_c' => 
    array (
      'labelValue' => 'adeudo CL',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'adeudo_cl_c',
      'vname' => 'ADEUDO CL',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'Accountsadeudo_cl_c',
      'custom_module' => 'Accounts',
    ),
    'venc_tc_c' => 
    array (
      'labelValue' => 'Vencimiento de TC',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'venc_tc_c',
      'vname' => 'LBL_VENC_TC',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'Accountsvenc_tc_c',
      'custom_module' => 'Accounts',
    ),
    'toma_de_contacto_c' => 
    array (
      'labelValue' => 'Toma de Contacto',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'toma_de_contacto_c',
      'vname' => 'LBL_TOMA_DE_CONTACTO',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => 'Aqui coloca 2',
      'help' => 'SELECCIONA EL ORIGEN DEL DEL CLIENTE',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'lead_source_dom',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountstoma_de_contacto_c',
      'custom_module' => 'Accounts',
    ),
    'tipocli_c' => 
    array (
      'labelValue' => 'Tipo',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'tipocli_c',
      'vname' => 'LBL_TIPOCLI',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'tipocli_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountstipocli_c',
      'custom_module' => 'Accounts',
    ),
    'cp_f_c' => 
    array (
      'labelValue' => 'CP f',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cp_f_c',
      'vname' => 'LBL_CP_F',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'Accountscp_f_c',
      'custom_module' => 'Accounts',
    ),
    'tiene_equipo_c' => 
    array (
      'labelValue' => 'tiene equipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tiene_equipo_c',
      'vname' => 'LBL_TIENE_EQUIPO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'tiene_equipo_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Accountstiene_equipo_c',
      'custom_module' => 'Accounts',
    ),
    'materno_c' => 
    array (
      'labelValue' => 'Materno',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'materno_c',
      'vname' => 'LBL_MATERNO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsmaterno_c',
      'custom_module' => 'Accounts',
    ),
    'rev_guevara_c' => 
    array (
      'labelValue' => 'Rev Guevara',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'rev_guevara_c',
      'vname' => 'LBL_REV_GUEVARA',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsrev_guevara_c',
      'custom_module' => 'Accounts',
    ),
    'pais_c' => 
    array (
      'labelValue' => 'Pais c',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pais_c',
      'vname' => 'LBL_PAIS',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => 'Mexico',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '120',
      'size' => '20',
      'id' => 'Accountspais_c',
      'custom_module' => 'Accounts',
    ),
    'aval2_direccion_c' => 
    array (
      'labelValue' => 'Aval2 Direccion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'aval2_direccion_c',
      'vname' => 'LBL_AVAL2_DIRECCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsaval2_direccion_c',
      'custom_module' => 'Accounts',
    ),
    'callenumero_c' => 
    array (
      'labelValue' => 'Calle c',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'callenumero_c',
      'vname' => 'LBL_CALLENUMERO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountscallenumero_c',
      'custom_module' => 'Accounts',
    ),
    'aval1_nombre_c' => 
    array (
      'labelValue' => 'Aval1 Nombre',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'aval1_nombre_c',
      'vname' => 'LBL_AVAL1_NOMBRE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '120',
      'size' => '20',
      'id' => 'Accountsaval1_nombre_c',
      'custom_module' => 'Accounts',
    ),
    'rev_nayeli_1_c' => 
    array (
      'labelValue' => 'Revicion Nay',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'rev_nayeli_1_c',
      'vname' => 'LBL_REV_NAYELI_1',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Rev_Nayely_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountsrev_nayeli_1_c',
      'custom_module' => 'Accounts',
    ),
    'en_depuracion_sait_c' => 
    array (
      'labelValue' => 'En Depuracion SAIT',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'en_depuracion_sait_c',
      'vname' => 'LBL_EN_DEPURACION_SAIT',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => ' seleccione si el cliente  entrara a la depuracion SAIT',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsen_depuracion_sait_c',
      'custom_module' => 'Accounts',
    ),
    'tesor_fech_limit__c' => 
    array (
      'options' => 'date_range_search_dom',
      'labelValue' => 'FECHA LIMITE PAGO',
      'enable_range_search' => '1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tesor_fech_limit__c',
      'vname' => 'LBL_TESOR_FECH_LIMIT_',
      'type' => 'date',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => 'FECHA LIMITE PARA REALIZAR EL PAGO',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'id' => 'Accountstesor_fech_limit__c',
      'custom_module' => 'Accounts',
    ),
    'obcervaccionesdepsait_c' => 
    array (
      'labelValue' => 'Obcervaccionesdepsait',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'obcervaccionesdepsait_c',
      'vname' => 'LBL_OBCERVACCIONESDEPSAIT',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'capture las Obcervaciones  de la depuracion ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'Accountsobcervaccionesdepsait_c',
      'custom_module' => 'Accounts',
    ),
    'fecha_de_nacimiento_c' => 
    array (
      'labelValue' => 'Fecha de Nacimiento',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_de_nacimiento_c',
      'vname' => 'LBL_FECHA_DE_NACIMIENTO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'SELECCIONA LA DECHA DE NACIMIENTO DEL CLIENTE  EN EL CALENDARIO  ( NO DIGITE LE FECHA',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'Accountsfecha_de_nacimiento_c',
      'custom_module' => 'Accounts',
    ),
    'cp_c' => 
    array (
      'labelValue' => 'CP c',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cp_c',
      'vname' => 'LBL_CP',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountscp_c',
      'custom_module' => 'Accounts',
    ),
    'tesor_datos_pago__c' => 
    array (
      'labelValue' => 'DATOS PARA PAGO',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tesor_datos_pago__c',
      'vname' => 'LBL_TESOR_DATOS_PAGO_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountstesor_datos_pago__c',
      'custom_module' => 'Accounts',
    ),
    'fecha_de_consulta_bc_c' => 
    array (
      'labelValue' => 'Fecha de Consulta BC',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_de_consulta_bc_c',
      'vname' => 'LBL_FECHA_DE_CONSULTA_BC',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'Accountsfecha_de_consulta_bc_c',
      'custom_module' => 'Accounts',
    ),
    'telefono2_c' => 
    array (
      'labelValue' => 'Telefono2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'telefono2_c',
      'vname' => 'LBL_TELEFONO2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURA SOLO LOS DIGITOS (Sin Espacios ni Signos ( (),-,/) Eje :55667788',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountstelefono2_c',
      'custom_module' => 'Accounts',
    ),
    'banco_tc_c' => 
    array (
      'labelValue' => 'Banco de la TC',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'banco_tc_c',
      'vname' => 'LBL_BANCO_TC',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsbanco_tc_c',
      'custom_module' => 'Accounts',
    ),
    'cod_seg_tc_c' => 
    array (
      'labelValue' => 'Codigo de Seguridad ',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cod_seg_tc_c',
      'vname' => 'LBL_COD_SEG_TC',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountscod_seg_tc_c',
      'custom_module' => 'Accounts',
    ),
    'ejecutivo_cobranza_c' => 
    array (
      'labelValue' => 'Cobrador',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ejecutivo_cobranza_c',
      'vname' => 'LBL_EJECUTIVO_COBRANZA',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAMPO RESERVADO PARA ADMINISTRACION (Aqui se asignara el ejecutivo de cobranza) ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Ejecutivo_CXC_lista',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountsejecutivo_cobranza_c',
      'custom_module' => 'Accounts',
    ),
    'gasto_tipo_c' => 
    array (
      'labelValue' => 'GASTO TIPO',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'gasto_tipo_c',
      'vname' => 'LBL_GASTO_TIPO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'GASTO_FIJO',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'TESOR_TIPO_GASTO_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Accountsgasto_tipo_c',
      'custom_module' => 'Accounts',
    ),
    'folio_de_consulta_bc_c' => 
    array (
      'labelValue' => 'Folio de Consulta BC',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'folio_de_consulta_bc_c',
      'vname' => 'LBL_FOLIO_DE_CONSULTA_BC',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsfolio_de_consulta_bc_c',
      'custom_module' => 'Accounts',
    ),
    'estado_c' => 
    array (
      'labelValue' => 'Estado C',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'estado_c',
      'vname' => 'LBL_ESTADO_C',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'SELECCIONA EL ESTADO',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'estado_c_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountsestado_c',
      'custom_module' => 'Accounts',
    ),
    'status_c' => 
    array (
      'labelValue' => 'Status del cliente',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'status_c',
      'vname' => 'LBL_STATUS',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAMPO RESERVADO PARA ADMINISTRACION (Estadistica)',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'status_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountsstatus_c',
      'custom_module' => 'Accounts',
    ),
    'ctipo_c' => 
    array (
      'labelValue' => 'CTIPO',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ctipo_c',
      'vname' => 'LBL_CTIPO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '30',
      'size' => '20',
      'id' => 'Accountsctipo_c',
      'custom_module' => 'Accounts',
    ),
    'agregar_a_e_mailing_c' => 
    array (
      'labelValue' => 'agregar a e-mailing',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'agregar_a_e_mailing_c',
      'vname' => 'LBL_AGREGAR_A_E_MAILING',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'seleccion la casilla para agregar al cliente en campa&ntilde;a de mailing',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsagregar_a_e_mailing_c',
      'custom_module' => 'Accounts',
    ),
    'fecha_firma_autorizacion_c' => 
    array (
      'labelValue' => 'Fecha Firma de Autorización de Solicitud de Reportes de Crédito',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_firma_autorizacion_c',
      'vname' => 'LBL_FECHA_FIRMA_AUTORIZACION',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'Accountsfecha_firma_autorizacion_c',
      'custom_module' => 'Accounts',
    ),
    'agend_25_c' => 
    array (
      'labelValue' => 'Agend 25',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'agend_25_c',
      'vname' => 'LBL_AGEND_25',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsagend_25_c',
      'custom_module' => 'Accounts',
    ),
    'usar_la_misma_direccion_c' => 
    array (
      'labelValue' => 'Usar la misma Dirección de Datos de Contacto',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'usar_la_misma_direccion_c',
      'vname' => 'LBL_USAR_LA_MISMA_DIRECCION',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccionando aqui; se copiaran los datos de la direccion que capturaste en los datos gen. del cliente solo captura "Razon Social","RFC" y "Email para envio de Factura" (Si los datos de facturacion no son los mismos deveras capturar los nuevos datos',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsusar_la_misma_direccion_c',
      'custom_module' => 'Accounts',
    ),
    'representante_legal_c' => 
    array (
      'labelValue' => 'Representante Legal',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'representante_legal_c',
      'vname' => 'LBL_REPRESENTANTE_LEGAL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsrepresentante_legal_c',
      'custom_module' => 'Accounts',
    ),
    'num_tc_c' => 
    array (
      'labelValue' => 'Num. Tarjeta de Crédito',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'num_tc_c',
      'vname' => 'LBL_NUM_TC',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '30',
      'size' => '20',
      'id' => 'Accountsnum_tc_c',
      'custom_module' => 'Accounts',
    ),
    'status_dep_sait_c' => 
    array (
      'labelValue' => 'status dep sait',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'status_dep_sait_c',
      'vname' => 'LBL_STATUS_DEP_SAIT',
      'type' => 'dynamicenum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Statud deen depuracion SAIR',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'depSait_list',
      'studio' => 'visible',
      'dbType' => 'enum',
      'parentenum' => '',
      'id' => 'Accountsstatus_dep_sait_c',
      'custom_module' => 'Accounts',
    ),
    'num_interior_c' => 
    array (
      'labelValue' => 'Num Interior c',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'num_interior_c',
      'vname' => 'LBL_NUM_INTERIOR',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '120',
      'size' => '20',
      'id' => 'Accountsnum_interior_c',
      'custom_module' => 'Accounts',
    ),
    'status_upside_c' => 
    array (
      'labelValue' => 'STATUS UPSIDE',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'status_upside_c',
      'vname' => 'LBL_STATUS_UPSIDE',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '10',
      'no_default' => false,
      'comments' => '',
      'help' => 'SELECCIONA  EL % DE POCIBILIDAD DE CIERRE ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ST_USIDE_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Accountsstatus_upside_c',
      'custom_module' => 'Accounts',
    ),
    'no_dep_excel_c' => 
    array (
      'labelValue' => 'no dep excel',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'no_dep_excel_c',
      'vname' => 'LBL_NO_DEP_EXCEL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsno_dep_excel_c',
      'custom_module' => 'Accounts',
    ),
    'lista_ciudad_c' => 
    array (
      'labelValue' => 'Ciudad_',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'lista_ciudad_c',
      'vname' => 'LBL_LISTA_CIUDAD',
      'type' => 'dynamicenum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'lista_ciudad_list',
      'studio' => 'visible',
      'dbType' => 'enum',
      'parentenum' => 'lista_estado_c',
      'id' => 'Accountslista_ciudad_c',
      'custom_module' => 'Accounts',
    ),
    'observaciones_2_c' => 
    array (
      'labelValue' => 'Observaciones',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'observaciones_2_c',
      'vname' => 'LBL_OBSERVACIONES_2',
      'type' => 'text',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURAR  INFORMACION  DEL CLIENTE , ALGUN DETALLE QUE LE SIVA  PARA  DER SEGUIMIENTO ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '2',
      'cols' => '40',
      'id' => 'Accountsobservaciones_2_c',
      'custom_module' => 'Accounts',
    ),
    'titulo_c' => 
    array (
      'labelValue' => 'titulo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'titulo_c',
      'vname' => 'LBL_TITULO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountstitulo_c',
      'custom_module' => 'Accounts',
    ),
    'x_rama_c' => 
    array (
      'labelValue' => 'X rama',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'x_rama_c',
      'vname' => 'LBL_X_RAMA',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => '17',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'evento_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountsx_rama_c',
      'custom_module' => 'Accounts',
    ),
    'anum_c' => 
    array (
      'labelValue' => 'ANUM',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'anum_c',
      'vname' => 'LBL_ANUM',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'id' => 'Accountsanum_c',
      'custom_module' => 'Accounts',
    ),
    'ciudad_c' => 
    array (
      'labelValue' => 'Ciudad / Delegación / Municipio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ciudad_c',
      'vname' => 'LBL_CIUDAD',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURA DATOS COMPLETOS  SEPARADOS POR COMAS (NO USAR ABREBIATURAS)',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsciudad_c',
      'custom_module' => 'Accounts',
    ),
    'telefono1_c' => 
    array (
      'labelValue' => 'Telefono1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'telefono1_c',
      'vname' => 'LBL_TELEFONO1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURA SOLO LOS DIGITOS (Sin Espacios ni Signos ( (),-,/) Eje :55667788',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountstelefono1_c',
      'custom_module' => 'Accounts',
    ),
    'aval2_nombre_c' => 
    array (
      'labelValue' => 'Aval2 Nombre',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'aval2_nombre_c',
      'vname' => 'LBL_AVAL2_NOMBRE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '130',
      'size' => '20',
      'id' => 'Accountsaval2_nombre_c',
      'custom_module' => 'Accounts',
    ),
    'nombre_c' => 
    array (
      'labelValue' => 'Nombre(s)',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'nombre_c',
      'vname' => 'LBL_NOMBRE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURA EL NOMBRE(S) DEL CLIENTE O CONTACTO',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsnombre_c',
      'custom_module' => 'Accounts',
    ),
    'problema_c' => 
    array (
      'labelValue' => 'Descripcion del Problema',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'problema_c',
      'vname' => 'LBL_PROBLEMA',
      'type' => 'text',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Describe cual es el problema pue presenta el problema',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'Accountsproblema_c',
      'custom_module' => 'Accounts',
    ),
    'liquodado_c' => 
    array (
      'labelValue' => 'Liquidado',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'liquodado_c',
      'vname' => 'LBL_LIQUODADO',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsliquodado_c',
      'custom_module' => 'Accounts',
    ),
    'tesor_agen_c_monto__c' => 
    array (
      'labelValue' => 'Agen c/monto',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tesor_agen_c_monto__c',
      'vname' => 'LBL_TESOR_AGEN_C_MONTO_',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountstesor_agen_c_monto__c',
      'custom_module' => 'Accounts',
    ),
    'rfc_c' => 
    array (
      'labelValue' => 'RFC',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'rfc_c',
      'vname' => 'LBL_RFC',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'SIN ESPACIOS NI GUIONES',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsrfc_c',
      'custom_module' => 'Accounts',
    ),
    'fecha_revicion_c' => 
    array (
      'labelValue' => 'fecha revicion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_revicion_c',
      'vname' => 'LBL_FECHA_REVICION',
      'type' => 'datetimecombo',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'Accountsfecha_revicion_c',
      'custom_module' => 'Accounts',
    ),
    'tesor_cta_pago__c' => 
    array (
      'labelValue' => 'CUENTA QUE PAGA',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tesor_cta_pago__c',
      'vname' => 'LBL_TESOR_CTA_PAGO_',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'TESOR_C_PAGO_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountstesor_cta_pago__c',
      'custom_module' => 'Accounts',
    ),
    'evento_c' => 
    array (
      'labelValue' => 'Evento No',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'evento_c',
      'vname' => 'LBL_EVENTO ',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsevento_c',
      'custom_module' => 'Accounts',
    ),
    'pasar_cliente_a_erp_c' => 
    array (
      'labelValue' => '¿Pasar Cliente a ERP?',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pasar_cliente_a_erp_c',
      'vname' => 'LBL_PASAR_CLIENTE_A_ERP',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => 'Habilita si el cliente se va a ERP',
      'help' => 'Habilita si el cliente se va a ERP',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountspasar_cliente_a_erp_c',
      'custom_module' => 'Accounts',
    ),
    'tesor_pago_presup__c' => 
    array (
      'options' => 'numeric_range_search_dom',
      'labelValue' => 'PAGO PRESUPUESTO',
      'enable_range_search' => '1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tesor_pago_presup__c',
      'vname' => 'LBL_TESOR_PAGO_PRESUP_',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => 'PAGO  PROMEDIO PRESSUPUESTADO',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'precision' => 6,
      'id' => 'Accountstesor_pago_presup__c',
      'custom_module' => 'Accounts',
    ),
    'tesor_dia_corte__c' => 
    array (
      'labelValue' => 'corte dia',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tesor_dia_corte__c',
      'vname' => 'LBL_TESOR_DIA_CORTE_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountstesor_dia_corte__c',
      'custom_module' => 'Accounts',
    ),
    'especialidad_1_c' => 
    array (
      'labelValue' => 'Especialidad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'especialidad_1_c',
      'vname' => 'LBL_ESPECIALIDAD_1',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Selecciona la especialidad del Dr.',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'E_list_ESPECIALIDAD',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountsespecialidad_1_c',
      'custom_module' => 'Accounts',
    ),
    'rev_20_c' => 
    array (
      'labelValue' => 'Rev 20',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'rev_20_c',
      'vname' => 'LBL_REV_20',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsrev_20_c',
      'custom_module' => 'Accounts',
    ),
    'anticipo_c' => 
    array (
      'labelValue' => 'Anticipo #',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'anticipo_c',
      'vname' => 'LBL_ANTICIPO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURAR EL # DEL ANTICIPO  ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsanticipo_c',
      'custom_module' => 'Accounts',
    ),
    'estado_f_c' => 
    array (
      'labelValue' => 'Estado F',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'estado_f_c',
      'vname' => 'LBL_ESTADO_F',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsestado_f_c',
      'custom_module' => 'Accounts',
    ),
    'estadov_c' => 
    array (
      'labelValue' => 'Estado*',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'estadov_c',
      'vname' => 'LBL_ESTADOV',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsestadov_c',
      'custom_module' => 'Accounts',
    ),
    'aos_quotes' => 
    array (
      'name' => 'aos_quotes',
      'type' => 'link',
      'relationship' => 'account_aos_quotes',
      'module' => 'AOS_Quotes',
      'bean_name' => 'AOS_Quotes',
      'source' => 'non-db',
    ),
    'aos_invoices' => 
    array (
      'name' => 'aos_invoices',
      'type' => 'link',
      'relationship' => 'account_aos_invoices',
      'module' => 'AOS_Invoices',
      'bean_name' => 'AOS_Invoices',
      'source' => 'non-db',
    ),
    'aos_contracts' => 
    array (
      'name' => 'aos_contracts',
      'type' => 'link',
      'relationship' => 'account_aos_contracts',
      'module' => 'AOS_Contracts',
      'bean_name' => 'AOS_Contracts',
      'source' => 'non-db',
    ),
    'accion_a_tomar1_c' => 
    array (
      'labelValue' => 'accion a tomar1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'accion_a_tomar1_c',
      'vname' => 'LBL_ACCION_A_TOMAR1',
      'type' => 'dynamicenum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Accion_a_Tomar_list',
      'studio' => 'visible',
      'dbType' => 'enum',
      'parentenum' => '',
      'id' => 'Accountsaccion_a_tomar1_c',
      'custom_module' => 'Accounts',
    ),
    'impuestos_c' => 
    array (
      'labelValue' => 'IMPUESTOS',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'impuestos_c',
      'vname' => 'IMPUESTOS',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'NO',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'impuestos_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Accountsimpuestos_c',
      'custom_module' => 'Accounts',
    ),
    'proceso_en_c' => 
    array (
      'labelValue' => 'Proceso en',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'proceso_en_c',
      'vname' => 'LBL_PROCESO_EN',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => 'SELECCIONAR EL PROCESO EN EL QUE SE ENCUENTRA EL CLIENTE',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Proces_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountsproceso_en_c',
      'custom_module' => 'Accounts',
    ),
    'evolucion_de_cierre_c' => 
    array (
      'labelValue' => 'evolucion de cierre',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'evolucion_de_cierre_c',
      'vname' => 'LBL_EVOLUCION_DE_CIERRE',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '0_sin_Contacto',
      'no_default' => false,
      'comments' => '',
      'help' => 'Seleccione  el porcentage de avance para el cierre de la venta',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'evolucion_a_cierre_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountsevolucion_de_cierre_c',
      'custom_module' => 'Accounts',
    ),
    'cliente_o_prospecto_c' => 
    array (
      'labelValue' => 'Cliente o prospecto',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cliente_o_prospecto_c',
      'vname' => 'LBL_CLIENTE_O_PROSPECTO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'prospecto',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'clente_o_prosp_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Accountscliente_o_prospecto_c',
      'custom_module' => 'Accounts',
    ),
    'cliente_sait__c' => 
    array (
      'labelValue' => 'Cliente Sait',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cliente_sait__c',
      'vname' => 'LBL_CLIENTE_SAIT_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'Numero de Cliente con el que esta regiatrado en  SAIT',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'Accountscliente_sait__c',
      'custom_module' => 'Accounts',
    ),
    'act_tesor_c' => 
    array (
      'labelValue' => 'act tesor',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'act_tesor_c',
      'vname' => 'LBL_ACT_TESOR',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsact_tesor_c',
      'custom_module' => 'Accounts',
    ),
    'es_distribuidor_c' => 
    array (
      'labelValue' => '¿Es Distribuidor?',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'es_distribuidor_c',
      'vname' => 'LBL_ES_DISTRIBUIDOR',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'No',
      'no_default' => false,
      'comments' => '',
      'help' => 'SELECCIONA SI ES DISTRIBUIDOR ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'si_no_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountses_distribuidor_c',
      'custom_module' => 'Accounts',
    ),
    'fecha_prob_cierre__c' => 
    array (
      'options' => 'date_range_search_dom',
      'labelValue' => 'fecha prob cierre',
      'enable_range_search' => '1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_prob_cierre__c',
      'vname' => 'LBL_FECHA_PROB_CIERRE_',
      'type' => 'date',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'id' => 'Accountsfecha_prob_cierre__c',
      'custom_module' => 'Accounts',
    ),
    'prob_sol_del_problem__c' => 
    array (
      'labelValue' => 'prob sol del problem',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'prob_sol_del_problem__c',
      'vname' => 'LBL_PROB_SOL_DEL_PROBLEM_',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'programar_curso_cap',
      'no_default' => false,
      'comments' => '',
      'help' => 'seleccione probable   solucion del problema',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'probable_solucion_del',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Accountsprob_sol_del_problem__c',
      'custom_module' => 'Accounts',
    ),
    'interesado_en_c' => 
    array (
      'labelValue' => 'Interesado en',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'interesado_en_c',
      'vname' => 'LBL_INTERESADO_EN',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'producto_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Accountsinteresado_en_c',
      'custom_module' => 'Accounts',
    ),
    'saldo_6sae_c' => 
    array (
      'labelValue' => 'Saldo en SAE 6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'saldo_6sae_c',
      'vname' => 'LBL_SALDO_6SAE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'capture el saldo que tiene en  SAE 6',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountssaldo_6sae_c',
      'custom_module' => 'Accounts',
    ),
    'revizar_tiene_errores_c' => 
    array (
      'labelValue' => 'revizar tiene errores',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'revizar_tiene_errores_c',
      'vname' => 'LBL_REVIZAR_TIENE_ERRORES ',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsrevizar_tiene_errores_c',
      'custom_module' => 'Accounts',
    ),
    'refer_bancaria_c' => 
    array (
      'labelValue' => 'Referencia Bancaria',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'refer_bancaria_c',
      'vname' => 'LBL_REFER_BANCARIA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'Accountsrefer_bancaria_c',
      'custom_module' => 'Accounts',
    ),
    'revizado_c' => 
    array (
      'labelValue' => 'revizado',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'revizado_c',
      'vname' => 'LBL_REVIZADO',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsrevizado_c',
      'custom_module' => 'Accounts',
    ),
    'ciudad_f_lista_c' => 
    array (
      'labelValue' => 'Ciudad f',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ciudad_f_lista_c',
      'vname' => 'LBL_CIUDAD_F_LISTA',
      'type' => 'dynamicenum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'lista_ciudad_list',
      'studio' => 'visible',
      'dbType' => 'enum',
      'parentenum' => 'estado_f_lista_c',
      'id' => 'Accountsciudad_f_lista_c',
      'custom_module' => 'Accounts',
    ),
    'proyecto_c' => 
    array (
      'labelValue' => 'participación en proyecto',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'proyecto_c',
      'vname' => 'LBL_PROYECTO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsproyecto_c',
      'custom_module' => 'Accounts',
    ),
    'tesor_dia_pago_limite_c' => 
    array (
      'labelValue' => 'DIA LIMITE PAGO',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tesor_dia_pago_limite_c',
      'vname' => 'LBL_TESOR_DIA_PAGO_LIMITE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountstesor_dia_pago_limite_c',
      'custom_module' => 'Accounts',
    ),
    'leads_accounts_1' => 
    array (
      'name' => 'leads_accounts_1',
      'type' => 'link',
      'relationship' => 'leads_accounts_1',
      'source' => 'non-db',
      'module' => 'Leads',
      'bean_name' => 'Lead',
      'vname' => 'LBL_LEADS_ACCOUNTS_1_FROM_LEADS_TITLE',
      'id_name' => 'leads_accounts_1leads_ida',
    ),
    'leads_accounts_1_name' => 
    array (
      'name' => 'leads_accounts_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_LEADS_ACCOUNTS_1_FROM_LEADS_TITLE',
      'save' => true,
      'id_name' => 'leads_accounts_1leads_ida',
      'link' => 'leads_accounts_1',
      'table' => 'leads',
      'module' => 'Leads',
      'rname' => 'name',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
    ),
    'leads_accounts_1leads_ida' => 
    array (
      'name' => 'leads_accounts_1leads_ida',
      'type' => 'link',
      'relationship' => 'leads_accounts_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_LEADS_ACCOUNTS_1_FROM_ACCOUNTS_TITLE',
    ),
    'freshdesk_tickets_list' => 
    array (
      'name' => 'freshdesk_tickets_list',
      'vname' => 'Freshdesk Tickets',
      'type' => 'html',
      'function' => 
      array (
        'name' => 'getTickets',
        'returns' => 'html',
        'include' => 'modules/freshdesk/TicketList.php',
      ),
      'len' => '6',
      'comment' => '',
      'source' => 'non-db',
      'studio' => 'visible',
    ),
    'alerta_cliente_c' => 
    array (
      'labelValue' => 'Alerta Cliente',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'alerta_cliente_c',
      'vname' => 'LBL_ALERTA_CLIENTE',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'SELECCIONAR  ALGUNA OPCION  EN CASO DE PROBLEMAS DE COBRANZA  PARA VENTAS POSTERIORES ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'alerta_1_cliente_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountsalerta_cliente_c',
      'custom_module' => 'Accounts',
    ),
    'nombre_conyuge_c' => 
    array (
      'labelValue' => 'Nombre(s) Conyuge',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'nombre_conyuge_c',
      'vname' => 'LBL_NOMBRE_CONYUGE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'Accountsnombre_conyuge_c',
      'custom_module' => 'Accounts',
    ),
    'saldo_5sae_c' => 
    array (
      'labelValue' => 'Saldo SAE 5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'saldo_5sae_c',
      'vname' => 'LBL_SALDO_5SAE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'capture el saldo que tiene en  SAE 5',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountssaldo_5sae_c',
      'custom_module' => 'Accounts',
    ),
    'enviado_el_c' => 
    array (
      'labelValue' => 'enviado el',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'enviado_el_c',
      'vname' => 'LBL_ENVIADO_EL',
      'type' => 'date',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'Accountsenviado_el_c',
      'custom_module' => 'Accounts',
    ),
    'razon_social_c' => 
    array (
      'labelValue' => '1 Razon Social',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'razon_social_c',
      'vname' => 'LBL_RAZON_SOCIAL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPURE A NOMBRE DE QUIEN SE EMITIRA LA FACTURA',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsrazon_social_c',
      'custom_module' => 'Accounts',
    ),
    'paterno_conyuge_c' => 
    array (
      'labelValue' => 'Paterno Conyuge',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'paterno_conyuge_c',
      'vname' => 'LBL_PATERNO_CONYUGE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '50',
      'size' => '20',
      'id' => 'Accountspaterno_conyuge_c',
      'custom_module' => 'Accounts',
    ),
    'aval1_direccion_c' => 
    array (
      'labelValue' => 'Aval1 Direccion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'aval1_direccion_c',
      'vname' => 'LBL_AVAL1_DIRECCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsaval1_direccion_c',
      'custom_module' => 'Accounts',
    ),
    'ciudad_f_c' => 
    array (
      'labelValue' => 'Ciudad F',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ciudad_f_c',
      'vname' => 'LBL_CIUDAD_F',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '120',
      'size' => '20',
      'id' => 'Accountsciudad_f_c',
      'custom_module' => 'Accounts',
    ),
    'autorizacion_para_c' => 
    array (
      'labelValue' => 'Autorizacion para',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'autorizacion_para_c',
      'vname' => 'LBL_AUTORIZACION_PARA',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'autorizacion_para_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Accountsautorizacion_para_c',
      'custom_module' => 'Accounts',
    ),
    'interesado_en_curso_c' => 
    array (
      'labelValue' => 'interesado en curso',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'interesado_en_curso_c',
      'vname' => 'LBL_INTERESADO_EN_CURSO',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsinteresado_en_curso_c',
      'custom_module' => 'Accounts',
    ),
    'colonia_c' => 
    array (
      'labelValue' => 'Colonia c',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'colonia_c',
      'vname' => 'LBL_COLONIA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '140',
      'size' => '20',
      'id' => 'Accountscolonia_c',
      'custom_module' => 'Accounts',
    ),
    'lada1_c' => 
    array (
      'labelValue' => 'Lada1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'lada1_c',
      'vname' => 'LBL_LADA1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURA SOLO LOS DIGITOS ( Sin Espacios ni Signos ( (),-,/) Eje : 777',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountslada1_c',
      'custom_module' => 'Accounts',
    ),
    'calle_y_numero_f_c' => 
    array (
      'labelValue' => 'Calle. f',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'calle_y_numero_f_c',
      'vname' => 'LBL_CALLE_Y_NUMERO_F',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '200',
      'size' => '20',
      'id' => 'Accountscalle_y_numero_f_c',
      'custom_module' => 'Accounts',
    ),
    'lada2_c' => 
    array (
      'labelValue' => 'Lada2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'lada2_c',
      'vname' => 'LBL_LADA2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURA SOLO LOS DIGITOS (Sin Espacios ni Signos ( (),-,/) Eje : 777',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'Accountslada2_c',
      'custom_module' => 'Accounts',
    ),
    'en_cartera_vencida_c' => 
    array (
      'labelValue' => 'en cartera vencida',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'en_cartera_vencida_c',
      'vname' => 'LBL_EN_CARTERA_VENCIDA',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsen_cartera_vencida_c',
      'custom_module' => 'Accounts',
    ),
    'prob_con_seg_c' => 
    array (
      'labelValue' => 'Prob con Seg',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'prob_con_seg_c',
      'vname' => 'LBL_PROB_CON_SEG',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'SELECCIONADO SIGNIFICA QUE  EL PROBLEMA YA ESTA SIENDO ATENDIDO',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsprob_con_seg_c',
      'custom_module' => 'Accounts',
    ),
    'folio_de_ife_c' => 
    array (
      'labelValue' => 'Folio de Credencial de Elector INE',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'folio_de_ife_c',
      'vname' => 'LBL_FOLIO_DE_IFE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURA SOLO LOS DIGITOS (Sin Espacios ni Signos ( (),-,/)',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsfolio_de_ife_c',
      'custom_module' => 'Accounts',
    ),
    'status_de_actualizacion_c' => 
    array (
      'labelValue' => 'Status Actualizacion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'status_de_actualizacion_c',
      'vname' => 'LBL_STATUS_DE_ACTUALIZACION',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAMPO RESERVADO PARA ADMINISTRACION (Estadistica)',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Elastic_boost_options',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountsstatus_de_actualizacion_c',
      'custom_module' => 'Accounts',
    ),
    'teror_agen_hasta_c' => 
    array (
      'options' => 'date_range_search_dom',
      'labelValue' => 'AGENDADO HASTA',
      'enable_range_search' => '1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'teror_agen_hasta_c',
      'vname' => 'LBL_TEROR_AGEN_HASTA',
      'type' => 'date',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'id' => 'Accountsteror_agen_hasta_c',
      'custom_module' => 'Accounts',
    ),
    'con_anticipo_c' => 
    array (
      'labelValue' => 'Con Anticipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'con_anticipo_c',
      'vname' => 'LBL_CON_ANTICIPO',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'SELECCIONADO SIGNIFICA QUE ELCLIENTE  DEJO UN ANTICIPO ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountscon_anticipo_c',
      'custom_module' => 'Accounts',
    ),
    'num_interior_f_c' => 
    array (
      'labelValue' => '# Interior f',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'num_interior_f_c',
      'vname' => 'LBL_NUM_INTERIOR_F',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '120',
      'size' => '20',
      'id' => 'Accountsnum_interior_f_c',
      'custom_module' => 'Accounts',
    ),
    'vendido_por_c' => 
    array (
      'labelValue' => 'Vendido por',
      'required' => false,
      'source' => 'non-db',
      'name' => 'vendido_por_c',
      'vname' => 'LBL_VENDIDO_POR',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'user_id1_c',
      'ext2' => 'Users',
      'module' => 'Users',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'Accountsvendido_por_c',
      'custom_module' => 'Accounts',
    ),
    'periodicidad_c' => 
    array (
      'labelValue' => 'PERIODICIDAD',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'periodicidad_c',
      'vname' => 'LBL_PERIODICIDAD',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'SEMANAL',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'TESOR_PERIOD_Pago_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Accountsperiodicidad_c',
      'custom_module' => 'Accounts',
    ),
    'pais_f_c' => 
    array (
      'labelValue' => 'Pais f',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pais_f_c',
      'vname' => 'LBL_PAIS_F',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => 'MEXICO',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountspais_f_c',
      'custom_module' => 'Accounts',
    ),
    'materno_conyuge_c' => 
    array (
      'labelValue' => 'Materno Conyuge',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'materno_conyuge_c',
      'vname' => 'LBL_MATERNO_CONYUGE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsmaterno_conyuge_c',
      'custom_module' => 'Accounts',
    ),
    'agend_20_c' => 
    array (
      'labelValue' => 'agend 20',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'agend_20_c',
      'vname' => 'LBL_AGEND_20',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsagend_20_c',
      'custom_module' => 'Accounts',
    ),
    'num_exterior_f_c' => 
    array (
      'labelValue' => '# Exterior f',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'num_exterior_f_c',
      'vname' => 'LBL_NUM_EXTERIOR_F',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '120',
      'size' => '20',
      'id' => 'Accountsnum_exterior_f_c',
      'custom_module' => 'Accounts',
    ),
    'en_ventas_c' => 
    array (
      'labelValue' => 'En Ventas',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'en_ventas_c',
      'vname' => 'LBL_EN_VENTAS',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsen_ventas_c',
      'custom_module' => 'Accounts',
    ),
    'linea_c' => 
    array (
      'labelValue' => 'Linea',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'linea_c',
      'vname' => 'LBL_LINEA',
      'type' => 'multienum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'options' => 'linea_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
      'id' => 'Accountslinea_c',
      'custom_module' => 'Accounts',
    ),
    'cursc_c' => 
    array (
      'labelValue' => 'INTERESADO EN CURSO DE',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cursc_c',
      'vname' => 'LBL_CURSC',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'curso_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountscursc_c',
      'custom_module' => 'Accounts',
    ),
    'status_actuliz_01_18_c' => 
    array (
      'labelValue' => 'status actuliz 01 18',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'status_actuliz_01_18_c',
      'vname' => 'LBL_STATUS_ACTULIZ_01_18',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsstatus_actuliz_01_18_c',
      'custom_module' => 'Accounts',
    ),
    'esta_entregado_c' => 
    array (
      'labelValue' => 'Esta entregado',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'esta_entregado_c',
      'vname' => 'LBL_ESTA_ENTREGADO',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'SELECCIONADO SIGNIFICA QUE EL EQUIPO SE LE ENTREGO AL CLIENTE ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsesta_entregado_c',
      'custom_module' => 'Accounts',
    ),
    'agendado_2018_mary_c' => 
    array (
      'labelValue' => 'agendado 2018 mary',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'agendado_2018_mary_c',
      'vname' => 'LBL_AGENDADO_2018_MARY',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsagendado_2018_mary_c',
      'custom_module' => 'Accounts',
    ),
    'depuracion_cobranz_2018_c' => 
    array (
      'labelValue' => 'depuracion cobranz 2018',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'depuracion_cobranz_2018_c',
      'vname' => 'LBL_DEPURACION_COBRANZ_2018',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsdepuracion_cobranz_2018_c',
      'custom_module' => 'Accounts',
    ),
    'email_f_c' => 
    array (
      'labelValue' => 'Email para envío de Facturas',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'email_f_c',
      'vname' => 'LBL_EMAIL_F',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURE EL E-MAIL PARA ENVIAR LA FACTURA',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsemail_f_c',
      'custom_module' => 'Accounts',
    ),
    'no_client_sae6_c' => 
    array (
      'labelValue' => 'No SAE 6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'no_client_sae6_c',
      'vname' => 'LBL_NO_CLIENT_SAE6',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Digite el numero del cliente  en SAE 6 si eta duplicado digite todos los nimeros y separelos con una coma',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsno_client_sae6_c',
      'custom_module' => 'Accounts',
    ),
    'paterno_c' => 
    array (
      'labelValue' => 'Paterno',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'paterno_c',
      'vname' => 'LBL_PATERNO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountspaterno_c',
      'custom_module' => 'Accounts',
    ),
    'accounts_pagos_pagos_de_clientes_1' => 
    array (
      'name' => 'accounts_pagos_pagos_de_clientes_1',
      'type' => 'link',
      'relationship' => 'accounts_pagos_pagos_de_clientes_1',
      'source' => 'non-db',
      'module' => 'Pagos_Pagos_de_Clientes',
      'bean_name' => 'Pagos_Pagos_de_Clientes',
      'side' => 'right',
      'vname' => 'LBL_ACCOUNTS_PAGOS_PAGOS_DE_CLIENTES_1_FROM_PAGOS_PAGOS_DE_CLIENTES_TITLE',
    ),
    'curp_c' => 
    array (
      'labelValue' => 'CURP',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'curp_c',
      'vname' => 'LBL_CURP',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURA EL CURP SIN ESPACIOS NI GUIONES',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountscurp_c',
      'custom_module' => 'Accounts',
    ),
    'tipo_gasto__c' => 
    array (
      'labelValue' => 'tipo gasto',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tipo_gasto__c',
      'vname' => 'LBL_TIPO_GASTO_',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'tipo_gasto_cxp_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountstipo_gasto__c',
      'custom_module' => 'Accounts',
    ),
    'especialidad_c' => 
    array (
      'labelValue' => 'Especialidad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'especialidad_c',
      'vname' => 'LBL_ESPECIALIDAD',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsespecialidad_c',
      'custom_module' => 'Accounts',
    ),
    'observ_dep_cobranza_2018_c' => 
    array (
      'labelValue' => 'observ dep cobranza 2018',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'observ_dep_cobranza_2018_c',
      'vname' => 'LBL_OBSERV_DEP_COBRANZA_2018',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'Accountsobserv_dep_cobranza_2018_c',
      'custom_module' => 'Accounts',
    ),
    'celular_c' => 
    array (
      'labelValue' => 'Celular',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'celular_c',
      'vname' => 'LBL_CELULAR',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURA SOLO LOS DIGITOS (Sin Espacios ni Signos ( (),-,/) Eje :55667788',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '40',
      'size' => '20',
      'id' => 'Accountscelular_c',
      'custom_module' => 'Accounts',
    ),
    'accounts_calls_1' => 
    array (
      'name' => 'accounts_calls_1',
      'type' => 'link',
      'relationship' => 'accounts_calls_1',
      'source' => 'non-db',
      'module' => 'Calls',
      'bean_name' => 'Call',
      'side' => 'right',
      'vname' => 'LBL_ACCOUNTS_CALLS_1_FROM_CALLS_TITLE',
    ),
    'rev_mary_c' => 
    array (
      'labelValue' => 'rev mary',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'rev_mary_c',
      'vname' => 'LBL_REV_MARY',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsrev_mary_c',
      'custom_module' => 'Accounts',
    ),
    'ciudad_txt_c' => 
    array (
      'labelValue' => 'ciudad txt',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ciudad_txt_c',
      'vname' => 'LBL_CIUDAD_TXT',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsciudad_txt_c',
      'custom_module' => 'Accounts',
    ),
    'ciudad_f_txt_c' => 
    array (
      'labelValue' => 'ciudad f txt',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ciudad_f_txt_c',
      'vname' => 'LBL_CIUDAD_F_TXT',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsciudad_f_txt_c',
      'custom_module' => 'Accounts',
    ),
    'tesor_deudor_c' => 
    array (
      'labelValue' => 'DEUDOR',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tesor_deudor_c',
      'vname' => 'LBL_TESOR_DEUDOR',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'TESOR_DEUDOR_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Accountstesor_deudor_c',
      'custom_module' => 'Accounts',
    ),
    'accounts_inf_informacionc_1' => 
    array (
      'name' => 'accounts_inf_informacionc_1',
      'type' => 'link',
      'relationship' => 'accounts_inf_informacionc_1',
      'source' => 'non-db',
      'module' => 'INF_InformacionC',
      'bean_name' => 'INF_InformacionC',
      'side' => 'right',
      'vname' => 'LBL_ACCOUNTS_INF_INFORMACIONC_1_FROM_INF_INFORMACIONC_TITLE',
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_accounts',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'observaciones_3_c' => 
    array (
      'labelValue' => 'observaciones 3 c',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'observaciones_3_c',
      'vname' => 'LBL_OBSERVACIONES_3_C',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'Accountsobservaciones_3_c',
      'custom_module' => 'Accounts',
    ),
    'observ_rev_mary_c' => 
    array (
      'labelValue' => 'observ rev mary',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'observ_rev_mary_c',
      'vname' => 'LBL_OBSERV_REV_MARY',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'Accountsobserv_rev_mary_c',
      'custom_module' => 'Accounts',
    ),
    'alcald_municipio_c' => 
    array (
      'labelValue' => 'alcald municipio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'alcald_municipio_c',
      'vname' => 'LBL_ALCALD_MUNICIPIO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsalcald_municipio_c',
      'custom_module' => 'Accounts',
    ),
    'rrrrrrama_c' => 
    array (
      'labelValue' => 'RRRRRRama',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'rrrrrrama_c',
      'vname' => '*_RRRRRRAMA',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Accion_a_Tomar_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Accountsrrrrrrama_c',
      'custom_module' => 'Accounts',
    ),
    'cliente_export_v_c' => 
    array (
      'labelValue' => 'Cliente exportado a Vtiger',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cliente_export_v_c',
      'vname' => 'LBL_CLIENTE_EXPORT_V',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountscliente_export_v_c',
      'custom_module' => 'Accounts',
    ),
    'nextel_c' => 
    array (
      'labelValue' => 'Nextel',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'nextel_c',
      'vname' => 'LBL_NEXTEL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURA SOLO LOS DIGITOS (Sin Espacios ni Signos ( (),-,/) Eje :55667788',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsnextel_c',
      'custom_module' => 'Accounts',
    ),
    'num_exterior_c' => 
    array (
      'labelValue' => 'Num Exterior c',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'num_exterior_c',
      'vname' => 'LBL_NUM_EXTERIOR',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '120',
      'size' => '20',
      'id' => 'Accountsnum_exterior_c',
      'custom_module' => 'Accounts',
    ),
    'colonia_f_c' => 
    array (
      'labelValue' => 'Colonia f',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'colonia_f_c',
      'vname' => 'LBL_COLONIA_F',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'Accountscolonia_f_c',
      'custom_module' => 'Accounts',
    ),
    'accounts_anti_anticipos_1' => 
    array (
      'name' => 'accounts_anti_anticipos_1',
      'type' => 'link',
      'relationship' => 'accounts_anti_anticipos_1',
      'source' => 'non-db',
      'module' => 'ANTI_Anticipos',
      'bean_name' => 'ANTI_Anticipos',
      'side' => 'right',
      'vname' => 'LBL_ACCOUNTS_ANTI_ANTICIPOS_1_FROM_ANTI_ANTICIPOS_TITLE',
    ),
    'depuracion_gevara_c' => 
    array (
      'labelValue' => 'Depuracion gevara',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'depuracion_gevara_c',
      'vname' => 'LBL_DEPURACION_GEVARA',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'depuracion',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountsdepuracion_gevara_c',
      'custom_module' => 'Accounts',
    ),
    'distribuidor_c' => 
    array (
      'labelValue' => 'Distribuidor',
      'required' => false,
      'source' => 'non-db',
      'name' => 'distribuidor_c',
      'vname' => 'LBL_DISTRIBUIDOR',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'account_id_c',
      'ext2' => 'Accounts',
      'module' => 'Accounts',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'Accountsdistribuidor_c',
      'custom_module' => 'Accounts',
    ),
    'en_cobranza_c' => 
    array (
      'labelValue' => 'En cobranza',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'en_cobranza_c',
      'vname' => 'LBL_EN_COBRANZA',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsen_cobranza_c',
      'custom_module' => 'Accounts',
    ),
    'demostracion_c' => 
    array (
      'labelValue' => 'demostracion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'demostracion_c',
      'vname' => 'LBL_DEMOSTRACION',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsdemostracion_c',
      'custom_module' => 'Accounts',
    ),
    'estado_f_lista_c' => 
    array (
      'labelValue' => 'Estado f',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'estado_f_lista_c',
      'vname' => 'LBL_ESTADO_F_LISTA',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'lista_estado_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountsestado_f_lista_c',
      'custom_module' => 'Accounts',
    ),
    'no_client_sae5_c' => 
    array (
      'labelValue' => 'No SAE 5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'no_client_sae5_c',
      'vname' => 'LBL_NO_CLIENT_SAE5',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'Digite el Numero que tiene el cliente en SAE 5, sieata duplicado  separe los numeros con una coma',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsno_client_sae5_c',
      'custom_module' => 'Accounts',
    ),
    'engan_enganches_accounts' => 
    array (
      'name' => 'engan_enganches_accounts',
      'type' => 'link',
      'relationship' => 'engan_enganches_accounts',
      'source' => 'non-db',
      'module' => 'Engan_Enganches',
      'bean_name' => false,
      'side' => 'right',
      'vname' => 'LBL_ENGAN_ENGANCHES_ACCOUNTS_FROM_ENGAN_ENGANCHES_TITLE',
    ),
    'delegacion_c' => 
    array (
      'labelValue' => 'Delegación / Ciudad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'delegacion_c',
      'vname' => 'LBL_DELEGACION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURA  NOMBRES COMPLETOS  SEPARADOS POR COMAS) No uses abrebiaciones )',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsdelegacion_c',
      'custom_module' => 'Accounts',
    ),
    'upside_c' => 
    array (
      'options' => 'numeric_range_search_dom',
      'labelValue' => 'UPSIDE',
      'enable_range_search' => '1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'upside_c',
      'vname' => 'LBL_UPSIDE',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'TECLEA EL VALOR DE LA oPORTUNIDAD EN PESOS ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'precision' => 6,
      'id' => 'Accountsupside_c',
      'custom_module' => 'Accounts',
    ),
    'lista_estado_c' => 
    array (
      'labelValue' => 'Estado_',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'lista_estado_c',
      'vname' => 'LBL_LISTA_ESTADO',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => 'Seleccione la entidad federativa del cliente',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'lista_estado_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Accountslista_estado_c',
      'custom_module' => 'Accounts',
    ),
    'account_id_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'account_id_c',
      'vname' => 'LBL_DISTRIBUIDOR_ACCOUNT_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'Accountsaccount_id_c',
      'custom_module' => 'Accounts',
    ),
    'currency_id' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'currency_id',
      'vname' => 'LBL_CURRENCY',
      'type' => 'currency_id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'dbType' => 'id',
      'studio' => 'visible',
      'function' => 
      array (
        'name' => 'getCurrencyDropDown',
        'returns' => 'html',
      ),
      'id' => 'Accountscurrency_id',
      'custom_module' => 'Accounts',
    ),
    'rev_ag_efb_nov_23_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'rev_ag_efb_nov_23_c',
      'vname' => 'LBL_REV_AG_EFB_NOV_23',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Accountsrev_ag_efb_nov_23_c',
      'custom_module' => 'Accounts',
    ),
    'user_id1_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'user_id1_c',
      'vname' => 'LBL_VENDIDO_POR_USER_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'Accountsuser_id1_c',
      'custom_module' => 'Accounts',
    ),
  ),
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'accountspk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
    0 => 
    array (
      'name' => 'idx_accnt_id_del',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'id',
        1 => 'deleted',
      ),
    ),
    1 => 
    array (
      'name' => 'idx_accnt_name_del',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'name',
        1 => 'deleted',
      ),
    ),
    2 => 
    array (
      'name' => 'idx_accnt_assigned_del',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'deleted',
        1 => 'assigned_user_id',
      ),
    ),
    3 => 
    array (
      'name' => 'idx_accnt_parent_id',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'parent_id',
      ),
    ),
  ),
  'relationships' => 
  array (
    'accounts_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Accounts',
      'rhs_table' => 'accounts',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'accounts_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Accounts',
      'rhs_table' => 'accounts',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'accounts_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Accounts',
      'rhs_table' => 'accounts',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'accounts_email_addresses' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'EmailAddresses',
      'rhs_table' => 'email_addresses',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'email_addr_bean_rel',
      'join_key_lhs' => 'bean_id',
      'join_key_rhs' => 'email_address_id',
      'relationship_role_column' => 'bean_module',
      'relationship_role_column_value' => 'Accounts',
    ),
    'accounts_email_addresses_primary' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'EmailAddresses',
      'rhs_table' => 'email_addresses',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'email_addr_bean_rel',
      'join_key_lhs' => 'bean_id',
      'join_key_rhs' => 'email_address_id',
      'relationship_role_column' => 'primary_address',
      'relationship_role_column_value' => '1',
    ),
    'member_accounts' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'Accounts',
      'rhs_table' => 'accounts',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
    ),
    'account_cases' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'Cases',
      'rhs_table' => 'cases',
      'rhs_key' => 'account_id',
      'relationship_type' => 'one-to-many',
    ),
    'account_tasks' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'Tasks',
      'rhs_table' => 'tasks',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Accounts',
    ),
    'account_notes' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'Notes',
      'rhs_table' => 'notes',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Accounts',
    ),
    'account_meetings' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'Meetings',
      'rhs_table' => 'meetings',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Accounts',
    ),
    'account_calls' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'Calls',
      'rhs_table' => 'calls',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Accounts',
    ),
    'account_emails' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'Emails',
      'rhs_table' => 'emails',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Accounts',
    ),
    'account_leads' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'Leads',
      'rhs_table' => 'leads',
      'rhs_key' => 'account_id',
      'relationship_type' => 'one-to-many',
    ),
    'account_campaign_log' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'CampaignLog',
      'rhs_table' => 'campaign_log',
      'rhs_key' => 'target_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'target_type',
      'relationship_role_column_value' => 'Accounts',
    ),
    'account_aos_quotes' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Quotes',
      'rhs_table' => 'aos_quotes',
      'rhs_key' => 'billing_account_id',
      'relationship_type' => 'one-to-many',
    ),
    'account_aos_invoices' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Invoices',
      'rhs_table' => 'aos_invoices',
      'rhs_key' => 'billing_account_id',
      'relationship_type' => 'one-to-many',
    ),
    'account_aos_contracts' => 
    array (
      'lhs_module' => 'Accounts',
      'lhs_table' => 'accounts',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Contracts',
      'rhs_table' => 'aos_contracts',
      'rhs_key' => 'contract_account_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_locking' => true,
  'templates' => 
  array (
    'company' => 'company',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);