<?php 
 $GLOBALS["dictionary"]["AOS_Invoices"]=array (
  'table' => 'aos_invoices',
  'audited' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'unified_search' => false,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'required' => false,
      'importable' => 'required',
      'duplicate_merge' => 'enabled',
      'merge_filter' => 'disabled',
      'help' => 'CAPTURA EL FOLIO DE LA ORDEN FISICA QUE LLENASTE',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => '7',
      'cols' => '40',
      'default' => 'Plan 0:Serie XX',
      'comments' => 'Full text of the note',
      'merge_filter' => 'disabled',
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'aos_invoices_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'aos_invoices_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'aos_invoices_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'billing_account_id' => 
    array (
      'required' => false,
      'name' => 'billing_account_id',
      'vname' => '',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => 0,
      'reportable' => 0,
      'len' => 36,
    ),
    'billing_account' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'billing_account',
      'vname' => 'LBL_BILLING_ACCOUNT',
      'type' => 'relate',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => 1,
      'len' => '255',
      'id_name' => 'billing_account_id',
      'ext2' => 'Accounts',
      'module' => 'Accounts',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'billing_contact_id' => 
    array (
      'required' => false,
      'name' => 'billing_contact_id',
      'vname' => '',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => 0,
      'reportable' => 0,
      'len' => 36,
    ),
    'billing_contact' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'billing_contact',
      'vname' => 'LBL_BILLING_CONTACT',
      'type' => 'relate',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => 1,
      'len' => '255',
      'id_name' => 'billing_contact_id',
      'ext2' => 'Contacts',
      'module' => 'Contacts',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'billing_address_street' => 
    array (
      'name' => 'billing_address_street',
      'vname' => 'LBL_BILLING_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => '150',
      'comment' => 'The street address used for billing address',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_city' => 
    array (
      'name' => 'billing_address_city',
      'vname' => 'LBL_BILLING_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => '100',
      'comment' => 'The city used for billing address',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_state' => 
    array (
      'name' => 'billing_address_state',
      'vname' => 'LBL_BILLING_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => '100',
      'group' => 'billing_address',
      'comment' => 'The state used for billing address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_postalcode' => 
    array (
      'name' => 'billing_address_postalcode',
      'vname' => 'LBL_BILLING_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => '20',
      'group' => 'billing_address',
      'comment' => 'The postal code used for billing address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_country' => 
    array (
      'name' => 'billing_address_country',
      'vname' => 'LBL_BILLING_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'billing_address',
      'comment' => 'The country used for the billing address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_street' => 
    array (
      'name' => 'shipping_address_street',
      'vname' => 'LBL_SHIPPING_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => 150,
      'group' => 'shipping_address',
      'comment' => 'The street address used for for shipping purposes',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_city' => 
    array (
      'name' => 'shipping_address_city',
      'vname' => 'LBL_SHIPPING_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => 100,
      'group' => 'shipping_address',
      'comment' => 'The city used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_state' => 
    array (
      'name' => 'shipping_address_state',
      'vname' => 'LBL_SHIPPING_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => 100,
      'group' => 'shipping_address',
      'comment' => 'The state used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_postalcode' => 
    array (
      'name' => 'shipping_address_postalcode',
      'vname' => 'LBL_SHIPPING_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => 20,
      'group' => 'shipping_address',
      'comment' => 'The zip code used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_country' => 
    array (
      'name' => 'shipping_address_country',
      'vname' => 'LBL_SHIPPING_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'shipping_address',
      'comment' => 'The country used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'number' => 
    array (
      'required' => true,
      'name' => 'number',
      'vname' => 'LBL_INVOICE_NUMBER',
      'type' => 'int',
      'len' => 11,
      'isnull' => 'false',
      'unified_search' => true,
      'comments' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'reportable' => true,
      'disable_num_format' => true,
    ),
    'line_items' => 
    array (
      'required' => false,
      'name' => 'line_items',
      'vname' => 'LBL_LINE_ITEMS',
      'type' => 'function',
      'source' => 'non-db',
      'massupdate' => 0,
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => false,
      'function' => 
      array (
        'name' => 'display_lines',
        'returns' => 'html',
        'include' => 'modules/AOS_Products_Quotes/Line_Items.php',
      ),
    ),
    'total_amt' => 
    array (
      'required' => false,
      'name' => 'total_amt',
      'vname' => 'LBL_TOTAL_AMT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
      'merge_filter' => 'disabled',
      'enable_range_search' => false,
    ),
    'total_amt_usdollar' => 
    array (
      'name' => 'total_amt_usdollar',
      'vname' => 'LBL_TOTAL_AMT_USDOLLAR',
      'type' => 'currency',
      'group' => 'total_amt',
      'disable_num_format' => true,
      'duplicate_merge' => 'disabled',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
      'duplicate_merge_dom_value' => '0',
      'merge_filter' => 'disabled',
      'enable_range_search' => false,
    ),
    'subtotal_amount' => 
    array (
      'required' => false,
      'name' => 'subtotal_amount',
      'vname' => 'LBL_SUBTOTAL_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'subtotal_amount_usdollar' => 
    array (
      'name' => 'subtotal_amount_usdollar',
      'vname' => 'LBL_SUBTOTAL_AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'subtotal_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => 'Formatted amount of the opportunity',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'discount_amount' => 
    array (
      'required' => false,
      'name' => 'discount_amount',
      'vname' => 'LBL_DISCOUNT_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'discount_amount_usdollar' => 
    array (
      'name' => 'discount_amount_usdollar',
      'vname' => 'LBL_DISCOUNT__AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'discount_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'tax_amount' => 
    array (
      'required' => false,
      'name' => 'tax_amount',
      'vname' => 'LBL_TAX_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'tax_amount_usdollar' => 
    array (
      'name' => 'tax_amount_usdollar',
      'vname' => 'LBL_TAX_AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'tax_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'shipping_amount' => 
    array (
      'required' => false,
      'name' => 'shipping_amount',
      'vname' => 'LBL_SHIPPING_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'len' => '26,6',
    ),
    'shipping_amount_usdollar' => 
    array (
      'name' => 'shipping_amount_usdollar',
      'vname' => 'LBL_SHIPPING_AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'shipping_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'shipping_tax' => 
    array (
      'required' => false,
      'name' => 'shipping_tax',
      'vname' => 'LBL_SHIPPING_TAX',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'len' => 100,
      'options' => 'vat_list',
      'studio' => 'visible',
    ),
    'shipping_tax_amt' => 
    array (
      'required' => false,
      'name' => 'shipping_tax_amt',
      'vname' => 'LBL_SHIPPING_TAX_AMT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'len' => '26,6',
      'size' => '10',
      'enable_range_search' => false,
      'function' => 
      array (
        'name' => 'display_shipping_vat',
        'returns' => 'html',
        'include' => 'modules/AOS_Products_Quotes/Line_Items.php',
      ),
    ),
    'shipping_tax_amt_usdollar' => 
    array (
      'name' => 'shipping_tax_amt_usdollar',
      'vname' => 'LBL_SHIPPING_TAX_AMT_USDOLLAR',
      'type' => 'currency',
      'group' => 'shipping_tax_amt',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'total_amount' => 
    array (
      'required' => false,
      'name' => 'total_amount',
      'vname' => 'LBL_GRAND_TOTAL',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '26,6',
      'enable_range_search' => true,
      'options' => 'numeric_range_search_dom',
      'merge_filter' => 'disabled',
    ),
    'total_amount_usdollar' => 
    array (
      'name' => 'total_amount_usdollar',
      'vname' => 'LBL_GRAND_TOTAL_USDOLLAR',
      'type' => 'currency',
      'group' => 'total_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'currency_id' => 
    array (
      'required' => false,
      'name' => 'currency_id',
      'vname' => 'LBL_CURRENCY',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => false,
      'len' => 36,
      'size' => '20',
      'studio' => 'visible',
      'function' => 
      array (
        'name' => 'getCurrencyDropDown',
        'returns' => 'html',
      ),
    ),
    'quote_number' => 
    array (
      'required' => false,
      'name' => 'quote_number',
      'vname' => 'LBL_QUOTE_NUMBER',
      'type' => 'int',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '11',
      'disable_num_format' => '',
    ),
    'quote_date' => 
    array (
      'required' => false,
      'name' => 'quote_date',
      'vname' => 'LBL_QUOTE_DATE',
      'type' => 'date',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'display_default' => 'now',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'invoice_date' => 
    array (
      'required' => false,
      'name' => 'invoice_date',
      'vname' => 'LBL_INVOICE_DATE',
      'type' => 'date',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'display_default' => 'now',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'merge_filter' => 'disabled',
    ),
    'due_date' => 
    array (
      'required' => false,
      'name' => 'due_date',
      'vname' => 'LBL_DUE_DATE',
      'type' => 'date',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'status' => 
    array (
      'required' => false,
      'name' => 'status',
      'vname' => 'LBL_STATUS',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'len' => 100,
      'options' => 'invoice_status_dom',
      'studio' => 'visible',
      'merge_filter' => 'disabled',
      'default' => 'Unpaid',
    ),
    'template_ddown_c' => 
    array (
      'required' => '0',
      'name' => 'template_ddown_c',
      'vname' => 'LBL_TEMPLATE_DDOWN_C',
      'type' => 'multienum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => 0,
      'reportable' => 0,
      'options' => 'template_ddown_c_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'subtotal_tax_amount' => 
    array (
      'required' => false,
      'name' => 'subtotal_tax_amount',
      'vname' => 'LBL_SUBTOTAL_TAX_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'subtotal_tax_amount_usdollar' => 
    array (
      'name' => 'subtotal_tax_amount_usdollar',
      'vname' => 'LBL_GRAND_TOTAL_USDOLLAR',
      'type' => 'currency',
      'group' => 'subtotal_tax_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'aos_quotes_aos_invoices' => 
    array (
      'name' => 'aos_quotes_aos_invoices',
      'type' => 'link',
      'relationship' => 'aos_quotes_aos_invoices',
      'source' => 'non-db',
      'module' => 'AOS_Quotes',
    ),
    'aos_products_quotes' => 
    array (
      'name' => 'aos_products_quotes',
      'type' => 'link',
      'relationship' => 'aos_invoices_aos_product_quotes',
      'module' => 'AOS_Products_Quotes',
      'bean_name' => 'AOS_Products_Quotes',
      'source' => 'non-db',
    ),
    'aos_line_item_groups' => 
    array (
      'name' => 'aos_line_item_groups',
      'type' => 'link',
      'relationship' => 'aos_invoices_aos_line_item_groups',
      'module' => 'AOS_Line_Item_Groups',
      'bean_name' => 'AOS_Line_Item_Groups',
      'source' => 'non-db',
    ),
    'vp14_c' => 
    array (
      'labelValue' => 'vP14',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp14_c',
      'vname' => 'LBL_VP14',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp14_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_resultados_avalados_c' => 
    array (
      'labelValue' => 'Los Resultados obtenidos seran avalados por',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_resultados_avalados_c',
      'vname' => 'LBL_CM_RESULTADOS_AVALADOS',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '50',
      'size' => '20',
      'id' => 'AOS_Invoicescm_resultados_avalados_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'ejecutivo_de_cobranza_c' => 
    array (
      'labelValue' => 'Ejecutivo de Cobranza',
      'required' => false,
      'source' => 'non-db',
      'name' => 'ejecutivo_de_cobranza_c',
      'vname' => 'LBL_EJECUTIVO_DE_COBRANZA',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'user_id_c',
      'ext2' => 'Users',
      'module' => 'Users',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'AOS_Invoicesejecutivo_de_cobranza_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_fecha_solicitud_c' => 
    array (
      'labelValue' => 'sc Fecha Solicitud',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_fecha_solicitud_c',
      'vname' => 'LBL_SC_FECHA_SOLICITUD',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicessc_fecha_solicitud_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial9_c' => 
    array (
      'labelValue' => 'parcial9',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial9_c',
      'vname' => 'LBL_PARCIAL9',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial9_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp27_c' => 
    array (
      'labelValue' => 'vP27',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp27_c',
      'vname' => 'LBL_VP27',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp27_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial14_c' => 
    array (
      'labelValue' => 'parcial14',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial14_c',
      'vname' => 'LBL_PARCIAL14',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial14_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'producto_c' => 
    array (
      'labelValue' => 'Producto',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'producto_c',
      'vname' => 'LBL_PRODUCTO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'Seleccione',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'producto_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicesproducto_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial23_c' => 
    array (
      'labelValue' => 'parcial23',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial23_c',
      'vname' => 'LBL_PARCIAL23',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial23_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'no_fact_fedex__c' => 
    array (
      'labelValue' => 'NO. FACT FEDEX',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'no_fact_fedex__c',
      'vname' => 'LBL_NO_FACT_FEDEX_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '40',
      'size' => '20',
      'id' => 'AOS_Invoicesno_fact_fedex__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'observaciones_c' => 
    array (
      'labelValue' => 'Observaciones orden',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'observaciones_c',
      'vname' => 'LBL_OBSERVACIONES',
      'type' => 'text',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'captura las obcervaciones de la venta : a que negociacion llegaron,  que incluye la negociacion , como seran los pagos  y cualquier dato que se requiera comunicar a administracion o cobranza',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '3',
      'cols' => '30',
      'id' => 'AOS_Invoicesobservaciones_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial36_c' => 
    array (
      'labelValue' => 'parcial36',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial36_c',
      'vname' => 'LBL_PARCIAL36',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial36_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_33_c' => 
    array (
      'labelValue' => 'contador 33',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_33_c',
      'vname' => 'LBL_CONTADOR_33',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_33_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task9_c' => 
    array (
      'labelValue' => 'task9',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task9_c',
      'vname' => 'LBL_TASK9',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask9_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'orden_detenida_c' => 
    array (
      'labelValue' => 'Orden Detenida',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'orden_detenida_c',
      'vname' => 'LBL_ORDEN_DETENIDA',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'seleccione la casilla si se detiene la orden ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesorden_detenida_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial8_c' => 
    array (
      'labelValue' => 'parcial8',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial8_c',
      'vname' => 'LBL_PARCIAL8',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial8_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial6_c' => 
    array (
      'labelValue' => 'numparcial6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial6_c',
      'vname' => 'LBL_NUMPARCIAL6',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial6_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_autoria_con_c' => 
    array (
      'labelValue' => 'Autoria del estudio compartida con',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_autoria_con_c',
      'vname' => 'LBL_CM_AUTORIA_CON',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '50',
      'size' => '20',
      'id' => 'AOS_Invoicescm_autoria_con_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad18_c' => 
    array (
      'labelValue' => 'mensualidad18',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad18_c',
      'vname' => 'LBL_MENSUALIDAD18',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad18_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega11_c' => 
    array (
      'labelValue' => 'Entrega11',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega11_c',
      'vname' => 'LBL_CM_ENTREGA11',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega11_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'fecha_de_primer_pago_c' => 
    array (
      'labelValue' => 'Fecha de Primer Pago',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_de_primer_pago_c',
      'vname' => 'LBL_FECHA_DE_PRIMER_PAGO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesfecha_de_primer_pago_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare3_c' => 
    array (
      'labelValue' => 'pagare3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare3_c',
      'vname' => 'LBL_PAGARE3',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'no_fact_dhl_c' => 
    array (
      'labelValue' => 'NO FACT DHL',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'no_fact_dhl_c',
      'vname' => 'LBL_NO_FACT_DHL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesno_fact_dhl_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial11_c' => 
    array (
      'labelValue' => 'parcial11',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial11_c',
      'vname' => 'LBL_PARCIAL11',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial11_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial8_c' => 
    array (
      'labelValue' => 'numparcial8',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial8_c',
      'vname' => 'LBL_NUMPARCIAL8',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial8_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad26_c' => 
    array (
      'labelValue' => 'mensualidad26',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad26_c',
      'vname' => 'LBL_MENSUALIDAD26',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad26_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_estudio_c' => 
    array (
      'labelValue' => 'Nombre del Estudio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_estudio_c',
      'vname' => 'LBL_CM_ESTUDIO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '150',
      'size' => '20',
      'id' => 'AOS_Invoicescm_estudio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp32_c' => 
    array (
      'labelValue' => 'vP32',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp32_c',
      'vname' => 'LBL_VP32',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp32_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_inicio_estudio_c' => 
    array (
      'labelValue' => 'Inicio del Estudio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_inicio_estudio_c',
      'vname' => 'LBL_CM_INICIO_ESTUDIO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_inicio_estudio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare19_c' => 
    array (
      'labelValue' => 'pagare19',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare19_c',
      'vname' => 'LBL_PAGARE19',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare19_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'comp_envio_c' => 
    array (
      'labelValue' => 'Compañia Envio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'comp_envio_c',
      'vname' => 'LBL_COMP_ENVIO',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'comp_envio_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicescomp_envio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp7_c' => 
    array (
      'labelValue' => 'vP7',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp7_c',
      'vname' => 'LBL_VP7',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp7_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'genera_registros_c' => 
    array (
      'labelValue' => 'Genera Registros de Cobranza',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'genera_registros_c',
      'vname' => 'LBL_GENERA_REGISTROS',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => 'Gene',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesgenera_registros_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad29_c' => 
    array (
      'labelValue' => 'mensualidad29',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad29_c',
      'vname' => 'LBL_MENSUALIDAD29',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad29_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task28_c' => 
    array (
      'labelValue' => 'task28',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task28_c',
      'vname' => 'LBL_TASK28',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask28_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp31_c' => 
    array (
      'labelValue' => 'vP31',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp31_c',
      'vname' => 'LBL_VP31',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp31_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad28_c' => 
    array (
      'labelValue' => 'mensualidad28',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad28_c',
      'vname' => 'LBL_MENSUALIDAD28',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad28_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task5_c' => 
    array (
      'labelValue' => 'task5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task5_c',
      'vname' => 'LBL_TASK5',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask5_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'obs_contacto__c' => 
    array (
      'labelValue' => 'obs contacto',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'obs_contacto__c',
      'vname' => 'LBL_OBS_CONTACTO_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'en caso de no encontrar  la descripcion correcta en "toma de Contacto" seleccione "Otro" y en este campo  ponga la  descripcion  de la situacion  del contacto',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesobs_contacto__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'orden_origen__c' => 
    array (
      'labelValue' => 'TOMA DE CONTACTO',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'orden_origen__c',
      'vname' => 'LBL_ORDEN_ORIGEN_',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'orden_origen_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicesorden_origen__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'num_factura_total_c' => 
    array (
      'labelValue' => 'Num Factura TOTAL',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'num_factura_total_c',
      'vname' => 'LBL_NUM_FACTURA_TOTAL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesnum_factura_total_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'subtotal_partida_c' => 
    array (
      'labelValue' => 'SubTotal',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'subtotal_partida_c',
      'vname' => 'LBL_SUBTOTAL_PARTIDA',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicessubtotal_partida_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial20_c' => 
    array (
      'labelValue' => 'numparcial20',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial20_c',
      'vname' => 'LBL_NUMPARCIAL20',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial20_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad1_c' => 
    array (
      'labelValue' => 'mensualidad1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad1_c',
      'vname' => 'LBL_MENSUALIDAD1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_colonia_c' => 
    array (
      'labelValue' => 'sc Colonia',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_colonia_c',
      'vname' => 'LBL_SC_COLONIA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_colonia_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp21_c' => 
    array (
      'labelValue' => 'vp21',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp21_c',
      'vname' => 'LBL_VP21',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp21_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_de_cada_mensualidad_c' => 
    array (
      'labelValue' => 'Importe de cada Mensualidad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_de_cada_mensualidad_c',
      'vname' => 'LBL_IMPORTE_DE_CADA_MENSUALIDAD',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_de_cada_mensualidad_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial33_c' => 
    array (
      'labelValue' => 'parcial33',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial33_c',
      'vname' => 'LBL_PARCIAL33',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial33_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cantidad_de_mensualidades_c' => 
    array (
      'labelValue' => '¿En cuantas Mensualidades desea registrar el pago total?',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'cantidad_de_mensualidades_c',
      'vname' => 'LBL_CANTIDAD_DE_MENSUALIDADES',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '10',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => 1,
      'max' => 36,
      'validation' => 
      array (
        'type' => 'range',
        'min' => 1,
        'max' => 36,
      ),
      'id' => 'AOS_Invoicescantidad_de_mensualidades_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare20_c' => 
    array (
      'labelValue' => 'pagare20',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare20_c',
      'vname' => 'LBL_PAGARE20',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare20_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt5_c' => 
    array (
      'labelValue' => 'vPt5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt5_c',
      'vname' => 'LBL_VPT5',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt5_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad17_c' => 
    array (
      'labelValue' => 'mensualidad17',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad17_c',
      'vname' => 'LBL_MENSUALIDAD17',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad17_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vencimiento_pagare_c' => 
    array (
      'labelValue' => 'Vencimiento Pagare',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vencimiento_pagare_c',
      'vname' => 'LBL_VENCIMIENTO_PAGARE',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvencimiento_pagare_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task20_c' => 
    array (
      'labelValue' => 'task20',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task20_c',
      'vname' => 'LBL_TASK20',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask20_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp9_c' => 
    array (
      'labelValue' => 'vP9',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp9_c',
      'vname' => 'LBL_VP9',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp9_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_cantidad_entregas_c' => 
    array (
      'labelValue' => 'Cantidad de Entregas',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_cantidad_entregas_c',
      'vname' => 'LBL_CM_CANTIDAD_ENTREGAS',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescm_cantidad_entregas_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_3_c' => 
    array (
      'labelValue' => 'contador 3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_3_c',
      'vname' => 'LBL_CONTADOR_3',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_31_c' => 
    array (
      'labelValue' => 'contador 31',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_31_c',
      'vname' => 'LBL_CONTADOR_31',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_31_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp2_c' => 
    array (
      'labelValue' => 'vP2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp2_c',
      'vname' => 'LBL_VP2',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_nombre_quien_recibe_c' => 
    array (
      'labelValue' => 'cm Nombre de quien recibe el equipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_nombre_quien_recibe_c',
      'vname' => 'LBL_CM_NOMBRE_QUIEN_RECIBE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '50',
      'size' => '20',
      'id' => 'AOS_Invoicescm_nombre_quien_recibe_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'serie_c' => 
    array (
      'labelValue' => 'Número de Serie del Equipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'serie_c',
      'vname' => 'LBL_SERIE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURA EL NUMERO DE SERIE DELEQUIPO DE LA SIG MANERA (AAAA-111-11A)',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesserie_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'venta_perdida_c' => 
    array (
      'labelValue' => 'Venta Perdida',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'venta_perdida_c',
      'vname' => 'LBL_VENTA_PERDIDA',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'No',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'si_no_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicesventa_perdida_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task34_c' => 
    array (
      'labelValue' => 'task34',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task34_c',
      'vname' => 'LBL_TASK34',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask34_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'total_anticipo_c' => 
    array (
      'labelValue' => 'Total del Anticipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'total_anticipo_c',
      'vname' => 'LBL_TOTAL_ANTICIPO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicestotal_anticipo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt26_c' => 
    array (
      'labelValue' => 'vPt26',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt26_c',
      'vname' => 'LBL_VPT26',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt26_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numero_dia_mes_c' => 
    array (
      'labelValue' => 'Número de día en el mes para cobro',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numero_dia_mes_c',
      'vname' => 'LBL_NUMERO_DIA_MES',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => 1,
      'max' => 30,
      'validation' => 
      array (
        'type' => 'range',
        'min' => 1,
        'max' => 30,
      ),
      'id' => 'AOS_Invoicesnumero_dia_mes_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial30_c' => 
    array (
      'labelValue' => 'parcial30',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial30_c',
      'vname' => 'LBL_PARCIAL30',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial30_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_fin_estudio_c' => 
    array (
      'labelValue' => 'Fin del Estudio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_fin_estudio_c',
      'vname' => 'LBL_CM_FIN_ESTUDIO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_fin_estudio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt25_c' => 
    array (
      'labelValue' => 'vPt25',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt25_c',
      'vname' => 'LBL_VPT25',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt25_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_34_c' => 
    array (
      'labelValue' => 'contador 34',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_34_c',
      'vname' => 'LBL_CONTADOR_34',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_34_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task3_c' => 
    array (
      'labelValue' => 'task3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task3_c',
      'vname' => 'LBL_TASK3',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'serv_c' => 
    array (
      'labelValue' => 'Importe de Servicios',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'serv_c',
      'vname' => 'LBL_SERV',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => 'Capture el importe del Servicio o Garantia',
      'help' => 'Capture el importe del Servicio o Garantia',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesserv_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task31_c' => 
    array (
      'labelValue' => 'task31',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task31_c',
      'vname' => 'LBL_TASK31',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask31_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp8_c' => 
    array (
      'labelValue' => 'vP8',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp8_c',
      'vname' => 'LBL_VP8',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp8_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt19_c' => 
    array (
      'labelValue' => 'vpt19',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt19_c',
      'vname' => 'LBL_VPT19',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt19_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_anticipo_total_c' => 
    array (
      'labelValue' => 'Importe con Letra del Anticipo Total',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_anticipo_total_c',
      'vname' => 'LBL_IMPORTE_ANTICIPO_TOTAL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '80',
      'size' => '20',
      'id' => 'AOS_Invoicesimporte_anticipo_total_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_35_c' => 
    array (
      'labelValue' => 'contador 35',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_35_c',
      'vname' => 'LBL_CONTADOR_35',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_35_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare12_c' => 
    array (
      'labelValue' => 'pagare12',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare12_c',
      'vname' => 'LBL_PAGARE12',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare12_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_represennte_legal_c' => 
    array (
      'labelValue' => 'sc Para el caso de Persona Moral, nombre del Represennte Legal',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_represennte_legal_c',
      'vname' => 'LBL_SC_REPRESENNTE_LEGAL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_represennte_legal_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt2_c' => 
    array (
      'labelValue' => 'vPt2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt2_c',
      'vname' => 'LBL_VPT2',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare4_c' => 
    array (
      'labelValue' => 'pagare4',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare4_c',
      'vname' => 'LBL_PAGARE4',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare4_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'servicio_c' => 
    array (
      'labelValue' => 'Servicio',
      'required' => false,
      'source' => 'non-db',
      'name' => 'servicio_c',
      'vname' => 'LBL_SERVICIO',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Selecciona el folio del servicio que se paga con esta orden',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'acase_id_c',
      'ext2' => 'Cases',
      'module' => 'Cases',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'AOS_Invoicesservicio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'totalmensualidades_c' => 
    array (
      'labelValue' => 'totalmensualidades',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'totalmensualidades_c',
      'vname' => 'LBL_TOTALMENSUALIDADES',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicestotalmensualidades_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_21_c' => 
    array (
      'labelValue' => 'contador 21',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_21_c',
      'vname' => 'LBL_CONTADOR_21',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_21_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'no_remision_c' => 
    array (
      'labelValue' => 'No remision',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'no_remision_c',
      'vname' => 'LBL_NO_REMISION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesno_remision_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task15_c' => 
    array (
      'labelValue' => 'task15',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task15_c',
      'vname' => 'LBL_TASK15',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask15_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare15_c' => 
    array (
      'labelValue' => 'pagare15',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare15_c',
      'vname' => 'LBL_PAGARE15',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare15_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task1_c' => 
    array (
      'labelValue' => 'task1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task1_c',
      'vname' => 'LBL_TASK1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_consultorio_c' => 
    array (
      'labelValue' => 'sc Consultorio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_consultorio_c',
      'vname' => 'LBL_SC_CONSULTORIO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'undefined',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'consultorio_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicessc_consultorio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp29_c' => 
    array (
      'labelValue' => 'vP29',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp29_c',
      'vname' => 'LBL_VP29',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp29_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial6_c' => 
    array (
      'labelValue' => 'parcial6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial6_c',
      'vname' => 'LBL_PARCIAL6',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial6_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt12_c' => 
    array (
      'labelValue' => 'vPt12',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt12_c',
      'vname' => 'LBL_VPT12',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt12_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial36_c' => 
    array (
      'labelValue' => 'numparcial36',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial36_c',
      'vname' => 'LBL_NUMPARCIAL36',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial36_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial13_c' => 
    array (
      'labelValue' => 'numparcial13',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial13_c',
      'vname' => 'LBL_NUMPARCIAL13',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial13_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp28_c' => 
    array (
      'labelValue' => 'vP28',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp28_c',
      'vname' => 'LBL_VP28',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp28_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare13_c' => 
    array (
      'labelValue' => 'pagare13',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare13_c',
      'vname' => 'LBL_PAGARE13',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare13_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_inmueble_c' => 
    array (
      'labelValue' => 'sc Inmueble',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_inmueble_c',
      'vname' => 'LBL_SC_INMUEBLE',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'undefined',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'consultorio_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicessc_inmueble_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad34_c' => 
    array (
      'labelValue' => 'mensualidad34',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad34_c',
      'vname' => 'LBL_MENSUALIDAD34',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad34_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp6_c' => 
    array (
      'labelValue' => 'vP6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp6_c',
      'vname' => 'LBL_VP6',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp6_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task16_c' => 
    array (
      'labelValue' => 'task16',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task16_c',
      'vname' => 'LBL_TASK16',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask16_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_cons_email_c' => 
    array (
      'labelValue' => 'sc Consultorio Email',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_cons_email_c',
      'vname' => 'LBL_SC_CONS_EMAIL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'AOS_Invoicessc_cons_email_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial10_c' => 
    array (
      'labelValue' => 'parcial10',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial10_c',
      'vname' => 'LBL_PARCIAL10',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial10_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_consultorio_ant_c' => 
    array (
      'labelValue' => 'sc Consultorio Antigüedad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_consultorio_ant_c',
      'vname' => 'LBL_SC_CONSULTORIO_ANT',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_consultorio_ant_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_aprobacion_c' => 
    array (
      'labelValue' => 'sc Aprobacion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_aprobacion_c',
      'vname' => 'LBL_SC_APROBACION',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'si_no_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicessc_aprobacion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare31_c' => 
    array (
      'labelValue' => 'pagare31',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare31_c',
      'vname' => 'LBL_PAGARE31',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare31_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'enganche_c' => 
    array (
      'labelValue' => 'Enganche',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'enganche_c',
      'vname' => 'LBL_ENGANCHE',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesenganche_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad36_c' => 
    array (
      'labelValue' => 'mensualidad36',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad36_c',
      'vname' => 'LBL_MENSUALIDAD36',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad36_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial15_c' => 
    array (
      'labelValue' => 'parcial15',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial15_c',
      'vname' => 'LBL_PARCIAL15',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial15_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'codigo_seguridad_c' => 
    array (
      'labelValue' => 'Código de Seguridad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'codigo_seguridad_c',
      'vname' => 'LBL_CODIGO_SEGURIDAD',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescodigo_seguridad_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial11_c' => 
    array (
      'labelValue' => 'numparcial11',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial11_c',
      'vname' => 'LBL_NUMPARCIAL11',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial11_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp15_c' => 
    array (
      'labelValue' => 'vP15',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp15_c',
      'vname' => 'LBL_VP15',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp15_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad3_c' => 
    array (
      'labelValue' => 'mensualidad3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad3_c',
      'vname' => 'LBL_MENSUALIDAD3',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_10_c' => 
    array (
      'labelValue' => 'contador 10',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_10_c',
      'vname' => 'LBL_CONTADOR_10',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_10_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'compania_c' => 
    array (
      'labelValue' => 'Compañia',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'compania_c',
      'vname' => 'LBL_COMPANIA',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CON QUE COMPANIA ESTAS VENDIENDO:   EL DOCUMENTO Y LATERMINAL ES DE INTROLIGHT O DE NAYELI',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'compania_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicescompania_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_telefono1_c' => 
    array (
      'labelValue' => 'sc Telefono1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_telefono1_c',
      'vname' => 'LBL_SC_TELEFONO1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_telefono1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt23_c' => 
    array (
      'labelValue' => 'vpt23',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt23_c',
      'vname' => 'LBL_VPT23',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt23_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task35_c' => 
    array (
      'labelValue' => 'task35',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task35_c',
      'vname' => 'LBL_TASK35',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask35_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_cons_celular_c' => 
    array (
      'labelValue' => 'sc Celular del Consultorio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_cons_celular_c',
      'vname' => 'LBL_SC_CONS_CELULAR',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_cons_celular_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_19_c' => 
    array (
      'labelValue' => 'contador 19',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_19_c',
      'vname' => 'LBL_CONTADOR_19',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_19_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task11_c' => 
    array (
      'labelValue' => 'task11',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task11_c',
      'vname' => 'LBL_TASK11',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask11_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task33_c' => 
    array (
      'labelValue' => 'task33',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task33_c',
      'vname' => 'LBL_TASK33',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask33_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare24_c' => 
    array (
      'labelValue' => 'pagare24',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare24_c',
      'vname' => 'LBL_PAGARE24',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare24_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task2_c' => 
    array (
      'labelValue' => 'task2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task2_c',
      'vname' => 'LBL_TASK2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega8_c' => 
    array (
      'labelValue' => 'Entrega8',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega8_c',
      'vname' => 'LBL_CM_ENTREGA8',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega8_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt7_c' => 
    array (
      'labelValue' => 'vPt7',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt7_c',
      'vname' => 'LBL_VPT7',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt7_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt11_c' => 
    array (
      'labelValue' => 'vPt11',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt11_c',
      'vname' => 'LBL_VPT11',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt11_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare32_c' => 
    array (
      'labelValue' => 'pagare32',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare32_c',
      'vname' => 'LBL_PAGARE32',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare32_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega6_c' => 
    array (
      'labelValue' => 'Entrega6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega6_c',
      'vname' => 'LBL_CM_ENTREGA6',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega6_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial12_c' => 
    array (
      'labelValue' => 'parcial12',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial12_c',
      'vname' => 'LBL_PARCIAL12',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial12_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad15_c' => 
    array (
      'labelValue' => 'mensualidad15',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad15_c',
      'vname' => 'LBL_MENSUALIDAD15',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad15_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega7_c' => 
    array (
      'labelValue' => 'Entrega7',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega7_c',
      'vname' => 'LBL_CM_ENTREGA7',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega7_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt28_c' => 
    array (
      'labelValue' => 'vPt28',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt28_c',
      'vname' => 'LBL_VPT28',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt28_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pasar_por_pago_c' => 
    array (
      'labelValue' => 'Pasar por Pago',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pasar_por_pago_c',
      'vname' => 'LBL_PASAR_POR_PAGO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'Seleccione',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'pasar_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicespasar_por_pago_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_26_c' => 
    array (
      'labelValue' => 'contador 26',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_26_c',
      'vname' => 'LBL_CONTADOR_26',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_26_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'razon_venta_perdida_c' => 
    array (
      'labelValue' => 'Razón de Venta Perdida',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'razon_venta_perdida_c',
      'vname' => 'LBL_RAZON_VENTA_PERDIDA',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'AOS_Invoicesrazon_venta_perdida_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial20_c' => 
    array (
      'labelValue' => 'parcial20',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial20_c',
      'vname' => 'LBL_PARCIAL20',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial20_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'no_fact_uber_c' => 
    array (
      'labelValue' => 'NO. FACT UBER',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'no_fact_uber_c',
      'vname' => 'LBL_NO_FACT_UBER',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesno_fact_uber_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_num_interior_c' => 
    array (
      'labelValue' => 'sc Num Interior',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_num_interior_c',
      'vname' => 'LBL_SC_NUM_INTERIOR',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_num_interior_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial4_c' => 
    array (
      'labelValue' => 'parcial4',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial4_c',
      'vname' => 'LBL_PARCIAL4',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial4_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_iva_c' => 
    array (
      'labelValue' => 'Importe IVA',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_iva_c',
      'vname' => 'LBL_IMPORTE_IVA',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_iva_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_13_c' => 
    array (
      'labelValue' => 'contador 13',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_13_c',
      'vname' => 'LBL_CONTADOR_13',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_13_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt3_c' => 
    array (
      'labelValue' => 'vPt3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt3_c',
      'vname' => 'LBL_VPT3',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'uso_cfdi__c' => 
    array (
      'labelValue' => 'uso cfdi',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'uso_cfdi__c',
      'vname' => 'LBL_USO_CFDI_',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'uso_de_CFDI_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicesuso_cfdi__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task6_c' => 
    array (
      'labelValue' => 'task6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task6_c',
      'vname' => 'LBL_TASK6',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask6_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare7_c' => 
    array (
      'labelValue' => 'pagare7',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare7_c',
      'vname' => 'LBL_PAGARE7',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare7_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_fecha_de_consulta_buro_c' => 
    array (
      'labelValue' => 'sc Fecha de consulta de Buro de Credito',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_fecha_de_consulta_buro_c',
      'vname' => 'LBL_SC_FECHA_DE_CONSULTA_BURO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicessc_fecha_de_consulta_buro_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'banco_tc_cargo_c' => 
    array (
      'labelValue' => 'Banco de TC para Cargo recurrente',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'banco_tc_cargo_c',
      'vname' => 'LBL_BANCO_TC_CARGO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicesbanco_tc_cargo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_18_c' => 
    array (
      'labelValue' => 'contador 18',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_18_c',
      'vname' => 'LBL_CONTADOR_18',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_18_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'calidad_prod__c' => 
    array (
      'labelValue' => 'La Calidad del producto es:',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'calidad_prod__c',
      'vname' => 'LBL_CALIDAD_PROD_',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'calidad_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicescalidad_prod__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task12_c' => 
    array (
      'labelValue' => 'task12',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task12_c',
      'vname' => 'LBL_TASK12',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask12_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp13_c' => 
    array (
      'labelValue' => 'vP13',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp13_c',
      'vname' => 'LBL_VP13',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp13_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp1_c' => 
    array (
      'labelValue' => 'vP1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp1_c',
      'vname' => 'LBL_VP1',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare36_c' => 
    array (
      'labelValue' => 'pagare36',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare36_c',
      'vname' => 'LBL_PAGARE36',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare36_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial10_c' => 
    array (
      'labelValue' => 'numparcial10',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial10_c',
      'vname' => 'LBL_NUMPARCIAL10',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial10_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt14_c' => 
    array (
      'labelValue' => 'vPt14',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt14_c',
      'vname' => 'LBL_VPT14',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt14_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp5_c' => 
    array (
      'labelValue' => 'vP5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp5_c',
      'vname' => 'LBL_VP5',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp5_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare18_c' => 
    array (
      'labelValue' => 'pagare18',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare18_c',
      'vname' => 'LBL_PAGARE18',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare18_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare26_c' => 
    array (
      'labelValue' => 'pagare26',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare26_c',
      'vname' => 'LBL_PAGARE26',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare26_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_5_c' => 
    array (
      'labelValue' => 'contador 5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_5_c',
      'vname' => 'LBL_CONTADOR_5',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_5_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare30_c' => 
    array (
      'labelValue' => 'pagare30',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare30_c',
      'vname' => 'LBL_PAGARE30',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare30_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt4_c' => 
    array (
      'labelValue' => 'vPt4',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt4_c',
      'vname' => 'LBL_VPT4',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt4_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp3_c' => 
    array (
      'labelValue' => 'vP3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp3_c',
      'vname' => 'LBL_VP3',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare17_c' => 
    array (
      'labelValue' => 'pagare17',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare17_c',
      'vname' => 'LBL_PAGARE17',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare17_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp22_c' => 
    array (
      'labelValue' => 'vp22',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp22_c',
      'vname' => 'LBL_VP22',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp22_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial32_c' => 
    array (
      'labelValue' => 'numparcial32',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial32_c',
      'vname' => 'LBL_NUMPARCIAL32',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial32_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare1_c' => 
    array (
      'labelValue' => 'pagare1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare1_c',
      'vname' => 'LBL_PAGARE1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_e1_c' => 
    array (
      'labelValue' => 'contador e1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_e1_c',
      'vname' => 'LBL_CONTADOR_E1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_e1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'orden_de_c' => 
    array (
      'labelValue' => 'Es Orden de',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'orden_de_c',
      'vname' => 'LBL_ORDEN_DE',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Para que movimiento estas generando tu orden',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Curso_list_',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicesorden_de_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial3_c' => 
    array (
      'labelValue' => 'numparcial3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial3_c',
      'vname' => 'LBL_NUMPARCIAL3',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'devol_sait_ajuste_c' => 
    array (
      'labelValue' => 'devol sait ajuste',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'devol_sait_ajuste_c',
      'vname' => 'LBL_DEVOL_SAIT_AJUSTE',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesdevol_sait_ajuste_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'evento_c' => 
    array (
      'labelValue' => 'Evento',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'evento_c',
      'vname' => 'LBL_EVENTO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'AMIC_NOV18',
      'no_default' => false,
      'comments' => 'Seleccione el Evento',
      'help' => 'Seleccione el evento',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'evento_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicesevento_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'estado_congreso_c' => 
    array (
      'labelValue' => 'Estado Congreso',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'estado_congreso_c',
      'vname' => 'LBL_ESTADO_CONGRESO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'estado_congreso_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicesestado_congreso_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt15_c' => 
    array (
      'labelValue' => 'vPt15',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt15_c',
      'vname' => 'LBL_VPT15',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt15_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare34_c' => 
    array (
      'labelValue' => 'pagare34',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare34_c',
      'vname' => 'LBL_PAGARE34',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare34_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt8_c' => 
    array (
      'labelValue' => 'vPt8',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt8_c',
      'vname' => 'LBL_VPT8',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt8_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_meses_estudio_c' => 
    array (
      'labelValue' => 'Meses Estudio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_meses_estudio_c',
      'vname' => 'LBL_CM_MESES_ESTUDIO',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => 0,
      'max' => 100,
      'validation' => 
      array (
        'type' => 'range',
        'min' => 0,
        'max' => 100,
      ),
      'id' => 'AOS_Invoicescm_meses_estudio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task25_c' => 
    array (
      'labelValue' => 'task25',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task25_c',
      'vname' => 'LBL_TASK25',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask25_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'serv_agente__c' => 
    array (
      'labelValue' => 'El Servicio del Agente fue ?:',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'serv_agente__c',
      'vname' => 'LBL_SERV_AGENTE_',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'calidad_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicesserv_agente__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'prod_adquirido__c' => 
    array (
      'labelValue' => 'prod adquirido',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'prod_adquirido__c',
      'vname' => 'LBL_PROD_ADQUIRIDO_',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'producto_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicesprod_adquirido__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'fecha_enganche_3_c' => 
    array (
      'labelValue' => 'Fecha Enganche 3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_enganche_3_c',
      'vname' => 'LBL_FECHA_ENGANCHE_3',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesfecha_enganche_3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r2_direccion_c' => 
    array (
      'labelValue' => 'Direccion Ref 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r2_direccion_c',
      'vname' => 'LBL_SC_R2_DIRECCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r2_direccion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_30_c' => 
    array (
      'labelValue' => 'contador 30',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_30_c',
      'vname' => 'LBL_CONTADOR_30',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_30_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt18_c' => 
    array (
      'labelValue' => 'vpt18',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt18_c',
      'vname' => 'LBL_VPT18',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt18_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task18_c' => 
    array (
      'labelValue' => 'task18',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task18_c',
      'vname' => 'LBL_TASK18',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask18_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial28_c' => 
    array (
      'labelValue' => 'numparcial28',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial28_c',
      'vname' => 'LBL_NUMPARCIAL28',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial28_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task13_c' => 
    array (
      'labelValue' => 'task13',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task13_c',
      'vname' => 'LBL_TASK13',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask13_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_comentarios_c' => 
    array (
      'labelValue' => 'sc Comentarios',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_comentarios_c',
      'vname' => 'LBL_SC_COMENTARIOS',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'AOS_Invoicessc_comentarios_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad25_c' => 
    array (
      'labelValue' => 'mensualidad25',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad25_c',
      'vname' => 'LBL_MENSUALIDAD25',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad25_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_9_c' => 
    array (
      'labelValue' => 'contador 9',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_9_c',
      'vname' => 'LBL_CONTADOR_9',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_9_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_autorizacion_para_c' => 
    array (
      'labelValue' => 'sc Autorizacion para',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_autorizacion_para_c',
      'vname' => 'LBL_SC_AUTORIZACION_PARA',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'to',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'autorizacion_para_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicessc_autorizacion_para_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad31_c' => 
    array (
      'labelValue' => 'mensualidad31',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad31_c',
      'vname' => 'LBL_MENSUALIDAD31',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad31_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp34_c' => 
    array (
      'labelValue' => 'vP34',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp34_c',
      'vname' => 'LBL_VP34',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp34_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial25_c' => 
    array (
      'labelValue' => 'numparcial25',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial25_c',
      'vname' => 'LBL_NUMPARCIAL25',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial25_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial22_c' => 
    array (
      'labelValue' => 'parcial22',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial22_c',
      'vname' => 'LBL_PARCIAL22',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial22_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'costo_empaque_2_c' => 
    array (
      'labelValue' => 'Costo empaque 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'costo_empaque_2_c',
      'vname' => 'LBL_COSTO_EMPAQUE_2',
      'type' => 'dynamicenum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'costo_caja_env_2_list',
      'studio' => 'visible',
      'dbType' => 'enum',
      'parentenum' => 'caja_envio__c',
      'id' => 'AOS_Invoicescosto_empaque_2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task10_c' => 
    array (
      'labelValue' => 'task10',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task10_c',
      'vname' => 'LBL_TASK10',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask10_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_monto_credito_c' => 
    array (
      'labelValue' => 'Monto Credito $',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_monto_credito_c',
      'vname' => 'LBL_SC_MONTO_CREDITO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicessc_monto_credito_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt27_c' => 
    array (
      'labelValue' => 'vPt27',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt27_c',
      'vname' => 'LBL_VPT27',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt27_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp17_c' => 
    array (
      'labelValue' => 'vp17',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp17_c',
      'vname' => 'LBL_VP17',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp17_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'anticipo_c' => 
    array (
      'labelValue' => 'Anticipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'anticipo_c',
      'vname' => 'LBL_ANTICIPO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Captura el folio del anticipo(s)  fisico',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '120',
      'size' => '20',
      'id' => 'AOS_Invoicesanticipo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad27_c' => 
    array (
      'labelValue' => 'mensualidad27',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad27_c',
      'vname' => 'LBL_MENSUALIDAD27',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad27_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial15_c' => 
    array (
      'labelValue' => 'numparcial15',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial15_c',
      'vname' => 'LBL_NUMPARCIAL15',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial15_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'servicio_relacionado_c' => 
    array (
      'labelValue' => 'servicio relacionado',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'servicio_relacionado_c',
      'vname' => 'LBL_SERVICIO_RELACIONADO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesservicio_relacionado_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_mensualidad_letra_c' => 
    array (
      'labelValue' => 'Importe de cada Mensualidad con Letra',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_mensualidad_letra_c',
      'vname' => 'LBL_IMPORTE_MENSUALIDAD_LETRA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '80',
      'size' => '20',
      'id' => 'AOS_Invoicesimporte_mensualidad_letra_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_e2_c' => 
    array (
      'labelValue' => 'contador e2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_e2_c',
      'vname' => 'LBL_CONTADOR_E2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_e2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_total_c' => 
    array (
      'labelValue' => 'T O T A L',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_total_c',
      'vname' => 'LBL_IMPORTE_TOTAL',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_total_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad22_c' => 
    array (
      'labelValue' => 'mensualidad22',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad22_c',
      'vname' => 'LBL_MENSUALIDAD22',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad22_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_6_c' => 
    array (
      'labelValue' => 'contador 6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_6_c',
      'vname' => 'LBL_CONTADOR_6',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_6_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp24_c' => 
    array (
      'labelValue' => 'vp24',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp24_c',
      'vname' => 'LBL_VP24',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp24_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task4_c' => 
    array (
      'labelValue' => 'task4',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task4_c',
      'vname' => 'LBL_TASK4',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask4_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_12_c' => 
    array (
      'labelValue' => 'contador 12',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_12_c',
      'vname' => 'LBL_CONTADOR_12',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_12_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare27_c' => 
    array (
      'labelValue' => 'pagare27',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare27_c',
      'vname' => 'LBL_PAGARE27',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare27_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt30_c' => 
    array (
      'labelValue' => 'vPt30',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt30_c',
      'vname' => 'LBL_VPT30',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt30_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial5_c' => 
    array (
      'labelValue' => 'numparcial5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial5_c',
      'vname' => 'LBL_NUMPARCIAL5',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial5_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad19_c' => 
    array (
      'labelValue' => 'mensualidad19',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad19_c',
      'vname' => 'LBL_MENSUALIDAD19',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad19_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare28_c' => 
    array (
      'labelValue' => 'pagare28',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare28_c',
      'vname' => 'LBL_PAGARE28',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare28_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_32_c' => 
    array (
      'labelValue' => 'contador 32',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_32_c',
      'vname' => 'LBL_CONTADOR_32',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_32_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_11_c' => 
    array (
      'labelValue' => 'contador 11',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_11_c',
      'vname' => 'LBL_CONTADOR_11',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_11_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega5_c' => 
    array (
      'labelValue' => 'Entrega5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega5_c',
      'vname' => 'LBL_CM_ENTREGA5',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega5_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial27_c' => 
    array (
      'labelValue' => 'parcial27',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial27_c',
      'vname' => 'LBL_PARCIAL27',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial27_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_fecha_firma_autorizacion_c' => 
    array (
      'labelValue' => 'sc Fecha de Firma de Autorizacion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_fecha_firma_autorizacion_c',
      'vname' => 'LBL_SC_FECHA_FIRMA_AUTORIZACION',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicessc_fecha_firma_autorizacion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_ciudad_c' => 
    array (
      'labelValue' => 'sc Ciudad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_ciudad_c',
      'vname' => 'LBL_SC_CIUDAD',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_ciudad_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp36_c' => 
    array (
      'labelValue' => 'vP36',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp36_c',
      'vname' => 'LBL_VP36',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp36_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp23_c' => 
    array (
      'labelValue' => 'vp23',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp23_c',
      'vname' => 'LBL_VP23',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp23_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'razon_porque_esta_detenida_c' => 
    array (
      'labelValue' => 'razon porque esta detenida',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'razon_porque_esta_detenida_c',
      'vname' => 'LBL_RAZON_PORQUE_ESTA_DETENIDA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'explique porque se detuvo la orden',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesrazon_porque_esta_detenida_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial29_c' => 
    array (
      'labelValue' => 'parcial29',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial29_c',
      'vname' => 'LBL_PARCIAL29',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial29_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_16_c' => 
    array (
      'labelValue' => 'contador 16',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_16_c',
      'vname' => 'LBL_CONTADOR_16',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_16_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial30_c' => 
    array (
      'labelValue' => 'numparcial30',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial30_c',
      'vname' => 'LBL_NUMPARCIAL30',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial30_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'explicacion_ag__c' => 
    array (
      'labelValue' => 'La Explicacion del Agente fue?: ',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'explicacion_ag__c',
      'vname' => 'LBL_EXPLICACION_AG_',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'calidad_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicesexplicacion_ag__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad4_c' => 
    array (
      'labelValue' => 'mensualidad4',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad4_c',
      'vname' => 'LBL_MENSUALIDAD4',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad4_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt22_c' => 
    array (
      'labelValue' => 'vpt22',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt22_c',
      'vname' => 'LBL_VPT22',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt22_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_firma_del_cliente_c' => 
    array (
      'labelValue' => 'Firma del Cliente',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_firma_del_cliente_c',
      'vname' => 'LBL_SC_FIRMA_DEL_CLIENTE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_firma_del_cliente_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'referencia_2_c' => 
    array (
      'labelValue' => 'REFERENCIA 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'referencia_2_c',
      'vname' => 'LBL_REFERENCIA_2',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesreferencia_2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_17_c' => 
    array (
      'labelValue' => 'contador 17',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_17_c',
      'vname' => 'LBL_CONTADOR_17',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_17_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp10_c' => 
    array (
      'labelValue' => 'vP10',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp10_c',
      'vname' => 'LBL_VP10',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp10_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad14_c' => 
    array (
      'labelValue' => 'mensualidad14',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad14_c',
      'vname' => 'LBL_MENSUALIDAD14',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad14_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial28_c' => 
    array (
      'labelValue' => 'parcial28',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial28_c',
      'vname' => 'LBL_PARCIAL28',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial28_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad32_c' => 
    array (
      'labelValue' => 'mensualidad32',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad32_c',
      'vname' => 'LBL_MENSUALIDAD32',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad32_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare2_c' => 
    array (
      'labelValue' => 'pagare2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare2_c',
      'vname' => 'LBL_PAGARE2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'requiere_factura_c' => 
    array (
      'labelValue' => 'Requiere Factura1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'requiere_factura_c',
      'vname' => 'LBL_REQUIERE_FACTURA',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesrequiere_factura_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'letra_cant_minima_entrega_c' => 
    array (
      'labelValue' => 'Letra Cantidad mínima para entrega',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'letra_cant_minima_entrega_c',
      'vname' => 'LBL_LETRA_CANT_MINIMA_ENTREGA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '80',
      'size' => '20',
      'id' => 'AOS_Invoicesletra_cant_minima_entrega_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad5_c' => 
    array (
      'labelValue' => 'mensualidad5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad5_c',
      'vname' => 'LBL_MENSUALIDAD5',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad5_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task7_c' => 
    array (
      'labelValue' => 'task7',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task7_c',
      'vname' => 'LBL_TASK7',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask7_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_36_c' => 
    array (
      'labelValue' => 'contador 36',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_36_c',
      'vname' => 'LBL_CONTADOR_36',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_36_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial2_c' => 
    array (
      'labelValue' => 'numparcial2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial2_c',
      'vname' => 'LBL_NUMPARCIAL2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp26_c' => 
    array (
      'labelValue' => 'vP26',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp26_c',
      'vname' => 'LBL_VP26',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp26_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt6_c' => 
    array (
      'labelValue' => 'vPt6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt6_c',
      'vname' => 'LBL_VPT6',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt6_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'tipo_factura_c' => 
    array (
      'labelValue' => '¿Como quiere la Factura?',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tipo_factura_c',
      'vname' => 'LBL_TIPO_FACTURA',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => 'Parcial=Cuando el cliente quiere una factura por cada pago que realice.  Total=Cuando el cliente quiere una factura por el total de la compra.',
      'help' => 'Parcial=Cuando el cliente quiere una factura por cada pago que realice.  Total=Cuando el cliente quiere una factura por el total de la compra.',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'tipo_factura_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicestipo_factura_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad9_c' => 
    array (
      'labelValue' => 'mensualidad9',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad9_c',
      'vname' => 'LBL_MENSUALIDAD9',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad9_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad35_c' => 
    array (
      'labelValue' => 'mensualidad35',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad35_c',
      'vname' => 'LBL_MENSUALIDAD35',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad35_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_22_c' => 
    array (
      'labelValue' => 'contador 22',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_22_c',
      'vname' => 'LBL_CONTADOR_22',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_22_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task19_c' => 
    array (
      'labelValue' => 'task19',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task19_c',
      'vname' => 'LBL_TASK19',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask19_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad8_c' => 
    array (
      'labelValue' => 'mensualidad8',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad8_c',
      'vname' => 'LBL_MENSUALIDAD8',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad8_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega1_c' => 
    array (
      'labelValue' => 'Entrega1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega1_c',
      'vname' => 'LBL_CM_ENTREGA1',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_folio_de_consulta_buro_c' => 
    array (
      'labelValue' => 'sc Folio de Consulta de Buro de credito',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_folio_de_consulta_buro_c',
      'vname' => 'LBL_SC_FOLIO_DE_CONSULTA_BURO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'AOS_Invoicessc_folio_de_consulta_buro_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial26_c' => 
    array (
      'labelValue' => 'parcial26',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial26_c',
      'vname' => 'LBL_PARCIAL26',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial26_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'requiere_factura2_c' => 
    array (
      'labelValue' => 'Requiere Factura',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'requiere_factura2_c',
      'vname' => 'LBL_REQUIERE_FACTURA2',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'si_no_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicesrequiere_factura2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cantidad_minima_para_entrega_c' => 
    array (
      'labelValue' => 'Cantidad Mínima para Entrega del equipo Láser',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cantidad_minima_para_entrega_c',
      'vname' => 'LBL_CANTIDAD_MINIMA_PARA_ENTREGA',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicescantidad_minima_para_entrega_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad16_c' => 
    array (
      'labelValue' => 'mensualidad16',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad16_c',
      'vname' => 'LBL_MENSUALIDAD16',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad16_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad21_c' => 
    array (
      'labelValue' => 'mensualidad21',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad21_c',
      'vname' => 'LBL_MENSUALIDAD21',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad21_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r2_tel_cons_c' => 
    array (
      'labelValue' => 'Tel Consultorio Ref 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r2_tel_cons_c',
      'vname' => 'LBL_SC_R2_TEL_CONS',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '30',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r2_tel_cons_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial27_c' => 
    array (
      'labelValue' => 'numparcial27',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial27_c',
      'vname' => 'LBL_NUMPARCIAL27',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial27_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt20_c' => 
    array (
      'labelValue' => 'vpt20',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt20_c',
      'vname' => 'LBL_VPT20',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt20_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_del_enganche_3_c' => 
    array (
      'labelValue' => 'Importe del Anticipo 3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_del_enganche_3_c',
      'vname' => 'LBL_IMPORTE_DEL_ENGANCHE_3',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_del_enganche_3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial24_c' => 
    array (
      'labelValue' => 'parcial24',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial24_c',
      'vname' => 'LBL_PARCIAL24',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial24_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare21_c' => 
    array (
      'labelValue' => 'pagare21',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare21_c',
      'vname' => 'LBL_PAGARE21',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare21_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_cons_tel2_c' => 
    array (
      'labelValue' => 'sc Telefono 2 Consultorio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_cons_tel2_c',
      'vname' => 'LBL_SC_CONS_TEL2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '30',
      'size' => '20',
      'id' => 'AOS_Invoicessc_cons_tel2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial35_c' => 
    array (
      'labelValue' => 'parcial35',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial35_c',
      'vname' => 'LBL_PARCIAL35',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial35_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp33_c' => 
    array (
      'labelValue' => 'vP33',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp33_c',
      'vname' => 'LBL_VP33',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp33_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'bueno_por_c' => 
    array (
      'labelValue' => 'Bueno por',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'bueno_por_c',
      'vname' => 'LBL_BUENO_POR',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesbueno_por_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_e3_c' => 
    array (
      'labelValue' => 'contador e3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_e3_c',
      'vname' => 'LBL_CONTADOR_E3',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_e3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cuantos_c' => 
    array (
      'labelValue' => 'Cuantos',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cuantos_c',
      'vname' => 'LBL_CUANTOS',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescuantos_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp35_c' => 
    array (
      'labelValue' => 'vP35',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp35_c',
      'vname' => 'LBL_VP35',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp35_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial19_c' => 
    array (
      'labelValue' => 'numparcial19',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial19_c',
      'vname' => 'LBL_NUMPARCIAL19',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial19_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt32_c' => 
    array (
      'labelValue' => 'vPt32',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt32_c',
      'vname' => 'LBL_VPT32',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt32_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cantidad_de_pagares_entrega_c' => 
    array (
      'labelValue' => 'Cantidad de Pagarés pagados para entrega:',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cantidad_de_pagares_entrega_c',
      'vname' => 'LBL_CANTIDAD_DE_PAGARES_ENTREGA',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescantidad_de_pagares_entrega_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'forma_de_pago_c' => 
    array (
      'labelValue' => 'Forma de Pago',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'forma_de_pago_c',
      'vname' => 'LBL_FORMA_DE_PAGO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Selecciona  si el pago es a &CREDITO& o de &CONTADO&',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'forma_de_pago_0',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicesforma_de_pago_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad10_c' => 
    array (
      'labelValue' => 'mensualidad10',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad10_c',
      'vname' => 'LBL_MENSUALIDAD10',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad10_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega12_c' => 
    array (
      'labelValue' => 'Entrega12',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega12_c',
      'vname' => 'LBL_CM_ENTREGA12',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega12_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task24_c' => 
    array (
      'labelValue' => 'task24',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task24_c',
      'vname' => 'LBL_TASK24',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask24_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad6_c' => 
    array (
      'labelValue' => 'mensualidad6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad6_c',
      'vname' => 'LBL_MENSUALIDAD6',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad6_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_28_c' => 
    array (
      'labelValue' => 'contador 28',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_28_c',
      'vname' => 'LBL_CONTADOR_28',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_28_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt9_c' => 
    array (
      'labelValue' => 'vPt9',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt9_c',
      'vname' => 'LBL_VPT9',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt9_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'calid_envio__c' => 
    array (
      'labelValue' => 'La Calidad  en el envio fue ?: ',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'calid_envio__c',
      'vname' => 'LBL_CALID_ENVIO_',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'calidad_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicescalid_envio__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contrato_c' => 
    array (
      'labelValue' => '#Contrato ETER',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contrato_c',
      'vname' => 'LBL_CONTRATO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '60',
      'size' => '20',
      'id' => 'AOS_Invoicescontrato_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r2_email_c' => 
    array (
      'labelValue' => 'e-mail Ref 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r2_email_c',
      'vname' => 'LBL_SC_R2_EMAIL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r2_email_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_8_c' => 
    array (
      'labelValue' => 'contador 8',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_8_c',
      'vname' => 'LBL_CONTADOR_8',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_8_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task21_c' => 
    array (
      'labelValue' => 'task21',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task21_c',
      'vname' => 'LBL_TASK21',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask21_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_1_c' => 
    array (
      'labelValue' => 'contador 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_1_c',
      'vname' => 'LBL_CONTADOR_1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial18_c' => 
    array (
      'labelValue' => 'numparcial18',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial18_c',
      'vname' => 'LBL_NUMPARCIAL18',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial18_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_25_c' => 
    array (
      'labelValue' => 'contador 25',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_25_c',
      'vname' => 'LBL_CONTADOR_25',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_25_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'caja_envio__c' => 
    array (
      'labelValue' => 'MOD CAJA ENVIO',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'caja_envio__c',
      'vname' => 'LBL_CAJA_ENVIO_',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'MOD_CAJA_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicescaja_envio__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task29_c' => 
    array (
      'labelValue' => 'task29',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task29_c',
      'vname' => 'LBL_TASK29',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask29_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial18_c' => 
    array (
      'labelValue' => 'parcial18',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial18_c',
      'vname' => 'LBL_PARCIAL18',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial18_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task36_c' => 
    array (
      'labelValue' => 'task36',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task36_c',
      'vname' => 'LBL_TASK36',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask36_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial25_c' => 
    array (
      'labelValue' => 'parcial25',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial25_c',
      'vname' => 'LBL_PARCIAL25',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial25_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_cons_tel1_c' => 
    array (
      'labelValue' => 'sc Telefono 1 Consultorio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_cons_tel1_c',
      'vname' => 'LBL_SC_CONS_TEL1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicessc_cons_tel1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad11_c' => 
    array (
      'labelValue' => 'mensualidad11',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad11_c',
      'vname' => 'LBL_MENSUALIDAD11',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad11_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task17_c' => 
    array (
      'labelValue' => 'task17',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task17_c',
      'vname' => 'LBL_TASK17',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask17_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r2_tel_c' => 
    array (
      'labelValue' => 'Tel Ref 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r2_tel_c',
      'vname' => 'LBL_SC_R2_TEL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r2_tel_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cuentas_bancarias_c' => 
    array (
      'labelValue' => 'Cuentas Bancarias',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cuentas_bancarias_c',
      'vname' => 'LBL_CUENTAS_BANCARIAS',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '5',
      'cols' => '20',
      'id' => 'AOS_Invoicescuentas_bancarias_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt16_c' => 
    array (
      'labelValue' => 'vpt16',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt16_c',
      'vname' => 'LBL_VPT16',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt16_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task26_c' => 
    array (
      'labelValue' => 'task26',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task26_c',
      'vname' => 'LBL_TASK26',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask26_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega9_c' => 
    array (
      'labelValue' => 'Entrega9',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega9_c',
      'vname' => 'LBL_CM_ENTREGA9',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega9_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial21_c' => 
    array (
      'labelValue' => 'parcial21',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial21_c',
      'vname' => 'LBL_PARCIAL21',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial21_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cantidad_con_letra_pagare_c' => 
    array (
      'labelValue' => 'Cantidad con Letra del Pagaré',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cantidad_con_letra_pagare_c',
      'vname' => 'LBL_CANTIDAD_CON_LETRA_PAGARE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'AOS_Invoicescantidad_con_letra_pagare_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad13_c' => 
    array (
      'labelValue' => 'mensualidad13',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad13_c',
      'vname' => 'LBL_MENSUALIDAD13',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad13_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial21_c' => 
    array (
      'labelValue' => 'numparcial21',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial21_c',
      'vname' => 'LBL_NUMPARCIAL21',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial21_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad20_c' => 
    array (
      'labelValue' => 'mensualidad20',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad20_c',
      'vname' => 'LBL_MENSUALIDAD20',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad20_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_4_c' => 
    array (
      'labelValue' => 'contador 4',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_4_c',
      'vname' => 'LBL_CONTADOR_4',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_4_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_de_enganche_2_c' => 
    array (
      'labelValue' => 'Importe del Anticipo 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_de_enganche_2_c',
      'vname' => 'LBL_IMPORTE_DE_ENGANCHE_2',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_de_enganche_2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp12_c' => 
    array (
      'labelValue' => 'vP12',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp12_c',
      'vname' => 'LBL_VP12',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp12_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare9_c' => 
    array (
      'labelValue' => 'pagare9',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare9_c',
      'vname' => 'LBL_PAGARE9',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare9_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_7_c' => 
    array (
      'labelValue' => 'contador 7',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_7_c',
      'vname' => 'LBL_CONTADOR_7',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_7_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'doc_rel_c' => 
    array (
      'labelValue' => 'Doc Rel',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'doc_rel_c',
      'vname' => 'LBL_DOC_REL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'AOS_Invoicesdoc_rel_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial14_c' => 
    array (
      'labelValue' => 'numparcial14',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial14_c',
      'vname' => 'LBL_NUMPARCIAL14',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial14_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_29_c' => 
    array (
      'labelValue' => 'contador 29',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_29_c',
      'vname' => 'LBL_CONTADOR_29',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_29_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt17_c' => 
    array (
      'labelValue' => 'vpt17',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt17_c',
      'vname' => 'LBL_VPT17',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt17_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task32_c' => 
    array (
      'labelValue' => 'task32',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task32_c',
      'vname' => 'LBL_TASK32',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask32_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare16_c' => 
    array (
      'labelValue' => 'pagare16',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare16_c',
      'vname' => 'LBL_PAGARE16',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare16_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp16_c' => 
    array (
      'labelValue' => 'vp16',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp16_c',
      'vname' => 'LBL_VP16',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp16_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_subtotal_c' => 
    array (
      'labelValue' => 'Subtotal',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_subtotal_c',
      'vname' => 'LBL_IMPORTE_SUBTOTAL',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_subtotal_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_institucion_c' => 
    array (
      'labelValue' => 'Institucion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_institucion_c',
      'vname' => 'LBL_CM_INSTITUCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '60',
      'size' => '20',
      'id' => 'AOS_Invoicescm_institucion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r2_nombre_completo_c' => 
    array (
      'labelValue' => 'Nombre Completo Ref 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r2_nombre_completo_c',
      'vname' => 'LBL_SC_R2_NOMBRE_COMPLETO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r2_nombre_completo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'banco_bancos_aos_invoices' => 
    array (
      'name' => 'banco_bancos_aos_invoices',
      'type' => 'link',
      'relationship' => 'banco_bancos_aos_invoices',
      'source' => 'non-db',
      'module' => 'Banco_Bancos',
      'bean_name' => false,
      'side' => 'right',
      'vname' => 'LBL_BANCO_BANCOS_AOS_INVOICES_FROM_BANCO_BANCOS_TITLE',
    ),
    'ocupa_envio_c' => 
    array (
      'labelValue' => 'OCUPA ENVIO',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ocupa_envio_c',
      'vname' => 'OCUPA ENVIO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'NO',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'OCUPA_ENVIO_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicesocupa_envio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial32_c' => 
    array (
      'labelValue' => 'parcial32',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial32_c',
      'vname' => 'LBL_PARCIAL32',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial32_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'del_cobrador_c' => 
    array (
      'labelValue' => 'Del Cobrador',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'del_cobrador_c',
      'vname' => 'LBL_DEL_COBRADOR',
      'type' => 'url',
      'massupdate' => '0',
      'default' => '{ejecutivo_de_cobranza_c}',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'dbType' => 'varchar',
      'gen' => '1',
      'link_target' => '_self',
      'id' => 'AOS_Invoicesdel_cobrador_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp30_c' => 
    array (
      'labelValue' => 'vP30',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp30_c',
      'vname' => 'LBL_VP30',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp30_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_direccion_c' => 
    array (
      'labelValue' => 'sc Direccion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_direccion_c',
      'vname' => 'LBL_SC_DIRECCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '140',
      'size' => '20',
      'id' => 'AOS_Invoicessc_direccion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial33_c' => 
    array (
      'labelValue' => 'numparcial33',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial33_c',
      'vname' => 'LBL_NUMPARCIAL33',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial33_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare29_c' => 
    array (
      'labelValue' => 'pagare29',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare29_c',
      'vname' => 'LBL_PAGARE29',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare29_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'iva_c' => 
    array (
      'labelValue' => 'IVA',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'iva_c',
      'vname' => 'LBL_IVA',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesiva_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial17_c' => 
    array (
      'labelValue' => 'numparcial17',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial17_c',
      'vname' => 'LBL_NUMPARCIAL17',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial17_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare5_c' => 
    array (
      'labelValue' => 'pagare5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare5_c',
      'vname' => 'LBL_PAGARE5',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare5_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_cp_c' => 
    array (
      'labelValue' => 'sc CP',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_cp_c',
      'vname' => 'LBL_SC_CP',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_cp_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt29_c' => 
    array (
      'labelValue' => 'vPt29',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt29_c',
      'vname' => 'LBL_VPT29',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt29_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt36_c' => 
    array (
      'labelValue' => 'vPt36',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt36_c',
      'vname' => 'LBL_VPT36',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt36_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'meses_garantia_c' => 
    array (
      'labelValue' => 'Meses de Garantia',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'meses_garantia_c',
      'vname' => 'LBL_MESES_GARANTIA',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '12',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicesmeses_garantia_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'costo_env_fedex__c' => 
    array (
      'labelValue' => 'COSTO ENVIO ',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'costo_env_fedex__c',
      'vname' => 'LBL_COSTO_ENV_FEDEX_',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Cuanto cobro la paqueteria',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicescosto_env_fedex__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt21_c' => 
    array (
      'labelValue' => 'vpt21',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt21_c',
      'vname' => 'LBL_VPT21',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt21_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numero_tc_cargo_c' => 
    array (
      'labelValue' => 'Numero de TC para cargo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numero_tc_cargo_c',
      'vname' => 'LBL_NUMERO_TC_CARGO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesnumero_tc_cargo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt31_c' => 
    array (
      'labelValue' => 'vPt31',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt31_c',
      'vname' => 'LBL_VPT31',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt31_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad24_c' => 
    array (
      'labelValue' => 'mensualidad24',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad24_c',
      'vname' => 'LBL_MENSUALIDAD24',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad24_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp11_c' => 
    array (
      'labelValue' => 'vP11',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp11_c',
      'vname' => 'LBL_VP11',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp11_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task23_c' => 
    array (
      'labelValue' => 'task23',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task23_c',
      'vname' => 'LBL_TASK23',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask23_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'satisf_prod__c' => 
    array (
      'labelValue' => 'El equipo satisface sus espectativas?:',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'satisf_prod__c',
      'vname' => 'LBL_SATISF_PROD_',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'satisf_prod_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicessatisf_prod__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt10_c' => 
    array (
      'labelValue' => 'vPt10',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt10_c',
      'vname' => 'LBL_VPT10',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt10_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r2_celular_c' => 
    array (
      'labelValue' => 'Celular Ref 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r2_celular_c',
      'vname' => 'LBL_SC_R2_CELULAR',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '50',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r2_celular_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_direccion_c' => 
    array (
      'labelValue' => 'Dirección de resguardo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_direccion_c',
      'vname' => 'LBL_CM_DIRECCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '80',
      'size' => '20',
      'id' => 'AOS_Invoicescm_direccion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cal_observ__c' => 
    array (
      'labelValue' => 'Obcervaciones  Calidad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cal_observ__c',
      'vname' => 'LBL_CAL_OBSERV_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '120',
      'size' => '20',
      'id' => 'AOS_Invoicescal_observ__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt1_c' => 
    array (
      'labelValue' => 'vPt1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt1_c',
      'vname' => 'LBL_VPT1',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_cons_direccion_c' => 
    array (
      'labelValue' => 'sc Dirección del Consultorio o donde labora',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_cons_direccion_c',
      'vname' => 'LBL_SC_CONS_DIRECCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_cons_direccion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'referencia_1_c' => 
    array (
      'labelValue' => 'REFERENCIA 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'referencia_1_c',
      'vname' => 'LBL_REFERENCIA_1',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesreferencia_1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial22_c' => 
    array (
      'labelValue' => 'numparcial22',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial22_c',
      'vname' => 'LBL_NUMPARCIAL22',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial22_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial3_c' => 
    array (
      'labelValue' => 'parcial3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial3_c',
      'vname' => 'LBL_PARCIAL3',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'aos_invoices_pagos_pagos_de_clientes_1' => 
    array (
      'name' => 'aos_invoices_pagos_pagos_de_clientes_1',
      'type' => 'link',
      'relationship' => 'aos_invoices_pagos_pagos_de_clientes_1',
      'source' => 'non-db',
      'module' => 'Pagos_Pagos_de_Clientes',
      'bean_name' => 'Pagos_Pagos_de_Clientes',
      'side' => 'right',
      'vname' => 'LBL_AOS_INVOICES_PAGOS_PAGOS_DE_CLIENTES_1_FROM_PAGOS_PAGOS_DE_CLIENTES_TITLE',
    ),
    'vp18_c' => 
    array (
      'labelValue' => 'vp18',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp18_c',
      'vname' => 'LBL_VP18',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp18_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_fecha_c' => 
    array (
      'labelValue' => 'sc fecha',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_fecha_c',
      'vname' => 'LBL_SC_FECHA',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'display_default' => 'now',
      'id' => 'AOS_Invoicessc_fecha_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_14_c' => 
    array (
      'labelValue' => 'contador 14',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_14_c',
      'vname' => 'LBL_CONTADOR_14',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_14_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega2_c' => 
    array (
      'labelValue' => 'Entrega2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega2_c',
      'vname' => 'LBL_CM_ENTREGA2',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp4_c' => 
    array (
      'labelValue' => 'vP4',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp4_c',
      'vname' => 'LBL_VP4',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp4_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'num_venta_mes_c' => 
    array (
      'labelValue' => 'Num Venta Mes',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'num_venta_mes_c',
      'vname' => 'LBL_NUM_VENTA_MES',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicesnum_venta_mes_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'num_factura_global_c' => 
    array (
      'labelValue' => 'Num Factura Global',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'num_factura_global_c',
      'vname' => 'LBL_NUM_FACTURA_GLOBAL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '40',
      'size' => '20',
      'id' => 'AOS_Invoicesnum_factura_global_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial7_c' => 
    array (
      'labelValue' => 'numparcial7',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial7_c',
      'vname' => 'LBL_NUMPARCIAL7',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial7_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial12_c' => 
    array (
      'labelValue' => 'numparcial12',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial12_c',
      'vname' => 'LBL_NUMPARCIAL12',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial12_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial19_c' => 
    array (
      'labelValue' => 'parcial19',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial19_c',
      'vname' => 'LBL_PARCIAL19',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial19_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_estado_c' => 
    array (
      'labelValue' => 'sc estado',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_estado_c',
      'vname' => 'LBL_SC_ESTADO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_estado_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial23_c' => 
    array (
      'labelValue' => 'numparcial23',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial23_c',
      'vname' => 'LBL_NUMPARCIAL23',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial23_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt13_c' => 
    array (
      'labelValue' => 'vPt13',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt13_c',
      'vname' => 'LBL_VPT13',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt13_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task27_c' => 
    array (
      'labelValue' => 'task27',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task27_c',
      'vname' => 'LBL_TASK27',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask27_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt34_c' => 
    array (
      'labelValue' => 'vPt34',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt34_c',
      'vname' => 'LBL_VPT34',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt34_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial17_c' => 
    array (
      'labelValue' => 'parcial17',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial17_c',
      'vname' => 'LBL_PARCIAL17',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial17_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_email_c' => 
    array (
      'labelValue' => 'sc Email',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_email_c',
      'vname' => 'LBL_SC_EMAIL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_email_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega4_c' => 
    array (
      'labelValue' => 'Entrega4',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega4_c',
      'vname' => 'LBL_CM_ENTREGA4',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega4_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare8_c' => 
    array (
      'labelValue' => 'pagare8',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare8_c',
      'vname' => 'LBL_PAGARE8',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare8_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial2_c' => 
    array (
      'labelValue' => 'parcial2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial2_c',
      'vname' => 'LBL_PARCIAL2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'entregado_c' => 
    array (
      'labelValue' => '¿Equipo entregado?',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'entregado_c',
      'vname' => 'LBL_ENTREGADO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'entregado_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicesentregado_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'razon_por_la_que_se_detiene__c' => 
    array (
      'labelValue' => 'razon por la que se detiene',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'razon_por_la_que_se_detiene__c',
      'vname' => 'LBL_RAZON_POR_LA_QUE_SE_DETIENE_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => 'ESCRIBA LAS RAZONES DETALLADAS POR LAS QUE SE DETUVO LA ORDEN',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesrazon_por_la_que_se_detiene__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial24_c' => 
    array (
      'labelValue' => 'numparcial24',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial24_c',
      'vname' => 'LBL_NUMPARCIAL24',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial24_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'fecha_enganche_2_c' => 
    array (
      'labelValue' => 'Fecha Enganche 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_enganche_2_c',
      'vname' => 'LBL_FECHA_ENGANCHE_2',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesfecha_enganche_2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task14_c' => 
    array (
      'labelValue' => 'task14',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task14_c',
      'vname' => 'LBL_TASK14',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask14_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r1_celular_c' => 
    array (
      'labelValue' => 'Celular Ref 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r1_celular_c',
      'vname' => 'LBL_SC_R1_CELULAR',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r1_celular_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial29_c' => 
    array (
      'labelValue' => 'numparcial29',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial29_c',
      'vname' => 'LBL_NUMPARCIAL29',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial29_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_15_c' => 
    array (
      'labelValue' => 'contador 15',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_15_c',
      'vname' => 'LBL_CONTADOR_15',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_15_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial34_c' => 
    array (
      'labelValue' => 'parcial34',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial34_c',
      'vname' => 'LBL_PARCIAL34',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial34_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vendido_por_ord_c' => 
    array (
      'labelValue' => 'vendido por ord',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vendido_por_ord_c',
      'vname' => 'LBL_VENDIDO_POR_ORD',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesvendido_por_ord_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare23_c' => 
    array (
      'labelValue' => 'pagare23',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare23_c',
      'vname' => 'LBL_PAGARE23',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare23_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r1_tel_consultorio_c' => 
    array (
      'labelValue' => 'Tel Consultorio Ref 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r1_tel_consultorio_c',
      'vname' => 'LBL_SC_R1_TEL_CONSULTORIO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r1_tel_consultorio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_celular_c' => 
    array (
      'labelValue' => 'sc Celular',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_celular_c',
      'vname' => 'LBL_SC_CELULAR',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_celular_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'tipo_de_orden_c' => 
    array (
      'labelValue' => 'Linea de Producto (Marca)',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tipo_de_orden_c',
      'vname' => 'LBL_TIPO_DE_ORDEN',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'tipo_de_orden_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicestipo_de_orden_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r1_nombre_completo_c' => 
    array (
      'labelValue' => ' Nombre Completo Ref 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r1_nombre_completo_c',
      'vname' => 'LBL_SC_R1_NOMBRE_COMPLETO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r1_nombre_completo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'no_guia_c' => 
    array (
      'labelValue' => 'No. de guia para envío',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'no_guia_c',
      'vname' => 'LBL_NO_GUIA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '80',
      'size' => '20',
      'id' => 'AOS_Invoicesno_guia_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare6_c' => 
    array (
      'labelValue' => 'pagare6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare6_c',
      'vname' => 'LBL_PAGARE6',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare6_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare10_c' => 
    array (
      'labelValue' => 'pagare10',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare10_c',
      'vname' => 'LBL_PAGARE10',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare10_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad2_c' => 
    array (
      'labelValue' => 'mensualidad2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad2_c',
      'vname' => 'LBL_MENSUALIDAD2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial31_c' => 
    array (
      'labelValue' => 'parcial31',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial31_c',
      'vname' => 'LBL_PARCIAL31',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial31_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task8_c' => 
    array (
      'labelValue' => 'task8',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task8_c',
      'vname' => 'LBL_TASK8',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask8_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial35_c' => 
    array (
      'labelValue' => 'numparcial35',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial35_c',
      'vname' => 'LBL_NUMPARCIAL35',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial35_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt24_c' => 
    array (
      'labelValue' => 'vpt24',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt24_c',
      'vname' => 'LBL_VPT24',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt24_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_20_c' => 
    array (
      'labelValue' => 'contador 20',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_20_c',
      'vname' => 'LBL_CONTADOR_20',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_20_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_del_enganche_1_c' => 
    array (
      'labelValue' => 'Importe del Anticipo 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_del_enganche_1_c',
      'vname' => 'LBL_IMPORTE_DEL_ENGANCHE_1',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_del_enganche_1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_dr_a_cargo_c' => 
    array (
      'labelValue' => 'La Investigacion estara a cargo del Dr.(a)  ',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_dr_a_cargo_c',
      'vname' => 'LBL_CM_DR_A_CARGO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '80',
      'size' => '20',
      'id' => 'AOS_Invoicescm_dr_a_cargo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial31_c' => 
    array (
      'labelValue' => 'numparcial31',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial31_c',
      'vname' => 'LBL_NUMPARCIAL31',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial31_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad33_c' => 
    array (
      'labelValue' => 'mensualidad33',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad33_c',
      'vname' => 'LBL_MENSUALIDAD33',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad33_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'observ_de_la_devolucion_c' => 
    array (
      'labelValue' => 'Observ de la devolucion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'observ_de_la_devolucion_c',
      'vname' => 'LBL_OBSERV_DE_LA_DEVOLUCION',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '10',
      'id' => 'AOS_Invoicesobserv_de_la_devolucion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad23_c' => 
    array (
      'labelValue' => 'mensualidad23',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad23_c',
      'vname' => 'LBL_MENSUALIDAD23',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad23_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial16_c' => 
    array (
      'labelValue' => 'parcial16',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial16_c',
      'vname' => 'LBL_PARCIAL16',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial16_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'referido_por__c' => 
    array (
      'labelValue' => 'PARTICIPANTE',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'referido_por__c',
      'vname' => 'LBL_REFERIDO_POR_',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ventas_referido_por__list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicesreferido_por__c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r1_direccion_c' => 
    array (
      'labelValue' => 'Direccion Ref 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r1_direccion_c',
      'vname' => 'LBL_SC_R1_DIRECCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r1_direccion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_numext_c' => 
    array (
      'labelValue' => 'sc NumExt',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_numext_c',
      'vname' => 'LBL_SC_NUMEXT',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_numext_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad7_c' => 
    array (
      'labelValue' => 'mensualidad7',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad7_c',
      'vname' => 'LBL_MENSUALIDAD7',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad7_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_telefono2_c' => 
    array (
      'labelValue' => 'sc Telefono2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_telefono2_c',
      'vname' => 'LBL_SC_TELEFONO2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_telefono2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_24_c' => 
    array (
      'labelValue' => 'contador 24',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_24_c',
      'vname' => 'LBL_CONTADOR_24',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_24_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare33_c' => 
    array (
      'labelValue' => 'pagare33',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare33_c',
      'vname' => 'LBL_PAGARE33',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare33_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_23_c' => 
    array (
      'labelValue' => 'contador 23',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_23_c',
      'vname' => 'LBL_CONTADOR_23',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_23_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare35_c' => 
    array (
      'labelValue' => 'pagare35',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare35_c',
      'vname' => 'LBL_PAGARE35',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare35_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega3_c' => 
    array (
      'labelValue' => 'Entrega3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega3_c',
      'vname' => 'LBL_CM_ENTREGA3',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad12_c' => 
    array (
      'labelValue' => 'mensualidad12',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad12_c',
      'vname' => 'LBL_MENSUALIDAD12',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad12_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial1_c' => 
    array (
      'labelValue' => 'parcial1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial1_c',
      'vname' => 'LBL_PARCIAL1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'fecha_enganche_1_c' => 
    array (
      'labelValue' => 'Fecha Enganche 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_enganche_1_c',
      'vname' => 'LBL_FECHA_ENGANCHE_1',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesfecha_enganche_1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'costo_empaque_c' => 
    array (
      'labelValue' => ' (No usar)COSTO empaque',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'costo_empaque_c',
      'vname' => 'LBL_COSTO_EMPAQUE',
      'type' => 'dynamicenum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ENVIO_COST_EXTRA_list',
      'studio' => 'visible',
      'dbType' => 'enum',
      'parentenum' => 'MOD_CAJA_list',
      'id' => 'AOS_Invoicescosto_empaque_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial1_c' => 
    array (
      'labelValue' => 'numparcial1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial1_c',
      'vname' => 'LBL_NUMPARCIAL1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r1_telefono_c' => 
    array (
      'labelValue' => 'Tel Ref 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r1_telefono_c',
      'vname' => 'LBL_SC_R1_TELEFONO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r1_telefono_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare11_c' => 
    array (
      'labelValue' => 'pagare11',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare11_c',
      'vname' => 'LBL_PAGARE11',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare11_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial16_c' => 
    array (
      'labelValue' => 'numparcial16',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial16_c',
      'vname' => 'LBL_NUMPARCIAL16',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial16_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'total_orden_c' => 
    array (
      'labelValue' => 'Total de Orden',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'total_orden_c',
      'vname' => 'LBL_TOTAL_ORDEN',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicestotal_orden_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare25_c' => 
    array (
      'labelValue' => 'pagare25',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare25_c',
      'vname' => 'LBL_PAGARE25',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare25_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega10_c' => 
    array (
      'labelValue' => 'Entrega10',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega10_c',
      'vname' => 'LBL_CM_ENTREGA10',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega10_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt33_c' => 
    array (
      'labelValue' => 'vPt33',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt33_c',
      'vname' => 'LBL_VPT33',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt33_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'equipo_con_bloqueos_c' => 
    array (
      'labelValue' => 'Equipo con Bloqueos',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'equipo_con_bloqueos_c',
      'vname' => 'LBL_EQUIPO_CON_BLOQUEOS',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'NO',
      'no_default' => false,
      'comments' => '',
      'help' => 'seleccione si el equipo va bloqueado o no',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'equipo_c_Bloqueos_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicesequipo_con_bloqueos_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task30_c' => 
    array (
      'labelValue' => 'task30',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task30_c',
      'vname' => 'LBL_TASK30',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask30_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_27_c' => 
    array (
      'labelValue' => 'contador 27',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_27_c',
      'vname' => 'LBL_CONTADOR_27',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_27_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'task22_c' => 
    array (
      'labelValue' => 'task22',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'task22_c',
      'vname' => 'LBL_TASK22',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '55',
      'size' => '20',
      'id' => 'AOS_Invoicestask22_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_lab_calle_c' => 
    array (
      'labelValue' => 'sc Lab Calle',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_lab_calle_c',
      'vname' => '',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_lab_calle_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare22_c' => 
    array (
      'labelValue' => 'pagare22',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare22_c',
      'vname' => 'LBL_PAGARE22',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare22_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_envio_c' => 
    array (
      'labelValue' => 'Importe de Envío',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_envio_c',
      'vname' => 'LBL_IMPORTE_ENVIO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'Cuanto cobramos por el envio',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_envio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'congreso_text_c' => 
    array (
      'labelValue' => 'Congreso Text',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'congreso_text_c',
      'vname' => 'LBL_CONGRESO_TEXT',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '40',
      'size' => '20',
      'id' => 'AOS_Invoicescongreso_text_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'mensualidad30_c' => 
    array (
      'labelValue' => 'mensualidad30',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'mensualidad30_c',
      'vname' => 'LBL_MENSUALIDAD30',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesmensualidad30_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial26_c' => 
    array (
      'labelValue' => 'numparcial26',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial26_c',
      'vname' => 'LBL_NUMPARCIAL26',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial26_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp20_c' => 
    array (
      'labelValue' => 'vp20',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp20_c',
      'vname' => 'LBL_VP20',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp20_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial34_c' => 
    array (
      'labelValue' => 'numparcial34',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial34_c',
      'vname' => 'LBL_NUMPARCIAL34',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial34_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vpt35_c' => 
    array (
      'labelValue' => 'vPt35',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vpt35_c',
      'vname' => 'LBL_VPT35',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Invoicesvpt35_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp25_c' => 
    array (
      'labelValue' => 'vP25',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp25_c',
      'vname' => 'LBL_VP25',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp25_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_2_c' => 
    array (
      'labelValue' => 'contador 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_2_c',
      'vname' => 'LBL_CONTADOR_2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial5_c' => 
    array (
      'labelValue' => 'parcial5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial5_c',
      'vname' => 'LBL_PARCIAL5',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial5_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial4_c' => 
    array (
      'labelValue' => 'numparcial4',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial4_c',
      'vname' => 'LBL_NUMPARCIAL4',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial4_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_gasto_administrativo_c' => 
    array (
      'labelValue' => 'Importe de Gasto Adm',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_gasto_administrativo_c',
      'vname' => 'LBL_IMPORTE_GASTO_ADMINISTRATIVO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_gasto_administrativo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numparcial9_c' => 
    array (
      'labelValue' => 'numparcial9',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numparcial9_c',
      'vname' => 'LBL_NUMPARCIAL9',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'AOS_Invoicesnumparcial9_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r1_email_c' => 
    array (
      'labelValue' => 'e-mail Ref 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r1_email_c',
      'vname' => 'LBL_SC_R1_EMAIL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r1_email_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial7_c' => 
    array (
      'labelValue' => 'parcial7',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial7_c',
      'vname' => 'LBL_PARCIAL7',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial7_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pagare14_c' => 
    array (
      'labelValue' => 'pagare14',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pagare14_c',
      'vname' => 'LBL_PAGARE14',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '16',
      'size' => '20',
      'id' => 'AOS_Invoicespagare14_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'precio_producto_c' => 
    array (
      'labelValue' => 'Precio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'precio_producto_c',
      'vname' => 'LBL_PRECIO_PRODUCTO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesprecio_producto_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp19_c' => 
    array (
      'labelValue' => 'vp19',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp19_c',
      'vname' => 'LBL_VP19',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp19_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'parcial13_c' => 
    array (
      'labelValue' => 'parcial13',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'parcial13_c',
      'vname' => 'LBL_PARCIAL13',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '15',
      'size' => '20',
      'id' => 'AOS_Invoicesparcial13_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'acase_id_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'acase_id_c',
      'vname' => 'LBL_SERVICIO_ACASE_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'AOS_Invoicesacase_id_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'agendado_cobranza_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'agendado_cobranza_c',
      'vname' => 'LBL_AGENDADO_COBRANZA',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesagendado_cobranza_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'genera_cobranza_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'genera_cobranza_c',
      'vname' => 'LBL_GENERA_COBRANZA',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesgenera_cobranza_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sidt_de_pagos_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sidt_de_pagos_c',
      'vname' => 'LBL_SIDT_DE_PAGOS',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'si el equipo lleva los pagos programados y va a requerir codico de desbloqueo ',
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessidt_de_pagos_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sist_de_pagos_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sist_de_pagos_c',
      'vname' => 'LBL_SIST_DE_PAGOS',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'NO',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Sist_de_Pagos_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicessist_de_pagos_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'user_id_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'user_id_c',
      'vname' => 'LBL_EJECUTIVO_DE_COBRANZA_USER_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'AOS_Invoicesuser_id_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vcalle_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vcalle_c',
      'vname' => 'LBL_VCALLE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesvcalle_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vespecialidad_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vespecialidad_c',
      'vname' => 'LBL_VESPECIALIDAD',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'E_list_ESPECIALIDAD',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicesvespecialidad_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vnombre_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vnombre_c',
      'vname' => 'LBL_VNOMBRE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesvnombre_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vtelefono_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vtelefono_c',
      'vname' => 'LBL_VTELEFONO',
      'type' => 'phone',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'dbType' => 'varchar',
      'id' => 'AOS_Invoicesvtelefono_c',
      'custom_module' => 'AOS_Invoices',
    ),
  ),
  'relationships' => 
  array (
    'aos_invoices_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Invoices',
      'rhs_table' => 'aos_invoices',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'aos_invoices_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Invoices',
      'rhs_table' => 'aos_invoices',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'aos_invoices_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Invoices',
      'rhs_table' => 'aos_invoices',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'aos_invoices_aos_product_quotes' => 
    array (
      'lhs_module' => 'AOS_Invoices',
      'lhs_table' => 'aos_invoices',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Products_Quotes',
      'rhs_table' => 'aos_products_quotes',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
    ),
    'aos_invoices_aos_line_item_groups' => 
    array (
      'lhs_module' => 'AOS_Invoices',
      'lhs_table' => 'aos_invoices',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Line_Item_Groups',
      'rhs_table' => 'aos_line_item_groups',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_lock' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'aos_invoicespk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);