<?php 
 $GLOBALS["dictionary"]["ANTI_Anticipos"]=array (
  'table' => 'anti_anticipos',
  'audited' => true,
  'duplicate_merge' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_SUBJECT',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'audited' => true,
      'unified_search' => false,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'The short description of the bug',
      'merge_filter' => 'disabled',
      'required' => false,
      'importable' => 'required',
      'comments' => 'The short description of the bug',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'anti_anticipos_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'anti_anticipos_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'anti_anticipos_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'anti_anticipos_number' => 
    array (
      'name' => 'anti_anticipos_number',
      'vname' => 'LBL_NUMBER',
      'type' => 'int',
      'readonly' => true,
      'len' => 11,
      'required' => true,
      'auto_increment' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'Visual unique identifier',
      'duplicate_merge' => 'disabled',
      'disable_num_format' => true,
      'studio' => 
      array (
        'quickcreate' => false,
      ),
    ),
    'type' => 
    array (
      'name' => 'type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'options' => 'anti_anticipos_type_dom',
      'len' => 255,
      'comment' => 'The type of issue (ex: issue, feature)',
      'merge_filter' => 'enabled',
    ),
    'status' => 
    array (
      'name' => 'status',
      'vname' => 'LBL_STATUS',
      'type' => 'enum',
      'options' => 'anti_anticipos_status_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'The status of the issue',
      'merge_filter' => 'enabled',
    ),
    'priority' => 
    array (
      'name' => 'priority',
      'vname' => 'LBL_PRIORITY',
      'type' => 'enum',
      'options' => 'anti_anticipos_priority_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'An indication of the priorty of the issue',
      'merge_filter' => 'enabled',
    ),
    'resolution' => 
    array (
      'name' => 'resolution',
      'vname' => 'LBL_RESOLUTION',
      'type' => 'enum',
      'options' => 'anti_anticipos_resolution_dom',
      'len' => 255,
      'audited' => true,
      'comment' => 'An indication of how the issue was resolved',
      'merge_filter' => 'enabled',
    ),
    'work_log' => 
    array (
      'name' => 'work_log',
      'vname' => 'LBL_WORK_LOG',
      'type' => 'text',
      'comment' => 'Free-form text used to denote activities of interest',
    ),
    'accounts_anti_anticipos_1' => 
    array (
      'name' => 'accounts_anti_anticipos_1',
      'type' => 'link',
      'relationship' => 'accounts_anti_anticipos_1',
      'source' => 'non-db',
      'module' => 'Accounts',
      'bean_name' => 'Account',
      'vname' => 'LBL_ACCOUNTS_ANTI_ANTICIPOS_1_FROM_ACCOUNTS_TITLE',
      'id_name' => 'accounts_anti_anticipos_1accounts_ida',
    ),
    'accounts_anti_anticipos_1_name' => 
    array (
      'name' => 'accounts_anti_anticipos_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_ACCOUNTS_ANTI_ANTICIPOS_1_FROM_ACCOUNTS_TITLE',
      'save' => true,
      'id_name' => 'accounts_anti_anticipos_1accounts_ida',
      'link' => 'accounts_anti_anticipos_1',
      'table' => 'accounts',
      'module' => 'Accounts',
      'rname' => 'name',
    ),
    'accounts_anti_anticipos_1accounts_ida' => 
    array (
      'name' => 'accounts_anti_anticipos_1accounts_ida',
      'type' => 'link',
      'relationship' => 'accounts_anti_anticipos_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_ACCOUNTS_ANTI_ANTICIPOS_1_FROM_ANTI_ANTICIPOS_TITLE',
    ),
    'retorno_mov_c' => 
    array (
      'labelValue' => 'Retorno Mov',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'retorno_mov_c',
      'vname' => 'RETORNO MOV :',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'ANTI_Anticiposretorno_mov_c',
      'custom_module' => 'ANTI_Anticipos',
    ),
    'aplicado_a_orden__c' => 
    array (
      'labelValue' => 'aplicado a orden',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'aplicado_a_orden__c',
      'vname' => 'LBL_APLICADO_A_ORDEN_',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'ANTI_Anticiposaplicado_a_orden__c',
      'custom_module' => 'ANTI_Anticipos',
    ),
    'forma_de_pago_c' => 
    array (
      'labelValue' => 'Forma de Pago',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'forma_de_pago_c',
      'vname' => 'LBL_FORMA_DE_PAGO',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => 'Seleccione',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'forma_de_pago_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'ANTI_Anticiposforma_de_pago_c',
      'custom_module' => 'ANTI_Anticipos',
    ),
    'importe_del_anticipo_c' => 
    array (
      'labelValue' => 'Importe',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'importe_del_anticipo_c',
      'vname' => 'LBL_IMPORTE_DEL_ANTICIPO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'ANTI_Anticiposimporte_del_anticipo_c',
      'custom_module' => 'ANTI_Anticipos',
    ),
    'factura_ant_c' => 
    array (
      'labelValue' => 'Factura',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'factura_ant_c',
      'vname' => 'LBL_FACTURA_ANT',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Captura el nunero de factura cuando se facture el antcipo  y aun no haya orden',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'ANTI_Anticiposfactura_ant_c',
      'custom_module' => 'ANTI_Anticipos',
    ),
    'cuatro_digitos_c' => 
    array (
      'labelValue' => '4 últimos dígitos de la TC',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cuatro_digitos_c',
      'vname' => 'LBL_CUATRO_DIGITOS',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'ANTI_Anticiposcuatro_digitos_c',
      'custom_module' => 'ANTI_Anticipos',
    ),
    'aplicado_folio_pago_c' => 
    array (
      'labelValue' => 'aplicado folio pago',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'aplicado_folio_pago_c',
      'vname' => 'LBL_APLICADO_FOLIO_PAGO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '10',
      'size' => '20',
      'id' => 'ANTI_Anticiposaplicado_folio_pago_c',
      'custom_module' => 'ANTI_Anticipos',
    ),
    'autorizacion_c' => 
    array (
      'labelValue' => 'Autorización del Banco',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'autorizacion_c',
      'vname' => 'LBL_AUTORIZACION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'ANTI_Anticiposautorizacion_c',
      'custom_module' => 'ANTI_Anticipos',
    ),
    'pagos_pagos_de_clientes_anti_anticipos_1' => 
    array (
      'name' => 'pagos_pagos_de_clientes_anti_anticipos_1',
      'type' => 'link',
      'relationship' => 'pagos_pagos_de_clientes_anti_anticipos_1',
      'source' => 'non-db',
      'module' => 'Pagos_Pagos_de_Clientes',
      'bean_name' => 'Pagos_Pagos_de_Clientes',
      'vname' => 'LBL_PAGOS_PAGOS_DE_CLIENTES_ANTI_ANTICIPOS_1_FROM_PAGOS_PAGOS_DE_CLIENTES_TITLE',
      'id_name' => 'pagos_pago3c17lientes_ida',
    ),
    'pagos_pagos_de_clientes_anti_anticipos_1_name' => 
    array (
      'name' => 'pagos_pagos_de_clientes_anti_anticipos_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_PAGOS_PAGOS_DE_CLIENTES_ANTI_ANTICIPOS_1_FROM_PAGOS_PAGOS_DE_CLIENTES_TITLE',
      'save' => true,
      'id_name' => 'pagos_pago3c17lientes_ida',
      'link' => 'pagos_pagos_de_clientes_anti_anticipos_1',
      'table' => 'pagos_pagos_de_clientes',
      'module' => 'Pagos_Pagos_de_Clientes',
      'rname' => 'name',
    ),
    'pagos_pago3c17lientes_ida' => 
    array (
      'name' => 'pagos_pago3c17lientes_ida',
      'type' => 'link',
      'relationship' => 'pagos_pagos_de_clientes_anti_anticipos_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'left',
      'vname' => 'LBL_PAGOS_PAGOS_DE_CLIENTES_ANTI_ANTICIPOS_1_FROM_PAGOS_PAGOS_DE_CLIENTES_TITLE',
    ),
    'folio_fisico_del_anticipo_c' => 
    array (
      'labelValue' => 'Folio fisico del Anticipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'folio_fisico_del_anticipo_c',
      'vname' => 'LBL_FOLIO_FISICO_DEL_ANTICIPO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'ANTI_Anticiposfolio_fisico_del_anticipo_c',
      'custom_module' => 'ANTI_Anticipos',
    ),
    'obs_c' => 
    array (
      'labelValue' => 'Observaciones del pago',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'obs_c',
      'vname' => 'LBL_OBS',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'ANTI_Anticiposobs_c',
      'custom_module' => 'ANTI_Anticipos',
    ),
    'fecha_de_recepcion_c' => 
    array (
      'options' => 'date_range_search_dom',
      'labelValue' => 'Fecha Recepción',
      'enable_range_search' => '1',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'fecha_de_recepcion_c',
      'vname' => 'LBL_FECHA_DE_RECEPCION',
      'type' => 'date',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'display_default' => 'now',
      'id' => 'ANTI_Anticiposfecha_de_recepcion_c',
      'custom_module' => 'ANTI_Anticipos',
    ),
    'para_la_orden_c' => 
    array (
      'labelValue' => 'Para la Orden',
      'required' => false,
      'source' => 'non-db',
      'name' => 'para_la_orden_c',
      'vname' => 'LBL_PARA_LA_ORDEN',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'aos_invoices_id_c',
      'ext2' => 'AOS_Invoices',
      'module' => 'AOS_Invoices',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'ANTI_Anticipospara_la_orden_c',
      'custom_module' => 'ANTI_Anticipos',
    ),
    'aos_invoices_id_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'aos_invoices_id_c',
      'vname' => 'LBL_PARA_LA_ORDEN_AOS_INVOICES_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'ANTI_Anticiposaos_invoices_id_c',
      'custom_module' => 'ANTI_Anticipos',
    ),
    'currency_id' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'currency_id',
      'vname' => 'LBL_CURRENCY',
      'type' => 'currency_id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'dbType' => 'id',
      'studio' => 'visible',
      'function' => 
      array (
        'name' => 'getCurrencyDropDown',
        'returns' => 'html',
      ),
      'id' => 'ANTI_Anticiposcurrency_id',
      'custom_module' => 'ANTI_Anticipos',
    ),
  ),
  'relationships' => 
  array (
    'anti_anticipos_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'ANTI_Anticipos',
      'rhs_table' => 'anti_anticipos',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'anti_anticipos_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'ANTI_Anticipos',
      'rhs_table' => 'anti_anticipos',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'anti_anticipos_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'ANTI_Anticipos',
      'rhs_table' => 'anti_anticipos',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_locking' => true,
  'unified_search' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'anti_anticipospk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
    'number' => 
    array (
      'name' => 'anti_anticiposnumk',
      'type' => 'unique',
      'fields' => 
      array (
        0 => 'anti_anticipos_number',
      ),
    ),
  ),
  'templates' => 
  array (
    'issue' => 'issue',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);