<?php 
 $GLOBALS["dictionary"]["Call"]=array (
  'table' => 'calls',
  'comment' => 'A Call is an activity representing a phone call',
  'unified_search' => true,
  'full_text_search' => true,
  'unified_search_default_enabled' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_SUBJECT',
      'dbType' => 'varchar',
      'type' => 'name',
      'len' => '120',
      'comment' => 'Brief description of the call',
      'unified_search' => true,
      'full_text_search' => 
      array (
      ),
      'required' => true,
      'importable' => 'required',
      'comments' => 'Brief description of the call',
      'merge_filter' => 'disabled',
      'help' => 'Breve descripcion del MOTIVO de la actividad (de modo particular), Ej. :    Demo Laser,     Seguimiento de Anticipo,    Concertar cita,   Recoger equipo   , etc.  (2 o 3 palabras)',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'comments' => 'Date record created',
      'merge_filter' => 'disabled',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'comments' => 'Date record last modified',
      'merge_filter' => 'disabled',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => '70',
      'comments' => 'Has una descripcion de la actividad  que vas a realizar. Mientras  mas detallada MEJOR, te facilitara el trabajo en el futuro,    Debes  poner todos los datos relevantes:   con quien vas a hablar,    que tema o punto vas a tratar,   si esta relacionado con algun pendiente,  seguimiento o  algun otro asunto,     Que esperas obtener con esta actividad,    de modo que tengas toda la informacion a la mano y  no requieras de consultar ningun otra fuente en el momento de realizar tu actividad ',
      'merge_filter' => 'disabled',
      'help' => 'Has una descripcion de la actividad  que vas a realizar. Mientras  mas detallada MEJOR, te facilitara el trabajo en el futuro,    Debes  poner todos los datos relevantes:   con quien vas a hablar,    que tema o punto vas a tratar,   si esta relacionado con algun pendiente,  seguimiento o  algun otro asunto,     Que esperas obtener con esta actividad,    de modo que tengas toda la informacion a la mano y  no requieras de consultar ningun otra fuente en el momento de realizar tu actividad ',
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'calls_created_by',
      'vname' => 'LBL_CREATED_BY_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'calls_modified_user',
      'vname' => 'LBL_MODIFIED_BY_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'calls_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'duration_hours' => 
    array (
      'name' => 'duration_hours',
      'vname' => 'LBL_DURATION_HOURS',
      'type' => 'int',
      'len' => '2',
      'comment' => 'Call duration, hours portion',
      'required' => true,
      'comments' => 'Call duration, hours portion',
      'merge_filter' => 'disabled',
      'enable_range_search' => false,
      'min' => false,
      'max' => false,
      'disable_num_format' => '',
      'help' => 'Captura las horas y/o minutos  que planeas que dure tu actividad ',
    ),
    'duration_minutes' => 
    array (
      'name' => 'duration_minutes',
      'vname' => 'LBL_DURATION_MINUTES',
      'type' => 'int',
      'function' => 
      array (
        'name' => 'getDurationMinutesOptions',
        'returns' => 'html',
        'include' => 'modules/Calls/CallHelper.php',
      ),
      'len' => '2',
      'group' => 'duration_hours',
      'importable' => 'required',
      'comment' => 'Call duration, minutes portion',
      'comments' => 'Call duration, minutes portion',
      'merge_filter' => 'disabled',
      'enable_range_search' => false,
      'min' => false,
      'max' => false,
      'disable_num_format' => '',
      'help' => 'Minutos   de  duracioacute;n: Captura las horas y/o minutos  que planeas que dure tu actividad ',
    ),
    'date_start' => 
    array (
      'name' => 'date_start',
      'vname' => 'LBL_DATE',
      'type' => 'datetimecombo',
      'dbType' => 'datetime',
      'comment' => 'Date in which call is schedule to (or did) start',
      'importable' => 'required',
      'required' => true,
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'comments' => 'Date in which call is schedule to (or did) start',
      'merge_filter' => 'disabled',
      'help' => 'Selecciona EN EL CALENDARIO  la fecha  y en los  campos LA HORA  en la que quieres  agendar EL INICIO de  tu actividad. Esta actividad se desplegara en tu calendario de actividades General en la fecha y la hora que tu designes, (Para consultarlo tu calendario  ve  a MENU-CALENDARIO) En la parte inferior de esta pantalla te muestra  las horas del dia que tienes libres para  agendar tu actividad  ',
    ),
    'date_end' => 
    array (
      'name' => 'date_end',
      'vname' => 'LBL_DATE_END',
      'type' => 'datetimecombo',
      'dbType' => 'datetime',
      'massupdate' => false,
      'comment' => 'Date is which call is scheduled to (or did) end',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'comments' => 'Date is which call is scheduled to (or did) end',
      'merge_filter' => 'disabled',
      'help' => 'Selecciona EN EL CALENDARIO  la fecha  y en los  campos LA HORA  en la que planeas  TERMINAR tu actividad. Esta actividad se desplegara en tu calendario de actividades General en la fecha y la hora que tu designes, (Para consultarlo tu calendario  ve  a MENU-CALENDARIO) En la parte inferior de esta pantalla te muestra  las horas del dia que tienes libres para  agendar tu actividad  ',
    ),
    'parent_type' => 
    array (
      'name' => 'parent_type',
      'vname' => 'LBL_PARENT_TYPE',
      'type' => 'parent_type',
      'dbType' => 'varchar',
      'required' => false,
      'group' => 'parent_name',
      'options' => 'parent_type_display',
      'len' => 255,
      'comment' => 'The Sugar object to which the call is related',
    ),
    'parent_name' => 
    array (
      'name' => 'parent_name',
      'parent_type' => 'record_type_display',
      'type_name' => 'parent_type',
      'id_name' => 'parent_id',
      'vname' => 'LBL_LIST_RELATED_TO',
      'type' => 'parent',
      'group' => 'parent_name',
      'source' => 'non-db',
      'options' => 'parent_type_display',
    ),
    'status' => 
    array (
      'name' => 'status',
      'vname' => 'LBL_STATUS',
      'type' => 'enum',
      'len' => 100,
      'options' => 'call_status_dom',
      'comment' => 'The status of the call (Held, Not Held, etc.)',
      'required' => true,
      'importable' => 'required',
      'default' => 'Planned',
      'studio' => 
      array (
        'detailview' => false,
      ),
      'comments' => 'The status of the call (Held, Not Held, etc.)',
      'merge_filter' => 'disabled',
      'help' => 'Una vez que HAYAS REALIZADO tu actividad  cambia el estado de PENDIENTE  a REALIZADA  de modo que  el sistema  detecte que YA ATENDISTE ESTA ACTIVIDAD  ',
    ),
    'direction' => 
    array (
      'name' => 'direction',
      'vname' => 'LBL_DIRECTION',
      'type' => 'enum',
      'len' => 100,
      'options' => 'call_direction_dom',
      'comment' => 'Indicates whether call is inbound or outbound',
      'default' => 'Inbound',
      'comments' => 'Indicates whether call is inbound or outbound',
      'merge_filter' => 'disabled',
      'help' => 'La actividad  es: SALIENTE (cuando la actividad es desde la compania  hacia  el exterior (Nosotros buscamos al cliente) La actividad  es: ENTRANTE  (cuando la actividad es desde el exterior hacia  la compania  (El cliente nos contacta)',
    ),
    'parent_id' => 
    array (
      'name' => 'parent_id',
      'vname' => 'LBL_LIST_RELATED_TO_ID',
      'type' => 'id',
      'group' => 'parent_name',
      'reportable' => false,
      'comment' => 'The ID of the parent Sugar object identified by parent_type',
    ),
    'reminder_checked' => 
    array (
      'name' => 'reminder_checked',
      'vname' => 'LBL_REMINDER',
      'type' => 'bool',
      'source' => 'non-db',
      'comment' => 'checkbox indicating whether or not the reminder value is set (Meta-data only)',
      'massupdate' => false,
    ),
    'reminder_time' => 
    array (
      'name' => 'reminder_time',
      'vname' => 'LBL_REMINDER_TIME',
      'type' => 'enum',
      'dbType' => 'int',
      'options' => 'reminder_time_options',
      'reportable' => true,
      'massupdate' => false,
      'default' => '60',
      'comment' => 'Specifies when a reminder alert should be issued; -1 means no alert; otherwise the number of seconds prior to the start',
      'comments' => 'Specifies when a reminder alert should be issued; -1 means no alert; otherwise the number of seconds prior to the start',
      'merge_filter' => 'disabled',
      'help' => 'El sistema te mostrara una pantalla emergente (como recordatorio)  de tu actividad, con el tiempo de anticipaci&oacute;n que tu selecciones',
    ),
    'email_reminder_checked' => 
    array (
      'name' => 'email_reminder_checked',
      'vname' => 'LBL_EMAIL_REMINDER',
      'type' => 'bool',
      'source' => 'non-db',
      'comment' => 'checkbox indicating whether or not the email reminder value is set (Meta-data only)',
      'massupdate' => false,
    ),
    'email_reminder_time' => 
    array (
      'name' => 'email_reminder_time',
      'vname' => 'LBL_EMAIL_REMINDER_TIME',
      'type' => 'enum',
      'dbType' => 'int',
      'options' => 'reminder_time_options',
      'reportable' => true,
      'massupdate' => false,
      'default' => '60',
      'comment' => 'Specifies when a email reminder alert should be issued; -1 means no alert; otherwise the number of seconds prior to the start',
      'help' => 'El sistema te mostrara una pantalla emergente (como recordatorio)  de tu actividad, con el tiempo de anticipaci&oacute;n que tu selecciones',
      'comments' => 'Specifies when a email reminder alert should be issued; -1 means no alert; otherwise the number of seconds prior to the start',
      'merge_filter' => 'disabled',
    ),
    'email_reminder_sent' => 
    array (
      'name' => 'email_reminder_sent',
      'vname' => 'LBL_EMAIL_REMINDER_SENT',
      'default' => 0,
      'type' => 'bool',
      'comment' => 'Whether email reminder is already sent',
      'studio' => false,
      'massupdate' => false,
    ),
    'outlook_id' => 
    array (
      'name' => 'outlook_id',
      'vname' => 'LBL_OUTLOOK_ID',
      'type' => 'varchar',
      'len' => '255',
      'reportable' => false,
      'comment' => 'When the Sugar Plug-in for Microsoft Outlook syncs an Outlook appointment, this is the Outlook appointment item ID',
    ),
    'accept_status' => 
    array (
      'name' => 'accept_status',
      'vname' => 'LBL_ACCEPT_STATUS',
      'dbType' => 'varchar',
      'type' => 'varchar',
      'len' => '20',
      'source' => 'non-db',
    ),
    'set_accept_links' => 
    array (
      'name' => 'accept_status',
      'vname' => 'LBL_ACCEPT_LINK',
      'dbType' => 'varchar',
      'type' => 'varchar',
      'len' => '20',
      'source' => 'non-db',
    ),
    'contact_name' => 
    array (
      'name' => 'contact_name',
      'rname' => 'last_name',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
      'id_name' => 'contact_id',
      'massupdate' => false,
      'vname' => 'LBL_CONTACT_NAME',
      'type' => 'relate',
      'link' => 'contacts',
      'table' => 'contacts',
      'isnull' => 'true',
      'module' => 'Contacts',
      'join_name' => 'contacts',
      'dbType' => 'varchar',
      'source' => 'non-db',
      'len' => 36,
      'importable' => 'false',
      'studio' => 
      array (
        'required' => false,
        'listview' => true,
        'visible' => false,
      ),
    ),
    'opportunities' => 
    array (
      'name' => 'opportunities',
      'type' => 'link',
      'relationship' => 'opportunity_calls',
      'source' => 'non-db',
      'link_type' => 'one',
      'vname' => 'LBL_OPPORTUNITY',
    ),
    'leads' => 
    array (
      'name' => 'leads',
      'type' => 'link',
      'relationship' => 'calls_leads',
      'source' => 'non-db',
      'vname' => 'LBL_LEADS',
    ),
    'project' => 
    array (
      'name' => 'project',
      'type' => 'link',
      'relationship' => 'projects_calls',
      'source' => 'non-db',
      'vname' => 'LBL_PROJECTS',
    ),
    'case' => 
    array (
      'name' => 'case',
      'type' => 'link',
      'relationship' => 'case_calls',
      'source' => 'non-db',
      'link_type' => 'one',
      'vname' => 'LBL_CASE',
    ),
    'accounts' => 
    array (
      'name' => 'accounts',
      'type' => 'link',
      'relationship' => 'account_calls',
      'module' => 'Accounts',
      'bean_name' => 'Account',
      'source' => 'non-db',
      'vname' => 'LBL_ACCOUNT',
    ),
    'contacts' => 
    array (
      'name' => 'contacts',
      'type' => 'link',
      'relationship' => 'calls_contacts',
      'source' => 'non-db',
      'vname' => 'LBL_CONTACTS',
    ),
    'users' => 
    array (
      'name' => 'users',
      'type' => 'link',
      'relationship' => 'calls_users',
      'source' => 'non-db',
      'vname' => 'LBL_USERS',
    ),
    'notes' => 
    array (
      'name' => 'notes',
      'type' => 'link',
      'relationship' => 'calls_notes',
      'module' => 'Notes',
      'bean_name' => 'Note',
      'source' => 'non-db',
      'vname' => 'LBL_NOTES',
    ),
    'contact_id' => 
    array (
      'name' => 'contact_id',
      'type' => 'id',
      'source' => 'non-db',
    ),
    'repeat_type' => 
    array (
      'name' => 'repeat_type',
      'vname' => 'LBL_REPEAT_TYPE',
      'type' => 'enum',
      'len' => 36,
      'options' => 'repeat_type_dom',
      'comment' => 'Type of recurrence',
      'importable' => 'false',
      'massupdate' => false,
      'reportable' => false,
      'studio' => 'false',
    ),
    'repeat_interval' => 
    array (
      'name' => 'repeat_interval',
      'vname' => 'LBL_REPEAT_INTERVAL',
      'type' => 'int',
      'len' => 3,
      'default' => 1,
      'comment' => 'Interval of recurrence',
      'importable' => 'false',
      'massupdate' => false,
      'reportable' => false,
      'studio' => 'false',
    ),
    'repeat_dow' => 
    array (
      'name' => 'repeat_dow',
      'vname' => 'LBL_REPEAT_DOW',
      'type' => 'varchar',
      'len' => 7,
      'comment' => 'Days of week in recurrence',
      'importable' => 'false',
      'massupdate' => false,
      'reportable' => false,
      'studio' => 'false',
    ),
    'repeat_until' => 
    array (
      'name' => 'repeat_until',
      'vname' => 'LBL_REPEAT_UNTIL',
      'type' => 'date',
      'comment' => 'Repeat until specified date',
      'importable' => 'false',
      'massupdate' => false,
      'reportable' => false,
      'studio' => 'false',
    ),
    'repeat_count' => 
    array (
      'name' => 'repeat_count',
      'vname' => 'LBL_REPEAT_COUNT',
      'type' => 'int',
      'len' => 7,
      'comment' => 'Number of recurrence',
      'importable' => 'false',
      'massupdate' => false,
      'reportable' => false,
      'studio' => 'false',
    ),
    'repeat_parent_id' => 
    array (
      'name' => 'repeat_parent_id',
      'vname' => 'LBL_REPEAT_PARENT_ID',
      'type' => 'id',
      'len' => 36,
      'comment' => 'Id of the first element of recurring records',
      'importable' => 'false',
      'massupdate' => false,
      'reportable' => false,
      'studio' => 'false',
    ),
    'recurring_source' => 
    array (
      'name' => 'recurring_source',
      'vname' => 'LBL_RECURRING_SOURCE',
      'type' => 'varchar',
      'len' => 36,
      'comment' => 'Source of recurring call',
      'importable' => false,
      'massupdate' => false,
      'reportable' => false,
      'studio' => false,
    ),
    'resultado_c' => 
    array (
      'labelValue' => 'Resultado',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'resultado_c',
      'vname' => 'LBL_RESULTADO',
      'type' => 'text',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Redacta el resultado de tu actividad, Mientras  mas detallada MEJOR, pon los acuerdos  en los que quedaste,  las cosas con las que te comprometiste, todo lo que sucedio durante tu actividad  y cual sera el siguiente paso ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '6',
      'cols' => '70',
      'id' => 'Callsresultado_c',
      'custom_module' => 'Calls',
    ),
    'priority_c' => 
    array (
      'labelValue' => 'Prioridad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'priority_c',
      'vname' => 'LBL_PRIORITY',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'Medium',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'task_priority_dom',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Callspriority_c',
      'custom_module' => 'Calls',
    ),
    'tipo_de_actividad_c' => 
    array (
      'labelValue' => 'Tipo de Actividad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tipo_de_actividad_c',
      'vname' => 'LBL_TIPO_DE_ACTIVIDAD',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'Seleccione',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'tipo_de_actividad_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Callstipo_de_actividad_c',
      'custom_module' => 'Calls',
    ),
    'accion_c' => 
    array (
      'labelValue' => 'Acción',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'accion_c',
      'vname' => 'LBL_ACCION',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => 'Seleccione',
      'no_default' => false,
      'comments' => '',
      'help' => 'Selecciona QUE TIPO de actividad vas a agendar',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'accion_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Callsaccion_c',
      'custom_module' => 'Calls',
    ),
    'fh_revision_c' => 
    array (
      'labelValue' => 'FH Revisión',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fh_revision_c',
      'vname' => 'LBL_FH_REVISION',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'Callsfh_revision_c',
      'custom_module' => 'Calls',
    ),
    'actividad_realizada__c' => 
    array (
      'labelValue' => 'actividad realizada',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'actividad_realizada__c',
      'vname' => 'LBL_ACTIVIDAD_REALIZADA_',
      'type' => 'dynamicenum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Selecciona la actividad que REALIZASTE  (Indispensable para tu conteo)',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'actividad_realizada__c_list',
      'studio' => 'visible',
      'dbType' => 'enum',
      'parentenum' => '',
      'id' => 'Callsactividad_realizada__c',
      'custom_module' => 'Calls',
    ),
    'sup_supervisor_calls' => 
    array (
      'name' => 'sup_supervisor_calls',
      'type' => 'link',
      'relationship' => 'sup_supervisor_calls',
      'source' => 'non-db',
      'module' => 'SUP_iSupervisor',
      'bean_name' => false,
      'side' => 'right',
      'vname' => 'LBL_SUP_SUPERVISOR_CALLS_FROM_SUP_ISUPERVISOR_TITLE',
    ),
    'reschedule_history' => 
    array (
      'required' => false,
      'name' => 'reschedule_history',
      'vname' => 'LBL_RESCHEDULE_HISTORY',
      'type' => 'varchar',
      'source' => 'non-db',
      'studio' => 'visible',
      'massupdate' => 0,
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'function' => 
      array (
        'name' => 'reschedule_history',
        'returns' => 'html',
        'include' => 'custom/modules/Calls/reschedule_history.php',
      ),
      'merge_filter' => 'disabled',
    ),
    'reschedule_count' => 
    array (
      'required' => false,
      'name' => 'reschedule_count',
      'vname' => 'LBL_RESCHEDULE_COUNT',
      'type' => 'varchar',
      'source' => 'non-db',
      'studio' => 'visible',
      'massupdate' => 0,
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'function' => 
      array (
        'name' => 'reschedule_count',
        'returns' => 'html',
        'include' => 'custom/modules/Calls/reschedule_history.php',
      ),
      'merge_filter' => 'disabled',
    ),
    'calls_reschedule' => 
    array (
      'name' => 'calls_reschedule',
      'type' => 'link',
      'relationship' => 'calls_reschedule',
      'module' => 'Calls_Reschedule',
      'bean_name' => 'Calls_Reschedule',
      'source' => 'non-db',
    ),
    'leads_calls_1' => 
    array (
      'name' => 'leads_calls_1',
      'type' => 'link',
      'relationship' => 'leads_calls_1',
      'source' => 'non-db',
      'module' => 'Leads',
      'bean_name' => 'Lead',
      'vname' => 'LBL_LEADS_CALLS_1_FROM_LEADS_TITLE',
      'id_name' => 'leads_calls_1leads_ida',
    ),
    'leads_calls_1_name' => 
    array (
      'name' => 'leads_calls_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_LEADS_CALLS_1_FROM_LEADS_TITLE',
      'save' => true,
      'id_name' => 'leads_calls_1leads_ida',
      'link' => 'leads_calls_1',
      'table' => 'leads',
      'module' => 'Leads',
      'rname' => 'name',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
    ),
    'leads_calls_1leads_ida' => 
    array (
      'name' => 'leads_calls_1leads_ida',
      'type' => 'link',
      'relationship' => 'leads_calls_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_LEADS_CALLS_1_FROM_CALLS_TITLE',
    ),
    'clasificacion_c' => 
    array (
      'labelValue' => 'Clasific',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'clasificacion_c',
      'vname' => 'LBL_CLASIFICACION',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'Seleccione',
      'no_default' => false,
      'comments' => 'Comentario del Campo',
      'help' => 'Selecciona CON QUE? se relaciona la actividad que vas a agendar (DE MODO GENERAL)',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'clasificacion_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'Callsclasificacion_c',
      'custom_module' => 'Calls',
    ),
    'project_calls_1' => 
    array (
      'name' => 'project_calls_1',
      'type' => 'link',
      'relationship' => 'project_calls_1',
      'source' => 'non-db',
      'module' => 'Project',
      'bean_name' => 'Project',
      'vname' => 'LBL_PROJECT_CALLS_1_FROM_PROJECT_TITLE',
      'id_name' => 'project_calls_1project_ida',
    ),
    'project_calls_1_name' => 
    array (
      'name' => 'project_calls_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_PROJECT_CALLS_1_FROM_PROJECT_TITLE',
      'save' => true,
      'id_name' => 'project_calls_1project_ida',
      'link' => 'project_calls_1',
      'table' => 'project',
      'module' => 'Project',
      'rname' => 'name',
    ),
    'project_calls_1project_ida' => 
    array (
      'name' => 'project_calls_1project_ida',
      'type' => 'link',
      'relationship' => 'project_calls_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_PROJECT_CALLS_1_FROM_CALLS_TITLE',
    ),
    'calls_sup_isupervisor_1' => 
    array (
      'name' => 'calls_sup_isupervisor_1',
      'type' => 'link',
      'relationship' => 'calls_sup_isupervisor_1',
      'source' => 'non-db',
      'module' => 'SUP_iSupervisor',
      'bean_name' => 'SUP_iSupervisor',
      'side' => 'right',
      'vname' => 'LBL_CALLS_SUP_ISUPERVISOR_1_FROM_SUP_ISUPERVISOR_TITLE',
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_calls',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'validacion_supervisor_c' => 
    array (
      'labelValue' => 'Validacion Supervisor',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'validacion_supervisor_c',
      'vname' => 'LBL_VALIDACION_SUPERVISOR',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Callsvalidacion_supervisor_c',
      'custom_module' => 'Calls',
    ),
    'demostracion_c' => 
    array (
      'labelValue' => 'Demo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'demostracion_c',
      'vname' => 'LBL_DEMOSTRACION',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => 'Selecciona si realizaste  una demostracion ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Callsdemostracion_c',
      'custom_module' => 'Calls',
    ),
    'pagos_pagos_de_clientes_calls_1' => 
    array (
      'name' => 'pagos_pagos_de_clientes_calls_1',
      'type' => 'link',
      'relationship' => 'pagos_pagos_de_clientes_calls_1',
      'source' => 'non-db',
      'module' => 'Pagos_Pagos_de_Clientes',
      'bean_name' => 'Pagos_Pagos_de_Clientes',
      'vname' => 'LBL_PAGOS_PAGOS_DE_CLIENTES_CALLS_1_FROM_PAGOS_PAGOS_DE_CLIENTES_TITLE',
      'id_name' => 'pagos_pagos_de_clientes_calls_1pagos_pagos_de_clientes_ida',
    ),
    'pagos_pagos_de_clientes_calls_1_name' => 
    array (
      'name' => 'pagos_pagos_de_clientes_calls_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_PAGOS_PAGOS_DE_CLIENTES_CALLS_1_FROM_PAGOS_PAGOS_DE_CLIENTES_TITLE',
      'save' => true,
      'id_name' => 'pagos_pagos_de_clientes_calls_1pagos_pagos_de_clientes_ida',
      'link' => 'pagos_pagos_de_clientes_calls_1',
      'table' => 'pagos_pagos_de_clientes',
      'module' => 'Pagos_Pagos_de_Clientes',
      'rname' => 'name',
    ),
    'pagos_pagos_de_clientes_calls_1pagos_pagos_de_clientes_ida' => 
    array (
      'name' => 'pagos_pagos_de_clientes_calls_1pagos_pagos_de_clientes_ida',
      'type' => 'link',
      'relationship' => 'pagos_pagos_de_clientes_calls_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'left',
      'vname' => 'LBL_PAGOS_PAGOS_DE_CLIENTES_CALLS_1_FROM_PAGOS_PAGOS_DE_CLIENTES_TITLE',
    ),
    'act_mal_capt_c' => 
    array (
      'labelValue' => 'act mal capt',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'act_mal_capt_c',
      'vname' => 'LBL_ACT_MAL_CAPT',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'Callsact_mal_capt_c',
      'custom_module' => 'Calls',
    ),
    'accounts_calls_1' => 
    array (
      'name' => 'accounts_calls_1',
      'type' => 'link',
      'relationship' => 'accounts_calls_1',
      'source' => 'non-db',
      'module' => 'Accounts',
      'bean_name' => 'Account',
      'vname' => 'LBL_ACCOUNTS_CALLS_1_FROM_ACCOUNTS_TITLE',
      'id_name' => 'accounts_calls_1accounts_ida',
    ),
    'accounts_calls_1_name' => 
    array (
      'name' => 'accounts_calls_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_ACCOUNTS_CALLS_1_FROM_ACCOUNTS_TITLE',
      'save' => true,
      'id_name' => 'accounts_calls_1accounts_ida',
      'link' => 'accounts_calls_1',
      'table' => 'accounts',
      'module' => 'Accounts',
      'rname' => 'name',
    ),
    'accounts_calls_1accounts_ida' => 
    array (
      'name' => 'accounts_calls_1accounts_ida',
      'type' => 'link',
      'relationship' => 'accounts_calls_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_ACCOUNTS_CALLS_1_FROM_CALLS_TITLE',
    ),
    'revicion_c' => 
    array (
      'labelValue' => 'Revisión',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'revicion_c',
      'vname' => 'LBL_REVICION',
      'type' => 'text',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Este campo esta reservado para EL SUPERVISOR. Aqui tu supervisor, te  hara los comentarios,     sugerencias,   correcciones   o    indicaciones pertinentes,  relacionados con esta actividad ',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '6',
      'cols' => '70',
      'id' => 'Callsrevicion_c',
      'custom_module' => 'Calls',
    ),
    'opportunities_calls_1' => 
    array (
      'name' => 'opportunities_calls_1',
      'type' => 'link',
      'relationship' => 'opportunities_calls_1',
      'source' => 'non-db',
      'module' => 'Opportunities',
      'bean_name' => 'Opportunity',
      'vname' => 'LBL_OPPORTUNITIES_CALLS_1_FROM_OPPORTUNITIES_TITLE',
      'id_name' => 'opportunities_calls_1opportunities_ida',
    ),
    'opportunities_calls_1_name' => 
    array (
      'name' => 'opportunities_calls_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_OPPORTUNITIES_CALLS_1_FROM_OPPORTUNITIES_TITLE',
      'save' => true,
      'id_name' => 'opportunities_calls_1opportunities_ida',
      'link' => 'opportunities_calls_1',
      'table' => 'opportunities',
      'module' => 'Opportunities',
      'rname' => 'name',
    ),
    'opportunities_calls_1opportunities_ida' => 
    array (
      'name' => 'opportunities_calls_1opportunities_ida',
      'type' => 'link',
      'relationship' => 'opportunities_calls_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_OPPORTUNITIES_CALLS_1_FROM_CALLS_TITLE',
    ),
  ),
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'callspk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
    0 => 
    array (
      'name' => 'idx_call_name',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'name',
      ),
    ),
    1 => 
    array (
      'name' => 'idx_status',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'status',
      ),
    ),
    2 => 
    array (
      'name' => 'idx_calls_date_start',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'date_start',
      ),
    ),
    3 => 
    array (
      'name' => 'idx_calls_par_del',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'parent_id',
        1 => 'parent_type',
        2 => 'deleted',
      ),
    ),
    4 => 
    array (
      'name' => 'idx_calls_assigned_del',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'deleted',
        1 => 'assigned_user_id',
      ),
    ),
  ),
  'relationships' => 
  array (
    'calls_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Calls',
      'rhs_table' => 'calls',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'calls_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Calls',
      'rhs_table' => 'calls',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'calls_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Calls',
      'rhs_table' => 'calls',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'calls_notes' => 
    array (
      'lhs_module' => 'Calls',
      'lhs_table' => 'calls',
      'lhs_key' => 'id',
      'rhs_module' => 'Notes',
      'rhs_table' => 'notes',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Calls',
    ),
    'calls_reschedule' => 
    array (
      'lhs_module' => 'Calls',
      'lhs_table' => 'calls',
      'lhs_key' => 'id',
      'rhs_module' => 'Calls_Reschedule',
      'rhs_table' => 'calls_reschedule',
      'rhs_key' => 'call_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_locking' => true,
  'templates' => 
  array (
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);