<?php 
 $GLOBALS["dictionary"]["AOS_Quotes"]=array (
  'table' => 'aos_quotes',
  'audited' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'unified_search' => false,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'required' => true,
      'importable' => 'required',
      'duplicate_merge' => 'disabled',
      'merge_filter' => 'disabled',
      'duplicate_merge_dom_value' => '0',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'aos_quotes_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'aos_quotes_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'aos_quotes_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'approval_issue' => 
    array (
      'required' => false,
      'name' => 'approval_issue',
      'vname' => 'LBL_APPROVAL_ISSUE',
      'type' => 'text',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'studio' => 'visible',
    ),
    'billing_account_id' => 
    array (
      'required' => false,
      'name' => 'billing_account_id',
      'vname' => '',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => 0,
      'reportable' => 0,
      'len' => 36,
    ),
    'billing_account' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'billing_account',
      'vname' => 'LBL_BILLING_ACCOUNT',
      'type' => 'relate',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '255',
      'id_name' => 'billing_account_id',
      'ext2' => 'Accounts',
      'module' => 'Accounts',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'billing_contact_id' => 
    array (
      'required' => false,
      'name' => 'billing_contact_id',
      'vname' => '',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => 0,
      'reportable' => 0,
      'len' => 36,
    ),
    'billing_contact' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'billing_contact',
      'vname' => 'LBL_BILLING_CONTACT',
      'type' => 'relate',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '255',
      'id_name' => 'billing_contact_id',
      'ext2' => 'Contacts',
      'module' => 'Contacts',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'billing_address_street' => 
    array (
      'name' => 'billing_address_street',
      'vname' => 'LBL_BILLING_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => '150',
      'comment' => 'The street address used for billing address',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_city' => 
    array (
      'name' => 'billing_address_city',
      'vname' => 'LBL_BILLING_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => '100',
      'comment' => 'The city used for billing address',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_state' => 
    array (
      'name' => 'billing_address_state',
      'vname' => 'LBL_BILLING_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => '100',
      'group' => 'billing_address',
      'comment' => 'The state used for billing address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_postalcode' => 
    array (
      'name' => 'billing_address_postalcode',
      'vname' => 'LBL_BILLING_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => '20',
      'group' => 'billing_address',
      'comment' => 'The postal code used for billing address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_country' => 
    array (
      'name' => 'billing_address_country',
      'vname' => 'LBL_BILLING_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'billing_address',
      'comment' => 'The country used for the billing address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_street' => 
    array (
      'name' => 'shipping_address_street',
      'vname' => 'LBL_SHIPPING_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => 150,
      'group' => 'shipping_address',
      'comment' => 'The street address used for for shipping purposes',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_city' => 
    array (
      'name' => 'shipping_address_city',
      'vname' => 'LBL_SHIPPING_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => 100,
      'group' => 'shipping_address',
      'comment' => 'The city used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_state' => 
    array (
      'name' => 'shipping_address_state',
      'vname' => 'LBL_SHIPPING_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => 100,
      'group' => 'shipping_address',
      'comment' => 'The state used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_postalcode' => 
    array (
      'name' => 'shipping_address_postalcode',
      'vname' => 'LBL_SHIPPING_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => 20,
      'group' => 'shipping_address',
      'comment' => 'The zip code used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_country' => 
    array (
      'name' => 'shipping_address_country',
      'vname' => 'LBL_SHIPPING_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'shipping_address',
      'comment' => 'The country used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'expiration' => 
    array (
      'required' => '1',
      'name' => 'expiration',
      'vname' => 'LBL_EXPIRATION',
      'type' => 'date',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'display_default' => '+ 1 month',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'number' => 
    array (
      'required' => true,
      'name' => 'number',
      'vname' => 'LBL_QUOTE_NUMBER',
      'type' => 'int',
      'len' => 11,
      'isnull' => 'false',
      'unified_search' => true,
      'comments' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'reportable' => true,
      'disable_num_format' => true,
    ),
    'opportunity_id' => 
    array (
      'required' => false,
      'name' => 'opportunity_id',
      'vname' => '',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => 0,
      'reportable' => 0,
      'len' => 36,
    ),
    'opportunity' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'opportunity',
      'vname' => 'LBL_OPPORTUNITY',
      'type' => 'relate',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '255',
      'id_name' => 'opportunity_id',
      'ext2' => 'Opportunities',
      'module' => 'Opportunities',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'template_ddown_c' => 
    array (
      'required' => '0',
      'name' => 'template_ddown_c',
      'vname' => 'LBL_TEMPLATE_DDOWN_C',
      'type' => 'multienum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => 0,
      'reportable' => 0,
      'options' => 'template_ddown_c_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'line_items' => 
    array (
      'required' => false,
      'name' => 'line_items',
      'vname' => 'LBL_LINE_ITEMS',
      'type' => 'function',
      'source' => 'non-db',
      'massupdate' => 0,
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => false,
      'function' => 
      array (
        'name' => 'display_lines',
        'returns' => 'html',
        'include' => 'modules/AOS_Products_Quotes/Line_Items.php',
      ),
    ),
    'total_amt' => 
    array (
      'required' => false,
      'name' => 'total_amt',
      'vname' => 'LBL_TOTAL_AMT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'total_amt_usdollar' => 
    array (
      'name' => 'total_amt_usdollar',
      'vname' => 'LBL_TOTAL_AMT_USDOLLAR',
      'type' => 'currency',
      'group' => 'total_amt',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'subtotal_amount' => 
    array (
      'required' => false,
      'name' => 'subtotal_amount',
      'vname' => 'LBL_SUBTOTAL_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'subtotal_amount_usdollar' => 
    array (
      'name' => 'subtotal_amount_usdollar',
      'vname' => 'LBL_SUBTOTAL_AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'subtotal_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'discount_amount' => 
    array (
      'required' => false,
      'name' => 'discount_amount',
      'vname' => 'LBL_DISCOUNT_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'discount_amount_usdollar' => 
    array (
      'name' => 'discount_amount_usdollar',
      'vname' => 'LBL_DISCOUNT_AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'discount_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'tax_amount' => 
    array (
      'required' => false,
      'name' => 'tax_amount',
      'vname' => 'LBL_TAX_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'tax_amount_usdollar' => 
    array (
      'name' => 'tax_amount_usdollar',
      'vname' => 'LBL_TAX_AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'tax_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'shipping_amount' => 
    array (
      'required' => false,
      'name' => 'shipping_amount',
      'vname' => 'LBL_SHIPPING_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'len' => '26,6',
      'size' => '10',
      'enable_range_search' => false,
    ),
    'shipping_amount_usdollar' => 
    array (
      'name' => 'shipping_amount_usdollar',
      'vname' => 'LBL_SHIPPING_AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'shipping_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'shipping_tax' => 
    array (
      'required' => false,
      'name' => 'shipping_tax',
      'vname' => 'LBL_SHIPPING_TAX',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'len' => 100,
      'options' => 'vat_list',
      'studio' => 'visible',
    ),
    'shipping_tax_amt' => 
    array (
      'required' => false,
      'name' => 'shipping_tax_amt',
      'vname' => 'LBL_SHIPPING_TAX_AMT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'len' => '26,6',
      'size' => '10',
      'enable_range_search' => false,
      'function' => 
      array (
        'name' => 'display_shipping_vat',
        'returns' => 'html',
        'include' => 'modules/AOS_Products_Quotes/Line_Items.php',
      ),
    ),
    'shipping_tax_amt_usdollar' => 
    array (
      'name' => 'shipping_tax_amt_usdollar',
      'vname' => 'LBL_SHIPPING_TAX_AMT_USDOLLAR',
      'type' => 'currency',
      'group' => 'shipping_tax_amt',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'total_amount' => 
    array (
      'required' => false,
      'name' => 'total_amount',
      'vname' => 'LBL_GRAND_TOTAL',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '26,6',
      'enable_range_search' => true,
      'options' => 'numeric_range_search_dom',
    ),
    'total_amount_usdollar' => 
    array (
      'name' => 'total_amount_usdollar',
      'vname' => 'LBL_GRAND_TOTAL_USDOLLAR',
      'type' => 'currency',
      'group' => 'total_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'currency_id' => 
    array (
      'required' => false,
      'name' => 'currency_id',
      'vname' => 'LBL_CURRENCY',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => false,
      'len' => 36,
      'size' => '20',
      'studio' => 'visible',
      'function' => 
      array (
        'name' => 'getCurrencyDropDown',
        'returns' => 'html',
      ),
    ),
    'stage' => 
    array (
      'required' => '1',
      'name' => 'stage',
      'vname' => 'LBL_STAGE',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => 'Draft',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => 100,
      'options' => 'quote_stage_dom',
      'studio' => 'visible',
    ),
    'term' => 
    array (
      'required' => false,
      'name' => 'term',
      'vname' => 'LBL_TERM',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => 100,
      'options' => 'quote_term_dom',
      'studio' => 'visible',
    ),
    'terms_c' => 
    array (
      'required' => false,
      'name' => 'terms_c',
      'vname' => 'LBL_TERMS_C',
      'type' => 'text',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'studio' => 'visible',
    ),
    'approval_status' => 
    array (
      'required' => false,
      'name' => 'approval_status',
      'vname' => 'LBL_APPROVAL_STATUS',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => 100,
      'options' => 'approval_status_dom',
      'studio' => 'visible',
    ),
    'invoice_status' => 
    array (
      'required' => false,
      'name' => 'invoice_status',
      'vname' => 'LBL_INVOICE_STATUS',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => 'Not Invoiced',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => 100,
      'options' => 'quote_invoice_status_dom',
      'studio' => 'visible',
    ),
    'subtotal_tax_amount' => 
    array (
      'required' => false,
      'name' => 'subtotal_tax_amount',
      'vname' => 'LBL_SUBTOTAL_TAX_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'subtotal_tax_amount_usdollar' => 
    array (
      'name' => 'subtotal_tax_amount_usdollar',
      'vname' => 'LBL_SUBTOTAL_TAX_AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'subtotal_tax_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'opportunities' => 
    array (
      'name' => 'opportunities',
      'type' => 'link',
      'relationship' => 'opportunity_aos_quotes',
      'module' => 'Opportunities',
      'bean_name' => 'Opportunity',
      'source' => 'non-db',
    ),
    'aos_quotes_project' => 
    array (
      'name' => 'aos_quotes_project',
      'type' => 'link',
      'relationship' => 'aos_quotes_project',
      'source' => 'non-db',
      'module' => 'Project',
    ),
    'aos_quotes_aos_invoices' => 
    array (
      'name' => 'aos_quotes_aos_invoices',
      'type' => 'link',
      'relationship' => 'aos_quotes_aos_invoices',
      'source' => 'non-db',
      'module' => 'AOS_Invoices',
    ),
    'aos_quotes_aos_contracts' => 
    array (
      'name' => 'aos_quotes_aos_contracts',
      'type' => 'link',
      'relationship' => 'aos_quotes_aos_contracts',
      'source' => 'non-db',
      'module' => 'AOS_Contracts',
    ),
    'aos_products_quotes' => 
    array (
      'name' => 'aos_products_quotes',
      'type' => 'link',
      'relationship' => 'aos_quotes_aos_product_quotes',
      'module' => 'AOS_Products_Quotes',
      'bean_name' => 'AOS_Products_Quotes',
      'source' => 'non-db',
    ),
    'aos_line_item_groups' => 
    array (
      'name' => 'aos_line_item_groups',
      'type' => 'link',
      'relationship' => 'aos_quotes_aos_line_item_groups',
      'module' => 'AOS_Line_Item_Groups',
      'bean_name' => 'AOS_Line_Item_Groups',
      'source' => 'non-db',
    ),
    'telefono_del_contacto_c' => 
    array (
      'labelValue' => 'Telefono del Contacto',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'telefono_del_contacto_c',
      'vname' => 'LBL_TELEFONO_DEL_CONTACTO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '80',
      'size' => '20',
      'id' => 'AOS_Quotestelefono_del_contacto_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'perfil_de_asistencia_c' => 
    array (
      'labelValue' => 'Perfil de Asistencia',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'perfil_de_asistencia_c',
      'vname' => 'LBL_PERFIL_DE_ASISTENCIA',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => 1,
      'max' => false,
      'validation' => 
      array (
        'type' => 'range',
        'min' => 1,
        'max' => false,
      ),
      'id' => 'AOS_Quotesperfil_de_asistencia_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'fecha_inicio_c' => 
    array (
      'labelValue' => 'Fecha Inicio del Congreso',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_inicio_c',
      'vname' => 'LBL_FECHA_INICIO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Quotesfecha_inicio_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'km_entrada_c' => 
    array (
      'labelValue' => 'Km Entrada',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'km_entrada_c',
      'vname' => 'LBL_KM_ENTRADA',
      'type' => 'decimal',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '12',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => '2',
      'id' => 'AOS_Quoteskm_entrada_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'meta_del_evento_c' => 
    array (
      'labelValue' => 'Meta del Evento',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'meta_del_evento_c',
      'vname' => 'LBL_META_DEL_EVENTO',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Quotesmeta_del_evento_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'especialidad_del_congreso_c' => 
    array (
      'labelValue' => 'Especialidad del Congreso',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'especialidad_del_congreso_c',
      'vname' => 'LBL_ESPECIALIDAD_DEL_CONGRESO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'E_list_ESPECIALIDAD',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Quotesespecialidad_del_congreso_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'saldo_inicial_c' => 
    array (
      'labelValue' => 'Saldo Inicial',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'saldo_inicial_c',
      'vname' => 'LBL_SALDO_INICIAL',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Quotessaldo_inicial_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'se_realizo_esfuerzo_c' => 
    array (
      'labelValue' => '¿Se realizo esfuerzo pubilcitario a la BD?',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'se_realizo_esfuerzo_c',
      'vname' => 'LBL_SE_REALIZO_ESFUERZO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'si_no_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Quotesse_realizo_esfuerzo_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'num_cuenta_c' => 
    array (
      'labelValue' => 'Num Cuenta',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'num_cuenta_c',
      'vname' => 'LBL_NUM_CUENTA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Quotesnum_cuenta_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'gasto_gastos_aos_quotes' => 
    array (
      'name' => 'gasto_gastos_aos_quotes',
      'type' => 'link',
      'relationship' => 'gasto_gastos_aos_quotes',
      'source' => 'non-db',
      'module' => 'Gasto_Gastos',
      'bean_name' => 'Gasto_Gastos',
      'side' => 'right',
      'vname' => 'LBL_GASTO_GASTOS_AOS_QUOTES_FROM_GASTO_GASTOS_TITLE',
    ),
    'estado_cuenta_c' => 
    array (
      'labelValue' => 'Estado Cuenta',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'estado_cuenta_c',
      'vname' => 'LBL_ESTADO_CUENTA',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Quotesestado_cuenta_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'cantidad_que_aporta_c' => 
    array (
      'labelValue' => 'Cantidad que aporta la compañia',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cantidad_que_aporta_c',
      'vname' => 'LBL_CANTIDAD_QUE_APORTA',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Quotescantidad_que_aporta_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'fecha_de_pago_c' => 
    array (
      'labelValue' => 'Fecha de Pago',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_de_pago_c',
      'vname' => 'LBL_FECHA_DE_PAGO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Quotesfecha_de_pago_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'nombre_del_contacto_c' => 
    array (
      'labelValue' => 'Nombre del Contacto',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'nombre_del_contacto_c',
      'vname' => 'LBL_NOMBRE_DEL_CONTACTO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '150',
      'size' => '20',
      'id' => 'AOS_Quotesnombre_del_contacto_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'agente_a_quien_se_descuenta_c' => 
    array (
      'labelValue' => 'Agente a quien se Descuenta',
      'required' => false,
      'source' => 'non-db',
      'name' => 'agente_a_quien_se_descuenta_c',
      'vname' => 'LBL_AGENTE_A_QUIEN_SE_DESCUENTA',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Agente a quien se Descuenta',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'user_id_c',
      'ext2' => 'Users',
      'module' => 'Users',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'AOS_Quotesagente_a_quien_se_descuenta_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'fecha_hora_recepcion_c' => 
    array (
      'labelValue' => 'Fecha Hora Recepcion de Documentos',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_hora_recepcion_c',
      'vname' => 'LBL_FECHA_HORA_RECEPCION',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Quotesfecha_hora_recepcion_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'fecha_hora_entrega_admon_c' => 
    array (
      'labelValue' => 'Fecha y Hora de Entrega a Administración',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_hora_entrega_admon_c',
      'vname' => 'LBL_FECHA_HORA_ENTREGA_ADMON',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'AOS_Quotesfecha_hora_entrega_admon_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'email_para_envio_pago_c' => 
    array (
      'labelValue' => 'Email para Envio de Pago',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'email_para_envio_pago_c',
      'vname' => 'LBL_EMAIL_PARA_ENVIO_PAGO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '200',
      'size' => '20',
      'id' => 'AOS_Quotesemail_para_envio_pago_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'fecha_final_c' => 
    array (
      'labelValue' => 'Fecha Final del Congreso',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_final_c',
      'vname' => 'LBL_FECHA_FINAL',
      'type' => 'date',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Quotesfecha_final_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'cuota_del_evento_monto_c' => 
    array (
      'labelValue' => 'Monto Cuota del Evento',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cuota_del_evento_monto_c',
      'vname' => 'LBL_CUOTA_DEL_EVENTO_MONTO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Quotescuota_del_evento_monto_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'faltantes_c' => 
    array (
      'labelValue' => 'Faltantes',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'faltantes_c',
      'vname' => 'LBL_FALTANTES',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Quotesfaltantes_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'cuota_del_evento_c' => 
    array (
      'labelValue' => 'Cuota del Evento',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cuota_del_evento_c',
      'vname' => 'LBL_CUOTA_DEL_EVENTO',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Quotescuota_del_evento_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'km_salida_c' => 
    array (
      'labelValue' => 'km Salida',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'km_salida_c',
      'vname' => 'LBL_KM_SALIDA',
      'type' => 'decimal',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '12',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => '2',
      'id' => 'AOS_Quoteskm_salida_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'perfil_del_giro_c' => 
    array (
      'labelValue' => 'Perfil del Giro',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'perfil_del_giro_c',
      'vname' => 'LBL_PERFIL_DEL_GIRO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'AOS_Quotesperfil_del_giro_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'costo_del_stand_c' => 
    array (
      'labelValue' => 'Costo del Stand',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'costo_del_stand_c',
      'vname' => 'LBL_COSTO_DEL_STAND',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Quotescosto_del_stand_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'estado_congreso_c' => 
    array (
      'labelValue' => 'Estado Congreso',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'estado_congreso_c',
      'vname' => 'LBL_ESTADO_CONGRESO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'estado_c_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Quotesestado_congreso_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'siglas_del_congreso_c' => 
    array (
      'labelValue' => 'Siglas del Congreso',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'siglas_del_congreso_c',
      'vname' => 'LBL_SIGLAS_DEL_CONGRESO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'AOS_Quotessiglas_del_congreso_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'importe_a_descontar_c' => 
    array (
      'labelValue' => 'Importe a Descontar',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_a_descontar_c',
      'vname' => 'LBL_IMPORTE_A_DESCONTAR',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Quotesimporte_a_descontar_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'asistencia_contemplada_c' => 
    array (
      'labelValue' => 'Asistencia contemplada',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'asistencia_contemplada_c',
      'vname' => 'LBL_ASISTENCIA_CONTEMPLADA',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => 1,
      'max' => false,
      'validation' => 
      array (
        'type' => 'range',
        'min' => 1,
        'max' => false,
      ),
      'id' => 'AOS_Quotesasistencia_contemplada_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'televia_c' => 
    array (
      'labelValue' => 'Televia',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'televia_c',
      'vname' => 'LBL_TELEVIA',
      'type' => 'decimal',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '12',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => '2',
      'id' => 'AOS_Quotestelevia_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'sede_c' => 
    array (
      'labelValue' => 'Sede',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sede_c',
      'vname' => 'LBL_SEDE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '150',
      'size' => '20',
      'id' => 'AOS_Quotessede_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'tipo_de_vehiculo_c' => 
    array (
      'labelValue' => 'Tipo de Vehiculo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tipo_de_vehiculo_c',
      'vname' => 'LBL_TIPO_DE_VEHICULO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '150',
      'size' => '20',
      'id' => 'AOS_Quotestipo_de_vehiculo_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'fecha_limite_pago_c' => 
    array (
      'labelValue' => 'Fecha Limite para Pago',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_limite_pago_c',
      'vname' => 'LBL_FECHA_LIMITE_PAGO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Quotesfecha_limite_pago_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'efectivale_c' => 
    array (
      'labelValue' => 'Efectivale',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'efectivale_c',
      'vname' => 'LBL_EFECTIVALE',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Quotesefectivale_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'total_de_viaticos_c' => 
    array (
      'labelValue' => 'Total de Viáticos',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'total_de_viaticos_c',
      'vname' => 'LBL_TOTAL_DE_VIATICOS',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Quotestotal_de_viaticos_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'depositos_trabajados_c' => 
    array (
      'labelValue' => 'Depositos Trabajados',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'depositos_trabajados_c',
      'vname' => 'LBL_DEPOSITOS_TRABAJADOS',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Quotesdepositos_trabajados_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'reporte_de_gastos_c' => 
    array (
      'labelValue' => 'Reporte de Gastos',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'reporte_de_gastos_c',
      'vname' => 'LBL_REPORTE_DE_GASTOS',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Quotesreporte_de_gastos_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'aos_invoices_aos_quotes_1' => 
    array (
      'name' => 'aos_invoices_aos_quotes_1',
      'type' => 'link',
      'relationship' => 'aos_invoices_aos_quotes_1',
      'source' => 'non-db',
      'module' => 'AOS_Invoices',
      'bean_name' => 'AOS_Invoices',
      'vname' => 'LBL_AOS_INVOICES_AOS_QUOTES_1_FROM_AOS_INVOICES_TITLE',
      'id_name' => 'aos_invoices_aos_quotes_1aos_invoices_ida',
    ),
    'aos_invoices_aos_quotes_1_name' => 
    array (
      'name' => 'aos_invoices_aos_quotes_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_AOS_INVOICES_AOS_QUOTES_1_FROM_AOS_INVOICES_TITLE',
      'save' => true,
      'id_name' => 'aos_invoices_aos_quotes_1aos_invoices_ida',
      'link' => 'aos_invoices_aos_quotes_1',
      'table' => 'aos_invoices',
      'module' => 'AOS_Invoices',
      'rname' => 'name',
    ),
    'aos_invoices_aos_quotes_1aos_invoices_ida' => 
    array (
      'name' => 'aos_invoices_aos_quotes_1aos_invoices_ida',
      'type' => 'link',
      'relationship' => 'aos_invoices_aos_quotes_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'left',
      'vname' => 'LBL_AOS_INVOICES_AOS_QUOTES_1_FROM_AOS_INVOICES_TITLE',
    ),
    'estado_cuenta_final_c' => 
    array (
      'labelValue' => 'Estado Cuenta Final',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'estado_cuenta_final_c',
      'vname' => 'LBL_ESTADO_CUENTA_FINAL',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Quotesestado_cuenta_final_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'evaluacion_del_congreso_c' => 
    array (
      'labelValue' => 'Evaluacion del Congreso',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'evaluacion_del_congreso_c',
      'vname' => 'LBL_EVALUACION_DEL_CONGRESO',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'AOS_Quotesevaluacion_del_congreso_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'autoriza_c' => 
    array (
      'labelValue' => 'Autoriza',
      'required' => false,
      'source' => 'non-db',
      'name' => 'autoriza_c',
      'vname' => 'LBL_AUTORIZA',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'user_id2_c',
      'ext2' => 'Users',
      'module' => 'Users',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'AOS_Quotesautoriza_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'num_registros_generados_c' => 
    array (
      'labelValue' => 'Número de Registros Generados',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'num_registros_generados_c',
      'vname' => 'LBL_NUM_REGISTROS_GENERADOS',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Quotesnum_registros_generados_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'meta_del_evento_monto_c' => 
    array (
      'labelValue' => 'Monto Meta del Evento',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'meta_del_evento_monto_c',
      'vname' => 'LBL_META_DEL_EVENTO_MONTO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Quotesmeta_del_evento_monto_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'fecha_del_proximo_congreso_c' => 
    array (
      'labelValue' => 'Fecha del Proximo Congreso',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_del_proximo_congreso_c',
      'vname' => 'LBL_FECHA_DEL_PROXIMO_CONGRESO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Quotesfecha_del_proximo_congreso_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'cantidad_que_aporta_agente_c' => 
    array (
      'labelValue' => 'Cantidad que aporta el Agente',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cantidad_que_aporta_agente_c',
      'vname' => 'LBL_CANTIDAD_QUE_APORTA_AGENTE',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Quotescantidad_que_aporta_agente_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'coordinador_c' => 
    array (
      'labelValue' => 'Coordinador',
      'required' => false,
      'source' => 'non-db',
      'name' => 'coordinador_c',
      'vname' => 'LBL_COORDINADOR',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'user_id1_c',
      'ext2' => 'Users',
      'module' => 'Users',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'AOS_Quotescoordinador_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'saldo_final_c' => 
    array (
      'labelValue' => 'Saldo Final',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'saldo_final_c',
      'vname' => 'LBL_SALDO_FINAL',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Quotessaldo_final_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'numero_de_asistentes_c' => 
    array (
      'labelValue' => 'Numero de Asistentes',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numero_de_asistentes_c',
      'vname' => 'LBL_NUMERO_DE_ASISTENTES',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => 1,
      'max' => false,
      'validation' => 
      array (
        'type' => 'range',
        'min' => 1,
        'max' => false,
      ),
      'id' => 'AOS_Quotesnumero_de_asistentes_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'asociacion_que_organiza_c' => 
    array (
      'labelValue' => 'Asociacion que organiza el Congreso',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'asociacion_que_organiza_c',
      'vname' => 'LBL_ASOCIACION_QUE_ORGANIZA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '120',
      'size' => '20',
      'id' => 'AOS_Quotesasociacion_que_organiza_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'solicitud_de_vehiculo_c' => 
    array (
      'labelValue' => 'Solicitud de Vehiculo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'solicitud_de_vehiculo_c',
      'vname' => 'LBL_SOLICITUD_DE_VEHICULO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Quotessolicitud_de_vehiculo_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'user_id1_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'user_id1_c',
      'vname' => 'LBL_COORDINADOR_USER_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'AOS_Quotesuser_id1_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'user_id2_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'user_id2_c',
      'vname' => 'LBL_AUTORIZA_USER_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'AOS_Quotesuser_id2_c',
      'custom_module' => 'AOS_Quotes',
    ),
    'user_id_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'user_id_c',
      'vname' => 'LBL_AGENTE_A_QUIEN_SE_DESCUENTA_USER_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'AOS_Quotesuser_id_c',
      'custom_module' => 'AOS_Quotes',
    ),
  ),
  'relationships' => 
  array (
    'aos_quotes_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Quotes',
      'rhs_table' => 'aos_quotes',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'aos_quotes_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Quotes',
      'rhs_table' => 'aos_quotes',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'aos_quotes_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Quotes',
      'rhs_table' => 'aos_quotes',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'aos_quotes_aos_product_quotes' => 
    array (
      'lhs_module' => 'AOS_Quotes',
      'lhs_table' => 'aos_quotes',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Products_Quotes',
      'rhs_table' => 'aos_products_quotes',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
    ),
    'aos_quotes_aos_line_item_groups' => 
    array (
      'lhs_module' => 'AOS_Quotes',
      'lhs_table' => 'aos_quotes',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Line_Item_Groups',
      'rhs_table' => 'aos_line_item_groups',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_lock' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'aos_quotespk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);