<?php 
 $GLOBALS["dictionary"]["AOS_Invoices"]=array (
  'table' => 'aos_invoices',
  'audited' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'unified_search' => false,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'required' => false,
      'importable' => 'required',
      'duplicate_merge' => 'enabled',
      'merge_filter' => 'disabled',
      'help' => 'CAPTURA EL FOLIO DE LA ORDEN FISICA QUE LLENASTE',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'aos_invoices_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'aos_invoices_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'aos_invoices_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'billing_account_id' => 
    array (
      'required' => false,
      'name' => 'billing_account_id',
      'vname' => '',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => 0,
      'reportable' => 0,
      'len' => 36,
    ),
    'billing_account' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'billing_account',
      'vname' => 'LBL_BILLING_ACCOUNT',
      'type' => 'relate',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => 1,
      'len' => '255',
      'id_name' => 'billing_account_id',
      'ext2' => 'Accounts',
      'module' => 'Accounts',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'billing_contact_id' => 
    array (
      'required' => false,
      'name' => 'billing_contact_id',
      'vname' => '',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => 0,
      'reportable' => 0,
      'len' => 36,
    ),
    'billing_contact' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'billing_contact',
      'vname' => 'LBL_BILLING_CONTACT',
      'type' => 'relate',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => 1,
      'len' => '255',
      'id_name' => 'billing_contact_id',
      'ext2' => 'Contacts',
      'module' => 'Contacts',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'billing_address_street' => 
    array (
      'name' => 'billing_address_street',
      'vname' => 'LBL_BILLING_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => '150',
      'comment' => 'The street address used for billing address',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_city' => 
    array (
      'name' => 'billing_address_city',
      'vname' => 'LBL_BILLING_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => '100',
      'comment' => 'The city used for billing address',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_state' => 
    array (
      'name' => 'billing_address_state',
      'vname' => 'LBL_BILLING_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => '100',
      'group' => 'billing_address',
      'comment' => 'The state used for billing address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_postalcode' => 
    array (
      'name' => 'billing_address_postalcode',
      'vname' => 'LBL_BILLING_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => '20',
      'group' => 'billing_address',
      'comment' => 'The postal code used for billing address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_country' => 
    array (
      'name' => 'billing_address_country',
      'vname' => 'LBL_BILLING_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'billing_address',
      'comment' => 'The country used for the billing address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_street' => 
    array (
      'name' => 'shipping_address_street',
      'vname' => 'LBL_SHIPPING_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => 150,
      'group' => 'shipping_address',
      'comment' => 'The street address used for for shipping purposes',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_city' => 
    array (
      'name' => 'shipping_address_city',
      'vname' => 'LBL_SHIPPING_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => 100,
      'group' => 'shipping_address',
      'comment' => 'The city used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_state' => 
    array (
      'name' => 'shipping_address_state',
      'vname' => 'LBL_SHIPPING_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => 100,
      'group' => 'shipping_address',
      'comment' => 'The state used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_postalcode' => 
    array (
      'name' => 'shipping_address_postalcode',
      'vname' => 'LBL_SHIPPING_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => 20,
      'group' => 'shipping_address',
      'comment' => 'The zip code used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_country' => 
    array (
      'name' => 'shipping_address_country',
      'vname' => 'LBL_SHIPPING_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'shipping_address',
      'comment' => 'The country used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'number' => 
    array (
      'required' => true,
      'name' => 'number',
      'vname' => 'LBL_INVOICE_NUMBER',
      'type' => 'int',
      'len' => 11,
      'isnull' => 'false',
      'unified_search' => true,
      'comments' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'reportable' => true,
      'disable_num_format' => true,
    ),
    'line_items' => 
    array (
      'required' => false,
      'name' => 'line_items',
      'vname' => 'LBL_LINE_ITEMS',
      'type' => 'function',
      'source' => 'non-db',
      'massupdate' => 0,
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => false,
      'function' => 
      array (
        'name' => 'display_lines',
        'returns' => 'html',
        'include' => 'modules/AOS_Products_Quotes/Line_Items.php',
      ),
    ),
    'total_amt' => 
    array (
      'required' => false,
      'name' => 'total_amt',
      'vname' => 'LBL_TOTAL_AMT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'total_amt_usdollar' => 
    array (
      'name' => 'total_amt_usdollar',
      'vname' => 'LBL_TOTAL_AMT_USDOLLAR',
      'type' => 'currency',
      'group' => 'total_amt',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'subtotal_amount' => 
    array (
      'required' => false,
      'name' => 'subtotal_amount',
      'vname' => 'LBL_SUBTOTAL_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'subtotal_amount_usdollar' => 
    array (
      'name' => 'subtotal_amount_usdollar',
      'vname' => 'LBL_SUBTOTAL_AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'subtotal_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => 'Formatted amount of the opportunity',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'discount_amount' => 
    array (
      'required' => false,
      'name' => 'discount_amount',
      'vname' => 'LBL_DISCOUNT_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'discount_amount_usdollar' => 
    array (
      'name' => 'discount_amount_usdollar',
      'vname' => 'LBL_DISCOUNT__AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'discount_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'tax_amount' => 
    array (
      'required' => false,
      'name' => 'tax_amount',
      'vname' => 'LBL_TAX_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'tax_amount_usdollar' => 
    array (
      'name' => 'tax_amount_usdollar',
      'vname' => 'LBL_TAX_AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'tax_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'shipping_amount' => 
    array (
      'required' => false,
      'name' => 'shipping_amount',
      'vname' => 'LBL_SHIPPING_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'len' => '26,6',
    ),
    'shipping_amount_usdollar' => 
    array (
      'name' => 'shipping_amount_usdollar',
      'vname' => 'LBL_SHIPPING_AMOUNT_USDOLLAR',
      'type' => 'currency',
      'group' => 'shipping_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'shipping_tax' => 
    array (
      'required' => false,
      'name' => 'shipping_tax',
      'vname' => 'LBL_SHIPPING_TAX',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'len' => 100,
      'options' => 'vat_list',
      'studio' => 'visible',
    ),
    'shipping_tax_amt' => 
    array (
      'required' => false,
      'name' => 'shipping_tax_amt',
      'vname' => 'LBL_SHIPPING_TAX_AMT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'len' => '26,6',
      'size' => '10',
      'enable_range_search' => false,
      'function' => 
      array (
        'name' => 'display_shipping_vat',
        'returns' => 'html',
        'include' => 'modules/AOS_Products_Quotes/Line_Items.php',
      ),
    ),
    'shipping_tax_amt_usdollar' => 
    array (
      'name' => 'shipping_tax_amt_usdollar',
      'vname' => 'LBL_SHIPPING_TAX_AMT_USDOLLAR',
      'type' => 'currency',
      'group' => 'shipping_tax_amt',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'total_amount' => 
    array (
      'required' => false,
      'name' => 'total_amount',
      'vname' => 'LBL_GRAND_TOTAL',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '26,6',
      'enable_range_search' => true,
      'options' => 'numeric_range_search_dom',
      'merge_filter' => 'disabled',
    ),
    'total_amount_usdollar' => 
    array (
      'name' => 'total_amount_usdollar',
      'vname' => 'LBL_GRAND_TOTAL_USDOLLAR',
      'type' => 'currency',
      'group' => 'total_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'currency_id' => 
    array (
      'required' => false,
      'name' => 'currency_id',
      'vname' => 'LBL_CURRENCY',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => false,
      'len' => 36,
      'size' => '20',
      'studio' => 'visible',
      'function' => 
      array (
        'name' => 'getCurrencyDropDown',
        'returns' => 'html',
      ),
    ),
    'quote_number' => 
    array (
      'required' => false,
      'name' => 'quote_number',
      'vname' => 'LBL_QUOTE_NUMBER',
      'type' => 'int',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '11',
      'disable_num_format' => '',
    ),
    'quote_date' => 
    array (
      'required' => false,
      'name' => 'quote_date',
      'vname' => 'LBL_QUOTE_DATE',
      'type' => 'date',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'display_default' => 'now',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'invoice_date' => 
    array (
      'required' => false,
      'name' => 'invoice_date',
      'vname' => 'LBL_INVOICE_DATE',
      'type' => 'date',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'display_default' => 'now',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'merge_filter' => 'disabled',
    ),
    'due_date' => 
    array (
      'required' => false,
      'name' => 'due_date',
      'vname' => 'LBL_DUE_DATE',
      'type' => 'date',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'status' => 
    array (
      'required' => false,
      'name' => 'status',
      'vname' => 'LBL_STATUS',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 0,
      'reportable' => true,
      'len' => 100,
      'options' => 'invoice_status_dom',
      'studio' => 'visible',
      'merge_filter' => 'disabled',
    ),
    'template_ddown_c' => 
    array (
      'required' => '0',
      'name' => 'template_ddown_c',
      'vname' => 'LBL_TEMPLATE_DDOWN_C',
      'type' => 'multienum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => 0,
      'reportable' => 0,
      'options' => 'template_ddown_c_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'subtotal_tax_amount' => 
    array (
      'required' => false,
      'name' => 'subtotal_tax_amount',
      'vname' => 'LBL_SUBTOTAL_TAX_AMOUNT',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => 1,
      'reportable' => true,
      'len' => '26,6',
    ),
    'subtotal_tax_amount_usdollar' => 
    array (
      'name' => 'subtotal_tax_amount_usdollar',
      'vname' => 'LBL_GRAND_TOTAL_USDOLLAR',
      'type' => 'currency',
      'group' => 'subtotal_tax_amount',
      'disable_num_format' => true,
      'duplicate_merge' => '0',
      'audited' => true,
      'comment' => '',
      'studio' => 
      array (
        'editview' => false,
        'detailview' => false,
        'quickcreate' => false,
      ),
      'len' => '26,6',
    ),
    'aos_quotes_aos_invoices' => 
    array (
      'name' => 'aos_quotes_aos_invoices',
      'type' => 'link',
      'relationship' => 'aos_quotes_aos_invoices',
      'source' => 'non-db',
      'module' => 'AOS_Quotes',
    ),
    'aos_products_quotes' => 
    array (
      'name' => 'aos_products_quotes',
      'type' => 'link',
      'relationship' => 'aos_invoices_aos_product_quotes',
      'module' => 'AOS_Products_Quotes',
      'bean_name' => 'AOS_Products_Quotes',
      'source' => 'non-db',
    ),
    'aos_line_item_groups' => 
    array (
      'name' => 'aos_line_item_groups',
      'type' => 'link',
      'relationship' => 'aos_invoices_aos_line_item_groups',
      'module' => 'AOS_Line_Item_Groups',
      'bean_name' => 'AOS_Line_Item_Groups',
      'source' => 'non-db',
    ),
    'cm_entrega6_c' => 
    array (
      'labelValue' => 'Entrega6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega6_c',
      'vname' => 'LBL_CM_ENTREGA6',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega6_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega7_c' => 
    array (
      'labelValue' => 'Entrega7',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega7_c',
      'vname' => 'LBL_CM_ENTREGA7',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega7_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_iva_c' => 
    array (
      'labelValue' => 'Importe IVA',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_iva_c',
      'vname' => 'LBL_IMPORTE_IVA',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_iva_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'num_factura_global_c' => 
    array (
      'labelValue' => 'Num Factura Global',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'num_factura_global_c',
      'vname' => 'LBL_NUM_FACTURA_GLOBAL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '40',
      'size' => '20',
      'id' => 'AOS_Invoicesnum_factura_global_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_meses_estudio_c' => 
    array (
      'labelValue' => 'Meses Estudio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_meses_estudio_c',
      'vname' => 'LBL_CM_MESES_ESTUDIO',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => 0,
      'max' => 100,
      'validation' => 
      array (
        'type' => 'range',
        'min' => 0,
        'max' => 100,
      ),
      'id' => 'AOS_Invoicescm_meses_estudio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_consultorio_ant_c' => 
    array (
      'labelValue' => 'sc Consultorio Antigüedad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_consultorio_ant_c',
      'vname' => 'LBL_SC_CONSULTORIO_ANT',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_consultorio_ant_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'fecha_enganche_1_c' => 
    array (
      'labelValue' => 'Fecha Enganche 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_enganche_1_c',
      'vname' => 'LBL_FECHA_ENGANCHE_1',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesfecha_enganche_1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_anticipo_total_c' => 
    array (
      'labelValue' => 'Letra Importe Anticipo Total',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_anticipo_total_c',
      'vname' => 'LBL_IMPORTE_ANTICIPO_TOTAL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesimporte_anticipo_total_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_mensualidad_letra_c' => 
    array (
      'labelValue' => 'Importe de cada Mensualidad con Letra',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_mensualidad_letra_c',
      'vname' => 'LBL_IMPORTE_MENSUALIDAD_LETRA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesimporte_mensualidad_letra_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'compania_c' => 
    array (
      'labelValue' => 'Compañia',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'compania_c',
      'vname' => 'LBL_COMPANIA',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CON QUE COMPANIA ESTAS VENDIENDO:   EL DOCUMENTO Y LATERMINAL ES DE INTROLIGHT O DE NAYELI',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'compania_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicescompania_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_inicio_estudio_c' => 
    array (
      'labelValue' => 'Inicio del Estudio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_inicio_estudio_c',
      'vname' => 'LBL_CM_INICIO_ESTUDIO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_inicio_estudio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega10_c' => 
    array (
      'labelValue' => 'Entrega10',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega10_c',
      'vname' => 'LBL_CM_ENTREGA10',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega10_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_comentarios_c' => 
    array (
      'labelValue' => 'sc Comentarios',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_comentarios_c',
      'vname' => 'LBL_SC_COMENTARIOS',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'AOS_Invoicessc_comentarios_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_cons_celular_c' => 
    array (
      'labelValue' => 'sc Celular del Consultorio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_cons_celular_c',
      'vname' => 'LBL_SC_CONS_CELULAR',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_cons_celular_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega12_c' => 
    array (
      'labelValue' => 'Entrega12',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega12_c',
      'vname' => 'LBL_CM_ENTREGA12',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega12_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'aos_invoices_pagos_pagos_de_clientes_1' => 
    array (
      'name' => 'aos_invoices_pagos_pagos_de_clientes_1',
      'type' => 'link',
      'relationship' => 'aos_invoices_pagos_pagos_de_clientes_1',
      'source' => 'non-db',
      'module' => 'Pagos_Pagos_de_Clientes',
      'bean_name' => 'Pagos_Pagos_de_Clientes',
      'side' => 'right',
      'vname' => 'LBL_AOS_INVOICES_PAGOS_PAGOS_DE_CLIENTES_1_FROM_PAGOS_PAGOS_DE_CLIENTES_TITLE',
    ),
    'importe_del_enganche_1_c' => 
    array (
      'labelValue' => 'Enganche 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_del_enganche_1_c',
      'vname' => 'LBL_IMPORTE_DEL_ENGANCHE_1',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_del_enganche_1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r2_tel_c' => 
    array (
      'labelValue' => 'sc r2 tel',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r2_tel_c',
      'vname' => 'LBL_SC_R2_TEL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r2_tel_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'fecha_enganche_3_c' => 
    array (
      'labelValue' => 'Fecha Enganche 3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_enganche_3_c',
      'vname' => 'LBL_FECHA_ENGANCHE_3',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesfecha_enganche_3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_folio_de_consulta_buro_c' => 
    array (
      'labelValue' => 'sc Folio de Consulta de Buro de credito',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_folio_de_consulta_buro_c',
      'vname' => 'LBL_SC_FOLIO_DE_CONSULTA_BURO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'AOS_Invoicessc_folio_de_consulta_buro_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r1_direccion_c' => 
    array (
      'labelValue' => 'sc r1 Direccion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r1_direccion_c',
      'vname' => 'LBL_SC_R1_DIRECCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r1_direccion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'meses_garantia_c' => 
    array (
      'labelValue' => 'Meses de Garantia',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'meses_garantia_c',
      'vname' => 'LBL_MESES_GARANTIA',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicesmeses_garantia_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega8_c' => 
    array (
      'labelValue' => 'Entrega8',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega8_c',
      'vname' => 'LBL_CM_ENTREGA8',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega8_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_cons_tel2_c' => 
    array (
      'labelValue' => 'sc Telefono 2 Consultorio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_cons_tel2_c',
      'vname' => 'LBL_SC_CONS_TEL2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '30',
      'size' => '20',
      'id' => 'AOS_Invoicessc_cons_tel2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador2_c' => 
    array (
      'labelValue' => 'contador2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador2_c',
      'vname' => 'LBL_CONTADOR2',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '02',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contrato_c' => 
    array (
      'labelValue' => 'Contrato',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contrato_c',
      'vname' => 'LBL_CONTRATO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicescontrato_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'orden_de_c' => 
    array (
      'labelValue' => 'Orden de',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'orden_de_c',
      'vname' => 'LBL_ORDEN_DE',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => 'Para que movimiento estas generando tu orden',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Curso_list_',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicesorden_de_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_cp_c' => 
    array (
      'labelValue' => 'sc CP',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_cp_c',
      'vname' => 'LBL_SC_CP',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_cp_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_telefono1_c' => 
    array (
      'labelValue' => 'sc Telefono1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_telefono1_c',
      'vname' => 'LBL_SC_TELEFONO1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_telefono1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega4_c' => 
    array (
      'labelValue' => 'Entrega4',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega4_c',
      'vname' => 'LBL_CM_ENTREGA4',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega4_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega3_c' => 
    array (
      'labelValue' => 'Entrega3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega3_c',
      'vname' => 'LBL_CM_ENTREGA3',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador5_c' => 
    array (
      'labelValue' => 'contador5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador5_c',
      'vname' => 'LBL_CONTADOR5',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '05',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador5_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'banco_bancos_aos_invoices' => 
    array (
      'name' => 'banco_bancos_aos_invoices',
      'type' => 'link',
      'relationship' => 'banco_bancos_aos_invoices',
      'source' => 'non-db',
      'module' => 'Banco_Bancos',
      'bean_name' => false,
      'side' => 'right',
      'vname' => 'LBL_BANCO_BANCOS_AOS_INVOICES_FROM_BANCO_BANCOS_TITLE',
    ),
    'cantidad_minima_para_entrega_c' => 
    array (
      'labelValue' => 'Cantidad Minima para Entrega',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cantidad_minima_para_entrega_c',
      'vname' => 'LBL_CANTIDAD_MINIMA_PARA_ENTREGA',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicescantidad_minima_para_entrega_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_resultados_avalados_c' => 
    array (
      'labelValue' => 'Resultados avalados por',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_resultados_avalados_c',
      'vname' => 'LBL_CM_RESULTADOS_AVALADOS',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicescm_resultados_avalados_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador4_c' => 
    array (
      'labelValue' => 'contador4',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador4_c',
      'vname' => 'LBL_CONTADOR4',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '04',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador4_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_nombre_quien_recibe_c' => 
    array (
      'labelValue' => 'cm Nombre de quien recibe el equipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_nombre_quien_recibe_c',
      'vname' => 'LBL_CM_NOMBRE_QUIEN_RECIBE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicescm_nombre_quien_recibe_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador8_c' => 
    array (
      'labelValue' => 'contador8',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador8_c',
      'vname' => 'LBL_CONTADOR8',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '08',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador8_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador7_c' => 
    array (
      'labelValue' => 'contador7',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador7_c',
      'vname' => 'LBL_CONTADOR7',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '07',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador7_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'anticipo_c' => 
    array (
      'labelValue' => 'anticipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'anticipo_c',
      'vname' => 'LBL_ANTICIPO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'Captura el folio del anticipo(s) de la orden',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesanticipo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r1_celular_c' => 
    array (
      'labelValue' => 'sc r1 Celular',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r1_celular_c',
      'vname' => 'LBL_SC_R1_CELULAR',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r1_celular_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'letra_cant_minima_entrega_c' => 
    array (
      'labelValue' => 'Letra Cantidad mínima para entrega',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'letra_cant_minima_entrega_c',
      'vname' => 'LBL_LETRA_CANT_MINIMA_ENTREGA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesletra_cant_minima_entrega_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'ejecutivo_de_cobranza_c' => 
    array (
      'labelValue' => 'Ejecutivo de Cobranza',
      'required' => false,
      'source' => 'non-db',
      'name' => 'ejecutivo_de_cobranza_c',
      'vname' => 'LBL_EJECUTIVO_DE_COBRANZA',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'user_id_c',
      'ext2' => 'Users',
      'module' => 'Users',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'AOS_Invoicesejecutivo_de_cobranza_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'total_orden_c' => 
    array (
      'labelValue' => 'Total de Orden',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'total_orden_c',
      'vname' => 'LBL_TOTAL_ORDEN',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicestotal_orden_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp9_c' => 
    array (
      'labelValue' => 'vP9',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp9_c',
      'vname' => 'LBL_VP9',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp9_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'enganche_c' => 
    array (
      'labelValue' => 'Enganche',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'enganche_c',
      'vname' => 'LBL_ENGANCHE',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesenganche_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador1_c' => 
    array (
      'labelValue' => 'contador1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador1_c',
      'vname' => 'LBL_CONTADOR1',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '01',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'razon_venta_perdida_c' => 
    array (
      'labelValue' => 'Razón de Venta Perdida',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'razon_venta_perdida_c',
      'vname' => 'LBL_RAZON_VENTA_PERDIDA',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'AOS_Invoicesrazon_venta_perdida_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r1_email_c' => 
    array (
      'labelValue' => 'sc r1 Email',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r1_email_c',
      'vname' => 'LBL_SC_R1_EMAIL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r1_email_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numero_dia_mes_c' => 
    array (
      'labelValue' => 'Número de día en el mes para cobro',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numero_dia_mes_c',
      'vname' => 'LBL_NUMERO_DIA_MES',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => 1,
      'max' => 30,
      'validation' => 
      array (
        'type' => 'range',
        'min' => 1,
        'max' => 30,
      ),
      'id' => 'AOS_Invoicesnumero_dia_mes_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp2_c' => 
    array (
      'labelValue' => 'vP2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp2_c',
      'vname' => 'LBL_VP2',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp10_c' => 
    array (
      'labelValue' => 'vP10',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp10_c',
      'vname' => 'LBL_VP10',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp10_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp11_c' => 
    array (
      'labelValue' => 'vP11',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp11_c',
      'vname' => 'LBL_VP11',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp11_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_de_enganche_2_c' => 
    array (
      'labelValue' => 'Enganche 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_de_enganche_2_c',
      'vname' => 'LBL_IMPORTE_DE_ENGANCHE_2',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_de_enganche_2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r1_nombre_completo_c' => 
    array (
      'labelValue' => 'sc r1 Nombre Completo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r1_nombre_completo_c',
      'vname' => 'LBL_SC_R1_NOMBRE_COMPLETO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r1_nombre_completo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega2_c' => 
    array (
      'labelValue' => 'Entrega2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega2_c',
      'vname' => 'LBL_CM_ENTREGA2',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_gasto_administrativo_c' => 
    array (
      'labelValue' => 'Importe Gasto Administrativo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_gasto_administrativo_c',
      'vname' => 'LBL_IMPORTE_GASTO_ADMINISTRATIVO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_gasto_administrativo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cso_c' => 
    array (
      'labelValue' => 'cso',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cso_c',
      'vname' => 'LBL_CSO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicescso_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'observaciones_c' => 
    array (
      'labelValue' => 'Observaciones',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'observaciones_c',
      'vname' => 'LBL_OBSERVACIONES',
      'type' => 'text',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '3',
      'cols' => '100',
      'id' => 'AOS_Invoicesobservaciones_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cantidad_de_mensualidades_c' => 
    array (
      'labelValue' => '¿En cuantas Mensualidades desea registrar el pago total?',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'cantidad_de_mensualidades_c',
      'vname' => 'LBL_CANTIDAD_DE_MENSUALIDADES',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '10',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => 1,
      'max' => 12,
      'validation' => 
      array (
        'type' => 'range',
        'min' => 1,
        'max' => 12,
      ),
      'id' => 'AOS_Invoicescantidad_de_mensualidades_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador13_c' => 
    array (
      'labelValue' => 'contador13',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador13_c',
      'vname' => 'LBL_CONTADOR13',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '13',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador13_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_estudio_c' => 
    array (
      'labelValue' => 'Nombre del Estudio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_estudio_c',
      'vname' => 'LBL_CM_ESTUDIO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '150',
      'size' => '20',
      'id' => 'AOS_Invoicescm_estudio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega9_c' => 
    array (
      'labelValue' => 'Entrega9',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega9_c',
      'vname' => 'LBL_CM_ENTREGA9',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega9_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cantidad_con_letra_pagare_c' => 
    array (
      'labelValue' => 'Cantidad con Letra Pagare',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cantidad_con_letra_pagare_c',
      'vname' => 'LBL_CANTIDAD_CON_LETRA_PAGARE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicescantidad_con_letra_pagare_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r2_celular_c' => 
    array (
      'labelValue' => 'sc r2 celular',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r2_celular_c',
      'vname' => 'LBL_SC_R2_CELULAR',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '50',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r2_celular_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_fin_estudio_c' => 
    array (
      'labelValue' => 'Fin del Estudio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_fin_estudio_c',
      'vname' => 'LBL_CM_FIN_ESTUDIO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_fin_estudio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'requiere_factura2_c' => 
    array (
      'labelValue' => 'Requiere Factura',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'requiere_factura2_c',
      'vname' => 'LBL_REQUIERE_FACTURA2',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'si_no_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicesrequiere_factura2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp12_c' => 
    array (
      'labelValue' => 'vP12',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp12_c',
      'vname' => 'LBL_VP12',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp12_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'entregado_c' => 
    array (
      'labelValue' => 'Entregado',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'entregado_c',
      'vname' => 'LBL_ENTREGADO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'entregado_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicesentregado_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_1_c' => 
    array (
      'labelValue' => 'contador 1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_1_c',
      'vname' => 'LBL_CONTADOR_1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '01',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp1_c' => 
    array (
      'labelValue' => 'vP1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp1_c',
      'vname' => 'LBL_VP1',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'aos_invoices_aos_quotes_1' => 
    array (
      'name' => 'aos_invoices_aos_quotes_1',
      'type' => 'link',
      'relationship' => 'aos_invoices_aos_quotes_1',
      'source' => 'non-db',
      'module' => 'AOS_Quotes',
      'bean_name' => 'AOS_Quotes',
      'vname' => 'LBL_AOS_INVOICES_AOS_QUOTES_1_FROM_AOS_QUOTES_TITLE',
      'id_name' => 'aos_invoices_aos_quotes_1aos_quotes_idb',
    ),
    'aos_invoices_aos_quotes_1_name' => 
    array (
      'name' => 'aos_invoices_aos_quotes_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_AOS_INVOICES_AOS_QUOTES_1_FROM_AOS_QUOTES_TITLE',
      'save' => true,
      'id_name' => 'aos_invoices_aos_quotes_1aos_quotes_idb',
      'link' => 'aos_invoices_aos_quotes_1',
      'table' => 'aos_quotes',
      'module' => 'AOS_Quotes',
      'rname' => 'name',
    ),
    'aos_invoices_aos_quotes_1aos_quotes_idb' => 
    array (
      'name' => 'aos_invoices_aos_quotes_1aos_quotes_idb',
      'type' => 'link',
      'relationship' => 'aos_invoices_aos_quotes_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'left',
      'vname' => 'LBL_AOS_INVOICES_AOS_QUOTES_1_FROM_AOS_QUOTES_TITLE',
    ),
    'sc_consultorio_c' => 
    array (
      'labelValue' => 'sc Consultorio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_consultorio_c',
      'vname' => 'LBL_SC_CONSULTORIO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'undefined',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'consultorio_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicessc_consultorio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'congreso_text_c' => 
    array (
      'labelValue' => 'Congreso Text',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'congreso_text_c',
      'vname' => 'LBL_CONGRESO_TEXT',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicescongreso_text_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_fecha_firma_autorizacion_c' => 
    array (
      'labelValue' => 'sc Fecha de Firma de Autorizacion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_fecha_firma_autorizacion_c',
      'vname' => 'LBL_SC_FECHA_FIRMA_AUTORIZACION',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicessc_fecha_firma_autorizacion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_cons_tel1_c' => 
    array (
      'labelValue' => 'sc Telefono 1 Consultorio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_cons_tel1_c',
      'vname' => 'LBL_SC_CONS_TEL1',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicessc_cons_tel1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'tipo_de_orden_c' => 
    array (
      'labelValue' => 'Linea de Producto',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tipo_de_orden_c',
      'vname' => 'LBL_TIPO_DE_ORDEN',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'tipo_de_orden_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicestipo_de_orden_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_estado_c' => 
    array (
      'labelValue' => 'sc estado',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_estado_c',
      'vname' => 'LBL_SC_ESTADO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_estado_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_de_cada_mensualidad_c' => 
    array (
      'labelValue' => 'Importe de cada Mensualidad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_de_cada_mensualidad_c',
      'vname' => 'LBL_IMPORTE_DE_CADA_MENSUALIDAD',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_de_cada_mensualidad_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp7_c' => 
    array (
      'labelValue' => 'vP7',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp7_c',
      'vname' => 'LBL_VP7',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp7_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r1_telefono_c' => 
    array (
      'labelValue' => 'sc r1 Telefono',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r1_telefono_c',
      'vname' => 'LBL_SC_R1_TELEFONO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r1_telefono_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp3_c' => 
    array (
      'labelValue' => 'vP3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp3_c',
      'vname' => 'LBL_VP3',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_direccion_c' => 
    array (
      'labelValue' => 'sc Direccion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_direccion_c',
      'vname' => 'LBL_SC_DIRECCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '140',
      'size' => '20',
      'id' => 'AOS_Invoicessc_direccion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r2_tel_cons_c' => 
    array (
      'labelValue' => 'sc r2 Tel Cons',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r2_tel_cons_c',
      'vname' => 'LBL_SC_R2_TEL_CONS',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '30',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r2_tel_cons_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'no_guia_c' => 
    array (
      'labelValue' => 'No. Guia',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'no_guia_c',
      'vname' => 'LBL_NO_GUIA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesno_guia_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega11_c' => 
    array (
      'labelValue' => 'Entrega11',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega11_c',
      'vname' => 'LBL_CM_ENTREGA11',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega11_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador6_c' => 
    array (
      'labelValue' => 'contador6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador6_c',
      'vname' => 'LBL_CONTADOR6',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '06',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador6_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_cantidad_entregas_c' => 
    array (
      'labelValue' => 'Cantidad de Entregas',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_cantidad_entregas_c',
      'vname' => 'LBL_CM_CANTIDAD_ENTREGAS',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescm_cantidad_entregas_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_subtotal_c' => 
    array (
      'labelValue' => 'Importe Subtotal',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_subtotal_c',
      'vname' => 'LBL_IMPORTE_SUBTOTAL',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_subtotal_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_telefono2_c' => 
    array (
      'labelValue' => 'sc Telefono2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_telefono2_c',
      'vname' => 'LBL_SC_TELEFONO2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_telefono2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'fecha_de_primer_pago_c' => 
    array (
      'labelValue' => 'Fecha de Primer Pago',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_de_primer_pago_c',
      'vname' => 'LBL_FECHA_DE_PRIMER_PAGO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesfecha_de_primer_pago_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'precio_producto_c' => 
    array (
      'labelValue' => 'Precio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'precio_producto_c',
      'vname' => 'LBL_PRECIO_PRODUCTO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesprecio_producto_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'producto_c' => 
    array (
      'labelValue' => 'Producto',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'producto_c',
      'vname' => 'LBL_PRODUCTO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'Seleccione',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'producto_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicesproducto_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'tipo_factura_c' => 
    array (
      'labelValue' => 'Tipo de Factura',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'tipo_factura_c',
      'vname' => 'LBL_TIPO_FACTURA',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'tipo_factura_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicestipo_factura_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'banco_tc_cargo_c' => 
    array (
      'labelValue' => 'Banco de TC para Cargo recurrente',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'banco_tc_cargo_c',
      'vname' => 'LBL_BANCO_TC_CARGO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesbanco_tc_cargo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'codigo_seguridad_c' => 
    array (
      'labelValue' => 'Código de Seguridad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'codigo_seguridad_c',
      'vname' => 'LBL_CODIGO_SEGURIDAD',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'AOS_Invoicescodigo_seguridad_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r2_email_c' => 
    array (
      'labelValue' => 'sc r2 email',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r2_email_c',
      'vname' => 'LBL_SC_R2_EMAIL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r2_email_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'total_anticipo_c' => 
    array (
      'labelValue' => 'Total Anticipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'total_anticipo_c',
      'vname' => 'LBL_TOTAL_ANTICIPO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicestotal_anticipo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp6_c' => 
    array (
      'labelValue' => 'vP6',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp6_c',
      'vname' => 'LBL_VP6',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp6_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_fecha_c' => 
    array (
      'labelValue' => 'sc fecha',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_fecha_c',
      'vname' => 'LBL_SC_FECHA',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'display_default' => 'now',
      'id' => 'AOS_Invoicessc_fecha_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'serie_c' => 
    array (
      'labelValue' => 'Número de Serie del Equipo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'serie_c',
      'vname' => 'LBL_SERIE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'CAPTURA EL NUMERO DE SERIE DELEQUIPO DE LA SIG MANERA (AAAA-111-11A)',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesserie_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_dr_a_cargo_c' => 
    array (
      'labelValue' => 'Dr a cargo de la investigación',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_dr_a_cargo_c',
      'vname' => 'LBL_CM_DR_A_CARGO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '130',
      'size' => '20',
      'id' => 'AOS_Invoicescm_dr_a_cargo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r2_nombre_completo_c' => 
    array (
      'labelValue' => 'sc r2 Nombre Completo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r2_nombre_completo_c',
      'vname' => 'LBL_SC_R2_NOMBRE_COMPLETO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r2_nombre_completo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp5_c' => 
    array (
      'labelValue' => 'vP5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp5_c',
      'vname' => 'LBL_VP5',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp5_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_fecha_de_consulta_buro_c' => 
    array (
      'labelValue' => 'sc Fecha de consulta de Buro de Credito',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_fecha_de_consulta_buro_c',
      'vname' => 'LBL_SC_FECHA_DE_CONSULTA_BURO',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicessc_fecha_de_consulta_buro_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'estado_congreso_c' => 
    array (
      'labelValue' => 'Estado Congreso',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'estado_congreso_c',
      'vname' => 'LBL_ESTADO_CONGRESO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'estado_congreso_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicesestado_congreso_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_represennte_legal_c' => 
    array (
      'labelValue' => 'sc Para el caso de Persona Moral, nombre del Represennte Legal',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_represennte_legal_c',
      'vname' => 'LBL_SC_REPRESENNTE_LEGAL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_represennte_legal_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp8_c' => 
    array (
      'labelValue' => 'vP8',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp8_c',
      'vname' => 'LBL_VP8',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp8_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'del_cobrador_c' => 
    array (
      'labelValue' => 'Del Cobrador',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'del_cobrador_c',
      'vname' => 'LBL_DEL_COBRADOR',
      'type' => 'url',
      'massupdate' => '0',
      'default' => '{ejecutivo_de_cobranza_c}',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'dbType' => 'varchar',
      'gen' => '1',
      'link_target' => '_self',
      'id' => 'AOS_Invoicesdel_cobrador_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vp4_c' => 
    array (
      'labelValue' => 'vP4',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vp4_c',
      'vname' => 'LBL_VP4',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvp4_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_institucion_c' => 
    array (
      'labelValue' => 'Institucion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_institucion_c',
      'vname' => 'LBL_CM_INSTITUCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '120',
      'size' => '20',
      'id' => 'AOS_Invoicescm_institucion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador12_c' => 
    array (
      'labelValue' => 'contador12',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador12_c',
      'vname' => 'LBL_CONTADOR12',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '12',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador12_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'requiere_factura_c' => 
    array (
      'labelValue' => 'Requiere Factura1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'requiere_factura_c',
      'vname' => 'LBL_REQUIERE_FACTURA',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesrequiere_factura_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_cons_email_c' => 
    array (
      'labelValue' => 'sc Consultorio Email',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_cons_email_c',
      'vname' => 'LBL_SC_CONS_EMAIL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'AOS_Invoicessc_cons_email_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_ciudad_c' => 
    array (
      'labelValue' => 'sc Ciudad',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_ciudad_c',
      'vname' => 'LBL_SC_CIUDAD',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_ciudad_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'genera_registros_c' => 
    array (
      'labelValue' => 'Genera Registros de Cobranza',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'genera_registros_c',
      'vname' => 'LBL_GENERA_REGISTROS',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesgenera_registros_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador15_c' => 
    array (
      'labelValue' => 'contador15',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador15_c',
      'vname' => 'LBL_CONTADOR15',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '15',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador15_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cantidad_de_pagares_entrega_c' => 
    array (
      'labelValue' => 'Cantidad de Pagarés pagados para entrega:',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cantidad_de_pagares_entrega_c',
      'vname' => 'LBL_CANTIDAD_DE_PAGARES_ENTREGA',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescantidad_de_pagares_entrega_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_inmueble_c' => 
    array (
      'labelValue' => 'sc Inmueble',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_inmueble_c',
      'vname' => 'LBL_SC_INMUEBLE',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'undefined',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'consultorio_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicessc_inmueble_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_aprobacion_c' => 
    array (
      'labelValue' => 'sc Aprobacion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_aprobacion_c',
      'vname' => 'LBL_SC_APROBACION',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'si_no_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicessc_aprobacion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vencimiento_pagare_c' => 
    array (
      'labelValue' => 'Vencimiento Pagare',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vencimiento_pagare_c',
      'vname' => 'LBL_VENCIMIENTO_PAGARE',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesvencimiento_pagare_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_fecha_solicitud_c' => 
    array (
      'labelValue' => 'sc Fecha Solicitud',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_fecha_solicitud_c',
      'vname' => 'LBL_SC_FECHA_SOLICITUD',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicessc_fecha_solicitud_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador9_c' => 
    array (
      'labelValue' => 'contador9',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador9_c',
      'vname' => 'LBL_CONTADOR9',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '09',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador9_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r1_tel_consultorio_c' => 
    array (
      'labelValue' => 'sc r1 Tel Consultorio',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r1_tel_consultorio_c',
      'vname' => 'LBL_SC_R1_TEL_CONSULTORIO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r1_tel_consultorio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_autorizacion_para_c' => 
    array (
      'labelValue' => 'sc Autorizacion para',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_autorizacion_para_c',
      'vname' => 'LBL_SC_AUTORIZACION_PARA',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'to',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'autorizacion_para_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicessc_autorizacion_para_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cuentas_bancarias_c' => 
    array (
      'labelValue' => 'Cuentas Bancarias',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cuentas_bancarias_c',
      'vname' => 'LBL_CUENTAS_BANCARIAS',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '5',
      'cols' => '20',
      'id' => 'AOS_Invoicescuentas_bancarias_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'subtotal_partida_c' => 
    array (
      'labelValue' => 'SubTotal',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'subtotal_partida_c',
      'vname' => 'LBL_SUBTOTAL_PARTIDA',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicessubtotal_partida_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'dias_cobro_c' => 
    array (
      'labelValue' => 'Dias de Cobro',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'dias_cobro_c',
      'vname' => 'LBL_DIAS_COBRO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesdias_cobro_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_2_c' => 
    array (
      'labelValue' => 'contador 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_2_c',
      'vname' => 'LBL_CONTADOR_2',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '02',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicescontador_2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'fecha_enganche_2_c' => 
    array (
      'labelValue' => 'Fecha Enganche 2',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fecha_enganche_2_c',
      'vname' => 'LBL_FECHA_ENGANCHE_2',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicesfecha_enganche_2_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_envio_c' => 
    array (
      'labelValue' => 'Importe Envío',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_envio_c',
      'vname' => 'LBL_IMPORTE_ENVIO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_envio_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'numero_tc_cargo_c' => 
    array (
      'labelValue' => 'Numero de TC para cargo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'numero_tc_cargo_c',
      'vname' => 'LBL_NUMERO_TC_CARGO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesnumero_tc_cargo_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_celular_c' => 
    array (
      'labelValue' => 'sc Celular',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_celular_c',
      'vname' => 'LBL_SC_CELULAR',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_celular_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_num_interior_c' => 
    array (
      'labelValue' => 'sc Num Interior',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_num_interior_c',
      'vname' => 'LBL_SC_NUM_INTERIOR',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_num_interior_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_cons_direccion_c' => 
    array (
      'labelValue' => 'sc Dirección del Consultorio o donde labora',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_cons_direccion_c',
      'vname' => 'LBL_SC_CONS_DIRECCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_cons_direccion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'forma_de_pago_c' => 
    array (
      'labelValue' => 'Forma de Pago',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'forma_de_pago_c',
      'vname' => 'LBL_FORMA_DE_PAGO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'forma_de_pago_0',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicesforma_de_pago_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_del_enganche_3_c' => 
    array (
      'labelValue' => 'Enganche 3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_del_enganche_3_c',
      'vname' => 'LBL_IMPORTE_DEL_ENGANCHE_3',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_del_enganche_3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_direccion_c' => 
    array (
      'labelValue' => 'Dirección de resguardo',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_direccion_c',
      'vname' => 'LBL_CM_DIRECCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicescm_direccion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'importe_total_c' => 
    array (
      'labelValue' => 'Importe Total',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'importe_total_c',
      'vname' => 'LBL_IMPORTE_TOTAL',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesimporte_total_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'pasar_por_pago_c' => 
    array (
      'labelValue' => 'Pasar por Pago',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'pasar_por_pago_c',
      'vname' => 'LBL_PASAR_POR_PAGO',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'Seleccione',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'pasar_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicespasar_por_pago_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_entrega1_c' => 
    array (
      'labelValue' => 'Entrega1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega1_c',
      'vname' => 'LBL_CM_ENTREGA1',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega1_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'campaigns_aos_invoices_1' => 
    array (
      'name' => 'campaigns_aos_invoices_1',
      'type' => 'link',
      'relationship' => 'campaigns_aos_invoices_1',
      'source' => 'non-db',
      'module' => 'Campaigns',
      'bean_name' => 'Campaign',
      'vname' => 'LBL_CAMPAIGNS_AOS_INVOICES_1_FROM_CAMPAIGNS_TITLE',
      'id_name' => 'campaigns_aos_invoices_1campaigns_ida',
    ),
    'campaigns_aos_invoices_1_name' => 
    array (
      'name' => 'campaigns_aos_invoices_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_CAMPAIGNS_AOS_INVOICES_1_FROM_CAMPAIGNS_TITLE',
      'save' => true,
      'id_name' => 'campaigns_aos_invoices_1campaigns_ida',
      'link' => 'campaigns_aos_invoices_1',
      'table' => 'campaigns',
      'module' => 'Campaigns',
      'rname' => 'name',
    ),
    'campaigns_aos_invoices_1campaigns_ida' => 
    array (
      'name' => 'campaigns_aos_invoices_1campaigns_ida',
      'type' => 'link',
      'relationship' => 'campaigns_aos_invoices_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'left',
      'vname' => 'LBL_CAMPAIGNS_AOS_INVOICES_1_FROM_CAMPAIGNS_TITLE',
    ),
    'cm_entrega5_c' => 
    array (
      'labelValue' => 'Entrega5',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_entrega5_c',
      'vname' => 'LBL_CM_ENTREGA5',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'AOS_Invoicescm_entrega5_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'venta_perdida_c' => 
    array (
      'labelValue' => 'Venta Perdida',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'venta_perdida_c',
      'vname' => 'LBL_VENTA_PERDIDA',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'No',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'si_no_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'AOS_Invoicesventa_perdida_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cm_autoria_con_c' => 
    array (
      'labelValue' => 'Autoria compartida con',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cm_autoria_con_c',
      'vname' => 'LBL_CM_AUTORIA_CON',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicescm_autoria_con_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador_c' => 
    array (
      'labelValue' => 'contador',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador_c',
      'vname' => 'LBL_CONTADOR',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_r2_direccion_c' => 
    array (
      'labelValue' => 'sc r2 Direccion',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_r2_direccion_c',
      'vname' => 'LBL_SC_R2_DIRECCION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_r2_direccion_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'bueno_por_c' => 
    array (
      'labelValue' => 'Bueno por',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'bueno_por_c',
      'vname' => 'LBL_BUENO_POR',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesbueno_por_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_colonia_c' => 
    array (
      'labelValue' => 'sc Colonia',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_colonia_c',
      'vname' => 'LBL_SC_COLONIA',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_colonia_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador10_c' => 
    array (
      'labelValue' => 'contador10',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador10_c',
      'vname' => 'LBL_CONTADOR10',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '10',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador10_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'cuantos_c' => 
    array (
      'labelValue' => 'Cuantos',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cuantos_c',
      'vname' => 'LBL_CUANTOS',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescuantos_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_monto_credito_c' => 
    array (
      'labelValue' => 'sc Monto Credito',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_monto_credito_c',
      'vname' => 'LBL_SC_MONTO_CREDITO',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicessc_monto_credito_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador3_c' => 
    array (
      'labelValue' => 'contador3',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador3_c',
      'vname' => 'LBL_CONTADOR3',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '03',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => NULL,
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador3_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'iva_c' => 
    array (
      'labelValue' => 'IVA',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'iva_c',
      'vname' => 'LBL_IVA',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'AOS_Invoicesiva_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador11_c' => 
    array (
      'labelValue' => 'contador11',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador11_c',
      'vname' => 'LBL_CONTADOR11',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '11',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador11_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'doc_rel_c' => 
    array (
      'labelValue' => 'Doc Rel',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'doc_rel_c',
      'vname' => 'LBL_DOC_REL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesdoc_rel_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'contador14_c' => 
    array (
      'labelValue' => 'contador14',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contador14_c',
      'vname' => 'LBL_CONTADOR14',
      'type' => 'int',
      'massupdate' => '0',
      'default' => '14',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
      'id' => 'AOS_Invoicescontador14_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_numext_c' => 
    array (
      'labelValue' => 'sc NumExt',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_numext_c',
      'vname' => 'LBL_SC_NUMEXT',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_numext_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_email_c' => 
    array (
      'labelValue' => 'sc Email',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_email_c',
      'vname' => 'LBL_SC_EMAIL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_email_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'sc_lab_calle_c' => 
    array (
      'labelValue' => 'sc Lab Calle',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sc_lab_calle_c',
      'vname' => '',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicessc_lab_calle_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'user_id_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'user_id_c',
      'vname' => 'LBL_EJECUTIVO_DE_COBRANZA_USER_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'AOS_Invoicesuser_id_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vcalle_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vcalle_c',
      'vname' => 'LBL_VCALLE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesvcalle_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vespecialidad_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vespecialidad_c',
      'vname' => 'LBL_VESPECIALIDAD',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'E_list_ESPECIALIDAD',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOS_Invoicesvespecialidad_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vnombre_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vnombre_c',
      'vname' => 'LBL_VNOMBRE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'AOS_Invoicesvnombre_c',
      'custom_module' => 'AOS_Invoices',
    ),
    'vtelefono_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'vtelefono_c',
      'vname' => 'LBL_VTELEFONO',
      'type' => 'phone',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'dbType' => 'varchar',
      'id' => 'AOS_Invoicesvtelefono_c',
      'custom_module' => 'AOS_Invoices',
    ),
  ),
  'relationships' => 
  array (
    'aos_invoices_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Invoices',
      'rhs_table' => 'aos_invoices',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'aos_invoices_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Invoices',
      'rhs_table' => 'aos_invoices',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'aos_invoices_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Invoices',
      'rhs_table' => 'aos_invoices',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'aos_invoices_aos_product_quotes' => 
    array (
      'lhs_module' => 'AOS_Invoices',
      'lhs_table' => 'aos_invoices',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Products_Quotes',
      'rhs_table' => 'aos_products_quotes',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
    ),
    'aos_invoices_aos_line_item_groups' => 
    array (
      'lhs_module' => 'AOS_Invoices',
      'lhs_table' => 'aos_invoices',
      'lhs_key' => 'id',
      'rhs_module' => 'AOS_Line_Item_Groups',
      'rhs_table' => 'aos_line_item_groups',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_lock' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'aos_invoicespk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);